/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.entities;

import com.badlogic.gdx.graphics.Texture;
import com.ortisoft.ortilator.assets.Assets;

public class IntroObject {
    private Assets.ObjectTypes textureType = Assets.ObjectTypes.INTRO;
    private String textureName;
    private Texture texture;
    private float currentX;
    private float currentY;
    private boolean finishX = false;
    private boolean finishY = false;
    private float targetY;
    private float targetX;
    private boolean goingDown;
    private boolean goingRight;
    private float speedTickY;
    private float speedTickX;
    private Assets.Sounds sound;
    private boolean soundPlayed = false;

    public IntroObject(Assets.ObjectTypes textureType, String textureName, float currentX, float currentY, float targetY, float speedTickY, float targetX, float speedTickX, boolean goingDown, boolean goingRight, Assets.Sounds sound) {
        this.textureType = textureType;
        this.initialize(textureName, currentX, currentY, targetY, speedTickY, targetX, speedTickX, goingDown, goingRight, sound);
    }

    private void initialize(String textureName, float currentX, float currentY, float targetY, float speedTickY, float targetX, float speedTickX, boolean goingDown, boolean goingRight, Assets.Sounds sound) {
        this.textureName = textureName;
        this.currentX = currentX;
        this.currentY = currentY;
        this.targetY = targetY;
        this.targetX = targetX;
        this.speedTickY = speedTickY;
        this.speedTickX = speedTickX;
        this.goingDown = goingDown;
        this.goingRight = goingRight;
        this.sound = sound;
        if (targetX == currentX) {
            this.finishX = true;
        }
        if (targetY == currentY) {
            this.finishY = true;
        }
        this.loadTexture();
    }

    public IntroObject(String textureName, float currentX, float currentY, float targetY, float speedTickY, float targetX, float speedTickX, boolean goingDown, boolean goingRight, Assets.Sounds sound) {
        this.initialize(textureName, currentX, currentY, targetY, speedTickY, targetX, speedTickX, goingDown, goingRight, sound);
    }

    public void loadTexture() {
        this.texture = Assets.returnTexture(this.textureType, this.textureName);
    }

    public void update() {
        if (!this.finishY) {
            if (this.goingDown) {
                if (this.targetY < this.currentY) {
                    this.currentY -= this.speedTickY;
                    if (this.currentY <= this.targetY) {
                        this.currentY = this.targetY;
                        this.finishY = true;
                    }
                }
            } else if (this.targetY > this.currentY) {
                this.currentY += this.speedTickY;
                if (this.currentY >= this.targetY) {
                    this.currentY = this.targetY;
                    this.finishY = true;
                }
            }
        }
        if (!this.finishX) {
            if (this.goingRight) {
                if (this.targetX > this.currentX) {
                    this.currentX += this.speedTickX;
                }
                if (this.currentX >= this.targetX) {
                    this.currentX = this.targetX;
                    this.finishX = true;
                }
            } else {
                if (this.targetX < this.currentX) {
                    this.currentX -= this.speedTickX;
                }
                if (this.currentX <= this.targetX) {
                    this.currentX = this.targetX;
                    this.finishX = true;
                }
            }
        }
        if (this.sound != null && !this.soundPlayed && this.isFinish()) {
            this.soundPlayed = true;
            Assets.sound(this.sound);
        }
    }

    public Texture getTexture() {
        return this.texture;
    }

    public boolean isFinish() {
        return this.finishX && this.finishY;
    }

    public float getCurrentX() {
        return this.currentX;
    }

    public float getCurrentY() {
        return this.currentY;
    }
}

