/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.entities;

import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Vector2;
import com.ortisoft.ortilator.controllers.AbstractMapController;
import com.ortisoft.ortilator.controllers.MapController;
import com.ortisoft.ortilator.entities.blocks.ActualBlock;
import com.ortisoft.ortilator.world.World;

public abstract class AbstractActualPlaceable {
    protected int id;
    private float positionX;
    private float positionY;
    private float positionZ;
    protected float direction = 0.0f;
    private boolean visible = true;
    private float height;
    private float width;
    private Polygon rectangleHitPoint;
    private String texture;
    protected MovementType currentMovementType;
    protected MovementType latestMovementType = MovementType.NONE;
    protected float movementTime = 0.0f;
    protected boolean isMoving = false;
    protected float latestCompleteX;
    protected float latestCompleteY;
    protected int currentXToGo;
    protected boolean facingRight = true;

    public AbstractActualPlaceable(int id, float positionX, float positionY, float positionZ, float width, float height, String texture) {
        this.id = id;
        this.positionX = positionX;
        this.positionY = positionY;
        this.positionZ = positionZ;
        this.height = height;
        this.width = width;
        this.texture = texture;
        this.latestCompleteX = positionX;
        this.latestCompleteY = positionY;
        this.completeDetectors();
        this.refreshCollisionDetectors();
    }

    private void completeDetectors() {
        this.rectangleHitPoint = new Polygon(new float[]{0.0f, 0.0f, this.width, 0.0f, this.width, this.height, 0.0f, this.height});
    }

    public MovementType getCurrentMovementType() {
        return this.currentMovementType;
    }

    public int getId() {
        return this.id;
    }

    public float getPositionX() {
        return this.positionX;
    }

    public float getLatestCompleteX() {
        return this.latestCompleteX;
    }

    public float getLatestCompleteY() {
        return this.latestCompleteY;
    }

    public int getCurrentXToGo() {
        return this.currentXToGo;
    }

    public float getPositionY() {
        return this.positionY;
    }

    public float getPositionZ() {
        return this.positionZ;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public float getDirection() {
        return this.direction;
    }

    public void setDirection(float direction) {
        this.direction = direction;
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public boolean isFacingRight() {
        return this.facingRight;
    }

    public void setMoving(MovementType currentMovementType, int currentXToGo) {
        this.currentXToGo = currentXToGo;
        if (currentMovementType != null) {
            this.currentMovementType = currentMovementType;
        }
        this.startMovement();
    }

    public void setMoving(MovementType currentMovementType) {
        this.setMoving(currentMovementType, 0);
    }

    public Polygon getRectangleHitPoint() {
        return this.rectangleHitPoint;
    }

    public void move(float x, float y) {
        float newX = this.positionX + x;
        float newY = this.positionY + y;
        this.positionX = newX;
        this.positionY = newY;
        this.refreshCollisionDetectors();
    }

    private void refreshCollisionDetectors() {
        this.rectangleHitPoint.setPosition(this.positionX, this.positionY);
    }

    public void setPosition(float x, float y) {
        this.positionX = x;
        this.positionY = y;
        this.refreshCollisionDetectors();
    }

    public void refreshLatestCompletePosition() {
        this.latestCompleteX = this.positionX;
        this.latestCompleteY = this.positionY;
    }

    public void refreshLatestCompletePositionBy(int x, int y) {
        this.latestCompleteX += (float)x;
        this.latestCompleteY += (float)y;
    }

    public void setPosition(Vector2 position) {
        this.positionX = position.x;
        this.positionY = position.y;
        this.refreshCollisionDetectors();
    }

    public void setPositionOffset(Vector2 position, float x, float y) {
        this.positionX = position.x + x;
        this.positionY = position.y + y;
        this.refreshCollisionDetectors();
    }

    public float getDistanceTo(AbstractActualPlaceable placeable) {
        return (float)Math.sqrt(Math.pow(placeable.getPositionX() + placeable.width / 2.0f - (this.positionX + this.width / 2.0f), 2.0) + Math.pow(placeable.getPositionY() + placeable.getHeight() - (this.positionY + this.height / 2.0f), 2.0));
    }

    public double getRadiusAddingHalfThisSize(float x, float y) {
        return Math.sqrt(Math.pow(x - (this.positionX + this.width / 2.0f), 2.0) + Math.pow(y - (this.positionY + this.height / 2.0f), 2.0));
    }

    public float getDistanceTo(float x, float y, float objectWidth, float objectHeight) {
        return (float)Math.sqrt(Math.pow(x + objectWidth / 2.0f - (this.positionX + this.width / 2.0f), 2.0) + Math.pow(y + objectHeight - (this.positionY + this.height / 2.0f), 2.0));
    }

    public String getTexture() {
        return this.texture;
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }

    public void startMovement() {
        this.isMoving = true;
        this.movementTime = 0.0f;
        if (this.currentMovementType == MovementType.PULL) {
            if (this.currentXToGo > 0) {
                this.facingRight = false;
            } else if (this.currentXToGo < 0) {
                this.facingRight = true;
            }
        } else if (this.currentXToGo > 0) {
            this.facingRight = true;
        } else if (this.currentXToGo < 0) {
            this.facingRight = false;
        }
        if (this.currentMovementType == MovementType.PUSH || this.currentMovementType == MovementType.PULL) {
            this.checkSound(SoundType.PUSH_PULL);
        }
        this.changeAnimation();
        this.onAnimationCheck();
    }

    public boolean checkFell() {
        ActualBlock blockBelow = MapController.getActualBlocks()[(int)this.getPositionX()][(int)this.getPositionY() - 1];
        if (blockBelow == null || blockBelow.isMoving() && blockBelow.currentMovementType == MovementType.FELL) {
            this.currentMovementType = MovementType.FELL;
            this.currentXToGo = 0;
            this.startMovement();
            return true;
        }
        if (this.latestMovementType == MovementType.FELL) {
            this.checkSound(SoundType.FELL_STOP);
        }
        return false;
    }

    protected void stopMovement() {
        this.isMoving = false;
        this.currentMovementType = MovementType.NONE;
        this.changeAnimation();
        this.onAnimationCheck();
    }

    public void checkMovement() {
        if (!this.isMoving) {
            return;
        }
        this.movementTime += World.getDeltaTime();
        if (this.checkMovementTimeType()) {
            this.setPosition(this.latestCompleteX + (float)this.currentXToGo, Math.round(this.getPositionY()));
            this.setPositionCompletedValues();
            this.latestMovementType = this.currentMovementType;
            if (this.latestMovementType == MovementType.FELL && !this.checkFell()) {
                this.stopMovement();
            } else if (this.latestMovementType != MovementType.FELL) {
                this.stopMovement();
                this.checkFell();
            }
            this.latestMovementType = MovementType.NONE;
        } else {
            this.moveByMovementType();
        }
    }

    private void setPositionCompletedValues() {
        this.latestCompleteX = this.getPositionX();
        this.latestCompleteY = this.getPositionY();
    }

    public void moveObject(int xToGo, boolean jump, boolean push) {
        if (!this.isMoving) {
            this.currentMovementType = this.checkIfValidMovement(xToGo, jump, push);
            if (this.currentMovementType != MovementType.NONE) {
                this.currentXToGo = xToGo;
                this.startMovement();
            }
        }
    }

    private MovementType checkIfValidMovement(int xToGo, boolean jump, boolean push) {
        if (!jump) {
            if (push) {
                if (this.getPositionX() + (float)xToGo > 0.0f && this.getPositionX() + (float)xToGo < (float)AbstractMapController.getMAP_WIDTH() && MapController.getActualBlocks()[(int)this.getPositionX() + xToGo][(int)this.getPositionY()] != null && !MapController.getActualBlocks()[(int)this.getPositionX() + xToGo][(int)this.getPositionY()].isMoving() && MapController.getActualBlocks()[(int)this.getPositionX() + xToGo + xToGo][(int)this.getPositionY()] == null && (MapController.getActualBlocks()[(int)this.getPositionX() + xToGo][(int)this.getPositionY() + 1] == null || MapController.getActualBlocks()[(int)this.getPositionX() + xToGo][(int)this.getPositionY() + 1].isMoving())) {
                    return MovementType.PUSH;
                }
                if (this.getPositionX() + (float)xToGo > 0.0f && this.getPositionX() + (float)xToGo <= (float)AbstractMapController.getMAP_WIDTH() && MapController.getActualBlocks()[(int)this.getPositionX() - xToGo][(int)this.getPositionY()] != null && !MapController.getActualBlocks()[(int)this.getPositionX() - xToGo][(int)this.getPositionY()].isMoving() && MapController.getActualBlocks()[(int)this.getPositionX() + xToGo][(int)this.getPositionY()] == null && (MapController.getActualBlocks()[(int)this.getPositionX() - xToGo][(int)this.getPositionY() + 1] == null || MapController.getActualBlocks()[(int)this.getPositionX() - xToGo][(int)this.getPositionY() + 1].isMoving())) {
                    return MovementType.PULL;
                }
            }
            if (MapController.getActualBlocks()[(int)this.getPositionX() + xToGo][(int)this.getPositionY()] == null) {
                if (MapController.getActualBlocks()[(int)this.getPositionX() + xToGo][(int)this.getPositionY() - 1] == null) {
                    return MovementType.JUMP_DOWN;
                }
                if (MapController.getActualBlocks()[(int)this.getPositionX() + xToGo][(int)this.getPositionY() - 1] != null) {
                    return MovementType.NORMAL;
                }
            }
            if (MapController.getActualBlocks()[(int)this.getPositionX() + xToGo][(int)this.getPositionY() + 1] == null && (this.id == 1 || this.id == 2)) {
                return MovementType.JUMP_UP;
            }
        }
        if (xToGo != 0) {
            this.faceObject(xToGo);
        }
        return MovementType.NONE;
    }

    public void faceObject(int xToGo) {
        if (xToGo > 0 && !this.facingRight || xToGo < 0 && this.facingRight || xToGo > 0 && this.facingRight || xToGo < 0 && !this.facingRight) {
            if (xToGo < 0 && this.facingRight) {
                this.facingRight = false;
            } else if (xToGo > 0 && !this.facingRight) {
                this.facingRight = true;
            }
        }
    }

    protected abstract void checkSound(SoundType var1);

    protected abstract boolean checkMovementTimeType();

    protected abstract void moveByMovementType();

    protected abstract void changeAnimation();

    protected abstract void onAnimationCheck();

    public static enum MovementType {
        NORMAL,
        PUSH,
        PULL,
        JUMP_UP,
        JUMP_FOR_BLOCK,
        JUMP_DOWN,
        HIT_BLOCK,
        NONE,
        FELL;

    }

    public static enum SoundType {
        FELL_STOP,
        PUSH_PULL;

    }
}

