/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.desktop;

import com.codedisaster.steamworks.SteamFriends;
import com.codedisaster.steamworks.SteamFriendsCallback;
import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamLeaderboardEntriesHandle;
import com.codedisaster.steamworks.SteamLeaderboardEntry;
import com.codedisaster.steamworks.SteamLeaderboardHandle;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUserStats;
import com.codedisaster.steamworks.SteamUserStatsCallback;
import com.ortisoft.ortilator.controllers.menu.LeaderBoardMenuController;
import com.ortisoft.ortilator.desktop.AchievementsCache;

class SteamUtils {
    private SteamUserStats userStats;
    private SteamFriends friends;
    private AchievementsCache achievementsCache;
    private leaderboardsTypes currentLeaderboardType = null;
    private SteamLeaderboardHandle currentLeaderboard = null;
    private LeaderBoardMenuController menuController = null;
    private SteamUserStatsCallback userStatsCallback = new SteamUserStatsCallback(){

        @Override
        public void onUserStatsReceived(long gameId, SteamID steamIDUser, SteamResult result) {
            int numAchievements = SteamUtils.this.userStats.getNumAchievements();
            for (int i = 0; i < numAchievements; ++i) {
                SteamUtils.this.achievementsCache.addAchievement(SteamUtils.this.userStats.getAchievementName(i), SteamUtils.this.userStats.isAchieved(SteamUtils.this.userStats.getAchievementName(i), false));
            }
        }

        @Override
        public void onUserStatsStored(long gameId, SteamResult result) {
        }

        @Override
        public void onUserStatsUnloaded(SteamID steamIDUser) {
        }

        @Override
        public void onUserAchievementStored(long gameId, boolean isGroupAchievement, String achievementName, int curProgress, int maxProgress) {
        }

        @Override
        public void onLeaderboardFindResult(SteamLeaderboardHandle leaderboard, boolean found) {
            if (found) {
                SteamUtils.this.currentLeaderboardType = SteamUtils.this.returnType(SteamUtils.this.userStats.getLeaderboardName(leaderboard));
                SteamUtils.this.currentLeaderboard = leaderboard;
                if (SteamUtils.this.menuController != null) {
                    SteamUtils.this.menuController.clearScores();
                    if (SteamUtils.this.menuController.isAroundUser()) {
                        if (SteamUtils.this.menuController.isOnlyFriends()) {
                            SteamUtils.this.userStats.downloadLeaderboardEntries(leaderboard, SteamUserStats.LeaderboardDataRequest.Friends, 1, 7);
                        } else {
                            SteamUtils.this.userStats.downloadLeaderboardEntries(leaderboard, SteamUserStats.LeaderboardDataRequest.GlobalAroundUser, -3, 3);
                        }
                    } else {
                        SteamUtils.this.userStats.downloadLeaderboardEntries(leaderboard, SteamUserStats.LeaderboardDataRequest.Global, 1, 7);
                    }
                }
            } else {
                SteamUtils.this.currentLeaderboardType = null;
                SteamUtils.this.currentLeaderboard = null;
            }
        }

        @Override
        public void onLeaderboardScoresDownloaded(SteamLeaderboardHandle leaderboard, SteamLeaderboardEntriesHandle entries, int numEntries) {
            System.out.println("Leaderboard scores downloaded: handle=" + leaderboard.toString() + ", entries=" + entries.toString() + ", count=" + numEntries);
            int[] details = new int[16];
            for (int i = 0; i < numEntries; ++i) {
                SteamLeaderboardEntry entry = new SteamLeaderboardEntry();
                if (!SteamUtils.this.userStats.getDownloadedLeaderboardEntry(entries, i, entry, details)) continue;
                int numDetails = entry.getNumDetails();
                int charId = 0;
                int gadgetId = 0;
                for (int detail = 0; detail < numDetails; ++detail) {
                    if (detail == 0) {
                        charId = details[detail];
                        continue;
                    }
                    if (detail != 1) continue;
                    gadgetId = details[detail];
                }
                SteamUtils.this.menuController.addResultData(SteamUtils.this.friends.getFriendPersonaName(entry.getSteamIDUser()), entry.getGlobalRank(), entry.getScore(), charId, gadgetId);
            }
        }

        @Override
        public void onLeaderboardScoreUploaded(boolean success, SteamLeaderboardHandle leaderboard, int score, boolean scoreChanged, int globalRankNew, int globalRankPrevious) {
        }

        @Override
        public void onGlobalStatsReceived(long gameId, SteamResult result) {
        }
    };
    private SteamFriendsCallback friendsCallback = new SteamFriendsCallback(){

        @Override
        public void onSetPersonaNameResponse(boolean success, boolean localSuccess, SteamResult result) {
        }

        @Override
        public void onPersonaStateChange(SteamID steamID, SteamFriends.PersonaChange change) {
        }

        @Override
        public void onGameOverlayActivated(boolean active) {
        }

        @Override
        public void onGameLobbyJoinRequested(SteamID steamIDLobby, SteamID steamIDFriend) {
        }

        @Override
        public void onAvatarImageLoaded(SteamID steamID, int image, int width, int height) {
        }

        @Override
        public void onFriendRichPresenceUpdate(SteamID steamIDFriend, int appID) {
        }

        @Override
        public void onGameRichPresenceJoinRequested(SteamID steamIDFriend, String connect) {
        }
    };

    public SteamUtils() {
        this.userStats = new SteamUserStats(this.userStatsCallback);
        this.friends = new SteamFriends(this.friendsCallback);
        this.achievementsCache = new AchievementsCache();
        this.userStats.requestCurrentStats();
    }

    void unlockAchievement(String achievementId) {
        if (!this.achievementsCache.checkAchievement(achievementId)) {
            this.userStats.setAchievement(achievementId);
            this.achievementsCache.setThereAreChanges();
        }
    }

    void saveAchievements(boolean firstRun) {
        if (this.achievementsCache.isThereAreChanges() || firstRun) {
            this.userStats.storeStats();
            this.achievementsCache.resetChanges();
        }
    }

    public leaderboardsTypes returnType(String name) {
        switch (name) {
            case "Classic Escape": {
                return leaderboardsTypes.CLASSIC_ESCAPE;
            }
            case "Classic Infinite": {
                return leaderboardsTypes.CLASSIC_INFINITE;
            }
            case "Extended Escape": {
                return leaderboardsTypes.EXTENDED_ESCAPE;
            }
            case "Extended Infinite": {
                return leaderboardsTypes.EXTENDED_INFINITE;
            }
        }
        return null;
    }

    public void loadLeaderBoard(leaderboardsTypes type, LeaderBoardMenuController menuController) {
        switch (type) {
            case CLASSIC_ESCAPE: {
                this.userStats.findLeaderboard("Classic Escape");
                break;
            }
            case CLASSIC_INFINITE: {
                this.userStats.findLeaderboard("Classic Infinite");
                break;
            }
            case EXTENDED_ESCAPE: {
                this.userStats.findLeaderboard("Extended Escape");
                break;
            }
            case EXTENDED_INFINITE: {
                this.userStats.findLeaderboard("Extended Infinite");
            }
        }
        this.menuController = menuController;
    }

    public void updateScore(leaderboardsTypes type, int score, int charId, int gadgetId) {
        if (this.currentLeaderboardType != null && this.currentLeaderboardType == type) {
            this.userStats.uploadLeaderboardScore(this.currentLeaderboard, SteamUserStats.LeaderboardUploadScoreMethod.KeepBest, score, new int[]{charId, gadgetId});
        }
    }

    public static enum leaderboardsTypes {
        CLASSIC_ESCAPE,
        CLASSIC_INFINITE,
        EXTENDED_ESCAPE,
        EXTENDED_INFINITE;

    }
}

