/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.desktop;

import com.codedisaster.steamworks.SteamAPI;
import com.codedisaster.steamworks.SteamApps;
import com.codedisaster.steamworks.SteamException;
import com.ortisoft.ortilator.IApplication;
import com.ortisoft.ortilator.controllers.menu.LeaderBoardMenuController;
import com.ortisoft.ortilator.desktop.SteamUtils;

public class SteamAPIController
implements IApplication {
    private boolean requestLeaderBoards;
    private static SteamUtils steamUtils;
    private boolean isSteamInit = false;
    String languageSteam;

    public SteamAPIController() {
        this.initializeSteam();
        this.languageSteam = SteamAPIController.getSteamLanguage();
    }

    public void initializeSteam() {
        try {
            if (SteamAPI.init()) {
                steamUtils = new SteamUtils();
                this.isSteamInit = true;
            }
        }
        catch (SteamException e) {
            e.printStackTrace();
        }
    }

    public static String getSteamLanguage() {
        if (SteamAPI.isSteamRunning()) {
            return new SteamApps().getCurrentGameLanguage();
        }
        return "en";
    }

    @Override
    public void closeApplication() {
        if (this.isSteamInit) {
            SteamAPI.shutdown();
        }
    }

    @Override
    public void showLeaderBoards(String idLeaderBoard) {
        this.requestLeaderBoards = true;
    }

    @Override
    public boolean waitingForResponse() {
        return this.requestLeaderBoards;
    }

    @Override
    public void unlockAchievement(String achievementId) {
        if (this.isSteamInit) {
            steamUtils.unlockAchievement(achievementId);
        }
    }

    @Override
    public void storeAchievements(boolean firstRun) {
        if (this.isSteamInit) {
            steamUtils.saveAchievements(firstRun);
        }
    }

    @Override
    public void updateScore(String name, int score, int charId, int idGadget) {
        if (this.isSteamInit) {
            steamUtils.updateScore(steamUtils.returnType(name), score, charId, idGadget);
        }
    }

    @Override
    public void updateSteam() {
        if (this.isSteamInit) {
            SteamAPI.runCallbacks();
        }
    }

    @Override
    public String getLanguage() {
        if (this.isSteamInit) {
            return this.languageSteam;
        }
        return "en";
    }

    @Override
    public void loadLeaderBoard(String name, LeaderBoardMenuController menuController) {
        if (this.isSteamInit) {
            steamUtils.loadLeaderBoard(steamUtils.returnType(name), menuController);
        }
    }
}

