/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers.menu;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.assets.ISDLocale;
import com.ortisoft.ortilator.controllers.AbstractCameraController;
import com.ortisoft.ortilator.controllers.AbstractMapController;
import com.ortisoft.ortilator.controllers.MenuController;
import com.ortisoft.ortilator.entities.ICharacter;
import com.ortisoft.ortilator.entities.IGadget;
import com.ortisoft.ortilator.entities.IObjectModifiers;
import com.ortisoft.ortilator.entities.gadgets.ExplodingBlock;
import com.ortisoft.ortilator.world.World;
import com.ortisoft.ortilator.world.loaders.BlockLoader;
import com.ortisoft.ortilator.world.loaders.CharacterLoader;
import com.ortisoft.ortilator.world.loaders.GadgetLoader;
import com.ortisoft.ortilator.world.loaders.ObjectModifiersLoader;
import java.util.HashMap;
import java.util.Map;

public class NewGameMenuController
extends MenuController {
    private boolean finish = false;
    private HashMap<Object, Rectangle> menus;
    private HashMap<Type, Rectangle> menusType;
    private HashMap<Difficulty, Rectangle> menusDifficulty;
    private HashMap<IGadget, Rectangle> menusSelectGadget;
    private HashMap<IObjectModifiers, Rectangle> menusSelectBonus;
    private HashMap<ICharacter, Rectangle> menuSelectChars;
    private HashMap<InsideMenu, Rectangle> menusSelect;
    private String controllerName = "";
    private String controllerName2 = "";
    private HashMap<TypeController, Rectangle> menusTypeController;
    private Action selectedAction;
    private Type selectedType;
    private Mode selectedMode;
    private Difficulty selectedDifficulty;
    private IGadget selectedGadget;
    private IObjectModifiers selectedObjectModifier;
    private ICharacter selectedCharacter;
    private ICharacter selectedCharacter2;
    private IGadget selectedGadget2;
    private ICharacter selectingCharacter1;
    private IGadget selectingGadget1;
    private ICharacter selectingCharacter2;
    private IGadget selectingGadget2;
    private final int OFFSET_WIDTH_SELECTION = 350;
    private final int OFFSET_HEIGHT_SELECTION = 275;
    private final int MAX_COLS = 3;
    TextureRegion currentFrame;
    private InsideMenu currentInsideMenu;
    private float startingHeight;
    private float startingWidth;

    public ICharacter getSelectedCharacter2() {
        return this.selectedCharacter2;
    }

    public IGadget getSelectedGadget2() {
        return this.selectedGadget2;
    }

    public Action getSelectedAction() {
        return this.selectedAction;
    }

    public boolean isFinish() {
        return this.finish;
    }

    public Mode getSelectedMode() {
        return this.selectedMode;
    }

    public Type getSelectedType() {
        return this.selectedType;
    }

    public InsideMenu getCurrentInsideMenu() {
        return this.currentInsideMenu;
    }

    public IGadget getSelectedGadget() {
        return this.selectedGadget;
    }

    public IObjectModifiers getSelectedObjectModifier() {
        return this.selectedObjectModifier;
    }

    public ICharacter getSelectedCharacter() {
        return this.selectedCharacter;
    }

    public void setControllerPlayer1(String controllerPlayer1) {
        this.controllerName = controllerPlayer1;
    }

    public void setControllerPlayer2(String controllerPlayer2) {
        this.controllerName2 = controllerPlayer2;
    }

    public NewGameMenuController(AbstractCameraController camera, IGadget selectedGadget, IObjectModifiers selectedObjectModifier, ICharacter selectedCharacter) {
        super(camera);
        this.selectedGadget = selectedGadget;
        this.selectedObjectModifier = selectedObjectModifier;
        this.selectedCharacter = selectedCharacter;
    }

    @Override
    protected void loadRectangles() {
        this.finish = false;
        this.isClosed = false;
        if (this.currentInsideMenu == null) {
            this.currentInsideMenu = InsideMenu.SELECTION_TYPE;
        }
        if (this.currentInsideMenu != InsideMenu.SELECTION_MODE) {
            this.actualNavigationLine = 1;
            this.actualNavigationColumn = 0;
        }
        if (this.selectedMode == null) {
            this.selectedMode = Mode.INFINITE;
        }
        if (this.selectedDifficulty == null) {
            this.selectedDifficulty = Difficulty.NORMAL;
        }
        switch (this.currentInsideMenu) {
            case SELECTION_TYPE: {
                this.menusType = new HashMap();
                this.selectedType = null;
                this.startingHeight = AbstractMapController.getHEIGHT() - 385;
                this.startingWidth = 200.0f;
                this.menusType.put(Type.EXTENDED, new Rectangle(this.startingWidth - 25.0f, this.startingHeight + 150.0f, 300.0f, 100.0f));
                this.menusType.put(Type.NORMAL, new Rectangle(this.startingWidth + 300.0f + 25.0f, this.startingHeight + 150.0f, 300.0f, 100.0f));
                this.menusType.put(Type.TWO_PLAYERS, new Rectangle(this.startingWidth + 600.0f + 75.0f, this.startingHeight + 150.0f, 300.0f, 100.0f));
                this.menusType.put(Type.DESC_NOSELECT, new Rectangle(this.startingWidth, 50.0f, 950.0f, 400.0f));
                this.navigationMenus = new Object[3][2];
                this.navigationMenus[0][1] = Type.EXTENDED;
                this.navigationMenus[1][1] = Type.NORMAL;
                this.navigationMenus[2][1] = Type.TWO_PLAYERS;
                this.navigationMenus[2][0] = InsideMenu.BACK;
                break;
            }
            case SELECTION_MODE: {
                if (this.selectedType != Type.TWO_PLAYERS) {
                    this.menus = new HashMap();
                    this.menusSelect = new HashMap();
                    if (this.selectedCharacter == null) {
                        this.selectedCharacter = CharacterLoader.allCharacters.get(1);
                    }
                    this.menus.put((Object)Mode.INFINITE, new Rectangle(this.startingWidth + 300.0f + 25.0f, this.startingHeight - 225.0f, 300.0f, 100.0f));
                    this.menus.put((Object)Action.START, new Rectangle(this.startingWidth + 600.0f + 75.0f, this.startingHeight - 225.0f, 300.0f, 100.0f));
                    this.menusSelect.put(InsideMenu.SELECTION_PLAYER, new Rectangle(this.startingWidth - 25.0f, this.startingHeight + 50.0f, 300.0f, 100.0f));
                    if (this.getSelectedType() == Type.EXTENDED) {
                        this.menusSelect.put(InsideMenu.SELECTION_GADGET, new Rectangle(this.startingWidth + 300.0f + 25.0f, this.startingHeight + 50.0f, 300.0f, 100.0f));
                        this.menusSelect.put(InsideMenu.SELECTION_BONUS, new Rectangle(this.startingWidth + 600.0f + 75.0f, this.startingHeight + 50.0f, 300.0f, 100.0f));
                    }
                    this.menusDifficulty = new HashMap();
                    this.menusDifficulty.put(Difficulty.NORMAL, new Rectangle(this.startingWidth - 25.0f, this.startingHeight - 225.0f, 300.0f, 100.0f));
                    this.navigationMenus = new Object[3][3];
                    if (this.getSelectedType() == Type.EXTENDED) {
                        this.navigationMenus[2][0] = InsideMenu.BACK;
                    } else {
                        this.navigationMenus[1][1] = InsideMenu.BACK;
                    }
                    this.navigationMenus[0][1] = InsideMenu.SELECTION_PLAYER;
                    if (this.getSelectedType() == Type.EXTENDED) {
                        this.navigationMenus[1][1] = InsideMenu.SELECTION_GADGET;
                        this.navigationMenus[2][1] = InsideMenu.SELECTION_BONUS;
                    }
                    this.navigationMenus[0][2] = Difficulty.NORMAL;
                    this.navigationMenus[1][2] = Mode.INFINITE;
                    this.navigationMenus[2][2] = Action.START;
                    break;
                }
                this.menusTypeController = new HashMap();
                this.menusSelect = new HashMap();
                this.selectedGadget = null;
                this.selectedCharacter = null;
                this.selectedGadget2 = null;
                this.selectedCharacter2 = null;
                this.selectingCharacter1 = CharacterLoader.allCharacters.get(1);
                this.selectingCharacter2 = CharacterLoader.allCharacters.get(2);
                this.selectingGadget1 = GadgetLoader.allGadgets.get(1);
                this.selectingGadget2 = GadgetLoader.allGadgets.get(1);
                this.menusTypeController.put(TypeController.NOT_SELECTED_KEYBOARD_GAMEPAD, new Rectangle(this.startingWidth + 125.0f, this.startingHeight + 160.0f, 150.0f, 100.0f));
                this.menusTypeController.put(TypeController.NOT_SELECTED_GAMEPAD, new Rectangle(this.startingWidth + 675.0f, this.startingHeight + 160.0f, 150.0f, 100.0f));
                this.menusSelect.put(InsideMenu.SELECTION_PLAYER, new Rectangle(this.startingWidth + 50.0f, this.startingHeight - 50.0f, 300.0f, 100.0f));
                this.menusSelect.put(InsideMenu.SELECTION_PLAYER2, new Rectangle(this.startingWidth + 600.0f, this.startingHeight - 50.0f, 300.0f, 100.0f));
                this.menusSelect.put(InsideMenu.SELECTION_GADGET, new Rectangle(this.startingWidth + 50.0f, this.startingHeight - 275.0f, 300.0f, 100.0f));
                this.menusSelect.put(InsideMenu.SELECTION_GADGET2, new Rectangle(this.startingWidth + 600.0f, this.startingHeight - 275.0f, 300.0f, 100.0f));
                this.navigationMenus = new Object[3][2];
                this.navigationMenus[0][0] = TypeController.NOT_SELECTED_KEYBOARD_GAMEPAD;
                this.navigationMenus[1][0] = InsideMenu.SELECTION_PLAYER;
                this.navigationMenus[2][0] = InsideMenu.SELECTION_GADGET;
                this.navigationMenus[0][1] = TypeController.NOT_SELECTED_GAMEPAD;
                this.navigationMenus[1][1] = InsideMenu.SELECTION_PLAYER2;
                this.navigationMenus[2][1] = InsideMenu.SELECTION_GADGET2;
                break;
            }
            case SELECTION_GADGET: {
                int col = 0;
                int line = 0;
                this.navigationMenus = new Object[3][3];
                this.navigationMenus[2][0] = InsideMenu.BACK;
                this.menusSelectGadget = new HashMap();
                for (IGadget gadget : GadgetLoader.allGadgets.values()) {
                    this.menusSelectGadget.put(gadget, new Rectangle(this.startingWidth - 25.0f + (float)(col * 350), this.startingHeight + 50.0f - (float)(line * 275), 300.0f, 100.0f));
                    this.navigationMenus[col][line + 1] = gadget;
                    if (++col != 3) continue;
                    col = 0;
                    ++line;
                }
                break;
            }
            case SELECTION_BONUS: {
                int colb = 0;
                int lineb = 0;
                this.navigationMenus = new Object[3][2];
                this.navigationMenus[2][0] = InsideMenu.BACK;
                this.menusSelectBonus = new HashMap();
                for (IObjectModifiers objectModifier : ObjectModifiersLoader.allObjectModifiers.values()) {
                    this.menusSelectBonus.put(objectModifier, new Rectangle(this.startingWidth - 25.0f + (float)(colb * 350), this.startingHeight + 50.0f - (float)(lineb * 275), 300.0f, 100.0f));
                    this.navigationMenus[colb][lineb + 1] = objectModifier;
                    if (++colb != 3) continue;
                    colb = 0;
                    ++lineb;
                }
                break;
            }
            case SELECTION_PLAYER: {
                int colc = 0;
                int linec = 0;
                this.navigationMenus = new Object[3][3];
                this.navigationMenus[2][0] = InsideMenu.BACK;
                this.menuSelectChars = new HashMap();
                for (ICharacter character : CharacterLoader.allCharacters.values()) {
                    this.menuSelectChars.put(character, new Rectangle(this.startingWidth - 25.0f + (float)(colc * 350), this.startingHeight + 50.0f - (float)(linec * 275), 300.0f, 100.0f));
                    this.navigationMenus[colc][linec + 1] = character;
                    if (++colc != 3) continue;
                    colc = 0;
                    ++linec;
                }
                break;
            }
        }
        this.backButton = new Rectangle(AbstractMapController.getWIDTH() - 185, AbstractCameraController.getHEIGHT() - 125, 80.0f, 80.0f);
    }

    @Override
    public void updateMouseHover(Vector3 mouseCords) {
        if (this.currentInsideMenu == InsideMenu.SELECTION_TYPE) {
            for (Map.Entry<Type, Rectangle> entry : this.menusType.entrySet()) {
                if (!entry.getValue().contains(mouseCords.x, mouseCords.y)) continue;
                super.updateSelectedMenu((Object)entry.getKey());
            }
        } else if (this.currentInsideMenu == InsideMenu.SELECTION_MODE) {
            if (this.selectedType != Type.TWO_PLAYERS) {
                for (Map.Entry<InsideMenu, Rectangle> entry : this.menusSelect.entrySet()) {
                    if (!entry.getValue().contains(mouseCords.x, mouseCords.y)) continue;
                    super.updateSelectedMenu((Object)entry.getKey());
                }
                for (Map.Entry<Object, Rectangle> entry : this.menus.entrySet()) {
                    if (!entry.getValue().contains(mouseCords.x, mouseCords.y)) continue;
                    super.updateSelectedMenu(entry.getKey());
                }
                for (Map.Entry<Object, Rectangle> entry : this.menusDifficulty.entrySet()) {
                    if (!entry.getValue().contains(mouseCords.x, mouseCords.y)) continue;
                    super.updateSelectedMenu(entry.getKey());
                }
            }
        } else if (this.currentInsideMenu == InsideMenu.SELECTION_GADGET) {
            for (Map.Entry<IGadget, Rectangle> entry : this.menusSelectGadget.entrySet()) {
                if (!entry.getValue().contains(mouseCords.x, mouseCords.y)) continue;
                super.updateSelectedMenu(entry.getKey());
            }
        } else if (this.currentInsideMenu == InsideMenu.SELECTION_BONUS) {
            for (Map.Entry<IObjectModifiers, Rectangle> entry : this.menusSelectBonus.entrySet()) {
                if (!entry.getValue().contains(mouseCords.x, mouseCords.y)) continue;
                super.updateSelectedMenu(entry.getKey());
            }
        } else if (this.currentInsideMenu == InsideMenu.SELECTION_PLAYER) {
            for (Map.Entry<ICharacter, Rectangle> entry : this.menuSelectChars.entrySet()) {
                if (!entry.getValue().contains(mouseCords.x, mouseCords.y)) continue;
                super.updateSelectedMenu(entry.getKey());
            }
        }
        if (this.backButton.contains(mouseCords.x, mouseCords.y)) {
            super.updateSelectedMenu((Object)InsideMenu.BACK);
        }
    }

    @Override
    public void drawMenuGui() {
        this.startBatch(this.guiBatch, this.camera.getGuiCam());
        this.drawBackground();
        this.draw();
        this.endBatch(this.guiBatch);
    }

    private void drawBackground() {
        this.drawToGui(Assets.getCurrentBG(), 0.0f, 0.0f, 1280.0f, 720.0f);
    }

    @Override
    protected void draw() {
        Assets.fontArialWhiteBig.getData().setScale(0.6f);
        Assets.fontArialWhite.getData().setScale(0.6f);
        if (this.currentInsideMenu == InsideMenu.SELECTION_TYPE) {
            this.drawSelectType();
        } else if (this.currentInsideMenu == InsideMenu.SELECTION_MODE) {
            if (this.selectedType != Type.TWO_PLAYERS) {
                this.drawSelectMode();
            } else {
                this.drawSelectMode2Players();
            }
        } else if (this.currentInsideMenu == InsideMenu.SELECTION_GADGET) {
            this.drawSelectGadget();
        } else if (this.currentInsideMenu == InsideMenu.SELECTION_BONUS) {
            this.drawSelectBonus();
        } else if (this.currentInsideMenu == InsideMenu.SELECTION_PLAYER) {
            this.drawSelectPlayer();
        }
        if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == InsideMenu.BACK) {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonShortBigSelMenu"), this.backButton.getX(), this.backButton.getY(), this.backButton.getWidth(), this.backButton.getHeight());
        } else {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonShortBig"), this.backButton.getX(), this.backButton.getY(), this.backButton.getWidth(), this.backButton.getHeight());
        }
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "return"), this.backButton.getX() + 8.0f, this.backButton.getY() + 8.0f, 64.0f, 64.0f);
        Assets.fontArialWhiteBig.getData().setScale(1.0f);
        Assets.fontArialWhite.getData().setScale(1.0f);
    }

    private void drawSelectMode2Players() {
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/WindowHTransparent"), this.startingWidth - 50.0f, 25.0f, 1050.0f, 675.0f);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), this.startingWidth + 250.0f, AbstractMapController.getHEIGHT() - 115, 450.0f, 75.0f);
        this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.Options"), this.startingWidth + 275.0f, AbstractMapController.getHEIGHT() - 65, 400.0f, 1, true);
        for (Map.Entry<TypeController, Rectangle> entry : this.menusTypeController.entrySet()) {
            String menuSel = entry.getKey() == TypeController.NOT_SELECTED_KEYBOARD_GAMEPAD ? (this.controllerName.equals("") ? "notSelectedKeyboardGamepad" : (this.controllerName.equals("keyboard") ? "selectedKeyBoard" : "selectedGamepad")) : (this.controllerName2.equals("") ? "notSelectedGamepad" : "selectedGamepad");
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "TwoPlayers/" + menuSel), entry.getValue().getX(), entry.getValue().getY(), entry.getValue().getWidth(), entry.getValue().getHeight());
        }
        block11: for (Map.Entry<Enum, Rectangle> entry : this.menusSelect.entrySet()) {
            switch ((InsideMenu)entry.getKey()) {
                case SELECTION_PLAYER: {
                    if (!this.controllerName.equals("")) break;
                    continue block11;
                }
                case SELECTION_PLAYER2: {
                    if (!this.controllerName2.equals("")) break;
                    continue block11;
                }
                case SELECTION_GADGET: {
                    if (this.selectedCharacter != null) break;
                    continue block11;
                }
                case SELECTION_GADGET2: {
                    if (this.selectedCharacter2 != null) break;
                    continue block11;
                }
            }
            this.drawSelector2Players((InsideMenu)entry.getKey());
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "TwoPlayers/selDer"), entry.getValue().getX() + entry.getValue().getWidth() + 10.0f, entry.getValue().getY() + 26.0f, 32.0f, 64.0f);
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "TwoPlayers/selIzq"), entry.getValue().getX() - 42.0f, entry.getValue().getY() + 26.0f, 32.0f, 64.0f);
            switch ((InsideMenu)entry.getKey()) {
                case SELECTION_GADGET: {
                    if (this.selectedGadget == null) break;
                    this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("TwoPlayersMenu.ready"), entry.getValue().getX() - 40.0f, entry.getValue().getY() - 15.0f, entry.getValue().getWidth() + 80.0f, 1, true);
                    break;
                }
                case SELECTION_GADGET2: {
                    if (this.selectedGadget2 == null) break;
                    this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("TwoPlayersMenu.ready"), entry.getValue().getX() - 40.0f, entry.getValue().getY() - 15.0f, entry.getValue().getWidth() + 80.0f, 1, true);
                }
            }
        }
    }

    private void drawSelectMode() {
        Assets.fontArialWhiteBig.getData().setScale(0.5f);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/WindowHTransparent"), this.startingWidth - 50.0f, 25.0f, 1050.0f, 675.0f);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), this.startingWidth + 250.0f, AbstractMapController.getHEIGHT() - 115, 450.0f, 75.0f);
        this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.Options"), this.startingWidth + 275.0f, AbstractMapController.getHEIGHT() - 65, 400.0f, 1, true);
        for (Map.Entry<Object, Rectangle> entry : this.menus.entrySet()) {
            String menuSel = "";
            if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == entry.getKey()) {
                menuSel = "SelMenu";
            }
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonBig" + menuSel), entry.getValue().getX(), entry.getValue().getY(), entry.getValue().getWidth(), entry.getValue().getHeight());
            if (entry.getKey() instanceof Mode) {
                Assets.fontArialWhiteBig.setColor(Color.WHITE);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), this.menus.get((Object)Mode.INFINITE).getX(), this.menus.get((Object)Mode.INFINITE).getY() + this.menus.get((Object)Mode.INFINITE).getHeight() + 25.0f, this.menus.get((Object)Mode.INFINITE).getWidth(), 75.0f);
                this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.SeleteGameMode"), this.menus.get((Object)Mode.INFINITE).getX(), this.menus.get((Object)Mode.INFINITE).getY() + this.menus.get((Object)Mode.INFINITE).getHeight() + 25.0f + 65.0f, this.menus.get((Object)Mode.INFINITE).getWidth(), 1, true);
                if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == entry.getKey()) {
                    Assets.fontArialWhiteBig.setColor(Color.YELLOW);
                    Assets.fontArialWhite.setColor(Color.YELLOW);
                } else {
                    Assets.fontArialWhiteBig.setColor(Color.BLACK);
                    Assets.fontArialWhite.setColor(Color.BLACK);
                }
                if (this.selectedMode == Mode.ESCAPE) {
                    this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.Escape"), entry.getValue().getX(), entry.getValue().getY() + entry.getValue().getHeight() / 1.25f, entry.getValue().getWidth(), 1, true);
                    this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("MenuNewGame.ReachTheTop"), entry.getValue().getX(), entry.getValue().getY() + entry.getValue().getHeight() / 2.0f, entry.getValue().getWidth(), 1, true);
                    continue;
                }
                this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.Infinite"), entry.getValue().getX(), entry.getValue().getY() + entry.getValue().getHeight() / 1.25f, entry.getValue().getWidth(), 1, true);
                this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("MenuNewGame.SurviveLong"), entry.getValue().getX(), entry.getValue().getY() + entry.getValue().getHeight() / 2.0f, entry.getValue().getWidth(), 1, true);
                continue;
            }
            if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == entry.getKey()) {
                Assets.fontArialWhiteBig.setColor(Color.YELLOW);
                Assets.fontArialWhite.setColor(Color.YELLOW);
            } else {
                Assets.fontArialWhiteBig.setColor(Color.BLACK);
                Assets.fontArialWhite.setColor(Color.BLACK);
            }
            this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.Play"), entry.getValue().getX(), entry.getValue().getY() + entry.getValue().getHeight() / 1.25f, entry.getValue().getWidth(), 1, true);
            this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("MenuNewGame.PlayDesc"), entry.getValue().getX(), entry.getValue().getY() + entry.getValue().getHeight() / 2.0f, entry.getValue().getWidth(), 1, true);
        }
        Assets.fontArialWhiteBig.setColor(Color.WHITE);
        Assets.fontArialWhite.setColor(Color.WHITE);
        this.drawSelector(InsideMenu.SELECTION_PLAYER);
        if (this.getSelectedType() == Type.EXTENDED) {
            this.drawSelector(InsideMenu.SELECTION_GADGET);
            this.drawSelector(InsideMenu.SELECTION_BONUS);
        } else {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), this.menusSelect.get((Object)InsideMenu.SELECTION_PLAYER).getX() + 350.0f, this.menusSelect.get((Object)InsideMenu.SELECTION_PLAYER).getY() + this.menusSelect.get((Object)InsideMenu.SELECTION_PLAYER).getHeight() + 25.0f, this.menusSelect.get((Object)InsideMenu.SELECTION_PLAYER).getWidth() * 2.0f + 50.0f, 75.0f);
            this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.ClassicActivated"), this.menusSelect.get((Object)InsideMenu.SELECTION_PLAYER).getX() + 25.0f + 350.0f, this.menusSelect.get((Object)InsideMenu.SELECTION_PLAYER).getY() + 25.0f + this.menusSelect.get((Object)InsideMenu.SELECTION_PLAYER).getHeight() + 60.0f, this.menusSelect.get((Object)InsideMenu.SELECTION_PLAYER).getWidth() * 2.0f, 1, true);
        }
        String selectedDifficulty = "";
        int numberOfStars = 0;
        switch (this.selectedDifficulty) {
            case EASY: {
                selectedDifficulty = ISDLocale.LocaleInUse("MenuNewGame.Easy");
                numberOfStars = 1;
                break;
            }
            case NORMAL: {
                selectedDifficulty = ISDLocale.LocaleInUse("MenuNewGame.Normal");
                numberOfStars = 2;
                break;
            }
            case HARD: {
                selectedDifficulty = ISDLocale.LocaleInUse("MenuNewGame.Hard");
                numberOfStars = 3;
            }
        }
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), this.menusDifficulty.get((Object)Difficulty.NORMAL).getX(), this.menusDifficulty.get((Object)Difficulty.NORMAL).getY() + this.menusDifficulty.get((Object)Difficulty.NORMAL).getHeight() + 25.0f, this.menusDifficulty.get((Object)Difficulty.NORMAL).getWidth(), 75.0f);
        this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.SelectDifficulty"), this.menusDifficulty.get((Object)Difficulty.NORMAL).getX(), this.menusDifficulty.get((Object)Difficulty.NORMAL).getY() + this.menusDifficulty.get((Object)Difficulty.NORMAL).getHeight() + 25.0f + 65.0f, this.menusDifficulty.get((Object)Difficulty.NORMAL).getWidth(), 1, true);
        this.drawToFontGui(Assets.fontArialWhite, selectedDifficulty, this.menusDifficulty.get((Object)Difficulty.NORMAL).getX(), this.menusDifficulty.get((Object)Difficulty.NORMAL).getY() + this.menusDifficulty.get((Object)Difficulty.NORMAL).getHeight() + 25.0f + 30.0f, this.menusDifficulty.get((Object)Difficulty.NORMAL).getWidth(), 1, true);
        if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == Difficulty.NORMAL) {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonBigSelMenu"), this.menusDifficulty.get((Object)Difficulty.NORMAL).getX(), this.menusDifficulty.get((Object)Difficulty.NORMAL).getY(), this.menusDifficulty.get((Object)Difficulty.NORMAL).getWidth(), this.menusDifficulty.get((Object)Difficulty.NORMAL).getHeight());
            Assets.fontArialWhite.setColor(Color.YELLOW);
        } else {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonBig"), this.menusDifficulty.get((Object)Difficulty.NORMAL).getX(), this.menusDifficulty.get((Object)Difficulty.NORMAL).getY(), this.menusDifficulty.get((Object)Difficulty.NORMAL).getWidth(), this.menusDifficulty.get((Object)Difficulty.NORMAL).getHeight());
            Assets.fontArialWhite.setColor(Color.BLACK);
        }
        int conta = 0;
        while (conta < numberOfStars) {
            switch (++conta) {
                case 1: {
                    this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "star"), this.menusDifficulty.get((Object)Difficulty.NORMAL).getX() + this.menusDifficulty.get((Object)Difficulty.NORMAL).getWidth() / 2.4f, this.menusDifficulty.get((Object)Difficulty.NORMAL).getY() + 16.0f, 64.0f, 64.0f);
                    break;
                }
                case 2: {
                    this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "star"), this.menusDifficulty.get((Object)Difficulty.NORMAL).getX() + this.menusDifficulty.get((Object)Difficulty.NORMAL).getWidth() / 6.0f, this.menusDifficulty.get((Object)Difficulty.NORMAL).getY() + 16.0f, 64.0f, 64.0f);
                    break;
                }
                case 3: {
                    this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "star"), this.menusDifficulty.get((Object)Difficulty.NORMAL).getX() + this.menusDifficulty.get((Object)Difficulty.NORMAL).getWidth() / 1.5f, this.menusDifficulty.get((Object)Difficulty.NORMAL).getY() + 16.0f, 64.0f, 64.0f);
                }
            }
        }
        Assets.fontArialWhiteBig.getData().setScale(1.0f);
        Assets.fontArialWhite.getData().setScale(1.0f);
        Assets.fontArialWhiteBig.setColor(Color.WHITE);
        Assets.fontArialWhite.setColor(Color.WHITE);
    }

    private void drawSelector(InsideMenu selection) {
        String menuSel = "";
        String texture = "";
        String selectedName = "";
        String selectedDesc = "";
        String label = "";
        switch (selection) {
            case SELECTION_BONUS: {
                label = ISDLocale.LocaleInUse("MenuNewGame.ChooseBonus");
                if (this.selectedObjectModifier == null) {
                    texture = "none";
                    selectedName = ISDLocale.LocaleInUse("MenuNewGame.None");
                    break;
                }
                texture = this.selectedObjectModifier.getTexture();
                selectedName = this.selectedObjectModifier.getName();
                selectedDesc = this.selectedObjectModifier.getDesc();
                break;
            }
            case SELECTION_GADGET: {
                label = ISDLocale.LocaleInUse("MenuNewGame.ChooseGadget");
                if (this.selectedGadget == null) {
                    texture = "none";
                    selectedName = ISDLocale.LocaleInUse("MenuNewGame.None");
                    break;
                }
                texture = this.selectedGadget.getTexture();
                selectedName = this.selectedGadget.getName();
                selectedDesc = this.selectedGadget.getDesc();
                break;
            }
            case SELECTION_PLAYER: {
                label = ISDLocale.LocaleInUse("MenuNewGame.ChooseCharacter");
                selectedName = this.selectedCharacter.getName();
                selectedDesc = this.selectedCharacter.getDesc();
            }
        }
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), this.menusSelect.get((Object)selection).getX(), this.menusSelect.get((Object)selection).getY() + this.menusSelect.get((Object)selection).getHeight() + 25.0f, this.menusSelect.get((Object)selection).getWidth(), 75.0f);
        this.drawToFontGui(Assets.fontArialWhiteBig, label, this.menusSelect.get((Object)selection).getX(), this.menusSelect.get((Object)selection).getY() + this.menusSelect.get((Object)selection).getHeight() + 25.0f + 65.0f, this.menusSelect.get((Object)selection).getWidth(), 1, true);
        this.drawToFontGui(Assets.fontArialWhite, selectedName, this.menusSelect.get((Object)selection).getX(), this.menusSelect.get((Object)selection).getY() + this.menusSelect.get((Object)selection).getHeight() + 25.0f + 30.0f, this.menusSelect.get((Object)selection).getWidth(), 1, true);
        if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == selection) {
            menuSel = "SelMenu";
            Assets.fontArialWhite.setColor(Color.YELLOW);
        } else {
            Assets.fontArialWhite.setColor(Color.BLACK);
        }
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonBig" + menuSel), this.menusSelect.get((Object)selection).getX(), this.menusSelect.get((Object)selection).getY(), this.menusSelect.get((Object)selection).getWidth(), this.menusSelect.get((Object)selection).getHeight());
        this.drawToFontGui(Assets.fontArialWhite, selectedDesc, this.menusSelect.get((Object)selection).getX() + 105.0f, this.menusSelect.get((Object)selection).getY() + this.menusSelect.get((Object)selection).getHeight() - 10.0f, this.menusSelect.get((Object)selection).getWidth() - 130.0f, 1, true);
        if (selection == InsideMenu.SELECTION_PLAYER) {
            this.selectedCharacter.setTimeAnimation(this.selectedCharacter.getTimeAnimation() + World.getDeltaTime());
            this.currentFrame = (TextureRegion)this.selectedCharacter.getCurrentAnimation().getKeyFrame(this.selectedCharacter.getTimeAnimation());
            this.guiBatch.draw(this.currentFrame, this.menusSelect.get((Object)selection).getX() + 40.0f, this.menusSelect.get((Object)selection).getY() + 20.0f, 32.0f, 32.0f, 64.0f, 64.0f, 1.0f, 1.0f, 0.0f);
        } else {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.PLAYER_OBJECTS, texture), this.menusSelect.get((Object)selection).getX() + 40.0f, this.menusSelect.get((Object)selection).getY() + 20.0f, 64.0f, 64.0f);
        }
        Assets.fontArialWhite.setColor(Color.WHITE);
    }

    private void drawSelector2Players(InsideMenu selection) {
        Assets.fontArialWhiteBig.getData().setScale(0.5f);
        Assets.fontArialWhiteBig.setColor(Color.WHITE);
        Assets.fontArialWhite.setColor(Color.WHITE);
        String menuSel = "";
        String texture = "";
        String selectedName = "";
        String selectedDesc = "";
        String label = "";
        switch (selection) {
            case SELECTION_GADGET: {
                label = ISDLocale.LocaleInUse("MenuNewGame.ChooseGadget");
                if (this.selectedGadget != null) {
                    texture = this.selectedGadget.getTexture();
                    selectedName = this.selectedGadget.getName();
                    selectedDesc = this.selectedGadget.getDesc();
                    break;
                }
                texture = this.selectingGadget1.getTexture();
                selectedName = this.selectingGadget1.getName();
                selectedDesc = this.selectingGadget1.getDesc();
                break;
            }
            case SELECTION_GADGET2: {
                label = ISDLocale.LocaleInUse("MenuNewGame.ChooseGadget");
                if (this.selectedGadget2 != null) {
                    texture = this.selectedGadget2.getTexture();
                    selectedName = this.selectedGadget2.getName();
                    selectedDesc = this.selectedGadget2.getDesc();
                    break;
                }
                texture = this.selectingGadget2.getTexture();
                selectedName = this.selectingGadget2.getName();
                selectedDesc = this.selectingGadget2.getDesc();
                break;
            }
            case SELECTION_PLAYER: {
                label = ISDLocale.LocaleInUse("MenuNewGame.ChooseCharacter");
                if (this.selectedCharacter != null) {
                    selectedName = this.selectedCharacter.getName();
                    selectedDesc = this.selectedCharacter.getDesc();
                    this.selectedCharacter.setTimeAnimation(this.selectedCharacter.getTimeAnimation() + World.getDeltaTime());
                    this.currentFrame = (TextureRegion)this.selectedCharacter.getCurrentAnimation().getKeyFrame(this.selectedCharacter.getTimeAnimation());
                    break;
                }
                selectedName = this.selectingCharacter1.getName();
                selectedDesc = this.selectingCharacter1.getDesc();
                this.selectingCharacter1.setTimeAnimation(this.selectingCharacter1.getTimeAnimation() + World.getDeltaTime());
                this.currentFrame = (TextureRegion)this.selectingCharacter1.getCurrentAnimation().getKeyFrame(this.selectingCharacter1.getTimeAnimation());
                break;
            }
            case SELECTION_PLAYER2: {
                label = ISDLocale.LocaleInUse("MenuNewGame.ChooseCharacter");
                if (this.selectedCharacter2 != null) {
                    selectedName = this.selectedCharacter2.getName();
                    selectedDesc = this.selectedCharacter2.getDesc();
                    this.selectedCharacter2.setTimeAnimation(this.selectedCharacter2.getTimeAnimation() + World.getDeltaTime());
                    this.currentFrame = (TextureRegion)this.selectedCharacter2.getCurrentAnimation().getKeyFrame(this.selectedCharacter2.getTimeAnimation());
                    break;
                }
                selectedName = this.selectingCharacter2.getName();
                selectedDesc = this.selectingCharacter2.getDesc();
                this.selectingCharacter2.setTimeAnimation(this.selectingCharacter2.getTimeAnimation() + World.getDeltaTime());
                this.currentFrame = (TextureRegion)this.selectingCharacter2.getCurrentAnimation().getKeyFrame(this.selectingCharacter2.getTimeAnimation());
            }
        }
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), this.menusSelect.get((Object)selection).getX(), this.menusSelect.get((Object)selection).getY() + this.menusSelect.get((Object)selection).getHeight() + 25.0f, this.menusSelect.get((Object)selection).getWidth(), 75.0f);
        this.drawToFontGui(Assets.fontArialWhiteBig, label, this.menusSelect.get((Object)selection).getX(), this.menusSelect.get((Object)selection).getY() + this.menusSelect.get((Object)selection).getHeight() + 25.0f + 65.0f, this.menusSelect.get((Object)selection).getWidth(), 1, true);
        this.drawToFontGui(Assets.fontArialWhite, selectedName, this.menusSelect.get((Object)selection).getX(), this.menusSelect.get((Object)selection).getY() + this.menusSelect.get((Object)selection).getHeight() + 25.0f + 30.0f, this.menusSelect.get((Object)selection).getWidth(), 1, true);
        switch (selection) {
            case SELECTION_PLAYER: {
                if (!this.controllerName.equals("") && this.selectedCharacter == null) {
                    menuSel = "SelMenu";
                    Assets.fontArialWhite.setColor(Color.YELLOW);
                    break;
                }
                Assets.fontArialWhite.setColor(Color.BLACK);
                break;
            }
            case SELECTION_PLAYER2: {
                if (!this.controllerName2.equals("") && this.selectedCharacter2 == null) {
                    menuSel = "SelMenu";
                    Assets.fontArialWhite.setColor(Color.YELLOW);
                    break;
                }
                Assets.fontArialWhite.setColor(Color.BLACK);
                break;
            }
            case SELECTION_GADGET: {
                if (!this.controllerName.equals("") && this.selectedCharacter != null && this.selectedGadget == null) {
                    menuSel = "SelMenu";
                    Assets.fontArialWhite.setColor(Color.YELLOW);
                    break;
                }
                Assets.fontArialWhite.setColor(Color.BLACK);
                break;
            }
            case SELECTION_GADGET2: {
                if (!this.controllerName2.equals("") && this.selectedCharacter2 != null && this.selectedGadget2 == null) {
                    menuSel = "SelMenu";
                    Assets.fontArialWhite.setColor(Color.YELLOW);
                    break;
                }
                Assets.fontArialWhite.setColor(Color.BLACK);
            }
        }
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonBig" + menuSel), this.menusSelect.get((Object)selection).getX(), this.menusSelect.get((Object)selection).getY(), this.menusSelect.get((Object)selection).getWidth(), this.menusSelect.get((Object)selection).getHeight());
        this.drawToFontGui(Assets.fontArialWhite, selectedDesc, this.menusSelect.get((Object)selection).getX() + 105.0f, this.menusSelect.get((Object)selection).getY() + this.menusSelect.get((Object)selection).getHeight() - 10.0f, this.menusSelect.get((Object)selection).getWidth() - 130.0f, 1, true);
        if (selection == InsideMenu.SELECTION_PLAYER || selection == InsideMenu.SELECTION_PLAYER2) {
            this.guiBatch.draw(this.currentFrame, this.menusSelect.get((Object)selection).getX() + 40.0f, this.menusSelect.get((Object)selection).getY() + 20.0f, 32.0f, 32.0f, 64.0f, 64.0f, 1.0f, 1.0f, 0.0f);
        } else {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.PLAYER_OBJECTS, texture), this.menusSelect.get((Object)selection).getX() + 40.0f, this.menusSelect.get((Object)selection).getY() + 20.0f, 64.0f, 64.0f);
        }
        Assets.fontArialWhiteBig.getData().setScale(1.0f);
        Assets.fontArialWhiteBig.setColor(Color.WHITE);
        Assets.fontArialWhite.setColor(Color.WHITE);
    }

    private void drawSelectGadget() {
        Assets.fontArialWhiteBig.getData().setScale(0.5f);
        Assets.fontArialWhite.setColor(Color.WHITE);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/WindowHTransparent"), this.startingWidth - 50.0f, 25.0f, 1050.0f, 675.0f);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), this.startingWidth + 250.0f, AbstractMapController.getHEIGHT() - 115, 450.0f, 75.0f);
        this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.SelectGadgetComplete"), this.startingWidth + 275.0f, AbstractMapController.getHEIGHT() - 50, 400.0f, 1, true);
        for (Map.Entry<IGadget, Rectangle> gadget : this.menusSelectGadget.entrySet()) {
            String menuSel = "";
            Assets.fontArialWhiteBig.setColor(Color.WHITE);
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), gadget.getValue().getX(), gadget.getValue().getY() + gadget.getValue().getHeight() + 25.0f, gadget.getValue().getWidth(), 75.0f);
            this.drawToFontGui(Assets.fontArialWhiteBig, gadget.getKey().getName(), gadget.getValue().getX(), gadget.getValue().getY() + gadget.getValue().getHeight() + 25.0f + 65.0f, gadget.getValue().getWidth(), 1, true);
            if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] != InsideMenu.BACK && ((IGadget)this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine]).getId() == gadget.getKey().getId()) {
                menuSel = "SelMenu";
                Assets.fontArialWhite.setColor(Color.YELLOW);
            } else {
                Assets.fontArialWhite.setColor(Color.BLACK);
            }
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonBig" + menuSel), gadget.getValue().getX(), gadget.getValue().getY(), gadget.getValue().getWidth(), gadget.getValue().getHeight());
            this.drawToFontGui(Assets.fontArialWhite, gadget.getKey().getDesc(), gadget.getValue().getX() + 105.0f, gadget.getValue().getY() + gadget.getValue().getHeight() - 10.0f, gadget.getValue().getWidth() - 130.0f, 1, true);
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.PLAYER_OBJECTS, gadget.getKey().getTexture()), gadget.getValue().getX() + 40.0f, gadget.getValue().getY() + 20.0f, 64.0f, 64.0f);
        }
    }

    private void drawSelectBonus() {
        Assets.fontArialWhiteBig.getData().setScale(0.5f);
        Assets.fontArialWhite.setColor(Color.WHITE);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/WindowHTransparent"), this.startingWidth - 50.0f, 25.0f, 1050.0f, 675.0f);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), this.startingWidth + 250.0f, AbstractMapController.getHEIGHT() - 115, 450.0f, 75.0f);
        this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.SelectBonusComplete"), this.startingWidth + 275.0f, AbstractMapController.getHEIGHT() - 50, 400.0f, 1, true);
        for (Map.Entry<IObjectModifiers, Rectangle> objectsModifier : this.menusSelectBonus.entrySet()) {
            String menuSel = "";
            Assets.fontArialWhiteBig.setColor(Color.WHITE);
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), objectsModifier.getValue().getX(), objectsModifier.getValue().getY() + objectsModifier.getValue().getHeight() + 25.0f, objectsModifier.getValue().getWidth(), 75.0f);
            this.drawToFontGui(Assets.fontArialWhiteBig, objectsModifier.getKey().getName(), objectsModifier.getValue().getX(), objectsModifier.getValue().getY() + objectsModifier.getValue().getHeight() + 25.0f + 65.0f, objectsModifier.getValue().getWidth(), 1, true);
            if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] != InsideMenu.BACK && ((IObjectModifiers)this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine]).getId() == objectsModifier.getKey().getId()) {
                menuSel = "SelMenu";
                Assets.fontArialWhite.setColor(Color.YELLOW);
            } else {
                Assets.fontArialWhite.setColor(Color.BLACK);
            }
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonBig" + menuSel), objectsModifier.getValue().getX(), objectsModifier.getValue().getY(), objectsModifier.getValue().getWidth(), objectsModifier.getValue().getHeight());
            this.drawToFontGui(Assets.fontArialWhite, objectsModifier.getKey().getDesc(), objectsModifier.getValue().getX() + 105.0f, objectsModifier.getValue().getY() + objectsModifier.getValue().getHeight() - 10.0f, objectsModifier.getValue().getWidth() - 130.0f, 1, true);
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.PLAYER_OBJECTS, objectsModifier.getKey().getTexture()), objectsModifier.getValue().getX() + 40.0f, objectsModifier.getValue().getY() + 20.0f, 64.0f, 64.0f);
        }
    }

    private void drawSelectPlayer() {
        Assets.fontArialWhiteBig.getData().setScale(0.5f);
        Assets.fontArialWhite.setColor(Color.WHITE);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/WindowHTransparent"), this.startingWidth - 50.0f, 25.0f, 1050.0f, 675.0f);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), this.startingWidth + 250.0f, AbstractMapController.getHEIGHT() - 115, 450.0f, 75.0f);
        this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.SelectCharacterComplete"), this.startingWidth + 275.0f, AbstractMapController.getHEIGHT() - 50, 400.0f, 1, true);
        for (Map.Entry<ICharacter, Rectangle> character : this.menuSelectChars.entrySet()) {
            String menuSel = "";
            Assets.fontArialWhiteBig.setColor(Color.WHITE);
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), character.getValue().getX(), character.getValue().getY() + character.getValue().getHeight() + 25.0f, character.getValue().getWidth(), 75.0f);
            this.drawToFontGui(Assets.fontArialWhiteBig, character.getKey().getName(), character.getValue().getX(), character.getValue().getY() + character.getValue().getHeight() + 25.0f + 65.0f, character.getValue().getWidth(), 1, true);
            if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] != InsideMenu.BACK && ((ICharacter)this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine]).getId() == character.getKey().getId()) {
                menuSel = "SelMenu";
                Assets.fontArialWhite.setColor(Color.YELLOW);
            } else {
                Assets.fontArialWhite.setColor(Color.BLACK);
            }
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonBig" + menuSel), character.getValue().getX(), character.getValue().getY(), character.getValue().getWidth(), character.getValue().getHeight());
            this.drawToFontGui(Assets.fontArialWhite, character.getKey().getDesc(), character.getValue().getX() + 105.0f, character.getValue().getY() + character.getValue().getHeight() - 10.0f, character.getValue().getWidth() - 130.0f, 1, true);
            character.getKey().setTimeAnimation(character.getKey().getTimeAnimation() + World.getDeltaTime());
            this.currentFrame = (TextureRegion)character.getKey().getCurrentAnimation().getKeyFrame(character.getKey().getTimeAnimation());
            this.guiBatch.draw(this.currentFrame, character.getValue().getX() + 40.0f, character.getValue().getY() + 20.0f, 32.0f, 32.0f, 64.0f, 64.0f, 1.0f, 1.0f, 0.0f);
        }
    }

    private void drawSelectType() {
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/WindowHTransparent"), this.startingWidth - 50.0f, 25.0f, 1050.0f, 675.0f);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), this.startingWidth + 250.0f, AbstractMapController.getHEIGHT() - 115, 450.0f, 75.0f);
        this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.SelectGameType"), this.startingWidth + 275.0f, AbstractMapController.getHEIGHT() - 65, 400.0f, 1, true);
        String selectedDesc = "";
        boolean display = false;
        for (Map.Entry<Type, Rectangle> entry : this.menusType.entrySet()) {
            boolean sel = false;
            display = false;
            Assets.fontArialWhiteBig.setColor(Color.BLACK);
            String menuSel = "";
            if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == entry.getKey()) {
                menuSel = "SelMenu";
                Assets.fontArialWhiteBig.setColor(Color.YELLOW);
                sel = true;
            }
            String name = "";
            String desc = "";
            switch (entry.getKey()) {
                case NORMAL: {
                    name = ISDLocale.LocaleInUse("MenuNewGame.Classic");
                    desc = ISDLocale.LocaleInUse("MenuNewGame.ClassicDesc");
                    break;
                }
                case EXTENDED: {
                    name = ISDLocale.LocaleInUse("MenuNewGame.Extended");
                    desc = ISDLocale.LocaleInUse("MenuNewGame.ExtendedDesc");
                    break;
                }
                case TWO_PLAYERS: {
                    name = ISDLocale.LocaleInUse("MenuNewGame.TwoPlayers");
                    desc = ISDLocale.LocaleInUse("MenuNewGame.TwoPlayersDesc");
                    break;
                }
                case DESC_NOSELECT: {
                    display = true;
                }
            }
            if (!display) {
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonBig" + menuSel), entry.getValue().getX(), entry.getValue().getY(), entry.getValue().getWidth(), entry.getValue().getHeight());
            } else {
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplayBig"), entry.getValue().getX(), entry.getValue().getY(), entry.getValue().getWidth(), entry.getValue().getHeight());
                Assets.fontArialWhiteBig.setColor(Color.WHITE);
                Assets.fontArialWhite.setColor(Color.WHITE);
                if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == Type.EXTENDED) {
                    this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GAME, BlockLoader.allBlocks.get(2).getTexture()), entry.getValue().getX() + 50.0f, entry.getValue().getY() + 95.0f, 64.0f, 64.0f);
                    this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GAME, BlockLoader.allBlocks.get(2).getTexture() + "3"), entry.getValue().getX() + 125.0f, entry.getValue().getY() + 95.0f, 64.0f, 64.0f);
                    this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GAME, BlockLoader.allBlocks.get(2).getTexture() + "2"), entry.getValue().getX() + 50.0f, entry.getValue().getY() + 20.0f, 64.0f, 64.0f);
                    this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GAME, BlockLoader.allBlocks.get(2).getTexture() + "1"), entry.getValue().getX() + 125.0f, entry.getValue().getY() + 20.0f, 64.0f, 64.0f);
                    this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.SandBlock"), entry.getValue().getX() + 50.0f, entry.getValue().getY() + 95.0f + 120.0f, 300.0f, 1, true);
                    this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("MenuNewGame.SandBlockDesc"), entry.getValue().getX() + 200.0f, entry.getValue().getY() + 95.0f + 30.0f, 300.0f, 1, true);
                    this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GAME, "purpleBlockExtended"), entry.getValue().getX() + 550.0f, entry.getValue().getY() + 50.0f + 20.0f, 64.0f, 64.0f);
                    this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.PurpleBlock"), entry.getValue().getX() + 550.0f, entry.getValue().getY() + 95.0f + 120.0f, 300.0f, 1, true);
                    this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("MenuNewGame.PurpleBlockDesc"), entry.getValue().getX() + 625.0f, entry.getValue().getY() + 95.0f + 30.0f, 300.0f, 1, true);
                } else if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == Type.TWO_PLAYERS) {
                    this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GAME, "blueBlock"), entry.getValue().getX() + 25.0f, entry.getValue().getY() + 50.0f + 10.0f, 64.0f, 64.0f);
                    this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.BlueBlock"), entry.getValue().getX() + 25.0f, entry.getValue().getY() + 95.0f + 70.0f, 300.0f, 8, true);
                    this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("MenuNewGame.BlueBlockDesc"), entry.getValue().getX() + 95.0f, entry.getValue().getY() + 95.0f + 30.0f, 225.0f, 1, true);
                    this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GAME, "greenBlock"), entry.getValue().getX() + 325.0f, entry.getValue().getY() + 50.0f + 10.0f, 64.0f, 64.0f);
                    this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.GreenBlock"), entry.getValue().getX() + 325.0f, entry.getValue().getY() + 95.0f + 70.0f, 300.0f, 8, true);
                    this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("MenuNewGame.GreenBlockDesc"), entry.getValue().getX() + 395.0f, entry.getValue().getY() + 95.0f + 30.0f, 225.0f, 1, true);
                    this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GAME, "stoneDark"), entry.getValue().getX() + 625.0f, entry.getValue().getY() + 50.0f + 10.0f, 64.0f, 64.0f);
                    this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuNewGame.BrownBlock"), entry.getValue().getX() + 625.0f, entry.getValue().getY() + 95.0f + 70.0f, 300.0f, 8, true);
                    this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("MenuNewGame.BrownBlockDesc"), entry.getValue().getX() + 695.0f, entry.getValue().getY() + 95.0f + 30.0f, 225.0f, 1, true);
                }
            }
            if (sel) {
                selectedDesc = desc;
            }
            this.drawToFontGui(Assets.fontArialWhiteBig, name, entry.getValue().getX() + 10.0f, entry.getValue().getY() + entry.getValue().getHeight() / 1.5f, entry.getValue().getWidth() - 20.0f, 1, true);
        }
        Assets.fontArialWhiteBig.setColor(Color.WHITE);
        this.drawToFontGui(Assets.fontArialWhiteBig, selectedDesc, this.menusType.get((Object)Type.DESC_NOSELECT).getX() + 10.0f, this.menusType.get((Object)Type.DESC_NOSELECT).getY() - 20.0f + this.menusType.get((Object)Type.DESC_NOSELECT).getHeight(), this.menusType.get((Object)Type.DESC_NOSELECT).getWidth() - 30.0f, 1, true);
    }

    @Override
    public boolean updateMenu(Vector3 touchPoint) {
        super.updateMenu(touchPoint);
        if (this.isClosed()) {
            return this.actionBackButton();
        }
        if (World.resetCloseCommand()) {
            return this.actionBackButton();
        }
        if (this.currentInsideMenu == InsideMenu.SELECTION_TYPE) {
            this.updateSelectType(touchPoint);
        } else if (this.currentInsideMenu == InsideMenu.SELECTION_MODE) {
            this.updateSelectedMode(touchPoint);
        } else if (this.currentInsideMenu == InsideMenu.SELECTION_GADGET) {
            this.updateSelectedGadget(touchPoint);
        } else if (this.currentInsideMenu == InsideMenu.SELECTION_BONUS) {
            this.updateSelectedBonus(touchPoint);
        } else if (this.currentInsideMenu == InsideMenu.SELECTION_PLAYER) {
            this.updateSelectedPlayer(touchPoint);
        }
        return !this.isClosed();
    }

    public void moveSelectorTwoPlayer(int numPlayer, int column) {
        if (numPlayer == 1) {
            if (this.selectedCharacter == null) {
                this.selectingCharacter1 = this.selectMoveCharacter(this.selectingCharacter1.getId() + column);
                if (this.selectingCharacter1.getId() == this.selectingCharacter2.getId()) {
                    if (column > 0) {
                        this.moveSelectorTwoPlayer(numPlayer, 1);
                    } else {
                        this.moveSelectorTwoPlayer(numPlayer, -1);
                    }
                }
            } else {
                this.selectingGadget1 = this.selectMoveGadget(this.selectingGadget1.getId() + column);
                if (this.selectingGadget1 instanceof ExplodingBlock) {
                    if (column > 0) {
                        this.moveSelectorTwoPlayer(numPlayer, 1);
                    } else {
                        this.moveSelectorTwoPlayer(numPlayer, -1);
                    }
                }
            }
        } else if (this.selectedCharacter2 == null) {
            this.selectingCharacter2 = this.selectMoveCharacter(this.selectingCharacter2.getId() + column);
            if (this.selectingCharacter2.getId() == this.selectingCharacter1.getId()) {
                if (column > 0) {
                    this.moveSelectorTwoPlayer(numPlayer, 1);
                } else {
                    this.moveSelectorTwoPlayer(numPlayer, -1);
                }
            }
        } else {
            this.selectingGadget2 = this.selectMoveGadget(this.selectingGadget2.getId() + column);
            if (this.selectingGadget2 instanceof ExplodingBlock) {
                if (column > 0) {
                    this.moveSelectorTwoPlayer(numPlayer, 1);
                } else {
                    this.moveSelectorTwoPlayer(numPlayer, -1);
                }
            }
        }
    }

    private IGadget selectMoveGadget(int auxSelector) {
        if (auxSelector == 0) {
            auxSelector = GadgetLoader.allGadgets.size();
        }
        if (auxSelector > GadgetLoader.allGadgets.size()) {
            auxSelector = 1;
        }
        return GadgetLoader.allGadgets.get(auxSelector);
    }

    private ICharacter selectMoveCharacter(int auxSelector) {
        if (auxSelector == 0) {
            auxSelector = CharacterLoader.allCharacters.size();
        }
        if (auxSelector > CharacterLoader.allCharacters.size()) {
            auxSelector = 1;
        }
        return CharacterLoader.allCharacters.get(auxSelector);
    }

    public void selectButtonTwoPlayers(int numPlayer) {
        if (numPlayer == 1) {
            if (this.selectedCharacter == null) {
                this.selectedCharacter = this.selectingCharacter1;
            } else {
                this.selectedGadget = this.selectingGadget1;
                this.checkStart();
            }
        } else if (this.selectedCharacter2 == null) {
            this.selectedCharacter2 = this.selectingCharacter2;
        } else {
            this.selectedGadget2 = this.selectingGadget2;
            this.checkStart();
        }
    }

    private void checkStart() {
        if (this.selectedGadget != null && this.selectedGadget2 != null) {
            this.selectedMode = Mode.INFINITE;
            this.selectedAction = Action.TWO_PLAYERS;
            this.finish = true;
            this.isClosed = true;
        }
    }

    public boolean cancelButtonTwoPlayerMode(int numPlayer) {
        boolean resettedController = false;
        if (numPlayer == 1) {
            if (this.selectedCharacter == null) {
                this.controllerName = "";
                resettedController = true;
            } else if (this.selectedCharacter != null && this.selectedGadget == null) {
                this.selectedCharacter = null;
            } else {
                this.selectedGadget = null;
            }
        } else if (numPlayer == 2) {
            if (this.selectedCharacter2 == null) {
                this.controllerName2 = "";
                resettedController = true;
            } else if (this.selectedCharacter2 != null && this.selectedGadget2 == null) {
                this.selectedCharacter2 = null;
            } else {
                this.selectedGadget2 = null;
            }
        }
        return resettedController;
    }

    @Override
    public void selectMenu() {
        if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == InsideMenu.BACK) {
            if (!this.actionBackButton()) {
                World.closeCommand();
            }
        } else {
            switch (this.currentInsideMenu) {
                case SELECTION_TYPE: {
                    this.actionSelectType((Type)((Object)this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine]));
                    break;
                }
                case SELECTION_MODE: {
                    if (this.selectedType == Type.TWO_PLAYERS) break;
                    if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] instanceof Difficulty) {
                        switch (this.selectedDifficulty) {
                            case EASY: {
                                this.selectedDifficulty = Difficulty.NORMAL;
                                break;
                            }
                            case NORMAL: {
                                this.selectedDifficulty = Difficulty.HARD;
                                break;
                            }
                            case HARD: {
                                this.selectedDifficulty = Difficulty.EASY;
                            }
                        }
                        break;
                    }
                    if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] instanceof Mode || this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] instanceof Action) {
                        this.startOrChangeMode(this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] instanceof Action);
                        break;
                    }
                    if (!(this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] instanceof InsideMenu)) break;
                    this.actionSelectModeMenu((InsideMenu)((Object)this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine]));
                    break;
                }
                case SELECTION_GADGET: {
                    this.actionSelectGadget((IGadget)this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine]);
                    break;
                }
                case SELECTION_BONUS: {
                    this.actionSelectBonus((IObjectModifiers)this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine]);
                    break;
                }
                case SELECTION_PLAYER: {
                    this.actionSelectPlayer((ICharacter)this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine]);
                }
            }
        }
    }

    private void updateSelectedPlayer(Vector3 touchPoint) {
        for (Map.Entry<ICharacter, Rectangle> entry : this.menuSelectChars.entrySet()) {
            if (!entry.getValue().contains(touchPoint.x, touchPoint.y)) continue;
            this.actionSelectPlayer(entry.getKey());
        }
    }

    private void updateSelectedBonus(Vector3 touchPoint) {
        for (Map.Entry<IObjectModifiers, Rectangle> entry : this.menusSelectBonus.entrySet()) {
            if (!entry.getValue().contains(touchPoint.x, touchPoint.y)) continue;
            this.actionSelectBonus(entry.getKey());
        }
    }

    private void updateSelectedGadget(Vector3 touchPoint) {
        for (Map.Entry<IGadget, Rectangle> entry : this.menusSelectGadget.entrySet()) {
            if (!entry.getValue().contains(touchPoint.x, touchPoint.y)) continue;
            this.actionSelectGadget(entry.getKey());
        }
    }

    private boolean actionBackButton() {
        this.actualNavigationLine = 1;
        this.actualNavigationColumn = 0;
        if (this.currentInsideMenu == InsideMenu.SELECTION_TYPE) {
            this.selectedAction = Action.EXIT;
            this.isClosed = true;
            return false;
        }
        if (this.currentInsideMenu == InsideMenu.SELECTION_MODE) {
            this.isClosed = false;
            this.currentInsideMenu = InsideMenu.SELECTION_TYPE;
            this.loadRectangles();
        } else if (this.currentInsideMenu == InsideMenu.SELECTION_GADGET || this.currentInsideMenu == InsideMenu.SELECTION_BONUS || this.currentInsideMenu == InsideMenu.SELECTION_PLAYER) {
            this.isClosed = false;
            switch (this.currentInsideMenu) {
                case SELECTION_GADGET: {
                    this.actualNavigationLine = 1;
                    this.actualNavigationColumn = 1;
                    break;
                }
                case SELECTION_BONUS: {
                    this.actualNavigationLine = 1;
                    this.actualNavigationColumn = 2;
                    break;
                }
                case SELECTION_PLAYER: {
                    this.actualNavigationLine = 1;
                    this.actualNavigationColumn = 0;
                }
            }
            this.currentInsideMenu = InsideMenu.SELECTION_MODE;
            this.loadRectangles();
        }
        return true;
    }

    private void updateSelectedMode(Vector3 touchPoint) {
        if (this.selectedType != Type.TWO_PLAYERS) {
            for (Map.Entry<Object, Rectangle> entry : this.menus.entrySet()) {
                if (!entry.getValue().contains(touchPoint.x, touchPoint.y)) continue;
                this.startOrChangeMode(entry.getKey() instanceof Action);
            }
            for (Map.Entry<Object, Rectangle> entry : this.menusSelect.entrySet()) {
                if (!entry.getValue().contains(touchPoint.x, touchPoint.y)) continue;
                this.actionSelectModeMenu((InsideMenu)((Object)entry.getKey()));
            }
            for (Map.Entry<Object, Rectangle> entry : this.menusDifficulty.entrySet()) {
                if (!entry.getValue().contains(touchPoint.x, touchPoint.y)) continue;
                switch (this.selectedDifficulty) {
                    case EASY: {
                        this.selectedDifficulty = Difficulty.NORMAL;
                        break;
                    }
                    case NORMAL: {
                        this.selectedDifficulty = Difficulty.HARD;
                        break;
                    }
                    case HARD: {
                        this.selectedDifficulty = Difficulty.EASY;
                    }
                }
            }
        }
    }

    private void startOrChangeMode(boolean isAction) {
        if (isAction) {
            this.actionSelectModeStart(this.selectedMode);
        } else {
            this.selectedMode = this.selectedMode == Mode.INFINITE ? Mode.ESCAPE : Mode.INFINITE;
        }
    }

    private void actionSelectModeMenu(InsideMenu key) {
        switch (key) {
            case SELECTION_GADGET: {
                this.currentInsideMenu = InsideMenu.SELECTION_GADGET;
                this.loadRectangles();
                break;
            }
            case SELECTION_BONUS: {
                this.currentInsideMenu = InsideMenu.SELECTION_BONUS;
                this.loadRectangles();
                break;
            }
            case SELECTION_PLAYER: {
                this.currentInsideMenu = InsideMenu.SELECTION_PLAYER;
                this.loadRectangles();
            }
        }
    }

    private Action selectAction() {
        switch (this.selectedMode) {
            case ESCAPE: {
                switch (this.selectedDifficulty) {
                    case EASY: {
                        return Action.NORMAL_ESCAPE;
                    }
                    case NORMAL: {
                        return Action.CLAUSTRO_ESCAPE;
                    }
                    case HARD: {
                        return Action.VERY_CLAUSTRO_ESCAPE;
                    }
                }
                break;
            }
            case INFINITE: {
                switch (this.selectedDifficulty) {
                    case EASY: {
                        return Action.NORMAL_INFINITE;
                    }
                    case NORMAL: {
                        return Action.CLAUSTRO_INFINITE;
                    }
                    case HARD: {
                        return Action.VERY_CLAUSTRO_INFINITE;
                    }
                }
            }
        }
        return Action.NORMAL_INFINITE;
    }

    private void updateSelectType(Vector3 touchPoint) {
        for (Map.Entry<Type, Rectangle> entry : this.menusType.entrySet()) {
            if (!entry.getValue().contains(touchPoint.x, touchPoint.y)) continue;
            this.actionSelectType(entry.getKey());
        }
    }

    private void actionSelectPlayer(ICharacter key) {
        this.selectedCharacter = key;
        this.currentInsideMenu = InsideMenu.SELECTION_MODE;
        this.loadRectangles();
        this.actualNavigationColumn = 0;
        this.actualNavigationLine = 1;
    }

    private void actionSelectBonus(IObjectModifiers key) {
        this.selectedObjectModifier = key;
        this.currentInsideMenu = InsideMenu.SELECTION_MODE;
        this.loadRectangles();
        this.actualNavigationColumn = 2;
        this.actualNavigationLine = 1;
    }

    private void actionSelectGadget(IGadget key) {
        this.selectedGadget = key;
        this.currentInsideMenu = InsideMenu.SELECTION_MODE;
        this.loadRectangles();
        this.actualNavigationColumn = 1;
        this.actualNavigationLine = 1;
    }

    private void actionSelectType(Type key) {
        this.selectedType = key;
        this.currentInsideMenu = InsideMenu.SELECTION_MODE;
        this.loadRectangles();
        this.actualNavigationColumn = 0;
        this.actualNavigationLine = 1;
    }

    private void actionSelectModeStart(Mode key) {
        this.selectedMode = key;
        this.selectedAction = this.selectAction();
        this.isClosed = true;
        this.finish = true;
    }

    public static enum InsideMenu {
        SELECTION_TYPE,
        SELECTION_MODE,
        SELECTION_GADGET,
        SELECTION_GADGET2,
        SELECTION_BONUS,
        SELECTION_PLAYER,
        SELECTION_PLAYER2,
        BACK;

    }

    public static enum Difficulty {
        EASY,
        NORMAL,
        HARD;

    }

    public static enum TypeController {
        NOT_SELECTED_KEYBOARD_GAMEPAD,
        NOT_SELECTED_GAMEPAD,
        GAMEPAD,
        KEYBOARD;

    }

    public static enum Type {
        NORMAL,
        EXTENDED,
        TWO_PLAYERS,
        DESC_NOSELECT;

    }

    public static enum Mode {
        ESCAPE,
        INFINITE;

    }

    public static enum Action {
        NORMAL_INFINITE,
        NORMAL_ESCAPE,
        CLAUSTRO_INFINITE,
        CLAUSTRO_ESCAPE,
        VERY_CLAUSTRO_INFINITE,
        VERY_CLAUSTRO_ESCAPE,
        TWO_PLAYERS,
        EXIT,
        START;

    }
}

