/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers.menu;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.ortisoft.ortilator.OrtiMain;
import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.assets.ISDLocale;
import com.ortisoft.ortilator.controllers.AbstractCameraController;
import com.ortisoft.ortilator.controllers.MenuController;
import com.ortisoft.ortilator.controllers.menu.AboutMenuController;
import com.ortisoft.ortilator.controllers.menu.LeaderBoardMenuController;
import com.ortisoft.ortilator.controllers.menu.NewGameMenuController;
import com.ortisoft.ortilator.world.World;
import com.ortisoft.ortilator.world.loaders.CharacterLoader;
import com.ortisoft.ortilator.world.loaders.GadgetLoader;
import java.util.HashMap;
import java.util.Map;

public class MainMenuController
extends MenuController {
    private MenuOptions currentMenu = null;
    private MenuOptions latestMenu = null;
    private World worldReference;
    private HashMap<MenuOptions, Rectangle> menuOptionsRectangle;
    private MenuController selectedMenu;
    private boolean loadedAdd = false;

    public MenuOptions getLatestMenu() {
        return this.latestMenu;
    }

    public MenuController getSelectedMenu() {
        return this.selectedMenu;
    }

    public boolean isNewMenuSelectedAndTwoPlayers() {
        return this.selectedMenu != null && this.selectedMenu instanceof NewGameMenuController && ((NewGameMenuController)this.selectedMenu).getSelectedType() == NewGameMenuController.Type.TWO_PLAYERS;
    }

    public NewGameMenuController returnCurrentNewGameController() {
        if (this.selectedMenu != null && this.selectedMenu instanceof NewGameMenuController) {
            return (NewGameMenuController)this.selectedMenu;
        }
        return null;
    }

    public MainMenuController(AbstractCameraController camera, World worldReference) {
        super(camera);
        this.worldReference = worldReference;
        Assets.selectRandomBackground();
    }

    @Override
    protected void loadRectangles() {
        this.menuOptionsRectangle = new HashMap();
        this.menuOptionsRectangle.put(MenuOptions.NEW_GAME, new Rectangle(500.0f, AbstractCameraController.getHEIGHT() - 175, 300.0f, 100.0f));
        this.menuOptionsRectangle.put(MenuOptions.LEADERBOARDS, new Rectangle(500.0f, AbstractCameraController.getHEIGHT() - 325, 300.0f, 100.0f));
        this.menuOptionsRectangle.put(MenuOptions.LANGUAGE, new Rectangle(1160.0f, AbstractCameraController.getHEIGHT() - 110, 80.0f, 80.0f));
        this.menuOptionsRectangle.put(MenuOptions.SOUND, new Rectangle(1160.0f, AbstractCameraController.getHEIGHT() - 270, 80.0f, 80.0f));
        this.menuOptionsRectangle.put(MenuOptions.MUSIC, new Rectangle(1160.0f, AbstractCameraController.getHEIGHT() - 430, 80.0f, 80.0f));
        this.menuOptionsRectangle.put(MenuOptions.TUTORIAL, new Rectangle(500.0f, AbstractCameraController.getHEIGHT() - 475, 300.0f, 100.0f));
        this.menuOptionsRectangle.put(MenuOptions.ABOUT, new Rectangle(500.0f, AbstractCameraController.getHEIGHT() - 625, 300.0f, 100.0f));
        this.backButton = new Rectangle(1160.0f, 50.0f, 80.0f, 80.0f);
        this.navigationMenus = new MenuOptions[2][4];
        this.navigationMenus[0][0] = MenuOptions.NEW_GAME;
        this.navigationMenus[1][0] = MenuOptions.LANGUAGE;
        this.navigationMenus[0][1] = MenuOptions.LEADERBOARDS;
        this.navigationMenus[1][1] = MenuOptions.SOUND;
        this.navigationMenus[0][2] = MenuOptions.TUTORIAL;
        this.navigationMenus[1][2] = MenuOptions.MUSIC;
        this.navigationMenus[0][3] = MenuOptions.ABOUT;
        this.navigationMenus[1][3] = MenuOptions.BACK;
    }

    public void resetCurrentMenu() {
        this.latestMenu = this.currentMenu;
        this.currentMenu = null;
        this.selectedMenu = null;
        this.isClosed = false;
    }

    public boolean setCurrentMenu(MenuOptions shortcutOption) {
        if (!(shortcutOption != MenuOptions.NEW_GAME || this.selectedMenu != null && this.selectedMenu instanceof NewGameMenuController)) {
            this.selectedMenu = new NewGameMenuController(this.camera, OrtiMain.getLatestSelectedGadget(), OrtiMain.getLatestSelectedOM(), OrtiMain.getLatestCharacter());
        } else if (shortcutOption == MenuOptions.TUTORIAL) {
            this.worldReference.startNewGame(OrtiMain.GameModes.TUTORIAL, NewGameMenuController.Type.EXTENDED, GadgetLoader.allGadgets.get(1), null, CharacterLoader.allCharacters.get(1), null, null, null, null);
        } else if (shortcutOption == MenuOptions.LEADERBOARDS) {
            this.selectedMenu = new LeaderBoardMenuController(this.camera);
        } else if (shortcutOption == MenuOptions.ABOUT) {
            this.selectedMenu = new AboutMenuController(this.camera);
        }
        if (this.selectedMenu != null) {
            this.latestMenu = this.currentMenu;
            this.currentMenu = shortcutOption;
        }
        return true;
    }

    public MenuOptions getCurrentMenu() {
        return this.currentMenu;
    }

    @Override
    public void resize(AbstractCameraController camera) {
        this.loadRectangles();
        if (this.selectedMenu != null) {
            this.selectedMenu.resize(camera);
        }
    }

    @Override
    public void draw() {
        if (!this.loadedAdd && this.currentMenu != MenuOptions.TUTORIAL) {
            this.loadedAdd = true;
        }
        if (this.drawLoadedMenu()) {
            this.startBatch(this.guiBatch, this.camera.getGuiCam());
            this.drawBackground();
            this.drawMain();
            this.endBatch(this.guiBatch);
        }
    }

    public boolean update(Vector3 touchPoint) {
        if (OrtiMain.waitingForResponse()) {
            return true;
        }
        super.updateMenu(touchPoint);
        if (this.isClosed()) {
            return false;
        }
        if (this.currentMenu == null) {
            for (Map.Entry<MenuOptions, Rectangle> rec : this.menuOptionsRectangle.entrySet()) {
                if (!rec.getValue().contains(touchPoint.x, touchPoint.y)) continue;
                this.actionSelectedMenu(rec.getKey());
            }
        } else {
            this.updateInnerMenu(touchPoint);
        }
        return !this.isClosed();
    }

    @Override
    public void updateMouseHover(Vector3 mouseCords) {
        if (this.currentMenu == null) {
            for (Map.Entry<MenuOptions, Rectangle> rec : this.menuOptionsRectangle.entrySet()) {
                if (!rec.getValue().contains(mouseCords.x, mouseCords.y)) continue;
                super.updateSelectedMenu((Object)rec.getKey());
            }
            if (this.backButton.contains(mouseCords.x, mouseCords.y)) {
                super.updateSelectedMenu((Object)MenuOptions.BACK);
            }
        } else {
            this.selectedMenu.updateMouseHover(mouseCords);
        }
    }

    private boolean drawLoadedMenu() {
        if (this.selectedMenu == null) {
            return true;
        }
        this.selectedMenu.drawMenuGui();
        return false;
    }

    private void updateInnerMenu(Vector3 touchPoint) {
        this.selectedMenu.updateMenu(touchPoint);
        if (this.selectedMenu.isClosed()) {
            if (this.currentMenu == MenuOptions.NEW_GAME && ((NewGameMenuController)this.selectedMenu).isFinish()) {
                this.isClosed = true;
            } else {
                this.latestMenu = this.currentMenu;
                this.selectedMenu = null;
                this.currentMenu = null;
            }
            return;
        }
    }

    public void moveCorrectMenu(int column, int line) {
        if (this.selectedMenu != null) {
            this.selectedMenu.moveMenu(column, line);
        } else {
            super.moveMenu(column, line);
        }
    }

    @Override
    public void selectMenu() {
        if (this.selectedMenu != null) {
            this.selectedMenu.selectMenu();
        } else {
            this.actionSelectedMenu((MenuOptions)((Object)this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine]));
        }
    }

    private void actionSelectedMenu(MenuOptions key) {
        if (key == MenuOptions.BACK) {
            World.closeCommand();
            return;
        }
        switch (key) {
            case SOUND: {
                OrtiMain.setSoundEnabled(!OrtiMain.isSoundEnabled());
                break;
            }
            case MUSIC: {
                OrtiMain.setMusicEnabled(!OrtiMain.isMusicEnabled(), false);
                break;
            }
            case LEADERBOARDS: {
                this.setCurrentMenu(MenuOptions.LEADERBOARDS);
                break;
            }
            case LANGUAGE: {
                OrtiMain.toggleLanguage();
                break;
            }
            default: {
                this.setCurrentMenu(key);
            }
        }
    }

    private void drawBackground() {
        this.drawToGui(Assets.getCurrentBG(), 0.0f, 0.0f, 1280.0f, 720.0f);
    }

    private void drawMain() {
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/MenuBack"), 425.0f, 15.0f, 450.0f, 700.0f);
        Assets.fontArialWhite.getData().setScale(0.4f);
        this.drawToFontGui(Assets.fontArialWhite, "V1.0.35 Steam - OrtiGames/OrtiSoft 2017/2018", 512.5f, 50.0f, 275.0f, 1, true);
        Assets.fontArialWhiteBig.getData().setScale(0.7f);
        Assets.fontArialWhite.getData().setScale(0.7f);
        for (Map.Entry<MenuOptions, Rectangle> entry : this.menuOptionsRectangle.entrySet()) {
            Assets.fontArialWhiteBig.setColor(Color.BLACK);
            String nameMenu = "";
            String imageDesc = "";
            switch (entry.getKey()) {
                case NEW_GAME: {
                    nameMenu = ISDLocale.LocaleInUse("MenuMain.NewGame");
                    break;
                }
                case SOUND: {
                    if (OrtiMain.isSoundEnabled()) {
                        imageDesc = "sound";
                        break;
                    }
                    imageDesc = "noSound";
                    break;
                }
                case MUSIC: {
                    if (OrtiMain.isMusicEnabled()) {
                        imageDesc = "music";
                        break;
                    }
                    imageDesc = "noMusic";
                    break;
                }
                case LEADERBOARDS: {
                    nameMenu = ISDLocale.LocaleInUse("MenuMain.LeaderBoards");
                    break;
                }
                case LANGUAGE: {
                    if (ISDLocale.getSelectedLang().equals("es")) {
                        imageDesc = "spanishFlag";
                        break;
                    }
                    if (ISDLocale.getSelectedLang().equals("cn")) {
                        imageDesc = "cn_flag";
                        break;
                    }
                    imageDesc = "ukFlag";
                    break;
                }
                case TUTORIAL: {
                    nameMenu = ISDLocale.LocaleInUse("MenuMain.Tutorial");
                    break;
                }
                case ABOUT: {
                    nameMenu = ISDLocale.LocaleInUse("MenuAbout.About");
                }
            }
            if (imageDesc.equals("")) {
                if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == entry.getKey()) {
                    this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonBigSelMenu"), entry.getValue().getX(), entry.getValue().getY(), entry.getValue().getWidth(), entry.getValue().getHeight());
                    Assets.fontArialWhiteBig.setColor(Color.YELLOW);
                } else {
                    this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonBig"), entry.getValue().getX(), entry.getValue().getY(), entry.getValue().getWidth(), entry.getValue().getHeight());
                }
                this.drawToFontGui(Assets.fontArialWhiteBig, nameMenu, entry.getValue().getX() + 10.0f, entry.getValue().getY() + entry.getValue().getHeight() / 1.5f, entry.getValue().getWidth() - 20.0f, 1, true);
                continue;
            }
            if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == entry.getKey()) {
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonShortBigSelMenu"), entry.getValue().getX(), entry.getValue().getY(), entry.getValue().getWidth(), entry.getValue().getHeight());
            } else {
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonShortBig"), entry.getValue().getX(), entry.getValue().getY(), entry.getValue().getWidth(), entry.getValue().getHeight());
            }
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, imageDesc), entry.getValue().getX() + 8.0f, entry.getValue().getY() + 8.0f, 64.0f, 64.0f);
        }
        if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == MenuOptions.BACK) {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonShortBigSelMenu"), this.backButton.getX(), this.backButton.getY(), this.backButton.getWidth(), this.backButton.getHeight());
        } else {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonShortBig"), this.backButton.getX(), this.backButton.getY(), this.backButton.getWidth(), this.backButton.getHeight());
        }
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "return"), this.backButton.getX() + 8.0f, this.backButton.getY() + 8.0f, 64.0f, 64.0f);
        Assets.fontArialWhiteBig.getData().setScale(1.0f);
        Assets.fontArialWhite.getData().setScale(1.0f);
        Assets.fontArialWhiteBig.setColor(Color.WHITE);
    }

    public static enum MenuOptions {
        NEW_GAME,
        LEADERBOARDS,
        TUTORIAL,
        ABOUT,
        SOUND,
        MUSIC,
        LANGUAGE,
        BACK;

    }
}

