/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers.menu;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.ortisoft.ortilator.OrtiMain;
import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.assets.ISDLocale;
import com.ortisoft.ortilator.controllers.AbstractCameraController;
import com.ortisoft.ortilator.controllers.AbstractMapController;
import com.ortisoft.ortilator.controllers.MenuController;
import com.ortisoft.ortilator.controllers.menu.LeaderBoardStruct;
import com.ortisoft.ortilator.world.World;
import com.ortisoft.ortilator.world.loaders.GadgetLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class LeaderBoardMenuController
extends MenuController {
    private boolean aroundUser = true;
    private boolean onlyFriends = false;
    private LeaderBoards currentLeaderBoard = LeaderBoards.EXPANDED_INFINITE;
    private ArrayList<LeaderBoardStruct> currentScores = new ArrayList();
    private HashMap<Menus, Rectangle> menuOptionsRectangle;
    private Rectangle leaderBoardPlayerPosition;
    private int startingHeight;
    private int startingWidth;

    public boolean isOnlyFriends() {
        return this.onlyFriends;
    }

    public boolean isAroundUser() {
        return this.aroundUser;
    }

    public LeaderBoardMenuController(AbstractCameraController camera) {
        super(camera);
        this.loadLeaderBoard();
    }

    @Override
    public void resize(AbstractCameraController camera) {
        this.loadRectangles();
    }

    @Override
    protected void loadRectangles() {
        this.menuOptionsRectangle = new HashMap();
        this.actualNavigationLine = 1;
        this.actualNavigationColumn = 0;
        this.startingHeight = AbstractMapController.getHEIGHT() - 385;
        this.startingWidth = 200;
        this.menuOptionsRectangle.put(Menus.CHANGE_MODE, new Rectangle(this.startingWidth - 25, this.startingHeight + 150, 300.0f, 100.0f));
        this.menuOptionsRectangle.put(Menus.CHANGE_LIST_MODE, new Rectangle(this.startingWidth + 300 + 25, this.startingHeight + 150, 300.0f, 100.0f));
        this.menuOptionsRectangle.put(Menus.CHANGE_FRIENDS, new Rectangle(this.startingWidth + 600 + 75, this.startingHeight + 150, 300.0f, 100.0f));
        this.leaderBoardPlayerPosition = new Rectangle(this.startingWidth, 50.0f, 950.0f, 350.0f);
        this.navigationMenus = new Object[3][2];
        this.navigationMenus[0][1] = Menus.CHANGE_MODE;
        this.navigationMenus[1][1] = Menus.CHANGE_LIST_MODE;
        this.navigationMenus[2][1] = Menus.CHANGE_FRIENDS;
        this.navigationMenus[2][0] = Menus.BACK;
        this.backButton = new Rectangle(AbstractMapController.getWIDTH() - 185, AbstractCameraController.getHEIGHT() - 125, 80.0f, 80.0f);
    }

    @Override
    public void drawMenuGui() {
        this.startBatch(this.guiBatch, this.camera.getGuiCam());
        this.drawBackground();
        this.draw();
        this.endBatch(this.guiBatch);
    }

    @Override
    public void updateMouseHover(Vector3 mouseCords) {
        for (Map.Entry<Menus, Rectangle> rec : this.menuOptionsRectangle.entrySet()) {
            if (!rec.getValue().contains(mouseCords.x, mouseCords.y)) continue;
            super.updateSelectedMenu((Object)rec.getKey());
        }
        if (this.backButton.contains(mouseCords.x, mouseCords.y)) {
            super.updateSelectedMenu((Object)Menus.BACK);
        }
    }

    private void drawBackground() {
        this.drawToGui(Assets.getCurrentBG(), 0.0f, 0.0f, 1280.0f, 720.0f);
    }

    @Override
    protected void draw() {
        Assets.fontArialWhiteBig.getData().setScale(0.6f);
        Assets.fontArialWhite.getData().setScale(0.6f);
        Assets.fontArialWhiteBig.setColor(Color.WHITE);
        Assets.fontArialWhite.setColor(Color.WHITE);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/WindowHTransparent"), this.startingWidth - 50, 25.0f, 1050.0f, 675.0f);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), this.startingWidth + 250, AbstractMapController.getHEIGHT() - 115, 450.0f, 75.0f);
        this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuMain.LeaderBoards"), this.startingWidth + 275, AbstractMapController.getHEIGHT() - 65, 400.0f, 1, true);
        if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == Menus.BACK) {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonShortBigSelMenu"), this.backButton.getX(), this.backButton.getY(), this.backButton.getWidth(), this.backButton.getHeight());
        } else {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonShortBig"), this.backButton.getX(), this.backButton.getY(), this.backButton.getWidth(), this.backButton.getHeight());
        }
        for (Map.Entry<Menus, Rectangle> entry : this.menuOptionsRectangle.entrySet()) {
            Assets.fontArialWhiteBig.setColor(Color.BLACK);
            String menuSel = "";
            if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == entry.getKey()) {
                menuSel = "SelMenu";
                Assets.fontArialWhiteBig.setColor(Color.YELLOW);
            }
            String name = "";
            switch (entry.getKey()) {
                case CHANGE_MODE: {
                    switch (this.currentLeaderBoard) {
                        case EXPANDED_INFINITE: {
                            name = ISDLocale.LocaleInUse("MenuLeaderBoard.ExtendedInfinite");
                            break;
                        }
                        case EXPANDEND_ESCAPE: {
                            name = ISDLocale.LocaleInUse("MenuLeaderBoard.ExtendedEscape");
                            break;
                        }
                        case CLASSIC_ESCAPE: {
                            name = ISDLocale.LocaleInUse("MenuLeaderBoard.ClassicEscape");
                            break;
                        }
                        case CLASSIC_INFINITE: {
                            name = ISDLocale.LocaleInUse("MenuLeaderBoard.ClassicInfinite");
                        }
                    }
                    break;
                }
                case CHANGE_LIST_MODE: {
                    if (this.aroundUser) {
                        name = ISDLocale.LocaleInUse("MenuLeaderBoard.AroundUser");
                        break;
                    }
                    name = ISDLocale.LocaleInUse("MenuLeaderBoard.All");
                    break;
                }
                case CHANGE_FRIENDS: {
                    name = this.onlyFriends ? ISDLocale.LocaleInUse("MenuLeaderBoard.Friends") : ISDLocale.LocaleInUse("MenuLeaderBoard.Global");
                }
            }
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonBig" + menuSel), entry.getValue().getX(), entry.getValue().getY(), entry.getValue().getWidth(), entry.getValue().getHeight());
            this.drawToFontGui(Assets.fontArialWhiteBig, name, entry.getValue().getX() + 10.0f, entry.getValue().getY() + entry.getValue().getHeight() / 1.5f, entry.getValue().getWidth() - 20.0f, 1, true);
        }
        Assets.fontArialWhiteBig.setColor(Color.BLACK);
        Assets.fontArialWhite.setColor(Color.BLACK);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "return"), this.backButton.getX() + 8.0f, this.backButton.getY() + 8.0f, 64.0f, 64.0f);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplayBig"), this.leaderBoardPlayerPosition.getX(), this.leaderBoardPlayerPosition.getY(), this.leaderBoardPlayerPosition.getWidth(), this.leaderBoardPlayerPosition.getHeight());
        Assets.fontArialWhiteBig.setColor(Color.WHITE);
        Assets.fontArialWhite.setColor(Color.WHITE);
        Assets.fontArialWhite.getData().setScale(0.8f);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), this.startingWidth, this.leaderBoardPlayerPosition.getY() + this.leaderBoardPlayerPosition.getHeight() + 10.0f, 950.0f, 50.0f);
        this.drawToFontGui(Assets.fontArialWhite, "#", this.startingWidth + 20, this.leaderBoardPlayerPosition.getY() + this.leaderBoardPlayerPosition.getHeight() + 45.0f, 30.0f, 8, true);
        this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("MenuLeaderBoard.Name"), this.startingWidth + 225, this.leaderBoardPlayerPosition.getY() + this.leaderBoardPlayerPosition.getHeight() + 45.0f, 450.0f, 8, true);
        this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("MenuLeaderBoard.Score"), this.startingWidth + 750, this.leaderBoardPlayerPosition.getY() + this.leaderBoardPlayerPosition.getHeight() + 45.0f, 200.0f, 8, true);
        float offsety = this.leaderBoardPlayerPosition.getHeight() - 10.0f;
        if (this.currentScores.size() > 0) {
            int loadedScores = 0;
            for (LeaderBoardStruct leaderboardstruct : this.currentScores) {
                if (loadedScores >= 7) break;
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "LeaderBoards/row"), this.startingWidth + 10, this.leaderBoardPlayerPosition.getY() + offsety - 35.0f, 930.0f, 40.0f);
                try {
                    this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "LeaderBoards/" + leaderboardstruct.getCharacter()), this.startingWidth + 100, this.leaderBoardPlayerPosition.getY() + offsety - 30.0f, 40.0f, 40.0f);
                    if (leaderboardstruct.getGadget() > 0 && (this.currentLeaderBoard == LeaderBoards.EXPANDED_INFINITE || this.currentLeaderBoard == LeaderBoards.EXPANDEND_ESCAPE)) {
                        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.PLAYER_OBJECTS, GadgetLoader.allGadgets.get(leaderboardstruct.getGadget()).getTexture()), this.startingWidth + 165, this.leaderBoardPlayerPosition.getY() + offsety - 30.0f, 30.0f, 30.0f);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                try {
                    this.drawToFontGui(Assets.fontArialWhite, String.valueOf(leaderboardstruct.getRank()), this.startingWidth + 20, this.leaderBoardPlayerPosition.getY() + offsety - 5.0f, 70.0f, 8, true);
                    this.drawToFontGui(Assets.fontArialWhite, leaderboardstruct.getName(), this.startingWidth + 225, this.leaderBoardPlayerPosition.getY() + offsety - 5.0f, 550.0f, 8, true);
                    if (this.currentLeaderBoard == LeaderBoards.CLASSIC_ESCAPE || this.currentLeaderBoard == LeaderBoards.EXPANDEND_ESCAPE) {
                        this.drawToFontGui(Assets.fontArialWhite, String.format("%dm %ds", TimeUnit.MILLISECONDS.toMinutes(leaderboardstruct.getScore() * 1000), TimeUnit.MILLISECONDS.toSeconds(leaderboardstruct.getScore() * 1000) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(leaderboardstruct.getScore() * 1000))), this.startingWidth + 750, this.leaderBoardPlayerPosition.getY() + offsety - 5.0f, 200.0f, 8, true);
                    } else {
                        this.drawToFontGui(Assets.fontArialWhite, String.valueOf(leaderboardstruct.getScore()), this.startingWidth + 750, this.leaderBoardPlayerPosition.getY() + offsety - 5.0f, 200.0f, 8, true);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                offsety -= 48.0f;
                ++loadedScores;
            }
        } else {
            this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("MenuLeaderBoard.NoData"), this.startingWidth + 125, this.leaderBoardPlayerPosition.getY() + offsety - 30.0f, 575.0f, 8, true);
        }
        Assets.fontArialWhiteBig.getData().setScale(1.0f);
        Assets.fontArialWhite.getData().setScale(1.0f);
    }

    public void clearScores() {
        this.currentScores.clear();
    }

    private void loadLeaderBoard() {
        this.clearScores();
        switch (this.currentLeaderBoard) {
            case EXPANDED_INFINITE: {
                OrtiMain.loadLeaderBoard("Extended Infinite", this);
                break;
            }
            case EXPANDEND_ESCAPE: {
                OrtiMain.loadLeaderBoard("Extended Escape", this);
                break;
            }
            case CLASSIC_ESCAPE: {
                OrtiMain.loadLeaderBoard("Classic Escape", this);
                break;
            }
            case CLASSIC_INFINITE: {
                OrtiMain.loadLeaderBoard("Classic Infinite", this);
            }
        }
    }

    public void addResultData(String name, int globalRank, int score, int character, int gadget) {
        this.currentScores.add(new LeaderBoardStruct(name, score, globalRank, character, gadget));
    }

    @Override
    public boolean updateMenu(Vector3 touchPoint) {
        super.updateMenu(touchPoint);
        if (this.isClosed()) {
            this.isClosed = true;
            return false;
        }
        if (World.resetCloseCommand()) {
            this.isClosed = true;
            return false;
        }
        for (Map.Entry<Menus, Rectangle> entry : this.menuOptionsRectangle.entrySet()) {
            if (!entry.getValue().contains(touchPoint.x, touchPoint.y)) continue;
            switch (entry.getKey()) {
                case CHANGE_FRIENDS: {
                    this.onlyFriends = !this.onlyFriends;
                    break;
                }
                case CHANGE_LIST_MODE: {
                    this.aroundUser = !this.aroundUser;
                    break;
                }
                case CHANGE_MODE: {
                    this.actionChangeMode();
                }
            }
            this.loadLeaderBoard();
            break;
        }
        return true;
    }

    @Override
    public void selectMenu() {
        if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == Menus.BACK) {
            this.isClosed = true;
            World.closeCommand();
        } else {
            switch ((Menus)((Object)this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine])) {
                case CHANGE_FRIENDS: {
                    this.onlyFriends = !this.onlyFriends;
                    break;
                }
                case CHANGE_LIST_MODE: {
                    this.aroundUser = !this.aroundUser;
                    break;
                }
                case CHANGE_MODE: {
                    this.actionChangeMode();
                }
            }
            this.loadLeaderBoard();
        }
    }

    private void actionChangeMode() {
        switch (this.currentLeaderBoard) {
            case EXPANDED_INFINITE: {
                this.currentLeaderBoard = LeaderBoards.CLASSIC_ESCAPE;
                break;
            }
            case CLASSIC_ESCAPE: {
                this.currentLeaderBoard = LeaderBoards.CLASSIC_INFINITE;
                break;
            }
            case CLASSIC_INFINITE: {
                this.currentLeaderBoard = LeaderBoards.EXPANDEND_ESCAPE;
                break;
            }
            case EXPANDEND_ESCAPE: {
                this.currentLeaderBoard = LeaderBoards.EXPANDED_INFINITE;
            }
        }
    }

    private static enum Menus {
        CHANGE_MODE,
        CHANGE_LIST_MODE,
        CHANGE_FRIENDS,
        BACK;

    }

    private static enum LeaderBoards {
        CLASSIC_ESCAPE,
        CLASSIC_INFINITE,
        EXPANDEND_ESCAPE,
        EXPANDED_INFINITE;

    }
}

