/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers.menu;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.ortisoft.ortilator.OrtiMain;
import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.assets.ISDLocale;
import com.ortisoft.ortilator.controllers.AbstractCameraController;
import com.ortisoft.ortilator.controllers.AbstractMapController;
import com.ortisoft.ortilator.controllers.MenuController;
import java.util.HashMap;
import java.util.Map;

public class IngameMenuController
extends MenuController {
    private MenuOptions currentMenu = MenuOptions.NONE;
    private HashMap<MenuOptions, Rectangle> menuOptionsRectangle;
    private MenuController selectedMenu;
    private final boolean isTuto;
    private final float menuHeightStart = 10.0f;
    private float menuWidthStart;

    public MenuOptions getLatestMenu() {
        return this.currentMenu;
    }

    public MenuController getSelectedMenu() {
        return this.selectedMenu;
    }

    public IngameMenuController(AbstractCameraController camera, boolean isTuto) {
        super(camera);
        this.isTuto = isTuto;
        if (isTuto) {
            this.navigationMenus[0][2] = MenuOptions.EXIT;
            this.navigationMenus[0][3] = MenuOptions.NONE;
            this.menuOptionsRectangle.remove((Object)MenuOptions.RESTART);
        }
    }

    @Override
    protected void loadRectangles() {
        this.menuOptionsRectangle = new HashMap();
        this.menuWidthStart = (float)AbstractCameraController.getWIDTH() / 2.0f - 200.0f;
        this.menuOptionsRectangle.put(MenuOptions.SOUND, new Rectangle(this.menuWidthStart + 75.0f, AbstractCameraController.getHEIGHT() - 200, 80.0f, 80.0f));
        this.menuOptionsRectangle.put(MenuOptions.MUSIC, new Rectangle(this.menuWidthStart + 75.0f + 220.0f, AbstractCameraController.getHEIGHT() - 200, 80.0f, 80.0f));
        this.menuOptionsRectangle.put(MenuOptions.RESUME, new Rectangle(this.menuWidthStart + 75.0f, AbstractCameraController.getHEIGHT() - 350, 300.0f, 100.0f));
        if (!this.isTuto) {
            this.menuOptionsRectangle.put(MenuOptions.RESTART, new Rectangle(this.menuWidthStart + 75.0f, AbstractCameraController.getHEIGHT() - 500, 300.0f, 100.0f));
        }
        this.menuOptionsRectangle.put(MenuOptions.EXIT, new Rectangle(this.menuWidthStart + 75.0f, AbstractCameraController.getHEIGHT() - 650, 300.0f, 100.0f));
        this.navigationMenus = new MenuOptions[2][4];
        this.navigationMenus[0][0] = MenuOptions.SOUND;
        this.navigationMenus[1][0] = MenuOptions.MUSIC;
        this.navigationMenus[0][1] = MenuOptions.RESUME;
        if (this.isTuto) {
            this.navigationMenus[0][2] = MenuOptions.EXIT;
        } else {
            this.navigationMenus[0][2] = MenuOptions.RESTART;
            this.navigationMenus[0][3] = MenuOptions.EXIT;
        }
    }

    @Override
    public void updateMouseHover(Vector3 mouseCords) {
        for (Map.Entry<MenuOptions, Rectangle> rec : this.menuOptionsRectangle.entrySet()) {
            if (!rec.getValue().contains(mouseCords.x, mouseCords.y)) continue;
            super.updateSelectedMenu((Object)rec.getKey());
        }
    }

    @Override
    public void selectMenu() {
        this.actualSelectMenu((MenuOptions)((Object)this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine]));
    }

    public void setCurrentMenu(MenuOptions shortcutOption) {
        if (shortcutOption == MenuOptions.EXIT) {
            // empty if block
        }
        this.currentMenu = shortcutOption;
    }

    public MenuOptions getCurrentMenu() {
        return this.currentMenu;
    }

    @Override
    public void resize(AbstractCameraController camera) {
        this.loadRectangles();
    }

    @Override
    public void draw() {
        if (this.drawLoadedMenu()) {
            this.drawMain();
        }
    }

    @Override
    public boolean updateMenu(Vector3 touchPoint) {
        super.updateMenu(touchPoint);
        if (this.isClosed()) {
            return false;
        }
        if (this.currentMenu == MenuOptions.NONE) {
            for (Map.Entry<MenuOptions, Rectangle> rec : this.menuOptionsRectangle.entrySet()) {
                if (!rec.getValue().contains(touchPoint.x, touchPoint.y)) continue;
                this.actualSelectMenu(rec.getKey());
            }
        } else {
            this.updateInnerMenu(touchPoint);
        }
        return !this.isClosed();
    }

    private void actualSelectMenu(MenuOptions key) {
        switch (key) {
            case MUSIC: {
                OrtiMain.setMusicEnabled(!OrtiMain.isMusicEnabled(), true);
                break;
            }
            case SOUND: {
                OrtiMain.setSoundEnabled(!OrtiMain.isSoundEnabled());
                break;
            }
            case RESUME: {
                this.setCurrentMenu(MenuOptions.NONE);
                this.isClosed = true;
                break;
            }
            case RESTART: {
                this.setCurrentMenu(MenuOptions.RESTART);
                this.isClosed = true;
                break;
            }
            case EXIT: {
                if (!this.isTuto) {
                    this.setCurrentMenu(MenuOptions.EXIT);
                } else {
                    this.setCurrentMenu(MenuOptions.EXIT_TUTO);
                }
                this.isClosed = true;
            }
        }
    }

    private boolean drawLoadedMenu() {
        if (this.currentMenu != MenuOptions.NONE) {
            this.selectedMenu.drawMenuGui();
            return false;
        }
        return true;
    }

    private void updateInnerMenu(Vector3 touchPoint) {
        this.selectedMenu.updateMenu(touchPoint);
        if (this.selectedMenu.isClosed()) {
            this.setCurrentMenu(MenuOptions.NONE);
        }
    }

    private void drawMain() {
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/WindowHTransparent"), this.menuWidthStart, 10.0f, 450.0f, 700.0f);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "IngameMenu/MenuBack"), this.menuWidthStart, 10.0f, 450.0f, 720.0f);
        Assets.fontArialWhiteBig.getData().setScale(0.8f);
        block7: for (Map.Entry<MenuOptions, Rectangle> menu : this.menuOptionsRectangle.entrySet()) {
            String textureToDraw = "";
            String textToDraw = "";
            switch (menu.getKey()) {
                case SOUND: {
                    if (OrtiMain.isSoundEnabled()) {
                        textureToDraw = "sound";
                        break;
                    }
                    textureToDraw = "noSound";
                    break;
                }
                case MUSIC: {
                    if (OrtiMain.isMusicEnabled()) {
                        textureToDraw = "music";
                        break;
                    }
                    textureToDraw = "noMusic";
                    break;
                }
                case RESTART: {
                    textToDraw = ISDLocale.LocaleInUse("MenuIngame.Restart");
                    break;
                }
                case RESUME: {
                    textToDraw = ISDLocale.LocaleInUse("MenuIngame.Resume");
                    break;
                }
                case EXIT: {
                    textToDraw = ISDLocale.LocaleInUse("MenuIngame.Exit");
                    break;
                }
                default: {
                    continue block7;
                }
            }
            if (textureToDraw.equals("")) {
                if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == menu.getKey()) {
                    this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonBigSelMenu"), menu.getValue().getX(), menu.getValue().getY(), menu.getValue().getWidth(), menu.getValue().getHeight());
                    Assets.fontArialWhiteBig.setColor(Color.YELLOW);
                } else {
                    Assets.fontArialWhiteBig.setColor(Color.BLACK);
                    this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonBig"), menu.getValue().getX(), menu.getValue().getY(), menu.getValue().getWidth(), menu.getValue().getHeight());
                }
                this.drawToFontGui(Assets.fontArialWhiteBig, textToDraw, menu.getValue().getX() + 10.0f, menu.getValue().getY() + menu.getValue().getHeight() / 1.5f, menu.getValue().getWidth() - 20.0f, 1, true);
                continue;
            }
            if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine] == menu.getKey()) {
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonShortBigSelMenu"), menu.getValue().getX(), menu.getValue().getY(), menu.getValue().getWidth(), menu.getValue().getHeight());
            } else {
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonShortBig"), menu.getValue().getX(), menu.getValue().getY(), menu.getValue().getWidth(), menu.getValue().getHeight());
            }
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, textureToDraw), menu.getValue().getX() + 8.0f, menu.getValue().getY() + 8.0f, 64.0f, 64.0f);
        }
        Assets.fontArialWhiteBig.setColor(Color.WHITE);
        Assets.fontArialWhiteBig.getData().setScale(1.1f);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), 460.0f, AbstractMapController.getHEIGHT() - 100, 400.0f, 75.0f);
        this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuIngame.Pause"), 475.0f, AbstractMapController.getHEIGHT() - 35, 370.0f, 1, true);
        Assets.fontArialWhiteBig.getData().setScale(1.0f);
    }

    public static enum MenuOptions {
        NONE,
        EXIT,
        EXIT_TUTO,
        SOUND,
        MUSIC,
        RESTART,
        RESUME;

    }
}

