/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers.menu;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.assets.ISDLocale;
import com.ortisoft.ortilator.controllers.AbstractCameraController;
import com.ortisoft.ortilator.controllers.AbstractMapController;
import com.ortisoft.ortilator.controllers.MenuController;
import com.ortisoft.ortilator.world.World;

public class AboutMenuController
extends MenuController {
    String aboutText = "";

    public AboutMenuController(AbstractCameraController camera) {
        super(camera);
        this.loadAboutText();
    }

    private void loadAboutText() {
        this.aboutText = ISDLocale.LocaleInUse("MenuAbout.AboutText");
    }

    @Override
    public void resize(AbstractCameraController camera) {
        this.loadRectangles();
    }

    @Override
    protected void loadRectangles() {
        this.backButton = new Rectangle(AbstractMapController.getWIDTH() - 185, AbstractCameraController.getHEIGHT() - 125, 80.0f, 80.0f);
    }

    @Override
    public void selectMenu() {
        World.closeCommand();
    }

    @Override
    public void drawMenuGui() {
        this.startBatch(this.guiBatch, this.camera.getGuiCam());
        this.drawBackground();
        this.draw();
        this.endBatch(this.guiBatch);
    }

    private void drawBackground() {
        this.drawToGui(Assets.getCurrentBG(), 0.0f, 0.0f, 1280.0f, 720.0f);
    }

    @Override
    protected void draw() {
        Assets.fontArialWhiteBig.getData().setScale(0.7f);
        Assets.fontArialWhite.getData().setScale(0.7f);
        Assets.fontArialWhiteBig.setColor(Color.WHITE);
        Assets.fontArialWhite.setColor(Color.WHITE);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/WindowHTransparent"), 150.0f, 25.0f, 1050.0f, 675.0f);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplaySmall"), 450.0f, AbstractMapController.getHEIGHT() - 115, 450.0f, 75.0f);
        this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("MenuAbout.About"), 475.0f, AbstractMapController.getHEIGHT() - 65, 400.0f, 1, true);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplayBig"), 200.0f, 45.0f, 950.0f, 545.0f);
        this.drawToFontGui(Assets.fontArialWhite, this.aboutText, 210.0f, AbstractMapController.getHEIGHT() - 150, 930.0f, 8, true);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonShortBigSelMenu"), this.backButton.getX(), this.backButton.getY(), this.backButton.getWidth(), this.backButton.getHeight());
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "return"), this.backButton.getX() + 8.0f, this.backButton.getY() + 8.0f, 64.0f, 64.0f);
        Assets.fontArialWhiteBig.getData().setScale(1.0f);
        Assets.fontArialWhite.getData().setScale(1.0f);
    }

    @Override
    public boolean updateMenu(Vector3 touchPoint) {
        return super.updateMenu(touchPoint);
    }
}

