/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers;

import com.badlogic.gdx.graphics.Texture;
import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.controllers.AbstractCameraController;
import com.ortisoft.ortilator.controllers.AbstractDrawController;
import com.ortisoft.ortilator.controllers.AbstractMapController;
import com.ortisoft.ortilator.controllers.MapController;
import com.ortisoft.ortilator.controllers.menu.NewGameMenuController;
import com.ortisoft.ortilator.entities.Block;
import com.ortisoft.ortilator.entities.blocks.ActualBlock;
import com.ortisoft.ortilator.entities.blocks.SandBlock;

public class TileDrawController
extends AbstractDrawController {
    protected AbstractCameraController camera;
    private Texture triangle;

    public TileDrawController(AbstractCameraController camera) {
        this.camera = camera;
    }

    public void draw(boolean isTutorial) {
        this.drawTiles(isTutorial);
    }

    private void drawTiles(boolean isTutorial) {
        this.mapBatch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.startBatch(this.mapBatch, this.camera.getUsedMapCam());
        for (ActualBlock actualBlock : MapController.getBlocks().values()) {
            this.drawBlock(actualBlock, isTutorial);
        }
        this.endBatch(this.mapBatch);
    }

    private void drawBlock(ActualBlock actualBlock, boolean isTutorial) {
        String texture;
        if (MapController.getGameType() == NewGameMenuController.Type.EXTENDED && (actualBlock.getBlockData().getBlockType() == Block.Type.SAND || actualBlock.getBlockData().getBlockType() == Block.Type.THREE_WAY_STONE)) {
            switch (actualBlock.getBlockData().getBlockType()) {
                case SAND: {
                    if (((SandBlock)actualBlock).getBlocksLeftToDestroy() > 3) {
                        texture = actualBlock.getTexture();
                        break;
                    }
                    texture = actualBlock.getTexture() + ((SandBlock)actualBlock).getBlocksLeftToDestroy();
                    break;
                }
                default: {
                    texture = actualBlock.getTexture() + "Extended";
                    break;
                }
            }
        } else {
            texture = actualBlock.getTexture();
        }
        if (isTutorial && (actualBlock.getPositionX() == 0.0f || actualBlock.getPositionX() == (float)(AbstractMapController.getMAP_WIDTH() + 1)) && actualBlock.getPositionY() > 3.0f) {
            return;
        }
        if ((actualBlock.getPositionX() == 0.0f || actualBlock.getPositionX() == (float)(AbstractMapController.getMAP_WIDTH() + 1)) && actualBlock.getPositionY() == (float)(AbstractMapController.getMAP_HEIGHT() - 2)) {
            this.drawToMap(Assets.returnTexture(Assets.ObjectTypes.GAME, texture), actualBlock.getPositionX(), actualBlock.getPositionY(), actualBlock.getWidth(), 0.25f);
        } else {
            if (actualBlock.getPositionY() - 0.5f > (float)(AbstractMapController.getMAP_HEIGHT() - 2)) {
                this.triangle = Assets.returnTexture(Assets.ObjectTypes.GAME, "triangle");
                this.drawToMap(this.triangle, actualBlock.getPositionX() + 0.33f, AbstractMapController.getMAP_HEIGHT() - 2, (float)this.triangle.getWidth() / 64.0f, (float)this.triangle.getHeight() / 64.0f);
            }
            this.drawToMap(Assets.returnTexture(Assets.ObjectTypes.GAME, texture), actualBlock.getPositionX(), actualBlock.getPositionY(), actualBlock.getWidth(), actualBlock.getHeight());
        }
    }
}

