/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.controllers.AbstractCameraController;
import com.ortisoft.ortilator.controllers.AbstractDrawController;
import com.ortisoft.ortilator.controllers.AbstractMapController;
import com.ortisoft.ortilator.controllers.BlockController;
import com.ortisoft.ortilator.controllers.MapController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TextureDrawController
extends AbstractDrawController {
    protected AbstractCameraController camera;
    private TextureRegion currentFrame;
    private HashMap<Animation<TextureRegion>, HashMap<Rectangle, Float>> currentAnimations = new HashMap();
    private HashMap<String, HashMap<Texture, Rectangle>> textures = new HashMap();

    public TextureDrawController(AbstractCameraController camera) {
        this.camera = camera;
    }

    public void drawAll(float delta, BlockController blockController) {
        this.checkSpecialTextures2Players();
        this.startBatch(this.mapBatch, this.camera.getUsedMapCam());
        this.drawEventTextures(blockController);
        this.drawTemporalTextures();
        this.playAtlasAnimations(delta);
        this.endBatch(this.mapBatch);
    }

    private void checkSpecialTextures2Players() {
        if (MapController.player2hasActivatedFreeze) {
            this.addToPlayAtlasAnimation("freeze", Float.valueOf(0.05f), 1.0f, 1.0f, 8.0f, 1.0f);
        }
        if (MapController.player1hasActivatedFreeze) {
            this.addToPlayAtlasAnimation("freeze", Float.valueOf(0.05f), 10.0f, 1.0f, 8.0f, 1.0f);
        }
        if (MapController.player2hasActivatedDoubleBlock) {
            this.addToPlayAtlasAnimation("double", Float.valueOf(0.05f), 1.0f, (float)AbstractMapController.getMAP_HEIGHT() - 1.8f, 8.0f, 1.0f);
        }
        if (MapController.player1hasActivatedDoubleBlock) {
            this.addToPlayAtlasAnimation("double", Float.valueOf(0.05f), 10.0f, (float)AbstractMapController.getMAP_HEIGHT() - 1.8f, 8.0f, 1.0f);
        }
    }

    private void drawEventTextures(BlockController blockController) {
        if (blockController.getMassDestroyActionCoolDown() < 0.0f) {
            this.drawToMap(Assets.returnTexture(Assets.ObjectTypes.GAME, "freeze"), 1.0f, 1.0f, 8.0f, 1.0f);
        }
        if (blockController.getMassDestroyActionCoolDown2() < 0.0f) {
            this.drawToMap(Assets.returnTexture(Assets.ObjectTypes.GAME, "freeze"), 10.0f, 1.0f, 8.0f, 1.0f);
        }
        if (MapController.getExtraBlocksPlayer1() > 0) {
            this.drawToMap(Assets.returnTexture(Assets.ObjectTypes.GAME, "double"), 1.0f, (float)AbstractMapController.getMAP_HEIGHT() - 1.8f, 8.0f, 1.0f);
        }
        if (MapController.getExtraBlocksPlayer2() > 0) {
            this.drawToMap(Assets.returnTexture(Assets.ObjectTypes.GAME, "double"), 10.0f, (float)AbstractMapController.getMAP_HEIGHT() - 1.8f, 8.0f, 1.0f);
        }
    }

    private void drawTemporalTextures() {
    }

    public void addTemporalTexture(String name, String textureName, int x, int y, int width, int height) {
        Texture texture = Assets.returnTexture(Assets.ObjectTypes.GAME, textureName);
        HashMap<Texture, Rectangle> data = new HashMap<Texture, Rectangle>();
        data.put(texture, new Rectangle(x, y, width, height));
        this.textures.put(name, data);
    }

    public void removeTemporalTexture(String name) {
        this.textures.remove(name);
    }

    public void addToPlayAtlasAnimation(String name, Float duration, float x, float y, float width, float height) {
        TextureAtlas animation = new TextureAtlas(Gdx.files.internal("data/Game/" + name + ".atlas"));
        HashMap<Rectangle, Float> data = new HashMap<Rectangle, Float>();
        data.put(new Rectangle(x, y, width, height), Float.valueOf(0.0f));
        this.currentAnimations.put(new Animation<TextureAtlas.AtlasRegion>(duration.floatValue(), animation.findRegions("singleAnimation"), Animation.PlayMode.NORMAL), data);
    }

    public void playAtlasAnimations(float delta) {
        if (this.currentAnimations.size() == 0) {
            return;
        }
        ArrayList<Animation<TextureRegion>> toRemove = new ArrayList<Animation<TextureRegion>>();
        for (Map.Entry<Animation<TextureRegion>, HashMap<Rectangle, Float>> entry : this.currentAnimations.entrySet()) {
            for (Map.Entry<Rectangle, Float> rectangleFloatEntry : entry.getValue().entrySet()) {
                rectangleFloatEntry.setValue(Float.valueOf(rectangleFloatEntry.getValue().floatValue() + delta));
                this.currentFrame = entry.getKey().getKeyFrame(rectangleFloatEntry.getValue().floatValue());
                this.mapBatch.draw(this.currentFrame, rectangleFloatEntry.getKey().x, rectangleFloatEntry.getKey().y, Math.round(rectangleFloatEntry.getKey().width / 2.0f), Math.round(rectangleFloatEntry.getKey().height / 2.0f), rectangleFloatEntry.getKey().width, rectangleFloatEntry.getKey().height, 1.0f, 1.0f, 0.0f);
                if (!entry.getKey().isAnimationFinished(rectangleFloatEntry.getValue().floatValue())) continue;
                toRemove.add(entry.getKey());
            }
        }
        for (Animation animation : toRemove) {
            this.currentAnimations.remove(animation);
        }
    }
}

