/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers;

import com.badlogic.gdx.controllers.Controller;
import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.controllers.MapController;
import com.ortisoft.ortilator.entities.AbstractActualPlaceable;
import com.ortisoft.ortilator.entities.ICharacter;
import com.ortisoft.ortilator.entities.IGadget;
import com.ortisoft.ortilator.entities.blocks.ActualBlock;
import com.ortisoft.ortilator.world.loaders.BlockLoader;
import com.ortisoft.ortilator.world.loaders.GadgetLoader;

public class PlayerController
extends AbstractActualPlaceable {
    private IGadget gadget;
    private int numGadgets;
    private int numPlayer;
    private ICharacter character;
    private Object controllerNameTwoPlayers;

    public PlayerController(int x, int y, IGadget gadget, ICharacter character, int numGadgets, int numPlayer, Object controllerNameTwoPlayers) {
        super(numPlayer, x, y, 1.0f, 1.0f, 1.0f, "player");
        this.currentXToGo = 1;
        this.gadget = gadget;
        this.numGadgets = numGadgets;
        this.character = character;
        this.character.setCurrentAnimation("idle");
        this.numPlayer = numPlayer;
        this.controllerNameTwoPlayers = controllerNameTwoPlayers;
    }

    public PlayerController(int numPlayer) {
        super(numPlayer, -50.0f, 1.0f, 1.0f, 1.0f, 1.0f, "player");
        this.numPlayer = numPlayer;
    }

    public Object getControllerNameTwoPlayers() {
        return this.controllerNameTwoPlayers;
    }

    public void setControllerNameTwoPlayers(Object controllerNameTwoPlayers) {
        this.controllerNameTwoPlayers = controllerNameTwoPlayers;
    }

    public boolean isControllerKeyboard() {
        return !(this.controllerNameTwoPlayers instanceof Controller);
    }

    public int getNumPlayer() {
        return this.numPlayer;
    }

    public void setTutoGadet() {
        this.gadget = GadgetLoader.allGadgets.get(1);
    }

    public int getNumGadgets() {
        return this.numGadgets;
    }

    @Override
    protected void checkSound(AbstractActualPlaceable.SoundType soundType) {
        switch (soundType) {
            case PUSH_PULL: {
                Assets.sound(Assets.Sounds.PUSH_PULL_BLOCK);
            }
        }
    }

    @Override
    protected boolean checkMovementTimeType() {
        switch (this.currentMovementType) {
            case NORMAL: {
                return this.movementTime >= MapController.movementTime;
            }
            case JUMP_UP: {
                return this.movementTime >= MapController.movementTime;
            }
            case JUMP_FOR_BLOCK: {
                return this.movementTime >= 0.195f;
            }
            case HIT_BLOCK: {
                return this.movementTime >= MapController.movementPushTime;
            }
            case JUMP_DOWN: {
                return this.movementTime >= MapController.movementTime;
            }
            case FELL: {
                return this.movementTime >= 0.195f;
            }
            case PUSH: 
            case PULL: {
                return this.movementTime >= MapController.movementPushTime;
            }
        }
        return true;
    }

    @Override
    protected void moveByMovementType() {
        switch (this.currentMovementType) {
            case NORMAL: {
                this.movePlayer((float)this.currentXToGo * (this.movementTime / MapController.movementTime), 0.0f);
                break;
            }
            case JUMP_UP: {
                this.movePlayer((float)this.currentXToGo * (this.movementTime / MapController.movementTime), 1.0f * (this.movementTime / MapController.movementTime));
                break;
            }
            case JUMP_FOR_BLOCK: {
                this.movePlayer(0.0f, 1.0f * (this.movementTime / 0.195f));
                break;
            }
            case HIT_BLOCK: {
                break;
            }
            case JUMP_DOWN: {
                this.movePlayer((float)this.currentXToGo * (this.movementTime / MapController.movementTime), -1.0f * (this.movementTime / MapController.movementTime));
                break;
            }
            case FELL: {
                this.movePlayer(0.0f, -1.0f * (this.movementTime / 0.195f));
                break;
            }
            case PUSH: 
            case PULL: {
                this.movePlayer((float)this.currentXToGo * (this.movementTime / MapController.movementPushTime), 0.0f);
            }
        }
    }

    private void movePlayer(float movementX, float movementY) {
        this.setPosition(this.latestCompleteX + movementX, this.latestCompleteY + movementY);
    }

    @Override
    protected void changeAnimation() {
        switch (this.currentMovementType) {
            case NORMAL: {
                this.character.setCurrentAnimation("moving");
                break;
            }
            case JUMP_UP: {
                this.character.setCurrentAnimation("moving");
                break;
            }
            case JUMP_FOR_BLOCK: {
                this.character.setCurrentAnimation("jump");
                break;
            }
            case JUMP_DOWN: {
                this.character.setCurrentAnimation("moving");
                break;
            }
            case FELL: {
                this.character.setCurrentAnimation("fall");
                break;
            }
            case NONE: {
                this.character.setCurrentAnimation("idle");
                break;
            }
            case HIT_BLOCK: {
                this.character.setCurrentAnimation("push");
                break;
            }
            case PUSH: {
                this.character.setCurrentAnimation("push");
                break;
            }
            case PULL: {
                this.character.setCurrentAnimation("pull");
            }
        }
        this.character.setTimeAnimation(0.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void onAnimationCheck() {
        block0 : switch (this.currentMovementType) {
            case PUSH: {
                MapController.getActualBlocks()[(int)this.getPositionX() + this.currentXToGo][(int)this.latestCompleteY].setMoving(this, AbstractActualPlaceable.MovementType.PUSH, this.currentXToGo);
                return;
            }
            case PULL: {
                MapController.getActualBlocks()[(int)this.getPositionX() - this.currentXToGo][(int)this.latestCompleteY].setMoving(this, AbstractActualPlaceable.MovementType.PUSH, this.currentXToGo);
                return;
            }
            case NONE: {
                switch (this.latestMovementType) {
                    case JUMP_FOR_BLOCK: {
                        MapController.insertBlockFromPlayer(this, MapController.BlockPlacementFromPlayer.BELOW, BlockLoader.allBlocks.get(100), this.controllerNameTwoPlayers != null);
                        break block0;
                    }
                    case HIT_BLOCK: {
                        ActualBlock actualBlock = MapController.getBlockInFrontOfUser(this);
                        if (actualBlock == null || MapController.getDestroyBlocks().contains(actualBlock)) return;
                        MapController.getDestroyBlocks().add(MapController.getBlockInFrontOfUser(this));
                    }
                }
            }
        }
    }

    public void useEquippedGadget() {
        if (this.gadget != null && this.numGadgets > 0 && this.gadget.isValidToUse(this)) {
            --this.numGadgets;
            this.gadget.onUse(this);
        }
    }

    public void rollBackStop() {
        this.stopMovement();
    }

    public ICharacter getCharacter() {
        return this.character;
    }

    public IGadget getGadget() {
        return this.gadget;
    }
}

