/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.controllers.AbstractCameraController;
import com.ortisoft.ortilator.controllers.AbstractDrawController;
import com.ortisoft.ortilator.controllers.PlayerController;
import com.ortisoft.ortilator.entities.AbstractActualPlaceable;
import com.ortisoft.ortilator.world.World;

public class PlaceableDrawController
extends AbstractDrawController {
    protected AbstractCameraController camera;
    private TextureRegion currentFrame;

    public PlaceableDrawController(AbstractCameraController camera) {
        this.camera = camera;
    }

    public void draw2D(AbstractActualPlaceable placeableToDraw) {
        this.drawPlaceables(placeableToDraw);
        if (World.debug) {
            this.loadDebugInfo(placeableToDraw);
        }
    }

    public void drawPlayer(PlayerController playerToDraw) {
        playerToDraw.getCharacter().setTimeAnimation(playerToDraw.getCharacter().getTimeAnimation() + World.getDeltaTime());
        this.currentFrame = (TextureRegion)playerToDraw.getCharacter().getCurrentAnimation().getKeyFrame(playerToDraw.getCharacter().getTimeAnimation());
        int scalePlayer = 1;
        if (!playerToDraw.isFacingRight()) {
            scalePlayer = -1;
        }
        this.startBatch(this.mapBatch, this.camera.getUsedMapCam());
        this.mapBatch.draw(this.currentFrame, playerToDraw.getPositionX(), playerToDraw.getPositionY(), playerToDraw.getWidth() / 2.0f, playerToDraw.getHeight() / 2.0f, playerToDraw.getWidth(), playerToDraw.getHeight(), scalePlayer, 1.0f, playerToDraw.getDirection());
        this.endBatch(this.mapBatch);
    }

    private void drawPlaceables(AbstractActualPlaceable placeable) {
        if (!placeable.isVisible()) {
            return;
        }
        Assets.ObjectTypes type = Assets.ObjectTypes.GAME;
        this.drawToMap(Assets.returnTexture(type, placeable.getTexture()), placeable.getPositionX(), placeable.getPositionY(), placeable.getWidth(), placeable.getHeight(), placeable.getDirection());
    }

    private void loadDebugInfo(AbstractActualPlaceable placeable) {
        if (World.debug) {
            // empty if block
        }
    }
}

