/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers;

import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.ortisoft.ortilator.controllers.AbstractCameraController;
import com.ortisoft.ortilator.controllers.AbstractDrawController;
import com.ortisoft.ortilator.controllers.MapController;
import com.ortisoft.ortilator.entities.AbstractActualPlaceable;
import com.ortisoft.ortilator.world.World;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ParticleDrawController
extends AbstractDrawController {
    ArrayList<ParticleEffect> particlesToDelete = new ArrayList();
    ArrayList<Map.Entry<AbstractActualPlaceable, ParticleEffect>> particlesShipToDelete = new ArrayList();
    HashMap<AbstractActualPlaceable, ParticleEffect> aux = new HashMap();
    protected AbstractCameraController camera;

    public ParticleDrawController(AbstractCameraController camera) {
        this.camera = camera;
    }

    public void drawParticles() {
        this.particlesToDelete.clear();
        this.particlesShipToDelete.clear();
        this.startBatch(this.mapBatch, this.camera.getUsedMapCam());
        for (ParticleEffect particleEffect : MapController.getParticleEffects()) {
            particleEffect.update(World.getDeltaTime());
            particleEffect.draw(this.mapBatch);
            if (!particleEffect.isComplete()) continue;
            this.particlesToDelete.add(particleEffect);
        }
        this.endBatch(this.mapBatch);
        if (this.particlesToDelete.size() > 0) {
            for (ParticleEffect particleEffect : this.particlesToDelete) {
                MapController.removeParticleEffect(particleEffect);
                particleEffect.dispose();
            }
        }
    }
}

