/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.controllers.AbstractCameraController;
import com.ortisoft.ortilator.controllers.AbstractDrawController;

public abstract class MenuController
extends AbstractDrawController {
    protected boolean isOk;
    protected boolean isClosed;
    protected Object[][] navigationMenus;
    protected int actualNavigationColumn = 0;
    protected int actualNavigationLine = 0;
    private Rectangle nextPage;
    private Rectangle prevPage;
    protected Rectangle okButton;
    protected Rectangle backButton;
    protected AbstractCameraController camera;

    public boolean isClosed() {
        return this.isClosed;
    }

    public MenuController(AbstractCameraController camera) {
        this.camera = camera;
        this.loadRectangles();
    }

    public boolean updateMenu(Vector3 touchPoint) {
        return this.updateMenu(touchPoint, false);
    }

    public void updateMouseHover(Vector3 touchPoint) {
    }

    public boolean updateMenu(Vector3 touchPoint, boolean forceClose) {
        if (forceClose) {
            this.isClosed = forceClose;
        }
        this.isOk = false;
        if (this.backButton != null && this.backButton.contains(touchPoint.x, touchPoint.y)) {
            this.isClosed = true;
            return false;
        }
        if (this.okButton != null && this.okButton.contains(touchPoint.x, touchPoint.y)) {
            this.isOk = true;
            return false;
        }
        return true;
    }

    public void resize(AbstractCameraController camera) {
        this.camera = camera;
        this.guiBatch = new SpriteBatch();
        this.loadRectangles();
        this.extraResize();
    }

    public void drawMenuGui() {
        this.startBatch(this.guiBatch, this.camera.getGuiCam());
        this.draw();
        this.endBatch(this.guiBatch);
    }

    protected void extraResize() {
    }

    protected abstract void draw();

    protected void loadRectangles() {
    }

    public void setClosed() {
        this.isClosed = true;
        this.updateMenu(new Vector3(0.0f, 0.0f, 0.0f));
    }

    public void moveMenu(int column, int line) {
        if (this.navigationMenus != null) {
            if (column != 0 && (column > 0 && this.navigationMenus.length - 1 != this.actualNavigationColumn || column < 0 && this.actualNavigationColumn != 0)) {
                if (this.navigationMenus[this.actualNavigationColumn + column][this.actualNavigationLine] == null) {
                    if (this.actualNavigationLine == 0) {
                        if (this.navigationMenus[this.actualNavigationColumn + column][this.actualNavigationLine + 1] != null) {
                            this.actualNavigationColumn += column;
                            ++this.actualNavigationLine;
                        }
                    } else if (this.navigationMenus[this.actualNavigationColumn + column][this.actualNavigationLine - 1] != null) {
                        this.actualNavigationColumn += column;
                        --this.actualNavigationLine;
                    }
                } else {
                    this.actualNavigationColumn += column;
                }
            }
            if (line != 0 && (line > 0 && this.navigationMenus[this.actualNavigationColumn].length - 1 != this.actualNavigationLine || line < 0 && this.actualNavigationLine != 0)) {
                if (this.navigationMenus[this.actualNavigationColumn][this.actualNavigationLine + line] == null) {
                    if (this.actualNavigationColumn == 0) {
                        if (this.navigationMenus[this.actualNavigationColumn + 1][this.actualNavigationLine + line] != null) {
                            ++this.actualNavigationColumn;
                            this.actualNavigationLine += line;
                        }
                    } else if (this.navigationMenus[this.actualNavigationColumn - 1][this.actualNavigationLine + line] != null) {
                        --this.actualNavigationColumn;
                        this.actualNavigationLine += line;
                    }
                } else {
                    this.actualNavigationLine += line;
                }
            }
        }
    }

    public abstract void selectMenu();

    protected void updateSelectedMenu(Object key) {
        boolean found = false;
        for (int column = 0; column < this.navigationMenus.length; ++column) {
            for (int line = 0; line < this.navigationMenus[column].length; ++line) {
                if (this.navigationMenus[column][line] == null || this.navigationMenus[column][line] != key) continue;
                if (this.actualNavigationColumn != column || this.actualNavigationLine != line) {
                    this.actualNavigationColumn = column;
                    this.actualNavigationLine = line;
                    Assets.sound(Assets.Sounds.MENU_MOVEMENT);
                }
                found = true;
                break;
            }
            if (found) break;
        }
    }
}

