/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers;

import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.controllers.AbstractMapController;
import com.ortisoft.ortilator.controllers.PlayerController;
import com.ortisoft.ortilator.controllers.menu.NewGameMenuController;
import com.ortisoft.ortilator.entities.AbstractActualPlaceable;
import com.ortisoft.ortilator.entities.Block;
import com.ortisoft.ortilator.entities.blocks.ActualBlock;
import com.ortisoft.ortilator.entities.blocks.BlueBlock;
import com.ortisoft.ortilator.entities.blocks.BrownBlock;
import com.ortisoft.ortilator.entities.blocks.GreenBlock;
import com.ortisoft.ortilator.entities.blocks.SandBlock;
import com.ortisoft.ortilator.entities.blocks.ThreeWayStone;
import com.ortisoft.ortilator.entities.blocks.WoodBlock;
import com.ortisoft.ortilator.world.World;
import com.ortisoft.ortilator.world.loaders.BlockLoader;
import java.util.ArrayList;
import java.util.HashMap;

public class MapController {
    private static HashMap<Integer, ActualBlock> blocks = new HashMap();
    private static ActualBlock[][] actualBlocks;
    private static ArrayList<Block.Type> additionalChecks;
    private static ArrayList<ParticleEffect> particleEffects;
    private static int idCounter;
    private static ArrayList<ActualBlock> aux;
    private static ArrayList<ActualBlock> auxMoving;
    private static ArrayList<ActualBlock> destroyBlocks;
    private static int extraBlocksPlayer1;
    private static int extraBlocksPlayer2;
    private static PlayerController playerController;
    private static PlayerController playerController2;
    private static long numberOfCreatedBlocks;
    private static boolean retardEffectMassDestructionPlayer1;
    private static boolean retardEffectMassDestructionPlayer2;
    public static boolean player1hasActivatedFreeze;
    public static boolean player2hasActivatedFreeze;
    public static boolean player1hasActivatedDoubleBlock;
    public static boolean player2hasActivatedDoubleBlock;
    public static boolean player1hasActivatedArtillery;
    public static boolean player2hasActivatedArtillery;
    private static NewGameMenuController.Type gameType;
    public static float movementPushTime;
    public static float movementTime;

    public static boolean isRetardEffectMassDestructionPlayer1() {
        return retardEffectMassDestructionPlayer1;
    }

    public static boolean isRetardEffectMassDestructionPlayer2() {
        return retardEffectMassDestructionPlayer2;
    }

    public static boolean readAndResetRetardEffectMassDestructionPlayer1() {
        boolean original = retardEffectMassDestructionPlayer1;
        retardEffectMassDestructionPlayer1 = false;
        return original;
    }

    public static boolean readAndResetRetardEffectMassDestructionPlayer2() {
        boolean original = retardEffectMassDestructionPlayer2;
        retardEffectMassDestructionPlayer2 = false;
        return original;
    }

    public static void setRetardEffectMassDestructionPlayer1() {
        retardEffectMassDestructionPlayer1 = true;
    }

    public static void setRetardEffectMassDestructionPlayer2() {
        retardEffectMassDestructionPlayer2 = true;
    }

    public static int getExtraBlocksPlayer1() {
        return extraBlocksPlayer1;
    }

    public static int getExtraBlocksPlayer2() {
        return extraBlocksPlayer2;
    }

    public static void removeExtraBlock(int numPlayer) {
        if (numPlayer == 1) {
            --extraBlocksPlayer1;
        } else {
            --extraBlocksPlayer2;
        }
    }

    public static PlayerController getPlayerController(int numPlayer) {
        if (numPlayer == 1) {
            return playerController;
        }
        if (numPlayer == 2) {
            return playerController2;
        }
        return null;
    }

    public static void setGameType(NewGameMenuController.Type gameType) {
        MapController.gameType = gameType;
    }

    public static NewGameMenuController.Type getGameType() {
        return gameType;
    }

    public static int getAndSetIdCounter() {
        if (++idCounter > 999999) {
            idCounter = 10000;
        }
        return idCounter;
    }

    public static void addBlock(ActualBlock actualBlockToAdd, boolean fallingOne) {
        MapController.getBlocks().put(actualBlockToAdd.getId(), actualBlockToAdd);
        MapController.getActualBlocks()[(int)actualBlockToAdd.getPositionX()][(int)actualBlockToAdd.getPositionY()] = MapController.getBlocks().get(actualBlockToAdd.getId());
        if (fallingOne) {
            MapController.getBlocks().get(actualBlockToAdd.getId()).setMoving(AbstractActualPlaceable.MovementType.FELL);
            MapController.getBlocks().get(actualBlockToAdd.getId()).checkMovement();
            MapController.addtNumberOfCreatedBlocks();
        } else if (!actualBlockToAdd.isDeactivatedEffect()) {
            actualBlockToAdd.checkSpecialProperties();
        }
    }

    public static void addMoving(ActualBlock actualBlock) {
        auxMoving.add(actualBlock);
    }

    public static void removeMoving(ActualBlock actualBlock) {
        auxMoving.remove(actualBlock);
    }

    public static ArrayList<ActualBlock> getAuxMoving() {
        return auxMoving;
    }

    public static void deleteRow(int maxY) {
        for (int col = 1; col < AbstractMapController.getMAP_WIDTH() + 1; ++col) {
            if (actualBlocks[col][1] == null || actualBlocks[col][1].isMoving() || MapController.getLengthNotMoving(actualBlocks[col]) < maxY - 2) continue;
            destroyBlocks.add(actualBlocks[col][1]);
        }
    }

    public static void deleteRow(int maxY, int firstBlock, int latestBlock) {
        for (int col = firstBlock; col < latestBlock; ++col) {
            if (actualBlocks[col][1] == null || actualBlocks[col][1].isMoving() || MapController.getLengthNotMoving(actualBlocks[col]) < maxY - 2) continue;
            destroyBlocks.add(actualBlocks[col][1]);
        }
    }

    public static int getLengthNotMoving(ActualBlock[] arr) {
        int count = 0;
        for (ActualBlock el : arr) {
            if (el == null || el.isMoving()) continue;
            ++count;
        }
        return count;
    }

    public static ArrayList<ParticleEffect> getParticleEffects() {
        return particleEffects;
    }

    public static HashMap<Integer, ActualBlock> getBlocks() {
        return blocks;
    }

    public static void checkIfPlayerShouldFall(PlayerController playerToCheck, int positionX, int positionY) {
        if (playerToCheck == null) {
            return;
        }
        if (playerToCheck.getPositionX() == (float)positionX && playerToCheck.getPositionY() - 1.0f == (float)positionY && actualBlocks[(int)playerToCheck.getPositionX()][(int)playerToCheck.getPositionY() - 1] == null) {
            playerToCheck.setMoving(AbstractActualPlaceable.MovementType.FELL);
        }
    }

    public static void checkIfBlockShouldFall(int positionX, int positionY) {
        ActualBlock actualBlock;
        if (positionY < AbstractMapController.getMAP_HEIGHT() && (actualBlock = actualBlocks[positionX][positionY + 1]) != null && actualBlocks[positionX][positionY] == null && actualBlock.getCurrentMovementType() == AbstractActualPlaceable.MovementType.NONE) {
            actualBlock.setMoving(AbstractActualPlaceable.MovementType.FELL);
        }
    }

    public static ActualBlock[][] getActualBlocks() {
        return actualBlocks;
    }

    public static void removeParticleEffect(ParticleEffect particleEffect) {
        particleEffects.remove(particleEffect);
    }

    public static void setPlayerController(PlayerController playerControllerReference, PlayerController playerControllerReference2) {
        playerController = playerControllerReference;
        playerController2 = playerControllerReference2;
    }

    public static long getNumberOfCreatedBlocks() {
        return numberOfCreatedBlocks;
    }

    public static void addtNumberOfCreatedBlocks() {
        ++numberOfCreatedBlocks;
    }

    public static void reinitialize() {
        blocks.clear();
        actualBlocks = new ActualBlock[AbstractMapController.getMAP_WIDTH() + 2][AbstractMapController.getMAP_HEIGHT() + 1];
        MapController.resetSpecialBlocks();
        particleEffects.clear();
        idCounter = 10000;
        aux.clear();
        auxMoving.clear();
        destroyBlocks.clear();
        numberOfCreatedBlocks = 0L;
        extraBlocksPlayer1 = 0;
        extraBlocksPlayer2 = 0;
        retardEffectMassDestructionPlayer1 = false;
        retardEffectMassDestructionPlayer2 = false;
    }

    private static void resetSpecialBlocks() {
        additionalChecks = new ArrayList();
        for (Block block : BlockLoader.allBlocks.values()) {
            if (!block.isSpecialPropertiesDependable()) continue;
            additionalChecks.add(block.getBlockType());
        }
    }

    public static void addBlocksToPlayer(int numPlayer) {
        if (numPlayer == 1) {
            extraBlocksPlayer1 += 2;
        } else {
            extraBlocksPlayer2 += 2;
        }
    }

    public static ArrayList<ActualBlock> getDestroyBlocks() {
        return destroyBlocks;
    }

    public static void destroyAction() {
        if (destroyBlocks.size() > 0) {
            Assets.sound(Assets.Sounds.EXPLOSION);
        }
        for (int i = destroyBlocks.size() - 1; i >= 0; --i) {
            ActualBlock actualBlock = destroyBlocks.get(i);
            MapController.startParticleExplosionEffect(actualBlock);
            if (MapController.getActualBlocks()[(int)actualBlock.getLatestCompleteX()][(int)actualBlock.getLatestCompleteY()] == actualBlock) {
                MapController.getActualBlocks()[(int)actualBlock.getLatestCompleteX()][(int)actualBlock.getLatestCompleteY()] = null;
                MapController.checkIfBlockShouldFall((int)actualBlock.getLatestCompleteX(), (int)actualBlock.getLatestCompleteY());
                MapController.checkIfPlayerShouldFall(playerController, (int)actualBlock.getLatestCompleteX(), (int)actualBlock.getLatestCompleteY());
                MapController.checkIfPlayerShouldFall(playerController2, (int)actualBlock.getLatestCompleteX(), (int)actualBlock.getLatestCompleteY());
            }
            if (MapController.getActualBlocks()[(int)actualBlock.getLatestCompleteX()][(int)actualBlock.getLatestCompleteY() - 1] == actualBlock) {
                MapController.getActualBlocks()[(int)actualBlock.getLatestCompleteX()][(int)actualBlock.getLatestCompleteY() - 1] = null;
                MapController.checkIfBlockShouldFall((int)actualBlock.getLatestCompleteX(), (int)actualBlock.getLatestCompleteY() - 1);
                MapController.checkIfPlayerShouldFall(playerController, (int)actualBlock.getLatestCompleteX(), (int)actualBlock.getLatestCompleteY() - 1);
                MapController.checkIfPlayerShouldFall(playerController2, (int)actualBlock.getLatestCompleteX(), (int)actualBlock.getLatestCompleteY() - 1);
            }
            MapController.getBlocks().remove(actualBlock.getId());
            auxMoving.remove(actualBlock);
            destroyBlocks.remove(actualBlock);
        }
    }

    private static void startParticleExplosionEffect(AbstractActualPlaceable placeable) {
        MapController.addParticleEffect("Explosions/explosion", placeable.getPositionX() + placeable.getWidth() / 2.0f, placeable.getPositionY() + placeable.getHeight() / 2.0f);
    }

    public static void addParticleEffect(String particleName, float positionX, float positionY) {
        String mobile = "";
        if (World.isMobile()) {
            mobile = "Mob";
        }
        ParticleEffect particleEffect = new ParticleEffect(Assets.returnEffect(particleName + mobile));
        particleEffect.setPosition(positionX, positionY);
        particleEffect.start();
        particleEffects.add(particleEffect);
    }

    public static void checkForSpecialTiles(float positionX) {
        for (ActualBlock actualBlock : MapController.getActualBlocks()[(int)positionX]) {
            for (Block.Type blockType : additionalChecks) {
                if (actualBlock == null || actualBlock.getBlockData().getBlockType() != blockType || actualBlock.isDeactivatedEffect()) continue;
                actualBlock.checkSpecialProperties();
            }
        }
    }

    public static boolean playerHasUpperTitleFree(PlayerController playerControllerToCheck) {
        return !playerControllerToCheck.isMoving() && playerControllerToCheck.getPositionY() + 1.0f <= (float)AbstractMapController.getMAP_HEIGHT() && MapController.getActualBlocks()[(int)playerControllerToCheck.getPositionX()][(int)playerControllerToCheck.getPositionY() + 1] == null;
    }

    public static boolean playerIsInFrontOfATrappedBlock(PlayerController playerControllerToCheck) {
        return !playerControllerToCheck.isMoving() && (playerControllerToCheck.isFacingRight() && MapController.getActualBlocks()[(int)playerControllerToCheck.getPositionX() + 1][(int)playerControllerToCheck.getPositionY()] != null && MapController.getActualBlocks()[(int)playerControllerToCheck.getPositionX() + 1][(int)playerControllerToCheck.getPositionY() + 1] != null || !playerControllerToCheck.isFacingRight() && MapController.getActualBlocks()[(int)playerControllerToCheck.getPositionX() - 1][(int)playerControllerToCheck.getPositionY()] != null && MapController.getActualBlocks()[(int)playerControllerToCheck.getPositionX() - 1][(int)playerControllerToCheck.getPositionY() + 1] != null);
    }

    public static boolean playerIsInFrontOfBlock(PlayerController playerControllerToCheck) {
        if (!playerControllerToCheck.isMoving()) {
            int posEndMap;
            int posIniMap;
            if (playerController2 == null) {
                posIniMap = 0;
                posEndMap = MapController.getActualBlocks().length - 1;
            } else if (playerControllerToCheck.getNumPlayer() == 1) {
                posIniMap = 0;
                posEndMap = 8;
            } else {
                posIniMap = 8;
                posEndMap = MapController.getActualBlocks().length - 1;
            }
            if (playerControllerToCheck.isFacingRight() && MapController.getActualBlocks()[(int)playerControllerToCheck.getPositionX() + 1][(int)playerControllerToCheck.getPositionY()] != null && playerControllerToCheck.getPositionX() + 1.0f != (float)posEndMap || !playerControllerToCheck.isFacingRight() && MapController.getActualBlocks()[(int)playerControllerToCheck.getPositionX() - 1][(int)playerControllerToCheck.getPositionY()] != null && playerControllerToCheck.getPositionX() - 1.0f != (float)posIniMap) {
                return true;
            }
        }
        return false;
    }

    public static boolean playerIsNotInFrontOfABlock(PlayerController playerControllerToCheck) {
        return !playerControllerToCheck.isMoving() && (playerControllerToCheck.isFacingRight() && MapController.getActualBlocks()[(int)playerControllerToCheck.getPositionX() + 1][(int)playerControllerToCheck.getPositionY()] == null && MapController.getActualBlocks()[(int)playerControllerToCheck.getPositionX() + 1][(int)playerControllerToCheck.getPositionY() + 1] == null || !playerControllerToCheck.isFacingRight() && MapController.getActualBlocks()[(int)playerControllerToCheck.getPositionX() - 1][(int)playerControllerToCheck.getPositionY()] == null && MapController.getActualBlocks()[(int)playerControllerToCheck.getPositionX() - 1][(int)playerControllerToCheck.getPositionY() + 1] == null);
    }

    public static ActualBlock getBlockInFrontOfUser(PlayerController playerControllerToCheck) {
        if (!playerControllerToCheck.isMoving()) {
            if (playerControllerToCheck.isFacingRight() && MapController.getActualBlocks()[(int)playerControllerToCheck.getPositionX() + 1][(int)playerControllerToCheck.getPositionY()] != null) {
                return MapController.getActualBlocks()[(int)playerControllerToCheck.getPositionX() + 1][(int)playerControllerToCheck.getPositionY()];
            }
            if (!playerControllerToCheck.isFacingRight() && MapController.getActualBlocks()[(int)playerControllerToCheck.getPositionX() - 1][(int)playerControllerToCheck.getPositionY()] != null) {
                return MapController.getActualBlocks()[(int)playerControllerToCheck.getPositionX() - 1][(int)playerControllerToCheck.getPositionY()];
            }
        }
        return null;
    }

    public static ActualBlock returnNewBlock(int id, int x, int y, Block blockDataToAdd, boolean isTwoPlayer) {
        ActualBlock actualBlockToAdd;
        switch (blockDataToAdd.getBlockType()) {
            case THREE_WAY_STONE: {
                actualBlockToAdd = new ThreeWayStone(id, (float)x, (float)y, 0.0f, 1.0f, 1.0f, blockDataToAdd);
                break;
            }
            case SAND: {
                actualBlockToAdd = new SandBlock(id, (float)x, (float)y, 0.0f, 1.0f, 1.0f, blockDataToAdd);
                break;
            }
            case WOOD: {
                actualBlockToAdd = new WoodBlock(id, (float)x, (float)y, 0.0f, 1.0f, 1.0f, blockDataToAdd);
                break;
            }
            case GREEN: {
                actualBlockToAdd = new GreenBlock(id, x, y, 0.0f, 1.0f, 1.0f, blockDataToAdd, isTwoPlayer);
                break;
            }
            case BROWN: {
                actualBlockToAdd = new BrownBlock(id, x, y, 0.0f, 1.0f, 1.0f, blockDataToAdd, isTwoPlayer);
                break;
            }
            case BLUE: {
                actualBlockToAdd = new BlueBlock(id, x, y, 0.0f, 1.0f, 1.0f, blockDataToAdd, isTwoPlayer);
                break;
            }
            default: {
                actualBlockToAdd = new ActualBlock(id, (float)x, (float)y, 0.0f, 1.0f, 1.0f, blockDataToAdd);
            }
        }
        return actualBlockToAdd;
    }

    public static void insertBlockFromPlayer(PlayerController playerControllerAction, BlockPlacementFromPlayer placement, Block blockType, boolean isTwoPlayers) {
        switch (placement) {
            case LEFT: {
                MapController.addBlock(MapController.returnNewBlock(MapController.getAndSetIdCounter(), (int)playerControllerAction.getPositionX() - 1, (int)playerControllerAction.getPositionY(), blockType, isTwoPlayers), false);
                MapController.checkIfBlockShouldFall((int)playerControllerAction.getPositionX() - 1, (int)playerControllerAction.getPositionY() - 1);
                break;
            }
            case RIGHT: {
                MapController.addBlock(MapController.returnNewBlock(MapController.getAndSetIdCounter(), (int)playerControllerAction.getPositionX() + 1, (int)playerController.getPositionY(), blockType, isTwoPlayers), false);
                MapController.checkIfBlockShouldFall((int)playerControllerAction.getPositionX() + 1, (int)playerControllerAction.getPositionY() - 1);
                break;
            }
            case BELOW: {
                ActualBlock actualBlockToAdd = MapController.returnNewBlock(MapController.getAndSetIdCounter(), (int)playerControllerAction.getPositionX(), (int)playerControllerAction.getPositionY() - 1, blockType, isTwoPlayers);
                playerControllerAction.setPosition(playerControllerAction.getPositionX(), playerControllerAction.getPositionY());
                playerControllerAction.refreshLatestCompletePosition();
                MapController.addBlock(actualBlockToAdd, false);
                ActualBlock blockBelow = MapController.getActualBlocks()[(int)playerControllerAction.getPositionX()][(int)playerControllerAction.getPositionY() - 2];
                if (blockBelow == null || blockBelow.isDeactivatedEffect()) break;
                blockBelow.checkSpecialProperties();
            }
        }
    }

    static {
        additionalChecks = new ArrayList();
        particleEffects = new ArrayList();
        idCounter = 10000;
        aux = new ArrayList();
        auxMoving = new ArrayList();
        destroyBlocks = new ArrayList();
        extraBlocksPlayer1 = 0;
        extraBlocksPlayer2 = 0;
    }

    public static enum BlockPlacementFromPlayer {
        BELOW,
        LEFT,
        RIGHT;

    }
}

