/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers;

import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.assets.ISDLocale;
import com.ortisoft.ortilator.controllers.AbstractCameraController;
import com.ortisoft.ortilator.controllers.MenuController;
import com.ortisoft.ortilator.entities.IntroObject;
import java.util.ArrayList;

public class IntroController
extends MenuController {
    private ArrayList<IntroObject> listIntroObjects = new ArrayList();
    private double timeSpan = 0.0;
    private boolean allFinish = false;
    private boolean showStart = false;

    public IntroController(AbstractCameraController camera) {
        super(camera);
        this.initialize();
    }

    private void initialize() {
        this.listIntroObjects.add(new IntroObject("l1", 175.0f, 1200.0f, 238.0f, 60.0f, 175.0f, 1.0f, true, true, null));
        this.listIntroObjects.add(new IntroObject("b1", -505.0f, 1247.0f, 447.0f, 20.0f, 295.0f, 20.0f, true, true, Assets.Sounds.FALLING_BLOCK));
        this.listIntroObjects.add(new IntroObject("b2", 1645.0f, 1245.0f, 345.0f, 20.0f, 745.0f, 20.0f, true, false, Assets.Sounds.FALLING_BLOCK));
        this.listIntroObjects.add(new IntroObject("l2", 350.0f, 2000.0f, 450.0f, 30.0f, 350.0f, 1.0f, true, true, Assets.Sounds.EXPLOSION));
        this.listIntroObjects.add(new IntroObject("l3", 390.0f, 2500.0f, 315.0f, 30.0f, 390.0f, 1.0f, true, true, Assets.Sounds.EXPLOSION));
    }

    @Override
    public void draw() {
        this.startBatch(this.guiBatch, this.camera.getGuiCam());
        this.drawToGui(Assets.getCurrentBG(), 0.0f, 0.0f, 1280.0f, 720.0f);
        if (this.allFinish) {
            this.guiBatch.draw(Assets.returnTexture(Assets.ObjectTypes.INTRO, "l1b"), 175.0f, 230.0f);
        }
        for (IntroObject introObject : this.listIntroObjects) {
            this.drawToGui(introObject.getTexture(), introObject.getCurrentX(), introObject.getCurrentY());
        }
        if (this.allFinish) {
            this.guiBatch.draw(Assets.returnTexture(Assets.ObjectTypes.INTRO, "selectedGamepad"), 1050.0f, 60.0f);
            Assets.fontArialWhite.getData().setScale(0.7f);
            Assets.fontArialWhite.draw(this.guiBatch, ISDLocale.LocaleInUse("Intro.better.with.gamepad"), 1060.0f, 35.0f, 125.0f, 1, false);
            Assets.fontArialWhite.draw(this.guiBatch, "OrtiSoft/OrtiGames 2017/2018", 0.0f, 35.0f, 1280.0f, 1, false);
            Assets.fontArialWhite.getData().setScale(1.0f);
            if (this.showStart) {
                Assets.fontArialWhite.draw(this.guiBatch, ISDLocale.LocaleInUse("Intro.press.button1"), 350.0f, 240.0f, 125.0f, 16, false);
                this.guiBatch.draw(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/XboxOne_A"), 475.0f, 180.0f);
                Assets.fontArialWhite.draw(this.guiBatch, ISDLocale.LocaleInUse("Intro.press.button2"), 580.0f, 240.0f, 125.0f, 1, false);
                this.guiBatch.draw(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/Keyboard_Black_Space"), 720.0f, 180.0f);
                Assets.fontArialWhite.draw(this.guiBatch, ISDLocale.LocaleInUse("Intro.press.button3"), 830.0f, 240.0f, 100.0f, 8, false);
            }
        }
        this.endBatch(this.guiBatch);
    }

    public void update(double delta) {
        this.timeSpan += delta;
        for (IntroObject introObject : this.listIntroObjects) {
            introObject.update();
            this.allFinish = true;
            if (introObject.isFinish()) continue;
            this.allFinish = false;
        }
        this.showStart = this.allFinish && Math.round(this.timeSpan) % 2L == 0L;
    }

    @Override
    public void selectMenu() {
    }

    public void reloadTextures() {
        for (IntroObject introObject : this.listIntroObjects) {
            introObject.loadTexture();
        }
    }
}

