/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.ortisoft.ortilator.OrtiMain;
import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.assets.ISDLocale;
import com.ortisoft.ortilator.controllers.AbstractCameraController;
import com.ortisoft.ortilator.controllers.AbstractDrawController;
import com.ortisoft.ortilator.controllers.AbstractMapController;
import com.ortisoft.ortilator.controllers.MapController;
import com.ortisoft.ortilator.controllers.PlayerController;
import com.ortisoft.ortilator.controllers.menu.NewGameMenuController;
import com.ortisoft.ortilator.world.World;
import com.ortisoft.ortilator.world.loaders.GadgetLoader;
import java.text.DecimalFormat;

public class GuiController
extends AbstractDrawController {
    private AbstractCameraController camera;
    private World worldReference;
    DecimalFormat df = new DecimalFormat("#.#");
    private boolean newLevelLabel = false;
    private float levelTime = 0.0f;
    private int lastLevel = 0;
    private int auxOffset = 0;
    private boolean offSetGoingTop = true;
    private boolean skipOneOffset = false;
    private long currentHighScore;
    private boolean isEscapeMode = false;
    private Rectangle skipTutorial;
    private float latestTimeShowModifierPlayer1 = 0.0f;
    private float latestTimeShowModifierPlayer2 = 0.0f;
    private modifiers2P modifiersForP1 = null;
    private modifiers2P modifiersForP2 = null;

    public GuiController(AbstractCameraController camera, World worldReference) {
        this.camera = camera;
        this.worldReference = worldReference;
        this.loadRectangles();
    }

    private void loadRectangles() {
        this.reloadDynamicRectangles();
        if (this.worldReference.getGameState() != null && this.worldReference.getGameState().getTutorialShow()) {
            this.skipTutorial = new Rectangle(AbstractMapController.getWIDTH() - 185, AbstractCameraController.getHEIGHT() - 125, 80.0f, 80.0f);
        }
    }

    public void reloadDynamicRectangles() {
    }

    public void drawFullBackground() {
        this.startBatch(this.guiBatch, this.camera.getGuiCam());
        this.drawBackground();
        this.endBatch(this.guiBatch);
    }

    public void drawGui() {
        if (this.worldReference.getGameState().isRestartingGame()) {
            return;
        }
        if (!this.worldReference.getGameState().getTutorialShow() && this.worldReference.getGameState().getGameMode() != OrtiMain.GameModes.TWO_PLAYERS) {
            this.checkGameMode();
            this.checkLevelLabel();
            this.startBatch(this.guiBatch, this.camera.getGuiCam());
            this.drawBase();
            this.endBatch(this.guiBatch);
        } else if (this.worldReference.getGameState().getGameMode() == OrtiMain.GameModes.TWO_PLAYERS) {
            this.isEscapeMode = false;
            this.checkLevelLabel();
            this.startBatch(this.guiBatch, this.camera.getGuiCam());
            this.drawBaseTwoPlayers();
            this.endBatch(this.guiBatch);
        } else {
            this.startBatch(this.guiBatch, this.camera.getGuiCam());
            this.drawTuto();
            this.endBatch(this.guiBatch);
        }
    }

    private void drawTuto() {
        Assets.fontArialWhiteBig.setColor(Color.WHITE);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/WindowHTransparent"), 150.0f, 225.0f, 1050.0f, 475.0f);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/darkDisplayBig"), 165.0f, 230.0f, 1025.0f, 465.0f);
        this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("Tutorial.HowToPlay"), 175.0f, AbstractMapController.getHEIGHT() - 45, 1015.0f, 1, true);
        switch (this.worldReference.getGameState().getCurrentTutoSteps()) {
            case INTRO: 
            case TAP_LEFT: {
                this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("Tutorial.TapLeft"), 175.0f, AbstractMapController.getHEIGHT() - 105, 900.0f, 1, true);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/XboxOne_Dpad_Left"), 140.0f, 20.0f, 100.0f, 100.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/Keyboard_Black_A"), 140.0f, 120.0f, 100.0f, 100.0f);
                break;
            }
            case SWIPE_LEFT_RIGHT: {
                this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("Tutorial.SwipeLeftRight"), 175.0f, AbstractMapController.getHEIGHT() - 105, 900.0f, 1, true);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/XboxOne_Dpad_Right"), 300.0f, 20.0f, 100.0f, 100.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/sum"), 240.0f, 40.0f, 60.0f, 60.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/XboxOne_A"), 140.0f, 20.0f, 100.0f, 100.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/Keyboard_Black_D"), 300.0f, 120.0f, 100.0f, 100.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/sum"), 240.0f, 140.0f, 60.0f, 60.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/Keyboard_Black_Space"), 140.0f, 120.0f, 100.0f, 100.0f);
                break;
            }
            case SWIPE_LEFT_LEFT: {
                this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("Tutorial.SwipeLeftLeft"), 175.0f, AbstractMapController.getHEIGHT() - 105, 900.0f, 1, true);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/XboxOne_Dpad_Left"), 300.0f, 20.0f, 100.0f, 100.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/sum"), 240.0f, 40.0f, 60.0f, 60.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/XboxOne_A"), 140.0f, 20.0f, 100.0f, 100.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/Keyboard_Black_A"), 300.0f, 120.0f, 100.0f, 100.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/sum"), 240.0f, 140.0f, 60.0f, 60.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/Keyboard_Black_Space"), 140.0f, 120.0f, 100.0f, 100.0f);
                break;
            }
            case TAP_RIGHT: {
                this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("Tutorial.TapRight"), 175.0f, AbstractMapController.getHEIGHT() - 105, 900.0f, 1, true);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/XboxOne_Dpad_Right"), 140.0f, 20.0f, 100.0f, 100.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/Keyboard_Black_D"), 140.0f, 120.0f, 100.0f, 100.0f);
                break;
            }
            case SWIPE_RIGHT_LEFT: {
                this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("Tutorial.SwipeRightLeft"), 175.0f, AbstractMapController.getHEIGHT() - 105, 900.0f, 1, true);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/XboxOne_Dpad_Left"), 300.0f, 20.0f, 100.0f, 100.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/sum"), 240.0f, 40.0f, 60.0f, 60.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/XboxOne_A"), 140.0f, 20.0f, 100.0f, 100.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/Keyboard_Black_A"), 300.0f, 120.0f, 100.0f, 100.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/sum"), 240.0f, 140.0f, 60.0f, 60.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/Keyboard_Black_Space"), 140.0f, 120.0f, 100.0f, 100.0f);
                break;
            }
            case SWIPE_RIGHT_RIGHT: {
                this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("Tutorial.SwipeRightRight"), 175.0f, AbstractMapController.getHEIGHT() - 105, 900.0f, 1, true);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/XboxOne_Dpad_Right"), 300.0f, 20.0f, 100.0f, 100.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/sum"), 240.0f, 40.0f, 60.0f, 60.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/XboxOne_A"), 140.0f, 20.0f, 100.0f, 100.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/Keyboard_Black_D"), 300.0f, 120.0f, 100.0f, 100.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/sum"), 240.0f, 140.0f, 60.0f, 60.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/Keyboard_Black_Space"), 140.0f, 120.0f, 100.0f, 100.0f);
                break;
            }
            case EXTENDED_MODE_GADGET: {
                this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("Tutorial.ExtendedModeGadget"), 175.0f, AbstractMapController.getHEIGHT() - 95, 900.0f, 1, true);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/XboxOne_B"), 140.0f, 20.0f, 100.0f, 100.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/Keyboard_Black_W"), 140.0f, 120.0f, 100.0f, 100.0f);
                this.drawExtendedTuto();
                break;
            }
            case FINISH: {
                this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("Tutorial.Finish"), 175.0f, AbstractMapController.getHEIGHT() - 95, 900.0f, 1, true);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/360_Start"), 140.0f, 20.0f, 100.0f, 100.0f);
                this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "/Tutorial/Keyboard_Black_Esc"), 140.0f, 120.0f, 100.0f, 100.0f);
                this.drawExtendedTuto();
            }
        }
        Assets.fontArialWhiteBig.setColor(Color.BLACK);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "MainMenu/buttonShortBig"), this.skipTutorial.getX(), this.skipTutorial.getY(), this.skipTutorial.getWidth(), this.skipTutorial.getHeight());
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "return"), this.skipTutorial.getX() + 8.0f, this.skipTutorial.getY() + 8.0f, 64.0f, 64.0f);
        Assets.fontArialWhiteBig.setColor(Color.WHITE);
    }

    private void checkGameMode() {
        if (this.currentHighScore == 0L) {
            this.currentHighScore = OrtiMain.getCurrentHighScore(this.worldReference.getGameState().getGameMode(), this.worldReference.getGameState().getGameType());
            switch (this.worldReference.getGameState().getGameMode()) {
                case ESCAPE: 
                case ESCAPE_CLAUSTRO: 
                case ESCAPE_VERY_CLAUSTRO: {
                    this.isEscapeMode = true;
                }
            }
        }
    }

    private void checkLevelLabel() {
        if (this.newLevelLabel) {
            this.levelTime += World.getDeltaTime();
            if (this.levelTime > 3.0f) {
                this.newLevelLabel = false;
            }
        } else if (this.lastLevel < this.worldReference.getGameState().getCurrentLevel()) {
            this.levelTime = 0.0f;
            this.newLevelLabel = true;
            this.lastLevel = this.worldReference.getGameState().getCurrentLevel();
        }
    }

    public void updateGUI(Vector3 touchPoint) {
        if (Gdx.input.isTouched() && this.skipTutorial != null && this.skipTutorial.contains(touchPoint.x, touchPoint.y)) {
            this.worldReference.getGameState().setRestartingGame();
        }
    }

    private void drawBase() {
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "WindowHTransparent"), 15.0f, 265.0f, 375.0f, 450.0f);
        this.drawAllGestures();
        String highScore = ISDLocale.LocaleInUse("GUI.MostBlocksAvoided") + ": ";
        String highType = "";
        String currentHigh = String.valueOf(this.currentHighScore);
        if (this.isEscapeMode) {
            highType = "";
            highScore = ISDLocale.LocaleInUse("GUI.BestEscapeTime") + ": ";
            currentHigh = this.currentHighScore > 0L ? this.df.format(this.currentHighScore) + " " + ISDLocale.LocaleInUse("GUI.Seconds") : ISDLocale.LocaleInUse("GUI.None");
        }
        this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("GUI.CurrentLevel") + ": " + String.valueOf(this.worldReference.getGameState().getCurrentLevel()), 25.0f, AbstractMapController.getHEIGHT() - 30, 360.0f, 8, true);
        this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("GUI.NoFallenBlocks") + ": " + String.valueOf(this.worldReference.getGameState().getNumFallenBlocks()), 25.0f, AbstractMapController.getHEIGHT() - 125, 360.0f, 8, true);
        this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("GUI.CurrentTime") + ": " + this.df.format(this.worldReference.getGameState().getTotalTime()), 25.0f, AbstractMapController.getHEIGHT() - 225, 360.0f, 8, true);
        this.drawToFontGui(Assets.fontArialWhite, highScore + currentHigh + highType, 25.0f, AbstractMapController.getHEIGHT() - 325, 360.0f, 8, true);
        if (this.newLevelLabel) {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "WindowHTransparent"), 140.0f, 125.0f, 245.0f, 125.0f);
            float lastLevel = 13.0f;
            if (this.worldReference.getGameState().getGameMode() == OrtiMain.GameModes.INFINITE_CLAUSTRO || this.worldReference.getGameState().getGameMode() == OrtiMain.GameModes.ESCAPE_CLAUSTRO || this.worldReference.getGameState().getGameMode() == OrtiMain.GameModes.TWO_PLAYERS) {
                lastLevel = 11.0f;
            } else if (this.worldReference.getGameState().getGameMode() == OrtiMain.GameModes.INFINITE_VERY_CLAUSTRO || this.worldReference.getGameState().getGameMode() == OrtiMain.GameModes.ESCAPE_VERY_CLAUSTRO) {
                lastLevel = 8.0f;
            }
            if ((float)this.worldReference.getGameState().getCurrentLevel() <= lastLevel) {
                this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("GUI.NewLevelFaster"), 150.0f, 225 + this.auxOffset, 225.0f, 1, true);
            } else {
                this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("GUI.NewLevel"), 150.0f, 225 + this.auxOffset, 225.0f, 1, true);
            }
            if (!this.skipOneOffset) {
                this.auxOffset = this.offSetGoingTop ? ++this.auxOffset : --this.auxOffset;
                if (this.auxOffset < -5 || this.auxOffset > 5) {
                    this.offSetGoingTop = !this.offSetGoingTop;
                }
            }
            boolean bl = this.skipOneOffset = !this.skipOneOffset;
        }
        if (this.worldReference.getGameState().isShowIntro()) {
            String gameMode = ISDLocale.LocaleInUse("GUI.Infinite");
            String intro = ISDLocale.LocaleInUse("GUI.InfiniteDesc");
            float width = 0.0f;
            float posx = 0.0f;
            switch (this.worldReference.getGameState().getGameMode()) {
                case ESCAPE: 
                case INFINITE: {
                    width = 9 * AbstractMapController.getSQUARE_SIZE();
                    posx = (this.camera.getMapCam().position.x + 3.0f) * (float)AbstractMapController.getSQUARE_SIZE();
                    break;
                }
                case ESCAPE_CLAUSTRO: 
                case INFINITE_CLAUSTRO: {
                    width = 7 * AbstractMapController.getSQUARE_SIZE();
                    posx = (this.camera.getMapCam().position.x + 3.25f) * (float)AbstractMapController.getSQUARE_SIZE();
                    break;
                }
                case ESCAPE_VERY_CLAUSTRO: 
                case INFINITE_VERY_CLAUSTRO: {
                    width = 5 * AbstractMapController.getSQUARE_SIZE();
                    posx = (this.camera.getMapCam().position.x + 7.1f) * (float)AbstractMapController.getSQUARE_SIZE();
                }
            }
            if (this.isEscapeMode) {
                gameMode = ISDLocale.LocaleInUse("GUI.Escape");
                intro = ISDLocale.LocaleInUse("GUI.EscapeDesc");
            }
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "WindowHTransparent"), posx - 15.0f, (float)AbstractMapController.getHEIGHT() - (float)AbstractMapController.getHEIGHT() / 5.0f - 135.0f, width + 30.0f, 180.0f);
            Assets.fontArialWhiteBig.getData().setScale(1.5f);
            this.drawToFontGui(Assets.fontArialWhiteBig, gameMode, posx, (float)AbstractMapController.getHEIGHT() - (float)AbstractMapController.getHEIGHT() / 5.0f + 20.0f, width, 1, true);
            Assets.fontArialWhiteBig.getData().setScale(1.0f);
            this.drawToFontGui(Assets.fontArialWhite, intro, posx, (float)AbstractMapController.getHEIGHT() - (float)AbstractMapController.getHEIGHT() / 5.0f - 60.0f, width, 1, true);
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "WindowHTransparent"), posx - 15.0f, (float)AbstractMapController.getHEIGHT() - (float)AbstractMapController.getHEIGHT() / 5.0f - 275.0f, width + 30.0f, 125.0f);
            this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("Tips.tip" + OrtiMain.getLatestTip()), posx, (float)AbstractMapController.getHEIGHT() - (float)AbstractMapController.getHEIGHT() / 5.0f - 160.0f, width, 1, true);
        }
        if (this.worldReference.getGameState().getGameType() == NewGameMenuController.Type.EXTENDED) {
            this.drawExtended();
        }
    }

    private void drawBaseTwoPlayers() {
        this.drawToFontGui(Assets.fontArialWhite, "Lv: " + String.valueOf(this.worldReference.getGameState().getCurrentLevel()), 25.0f, AbstractMapController.getHEIGHT() - 30, 360.0f, 8, true);
        if (this.worldReference.getGameState().isShowIntro()) {
            String gameMode = ISDLocale.LocaleInUse("GUI.InfiniteTwoPlayers");
            String intro = ISDLocale.LocaleInUse("GUI.InfiniteDescTwoPlayers");
            float width = 9.0f * ((float)AbstractMapController.getSQUARE_SIZE() * 1.5f);
            float posx = (this.camera.getMapCam().position.x + 1.0f) * (float)AbstractMapController.getSQUARE_SIZE() / 3.0f - 10.0f;
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "WindowHTransparent"), posx - 15.0f, (float)AbstractMapController.getHEIGHT() - (float)AbstractMapController.getHEIGHT() / 5.0f - 135.0f, width + 30.0f, 180.0f);
            Assets.fontArialWhiteBig.getData().setScale(1.5f);
            this.drawToFontGui(Assets.fontArialWhiteBig, gameMode, posx, (float)AbstractMapController.getHEIGHT() - (float)AbstractMapController.getHEIGHT() / 5.0f + 20.0f, width, 1, true);
            Assets.fontArialWhiteBig.getData().setScale(1.0f);
            this.drawToFontGui(Assets.fontArialWhite, intro, posx, (float)AbstractMapController.getHEIGHT() - (float)AbstractMapController.getHEIGHT() / 5.0f - 60.0f, width, 1, true);
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "WindowHTransparent"), posx - 15.0f, (float)AbstractMapController.getHEIGHT() - (float)AbstractMapController.getHEIGHT() / 5.0f - 275.0f, width + 30.0f, 125.0f);
            this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("Tips.tip2Player"), posx, (float)AbstractMapController.getHEIGHT() - (float)AbstractMapController.getHEIGHT() / 5.0f - 160.0f, width, 1, true);
        }
        this.drawExtendedTwoPlayers(this.worldReference.getGameState().getPlayerController());
        this.drawExtendedTwoPlayers(this.worldReference.getGameState().getPlayerController2());
        this.drawModifiers2Players();
        if (this.worldReference.getGameState().isGameOver()) {
            if (this.worldReference.getGameState().isPlayer1Crushed() && this.worldReference.getGameState().isPlayer2Crushed()) {
                this.drawVictory(0);
            } else if (this.worldReference.getGameState().isPlayer1Crushed()) {
                this.drawVictory(2);
            } else if (this.worldReference.getGameState().isPlayer2Crushed()) {
                this.drawVictory(1);
            }
        }
    }

    private void drawVictory(int numPlayerVictory) {
        float xStartingPlayer1 = 250.0f;
        float xStartingPlayer2 = 700.0f;
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "WindowHTransparent"), xStartingPlayer1, (float)AbstractMapController.getHEIGHT() - (float)AbstractMapController.getHEIGHT() / 5.0f - 55.0f, 350.0f, 100.0f);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "WindowHTransparent"), xStartingPlayer2, (float)AbstractMapController.getHEIGHT() - (float)AbstractMapController.getHEIGHT() / 5.0f - 55.0f, 350.0f, 100.0f);
        if (numPlayerVictory == 0) {
            this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("GUI.Draw"), xStartingPlayer1, (float)AbstractMapController.getHEIGHT() - (float)AbstractMapController.getHEIGHT() / 5.0f + 20.0f, 350.0f, 1, true);
            this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("GUI.Draw"), xStartingPlayer2, (float)AbstractMapController.getHEIGHT() - (float)AbstractMapController.getHEIGHT() / 5.0f + 20.0f, 350.0f, 1, true);
        } else {
            float xVictory;
            float xLosing;
            if (numPlayerVictory == 1) {
                xLosing = xStartingPlayer2;
                xVictory = xStartingPlayer1;
            } else {
                xLosing = xStartingPlayer1;
                xVictory = xStartingPlayer2;
            }
            this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("GUI.Victory"), xVictory, (float)AbstractMapController.getHEIGHT() - (float)AbstractMapController.getHEIGHT() / 5.0f + 20.0f, 350.0f, 1, true);
            this.drawToFontGui(Assets.fontArialWhiteBig, ISDLocale.LocaleInUse("GUI.Loss"), xLosing, (float)AbstractMapController.getHEIGHT() - (float)AbstractMapController.getHEIGHT() / 5.0f + 20.0f, 350.0f, 1, true);
        }
    }

    private void drawAllGestures() {
        if (OrtiMain.isMobile()) {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "tTap"), AbstractMapController.getWIDTH() - 125, 40.0f, 80.0f, 86.0f);
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "tTapI"), 40.0f, 40.0f, 80.0f, 86.0f);
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "tSwipeRight"), AbstractMapController.getWIDTH() - 125, 135.0f, 80.0f, 86.0f);
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "tSwipeLeft"), 40.0f, 135.0f, 80.0f, 86.0f);
        }
    }

    private void drawExtendedTwoPlayers(PlayerController playerController) {
        int startingX = playerController.getNumPlayer() == 1 ? 10 : AbstractMapController.getWIDTH() - 160;
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "WindowHTransparent"), startingX, AbstractMapController.getHEIGHT() - 250, 150.0f, 150.0f);
        if (playerController.getGadget() != null) {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.PLAYER_OBJECTS, playerController.getGadget().getTexture()), startingX + 20, AbstractMapController.getHEIGHT() - 220, 110.0f, 110.0f);
            this.drawToFontGui(Assets.fontArialWhite, String.valueOf(playerController.getNumGadgets()), startingX + 100, AbstractMapController.getHEIGHT() - 220, 40.0f, 1, true);
        }
    }

    private void drawModifiers2Players() {
        Assets.fontArialWhite.getData().setScale(0.6f);
        if (MapController.player1hasActivatedFreeze) {
            this.modifiersForP2 = modifiers2P.FREEZE;
            this.latestTimeShowModifierPlayer2 = 0.0f;
            MapController.player1hasActivatedFreeze = false;
        }
        if (MapController.player2hasActivatedFreeze) {
            this.modifiersForP1 = modifiers2P.FREEZE;
            this.latestTimeShowModifierPlayer1 = 0.0f;
            MapController.player2hasActivatedFreeze = false;
        }
        if (MapController.player1hasActivatedDoubleBlock) {
            this.modifiersForP2 = modifiers2P.DOUBLE;
            this.latestTimeShowModifierPlayer2 = 0.0f;
            MapController.player1hasActivatedDoubleBlock = false;
        }
        if (MapController.player2hasActivatedDoubleBlock) {
            this.modifiersForP1 = modifiers2P.DOUBLE;
            this.latestTimeShowModifierPlayer1 = 0.0f;
            MapController.player2hasActivatedDoubleBlock = false;
        }
        if (MapController.player1hasActivatedArtillery) {
            this.modifiersForP2 = modifiers2P.ARTILLERY;
            this.latestTimeShowModifierPlayer2 = 0.0f;
            MapController.player1hasActivatedArtillery = false;
        }
        if (MapController.player2hasActivatedArtillery) {
            this.modifiersForP1 = modifiers2P.ARTILLERY;
            this.latestTimeShowModifierPlayer1 = 0.0f;
            MapController.player2hasActivatedArtillery = false;
        }
        if (this.modifiersForP1 != null) {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "WindowHTransparent"), 10.0f, AbstractMapController.getHEIGHT() - 470, 150.0f, 200.0f);
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GAME, this.selectTextureModifierP2(this.modifiersForP1)), 21.0f, AbstractMapController.getHEIGHT() - 439, 128.0f, 128.0f);
            this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("GUI.player2HasActivated"), 21.0f, AbstractMapController.getHEIGHT() - 280, 130.0f, 1, true);
            this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("GUI." + this.selectTextureModifierP2(this.modifiersForP1)), 21.0f, AbstractMapController.getHEIGHT() - 440, 130.0f, 1, true);
            this.latestTimeShowModifierPlayer1 += World.getDeltaTime();
            if (this.latestTimeShowModifierPlayer1 > 5.0f) {
                this.modifiersForP1 = null;
            }
        }
        if (this.modifiersForP2 != null) {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "WindowHTransparent"), AbstractMapController.getWIDTH() - 160, AbstractMapController.getHEIGHT() - 470, 150.0f, 200.0f);
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GAME, this.selectTextureModifierP2(this.modifiersForP2)), AbstractMapController.getWIDTH() - 149, AbstractMapController.getHEIGHT() - 439, 128.0f, 128.0f);
            this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("GUI.player1HasActivated"), AbstractMapController.getWIDTH() - 149, AbstractMapController.getHEIGHT() - 280, 130.0f, 1, true);
            this.drawToFontGui(Assets.fontArialWhite, ISDLocale.LocaleInUse("GUI." + this.selectTextureModifierP2(this.modifiersForP2)), AbstractMapController.getWIDTH() - 149, AbstractMapController.getHEIGHT() - 440, 130.0f, 1, true);
            this.latestTimeShowModifierPlayer2 += World.getDeltaTime();
            if (this.latestTimeShowModifierPlayer2 > 5.0f) {
                this.modifiersForP2 = null;
            }
        }
        Assets.fontArialWhite.getData().setScale(1.0f);
    }

    private String selectTextureModifierP2(modifiers2P modifiers2P2) {
        switch (modifiers2P2) {
            case FREEZE: {
                return "2pFreeze";
            }
            case ARTILLERY: {
                return "2pArtillery";
            }
            case DOUBLE: {
                return "2pDouble";
            }
        }
        return null;
    }

    private void drawExtended() {
        if (this.worldReference.getGameState().getSelectedObjectModifier() != null || this.worldReference.getGameState().getSelectedGadget() != null) {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "WindowHTransparent"), AbstractMapController.getWIDTH() - 175, AbstractMapController.getHEIGHT() - 350, 150.0f, 300.0f);
        }
        if (this.worldReference.getGameState().getSelectedObjectModifier() != null) {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.PLAYER_OBJECTS, this.worldReference.getGameState().getSelectedObjectModifier().getTexture()), AbstractMapController.getWIDTH() - 150, AbstractMapController.getHEIGHT() - 175, 100.0f, 100.0f);
        }
        if (this.worldReference.getGameState().getSelectedGadget() != null) {
            this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.PLAYER_OBJECTS, this.worldReference.getGameState().getSelectedGadget().getTexture()), AbstractMapController.getWIDTH() - 155, AbstractMapController.getHEIGHT() - 320, 110.0f, 110.0f);
            this.drawToFontGui(Assets.fontArialWhite, String.valueOf(this.worldReference.getGameState().getPlayerController().getNumGadgets()), AbstractMapController.getWIDTH() - 75, AbstractMapController.getHEIGHT() - 320, 40.0f, 1, true);
        }
    }

    private void drawExtendedTuto() {
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.GUI, "WindowHTransparent"), AbstractMapController.getWIDTH() - 175, AbstractMapController.getHEIGHT() - 350, 150.0f, 150.0f);
        this.drawToGui(Assets.returnTexture(Assets.ObjectTypes.PLAYER_OBJECTS, GadgetLoader.allGadgets.get(1).getTexture()), AbstractMapController.getWIDTH() - 155, AbstractMapController.getHEIGHT() - 320, 110.0f, 110.0f);
        this.drawToFontGui(Assets.fontArialWhite, String.valueOf(this.worldReference.getGameState().getPlayerController().getNumGadgets()), AbstractMapController.getWIDTH() - 75, AbstractMapController.getHEIGHT() - 320, 40.0f, 1, true);
    }

    private void drawBackground() {
        this.drawToGui(Assets.getCurrentBG(), 0.0f, 0.0f, 1280.0f, 720.0f);
    }

    private static enum modifiers2P {
        FREEZE,
        DOUBLE,
        ARTILLERY;

    }
}

