/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.controllers.PovDirection;
import com.badlogic.gdx.math.Vector3;
import com.ortisoft.ortilator.Game;
import com.ortisoft.ortilator.OrtiMain;
import com.ortisoft.ortilator.controllers.AbstractHandling;
import com.ortisoft.ortilator.controllers.gamePad.XBox360Pad;
import com.ortisoft.ortilator.stateControls.GameState;

public class CameraControllerDesktop
extends AbstractHandling
implements InputProcessor,
ControllerListener {
    public CameraControllerDesktop(Game game, OrtiMain.GameModes gameMode) {
        super(game, gameMode);
        Controllers.clearListeners();
        Controllers.addListener(this);
        Gdx.input.setInputProcessor(this);
    }

    @Override
    public boolean keyDown(int keycode) {
        if (this.game == null || this.game.getMain() == null || this.game.getMain().getLoadedWorld() == null || this.game.getMain().getLoadedWorld().getGameState() == null || this.game.getMain().getLoadedWorld().getGameState().isExiting()) {
            return false;
        }
        if (!this.game.getMain().getLoadedWorld().getGameState().isShowGeneralMenu() && this.game.getMain().getLoadedWorld().getGameState().getCurrentMenu() != GameState.Menu.INGAME_MENU && this.game.getMain().getLoadedWorld().getGameState().getCurrentMenu() != GameState.Menu.INGAME_MENU_GAME_OVER) {
            boolean push = false;
            if (Gdx.input.isKeyPressed(62) || Gdx.input.isKeyPressed(66)) {
                push = true;
            }
            if (keycode == 32 || keycode == 22) {
                super.movePlayer(null, 1, push);
                return true;
            }
            if (keycode == 29 || keycode == 21) {
                super.movePlayer(null, -1, push);
                return true;
            }
            if (keycode == 51 || keycode == 19) {
                super.useGadget(null);
                return true;
            }
        } else {
            if (keycode == 32 || keycode == 22) {
                super.moveMenu(null, 1, 0);
                return true;
            }
            if (keycode == 29 || keycode == 21) {
                super.moveMenu(null, -1, 0);
                return true;
            }
            if (keycode == 51 || keycode == 19) {
                super.moveMenu(null, 0, -1);
                return true;
            }
            if (keycode == 47 || keycode == 20) {
                super.moveMenu(null, 0, 1);
                return true;
            }
            if (keycode == 62 || keycode == 66) {
                super.selectMenu(null);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        if (Gdx.input.isKeyPressed(131)) {
            super.exitMenu(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return true;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return true;
    }

    @Override
    public void connected(Controller controller) {
    }

    @Override
    public void disconnected(Controller controller) {
    }

    @Override
    public boolean buttonDown(Controller controller, int buttonCode) {
        if (!this.game.getMain().getLoadedWorld().getGameState().isShowGeneralMenu() && this.game.getMain().getLoadedWorld().getGameState().getCurrentMenu() != GameState.Menu.INGAME_MENU && this.game.getMain().getLoadedWorld().getGameState().getCurrentMenu() != GameState.Menu.INGAME_MENU_GAME_OVER) {
            if (buttonCode == 1) {
                super.useGadget(controller);
                return true;
            }
            if (buttonCode == 7) {
                super.exitMenu(controller);
                return true;
            }
        } else {
            if (buttonCode == 0) {
                super.selectMenu(controller);
                return true;
            }
            if (buttonCode == 1) {
                super.exitMenu(controller);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean buttonUp(Controller controller, int buttonCode) {
        return false;
    }

    @Override
    public boolean axisMoved(Controller controller, int axisCode, float value) {
        return false;
    }

    @Override
    public boolean povMoved(Controller controller, int povCode, PovDirection value) {
        if (!this.game.getMain().getLoadedWorld().getGameState().isShowGeneralMenu() && this.game.getMain().getLoadedWorld().getGameState().getCurrentMenu() != GameState.Menu.INGAME_MENU && this.game.getMain().getLoadedWorld().getGameState().getCurrentMenu() != GameState.Menu.INGAME_MENU_GAME_OVER) {
            boolean push = false;
            if (controller.getButton(0)) {
                push = true;
            }
            if (value == XBox360Pad.BUTTON_DPAD_RIGHT) {
                super.movePlayer(controller, 1, push);
                return true;
            }
            if (value == XBox360Pad.BUTTON_DPAD_LEFT) {
                super.movePlayer(controller, -1, push);
                return true;
            }
        } else {
            if (value == XBox360Pad.BUTTON_DPAD_RIGHT) {
                super.moveMenu(controller, 1, 0);
                return true;
            }
            if (value == XBox360Pad.BUTTON_DPAD_LEFT) {
                super.moveMenu(controller, -1, 0);
                return true;
            }
            if (value == XBox360Pad.BUTTON_DPAD_UP) {
                super.moveMenu(controller, 0, -1);
                return true;
            }
            if (value == XBox360Pad.BUTTON_DPAD_DOWN) {
                super.moveMenu(controller, 0, 1);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean xSliderMoved(Controller controller, int sliderCode, boolean value) {
        return false;
    }

    @Override
    public boolean ySliderMoved(Controller controller, int sliderCode, boolean value) {
        return false;
    }

    @Override
    public boolean accelerometerMoved(Controller controller, int accelerometerCode, Vector3 value) {
        return false;
    }
}

