/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers;

import com.ortisoft.ortilator.OrtiMain;
import com.ortisoft.ortilator.controllers.AbstractMapController;
import com.ortisoft.ortilator.controllers.MapController;
import com.ortisoft.ortilator.controllers.PlayerController;
import com.ortisoft.ortilator.entities.Block;
import com.ortisoft.ortilator.entities.blocks.ActualBlock;
import com.ortisoft.ortilator.world.RandomSeed;
import com.ortisoft.ortilator.world.World;
import com.ortisoft.ortilator.world.loaders.BlockLoader;
import java.util.ArrayList;

public class BlockController {
    private float latestTimeBlock;
    private float currentBlockTime;
    private int currentLevel = 1;
    private ArrayList<Integer> aux = new ArrayList();
    private OrtiMain.GameModes gameMode;
    private float massDestroyActionCoolDown = 0.0f;
    private float massDestroyActionCoolDown2 = 0.0f;
    private float minBlockTime = 1.0f;
    private float maxBlockTime = 1.0f;
    private float subBlockTime = 1.0f;
    private int latestRow;

    public float getMassDestroyActionCoolDown() {
        return this.massDestroyActionCoolDown;
    }

    public float getMassDestroyActionCoolDown2() {
        return this.massDestroyActionCoolDown2;
    }

    public BlockController(OrtiMain.GameModes gameMode) {
        this.gameMode = gameMode;
        this.initializeGameParams();
    }

    private void initializeGameParams() {
        switch (this.gameMode) {
            case INFINITE: 
            case ESCAPE: {
                this.minBlockTime = 0.62f;
                this.maxBlockTime = 1.45f;
                this.subBlockTime = 0.17f;
                break;
            }
            case INFINITE_CLAUSTRO: 
            case ESCAPE_CLAUSTRO: 
            case TWO_PLAYERS: {
                this.minBlockTime = 0.5f;
                this.maxBlockTime = 1.35f;
                this.subBlockTime = 0.195f;
                break;
            }
            case INFINITE_VERY_CLAUSTRO: 
            case ESCAPE_VERY_CLAUSTRO: {
                this.minBlockTime = 0.45f;
                this.maxBlockTime = 1.25f;
                this.subBlockTime = 0.22f;
            }
        }
        this.currentBlockTime = this.maxBlockTime;
    }

    public void setModifierSpeed(float modifierSpeed) {
        this.currentBlockTime += modifierSpeed;
        this.maxBlockTime += modifierSpeed;
    }

    public void checkCreationBlock(int currentLevel, boolean twoPlayerMode) {
        this.checkLevel(currentLevel);
        if (this.latestTimeBlock > this.currentBlockTime) {
            if (!twoPlayerMode) {
                this.createBlock(twoPlayerMode, 0, AbstractMapController.getMAP_WIDTH());
            } else {
                this.createBlock(twoPlayerMode, 0, 8);
                if (MapController.getExtraBlocksPlayer1() > 0) {
                    this.createBlock(twoPlayerMode, 0, 8);
                    MapController.removeExtraBlock(1);
                }
                this.createBlock(twoPlayerMode, 9, AbstractMapController.getMAP_WIDTH());
                if (MapController.getExtraBlocksPlayer2() > 0) {
                    this.createBlock(twoPlayerMode, 9, AbstractMapController.getMAP_WIDTH());
                    MapController.removeExtraBlock(2);
                }
            }
            this.latestTimeBlock = 0.0f;
        } else {
            this.latestTimeBlock += World.getDeltaTime();
        }
    }

    public boolean checkGameConditions(PlayerController playerController, float delta) {
        switch (this.gameMode) {
            case INFINITE: 
            case INFINITE_CLAUSTRO: 
            case TWO_PLAYERS: 
            case INFINITE_VERY_CLAUSTRO: {
                this.checkMaxBlock(delta, playerController.getNumPlayer());
                break;
            }
            case ESCAPE: 
            case ESCAPE_CLAUSTRO: 
            case ESCAPE_VERY_CLAUSTRO: {
                return this.checkPlayerEscape(playerController);
            }
        }
        return false;
    }

    private boolean checkPlayerEscape(PlayerController playerController) {
        return playerController.getPositionY() >= (float)(AbstractMapController.getMAP_HEIGHT() - 2);
    }

    private void checkMaxBlock(float delta, int numPlayer) {
        int latestBlockToCheck;
        int firstBlockToCheck;
        int numBlocks = 0;
        int i = 0;
        if (numPlayer == 1) {
            this.massDestroyActionCoolDown += delta;
            if (MapController.readAndResetRetardEffectMassDestructionPlayer1()) {
                this.massDestroyActionCoolDown = -5.0f;
            }
            if (this.massDestroyActionCoolDown < 3.0f) {
                return;
            }
        } else {
            this.massDestroyActionCoolDown2 += delta;
            if (MapController.readAndResetRetardEffectMassDestructionPlayer2()) {
                this.massDestroyActionCoolDown2 = -5.0f;
            }
            if (this.massDestroyActionCoolDown2 < 3.0f) {
                return;
            }
        }
        if (this.gameMode == OrtiMain.GameModes.TWO_PLAYERS) {
            if (numPlayer == 1) {
                firstBlockToCheck = 0;
                latestBlockToCheck = (int)Math.floor(8.0) + 1;
            } else {
                firstBlockToCheck = (int)Math.floor(8.0) + 1;
                latestBlockToCheck = AbstractMapController.getMAP_WIDTH() + 1;
            }
        } else {
            firstBlockToCheck = 0;
            latestBlockToCheck = AbstractMapController.getMAP_WIDTH() + 1;
        }
        for (ActualBlock[] entry : MapController.getActualBlocks()) {
            ActualBlock actualBlock;
            if (i > firstBlockToCheck && i < latestBlockToCheck && (actualBlock = entry[Math.round((float)AbstractMapController.getMAP_HEIGHT() / 2.0f)]) != null && !actualBlock.isMoving()) {
                ++numBlocks;
            }
            ++i;
        }
        boolean destroyLine = false;
        switch (this.gameMode) {
            case INFINITE: {
                destroyLine = numBlocks >= 5;
                break;
            }
            case INFINITE_CLAUSTRO: 
            case TWO_PLAYERS: {
                destroyLine = numBlocks >= 4;
                break;
            }
            case INFINITE_VERY_CLAUSTRO: {
                boolean bl = destroyLine = numBlocks >= 3;
            }
        }
        if (destroyLine) {
            if (this.gameMode == OrtiMain.GameModes.TWO_PLAYERS) {
                if (numPlayer == 1) {
                    this.massDestroyActionCoolDown = 0.0f;
                    MapController.deleteRow(Math.round((float)AbstractMapController.getMAP_HEIGHT() / 2.0f), firstBlockToCheck + 1, latestBlockToCheck);
                } else {
                    this.massDestroyActionCoolDown2 = 0.0f;
                    MapController.deleteRow(Math.round((float)AbstractMapController.getMAP_HEIGHT() / 2.0f), firstBlockToCheck + 1, latestBlockToCheck);
                }
            } else {
                this.massDestroyActionCoolDown = 0.0f;
                MapController.deleteRow(Math.round((float)AbstractMapController.getMAP_HEIGHT() / 2.0f));
            }
        }
    }

    private void createBlock(boolean isTwoPlayer, int minX, int maxX) {
        int id = MapController.getAndSetIdCounter();
        int x = 0;
        this.aux.clear();
        this.refillAux(minX, maxX);
        while (this.aux.size() > 0) {
            int ran = RandomSeed.getRan().nextInt(this.aux.size());
            x = this.aux.get(ran) + 1;
            if (MapController.getActualBlocks()[x][AbstractMapController.getMAP_HEIGHT() - 2] == null && this.latestRow != x) break;
            if (this.latestRow == x) {
                if (isTwoPlayer) continue;
                this.latestRow = -1;
                continue;
            }
            this.aux.remove(ran);
        }
        if (this.aux.size() == 0) {
            return;
        }
        this.latestRow = x;
        Block blockDataToAdd = isTwoPlayer ? BlockLoader.allBlocks.get(RandomSeed.getRan().nextInt(4) + 1) : BlockLoader.allBlocks.get(RandomSeed.getRan().nextInt(6) + 1);
        ActualBlock actualBlockToAdd = MapController.returnNewBlock(id, x, AbstractMapController.getMAP_HEIGHT(), blockDataToAdd, this.gameMode == OrtiMain.GameModes.TWO_PLAYERS);
        MapController.addBlock(actualBlockToAdd, true);
    }

    private void refillAux(int minX, int maxX) {
        for (int i = minX; i < maxX; ++i) {
            this.aux.add(i);
        }
    }

    private void checkLevel(int currentLevel) {
        if (this.currentLevel != currentLevel) {
            this.currentLevel = currentLevel;
            if (this.currentBlockTime > this.minBlockTime) {
                this.currentBlockTime = this.maxBlockTime - this.subBlockTime * (float)this.currentLevel;
                if (this.currentBlockTime < this.minBlockTime) {
                    this.currentBlockTime = this.minBlockTime;
                    switch (this.gameMode) {
                        case INFINITE: 
                        case ESCAPE: {
                            this.minBlockTime = 0.22f;
                            this.subBlockTime = 0.045f;
                            break;
                        }
                        case INFINITE_CLAUSTRO: 
                        case ESCAPE_CLAUSTRO: 
                        case TWO_PLAYERS: {
                            this.minBlockTime = 0.245f;
                            this.subBlockTime = 0.05f;
                            break;
                        }
                        case INFINITE_VERY_CLAUSTRO: 
                        case ESCAPE_VERY_CLAUSTRO: {
                            this.minBlockTime = 0.27f;
                            this.subBlockTime = 0.055f;
                        }
                    }
                }
            }
        }
    }

    public void checkBlocksMovement() {
        for (int i = MapController.getAuxMoving().size() - 1; i >= 0; --i) {
            MapController.getAuxMoving().get(i).checkMovement();
        }
    }

    public void checkDestroyed() {
        MapController.destroyAction();
    }

    public boolean checkPlayerCollision(PlayerController playerController) {
        boolean collision;
        float xToCheck = playerController.getPositionX() + playerController.getWidth() / 2.0f;
        float yToCheck = playerController.getPositionY() + playerController.getHeight() / 2.0f;
        if (playerController.getPositionY() + 1.0f <= (float)(AbstractMapController.getMAP_HEIGHT() - 1)) {
            collision = this.checkCollision(MapController.getActualBlocks()[(int)playerController.getLatestCompleteX()][(int)playerController.getLatestCompleteY() + 1], xToCheck, yToCheck);
            if (collision) {
                return true;
            }
            collision = this.checkCollision(MapController.getActualBlocks()[(int)playerController.getLatestCompleteX() + 1][(int)playerController.getLatestCompleteY() + 1], xToCheck, yToCheck);
            if (collision) {
                return true;
            }
            collision = this.checkCollision(MapController.getActualBlocks()[(int)playerController.getLatestCompleteX() - 1][(int)playerController.getLatestCompleteY() + 1], xToCheck, yToCheck);
            if (collision) {
                return true;
            }
        }
        if (collision = this.checkCollision(MapController.getActualBlocks()[(int)playerController.getLatestCompleteX() + 1][(int)playerController.getLatestCompleteY()], xToCheck, yToCheck)) {
            return true;
        }
        collision = this.checkCollision(MapController.getActualBlocks()[(int)playerController.getLatestCompleteX() - 1][(int)playerController.getLatestCompleteY()], xToCheck, yToCheck);
        return collision;
    }

    private boolean checkCollision(ActualBlock actualBlock, float xToCheck, float yToCheck) {
        return actualBlock != null && actualBlock.isMoving() && actualBlock.getRectangleHitPoint().contains(xToCheck, yToCheck);
    }
}

