/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers;

import com.badlogic.gdx.controllers.Controller;
import com.ortisoft.ortilator.Game;
import com.ortisoft.ortilator.OrtiMain;
import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.controllers.AbstractCameraController;
import com.ortisoft.ortilator.controllers.menu.NewGameMenuController;
import com.ortisoft.ortilator.stateControls.GameState;
import com.ortisoft.ortilator.world.World;

public abstract class AbstractHandling
extends AbstractCameraController {
    AbstractHandling(Game game, OrtiMain.GameModes gameMode) {
        super(game, gameMode);
    }

    protected void movePlayer(Controller controller, int x, boolean push) {
        if (this.isTheGameActive()) {
            if (this.tutorialInvalidKey(x, push)) {
                return;
            }
            if (this.game.getMain().getLoadedWorld().getGameState().getGameMode() == OrtiMain.GameModes.TWO_PLAYERS) {
                if (controller == null && this.game.getMain().getLoadedWorld().getGameState().getPlayerController().getControllerNameTwoPlayers() instanceof String) {
                    this.game.getMain().getLoadedWorld().getGameState().getPlayerController().moveObject(x, false, push);
                } else {
                    int numPlayer = this.returnNumPlayerController(controller);
                    if (numPlayer == 1) {
                        this.game.getMain().getLoadedWorld().getGameState().getPlayerController().moveObject(x, false, push);
                    } else if (numPlayer == 2) {
                        this.game.getMain().getLoadedWorld().getGameState().getPlayerController2().moveObject(x, false, push);
                    }
                }
            } else {
                this.game.getMain().getLoadedWorld().getGameState().getPlayerController().moveObject(x, false, push);
            }
        }
    }

    protected void moveMenu(Controller controller, int column, int line) {
        if (this.game.getMain().getLoadedWorld().getGameState().getMainMenuController().isNewMenuSelectedAndTwoPlayers() && !this.isTheGameActive()) {
            int numPlayer;
            if (controller == null && this.game.getMain().getLoadedWorld().getGameState().getPlayerController().getControllerNameTwoPlayers() instanceof String) {
                this.game.getMain().getLoadedWorld().getGameState().getMainMenuController().returnCurrentNewGameController().moveSelectorTwoPlayer(1, column);
            } else if (controller != null && (numPlayer = this.returnNumPlayerController(controller)) > 0) {
                this.game.getMain().getLoadedWorld().getGameState().getMainMenuController().returnCurrentNewGameController().moveSelectorTwoPlayer(numPlayer, column);
            }
        } else {
            this.game.getMain().getLoadedWorld().getGameState().moveCorrectMenu(column, line);
        }
        this.game.getMain().getLoadedWorld().getGameState().hideMouse();
        Assets.sound(Assets.Sounds.MENU_MOVEMENT);
    }

    protected void selectMenu(Controller controller) {
        if (this.game.isShowIntro()) {
            this.game.getMain().getLoadedWorld().finishIntro();
            return;
        }
        if (this.game.getMain().getLoadedWorld().getGameState().getMainMenuController().isNewMenuSelectedAndTwoPlayers() && !this.isTheGameActive()) {
            if (this.game.getMain().getLoadedWorld().getGameState().getPlayerController2() == null) {
                this.game.getMain().getLoadedWorld().getGameState().resetPlayerControllersForTwoPlayers();
            }
            if (this.game.getMain().getLoadedWorld().getGameState().getPlayerController().getControllerNameTwoPlayers() == null) {
                if (controller == null) {
                    this.game.getMain().getLoadedWorld().getGameState().getPlayerController().setControllerNameTwoPlayers("keyboard");
                    this.game.getMain().getLoadedWorld().getGameState().getMainMenuController().returnCurrentNewGameController().setControllerPlayer1("keyboard");
                } else {
                    this.game.getMain().getLoadedWorld().getGameState().getPlayerController().setControllerNameTwoPlayers(controller);
                    this.game.getMain().getLoadedWorld().getGameState().getMainMenuController().returnCurrentNewGameController().setControllerPlayer1(controller.getName());
                }
            } else if (controller != null && this.game.getMain().getLoadedWorld().getGameState().getPlayerController().getControllerNameTwoPlayers() != null && controller == this.game.getMain().getLoadedWorld().getGameState().getPlayerController().getControllerNameTwoPlayers() || controller == null && this.game.getMain().getLoadedWorld().getGameState().getPlayerController().getControllerNameTwoPlayers() instanceof String) {
                this.game.getMain().getLoadedWorld().getGameState().getMainMenuController().returnCurrentNewGameController().selectButtonTwoPlayers(1);
            } else if (controller != null && this.game.getMain().getLoadedWorld().getGameState().getPlayerController2().getControllerNameTwoPlayers() == null) {
                this.game.getMain().getLoadedWorld().getGameState().getPlayerController2().setControllerNameTwoPlayers(controller);
                this.game.getMain().getLoadedWorld().getGameState().getMainMenuController().returnCurrentNewGameController().setControllerPlayer2(controller.getName());
            } else if (controller != null && this.game.getMain().getLoadedWorld().getGameState().getPlayerController2().getControllerNameTwoPlayers() != null && controller == this.game.getMain().getLoadedWorld().getGameState().getPlayerController2().getControllerNameTwoPlayers()) {
                this.game.getMain().getLoadedWorld().getGameState().getMainMenuController().returnCurrentNewGameController().selectButtonTwoPlayers(2);
            }
        } else {
            this.game.getMain().getLoadedWorld().getGameState().selectCorrectMenu();
        }
        Assets.sound(Assets.Sounds.FALLING_BLOCK);
    }

    private boolean tutorialInvalidKey(int x, boolean push) {
        if (this.game.getMain().getLoadedWorld().getGameState().getTutorialShow()) {
            switch (this.game.getMain().getLoadedWorld().getGameState().getCurrentTutoSteps()) {
                case TAP_LEFT: {
                    if (!push && x <= 0) break;
                    return true;
                }
                case SWIPE_LEFT_RIGHT: {
                    if (push && x >= 0) break;
                    return true;
                }
                case SWIPE_LEFT_LEFT: {
                    if (push && x <= 0) break;
                    return true;
                }
                case TAP_RIGHT: {
                    if (!push && x >= 0) break;
                    return true;
                }
                case SWIPE_RIGHT_LEFT: {
                    if (push && x <= 0) break;
                    return true;
                }
                case SWIPE_RIGHT_RIGHT: {
                    if (push && x >= 0) break;
                    return true;
                }
                case EXTENDED_MODE_GADGET: {
                    return true;
                }
            }
        }
        return false;
    }

    void exitMenu(Controller controller) {
        if (this.game.isShowIntro()) {
            this.game.getMain().getLoadedWorld().finishIntro();
            return;
        }
        if (!this.game.getMain().getLoadedWorld().getGameState().getMainMenuController().isNewMenuSelectedAndTwoPlayers() || this.isTheGameActive()) {
            World.closeCommand();
        } else if (this.game.getMain().getLoadedWorld().getGameState().getMainMenuController().isNewMenuSelectedAndTwoPlayers()) {
            if (controller == null && this.game.getMain().getLoadedWorld().getGameState().getPlayerController() != null && this.game.getMain().getLoadedWorld().getGameState().getPlayerController().getControllerNameTwoPlayers() instanceof String) {
                if (this.game.getMain().getLoadedWorld().getGameState().getMainMenuController().returnCurrentNewGameController().cancelButtonTwoPlayerMode(1)) {
                    this.game.getMain().getLoadedWorld().getGameState().getPlayerController().setControllerNameTwoPlayers(null);
                }
            } else if (controller == null && (this.game.getMain().getLoadedWorld().getGameState().getPlayerController() == null || this.game.getMain().getLoadedWorld().getGameState().getPlayerController().getControllerNameTwoPlayers() == null)) {
                World.closeCommand();
            } else if (controller != null) {
                int numPlayer = this.returnNumPlayerController(controller);
                if (numPlayer > 0) {
                    if (this.game.getMain().getLoadedWorld().getGameState().getMainMenuController().returnCurrentNewGameController().cancelButtonTwoPlayerMode(numPlayer)) {
                        if (numPlayer == 1) {
                            this.game.getMain().getLoadedWorld().getGameState().getPlayerController().setControllerNameTwoPlayers(null);
                        } else {
                            this.game.getMain().getLoadedWorld().getGameState().getPlayerController2().setControllerNameTwoPlayers(null);
                        }
                    }
                } else if (this.game.getMain().getLoadedWorld().getGameState().getPlayerController() == null || this.game.getMain().getLoadedWorld().getGameState().getPlayerController().getControllerNameTwoPlayers() == null) {
                    World.closeCommand();
                }
            }
        }
    }

    private int returnNumPlayerController(Controller controller) {
        if (this.game.getMain().getLoadedWorld().getGameState().getPlayerController() != null && this.game.getMain().getLoadedWorld().getGameState().getPlayerController().getControllerNameTwoPlayers() == controller) {
            return 1;
        }
        if (this.game.getMain().getLoadedWorld().getGameState().getPlayerController2() != null && this.game.getMain().getLoadedWorld().getGameState().getPlayerController2().getControllerNameTwoPlayers() == controller) {
            return 2;
        }
        return 0;
    }

    public boolean isTheGameActive() {
        return !this.game.getMain().getLoadedWorld().getGameState().isGameOver() && !this.game.getMain().getLoadedWorld().getGameState().isRestarting() && !this.game.getMain().getLoadedWorld().getGameState().isRestartingGame() && !this.game.getMain().getLoadedWorld().getGameState().isShowGeneralMenu() && this.game.getMain().getLoadedWorld().getGameState().getCurrentMenu() == GameState.Menu.GAME;
    }

    public void useGadget(Controller controller) {
        if (this.game.getMain().getLoadedWorld().getGameState().getTutorialShow() && this.game.getMain().getLoadedWorld().getGameState().getCurrentTutoSteps() != GameState.TutoSteps.EXTENDED_MODE_GADGET && this.game.getMain().getLoadedWorld().getGameState().getCurrentTutoSteps() != GameState.TutoSteps.FINISH) {
            return;
        }
        if ((this.game.getMain().getLoadedWorld().getGameState().getGameType() == NewGameMenuController.Type.EXTENDED || this.game.getMain().getLoadedWorld().getGameState().getTutorialShow()) && this.isTheGameActive()) {
            if (this.game.getMain().getLoadedWorld().getGameState().getGameMode() == OrtiMain.GameModes.TWO_PLAYERS) {
                if (controller == null && this.game.getMain().getLoadedWorld().getGameState().getPlayerController().getControllerNameTwoPlayers() instanceof String) {
                    this.game.getMain().getLoadedWorld().getGameState().getPlayerController().useEquippedGadget();
                } else if (controller == this.game.getMain().getLoadedWorld().getGameState().getPlayerController().getControllerNameTwoPlayers()) {
                    this.game.getMain().getLoadedWorld().getGameState().getPlayerController().useEquippedGadget();
                } else if (controller == this.game.getMain().getLoadedWorld().getGameState().getPlayerController2().getControllerNameTwoPlayers()) {
                    this.game.getMain().getLoadedWorld().getGameState().getPlayerController2().useEquippedGadget();
                }
            } else {
                this.game.getMain().getLoadedWorld().getGameState().getPlayerController().useEquippedGadget();
            }
        }
    }
}

