/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;

public abstract class AbstractDrawController {
    protected SpriteBatch guiBatch = new SpriteBatch();
    protected SpriteBatch mapBatch = new SpriteBatch();
    protected ShapeRenderer shapeRendererCircle;

    public AbstractDrawController() {
    }

    public AbstractDrawController(SpriteBatch guiBatch) {
        this.guiBatch = guiBatch;
    }

    protected void startBatch(SpriteBatch batch, Camera camera) {
        batch.setProjectionMatrix(camera.combined);
        batch.begin();
    }

    protected void endBatch(SpriteBatch batch) {
        batch.end();
    }

    protected void drawToMap(Texture texture, float x, float y, float width, float height) {
        this.mapBatch.draw(texture, x, y, width, height);
    }

    protected void drawToMap(Texture texture, float x, float y, float width, float height, double direction) {
        this.mapBatch.draw(texture, x, y, width / 2.0f, height / 2.0f, width, height, 1.0f, 1.0f, (float)direction, 0, 0, texture.getWidth(), texture.getHeight(), true, false);
    }

    protected void drawToMapRotateFromBegining(Texture texture, float x, float y, float width, float height, double direction) {
        this.mapBatch.draw(texture, x, y, 0.0f, height / 2.0f, width, height, 1.0f, 1.0f, (float)direction, 0, 0, texture.getWidth(), texture.getHeight(), true, false);
    }

    protected void drawToGui(Texture texture, float x, float y, float width, float height) {
        this.guiBatch.draw(texture, x, y, width, height);
    }

    protected void drawToGui(Texture texture, float x, float y, float width, float height, double direction) {
        this.drawToGui(texture, x, y, width, height, direction, false);
    }

    protected void drawToGui(Texture texture, float x, float y, float width, float height, double direction, boolean cropVertical) {
        int textureHeight = texture.getHeight();
        int xOffset = 0;
        if (cropVertical && texture.getHeight() != texture.getWidth()) {
            textureHeight = texture.getWidth();
            xOffset = (int)(width / 4.0f);
        }
        this.guiBatch.draw(texture, x + (float)xOffset, y, width / 2.0f, height / 2.0f, width, height, 1.0f, 1.0f, (float)direction, 0, 0, texture.getWidth(), textureHeight, true, false);
    }

    protected void drawToGui(Texture texture, float x, float y) {
        this.guiBatch.draw(texture, x, y);
    }

    protected void drawToFontGui(BitmapFont fontToUse, String text, float x, float y, float width, int align, boolean wrap) {
        fontToUse.draw(this.guiBatch, text, x, y, width, align, wrap);
    }

    protected void drawToFontMap(BitmapFont fontToUse, String text, float x, float y, float width, int align, boolean wrap) {
        fontToUse.draw(this.mapBatch, text, x, y, width, align, wrap);
    }
}

