/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.controllers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.ortisoft.ortilator.Game;
import com.ortisoft.ortilator.OrtiMain;
import com.ortisoft.ortilator.controllers.AbstractMapController;

public abstract class AbstractCameraController
extends AbstractMapController {
    Game game;
    private Viewport viewport;
    private OrthographicCamera mapCam;
    private Viewport viewPortGui;
    private OrthographicCamera guiCam;
    private double addX = 0.0;
    private double addY = 0.0;
    private boolean isSmall;
    private boolean isVerySmall;
    private boolean isBig;

    public AbstractCameraController(Game game, OrtiMain.GameModes gameMode) {
        this.game = game;
        this.isSmall = false;
        switch (gameMode) {
            case INFINITE_CLAUSTRO: 
            case ESCAPE_CLAUSTRO: {
                MAP_WIDTH = 8;
                break;
            }
            case INFINITE_VERY_CLAUSTRO: 
            case ESCAPE_VERY_CLAUSTRO: {
                MAP_WIDTH = 6;
                this.isSmall = true;
                break;
            }
            case TUTORIAL: {
                MAP_WIDTH = 3;
                this.isSmall = true;
                this.isVerySmall = true;
                break;
            }
            case TWO_PLAYERS: {
                MAP_WIDTH = 17;
                this.isBig = true;
                break;
            }
            default: {
                MAP_WIDTH = 10;
            }
        }
        this.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    private OrthographicCamera createNewCamera(int offset, boolean isGUI) {
        OrthographicCamera cam = new OrthographicCamera();
        cam.viewportWidth = 1280.0f;
        cam.viewportHeight = 720.0f;
        if (!isGUI) {
            cam.far = 10.0f;
        } else {
            cam.position.set(cam.viewportWidth / 2.0f, cam.viewportHeight / 2.0f, 0.0f);
        }
        return cam;
    }

    private void moveCamera(float x, float y) {
        this.mapCam.position.add(x, y, 0.0f);
    }

    protected void moveFreeCamera(float x, float y) {
        this.addX += (double)(x / 10.0f);
        if (this.addX > 5.0) {
            this.addX = 5.0;
        }
        if (this.addX < -5.0) {
            this.addX = -5.0;
        }
        this.addY += (double)(y / 10.0f);
        if (this.addY > 5.0) {
            this.addY = 5.0;
        }
        if (this.addY < -5.0) {
            this.addY = -5.0;
        }
    }

    public Vector3 checkTileTouched(Vector3 touch) {
        if (Gdx.input.isButtonPressed(0)) {
            int pickedTileX = (int)touch.x;
            int pickedTileY = (int)touch.y;
            if (pickedTileX >= 0 && pickedTileX < MAP_WIDTH && pickedTileY >= 0 && pickedTileY < AbstractCameraController.getMAP_HEIGHT()) {
                return new Vector3(pickedTileX, pickedTileY, 0.0f);
            }
        }
        return null;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public Camera getUsedMapCam() {
        return this.mapCam;
    }

    public OrthographicCamera getMapCam() {
        return this.mapCam;
    }

    public OrthographicCamera getGuiCam() {
        return this.guiCam;
    }

    public Viewport getViewPortGui() {
        return this.viewPortGui;
    }

    public void resize(int width, int height) {
        this.mapCam = this.createNewCamera(0, false);
        this.guiCam = this.createNewCamera(0, true);
        if (this.viewport == null) {
            this.viewport = new FitViewport(1280.0f, 720.0f, this.mapCam);
            this.viewPortGui = new FitViewport(1280.0f, 720.0f, this.guiCam);
            this.viewport.apply();
            this.viewPortGui.apply();
            this.mapCam.update();
            this.guiCam.update();
        }
        this.viewport.update(width, height);
        this.viewport.setCamera(this.mapCam);
        this.viewPortGui.update(width, height);
        this.viewPortGui.setCamera(this.guiCam);
        this.resetCameraPosition();
        this.guiCam.update();
    }

    public void resetCameraPosition() {
        this.mapCam.position.x = this.isSmall ? 2.0f : (this.isVerySmall ? 5.0f : (this.isBig ? 9.5f : 4.0f));
        this.mapCam.position.y = 7.25f;
        this.mapCam.zoom = 0.02f;
    }
}

