/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.I18NBundle;
import com.ortisoft.ortilator.assets.Assets;
import java.util.Locale;

public class ISDLocale {
    private static FileHandle internal;
    private static I18NBundle localeUse;
    private static String selectedLang;

    public static String getSelectedLang() {
        if (selectedLang == null) {
            return "en";
        }
        return selectedLang;
    }

    public static String LocaleInUse(String key) {
        try {
            return localeUse.get(key);
        }
        catch (Exception ex) {
            return "#" + key + "#";
        }
    }

    public static void setLocale(String lang) {
        Gdx.app.getPreferences("RB").putString("lang", lang);
        Gdx.app.getPreferences("RB").flush();
        internal = Gdx.files.internal("i18n/lang");
        if (lang.equals("es")) {
            localeUse = I18NBundle.createBundle(internal, new Locale("es"));
            selectedLang = "es";
        } else if (lang.equals("cn")) {
            localeUse = I18NBundle.createBundle(internal, new Locale("cn"));
            selectedLang = "cn";
        } else if (lang.equals("en")) {
            localeUse = I18NBundle.createBundle(internal, Locale.ROOT);
            selectedLang = "en";
        }
        Assets.loadFonts();
        internal = null;
    }

    public static void toggleLanguage() {
        if (selectedLang.equals("es")) {
            ISDLocale.setLocale("en");
        } else if (selectedLang.equals("en")) {
            ISDLocale.setLocale("cn");
        } else if (selectedLang.equals("cn")) {
            ISDLocale.setLocale("es");
        }
    }
}

