/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.ortisoft.ortilator.OrtiMain;
import com.ortisoft.ortilator.assets.ISDLocale;
import com.ortisoft.ortilator.world.RandomSeed;
import com.ortisoft.ortilator.world.loaders.CharacterLoader;
import java.util.HashMap;

public class Assets {
    private static boolean isLoaded = false;
    private static Music music;
    private static HashMap<String, ParticleEffect> particleEffects;
    private static int currentBG;
    private static HashMap<Sounds, Sound> gameSounds;
    private static HashMap<String, Texture> gameTextures;
    private static HashMap<String, Texture> debugTextures;
    private static HashMap<String, Texture> guiTextures;
    private static HashMap<String, Texture> playerObjectsTextures;
    private static HashMap<String, Texture> bg;
    private static HashMap<String, Texture> intro;
    public static BitmapFont font;
    public static BitmapFont fontGui;
    public static BitmapFont fontArialWhite;
    public static BitmapFont fontArialWhiteBig;
    private static TextureRegion background;

    public static Texture getCurrentBG() {
        if (currentBG == 0) {
            Assets.selectRandomBackground();
        }
        return Assets.returnTexture(ObjectTypes.BG, "BG" + currentBG);
    }

    public static ParticleEffect returnEffect(String name) {
        if (!particleEffects.containsKey(name)) {
            ParticleEffect pe = new ParticleEffect();
            pe.load(Gdx.files.internal("data/Effects/" + name), Gdx.files.internal("data/Effects/" + name + "Resources/"));
            particleEffects.put(name, pe);
        }
        return particleEffects.get(name);
    }

    public static Texture returnTexture(ObjectTypes imageType, String name) {
        try {
            switch (imageType) {
                case GAME: {
                    if (!gameTextures.containsKey(name)) {
                        gameTextures.put(name, new Texture(Gdx.files.internal("data/Game/" + name + ".png")));
                    }
                    return gameTextures.get(name);
                }
                case DEBUG: {
                    if (!debugTextures.containsKey(name)) {
                        debugTextures.put(name, new Texture(Gdx.files.internal("data/Debug/" + name + ".png")));
                    }
                    return debugTextures.get(name);
                }
                case GUI: {
                    if (!guiTextures.containsKey(name)) {
                        guiTextures.put(name, new Texture(Gdx.files.internal("data/Gui/" + name + ".png"), true));
                    }
                    return guiTextures.get(name);
                }
                case PLAYER_OBJECTS: {
                    if (!playerObjectsTextures.containsKey(name)) {
                        playerObjectsTextures.put(name, new Texture(Gdx.files.internal("data/PlayerObjects/" + name + ".png"), true));
                    }
                    return playerObjectsTextures.get(name);
                }
                case BG: {
                    if (!bg.containsKey(name)) {
                        bg.put(name, new Texture(Gdx.files.internal("data/BG/" + name + ".png"), true));
                    }
                    return bg.get(name);
                }
                case INTRO: {
                    if (!intro.containsKey(name)) {
                        intro.put(name, new Texture(Gdx.files.internal("data/Intro/" + name + ".png"), true));
                    }
                    return intro.get(name);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static void load() {
        if (isLoaded) {
            return;
        }
        Assets.loadAll();
        CharacterLoader.reloadAtlas();
        isLoaded = true;
    }

    private static void loadAll() {
        Assets.loadFonts();
        Assets.loadSounds();
        Assets.loadBG();
    }

    public static void loadFonts() {
        fontGui = new BitmapFont();
        fontGui.setColor(Color.WHITE);
        fontGui.getData().setScale(1.0f);
        fontGui.getRegion().getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        if (!ISDLocale.getSelectedLang().equals("cn")) {
            Texture arial = new Texture(Gdx.files.internal("data/Fonts/Arial.png"), true);
            arial.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.Linear);
            Texture arialBig = new Texture(Gdx.files.internal("data/Fonts/ArialBig.png"), true);
            arialBig.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.Linear);
            fontArialWhite = new BitmapFont(Gdx.files.internal("data/Fonts/Arial.fnt"), new TextureRegion(arial), false);
            fontArialWhiteBig = new BitmapFont(Gdx.files.internal("data/Fonts/ArialBig.fnt"), new TextureRegion(arialBig), false);
        } else {
            Texture arial = new Texture(Gdx.files.internal("data/Fonts/cn.png"), true);
            arial.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.Linear);
            fontArialWhite = new BitmapFont(Gdx.files.internal("data/Fonts/cn.fnt"), new TextureRegion(arial), false);
            fontArialWhiteBig = new BitmapFont(Gdx.files.internal("data/Fonts/cn.fnt"), new TextureRegion(arial), false);
            fontArialWhiteBig.getData().setScale(1.2f);
        }
    }

    private static void loadBG() {
        bg.put("BG1", new Texture(Gdx.files.internal("data/BG/BG1.png"), true));
        bg.put("BG2", new Texture(Gdx.files.internal("data/BG/BG2.png"), true));
        bg.put("BG3", new Texture(Gdx.files.internal("data/BG/BG3.png"), true));
        bg.put("BG4", new Texture(Gdx.files.internal("data/BG/BG4.png"), true));
    }

    private static void loadSounds() {
        gameSounds.put(Sounds.FALLING_BLOCK, Gdx.audio.newSound(Gdx.files.internal("data/Sounds/thump.mp3")));
        gameSounds.put(Sounds.PUSH_PULL_BLOCK, Gdx.audio.newSound(Gdx.files.internal("data/Sounds/pushpull.mp3")));
        gameSounds.put(Sounds.MENU_MOVEMENT, Gdx.audio.newSound(Gdx.files.internal("data/Sounds/click.mp3")));
        gameSounds.put(Sounds.LEVEL_CHANGE_1, Gdx.audio.newSound(Gdx.files.internal("data/Music/LevelChange/1.wav")));
        gameSounds.put(Sounds.LEVEL_CHANGE_2, Gdx.audio.newSound(Gdx.files.internal("data/Music/LevelChange/2.wav")));
        gameSounds.put(Sounds.LEVEL_CHANGE_3, Gdx.audio.newSound(Gdx.files.internal("data/Music/LevelChange/3.wav")));
        gameSounds.put(Sounds.EXPLOSION, Gdx.audio.newSound(Gdx.files.internal("data/Sounds/explosion.mp3")));
        gameSounds.put(Sounds.FREEZE, Gdx.audio.newSound(Gdx.files.internal("data/Sounds/freeze.mp3")));
        gameSounds.put(Sounds.BLEEP, Gdx.audio.newSound(Gdx.files.internal("data/Sounds/bleep.mp3")));
    }

    public static void menuMusic() {
        Assets.stopMusic();
        if (OrtiMain.isMusicEnabled()) {
            music = Gdx.audio.newMusic(Gdx.files.internal("data/Music/Background/menu.mp3"));
            music.setVolume(1.0f);
            music.setLooping(true);
            music.play();
        }
    }

    public static void gameMusic() {
        Assets.stopMusic();
        if (OrtiMain.isMusicEnabled()) {
            int musicNumber = 1;
            music = Gdx.audio.newMusic(Gdx.files.internal("data/Music/Background/game" + musicNumber + ".mp3"));
            music.setVolume(0.25f);
            music.setLooping(true);
            music.play();
        }
    }

    public static void changeLevelMusic() {
        int musicNumber = RandomSeed.getRan().nextInt(3) + 1;
        switch (musicNumber) {
            case 1: {
                Assets.sound(Sounds.LEVEL_CHANGE_1);
                break;
            }
            case 2: {
                Assets.sound(Sounds.LEVEL_CHANGE_2);
                break;
            }
            case 3: {
                Assets.sound(Sounds.LEVEL_CHANGE_3);
            }
        }
    }

    public static void selectRandomBackground() {
        int latest = currentBG;
        while (currentBG == latest) {
            currentBG = RandomSeed.getRan().nextInt(4) + 1;
        }
    }

    public static void stopMusic() {
        if (music != null) {
            music.stop();
            music.dispose();
            music = null;
        }
    }

    public static void sound(Sounds soundName) {
        if (OrtiMain.isSoundEnabled()) {
            long id = gameSounds.get((Object)soundName).play();
            float volume = 1.0f;
            switch (soundName) {
                case LEVEL_CHANGE_1: 
                case LEVEL_CHANGE_2: 
                case LEVEL_CHANGE_3: {
                    volume = 0.75f;
                    break;
                }
                case MENU_MOVEMENT: 
                case EXPLOSION: {
                    volume = 0.5f;
                }
            }
            gameSounds.get((Object)soundName).setVolume(id, volume);
        }
    }

    public static void dispose() {
        if (!isLoaded) {
            return;
        }
        Assets.clear();
    }

    public static void clear() {
        for (Texture gameTexture : gameTextures.values()) {
            gameTexture.dispose();
        }
        gameTextures.clear();
        for (Texture debugTexture : debugTextures.values()) {
            debugTexture.dispose();
        }
        debugTextures.clear();
        for (Texture guiTexture : guiTextures.values()) {
            guiTexture.dispose();
        }
        guiTextures.clear();
        for (Texture playerObjectsTexture : playerObjectsTextures.values()) {
            playerObjectsTexture.dispose();
        }
        playerObjectsTextures.clear();
        for (Texture bgTextures : bg.values()) {
            bgTextures.dispose();
        }
        bg.clear();
        for (Texture introTextures : intro.values()) {
            introTextures.dispose();
        }
        intro.clear();
        if (font != null) {
            font.dispose();
        }
        if (fontGui != null) {
            fontGui.dispose();
        }
        if (fontArialWhite != null) {
            fontArialWhite.dispose();
        }
        if (music != null) {
            music.dispose();
        }
        isLoaded = false;
    }

    static {
        particleEffects = new HashMap();
        gameSounds = new HashMap();
        gameTextures = new HashMap();
        debugTextures = new HashMap();
        guiTextures = new HashMap();
        playerObjectsTextures = new HashMap();
        bg = new HashMap();
        intro = new HashMap();
    }

    public static enum Sounds {
        FALLING_BLOCK,
        PUSH_PULL_BLOCK,
        MENU_MOVEMENT,
        LEVEL_CHANGE_1,
        LEVEL_CHANGE_2,
        LEVEL_CHANGE_3,
        EXPLOSION,
        FREEZE,
        BLEEP;

    }

    public static enum ObjectTypes {
        GAME,
        BG,
        DEBUG,
        GUI,
        PLAYER_OBJECTS,
        INTRO;

    }
}

