/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.files.FileHandle;
import com.ortisoft.ortilator.Game;
import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.assets.ISDLocale;
import com.ortisoft.ortilator.controllers.menu.LeaderBoardMenuController;
import com.ortisoft.ortilator.controllers.menu.NewGameMenuController;
import com.ortisoft.ortilator.entities.ICharacter;
import com.ortisoft.ortilator.entities.IGadget;
import com.ortisoft.ortilator.entities.IObjectModifiers;
import com.ortisoft.ortilator.stateControls.LoadController;
import com.ortisoft.ortilator.stateControls.SaveController;
import com.ortisoft.ortilator.world.HighScoreData;
import com.ortisoft.ortilator.world.World;
import com.ortisoft.ortilator.world.loaders.BlockLoader;
import com.ortisoft.ortilator.world.loaders.CharacterLoader;
import com.ortisoft.ortilator.world.loaders.GadgetLoader;
import com.ortisoft.ortilator.world.loaders.ObjectModifiersLoader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;

public class OrtiMain
extends ScreenAdapter {
    private static boolean showTutorial = true;
    private static boolean soundEnabled = true;
    private static IGadget latestSelectedGadget;
    private static IObjectModifiers latestSelectedOM;
    private static ICharacter latestCharacter;
    private static int latestTip;
    private static boolean musicEnabled;
    private static String directory;
    private static Game game;
    private static HighScoreData highScoreData;
    World loadedWorld;

    public static boolean isMobile() {
        return game.isMobile();
    }

    public static int getLatestTip() {
        return latestTip;
    }

    public static void updateLatestTip() {
        if (++latestTip > 5) {
            latestTip = 1;
        }
    }

    public static long getLatestScore() {
        return highScoreData.getLatestScore();
    }

    public static void resetLatestHighScore() {
        highScoreData.resetLatestHighScore();
    }

    public static void toggleLanguage() {
        ISDLocale.toggleLanguage();
        game.setLang(ISDLocale.getSelectedLang());
    }

    public static void updateSteam() {
        game.updateSteam();
    }

    public static void loadLeaderBoard(String leaderboardName) {
        OrtiMain.loadLeaderBoard(leaderboardName, null);
    }

    public static void loadLeaderBoard(String leaderboardName, LeaderBoardMenuController menuController) {
        game.loadLeaderBoard(leaderboardName, menuController);
    }

    public static boolean checkGameScore(GameModes gameMode, NewGameMenuController.Type type, long result) {
        return highScoreData.checkGameScore(gameMode, type, result);
    }

    public static boolean isShowTutorial() {
        return showTutorial;
    }

    public static IGadget getLatestSelectedGadget() {
        return latestSelectedGadget;
    }

    public static IObjectModifiers getLatestSelectedOM() {
        return latestSelectedOM;
    }

    public static ICharacter getLatestCharacter() {
        return latestCharacter;
    }

    public static void setLatestSelectedGadget(IGadget latestSelectedGadget) {
        OrtiMain.latestSelectedGadget = latestSelectedGadget;
    }

    public static void setLatestSelectedOM(IObjectModifiers latestSelectedOM) {
        OrtiMain.latestSelectedOM = latestSelectedOM;
    }

    public static void setLatestCharacter(ICharacter selectedCharacter) {
        latestCharacter = selectedCharacter;
    }

    public static void setLatestCharacter(int latestCharacter) {
        if (latestCharacter != 0) {
            OrtiMain.latestCharacter = CharacterLoader.allCharacters.get(latestCharacter);
        }
    }

    public static void setLatestSelectedGadget(int latestSelectedGadget) {
        if (latestSelectedGadget != 0) {
            OrtiMain.latestSelectedGadget = GadgetLoader.allGadgets.get(latestSelectedGadget);
        }
    }

    public static void setLatestSelectedOM(int latestSelectedOM) {
        if (latestSelectedOM != 0) {
            OrtiMain.latestSelectedOM = ObjectModifiersLoader.allObjectModifiers.get(latestSelectedOM);
        }
    }

    public static void unlockAchievement(String achievementId) {
        game.unlockAchievement(achievementId);
    }

    public static void updateScore(String leaderBoardId, long score) {
        int gadget = 0;
        if (latestSelectedGadget != null) {
            gadget = latestSelectedGadget.getId();
        }
        game.updateScore(leaderBoardId, Math.round(score), latestCharacter.getId(), gadget);
    }

    public static boolean waitingForResponse() {
        return game.waitingForResponse();
    }

    public static boolean isSoundEnabled() {
        return soundEnabled;
    }

    public static void setSoundEnabled(boolean soundEnabled) {
        OrtiMain.soundEnabled = soundEnabled;
        OrtiMain.saveGame();
    }

    public static String getLang() {
        return game.getLang();
    }

    public static void setLang(String lang) {
        if (!lang.equals("")) {
            game.setLang(lang);
        }
    }

    public static boolean isMusicEnabled() {
        return musicEnabled;
    }

    public static void setMusicEnabled(boolean musicEnabled, boolean inGame) {
        OrtiMain.musicEnabled = musicEnabled;
        if (musicEnabled) {
            if (inGame) {
                Assets.gameMusic();
            } else {
                Assets.menuMusic();
            }
        } else {
            Assets.stopMusic();
        }
        OrtiMain.saveGame();
    }

    public static long getCurrentHighScore(GameModes gameMode, NewGameMenuController.Type type) {
        return highScoreData.checkGameScore(gameMode, type);
    }

    public static void setShowTutorial(boolean bShowTutorial) {
        showTutorial = bShowTutorial;
    }

    public OrtiMain(Game gameReference) {
        game = gameReference;
        game.setMain(this);
        this.loadHighScores();
        this.loadLoaders();
        latestCharacter = CharacterLoader.allCharacters.get(1);
        game.storeAchievements(true);
        this.startNewGame();
    }

    private void loadLoaders() {
        new BlockLoader();
        new CharacterLoader();
        new GadgetLoader();
        new ObjectModifiersLoader();
    }

    private void loadHighScores() {
        highScoreData = new HighScoreData(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    public static void loadHighScores(long totalBlocksNormal, long totalBlocksClaustro, long totalBlocksVeryClaustro, long timeEscapeNormal, long timeEscapeClaustro, long timeEscapeVeryClaustro, long totalBlocksNormalExtended, long totalBlocksClaustroExtended, long totalBlocksVeryClaustroExtended, long timeEscapeNormalExtended, long timeEscapeClaustroExtended, long timeEscapeVeryClaustroExtended) {
        highScoreData = new HighScoreData(totalBlocksNormal, totalBlocksClaustro, totalBlocksVeryClaustro, timeEscapeNormal, timeEscapeClaustro, timeEscapeVeryClaustro, totalBlocksNormalExtended, totalBlocksClaustroExtended, totalBlocksVeryClaustroExtended, timeEscapeNormalExtended, timeEscapeClaustroExtended, timeEscapeVeryClaustroExtended);
    }

    public void startNewGame() {
        this.loadedWorld = null;
        if (Gdx.files.absolute(directory + "/save.sav").exists() || Gdx.files.absolute(directory + "/save_new.sav").exists()) {
            if (Gdx.files.absolute(directory + "/save.sav").exists()) {
                OrtiMain.loadGame(Gdx.files.absolute(directory + "/save.sav"));
            } else {
                OrtiMain.loadGame(Gdx.files.absolute(directory + "/save_new.sav"), true);
            }
        }
        this.loadedWorld = new World(this, game);
        game.setScreen(this.loadedWorld);
    }

    private static void loadGame(FileHandle local) {
        OrtiMain.loadGame(local, false);
    }

    private static void loadGame(FileHandle local, boolean rename) {
        try {
            new LoadController(new FileReader(local.file()));
            if (rename) {
                local.file().renameTo(Gdx.files.absolute(directory + "/save.sav").file());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void deleteSaveGame() {
        FileHandle fileLast = Gdx.files.absolute(directory + "/save.sav");
        if (fileLast.exists()) {
            fileLast.delete();
        }
    }

    private static void deleteBackSaveGame() {
        FileHandle fileLast = Gdx.files.absolute(directory + "/save_new.sav");
        if (fileLast.exists()) {
            fileLast.delete();
        }
    }

    public static void saveGame() {
        block2: {
            SaveController save = new SaveController();
            try {
                FileHandle file = Gdx.files.absolute(directory + "/save_new.sav");
                file.file().createNewFile();
                save.saveData(file);
                OrtiMain.deleteSaveGame();
                file.file().renameTo(Gdx.files.absolute(directory + "/save.sav").file());
            }
            catch (Throwable ex) {
                FileHandle file = Gdx.files.absolute(directory + "/save_new.sav");
                if (!file.exists()) break block2;
                file.delete();
            }
        }
        game.storeAchievements(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(Exception error) {
        Gdx.app.error("Error", "Non controlled error: ", error);
        FileHandle file = Gdx.files.absolute(directory + "/error.log");
        if (!file.exists()) {
            try {
                file.file().createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try (PrintStream ps = null;){
            ps = new PrintStream(file.file());
            error.printStackTrace(ps);
        }
    }

    @Override
    public void dispose() {
        OrtiMain.saveGame();
        Assets.dispose();
    }

    public void restart() {
        this.loadedWorld = null;
        World newWorld = new World(this, game);
        game.setScreen(newWorld);
        this.loadedWorld = newWorld;
    }

    public static void showLeaderBoards(String idLeaderBoard) {
        game.showLeaderBoards(idLeaderBoard);
    }

    public World getLoadedWorld() {
        return this.loadedWorld;
    }

    static {
        latestTip = 0;
        musicEnabled = true;
        directory = System.getProperty("user.dir");
    }

    public static enum GameModes {
        INFINITE,
        ESCAPE,
        INFINITE_CLAUSTRO,
        ESCAPE_CLAUSTRO,
        INFINITE_VERY_CLAUSTRO,
        ESCAPE_VERY_CLAUSTRO,
        TUTORIAL,
        TWO_PLAYERS;

    }
}

