/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.ortisoft.ortilator.IApplication;
import com.ortisoft.ortilator.OrtiMain;
import com.ortisoft.ortilator.controllers.menu.LeaderBoardMenuController;

public class Game
extends com.badlogic.gdx.Game {
    private OrtiMain currentMain;
    private boolean mobile;
    private String lang;
    private String steamLanguage;
    private boolean showIntro = true;
    private IApplication application;

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public boolean isShowIntro() {
        return this.showIntro;
    }

    public void setShowIntro(boolean showIntro) {
        this.showIntro = showIntro;
    }

    public Game(boolean forceResolution, IApplication application) {
        this.initialize(forceResolution, application);
        if (application != null) {
            this.steamLanguage = application.getLanguage();
        }
    }

    private void initialize(boolean mobile, IApplication application) {
        this.mobile = mobile;
        this.application = application;
    }

    public Game(boolean forceResolution) {
        this.initialize(forceResolution, null);
    }

    public boolean isMobile() {
        return this.mobile;
    }

    @Override
    public void create() {
        Preferences prefs = Gdx.app.getPreferences("RB");
        if (!prefs.contains("lang")) {
            if (this.steamLanguage.toLowerCase().equals("spanish") || this.steamLanguage.toLowerCase().equals("es")) {
                prefs.putString("lang", "es");
            } else if (this.steamLanguage.toLowerCase().equals("sc")) {
                prefs.putString("lang", "sc");
            } else {
                prefs.putString("lang", "en");
            }
            prefs.flush();
        }
        this.lang = prefs.getString("lang");
        this.currentMain = new OrtiMain(this);
    }

    public OrtiMain getMain() {
        return this.currentMain;
    }

    @Override
    public void resize(int width, int height) {
        boolean resetWindow = false;
        this.currentMain.loadedWorld.resize(width, height);
        if (resetWindow) {
            Gdx.graphics.setWindowedMode(width, height);
        }
    }

    @Override
    public void render() {
        super.render();
    }

    public void startNewGame() {
        this.currentMain.restart();
    }

    public void setMain(OrtiMain main) {
        this.currentMain = main;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.application != null) {
            if (this.currentMain != null) {
                this.currentMain.dispose();
                this.currentMain = null;
            }
            this.application.closeApplication();
            Gdx.app.exit();
        } else {
            Gdx.app.exit();
        }
    }

    public void showLeaderBoards(String idLeaderBoard) {
        if (this.application != null) {
            this.application.showLeaderBoards(idLeaderBoard);
        }
    }

    public boolean waitingForResponse() {
        if (this.application != null) {
            return this.application.waitingForResponse();
        }
        return false;
    }

    public void unlockAchievement(String achievementId) {
        if (this.application != null) {
            this.application.unlockAchievement(achievementId);
        }
    }

    public void updateScore(String leaderBoardId, int score, int idChar, int idGadget) {
        if (this.application != null) {
            this.application.updateScore(leaderBoardId, score, idChar, idGadget);
        }
    }

    public void updateSteam() {
        if (this.application != null) {
            this.application.updateSteam();
        }
    }

    public void storeAchievements(boolean firstRun) {
        if (this.application != null) {
            this.application.storeAchievements(firstRun);
        }
    }

    public void loadLeaderBoard(String leaderboardName, LeaderBoardMenuController menuController) {
        if (this.application != null) {
            this.application.loadLeaderBoard(leaderboardName, menuController);
        }
    }
}

