/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import com.codedisaster.steamworks.SteamAPICall;
import com.codedisaster.steamworks.SteamGameServerAPI;
import com.codedisaster.steamworks.SteamGameServerStatsCallback;
import com.codedisaster.steamworks.SteamGameServerStatsCallbackAdapter;
import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamInterface;

public class SteamGameServerStats
extends SteamInterface {
    public SteamGameServerStats(SteamGameServerStatsCallback callback) {
        super(SteamGameServerAPI.getSteamGameServerStatsPointer(), SteamGameServerStats.createCallback(new SteamGameServerStatsCallbackAdapter(callback)));
    }

    public SteamAPICall requestUserStats(SteamID steamIDUser) {
        return new SteamAPICall(SteamGameServerStats.requestUserStats(this.pointer, steamIDUser.handle));
    }

    public int getUserStatI(SteamID steamIDUser, String name, int defaultValue) {
        int[] values = new int[1];
        if (SteamGameServerStats.getUserStat(this.pointer, steamIDUser.handle, name, values)) {
            return values[0];
        }
        return defaultValue;
    }

    public float getUserStatF(SteamID steamIDUser, String name, float defaultValue) {
        float[] values = new float[1];
        if (SteamGameServerStats.getUserStat(this.pointer, steamIDUser.handle, name, values)) {
            return values[0];
        }
        return defaultValue;
    }

    public boolean getUserAchievement(SteamID steamIDUser, String name, boolean defaultValue) {
        boolean[] achieved = new boolean[1];
        if (SteamGameServerStats.getUserAchievement(this.pointer, steamIDUser.handle, name, achieved)) {
            return achieved[0];
        }
        return defaultValue;
    }

    public boolean setUserStatI(SteamID steamIDUser, String name, int value) {
        return SteamGameServerStats.setUserStat(this.pointer, steamIDUser.handle, name, value);
    }

    public boolean setUserStatF(SteamID steamIDUser, String name, float value) {
        return SteamGameServerStats.setUserStat(this.pointer, steamIDUser.handle, name, value);
    }

    public boolean updateUserAvgRateStat(SteamID steamIDUser, String name, float countThisSession, double sessionLength) {
        return SteamGameServerStats.updateUserAvgRateStat(this.pointer, steamIDUser.handle, name, countThisSession, sessionLength);
    }

    public boolean setUserAchievement(SteamID steamIDUser, String name) {
        return SteamGameServerStats.setUserAchievement(this.pointer, steamIDUser.handle, name);
    }

    public boolean clearUserAchievement(SteamID steamIDUser, String name) {
        return SteamGameServerStats.clearUserAchievement(this.pointer, steamIDUser.handle, name);
    }

    public SteamAPICall storeUserStats(SteamID steamIDUser) {
        return new SteamAPICall(SteamGameServerStats.storeUserStats(this.pointer, steamIDUser.handle));
    }

    private static native long createCallback(SteamGameServerStatsCallbackAdapter var0);

    private static native long requestUserStats(long var0, long var2);

    private static native boolean getUserStat(long var0, long var2, String var4, int[] var5);

    private static native boolean getUserStat(long var0, long var2, String var4, float[] var5);

    private static native boolean getUserAchievement(long var0, long var2, String var4, boolean[] var5);

    private static native boolean setUserStat(long var0, long var2, String var4, int var5);

    private static native boolean setUserStat(long var0, long var2, String var4, float var5);

    private static native boolean updateUserAvgRateStat(long var0, long var2, String var4, float var5, double var6);

    private static native boolean setUserAchievement(long var0, long var2, String var4);

    private static native boolean clearUserAchievement(long var0, long var2, String var4);

    private static native long storeUserStats(long var0, long var2);
}

