# QCart Changelog

## 1.2.2

- Added: better logging support to improve our ability to provide technical support. See QCart (menu) -> Preferences.
- Fixed: incompatible audio effects could prevent workspaces from being opened
- Fixed: set show mode correctly when loading a workspace that was saved while in show mode
- Fixed: a rare crash when dragging'n'dropping

## 1.2.1

- Added: new cue warnings. 1) if your cue is outside the current grid 2) if your cue has the same hotkey as a workspace action
- Added: support scrolling left and right in the audio waveform 
- Fixed: if there were any empty workspace-level hotkeys, the "A" key could not be used to trigger a cue
- Fixed: when switching tabs in Show Mode, the screen would appear to be in Edit Mode
- Fixed: support undo for cue volume
- Fixed: cue inspector could break on 10.6
- Fixed: the "paste" menu item could be available in Show mode

## 1.2

- Changed: we refer to locked/unlocked workspaces as Show Mode and Edit Mode, respectively
- Changed: swapped commands for closing windows and tabs. ⌘-W now closes the window, rather than deleting a tab (⌘-⇧-W)
- Changed: default hotkeys only appear when they will be used - when creating a cue by dragging an audio track into the window
- Changed: alt-drag or or cut/copy/paste now only put cues into empty slots
- Changed: removed Mute in favor of a button which stops all running cues with a quick fade ("Panic," for you QLab users out there)
- Changed: press escape once to "panic", twice to "hard stop" (stop all cues without a fade, immediately)
- Changed: prevent AirPlay devices from being selected as output options
- New: added a per-workspace settings panel. It is under View > Workspace Settings (⌘-,)
- New: per-workspace settings to select incoming MIDI channel and panic (fade to stop) duration per workspace in workspace settings
- New: workspace settings for optional hotkeys for pause all, resume all, duck
- New: added Broken Cues & Warnings inspector. View > Broken Cues & Warnings (⌘B) will check your workspace for duplicate hotkeys and MIDI triggers, as well as missing files. There is a setting to perform this check when switching to show mode
- New: added standard "cut" command for cues in the grid, in addition to copy
- New: empty slots can be selected to paste cues from the clipboard (cut or copy)
- New: use ⌘-arrow keys to select different cues while editing text (great for naming or setting up hotkeys and MIDI triggers)
- New: enable the use of the tab key to navigate text fields in more places
- New: added menu when right clicking the waveform editor to "Open with External Editor." Note: this uses the default program for the file you are editing. For example, if you have not changed your settings, an mp3 file might open in iTunes or VLC
- New: restore the position and size of a workspace when you reopen it on the same computer
- New: when adding an audio effect, the menu will show audio effects plugins grouped by manufacturer
- New: option to send anonymous system profile information to help us understand the aggregate patterns for QCart usage in the field
- Fixed: handle unplugged/turned off output devices more gracefully
- Fixed: solo cues could take a long time to begin playing if many other cues were running
- Fixed: playback position would reset inappropriately sometimes when changing the audio start/end times
- Fixed: could not drag a tab to another workspace if the other workspace had only one tab
- Fixed: when unpausing the workspace, only paused cues will be effected. Previously, if cues were triggered while the workspace was paused, those cues would be paused when the workspace was unpaused
- Fixed: some actions should not have been available when workspaces were in show mode. They have been disabled.
- Fixed: workspaces might not have restored properly when they were saved when in show mode.
- Fixed: pressing Escape to panic/stop all works in text fields now
- Fixed: When a workspace has multiple tabs, select the one furthest to the left when opening.
- Other bug fixes, menu, and cosmetic changes

## 1.1.3
- New: improved Contact Support feature
- New: added buttons to pause and clear the log
- New: display the file's path as a tooltip on the name field in the inspector
- New: code signed for Apple's Gatekeeper security technology
- Fixed: bug that caused a crash when loading certain AU plugins
- Fixed: improve function of the copy, paste, and delete menu items
- Fixed: the cue play/stop button wasn't kept kept updated between the inspector and the grid
- Fixed: a bug that caused the pause button to disappear when pressing Escape
- Other bug fixes

## 1.1.2
- Increased audio buffer size to address audio glitching in some systems
- Significant speed and efficiency improvements when saving documents
- Fixed bug with copy and pasting cues
- Other bug fixes


## 1.1.1
- New: added help menu item for emailing support
- Fixed: sample rate of output device is now honored
- Misc bug fixes

## 1.1
- New: drag and drop multiple files at once, it will fill any empty cells, filling in from left to right, and wrapping around
- New: drag and drop tracks from iTunes 
- New: change the number of cue cells by choosing Cart > Change Grid (⌘-G)
- New: rename the current cart by going to Cart > Rename Cart (⌘-R)
- New: mono files are now played out of both channels
- New: solo cue feature. All currently playing cues will be stopped when a cue with solo enabled is played
- New: copy and paste cues. Edit > Copy (or ⌘-C) will copy the selected cue. You can paste into the same document or another document, and it will put the cue in the first empty spot after the currently selected cue. Can also option-drag a cue to copy it as well
- New: time remaining/elapsed is displayed with a progress bar while a cue is playing
- New: global ducking button fades out the volume of all playing cues when enabled, and fades in the volume back to previous level when disabled
- New: right-click or double-click a cell to choose an audio file instead of drag and drop
- New: can rearrange the order of effects
- New: log of all cues played, stored with document (Cart > View Log)
- New: cue actions (hold, loop, solo) have been moved to menu (gear icon), also available via right-click
- New: easily export files in document (right-click on cue, "Export File")
- New: cue inspector shows "No Cue Selected" message if a cue isn't selected, instead of empty inspector view
- Fixed: issue where closing tab wouldn't be removed from document
- Fixed: can no longer close tabs when in locked mode
- Fixed: pressing delete when effects table has focus will delete selected effect instead of cue
- Fixed: adjusted audio buffering to prevent glitching on some systems
- Fixed: in some cases closing a cart wouldn't remove it from the document
- Fixed: a bug that could prevent carts from being saved in the correct order
- Misc bug fixes
