--[[ * LEAGUE GENERATION SCRIPTS * ]]

Import "Localization.lua"
Import "WorldContentScripts.lua"
Import "NarrationScripts.lua"
Import "UtilityScripts.lua"
Import "Color.lua"
Import "LeagueUtilityScripts.lua"
Import "PlayerTraitScripts.lua"
Import "ItemPurchaseScripts.lua"

-- Team Sigils
Using "SigilNightwings"
Using "SigilAccusers"
Using "SigilBeyonders"
Using "SigilChastity"
Using "SigilDissidents"
Using "SigilEssence"
Using "SigilFate"
Using "SigilPyrehearts"
Using "SigilTempers"
Using "SigilTrueNightwings"
Using "SigilWithdrawn"

--[[ * CHARACTER GENERATOR * ]]

ArchetypeData =
{
	["PlayerSmall"] =
	{
		ScoreValue = 15,
		-- SprintSound = "/SFX/Player Sounds/CurSprint",
		SprintSound = nil,
		AuraOnAnimation = "PlayerSmallHowlTaunt",
		TauntAnimation = "PlayerSmallHowlTaunt",
		FidgetAnimation = "PlayerSmallHowlTaunt",
		ExitAnimation = "PlayerSmallRushing",
		AscendedAnimation = "PlayerSmallUpTheWaterfall",
		AscensionPose = "PlayerSmallAscension",
		TauntSound = "/SFX/Match SFX/CurHowl",
		Height = 2.1,
		WeaponSuffix = "Small",
		SkillTreeBackgroundLeft = "GUI\\Screens\\MasteriesTree_CurLeft",
		SkillTreeBackgroundRight = "GUI\\Screens\\MasteriesTree_CurRight",
	},
	["PlayerMedium"] =
	{
		ScoreValue = 20,
		-- SprintSound = "/SFX/Player Sounds/NomadSprint",
		SprintSound = nil,
		AuraOnAnimation = "PlayerMediumAuraTurnOn",
		TauntAnimation = "PlayerMediumTaunt",
		FidgetAnimation = "PlayerMediumFidget",
		ExitAnimation = "PlayerMediumRushing",
		AscendedAnimation = "PlayerMediumUpTheWaterfall",
		AscensionPose = "PlayerMediumAscension",
		Height = 6.1,
		WeaponSuffix = "Medium",
		SkillTreeBackgroundLeft = "GUI\\Screens\\MasteriesTree_NomadLeft",
		SkillTreeBackgroundRight = "GUI\\Screens\\MasteriesTree_NomadRight",
	},
	["PlayerMediumAlt"] =
	{
		ScoreValue = 20,
		-- SprintSound = "/SFX/Player Sounds/NomadSprint",
		SprintSound = nil,
		AuraOnAnimation = "PlayerMediumAltAuraTurnOn",
		TauntAnimation = "PlayerMediumAltTaunt",
		ExitAnimation = "PlayerMediumRushing",
		AscendedAnimation = "PlayerMediumAltUpTheWaterfall",
		AscensionPose = "PlayerMediumAltIdle",
		Height = 4.1,
		WeaponSuffix = "MediumAlt",
		SkillTreeBackgroundLeft = "GUI\\Screens\\MasteriesTree_Nomad2Left",
		SkillTreeBackgroundRight = "GUI\\Screens\\MasteriesTree_Nomad2Right",
	},
	["PlayerLarge"] =
	{
		ScoreValue = 30,
		-- SprintSound = "/SFX/Player Sounds/DemonSprint",
		SprintSound = nil,
		AuraOnAnimation = "PlayerLargeAuraTurnOn",
		TauntAnimation = "PlayerLargeAuraTurnOn",
		TauntAlternateAnimation="PlayerLargeAuraTurnOn2",
		FidgetAnimation = "PlayerLargeFidget",
		ExitAnimation = "PlayerLargeJump",
		AscendedAnimation = "PlayerLargeUpTheWaterfall",
		AscensionPose = "PlayerLargeAscension",
		Height = 8.1,
		WeaponSuffix = "Large",
		SkillTreeBackgroundLeft = "GUI\\Screens\\MasteriesTree_DemonLeft",
		SkillTreeBackgroundRight = "GUI\\Screens\\MasteriesTree_DemonRight",
	},
	["PlayerImp"] =
	{
		ScoreValue = 15,
		-- SprintSound = "/SFX/Player Sounds/CurSprint",
		AscendedAnimation = "PlayerImpUpTheWaterfall",
		AuraOnAnimation = "PlayerImpAuraTurnOn",
		TauntAnimation = "PlayerImpAuraTurnOn",
		AscensionPose = "PlayerImpAscension",
		Height = 1.1,
		WeaponSuffix = "Imp",
		SkillTreeBackgroundLeft = "GUI\\Screens\\MasteriesTree_ImpLeft",
		SkillTreeBackgroundRight = "GUI\\Screens\\MasteriesTree_ImpRight",
	},
	["PlayerTrail"] =
	{
		ScoreValue = 15,
		-- SprintSound = "/SFX/Player Sounds/CurSprint",
		ExitAnimation = "PlayerLargeJumpBackwards",
		AuraOnAnimation = "PlayerTrailAuraTurnOn",
		TauntAnimation = "PlayerTrailAuraTurnOn",
		AscendedAnimation = "PlayerTrailUpTheWaterfall",
		AscensionPose = "PlayerTrailIdle",
		Height = 3.1,
		WeaponSuffix = "Trail",
		SkillTreeBackgroundLeft = "GUI\\Screens\\MasteriesTree_WyrmLeft",
		SkillTreeBackgroundRight = "GUI\\Screens\\MasteriesTree_WyrmRight",
	},
	["PlayerFlying"] =
	{
		ScoreValue = 20,
		-- SprintSound = "/SFX/Player Sounds/NomadSprint",
		ExitAnimation = "PlayerMediumRushing",
		AuraOnAnimation = "PlayerFlyingAuraTurnOn",
		TauntAnimation = "PlayerFlyingAuraTurnOn",
		AscendedAnimation = "PlayerFlyingUpTheWaterFall",
		AscensionPose = "PlayerFlyingAscension",
		Height = 6.5,
		WeaponSuffix = "Flying",
		SkillTreeBackgroundLeft = "GUI\\Screens\\MasteriesTree_HarpLeft",
		SkillTreeBackgroundRight = "GUI\\Screens\\MasteriesTree_HarpRight",
	},
	["PlayerTree"] =
	{
		ScoreValue = 25,
		-- SprintSound = "/SFX/Player Sounds/DemonSprint",
		AuraOnAnimation = "PlayerTreeAuraTurnOn",
		TauntAnimation = "PlayerTreeAuraTurnOn",
		AscendedAnimation = "PlayerTreeUpTheWaterfall",
		AscensionPose = "PlayerTreeAscension",
		Height = 9.1,
		WeaponSuffix = "Tree",
		SkillTreeBackgroundLeft = "GUI\\Screens\\MasteriesTree_SapLeft",
		SkillTreeBackgroundRight = "GUI\\Screens\\MasteriesTree_SapRight",
	},
	["PlayerMonster"] =
	{
		ScoreValue = 25,
		SprintSound = "/SFX/Player Sounds/CroneIntenseHiss",
		AuraOnAnimation = "PlayerMonsterAuraTurnOn",
		TauntAnimation = "PlayerMonsterAuraTurnOn",
		AscendedAnimation = "PlayerMonsterUpTheWaterfall",
		AscensionPose = "PlayerMonsterAscension",
		Height = 7.1,
		WeaponSuffix = "Monster",
		SkillTreeBackgroundLeft = "GUI\\Screens\\MasteriesTree_CroneLeft",
		SkillTreeBackgroundRight = "GUI\\Screens\\MasteriesTree_CroneRight",
	},
}

PlayerDefaultAttributes =
{
	["PlayerImp"] =
	{
		["PlayerAttributeAura"] = 17,
		["PlayerAttributeSpeed"] = 10,
		["PlayerAttributeBallControl"] = 5,
		["PlayerAttributeStamina"] = 10,
		["PlayerAttributeFame"] = 12,
		["PlayerAttributeWeapon"] = 0,
		["PlayerAttributeRespawn"] = 19,
		["PlayerAttributeLuck"] = 3,
	},

	["PlayerTrail"] =
	{
		["PlayerAttributeAura"] = 5,
		["PlayerAttributeSpeed"] = 25,
		["PlayerAttributeBallControl"] = 2,
		["PlayerAttributeStamina"] = 10,
		["PlayerAttributeFame"] = 6,
		["PlayerAttributeWeapon"] = 0,
		["PlayerAttributeRespawn"] = 17,
		["PlayerAttributeLuck"] = 5,
	},

	["PlayerSmall"] =
	{
		["PlayerAttributeAura"] = 3,
		["PlayerAttributeSpeed"] = 15,
		["PlayerAttributeBallControl"] = 3,
		["PlayerAttributeStamina"] = 10,
		["PlayerAttributeFame"] = 5,
		["PlayerAttributeWeapon"] = 0,
		["PlayerAttributeRespawn"] = 25,
		["PlayerAttributeLuck"] = 6,
	},

	["PlayerMedium"] =
	{
		["PlayerAttributeAura"] = 13,
		["PlayerAttributeSpeed"] = 12,
		["PlayerAttributeBallControl"] = 4,
		["PlayerAttributeStamina"] = 10,
		["PlayerAttributeFame"] = 9,
		["PlayerAttributeWeapon"] = 0,
		["PlayerAttributeRespawn"] = 20,
		["PlayerAttributeLuck"] = 10,
	},

	["PlayerMediumAlt"] =
	{
		["PlayerAttributeAura"] = 10,
		["PlayerAttributeSpeed"] = 16,
		["PlayerAttributeBallControl"] = 4,
		["PlayerAttributeStamina"] = 10,
		["PlayerAttributeFame"] = 9,
		["PlayerAttributeWeapon"] = 0,
		["PlayerAttributeRespawn"] = 21,
		["PlayerAttributeLuck"] = 12,
	},

	["PlayerFlying"] =
	{
		["PlayerAttributeAura"] = 7,
		["PlayerAttributeSpeed"] = 10,
		["PlayerAttributeBallControl"] = 6,
		["PlayerAttributeStamina"] = 10,
		["PlayerAttributeFame"] = 11,
		["PlayerAttributeWeapon"] = 0,
		["PlayerAttributeRespawn"] = 15,
		["PlayerAttributeLuck"] = 8,
	},

	["PlayerTree"] =
	{
		["PlayerAttributeAura"] = 21,
		["PlayerAttributeSpeed"] = 6,
		["PlayerAttributeBallControl"] = 8,
		["PlayerAttributeStamina"] = 10,
		["PlayerAttributeFame"] = 10,
		["PlayerAttributeWeapon"] = 0,
		["PlayerAttributeRespawn"] = 13,
		["PlayerAttributeLuck"] = 9,
	},

	["PlayerLarge"] =
	{
		["PlayerAttributeAura"] = 25,
		["PlayerAttributeSpeed"] = 6,
		["PlayerAttributeBallControl"] = 10,
		["PlayerAttributeStamina"] = 10,
		["PlayerAttributeFame"] = 8,
		["PlayerAttributeWeapon"] = 0,
		["PlayerAttributeRespawn"] = 11,
		["PlayerAttributeLuck"] = 11,
	},

	["PlayerMonster"] =
	{
		["PlayerAttributeAura"] = 19,
		["PlayerAttributeSpeed"] = 11,
		["PlayerAttributeBallControl"] = 13,
		["PlayerAttributeStamina"] = 10,
		["PlayerAttributeFame"] = 13,
		["PlayerAttributeWeapon"] = 0,
		["PlayerAttributeRespawn"] = 9,
		["PlayerAttributeLuck"] = 14,
	},
}

OnAnyLoad{ function( triggerArgs )

	PlayerData = PlayerData or {}

	-- Team and Character Data
	PlayerData.Teams =
	{
		[1] =
		{
			-- Nightwings Team (Player Team)
			Name = "TeamName01",
			GoalDecalSigil = "NightwingsGrill01",
			MeteorColorGrade = "Team01",
			MaskHue = 210, MaskSaturationAddition = -20, MaskValueAddition = -15,
			MaskHue2 = 10, MaskSaturationAddition2 = 0,  MaskValueAddition2 = 0,
			IntroVO = "/VO/Match_120", VictoryVO = "/VO/Match_144",
			AscensionVictoryVO = "/VO/Match_556",
			PostMatchSigil = "SigilNightwings",
			RosterScreenSigil = "GUI\\Sigils\\Nightwings_01_UI",
			LargeSigil = "Tilesets\\Arena\\Nightwings_01",
			PyreIcon = "GUI\\Icons\\Pyre\\PyreIcon_Nightwings",
			MusicTheme = "/Music/MatchMusic5_MC",
			PrepareTakeOffEvents = { "PrepareTakeOff_01", "PrepareTakeOff_02", "PrepareTakeOff_03" },
			ForageResultEvents = { "ForageResult_02", "ForageResult_03", "ForageResult_04", "ForageResult_05", "ForageResult_06", "ForageResult_07", "ForageResult_08", "ForageResult_09", "ForageResult_10" },
			FlyingEvents = { "FlyingInteraction_01" },
			PreMatchEvents = { "OpenStructure_ReachedGoal_01", "OpenStructure_ReachedGoal_02", "OpenStructure_ReachedGoal_03", "OpenStructure_ReachedGoal_04", "OpenStructure_ReachedGoal_05" },
			StarPickEvents = { "OpenStructure_Onward_StarPicked_Nightwings_01", "OpenStructure_Onward_01_StarPicked" },
			MatchStartEvents = { "OpenStructure_Match_Beginning_01" },
			GrudgeMatchStartEvents = { "OpenStructure_GrudgeMatch_Beginning_01" },
			MatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_04" },
			-- MatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_01", "OpenStructure_Match_DraftEnd_02", "OpenStructure_Match_DraftEnd_03" },
			MatchVictoryEvents = { "OpenStructure_Match_YouWon_01", "OpenStructure_Match_YouWon_02" },
			MatchDefeatEvents = { "OpenStructure_Match_YouLost_01" },
			PostMatchWinEvents = { "OpenStructure_Onward_02_Win", "OpenStructure_Onward_03_Win" },
			PostMatchLossEvents = { "OpenStructure_Onward_02_Loss", "OpenStructure_Onward_03_Loss" },
			AscensionMatchStartEvents = { "OpenStructure_Match_Ascension_Beginning_01" },
			AscensionMatchDraftEndEvents = { "OpenStructure_Match_Ascension_DraftEnd_01", },
			AscensionReMatchDraftEndEvents = { "OpenStructure_GrudgeMatch_Ascension_DraftEnd_01", },
			AscensionFirstDraftPickEvents = { "OpenStructure_Match_Ascension_FirstDraftPick_FirstChance_01" },
			AscensionNextDraftPickEvents = { "OpenStructure_Match_Ascension_NextDraftPick_FirstChance_01", "OpenStructure_Match_Ascension_NextDraftPick_FirstChance_02" },
			AscensionFirstDraftPick_SecondChanceEvents = { "OpenStructure_Match_Ascension_FirstDraftPick_SecondChance_01", "OpenStructure_Match_Ascension_FirstDraftPick_SecondChance_02" },
			AscensionFirstDraftPick_RepeatedFailures = { "OpenStructure_Match_Ascension_FirstDraftPick_FourPlusChances_01", "OpenStructure_Match_Ascension_FirstDraftPick_FourPlusChances_02", "OpenStructure_Match_Ascension_FirstDraftPick_FourPlusChances_03" },
			AscensionNextDraftPick_SecondChanceEvents = { "OpenStructure_Match_Ascension_NextDraftPick_SecondChance_01", "OpenStructure_Match_Ascension_NextDraftPick_SecondChance_02" },
			AscensionPlayerSuccessEvents = { "AscensionSuccess_PlayerTeam_Misc_01" },
			AscensionPlayerFailureEvents = { "AscensionFailure_PlayerTeam_ThirdStrike_01" },
			-- AscensionPlayerFailureEvents = { "AscensionFailure_PlayerTeam_Misc_01", "AscensionFailure_PlayerTeam_Misc_02" },
			AscensionRivalSuccessEvents = { "AscensionSuccess_RivalTeam_Misc_01" },
			AscensionRivalFailureEvents = { "AscensionFailure_RivalTeam_Misc_01" },
			PostAscensionSuccessEvents = { "OpenStructure_PostAscension_Success_01", "OpenStructure_PostAscension_Success_02" },
			PostAscensionFailureEvents = { "OpenStructure_PostAscension_Fail_01", "OpenStructure_PostAscension_Fail_02" },
			StudyIntroPhrases = { "StudySetup_01", "StudySetup_02", "StudySetup_03", "StudySetup_04", "StudySetup_05", "StudySetup_06", "StudySetup_07", "StudySetup_08", "StudySetup_09", "StudySetup_10", "StudySetup_11" },
			LastMatchResult_YouWonPhrases = { "LastMatchResult_Phrase01_Victory_01", "LastMatchResult_Phrase01_Victory_02", "LastMatchResult_Phrase01_Victory_03", "LastMatchResult_Phrase01_Victory_04", "LastMatchResult_Phrase01_Victory_05", "LastMatchResult_Phrase01_Victory_06", "LastMatchResult_Phrase01_Victory_07" },
			LastMatchResult_AltYouWonPhrases = { "LastMatchResult_Phrase01A_Victory_01", "LastMatchResult_Phrase01A_Victory_02", "LastMatchResult_Phrase01A_Victory_03", "LastMatchResult_Phrase01A_Victory_04", "LastMatchResult_Phrase01A_Victory_05", "LastMatchResult_Phrase01A_Victory_06", "LastMatchResult_Phrase01A_Victory_07" },
			LastMatchResult_YouLostPhrases = { "LastMatchResult_Phrase01_Defeat_01", "LastMatchResult_Phrase01_Defeat_02", "LastMatchResult_Phrase01_Defeat_03", "LastMatchResult_Phrase01_Defeat_04", "LastMatchResult_Phrase01_Defeat_05", "LastMatchResult_Phrase01_Defeat_06", "LastMatchResult_Phrase01_Defeat_07" },
			LastMatchResult_AltYouLostPhrases = { "LastMatchResult_Phrase01A_Defeat_01", "LastMatchResult_Phrase01A_Defeat_02", "LastMatchResult_Phrase01A_Defeat_03", "LastMatchResult_Phrase01A_Defeat_04", "LastMatchResult_Phrase01A_Defeat_05", "LastMatchResult_Phrase01A_Defeat_06", "LastMatchResult_Phrase01A_Defeat_07" },
			LastMatchResult_BigVictoryPhrases = { "LastMatchResult_Phrase02_Victory_Big_01", "LastMatchResult_Phrase02_Victory_Big_02", "LastMatchResult_Phrase02_Victory_Big_03", "LastMatchResult_Phrase02_Victory_Big_04", "LastMatchResult_Phrase02_Victory_Big_05", "LastMatchResult_Phrase02_Victory_Big_06" },
			LastMatchResult_CloseVictoryPhrases = { "LastMatchResult_Phrase02_Victory_Close_01", "LastMatchResult_Phrase02_Victory_Close_02", "LastMatchResult_Phrase02_Victory_Close_03", "LastMatchResult_Phrase02_Victory_Close_04", "LastMatchResult_Phrase02_Victory_Close_05", "LastMatchResult_Phrase02_Victory_Close_06" },
			LastMatchResult_EvenVictoryPhrases = { "LastMatchResult_Phrase02_Victory_Even_01", "LastMatchResult_Phrase02_Victory_Even_02", "LastMatchResult_Phrase02_Victory_Even_03", "LastMatchResult_Phrase02_Victory_Even_04", "LastMatchResult_Phrase02_Victory_Even_05", "LastMatchResult_Phrase02_Victory_Even_06" },
			LastMatchResult_BigDefeatPhrases = { "LastMatchResult_Phrase02_Defeat_Big_01", "LastMatchResult_Phrase02_Defeat_Big_02", "LastMatchResult_Phrase02_Defeat_Big_03", "LastMatchResult_Phrase02_Defeat_Big_04", "LastMatchResult_Phrase02_Defeat_Big_05", "LastMatchResult_Phrase02_Defeat_Big_06" },
			LastMatchResult_CloseDefeatPhrases = { "LastMatchResult_Phrase02_Defeat_Close_01", "LastMatchResult_Phrase02_Defeat_Close_02", "LastMatchResult_Phrase02_Defeat_Close_03", "LastMatchResult_Phrase02_Defeat_Close_04", "LastMatchResult_Phrase02_Defeat_Close_05", "LastMatchResult_Phrase02_Defeat_Close_06" },
			LastMatchResult_EvenDefeatPhrases = { "LastMatchResult_Phrase02_Defeat_Even_01", "LastMatchResult_Phrase02_Defeat_Even_02", "LastMatchResult_Phrase02_Defeat_Even_03", "LastMatchResult_Phrase02_Defeat_Even_04", "LastMatchResult_Phrase02_Defeat_Even_05", "LastMatchResult_Phrase02_Defeat_Even_06" },
			WinsSinceLastAscensionAttempt = 0,

			TeamAVersusLineNames = { "/VO/Match_1201" },
			TeamBVersusLineNames = { "/VO/Match_1202" },
			TeamScoresFirstSpeechLines =
			{
				-- The Nightwings make their mark upon the flame!
				"/VO/Justice_513",
				-- The Nightwings thus assert themselves.
				"/VO/Match_512",
				-- The Nightwings are the first to strike!
				"/VO/Match_516",
			},
			TeamScoredOnFirstSpeechLines =
			{
				-- The Nightwings' Pyre is the first to falter!
				"/VO/Justice_514",
				-- The Orb bathes first within the Nightwings' flame!
				"/VO/Justice_516",
			},
			TeamTakesLeadSpeechLines =
			{
				-- The Nightwings' Pyre burns brighter for the while.
				"/VO/Justice_553",
				-- The Nightwings shall prevail at this rate.
				"/VO/Justice_554",
				-- The Nightwings now are closer to achieving victory.
				"/VO/Justice_555",
				-- I wonder shall the Nightwings press their luck?
				"/VO/Justice_556",
				-- Best not get overconfident, Nightwings.
				"/VO/Justice_557",
				-- Let's see you Nightwings keep this up.
				"/VO/Justice_558",
				-- The Nightwings' Pyre burns brighter for now.
				"/VO/Match_522",
				-- The Nightwings edge closer to victory.
				"/VO/Match_523",
				-- It seems the Nightwings are a bit ahead.
				"/VO/Match_524",
			},
			TeamLosesLeadSpeechLines =
			{
				-- The Nightwings seem to be falling behind.
				"/VO/Match_525",
				-- The Nightwings' adversaries gained an edge.
				"/VO/Match_526",
				-- A show of strength from the Nightwings' opponents.
				"/VO/Match_527",
			},
			TeamFullWipeLines =
			{
				-- Wherever did the Nightwings go?
				"/VO/Justice_575",
				-- Tough luck, Nightwings.
				"/VO/Justice_576",
				-- Oh you poor Nightwings.
				"/VO/Justice_577",
				-- All of the Nightwings, banished.
				"/VO/Justice_578",
				-- Quite foul for the Nightwings.
				"/VO/Justice_579",
				-- All three Nightwings, poof.
				"/VO/Justice_580",
			},
			TeamPyreExtinguishedLines =
			{
				-- The Nightwings' flame is out!
				"/VO/Justice_567",
				-- Nightwings flames extinguished!
				"/VO/Justice_568",
			},
			TeamReadyLines =
			{
				-- Nightwings, stand prepared.
				"/VO/Justice_476",
				-- Nightwings, stand ready.
				"/VO/Justice_477",
				-- Prepare yourselves, Nightwings.
				"/VO/Justice_478",
				-- Declare yourselves, Nightwings!
				-- "/VO/Justice_455",
				-- Are all the Nightwings gathered?
				-- "/VO/Justice_456",
			},

			TeamBench =
			{
				-- Hedwyn / Nomad
				{
					Archetype = "PlayerMedium",
					Tags = { "Story_Friend" },
					LocId = LocId_Story_Friend,
					Personality = "Personality_Friend",
					Gender = "male",
					FirstName = "Chars_Friend_FirstName",
					NickName = "Chars_Friend_NickName",
					TitlePostFix = "Nomad_Title_01",
					StartingTrait = "Friend01",
					Past = "Past_Friend01",
					Reason = "Reason_Friend01",
					Reputation = "Friend_Reputation_01",
					Backstory = "Backstory_Friend01",
					RevealedBackstories = { "Backstory_Friend01_Complete", },
					Goal = "Goal_Friend01",
					Fear = "Fear_Friend01",
					YearsExiled = 5,
					Birthday = { Month = "mJuly", Date = 29 },
					Portrait = "NomadHedwyn01",
					SadPortrait = "NomadHedwyn01_Vulnerable",
					ForfeitVictoryScreenPortrait = "NomadHedwyn01_Robed_Vulnerable",
					ForfeitVictoryVO = "/VO/Nomad_Hedwyn_0310__10",
					AscensionSendOffVO = "/VO/Justice_985",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Hedwyn/",
					EventPositionOffset = -30,
					EventPositionOffsetRobed = -80,
					EventPositionOffsetMasked = -20,
					CaravanOffsetX = -50,
					CaravanOffsetY = 20,
					CaravanRobedOffsetX = -50,
					CaravanRobedOffsetY = 120,
					StartingXP = 250,
					PlayerAttributeRespawn = 22,
					SkillTreeA = "PlayerMediumA",
					SkillTreeB = "PlayerMediumB",
					StartingSkills = { },
					PreTrainingDialogue = { "PreTraining_Friend_01", "PreTraining_Friend_02" },
					LevelUpDialogue = { "LevelUpDialogue_Friend_01", "LevelUpDialogue_Friend_02", "LevelUpDialogue_Friend_03", "LevelUpDialogue_Friend_04" },
					FirstScoreSpeech = "firstscorehedwyn",
					BuddyCharTag = "Story_Doc",
					RivalCharTag = "Story_Nightwing",
					WagonConversations = { "SideCon_Friend_Disposition", "SideCon_Friend_ProblemSolving" },
					PostRivalryConversations = { },
					PostAscensionBuddyGoneConversations = { "SideCon_BuddyAscended_Friend_01" },
					PostAscensionLossConversations = { },
					AscensionNextDraftPickEvents = { "Ascension_Friend_NextDraftPick_FirstChance_01", "Ascension_Friend_NextDraftPick_FirstChance_02", "Ascension_Friend_NextDraftPick_FirstChance_03", "Ascension_Friend_NextDraftPick_FirstChance_04", "Ascension_Friend_NextDraftPick_FirstChance_05" },
					AscensionNextDraftPickRetryEvents = { "Ascension_Friend_NextDraftPick_Retry_01", "Ascension_Friend_NextDraftPick_Retry_02", "Ascension_Friend_NextDraftPick_Retry_03", "Ascension_Friend_NextDraftPick_Retry_04", "Ascension_Friend_NextDraftPick_Retry_05" },
					AscensionSuccessEvent = "AscensionSuccess_Friend",
					AscensionFailureEvents = { "AscensionFailure_Friend", "AscensionFailure_Friend_02" },
					LiberationPlanBonus = 5,
					PostMatchAscensionSuccessEvent = "Week9_Onward_Ascended_Friend",
					PostMatchAscensionFailureEvent = "Week9_Onward_FailedAscension_Friend",
					-- PostAscensionNewTravelEvents = { "OpenStructure_CharAscended_Friend_01" },
					PostAscensionNewJunctionEvents = { "OpenStructure_CharAscended_Friend_01" },
					PostAscensionRemoveTravelEvents = { "OpenStructure_Misc_Friend_01" },
					AscendedTooltip = "AscendedChar_Friend",
					ChallengePickEvents = { "ChallengeMatch_Pick_Friend_01" },
					ChallengeIntroEvents = { "ChallengeMatch_Intro_Friend_01" },
					ChallengeSuccessEvents = { "ChallengeMatch_Success_Friend_01" },
					ChallengeFailureEvents = { "ChallengeMatch_Failure_Friend_01" },
					ChallengeRewardEvents = { "ChallengeMatch_Reward_Friend_01" },

					EpilogueRemainedEvent = "Epilogue_Friend_Remained_01",
					EpilogueAscendedEvent = "Epilogue_Friend_Ascended_01",
					EpilogueAscendedPlanAEvent = "Epilogue_Friend_AscendedPlanA_01",
					EpilogueAscendedPlanBEvent = "Epilogue_Friend_AscendedPlanB_01",
					EpilogueBuddyCharTag = "Story_Badass",
					EpilogueAscendedWithBuddyEvent = "Epilogue_Friend_Ascended_WithBuddy_01",
					EpilogueRemainedWithBuddyEvent = "Epilogue_Friend_Remained_WithBuddy_01",
					EpilogueWithoutBuddyEvent = "Epilogue_Friend_WithoutBuddy_01",
					EpilogueScavengersAscendedEvent = "Epilogue_Friend_ScavengersAscended_01",
					EpilogueAllScavengersAscendedEvent = "Epilogue_Friend_ScavengersAscended_All_01",
					EpilogueSomeScavengersAscendedEvent = "Epilogue_Friend_ScavengersAscended_Some_01",
					EpilogueNoScavengersAscendedEvent = "Epilogue_Friend_ScavengersAscended_None_01",
					-- EpilogueWithRivalEvent = "Epilogue_Badass_WithRival_01",
					EpilogueConclusionEvent = "Epilogue_Friend_Conclusion_01",

					AttractQuip = "/VO/Nomad_Hedwyn_0294__9",
					DraftedSpeech = "/VO/Match_93",
					VoiceUseTeamPostfix = false,
					LevelUpSpeechLines = { "/VO/Justice_687", "/VO/Justice_688", "/VO/Justice_689", "/VO/Justice_690" },
					ScoringSpeechLines = { "/VO/Match_341", "/VO/Match_342" },
					ThrowScoringSpeechLines = { "/VO/Match_839", "/VO/Match_840", "/VO/Match_841" },
					BanishedSpeechLines = { "/VO/Match_349", "/VO/Match_350", "/VO/Match_351", "/VO/Match_352", "/VO/Match_353" },
					Height = 5,
					MusicTheme = "/Music/ScavengersTheme_MC",
					MusicStemName = "Mandolins",
					MusicStemValue = 1,
					EnteredShopAscendedNarration = "EnteredShop_FriendAscended_01",
					RushCommandText = "Controls_Sprint",
					BenchedConversationWin = "SideCon_Friend_Benched_01",
					BenchedConversationLoss = "SideCon_Friend_Benched_02",
					CurrentStatusesA = { "Status_A_Friend_01", "Status_A_Friend_02", "Status_A_Friend_03", "Status_A_Friend_04", "Status_A_Friend_05", "Status_A_Friend_06", "Status_A_Friend_07", "Status_A_Friend_08", "Status_A_Friend_09", "Status_A_Friend_10", "Status_A_Friend_11", "Status_A_Friend_12", "Status_A_Friend_13", "Status_A_Friend_14", "Status_A_Friend_15", "Status_A_Friend_16" },
					CurrentStatusesW = { "Status_W_Friend_01", "Status_W_Friend_02", "Status_W_Friend_03", "Status_W_Friend_04", "Status_W_Friend_05", "Status_W_Friend_06", "Status_W_Friend_07", "Status_W_Friend_08", "Status_W_Friend_09", "Status_W_Friend_10", "Status_W_Friend_11", "Status_W_Friend_12", "Status_W_Friend_13", "Status_W_Friend_14", "Status_W_Friend_15", },
					CurrentStatusesR = { "Status_R_Friend_01", "Status_R_Friend_02", "Status_R_Friend_03", "Status_R_Friend_04", "Status_R_Friend_05", "Status_R_Friend_06", "Status_R_Friend_07", "Status_R_Friend_08", "Status_R_Friend_09", "Status_R_Friend_10" },
					CurrentStatusesI = { "Status_I_Friend_01", "Status_I_Friend_02", "Status_I_Friend_03", "Status_I_Friend_04", "Status_I_Friend_05", "Status_I_Friend_06", "Status_I_Friend_07" },
					CurrentStatusesN = { "Status_N_Friend_01", "Status_N_Friend_02", "Status_N_Friend_03", "Status_N_Friend_04", "Status_N_Friend_05", "Status_N_Friend_06", "Status_N_Friend_07", "Status_N_Friend_08", "Status_N_Friend_09", "Status_N_Friend_10", },
				},

				-- Jodi / Jodariel / Demon
				{
					Archetype = "PlayerLarge",
					Tags = { "Story_Badass" },
					LocId = LocId_Story_Badass,
					Personality = "Personality_Badass",
					Gender = "female",
					FirstName = "Chars_Badass_FirstName",
					NickName = "Chars_Badass_NickName",
					StartingTrait = "Badass01",
					Past = "Past_Badass01",
					Reason = "Reason_Badass01",
					Goal = "Goal_Badass01",
					Fear = "Fear_Badass01",
					Reputation = "Badass_Reputation_01",
					Backstory = "Backstory_Badass01",
					RevealedBackstories = { "Backstory_Badass01_Complete", },
					YearsExiled = 16,
					Birthday = { Month = "mDecember", Date = 23 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop2",
					TextSpeedMultiplier = 1.15,
					Portrait = "DemonJodi01",
					SadPortrait = "DemonJodi01_Pensive",
					VictoryScreenPortrait = "DemonJodi01_Robed_Smirking",
					ForfeitVictoryScreenPortrait = "DemonJodi01_Robed_Pensive",
					ForfeitVictoryVO = "/VO/Demon_Jodi_0208__3",
					AscensionSendOffVO = "/VO/Justice_986",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Jodi/",
					EventPositionOffset = -60,
					CaravanOffsetX = -50,
					CaravanOffsetY = 20,
					CaravanRobedOffsetX = -50,
					CaravanRobedOffsetY = 70,
					StartingXP = 750,
					PlayerAttributeAura = 23,
					PlayerAttributeRespawn = 9,
					SkillTreeA = "PlayerLargeA",
					SkillTreeB = "PlayerLargeB",
					StartingSkills = { },
					PreTrainingDialogue = { "PreTraining_Badass_01", "PreTraining_Badass_02" },
					LevelUpDialogue = { "LevelUpDialogue_Badass_01", "LevelUpDialogue_Badass_02", "LevelUpDialogue_Badass_03", "LevelUpDialogue_Badass_04" },
					FirstScoreSpeech = "firstscorejodariel",
					BuddyCharTag = "Story_Friend",
					RivalCharTag = "Story_Temper",
					WagonConversations = { "SideCon_Badass_Past_01", "SideCon_Badass_Horns" },
					PostRivalryConversations = { },
					PostAscensionBuddyGoneConversations = { "SideCon_BuddyAscended_Badass_01" },
					PostAscensionLossConversations = { },
					AscensionNextDraftPickEvents = { "Ascension_Badass_NextDraftPick_FirstChance_01", "Ascension_Badass_NextDraftPick_FirstChance_02", "Ascension_Badass_NextDraftPick_FirstChance_03", "Ascension_Badass_NextDraftPick_FirstChance_04", "Ascension_Badass_NextDraftPick_FirstChance_05" },
					AscensionNextDraftPickRetryEvents = { "Ascension_Badass_NextDraftPick_Retry_01", "Ascension_Badass_NextDraftPick_Retry_02", "Ascension_Badass_NextDraftPick_Retry_03", "Ascension_Badass_NextDraftPick_Retry_04", "Ascension_Badass_NextDraftPick_Retry_05" },
					AscensionSuccessEvent = "AscensionSuccess_Badass",
					AscensionFailureEvents = { "AscensionFailure_Badass", "AscensionFailure_Badass_02" },
					LiberationPlanBonus = 6,
					PostMatchAscensionSuccessEvent = "Week9_Onward_Ascended_Badass",
					PostMatchAscensionFailureEvent = "Week9_Onward_FailedAscension_Badass",
					PostAscensionNewJunctionEvents = { "OpenStructure_CharAscended_Badass_01" },
					PostAscensionRemoveTravelEvents = { "OpenStructure_Misc_Badass_01" },
					AscendedTooltip = "AscendedChar_Badass",
					ChallengePickEvents = { "ChallengeMatch_Pick_Badass_01" },
					ChallengeIntroEvents = { "ChallengeMatch_Intro_Badass_01" },
					ChallengeSuccessEvents = { "ChallengeMatch_Success_Badass_01" },
					ChallengeFailureEvents = { "ChallengeMatch_Failure_Badass_01" },
					ChallengeRewardEvents = { "ChallengeMatch_Reward_Badass_01" },

					EpilogueBuddyCharTag = "Story_Friend",
					EpilogueBuddyChar2Tag = "Story_Psycho",
					EpilogueRivalCharTag = "Story_Temper",
					EpilogueRemainedEvent = "Epilogue_Badass_Remained_01",
					EpilogueAscendedEvent = "Epilogue_Badass_Ascended_01",
					EpilogueAscendedPlanAEvent = "Epilogue_Badass_AscendedPlanA_01",
					EpilogueAscendedPlanBEvent = "Epilogue_Badass_AscendedPlanB_01",
					EpilogueAscendedPostPlanEvent = "Epilogue_Badass_AscendedPostPlan_01",
					EpilogueWithBuddyEvent = "Epilogue_Badass_WithBuddy_01",
					EpilogueWithoutBuddyEvent = "Epilogue_Badass_WithoutBuddy_01",
					EpilogueWithBuddy2Event = "Epilogue_Badass_WithBuddy2_01",
					EpilogueAscendedWithoutBuddy2Event = "Epilogue_Badass_Ascended_WithoutBuddy2_01",
					EpilogueRemainedWithoutBuddy2Event = "Epilogue_Badass_Remained_WithoutBuddy2_01",
					-- EpilogueWithRivalEvent = "Epilogue_Badass_WithRival_01",
					EpilogueAscendedWithRivalEvent = "Epilogue_Badass_Ascended_WithRival_01",
					EpilogueRemainedWithRivalEvent = "Epilogue_Badass_Remained_WithRival_01",
					EpilogueWithoutRivalNarrationReqs = { "OpenStructure_Match_Conclusion_Rivalry_Tempers_01" },
					EpilogueWithoutRivalEvent = "Epilogue_Badass_WithoutRival_01",
					EpilogueConclusionEvent = "Epilogue_Badass_Conclusion_01",

					AttractQuip = "/VO/Demon_Jodi_9a",
					DraftedSpeech = "/VO/Match_21",
					LevelUpSpeechLines = { "/VO/Justice_287", "/VO/Justice_691", "/VO/Justice_693", "/VO/Justice_694" },
					EventEnterSound = "/SFX/World Sounds/DemonEnter",
					EventExitSound = "/SFX/World Sounds/DemonEnter",
					ScoringSpeechLines = { "/VO/Match_343", "/VO/Match_344" },
					ThrowScoringSpeechLines = { "/VO/Match_842", "/VO/Match_843", "/VO/Match_844" },
					BanishedSpeechLines = { "/VO/Match_354", "/VO/Match_355", "/VO/Match_356", "/VO/Match_357", "/VO/Match_358" },
					Height = 8,
					MusicTheme = "/Music/ScavengersTheme_MC",
					MusicStemName = "Toms",
					MusicStemValue = 1,
					EnteredShopAscendedNarration = "EnteredShop_BadassAscended_01",
					RushCommandText = "Controls_Sprint_Demon",
					BenchedConversationWin = "SideCon_Badass_Benched_01",
					BenchedConversationLoss = "SideCon_Badass_Benched_02",
					CurrentStatusesA = { "Status_A_Badass_01", "Status_A_Badass_02", "Status_A_Badass_03", "Status_A_Badass_04", "Status_A_Badass_05", "Status_A_Badass_06", "Status_A_Badass_07", "Status_A_Badass_08", "Status_A_Badass_09", "Status_A_Badass_10", "Status_A_Badass_11", "Status_A_Badass_12", "Status_A_Badass_13", "Status_A_Badass_14", "Status_A_Badass_15", "Status_A_Badass_16" },
					CurrentStatusesW = { "Status_W_Badass_01", "Status_W_Badass_02", "Status_W_Badass_03", "Status_W_Badass_04", "Status_W_Badass_05", "Status_W_Badass_06", "Status_W_Badass_07", "Status_W_Badass_08", "Status_W_Badass_09", "Status_W_Badass_10", "Status_W_Badass_11", "Status_W_Badass_12", "Status_W_Badass_13", "Status_W_Badass_14", "Status_W_Badass_15", },
					CurrentStatusesR = { "Status_R_Badass_01", "Status_R_Badass_02", "Status_R_Badass_03", "Status_R_Badass_04", "Status_R_Badass_05", "Status_R_Badass_06", "Status_R_Badass_07", "Status_R_Badass_08", "Status_R_Badass_09", "Status_R_Badass_10" },
					CurrentStatusesI = { "Status_I_Badass_01", "Status_I_Badass_02", "Status_I_Badass_03", "Status_I_Badass_04", "Status_I_Badass_05", "Status_I_Badass_06", "Status_I_Badass_07" },
					CurrentStatusesN = { "Status_N_Badass_01", "Status_N_Badass_02", "Status_N_Badass_03", "Status_N_Badass_04", "Status_N_Badass_05", "Status_N_Badass_06", "Status_N_Badass_07", "Status_N_Badass_08", "Status_N_Badass_09", "Status_N_Badass_10", },
				},

				-- Rukey / Cur
				{
					Archetype = "PlayerSmall",
					Tags = { "Story_Joker" },
					LocId = LocId_Story_Joker,
					Personality = "Personality_Joker",
					Gender = "male",
					FirstName = "Chars_Joker_FirstName",
					NickName = "Chars_Joker_NickName",
					LastName = "Chars_Joker_LastName",
					FamilyName = "Chars_Joker_LastName",
					LongName = "Chars_Joker_LongName",
					TooltipIds = { FirstName = "Chars_Joker_LongName", ShortName = "Chars_Joker_LongName", FullName = "Chars_Joker_LongName", LastName = "Chars_Joker_LongName", FamilyName = "Chars_Joker_LastName_Tooltip" },
					StartingTrait = "Joker01",
					Past = "Past_Joker01",
					Reason = "Reason_Joker01",
					Reputation = "Joker_Reputation_01",
					Backstory = "Backstory_Joker01",
					RevealedBackstories = { "Backstory_Joker01_Complete", },
					Goal = "Goal_Joker01",
					Fear = "Fear_Joker01",
					YearsExiled = 4,
					Birthday = { Month = "mApril", Date = 4 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop3",
					TextSpeedMultiplier = 0.8,
					Portrait = "CurRukey02",
					SadPortrait = "CurRukey02_Nervous",
					ForfeitVictoryScreenPortrait = "CurRukey02_Robed_Nervous",
					ForfeitVictoryVO = "/VO/Cur_Rukey_0271__12",
					AscensionSendOffVO = "/VO/Justice_987",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Rukey/",
					EventPositionOffset = -100,
					EventPositionOffsetRobed = 0,
					EventPositionOffsetMasked = 0,
					CaravanOffsetX = -90,
					CaravanOffsetY = 100,
					CaravanRobedOffsetX = 0,
					CaravanRobedOffsetY = 100,
					StartingXP = 100,
					PlayerAttributeSpeed = 18,
					SkillTreeA = "PlayerSmallA",
					SkillTreeB = "PlayerSmallB",
					StartingSkills = { },
					PreTrainingDialogue = { "PreTraining_Joker_01", "PreTraining_Joker_02", },
					LevelUpDialogue = { "LevelUpDialogue_Joker_01", "LevelUpDialogue_Joker_02", "LevelUpDialogue_Joker_03", "LevelUpDialogue_Joker_04", },
					FirstScoreSpeech = "firstscorerukey",
					BuddyCharTag = "Story_Knight",
					RivalCharTag = "Story_Dissident",
					WagonConversations = { "SideCon_Joker_Past_01", "SideCon_Joker_FalconRon" },
					PostRivalryConversations = { },
					PostAscensionBuddyGoneConversations = { "SideCon_BuddyAscended_Joker_01" },
					PostAscensionLossConversations = { },
					AscensionNextDraftPickEvents = { "Ascension_Joker_NextDraftPick_FirstChance_01", "Ascension_Joker_NextDraftPick_FirstChance_02", "Ascension_Joker_NextDraftPick_FirstChance_03", "Ascension_Joker_NextDraftPick_FirstChance_04", "Ascension_Joker_NextDraftPick_FirstChance_05" },
					AscensionNextDraftPickRetryEvents = { "Ascension_Joker_NextDraftPick_Retry_01", "Ascension_Joker_NextDraftPick_Retry_02", "Ascension_Joker_NextDraftPick_Retry_03", "Ascension_Joker_NextDraftPick_Retry_04", "Ascension_Joker_NextDraftPick_Retry_05" },
					AscensionSuccessEvent = "AscensionSuccess_Joker",
					AscensionFailureEvents = { "AscensionFailure_Joker", "AscensionFailure_Joker_02" },
					LiberationPlanBonus = 4,
					PostMatchAscensionSuccessEvent = "Week9_Onward_Ascended_Joker",
					PostMatchAscensionFailureEvent = "Week9_Onward_FailedAscension_Joker",
					PostAscensionNewJunctionEvents = { "OpenStructure_CharAscended_Joker_01" },
					PostAscensionRemoveTravelEvents = { "OpenStructure_Misc_Joker_01" },
					AscendedTooltip = "AscendedChar_Joker",
					ChallengePickEvents = { "ChallengeMatch_Pick_Joker_01" },
					ChallengeIntroEvents = { "ChallengeMatch_Intro_Joker_01" },
					ChallengeSuccessEvents = { "ChallengeMatch_Success_Joker_01" },
					ChallengeFailureEvents = { "ChallengeMatch_Failure_Joker_01" },
					ChallengeRewardEvents = { "ChallengeMatch_Reward_Joker_01" },

					EpilogueBuddyCharTag = "Story_Vamp",
					EpilogueBuddyChar2Tag = "Story_Knight",
					EpilogueRivalCharTag = "Story_Dissident",
					EpilogueAscendedEvent = "Epilogue_Joker_Ascended_01",
					EpilogueAscendedPlanAEvent = "Epilogue_Joker_AscendedPlanA_01",
					EpilogueAscendedPlanBEvent = "Epilogue_Joker_AscendedPlanB_01",
					EpilogueAscendedPlanCEvent = "Epilogue_Joker_AscendedPlanC_01",
					EpilogueAscendedPostPlanEvent = "Epilogue_Joker_AscendedPostPlan_01",
					EpilogueConclusionEvent = "Epilogue_Joker_Conclusion_01",
					EpilogueWithBuddyEvent = "Epilogue_Joker_WithBuddy_01",
					EpilogueWithBuddy2Event = "Epilogue_Joker_WithBuddy2_01",
					EpilogueRemainedEvent = "Epilogue_Joker_Remained_01",

					AttractQuip =  "/VO/Cur_Rukey_17",
					DraftedSpeech = "/VO/Match_94",
					LevelUpSpeechLines = { "/VO/Justice_695", "/VO/Justice_696", "/VO/Justice_697", "/VO/Justice_698" },
					ScoringSpeechLines = { "/VO/Match_345", "/VO/Match_346" },
					ThrowScoringSpeechLines = { "/VO/Match_845", "/VO/Match_846", "/VO/Match_847" },
					BanishedSpeechLines = { "/VO/Match_359", "/VO/Match_360", "/VO/Match_361", "/VO/Match_362", "/VO/Match_363" },
					Height = 3,
					MusicTheme = "/Music/ScavengersTheme_MC",
					MusicStemName = "Flutes",
					MusicStemValue = 1,
					EnteredShopAscendedNarration = "EnteredShop_JokerAscended_01",
					RushCommandText = "Controls_Sprint",
					TauntSoundLong = "/SFX/Player Sounds/Vocalizations/Rukey/EmoteLongHowl",
					TauntSound = "/SFX/Player Sounds/Vocalizations/Rukey/EmoteShortHowl",
					BenchedConversationWin = "SideCon_Joker_Benched_01",
					BenchedConversationLoss = "SideCon_Joker_Benched_02",
					CurrentStatusesA = { "Status_A_Joker_01", "Status_A_Joker_02", "Status_A_Joker_03", "Status_A_Joker_04", "Status_A_Joker_05", "Status_A_Joker_06", "Status_A_Joker_07", "Status_A_Joker_08", "Status_A_Joker_09", "Status_A_Joker_10", "Status_A_Joker_11", "Status_A_Joker_12", "Status_A_Joker_13", "Status_A_Joker_14", "Status_A_Joker_15", "Status_A_Joker_16" },
					CurrentStatusesW = { "Status_W_Joker_01", "Status_W_Joker_02", "Status_W_Joker_03", "Status_W_Joker_04", "Status_W_Joker_05", "Status_W_Joker_06", "Status_W_Joker_07", "Status_W_Joker_08", "Status_W_Joker_09", "Status_W_Joker_10", "Status_W_Joker_11", "Status_W_Joker_12", "Status_W_Joker_13", "Status_W_Joker_14", "Status_W_Joker_15", },
					CurrentStatusesR = { "Status_R_Joker_01", "Status_R_Joker_02", "Status_R_Joker_03", "Status_R_Joker_04", "Status_R_Joker_05", "Status_R_Joker_06", "Status_R_Joker_07", "Status_R_Joker_08", "Status_R_Joker_09", "Status_R_Joker_10" },
					CurrentStatusesI = { "Status_I_Joker_01", "Status_I_Joker_02", "Status_I_Joker_03", "Status_I_Joker_04", "Status_I_Joker_05", "Status_I_Joker_06", "Status_I_Joker_07" },
					CurrentStatusesN = { "Status_N_Joker_01", "Status_N_Joker_02", "Status_N_Joker_03", "Status_N_Joker_04", "Status_N_Joker_05", "Status_N_Joker_06", "Status_N_Joker_07", "Status_N_Joker_08", "Status_N_Joker_09", "Status_N_Joker_10", },
				},

				-- Mae / NomadAlt
				{
					Archetype = "PlayerMediumAlt",
					Tags = { "Story_Psycho" },
					LocId = LocId_Story_Psycho,
					Personality = "Personality_Psycho",
					Gender = "female",
					FirstName = "Chars_Psycho_FirstName",
					NickName = "Chars_Psycho_NickName",
					TitlePostFix = "Nomad_Title_02",
					StartingTrait = "Psycho01",
					Past = "Past_Psycho01",
					Reason = "Reason_Psycho01",
					Reputation = "Psycho_Reputation_01",
					Backstory = "Backstory_Psycho01",
					RevealedBackstories = { "Backstory_Psycho01_Complete", },
					Goal = "Goal_Psycho01",
					Fear = "Fear_Psycho01",
					YearsExiled = 2,
					Birthday = { Month = "mNovember", Date = 19 },
					Portrait = "NomadMae01",
					SadPortrait = "NomadMae01_Zen",
					VictoryScreenPortrait = "NomadMae01_Robed_Joy",
					ForfeitVictoryScreenPortrait = "NomadMae01_Robed_Zen",
					ForfeitVictoryVO = "/VO/Mae_229",
					AscensionSendOffVO = "/VO/Justice_988",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Mae/",
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop3",
					EventPositionOffset = 50,
					EventPositionOffsetRobed = 20,
					EventPositionOffsetMasked = 20,
					CaravanOffsetX = 0,
					CaravanOffsetY = 100,
					CaravanRobedOffsetX = -20,
					CaravanRobedOffsetY = 100,
					TextSpeedMultiplier = 0.8,
					SkillTreeA = "PlayerMediumAltA",
					SkillTreeB = "PlayerMediumAltB",
					StartingSkills = { },
					PreTrainingDialogue = { "PreTraining_Psycho_01", "PreTraining_Psycho_02", },
					LevelUpDialogue = { "LevelUpDialogue_Psycho_01", "LevelUpDialogue_Psycho_02", "LevelUpDialogue_Psycho_03", "LevelUpDialogue_Psycho_04" },
					BuddyCharTag = "Story_Badass",
					RivalCharTag = "Story_FateSon",
					WagonConversations = { "SideCon_Psycho_Past_01", "SideCon_Psycho_ScribesConnection" },
					PostRivalryConversations = { },
					PostAscensionBuddyGoneConversations = { "SideCon_BuddyAscended_Psycho_01" },
					PostAscensionLossConversations = { },
					AscensionNextDraftPickEvents = { "Ascension_Psycho_NextDraftPick_FirstChance_01", "Ascension_Psycho_NextDraftPick_FirstChance_02", "Ascension_Psycho_NextDraftPick_FirstChance_03", "Ascension_Psycho_NextDraftPick_FirstChance_04", "Ascension_Psycho_NextDraftPick_FirstChance_05" },
					AscensionNextDraftPickRetryEvents = { "Ascension_Psycho_NextDraftPick_Retry_01", "Ascension_Psycho_NextDraftPick_Retry_02", "Ascension_Psycho_NextDraftPick_Retry_03", "Ascension_Psycho_NextDraftPick_Retry_04", "Ascension_Psycho_NextDraftPick_Retry_05" },
					AscensionSuccessEvent = "AscensionSuccess_Psycho",
					AscensionFailureEvents = { "AscensionFailure_Psycho", "AscensionFailure_Psycho_02" },
					LiberationPlanBonus = 3,
					PostMatchAscensionSuccessEvent = "Week9_Onward_Ascended_Other",
					PostMatchAscensionFailureEvent = "Week9_Onward_FailedAscension_Other",
					PostJoinTravelEvents = { "OpenStructure_Misc_Psycho_01" },
					PostAscensionNewJunctionEvents = { "OpenStructure_CharAscended_Psycho_01" },
					PostAscensionRemoveTravelEvents = { "OpenStructure_Misc_Psycho_01" },
					AscendedTooltip = "AscendedChar_Psycho",
					ChallengePickEvents = { "ChallengeMatch_Pick_Psycho_01" },
					ChallengeIntroEvents = { "ChallengeMatch_Intro_Psycho_01" },
					ChallengeSuccessEvents = { "ChallengeMatch_Success_Psycho_01" },
					ChallengeFailureEvents = { "ChallengeMatch_Failure_Psycho_01" },
					ChallengeRewardEvents = { "ChallengeMatch_Reward_Psycho_01" },

					EpilogueBuddyCharTag = "Story_Mascot",
					EpilogueBuddyChar2Tag = "Story_Badass",
					EpilogueRivalCharTag = "Story_FateSon",
					EpilogueAscendedEvent = "Epilogue_Psycho_Ascended_01",
					EpilogueAscendedPlanAEvent = "Epilogue_Psycho_AscendedPlanA_01",
					EpilogueAscendedPlanBEvent = "Epilogue_Psycho_AscendedPlanB_01",
					EpilogueAscendedPlanCEvent = "Epilogue_Psycho_AscendedPlanC_01",
					EpilogueAscendedPostPlanEvent = "Epilogue_Psycho_AscendedPostPlan_01",
					EpilogueAscendedConclusionEvent = "Epilogue_Psycho_AscendedConclusion_01",
					EpilogueWithBuddyEvent = "Epilogue_Psycho_WithBuddy_01",
					EpilogueWithBuddy2Event = "Epilogue_Psycho_WithBuddy2_01",
					EpilogueWithoutBuddyEvent = "Epilogue_Psycho_WithoutBuddy_01",
					EpilogueWithoutBuddy2Event = "Epilogue_Psycho_WithoutBuddy2_01",
					EpilogueWithRivalEvent = "Epilogue_Psycho_WithRival_01",
					EpilogueWithReaderEvent = "Epilogue_Psycho_WithReader_01",
					EpilogueRemainedEvent = "Epilogue_Psycho_Remained_01",
					EpilogueRemainedConclusionEvent = "Epilogue_Psycho_RemainedConclusion_01",

					AttractQuip = "/VO/Mae_291",
					DraftedSpeech = "/VO/Match_95",
					VoiceUseTeamPostfix = false,
					LevelUpSpeechLines = { "/VO/Justice_699", "/VO/Justice_700", "/VO/Justice_701", "/VO/Justice_702" },
					ScoringSpeechLines = { "/VO/Match_258", "/VO/Match_259", "/VO/Match_260", },
					-- ThrowScoringSpeechLines = { "/VO/Match_848", "/VO/Match_849", "/VO/Match_850" },
					ThrowScoringSpeechLines = { "/VO/Match_1244", "/VO/Match_1245", "/VO/Match_1246" },
					BanishedSpeechLines = { "/VO/Match_261", "/VO/Match_262", "/VO/Match_263", "/VO/Match_264" },
					Height = 4,
					MusicTheme = "/Music/MaeTheme_MC",
					MusicStemName = "Flutes",
					MusicStemValue = 1,
					EnteredShopAscendedNarration = "EnteredShop_PsychoAscended_01",
					BenchedConversationWin = "SideCon_Psycho_Benched_01",
					BenchedConversationLoss = "SideCon_Psycho_Benched_02",
					CurrentStatusesA = { "Status_A_Psycho_01", "Status_A_Psycho_02", "Status_A_Psycho_03", "Status_A_Psycho_04", "Status_A_Psycho_05", "Status_A_Psycho_06", "Status_A_Psycho_07", "Status_A_Psycho_08", "Status_A_Psycho_09", "Status_A_Psycho_10", "Status_A_Psycho_11", "Status_A_Psycho_12", "Status_A_Psycho_13", "Status_A_Psycho_14", "Status_A_Psycho_15", "Status_A_Psycho_16" },
					CurrentStatusesW = { "Status_W_Psycho_01", "Status_W_Psycho_02", "Status_W_Psycho_03", "Status_W_Psycho_04", "Status_W_Psycho_05", "Status_W_Psycho_06", "Status_W_Psycho_07", "Status_W_Psycho_08", "Status_W_Psycho_09", "Status_W_Psycho_10", "Status_W_Psycho_11", "Status_W_Psycho_12", "Status_W_Psycho_13", "Status_W_Psycho_14", "Status_W_Psycho_15", },
					CurrentStatusesR = { "Status_R_Psycho_01", "Status_R_Psycho_02", "Status_R_Psycho_03", "Status_R_Psycho_04", "Status_R_Psycho_05", "Status_R_Psycho_06", "Status_R_Psycho_07", "Status_R_Psycho_08", "Status_R_Psycho_09", "Status_R_Psycho_10" },
					CurrentStatusesI = { "Status_I_Psycho_01", "Status_I_Psycho_02", "Status_I_Psycho_03", "Status_I_Psycho_04", "Status_I_Psycho_05", "Status_I_Psycho_06", "Status_I_Psycho_07" },
					CurrentStatusesN = { "Status_N_Psycho_01", "Status_N_Psycho_02", "Status_N_Psycho_03", "Status_N_Psycho_04", "Status_N_Psycho_05", "Status_N_Psycho_06", "Status_N_Psycho_07", "Status_N_Psycho_08", "Status_N_Psycho_09", "Status_N_Psycho_10", },
				},

				-- Ti'zo / Imp
				{
					Archetype = "PlayerImp",
					Tags = { "Story_Mascot" },
					LocId = LocId_Story_Mascot,
					Personality = "Personality_Mascot",
					Gender = "male",
					FirstName = "Chars_Mascot_FirstName",
					NickName = "Chars_Mascot_NickName",
					StartingTrait = "Mascot01",
					Backstory = "Backstory_Mascot01",
					RevealedBackstories = { "Backstory_Mascot01_Complete", },
					Past = "Past_Mascot01",
					Reason = "Reason_Mascot01",
					Goal = "Goal_Mascot01",
					Fear = "Fear_Mascot01",
					Reputation = "Mascot_Reputation_01",
					TooltipIds = { YearsExiled = "YearsExiled_Alt_Tooltip" },
					-- YearsExiled = 99,
					Birthday = { Month = "mMay", Date = 13 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop3",
					TextSpeedMultiplier = 0.8,
					Portrait = "ImpTizo01",
					SadPortrait = "ImpTizo01_Sad",
					ForfeitVictoryScreenPortrait = "ImpTizo01_Robed_Sad",
					ForfeitVictoryVO = "/VO/Imp_Tizo_0179__3",
					AscensionSendOffVO = "/VO/Justice_989",
					VictoryScreenPortrait = "ImpTizo01_Robed_Stoked",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Tizo/",
					CaravanOffsetX = 0,
					CaravanOffsetY = 10,
					CaravanRobedOffsetX = -70,
					CaravanRobedOffsetY = 10,
					BuddyCharTag = "Story_Psycho",
					RivalCharTag = "Story_Accuser",
					WagonConversations = { "SideCon_Mascot_Past_01", "SideCon_Mascot_Haub_01" },
					PostRivalryConversations = { },
					PostAscensionBuddyGoneConversations = { "SideCon_BuddyAscended_Mascot_01" },
					PostAscensionLossConversations = { },
					AscensionNextDraftPickEvents = { "Ascension_Mascot_NextDraftPick_FirstChance_01", "Ascension_Mascot_NextDraftPick_FirstChance_02", "Ascension_Mascot_NextDraftPick_FirstChance_03", "Ascension_Mascot_NextDraftPick_FirstChance_04", "Ascension_Mascot_NextDraftPick_FirstChance_05" },
					AscensionNextDraftPickRetryEvents = { "Ascension_Mascot_NextDraftPick_Retry_01", "Ascension_Mascot_NextDraftPick_Retry_02", "Ascension_Mascot_NextDraftPick_Retry_03", "Ascension_Mascot_NextDraftPick_Retry_04", "Ascension_Mascot_NextDraftPick_Retry_05" },
					AscensionSuccessEvent = "AscensionSuccess_Mascot",
					AscensionFailureEvents = { "AscensionFailure_Mascot_01", "AscensionFailure_Mascot_02" },
					LiberationPlanBonus = 2,
					PostMatchAscensionSuccessEvent = "Week9_Onward_Ascended_Other",
					PostMatchAscensionFailureEvent = "Week9_Onward_FailedAscension_Other",
					StartingXP = 850,
					SkillTreeA = "PlayerImpA",
					SkillTreeB = "PlayerImpB",
					StartingSkills = { },
					PreTrainingDialogue = { "PreTraining_Mascot_01", "PreTraining_Mascot_02", },
					LevelUpDialogue = { "LevelUpDialogue_Mascot_01", "LevelUpDialogue_Mascot_02", "LevelUpDialogue_Mascot_03", "LevelUpDialogue_Mascot_04", },
					PostJoinTravelEvents = { "OpenStructure_Misc_Mascot_01", },
					PostAscensionNewJunctionEvents = { "OpenStructure_CharAscended_Mascot_01" },
					PostAscensionRemoveTravelEvents = { "OpenStructure_Misc_Mascot_01" },
					AscendedTooltip = "AscendedChar_Mascot",
					ChallengePickEvents = { "ChallengeMatch_Pick_Mascot_01" },
					ChallengeIntroEvents = { "ChallengeMatch_Intro_Mascot_01" },
					ChallengeSuccessEvents = { "ChallengeMatch_Success_Mascot_01" },
					ChallengeFailureEvents = { "ChallengeMatch_Failure_Mascot_01" },
					ChallengeRewardEvents = { "ChallengeMatch_Reward_Mascot_01" },

					EpilogueBuddyCharTag = "Story_Psycho",
					EpilogueBuddyChar2Tag = "Story_Doc",
					EpilogueRivalCharTag = "Story_Nightwing",
					EpilogueAscendedEvent = "Epilogue_Mascot_Ascended_01",
					EpilogueAscendedPlanAEvent = "Epilogue_Mascot_AscendedPlanA_01",
					EpilogueAscendedPlanBEvent = "Epilogue_Mascot_AscendedPlanB_01",
					EpilogueAscendedPlanCEvent = "Epilogue_Mascot_AscendedPlanC_01",
					EpilogueAscendedPostPlanEvent = "Epilogue_Mascot_AscendedPostPlan_01",
					EpilogueAscendedConclusionEvent = "Epilogue_Mascot_AscendedConclusion_01",
					EpilogueWithBuddyEvent = "Epilogue_Mascot_WithBuddy_01",
					EpilogueWithBuddy2Event = "Epilogue_Mascot_WithBuddy2_01",
					EpilogueWithoutBuddy2Event = "Epilogue_Mascot_WithoutBuddy2_01",
					EpilogueWithReaderEvent = "Epilogue_Mascot_WithReader_01",
					EpilogueWithoutReaderEvent = "Epilogue_Mascot_WithoutReader_01",
					EpilogueAscendedWithRivalEvent = "Epilogue_Mascot_Ascended_WithRival_01",
					EpilogueRemainedEvent = "Epilogue_Mascot_Remained_01",
					EpilogueRemainedConclusionEvent = "Epilogue_Mascot_RemainedConclusion_01",

					AttractQuip = "/VO/Imp_Tizo_0141__7",
					DraftedSpeech = "/VO/Match_96",
					LevelUpSpeechLines = { "/VO/Justice_703", "/VO/Justice_704", "/VO/Justice_705", "/VO/Justice_706" },
					ScoringSpeechLines = { "/VO/Match_265", "/VO/Match_266", "/VO/Match_267", },
					ThrowScoringSpeechLines = { "/VO/Match_851", "/VO/Match_852", "/VO/Match_853" },
					BanishedSpeechLines = { "/VO/Match_268", "/VO/Match_269", "/VO/Match_270", "/VO/Match_271" },
					Height = 1,
					MusicTheme = "/Music/ImpTheme_MC",
					MusicStemName = "Misc",
					MusicStemValue = 1,
					EnteredShopAscendedNarration = "EnteredShop_MascotAscended_01",
					CurrentStatusesA = { "Status_A_Mascot_01", "Status_A_Mascot_02", "Status_A_Mascot_03", "Status_A_Mascot_04", "Status_A_Mascot_05", "Status_A_Mascot_06", "Status_A_Mascot_07", "Status_A_Mascot_08", "Status_A_Mascot_09", "Status_A_Mascot_10", "Status_A_Mascot_11", "Status_A_Mascot_12", "Status_A_Mascot_13", "Status_A_Mascot_14", "Status_A_Mascot_15", "Status_A_Mascot_16" },
					CurrentStatusesW = { "Status_W_Mascot_01", "Status_W_Mascot_02", "Status_W_Mascot_03", "Status_W_Mascot_04", "Status_W_Mascot_05", "Status_W_Mascot_06", "Status_W_Mascot_07", "Status_W_Mascot_08", "Status_W_Mascot_09", "Status_W_Mascot_10", "Status_W_Mascot_11", "Status_W_Mascot_12", "Status_W_Mascot_13", "Status_W_Mascot_14", "Status_W_Mascot_15", },
					CurrentStatusesR = { "Status_R_Mascot_01", "Status_R_Mascot_02", "Status_R_Mascot_03", "Status_R_Mascot_04", "Status_R_Mascot_05", "Status_R_Mascot_06", "Status_R_Mascot_07", "Status_R_Mascot_08", "Status_R_Mascot_09", "Status_R_Mascot_10" },
					CurrentStatusesI = { "Status_I_Mascot_01", "Status_I_Mascot_02", "Status_I_Mascot_03", "Status_I_Mascot_04", "Status_I_Mascot_05", "Status_I_Mascot_06", "Status_I_Mascot_07" },
					CurrentStatusesN = { "Status_N_Mascot_01", "Status_N_Mascot_02", "Status_N_Mascot_03", "Status_N_Mascot_04", "Status_N_Mascot_05", "Status_N_Mascot_06", "Status_N_Mascot_07", "Status_N_Mascot_08", "Status_N_Mascot_09", "Status_N_Mascot_10", },
				},

				-- Sir Gilman / Wyrm
				{
					Archetype = "PlayerTrail",
					Tags = { "Story_Knight" },
					LocId = LocId_Story_Knight,
					Personality = "Personality_Knight",
					Gender = "male",
					SurName = "Worm_Honorific_Male",
					FirstName = "Chars_Knight_FirstName",
					NickName = "Chars_Knight_NickName",
					LastName = "Chars_Knight_FirstName",
					LongName = "Chars_Knight_LongName",
					TooltipIds = { FirstName = "Chars_Knight_LongName", ShortName = "Chars_Knight_LongName", FullName = "Chars_Knight_LongName", LastName = "Chars_Knight_LongName" },
					StartingTrait = "Knight01",
					Past = "Past_Knight01",
					Reason = "Reason_Knight01",
					Backstory = "Backstory_Knight01",
					Reputation = "Knight_Reputation_01",
					RevealedBackstories = { "Backstory_Knight01_Complete", },
					Goal = "Goal_Knight01",
					Fear = "Fear_Knight01",
					YearsExiled = 3,
					Birthday = { Month = "mNovember", Date = 3 },
					Portrait = "WyrmGilman01",
					SadPortrait = "WyrmGilman01_Shocked",
					ForfeitVictoryScreenPortrait = "WyrmGilman01_Robed_Pained",
					ForfeitVictoryVO = "/VO/Wyrm_Gilman_213__1",
					AscensionSendOffVO = "/VO/Justice_990",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Gilman/",
					EventPositionOffset = -50,
					EventPositionOffsetRobed = -50,
					EventPositionOffsetMasked = -50,
					CaravanOffsetX = 0,
					CaravanOffsetY = 100,
					CaravanRobedOffsetX = 0,
					CaravanRobedOffsetY = 140,
					StartingXP = 650,
					SkillTreeA = "PlayerTrailA",
					SkillTreeB = "PlayerTrailB",
					StartingSkills = { },
					PreTrainingDialogue = { "PreTraining_Knight_01", "PreTraining_Knight_02", },
					LevelUpDialogue = { "LevelUpDialogue_Knight_01", "LevelUpDialogue_Knight_02", "LevelUpDialogue_Knight_03", "LevelUpDialogue_Knight_04" },
					BuddyCharTag = "Story_Diva",
					RivalCharTag = "Story_Pyreheart",
					WagonConversations = { "SideCon_Knight_Past_01", "SideCon_Knight_SeaDominion" },
					PostRivalryConversations = { },
					PostAscensionBuddyGoneConversations = { "SideCon_BuddyAscended_Knight_01" },
					PostAscensionLossConversations = { },
					PostMatchAscensionSuccessEvent = "Week9_Onward_Ascended_Other",
					PostMatchAscensionFailureEvent = "Week9_Onward_FailedAscension_Other",
					AscensionNextDraftPickEvents = { "Ascension_Knight_NextDraftPick_FirstChance_01", "Ascension_Knight_NextDraftPick_FirstChance_02", "Ascension_Knight_NextDraftPick_FirstChance_03", "Ascension_Knight_NextDraftPick_FirstChance_04", "Ascension_Knight_NextDraftPick_FirstChance_05" },
					AscensionNextDraftPickRetryEvents = { "Ascension_Knight_NextDraftPick_Retry_01", "Ascension_Knight_NextDraftPick_Retry_02", "Ascension_Knight_NextDraftPick_Retry_03", "Ascension_Knight_NextDraftPick_Retry_04", "Ascension_Knight_NextDraftPick_Retry_05" },
					AscensionSuccessEvent = "AscensionSuccess_Knight",
					AscensionFailureEvents = { "AscensionFailure_Knight_01", "AscensionFailure_Knight_02" },
					LiberationPlanBonus = 4,
					PostJoinTravelEvents = { "OpenStructure_Misc_Knight_01" },
					PostJoinVoyageEvents = { "OpenStructure_Voyage_Knight_01" },
					PostAscensionNewJunctionEvents = { "OpenStructure_CharAscended_Knight_01" },
					PostAscensionRemoveTravelEvents = { "OpenStructure_Misc_Knight_01" },
					PostAscensionRemoveVoyageEvents = { "OpenStructure_Voyage_Knight_01" },
					AscendedTooltip = "AscendedChar_Knight",
					ChallengePickEvents = { "ChallengeMatch_Pick_Knight_01" },
					ChallengeIntroEvents = { "ChallengeMatch_Intro_Knight_01" },
					ChallengeSuccessEvents = { "ChallengeMatch_Success_Knight_01" },
					ChallengeFailureEvents = { "ChallengeMatch_Failure_Knight_01" },
					ChallengeRewardEvents = { "ChallengeMatch_Reward_Knight_01" },

					EpilogueBuddyCharTag = "Story_Joker",
					EpilogueBuddyChar2Tag = "Story_Diva",
					EpilogueRivalCharTag = "Story_Pyreheart",
					EpilogueAscendedEvent = "Epilogue_Knight_Ascended_01",
					EpilogueAscendedPlanAEvent = "Epilogue_Knight_AscendedPlanA_01",
					EpilogueAscendedPlanBEvent = "Epilogue_Knight_AscendedPlanB_01",
					EpilogueAscendedPlanCEvent = "Epilogue_Knight_AscendedPlanC_01",
					EpilogueAscendedPostPlanEvent = "Epilogue_Knight_AscendedPostPlan_01",
					EpilogueWithBuddyEvent = "Epilogue_Knight_WithBuddy_01",
					EpilogueWithBuddy2Event = "Epilogue_Knight_WithBuddy2_01",
					EpilogueWithoutBuddyEvent = "Epilogue_Knight_WithoutBuddy_01",
					EpilogueWithRivalEvent = "Epilogue_Knight_WithRival_01",
					EpilogueWithoutRivalEvent = "Epilogue_Knight_WithoutRival_01",
					EpilogueWithReaderEvent = "Epilogue_Knight_WithReader_01",
					EpilogueAscendedWithoutReaderEvent = "Epilogue_Knight_Ascended_WithoutReader_01",
					EpilogueConclusionEvent = "Epilogue_Knight_Conclusion_01",
					EpilogueRemainedEvent = "Epilogue_Knight_Remained_01",

					AttractQuip = "/VO/Wyrm_Gilman_172__3",
					DraftedSpeech = "/VO/Match_97",
					EventEnterSound = "/SFX/World Sounds/WyrmEnter",
					EventExitSound = "/SFX/World Sounds/WyrmEnter",
					LevelUpSpeechLines = { "/VO/Justice_707", "/VO/Justice_708", "/VO/Justice_709", "/VO/Justice_710" },
					ScoringSpeechLines = { "/VO/Match_272", "/VO/Match_273", "/VO/Match_274", },
					ThrowScoringSpeechLines = { "/VO/Match_854", "/VO/Match_855", "/VO/Match_856" },
					BanishedSpeechLines = { "/VO/Match_275", "/VO/Match_276", "/VO/Match_277", "/VO/Match_278" },
					Height = 2,
					MusicTheme = "/Music/GilmanTheme_MC",
					MusicStemName = "Drums",
					MusicStemValue = 1,
					EnteredShopAscendedNarration = "EnteredShop_KnightAscended_01",
					CurrentStatusesA = { "Status_A_Knight_01", "Status_A_Knight_02", "Status_A_Knight_03", "Status_A_Knight_04", "Status_A_Knight_05", "Status_A_Knight_06", "Status_A_Knight_07", "Status_A_Knight_08", "Status_A_Knight_09", "Status_A_Knight_10", "Status_A_Knight_11", "Status_A_Knight_12", "Status_A_Knight_13", "Status_A_Knight_14", "Status_A_Knight_15", "Status_A_Knight_16" },
					CurrentStatusesW = { "Status_W_Knight_01", "Status_W_Knight_02", "Status_W_Knight_03", "Status_W_Knight_04", "Status_W_Knight_05", "Status_W_Knight_06", "Status_W_Knight_07", "Status_W_Knight_08", "Status_W_Knight_09", "Status_W_Knight_10", "Status_W_Knight_11", "Status_W_Knight_12", "Status_W_Knight_13", "Status_W_Knight_14", "Status_W_Knight_15", },
					CurrentStatusesR = { "Status_R_Knight_01", "Status_R_Knight_02", "Status_R_Knight_03", "Status_R_Knight_04", "Status_R_Knight_05", "Status_R_Knight_06", "Status_R_Knight_07", "Status_R_Knight_08", "Status_R_Knight_09", "Status_R_Knight_10" },
					CurrentStatusesI = { "Status_I_Knight_01", "Status_I_Knight_02", "Status_I_Knight_03", "Status_I_Knight_04", "Status_I_Knight_05", "Status_I_Knight_06", "Status_I_Knight_07" },
					CurrentStatusesN = { "Status_N_Knight_01", "Status_N_Knight_02", "Status_N_Knight_03", "Status_N_Knight_04", "Status_N_Knight_05", "Status_N_Knight_06", "Status_N_Knight_07", "Status_N_Knight_08", "Status_N_Knight_09", "Status_N_Knight_10", },
				},

				-- Pamitha / Harp
				{
					Archetype = "PlayerFlying",
					Tags = { "Story_Vamp" },
					LocId = LocId_Story_Vamp,
					Personality = "Personality_Vamp",
					Gender = "female",
					FirstName = "Chars_Vamp_FirstName",
					NickName = "Chars_Vamp_NickName",
					LastName = "Chars_Vamp_LastName",
					LongName = "Chars_Vamp_LongName",
					TooltipIds = { FirstName = "Chars_Vamp_LongName", ShortName = "Chars_Vamp_LongName", FullName = "Chars_Vamp_LongName", LastName = "Chars_Vamp_LastName_Tooltip" },
					StartingTrait = "Vamp01",
					Past = "Past_Vamp01",
					Reason = "Reason_Vamp01",
					Backstory = "Backstory_Vamp01",
					RevealedBackstories = { "Backstory_Vamp01_Complete", },
					Goal = "Goal_Vamp01",
					Fear = "Fear_Vamp01",
					Reputation = "Vamp_Reputation_01",
					YearsExiled = 4,
					Birthday = { Month = "mAugust", Date = 31 },
					Portrait = "HarpPamitha02",
					SadPortrait = "HarpPamitha02_Annoyed",
					ForfeitVictoryScreenPortrait = "HarpPamitha02_Robed_EyesClosed",
					ForfeitVictoryVO = "/VO/Harp_Pamitha_0188__1",
					AscensionSendOffVO = "/VO/Justice_991",
					SmallPortrait = "HarpPamitha01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Pamitha/",
					CaravanOffsetX = -100,
					CaravanOffsetY = 120,
					CaravanRobedOffsetX = -100,
					CaravanRobedOffsetY = 140,
					StartingXP = 450,
					SkillTreeA = "PlayerFlyingA",
					SkillTreeB = "PlayerFlyingB",
 					StartingSkills = { },
					LevelUpDialogue = { "LevelUpDialogue_Vamp_01", "LevelUpDialogue_Vamp_02", "LevelUpDialogue_Vamp_03", "LevelUpDialogue_Vamp_04" },
					PreTrainingDialogue = { "PreTraining_Vamp_01", "PreTraining_Vamp_02", },
					BuddyCharTag = "Story_Joker",
					RivalCharTag = "Story_Essence",
					WagonConversations = { "SideCon_Vamp_Past_01", "SideCon_Vamp_HarpFaction" },
					PostRivalryConversations = { },
					PostAscensionBuddyGoneConversations = { "SideCon_BuddyAscended_Vamp_01" },
					PostAscensionLossConversations = { },
					PostMatchAscensionSuccessEvent = "Week9_Onward_Ascended_Other",
					PostMatchAscensionFailureEvent = "Week9_Onward_FailedAscension_Other",
					AscensionNextDraftPickEvents = { "Ascension_Vamp_NextDraftPick_FirstChance_01", "Ascension_Vamp_NextDraftPick_FirstChance_02", "Ascension_Vamp_NextDraftPick_FirstChance_03", "Ascension_Vamp_NextDraftPick_FirstChance_04", "Ascension_Vamp_NextDraftPick_FirstChance_05" },
					AscensionNextDraftPickRetryEvents = { "Ascension_Vamp_NextDraftPick_Retry_01", "Ascension_Vamp_NextDraftPick_Retry_02", "Ascension_Vamp_NextDraftPick_Retry_03", "Ascension_Vamp_NextDraftPick_Retry_04", "Ascension_Vamp_NextDraftPick_Retry_05" },
					AscensionSuccessEvent = "AscensionSuccess_Vamp",
					AscensionSuccessEventAlt = "AscensionSuccess_Vamp_Alt",
					AscensionFailureEvents = { "AscensionFailure_Vamp_01", "AscensionFailure_Vamp_02" },
					LiberationPlanBonus = 4,
					PostJoinTravelEvents = { "OpenStructure_Misc_Vamp_01" },
					PostAscensionNewJunctionEvents = { "OpenStructure_CharAscended_Vamp_01" },
					PostAscensionRemoveTravelEvents = { "OpenStructure_Misc_Vamp_01" },
					AscendedTooltip = "AscendedChar_Vamp",
					ChallengePickEvents = { "ChallengeMatch_Pick_Vamp_01" },
					ChallengeIntroEvents = { "ChallengeMatch_Intro_Vamp_01" },
					ChallengeSuccessEvents = { "ChallengeMatch_Success_Vamp_01" },
					ChallengeFailureEvents = { "ChallengeMatch_Failure_Vamp_01" },
					ChallengeRewardEvents = { "ChallengeMatch_Reward_Vamp_01" },

					EpilogueRivalCharTag = "Story_Essence",
					EpilogueBuddyCharTag = "Story_Diva",
					EpilogueBuddyChar2Tag = "Story_Joker",
					EpilogueAscendedEvent = "Epilogue_Vamp_Ascended_01",
					EpilogueAscendedPlanAEvent = "Epilogue_Vamp_AscendedPlanA_01",
					EpilogueAscendedPlanBEvent = "Epilogue_Vamp_AscendedPlanB_01",
					EpilogueAscendedPlanCEvent = "Epilogue_Vamp_AscendedPlanC_01",
					EpilogueAscendedPostPlanEvent = "Epilogue_Vamp_AscendedPostPlan_01",
					EpilogueAscendedWithRivalEvent = "Epilogue_Vamp_Ascended_WithRival_01",
					EpilogueAscendedWithoutRivalEvent = "Epilogue_Vamp_Ascended_WithoutRival_01",
					EpilogueAscendedConclusionEvent = "Epilogue_Vamp_AscendedConclusion_01",
					EpilogueWithBuddyEvent = "Epilogue_Vamp_WithBuddy_01",
					EpilogueWithBuddy2Event = "Epilogue_Vamp_WithBuddy2_01",
					EpilogueRemainedEvent = "Epilogue_Vamp_Remained_01",
					EpilogueRemainedWithRivalEvent = "Epilogue_Vamp_Remained_WithRival_01",
					EpilogueRemainedWithoutRivalEvent = "Epilogue_Vamp_Remained_WithoutRival_01",
					EpilogueRemainedConclusionEvent = "Epilogue_Vamp_RemainedConclusion_01",

					AttractQuip = "/VO/Harp_Pamitha_0177__3",
					DraftedSpeech = "/VO/Match_98",
					LevelUpSpeechLines = { "/VO/Justice_711", "/VO/Justice_712", "/VO/Justice_713", "/VO/Justice_714" },
					ScoringSpeechLines = { "/VO/Match_279", "/VO/Match_280", "/VO/Match_281", },
					ThrowScoringSpeechLines = { "/VO/Match_857", "/VO/Match_858", "/VO/Match_859" },
					BanishedSpeechLines = { "/VO/Match_282", "/VO/Match_283", "/VO/Match_284", "/VO/Match_285" },
					Height = 6,
					MusicTheme = "/Music/PamithaTheme_MC",
					MusicStemName = "Drums",
					MusicStemValue = 1,
					EnteredShopAscendedNarration = "EnteredShop_VampAscended_01",
					CurrentStatusesA = { "Status_A_Vamp_01", "Status_A_Vamp_02", "Status_A_Vamp_03", "Status_A_Vamp_04", "Status_A_Vamp_05", "Status_A_Vamp_06", "Status_A_Vamp_07", "Status_A_Vamp_08", "Status_A_Vamp_09", "Status_A_Vamp_10", "Status_A_Vamp_11", "Status_A_Vamp_12", "Status_A_Vamp_13", "Status_A_Vamp_14", "Status_A_Vamp_15", "Status_A_Vamp_16" },
					CurrentStatusesW = { "Status_W_Vamp_01", "Status_W_Vamp_02", "Status_W_Vamp_03", "Status_W_Vamp_04", "Status_W_Vamp_05", "Status_W_Vamp_06", "Status_W_Vamp_07", "Status_W_Vamp_08", "Status_W_Vamp_09", "Status_W_Vamp_10", "Status_W_Vamp_11", "Status_W_Vamp_12", "Status_W_Vamp_13", "Status_W_Vamp_14", "Status_W_Vamp_15", },
					CurrentStatusesR = { "Status_R_Vamp_01", "Status_R_Vamp_02", "Status_R_Vamp_03", "Status_R_Vamp_04", "Status_R_Vamp_05", "Status_R_Vamp_06", "Status_R_Vamp_07", "Status_R_Vamp_08", "Status_R_Vamp_09", "Status_R_Vamp_10" },
					CurrentStatusesI = { "Status_I_Vamp_01", "Status_I_Vamp_02", "Status_I_Vamp_03", "Status_I_Vamp_04", "Status_I_Vamp_05", "Status_I_Vamp_06", "Status_I_Vamp_07" },
					CurrentStatusesN = { "Status_N_Vamp_01", "Status_N_Vamp_02", "Status_N_Vamp_03", "Status_N_Vamp_04", "Status_N_Vamp_05", "Status_N_Vamp_06", "Status_N_Vamp_07", "Status_N_Vamp_08", "Status_N_Vamp_09", "Status_N_Vamp_10", },
				},

				-- Volfred / Sap
				{
					Archetype = "PlayerTree",
					Tags = { "Story_Doc" },
					LocId = LocId_Story_Doc,
					Personality = "Personality_Doc",
					Gender = "male",
					FirstName = "Chars_Doc_FirstName",
					NickName = "Chars_Doc_NickName",
					FirstInitial = "Chars_Doc_FirstInitial",
					MiddleName = "Chars_Doc_MiddleName",
					MiddleInitial = "Chars_Doc_MiddleInitial",
					LastName = "Chars_Doc_LastName",
					LongName = "Chars_Doc_LongName",
					TooltipIds = { FirstName = "Chars_Doc_LongName", ShortName = "Chars_Doc_LongName", FullName = "Chars_Doc_LongName", LongName = "Chars_Doc_LongName", LastName = "Chars_Doc_LongName" },
					StartingTrait = "Doc01",
					Past = "Past_Doc01",
					Reason = "Reason_Doc01",
					Backstory = "Backstory_Doc01",
					RevealedBackstories = { "Backstory_Doc01_Complete", },
					Goal = "Goal_Doc01",
					Fear = "Fear_Doc01",
					Reputation = "Doc_Reputation_01",
					YearsExiled = 9,
					Birthday = { Month = "mJune", Date = 21 },
					Portrait = "SapVolfred01",
					SadPortrait = "SapVolfred01_Averted",
					ForfeitVictoryScreenPortrait = "SapVolfred01_Robed_Averted",
					ForfeitVictoryVO = "/VO/Sap_Volfred_0316__3",
					AscensionSendOffVO = "/VO/Justice_992",
					RobedPortrait = "SapVolfred01",
					VictoryScreenPortrait = "SapVolfred01_Robed",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Volfred/",
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop2",
					CaravanOffsetX = -20,
					CaravanOffsetY = 50,
					CaravanRobedOffsetX = -20,
					CaravanRobedOffsetY = 0,
					StartingXP = 200,
					RestXp = 8300,
					SkillTreeA = "PlayerTreeA",
					SkillTreeB = "PlayerTreeB",
					StartingSkills = { },
					PreTrainingDialogue = { "PreTraining_Doc_01", "PreTraining_Doc_02",  },
					LevelUpDialogue = { "LevelUpDialogue_Doc_01", "LevelUpDialogue_Doc_02", "LevelUpDialogue_Doc_03", "LevelUpDialogue_Doc_04" },
					BuddyCharTag = "Story_Mascot",
					RivalCharTag = "Story_Chastity",
					WagonConversations = { "SideCon_Doc_BookReport", "SideCon_Doc_Agents" },
					PostRivalryConversations = { },
					PostAscensionBuddyGoneConversations = { "SideCon_BuddyAscended_Doc_01" },
					PostAscensionLossConversations = { },
					AscensionNextDraftPickEvents = { "Ascension_Doc_NextDraftPick_FirstChance_01", "Ascension_Doc_NextDraftPick_FirstChance_02", "Ascension_Doc_NextDraftPick_FirstChance_03" },
					AscensionNextDraftPickRetryEvents = { "Ascension_Doc_NextDraftPick_Retry_01", "Ascension_Doc_NextDraftPick_Retry_02", "Ascension_Doc_NextDraftPick_Retry_03" },
					AscensionSuccessEvent = "AscensionSuccess_Doc",
					AscensionFailureEvents = { "AscensionFailure_Doc_01", "AscensionFailure_Doc_02" },
					LiberationPlanBonus = 8,
					PostMatchAscensionSuccessEvent = "Week9_Onward_Ascended_Other",
					PostMatchAscensionFailureEvent = "Week9_Onward_FailedAscension_Other",
					PostJoinTravelEvents = { "OpenStructure_Misc_Doc_01" },
					PostAscensionNewJunctionEvents = { "OpenStructure_CharAscended_Doc_01" },
					PostAscensionRemoveTravelEvents = { "OpenStructure_Misc_Doc_01" },
					AscendedTooltip = "AscendedChar_Doc",
					ChallengePickEvents = { "ChallengeMatch_Pick_Doc_01" },
					ChallengeIntroEvents = { "ChallengeMatch_Intro_Doc_01" },
					ChallengeSuccessEvents = { "ChallengeMatch_Success_Doc_01" },
					ChallengeFailureEvents = { "ChallengeMatch_Failure_Doc_01" },
					ChallengeRewardEvents = { "ChallengeMatch_Reward_Doc_01" },

					EpilogueBuddyCharTag = "Story_Mascot",
					EpilogueBuddyChar2Tag = "Story_Diva",
					EpilogueRivalCharTag = "Story_Nightwing",
					EpilogueAscendedEvent = "Epilogue_Doc_Ascended_01",
					EpilogueAscendedPlanAEvent = "Epilogue_Doc_AscendedPlanA_01",
					EpilogueAscendedPlanBEvent = "Epilogue_Doc_AscendedPlanB_01",
					EpilogueAscendedWithRivalEvent = "Epilogue_Doc_Ascended_WithRival_01",
					EpilogueAscendedWithReaderPlanAEvent = "Epilogue_Doc_Ascended_WithReaderPlanA_01",
					EpilogueAscendedWithReaderPlanBEvent = "Epilogue_Doc_Ascended_WithReaderPlanB_01",
					EpilogueAscendedConclusionEvent = "Epilogue_Doc_AscendedConclusion_01",
					EpilogueWithBuddyEvent = "Epilogue_Doc_WithBuddy_01",
					EpilogueRemainedEvent = "Epilogue_Doc_Remained_01",
					EpilogueRemainedPlanAEvent = "Epilogue_Doc_RemainedPlanA_01",
					EpilogueRemainedPlanBEvent = "Epilogue_Doc_RemainedPlanB_01",
					EpilogueRemainedPlanCEvent = "Epilogue_Doc_RemainedPlanC_01",
					EpilogueRemainedPostPlanEvent = "Epilogue_Doc_RemainedPostPlan_01",
					EpilogueRemainedWithReaderEvent = "Epilogue_Doc_Remained_WithReader_01",
					EpilogueSpecialRemainedWithRivalEventNarrationReqs = { "Match_Ascension7_YouLost_Manipulate_Escape", "Match_Ascension7_YouWon" },
					EpilogueSpecialRemainedWithRivalEvent = "Epilogue_Doc_Remained_SpecialWithRival_01",
					EpilogueRemainedWithoutRivalEvent = "Epilogue_Doc_Remained_WithoutRival_01",
					EpilogueRemainedWithoutReaderEvent = "Epilogue_Doc_Remained_WithoutReader_01",
					EpilogueRemainedConclusionEvent = "Epilogue_Doc_RemainedConclusion_01",

					AttractQuip = "/VO/Sap_Volfred_0305__5",
					DraftedSpeech = "/VO/Match_99",
					EventEnterSound = "/SFX/World Sounds/SapEnter",
					EventExitSound = "/SFX/World Sounds/SapEnter",
					LevelUpSpeechLines = { "/VO/Justice_715", "/VO/Justice_716", "/VO/Justice_717", "/VO/Justice_718" },
					ScoringSpeechLines = { "/VO/Match_286", "/VO/Match_287", "/VO/Match_288", },
					ThrowScoringSpeechLines = { "/VO/Match_860", "/VO/Match_861", "/VO/Match_862" },
					BanishedSpeechLines = { "/VO/Match_289", "/VO/Match_290", "/VO/Match_291", "/VO/Match_433" },
					Height = 9,
					MusicTheme = "/Music/VolfredTheme_MC",
					MusicStemName = "Mandolins",
					MusicStemValue = 2,
					EnteredShopAscendedNarration = "EnteredShop_DocAscended_01",
					CurrentStatusesA = { "Status_A_Doc_01", "Status_A_Doc_02", "Status_A_Doc_03", "Status_A_Doc_04", "Status_A_Doc_05", "Status_A_Doc_06", "Status_A_Doc_07", "Status_A_Doc_08", "Status_A_Doc_09", "Status_A_Doc_10", "Status_A_Doc_11", "Status_A_Doc_12", "Status_A_Doc_13", "Status_A_Doc_14", "Status_A_Doc_15", "Status_A_Doc_16" },
					CurrentStatusesW = { "Status_W_Doc_01", "Status_W_Doc_02", "Status_W_Doc_03", "Status_W_Doc_04", "Status_W_Doc_05", "Status_W_Doc_06", "Status_W_Doc_07", "Status_W_Doc_08", "Status_W_Doc_09", "Status_W_Doc_10", "Status_W_Doc_11", "Status_W_Doc_12", "Status_W_Doc_13", "Status_W_Doc_14", "Status_W_Doc_15", },
					CurrentStatusesR = { "Status_R_Doc_01", "Status_R_Doc_02", "Status_R_Doc_03", "Status_R_Doc_04", "Status_R_Doc_05", "Status_R_Doc_06", "Status_R_Doc_07", "Status_R_Doc_08", "Status_R_Doc_09", "Status_R_Doc_10" },
					CurrentStatusesI = { "Status_I_Doc_01", "Status_I_Doc_02", "Status_I_Doc_03", "Status_I_Doc_04", "Status_I_Doc_05", "Status_I_Doc_06", "Status_I_Doc_07" },
					CurrentStatusesN = { "Status_N_Doc_01", "Status_N_Doc_02", "Status_N_Doc_03", "Status_N_Doc_04", "Status_N_Doc_05", "Status_N_Doc_06", "Status_N_Doc_07", "Status_N_Doc_08", "Status_N_Doc_09", "Status_N_Doc_10", },
				},

				-- Bertrude / Monster
				{
					Archetype = "PlayerMonster",
					Tags = { "Story_Diva" },
					LocId = LocId_Story_Diva,
					Personality = "Personality_Diva",
					Gender = "female",
					SurName = "Chars_Diva_SurName",
					FirstName = "Chars_Diva_FirstName",
					NickName = "Chars_Diva_NickName",
					LastName = "Chars_Diva_FirstName",
					LongName = "Chars_Diva_LongName",
					TooltipIds = { FirstName = "Chars_Diva_LongName", ShortName = "Chars_Diva_LongName", FullName = "Chars_Diva_LongName", LongName = "Chars_Diva_LongName" },
					StartingTrait = "Diva01",
					Past = "Past_Diva01",
					Reason = "Reason_Diva01",
					Reputation = "Diva_Reputation_01",
					Backstory = "Backstory_Diva01",
					RevealedBackstories = { "Backstory_Diva01_Complete", },
					Goal = "Goal_Diva01",
					Fear = "Fear_Diva01",
					YearsExiled = 21,
					Birthday = { Month = "mFebruary", Date = 22 },
					Portrait = "CroneBertrude01",
					SadPortrait = "CroneBertrude01_Averted",
					ForfeitVictoryScreenPortrait = "CroneBertrude01_Robed_Averted",
					ForfeitVictoryVO = "/VO/Bertrude_0162__4",
					AscensionSendOffVO = "/VO/Justice_993",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Bertrude/",
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop5",
					TextSpeedMultiplier = 1.25,
					CaravanOffsetX = 0,
					CaravanOffsetY = 0,
					StartingXP = 950,
					RestXp = 1500,
					SkillTreeA = "PlayerMonsterA",
					SkillTreeB = "PlayerMonsterB",
					PreTrainingDialogue = { "PreTraining_Diva_01", "PreTraining_Diva_02", },
					LevelUpDialogue = { "LevelUpDialogue_Diva_01", "LevelUpDialogue_Diva_02", "LevelUpDialogue_Diva_03", "LevelUpDialogue_Diva_04" },
					BuddyCharTag = "Story_Vamp",
					RivalCharTag = "Story_Withdrawn",
					WagonConversations = { "SideCon_Diva_Past_01", "SideCon_Diva_BeyonderCrystal" },
					PostRivalryConversations = { },
					PostAscensionBuddyGoneConversations = { "SideCon_BuddyAscended_Diva_01" },
					PostAscensionLossConversations = { },
					AscensionNextDraftPickEvents = { "Ascension_Diva_NextDraftPick_FirstChance_01", "Ascension_Diva_NextDraftPick_FirstChance_02", "Ascension_Diva_NextDraftPick_FirstChance_03", "Ascension_Diva_NextDraftPick_FirstChance_04" },
					AscensionNextDraftPickRetryEvents = { "Ascension_Diva_NextDraftPick_Retry_01", "Ascension_Diva_NextDraftPick_Retry_02", "Ascension_Diva_NextDraftPick_Retry_03", "Ascension_Diva_NextDraftPick_Retry_04" },
					AscensionSuccessEvent = "AscensionSuccess_Diva",
					AscensionFailureEvents = { "AscensionFailure_Diva_01", "AscensionFailure_Diva_02" },
					LiberationPlanBonus = 5,
					StartingSkills = { },
					PostJoinTravelEvents = { "OpenStructure_Misc_Diva_01" },
					PostMatchAscensionSuccessEvent = "Week9_Onward_Ascended_Other",
					PostMatchAscensionFailureEvent = "Week9_Onward_FailedAscension_Other",
					PostAscensionNewJunctionEvents = { "OpenStructure_CharAscended_Diva_01" },
					PostAscensionRemoveTravelEvents = { "OpenStructure_Misc_Diva_01" },
					AscendedTooltip = "AscendedChar_Diva",
					ChallengePickEvents = { "ChallengeMatch_Pick_Diva_01" },
					ChallengeIntroEvents = { "ChallengeMatch_Intro_Diva_01" },
					ChallengeSuccessEvents = { "ChallengeMatch_Success_Diva_01" },
					ChallengeFailureEvents = { "ChallengeMatch_Failure_Diva_01" },
					ChallengeRewardEvents = { "ChallengeMatch_Reward_Diva_01" },

					EpilogueBuddyCharTag = "Story_Doc",
					EpilogueBuddyChar2Tag = "Story_Vamp",
					EpilogueAscendedEvent = "Epilogue_Diva_Ascended_01",
					EpilogueAscendedPlanAEvent = "Epilogue_Diva_AscendedPlanA_01",
					EpilogueAscendedPlanBEvent = "Epilogue_Diva_AscendedPlanB_01",
					EpilogueAscendedPlanCEvent = "Epilogue_Diva_AscendedPlanC_01",
					EpilogueAscendedPostPlanEvent = "Epilogue_Diva_AscendedPostPlan_01",
					EpilogueWithBuddyEvent = "Epilogue_Diva_WithBuddy_01",
					EpilogueWithBuddy2Event = "Epilogue_Diva_WithBuddy2_01",
					EpilogueAscendedWithoutBuddyEvent = "Epilogue_Diva_Ascended_WithoutBuddy_01",
					EpilogueAscendedConclusionEvent = "Epilogue_Diva_AscendedConclusion_01",
					EpilogueRemainedEvent = "Epilogue_Diva_Remained_01",
					EpilogueRemainedWithoutBuddyEvent = "Epilogue_Diva_Remained_WithoutBuddy_01",
					EpilogueRemainedConclusionEvent = "Epilogue_Diva_RemainedConclusion_01",

					AttractQuip = "/VO/Bertrude_0175__13",
					DraftedSpeech = "/VO/Match_100",
					EventEnterSound = "/SFX/World Sounds/CroneEnter",
					EventExitSound = "/SFX/World Sounds/CroneEnter",
					LevelUpSpeechLines = { "/VO/Justice_719", "/VO/Justice_720", "/VO/Justice_721", "/VO/Justice_722" },
					ScoringSpeechLines = { "/VO/Match_434", "/VO/Match_435", "/VO/Match_436", },
					ThrowScoringSpeechLines = { "/VO/Match_863", "/VO/Match_864", "/VO/Match_865" },
					BanishedSpeechLines = { "/VO/Match_437", "/VO/Match_438", "/VO/Match_439", "/VO/Match_440" },
					Height = 7,
					MusicTheme = "/Music/BertrudeTheme_MC",
					MusicStemName = "Drums",
					MusicStemValue = 2,
					EnteredShopAscendedNarration = "EnteredShop_DivaAscended_01",
					CurrentStatusesA = { "Status_A_Diva_01", "Status_A_Diva_02", "Status_A_Diva_03", "Status_A_Diva_04", "Status_A_Diva_05", "Status_A_Diva_06", "Status_A_Diva_07", "Status_A_Diva_08", "Status_A_Diva_09", "Status_A_Diva_10", "Status_A_Diva_11", "Status_A_Diva_12", "Status_A_Diva_13", "Status_A_Diva_14", "Status_A_Diva_15", "Status_A_Diva_16" },
					CurrentStatusesW = { "Status_W_Diva_01", "Status_W_Diva_02", "Status_W_Diva_03", "Status_W_Diva_04", "Status_W_Diva_05", "Status_W_Diva_06", "Status_W_Diva_07", "Status_W_Diva_08", "Status_W_Diva_09", "Status_W_Diva_10", "Status_W_Diva_11", "Status_W_Diva_12", "Status_W_Diva_13", "Status_W_Diva_14", "Status_W_Diva_15", },
					CurrentStatusesR = { "Status_R_Diva_01", "Status_R_Diva_02", "Status_R_Diva_03", "Status_R_Diva_04", "Status_R_Diva_05", "Status_R_Diva_06", "Status_R_Diva_07", "Status_R_Diva_08", "Status_R_Diva_09", "Status_R_Diva_10" },
					CurrentStatusesI = { "Status_I_Diva_01", "Status_I_Diva_02", "Status_I_Diva_03", "Status_I_Diva_04", "Status_I_Diva_05", "Status_I_Diva_06", "Status_I_Diva_07" },
					CurrentStatusesN = { "Status_N_Diva_01", "Status_N_Diva_02", "Status_N_Diva_03", "Status_N_Diva_04", "Status_N_Diva_05", "Status_N_Diva_06", "Status_N_Diva_07", "Status_N_Diva_08", "Status_N_Diva_09", "Status_N_Diva_10", },
				},

			}
		},
		[2] =
		{
			-- Accusers Team
			Name = "TeamName02",
			GoalDecalSigil = "AccusersGrill01",
			MeteorColorGrade = "Team02",
			MaskHue = 30, MaskSaturationAddition = -30, MaskValueAddition = -30,
			MaskHue2 = 40, MaskSaturationAddition2 = 10, MaskValueAddition2 = 30,
			IntroVO = "/VO/Match_145", VictoryVO = "/VO/Match_146",
			AscensionVictoryVO = "/VO/Match_560",
			MusicTheme = "/Music/UrsaIdea8_MC",
			AscensionMusicTheme = "/Music/AscensionMatchMusicAccusers_MC",
			PostMatchSigil = "SigilAccusers",
			RosterScreenSigil = "GUI\\Sigils\\Accusers_01_UI",
			LargeSigil = "Tilesets\\Arena\\Accusers_01",
			PyreIcon = "GUI\\Icons\\Pyre\\PyreIcon_Accusers",
			AscensionMatchStartEvents = { "Ascension_Beginning_Accusers_01" },
			FlyingEvents = { "FlyingWagon_Accusers_01", "FlyingWagon_Accusers_02" },
			StarPickEvents = { "OpenStructure_Onward_StarPicked_Accusers_01" },
			RivalryCharTag = "Story_Mascot",
			RivalryPreMatchEvents = { "OpenStructure_ReachedGoal_Rivalry_Accusers_01" },
			RivalryMatchStartEvents = { "OpenStructure_Match_Beginning_Rivalry_Accusers_01" },
			RivalryMatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_Rivalry_Accusers_01" },
			RivalryMatchVictoryEvents = { "OpenStructure_Match_TheyLost_Rivalry_Accusers_01" },
			RivalryMatchDefeatEvents = { "OpenStructure_Match_TheyWon_Rivalry_Accusers_01" },
			-- PreMatchEvents = { "OpenStructure_ReachedGoal_01" },
			MatchStartEvents = { "OpenStructure_Match_Accusers_Beginning_01" },
			-- MatchStartEvents = { "OpenStructure_Match_Beginning_01" },
			-- MatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_01" },
			MatchDefeatEvents = { "OpenStructure_Match_Accusers_TheyLost_01", },
			MatchVictoryEvents = { "OpenStructure_Match_Accusers_TheyWon_01", },
			LastMatchBigWinPhrases = { "TeamMemory_BigWin_Accusers_01" },
			LastMatchCloseWinPhrases = { "TeamMemory_CloseWin_Accusers_01" },
			LastMatchSolidWinPhrases = { "TeamMemory_SolidWin_Accusers_01" },
			LastMatchBigLossPhrases = { "TeamMemory_BigLoss_Accusers_01" },
			LastMatchCloseLossPhrases = { "TeamMemory_CloseLoss_Accusers_01" },
			LastMatchSolidLossPhrases = { "TeamMemory_SolidLoss_Accusers_01" },
			LastMatchNoMemoryPhrases = { "TeamMemory_NoMemory_Accusers_01" },
			GenericReputation = "TeamName02_GenericRep_01",
			GuideBookChapter = 8,
			GuideBookEntry = 2,
			WinsSinceLastAscensionAttempt = 30,
			SimulatedMatchPower = 6,

			ForcedDraftPicks =
			{
				[1] = { 1, 2, 3 },
				[2] = { 1, 2, 3 },
				[3] = { 1, 4, 5 } ,
				[4] = { 1, 4, 5 } ,
				[5] = { 1 } ,
			},

			TeamAVersusLineNames = { "/VO/Match_1203" },
			TeamBVersusLineNames = { "/VO/Match_1204" },
			TeamScoresFirstSpeechLines =
			{
				-- The Accusers are the first to strike their adversary's flame!
				"/VO/Match_972",
				-- Glory first to the Accusers!
				"/VO/Match_973",
				-- The Accusers make their mark upon the flame!
				"/VO/Match_974",
			},
			TeamScoredOnFirstSpeechLines =
			{
				-- The Accusers' Pyre is the first to falter.
				"/VO/Match_975",
				-- The Orb bathes first in the Accusers' flame!
				"/VO/Match_976",
			},
			TeamTakesLeadSpeechLines =
			{
				-- The Accusers shall prevail at this rate.
				"/VO/Match_302",
				-- The Accusers' Pyre now burns brighter.
				"/VO/Match_977",
				-- The Accusers seem to want their freedom more.
				"/VO/Match_978",
				-- The Accusers are now favored to prevail.
				"/VO/Match_979",
				-- Shall the Accusers press their luck, perhaps?
				"/VO/Match_980",
				-- Best not give in to pride just yet, Accusers.
				"/VO/Match_981",
				-- How very fortunate for the Accusers.
				"/VO/Match_982",
			},
			TeamLosesLeadSpeechLines =
			{
				-- The Accusers seem to be falling behind.
				"/VO/Match_983",
				-- The Accusers' adversaries gained an edge.
				"/VO/Match_984",
				-- A show of strength from the Accusers' foe.
				"/VO/Match_985",
				-- Have the Accusers underestimated you?
				"/VO/Match_299",
				-- The Accusers' Pyre grows weaker.
				"/VO/Match_408",
			},
			TeamFullWipeLines =
			{
				-- All of the Accusers, gone.
				"/VO/Match_986",
				-- Accusers, banished to the last.
				"/VO/Match_987",
				-- Unfortunate for the Accusers.
				"/VO/Match_988",
				-- Farewell, Accusers!
				"/VO/Match_989",
				-- How sad for the Accusers.
				"/VO/Match_990",
				-- No sign of the Accusers!
				"/VO/Match_991",
			},
			TeamPyreExtinguishedLines =
			{
				-- The Accusers' flame is out!
				"/VO/Match_992",
				-- The Accusers' flames, extinguished!
				"/VO/Match_993",
			},
			TeamReadyLines =
			{
				-- Accusers, stand prepared.
				"/VO/Match_994",
				-- Accusers, stand ready.
				"/VO/Match_995",
			},

			TeamBench =
			{
				-- Lendel the Liar / Nomad
				{
					Archetype = "PlayerMedium",
					Tags = { "Story_Accuser" },
					Gender = "male",
					FirstName = "Rivals_Accuser_FirstName",
					TitlePostFix = "Nomad_Title_03",
					TooltipIds = { FullName = "Rival_Accuser_02", LongName = "Rival_Accuser_02" },
					StartingTrait = "Accuser01",
					Backstory = "Rivals_Accuser_Backstory_Initial",
					RevealedBackstories = { "Rivals_Accuser_Backstory_Complete", },
					Past = "Rivals_Captain02_Past",
					Reason = "Rivals_Accuser_Reason",
					Reputation = "Accuser_Reputation_01",
					YearsExiled = 6,
					Birthday = { Month = "mNovember", Date = 19 },
					Portrait = "NomadLendel01_Robed",
					RobedPortrait = "NomadLendel01_Robed",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Lendel/",
					AscensionSendOffVO = "/VO/Justice_994",
					Height = 5.5,
					MusicTheme = "/Music/UrsaIdea8_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,
					AscensionSuccessEvent = "AscensionSuccess_Accuser",
					AscensionFailureEvent = "AscensionFailure_Accuser",
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop2",
					PostAscensionNewJunctionEvents = { "OpenStructure_RivalAscended_Accuser_01" },
					Traits = { "AccuserLeaderPackage" },
					MatchScale = 1.15,
					EventPositionOffset = -50,
					AscendedTooltip = "AscendedRival_Accuser",
					DraftedSpeech = "/VO/Match_101",

					EpilogueAscendedEvent = "Epilogue_Accuser_Ascended_01",
					EpilogueAscendedPlanAEvent = "Epilogue_Accuser_AscendedPlanA_01",
					EpilogueAscendedPlanBEvent = "Epilogue_Accuser_AscendedPlanB_01",
					EpilogueAscendedPlanCEvent = "Epilogue_Accuser_AscendedPlanC_01",
					EpilogueRemainedEvent = "Epilogue_Accuser_Remained_01",

					VoiceUseTeamPostfix = false,
					UseWinningVO = true,
					-- UseVictoryVO = true,
					ScoringSpeechLines = { "/VO/Match_347", "/VO/Match_348" },
					ThrowScoringSpeechLines = { "/VO/Match_866", "/VO/Match_867", "/VO/Match_868" },
					BanishedSpeechLines = { "/VO/Match_364", "/VO/Match_365", "/VO/Match_366", "/VO/Match_367", "/VO/Match_368" },
					SpecialScorePose = "PlayerMediumScorePoseAlt",

					PlayerAttributeRespawn = 26,
					PlayerAttributeSpeedModifier = -2,

					MatchSkills =
					{
						[2] = { "TeamStaminaRechargeSkill" },
						[3] = { "TeamBallSkill" },
						[4] = { "TeamEnemyBanishTime" },
					},

					MatchItems =
					{
						[2] = "PyreHealthItemLendel",
					},
				},
				-- Vispa
				{ Archetype = "PlayerMedium",  Gender = "female",
					FirstName = "Rivals_Accusers_Extra_01",
					Tags = { "Test_Medium" },
					MatchScale = 0.88,
					SpecialScorePose = "PlayerMediumScorePoseAlt",
					SmallPortrait = "Nomad_Accusers_Small",
					PlayerAttributeRespawn = 21,
					PlayerAttributeAuraModifier = 0,
					PlayerAttributeSpeedModifier = -3,
					Height = 4.9,
					MatchSkills =
					{
						[2] = { "StaminaSkill", "MassivePowerShot" },
						[3] = { "JumpKillSkill" },
					},
					MatchItems =
					{
						[2] = "WinningScoreItemAccusers",
					},
				},
				-- Darben
				{ Archetype = "PlayerMedium",  Gender = "male",
					FirstName = "Rivals_Accusers_Extra_02",
					MatchScale = 0.93,
					SpecialScorePose = "PlayerMediumScorePoseAlt",
					SmallPortrait = "Nomad_Accusers_Small",
					PlayerAttributeRespawn = 20,
					PlayerAttributeSpeedModifier = -4,
					Height = 5.0,
					MatchSkills =
					{
						[2] = { "StaminaSkill", "MassivePowerShot" },
						[3] = { "JumpKillSkill" },
					},
					MatchItems =
					{
						[2] = "WinningScoreItemAccusers",
					},
				},
				-- Vispaleth
				{ Archetype = "PlayerLarge", Gender = "female", Tags = { "Test_Large" },
					FirstName = "Rivals_Accusers_Extra_03",
					PlayerAttributeAuraModifier = 6,
					PlayerAttributeRespawnModifier = 8,
					PlayerAttributeSpeedModifier = 2,
					SpecialScorePose = "PlayerLargeScorePoseAlt",
					SmallPortrait = "Demon_Accusers_Small",
					Height = 5.1,
					MatchSkills =
					{
						[2] = { "KillsRegenerateStamina100", "PlusPresenceSkill" },
						[3] = { "PlusEnemyRespawnTime", "DoubleRush" },
					},
					MatchItems =
					{
						[2] = "WinningScoreItemAccusers",
					},
				},
				-- Darbenfor
				{ Archetype = "PlayerLarge", Gender = "male",
					FirstName = "Rivals_Accusers_Extra_04",
					PlayerAttributeAuraModifier = 3,
					PlayerAttributeRespawnModifier = 7,
					PlayerAttributeSpeedModifier = 2,
					SpecialScorePose = "PlayerLargeScorePoseAlt",
					SmallPortrait = "Demon_Accusers_Small",
					Height = 5.2,
					MatchSkills =
					{
						[2] = { "KillsRegenerateStamina100", "PlusPresenceSkill" },
						[3] = { "PlusEnemyRespawnTime", "DoubleRush" },
					},
					MatchItems =
					{
						[2] = "WinningScoreItemAccusers",
					},
				},
			}
		},
		[3] =
		{
			-- Fate Team
			Name = "TeamName03",
			GoalDecalSigil = "FateGrill01",
			MeteorColorGrade = "Team03",
			MaskHue = 290, MaskSaturationAddition = -30, MaskValueAddition = -25,
			MaskHue2 = 40, MaskSaturationAddition2 = -40, MaskValueAddition2 = 40,
			PostMatchSigil = "SigilFate",
			RosterScreenSigil = "GUI\\Sigils\\Fate_01_UI",
			LargeSigil = "Tilesets\\Arena\\Fate_01",
			PyreIcon = "GUI\\Icons\\Pyre\\PyreIcon_Fate",
			IntroVO = "/VO/Match_147", VictoryVO = "/VO/Match_148",
			AscensionVictoryVO = "/VO/Match_561",
			MusicTheme = "/Music/MatchMusic7_MC",
			AscensionMusicTheme = "/Music/AscensionMatchMusicFate_MC",
			AscensionMatchStartEvents = { "Ascension_Beginning_Fate_01" },
			FlyingEvents = { "FlyingWagon_Fate_01", "FlyingWagon_Fate_02" },
			StarPickEvents = { "OpenStructure_Onward_StarPicked_Fate_01" },
			RivalryCharTag = "Story_Psycho",
			RivalryPreMatchEvents = { "OpenStructure_ReachedGoal_Rivalry_Fate_01", "OpenStructure_ReachedGoal_Rivalry_Fate_02" },
			RivalryMatchStartEvents = { "OpenStructure_Match_Beginning_Rivalry_Fate_01", "OpenStructure_Match_Beginning_Rivalry_Fate_02" },
			RivalryMatchDraftStartEvents = { "OpenStructure_Match_DraftStart_Rivalry_Fate_01" },
			RivalryMatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_Rivalry_Fate_01" },
			RivalryMatchVictoryEvents = { "OpenStructure_Match_TheyLost_Rivalry_Fate_01" },
			RivalryMatchDefeatEvents = { "OpenStructure_Match_TheyWon_Rivalry_Fate_01" },
			RivalryAscensionConclusionEventsPlayerWon = { "Ascension_Conclusion_PlayerWon_Rivalry_Fate" },
			RivalryAscensionConclusionEventsPlayerLost = { "Ascension_Conclusion_PlayerLost_Rivalry_Fate" },
			-- PreMatchEvents = { "OpenStructure_ReachedGoal_01" },
			-- MatchStartEvents = { "OpenStructure_Match_Beginning_02" },
			-- MatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_01" },
			LastMatchBigWinPhrases = { "TeamMemory_BigWin_Fate_01" },
			LastMatchCloseWinPhrases = { "TeamMemory_CloseWin_Fate_01" },
			LastMatchSolidWinPhrases = { "TeamMemory_SolidWin_Fate_01" },
			LastMatchBigLossPhrases = { "TeamMemory_BigLoss_Fate_01" },
			LastMatchCloseLossPhrases = { "TeamMemory_CloseLoss_Fate_01" },
			LastMatchSolidLossPhrases = { "TeamMemory_SolidLoss_Fate_01" },
			LastMatchNoMemoryPhrases = { "TeamMemory_NoMemory_Fate_01" },
			GenericReputation = "TeamName03_GenericRep_01",
			GuideBookChapter = 8,
			GuideBookEntry = 3,
			WinsSinceLastAscensionAttempt = 37,
			SimulatedMatchPower = 4,

			ForcedDraftPicks =
			{
				[1] = { 1, 2, 3 },
				[2] = { 1, 2, 3 },
				[3] = { 1, 2, 4 },
				[4] = { 1, 2, },
				[5] = { 1, 2 },
			},

			TeamAVersusLineNames = { "/VO/Match_1205" },
			TeamBVersusLineNames = { "/VO/Match_1206" },
			TeamScoresFirstSpeechLines =
			{
				-- The Fate are first to strike their adversary's flame!
				"/VO/Match_996",
				-- Glory goes first to the Fate!
				"/VO/Match_997",
				-- The Fate have made their mark upon the flame!
				"/VO/Match_998",
			},
			TeamScoredOnFirstSpeechLines =
			{
				-- The Fate's Pyre is the first to falter.
				"/VO/Match_999",
				-- The Orb bathes first in the Fate's flame!
				"/VO/Match_1000",
			},
			TeamTakesLeadSpeechLines =
			{
				-- The Fate's Pyre now burns relatively brighter.
				"/VO/Match_1001",
				-- The Fate seem to want their freedom more.
				"/VO/Match_1002",
				-- The Fate are now favored to prevail.
				"/VO/Match_1003",
				-- Shall the Fate press their luck, perhaps?
				"/VO/Match_1004",
				-- Perhaps the Scribes are favoring the Fate.
				"/VO/Match_1005",
				-- The Fate have gained an edge, for now.
				"/VO/Match_1006",
			},
			TeamLosesLeadSpeechLines =
			{
				-- The Fate seem to be falling behind.
				"/VO/Match_1007",
				-- The Fate's adversaries may as yet prevail.
				"/VO/Match_1008",
				-- A show of strength from the Fate's opponent.
				"/VO/Match_1009",
			},
			TeamFullWipeLines =
			{
				-- All of the Fate, gone.
				"/VO/Match_1010",
				-- The Fate are banished to the last.
				"/VO/Match_1011",
				-- Unfortunate for the Fate.
				"/VO/Match_1012",
				-- An awkward situation for the Fate.
				"/VO/Match_1013",
				-- How very sad for the Fate.
				"/VO/Match_1014",
				-- No sign of the Fate for now!
				"/VO/Match_1015",
			},
			TeamPyreExtinguishedLines =
			{
				-- The Fate's flame is out!
				"/VO/Match_1016",
				-- The Fate's flames, extinguished!
				"/VO/Match_1017",
			},
			TeamReadyLines =
			{
				-- The Fate, stand prepared.
				"/VO/Match_1018",
				-- The Fate, stand ready.
				"/VO/Match_1019",
			},

			TeamBench =
			{
				-- Dalbert Oldheart / Cur
				{
					Archetype = "PlayerSmall",
					Tags = { "Story_FateDad" },
					Traits = { },
					Gender = "male",
					FirstName = "Rivals_FateDad_FirstName",
					LastName = "Rivals_FateDad_LastName",
					LongName = "Rivals_FateDad_FullName",
					FamilyName = "Rivals_FateDad_LastName",
					TooltipIds = { FirstName = "Rivals_FateDad_FullName", ShortName = "Rivals_FateDad_FullName", LongName = "Rivals_FateDad_FullName", FullName = "Rivals_FateDad_FullName", LastName = "Rivals_FateDad_FullName", FamilyName = "Rivals_FateDad_LastName_Tooltip" },
					StartingTrait = "FateDad01",
					Backstory = "Rivals_FateDad_Backstory_Initial",
					RevealedBackstories = { "Rivals_FateDad_Backstory_Complete", },
					Past = "Rivals_FateDad_Past",
					Reason = "Rivals_FateDad_Reason",
					Reputation = "FateDad_Reputation_01",
					YearsExiled = 5,
					Birthday = { Month = "mOctober", Date = 1 },
					Portrait = "CurDalbert01_Robed",
					RobedPortrait = "CurDalbert01_Robed",
					SmallPortrait = "CurDalbert01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Dalbert/",
					AscensionSendOffVO = "/VO/Justice_996",
					MusicTheme = "/Music/MatchMusic7_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,
					AscensionSuccessEvent = "AscensionSuccess_FateDad",
					AscensionFailureEvent = "AscensionFailure_FateDad",
					PostAscensionNewJunctionEvents = { "OpenStructure_RivalAscended_Fate_01" },
					AscendedTooltip = "AscendedRival_FateDad",

					-- EpilogueAscendedEvent = "Epilogue_Fate_Ascended_01",

					DraftedSpeech = "/VO/Match_102",
					TauntSoundLong = "/SFX/Player Sounds/Vocalizations/Dalbert/EmoteLongHowl",
					TauntSound = "/SFX/Player Sounds/Vocalizations/Dalbert/EmoteShortHowl",
					UseVictoryVO = true,
					ScoringSpeechLines = { "/VO/Match_441", "/VO/Match_442", "/VO/Match_443", },
					ThrowScoringSpeechLines = { "/VO/Match_869", "/VO/Match_870", "/VO/Match_871" },
					BanishedSpeechLines = { "/VO/Match_444", "/VO/Match_445", "/VO/Match_446", "/VO/Match_447" },
					SpecialScorePose = "PlayerSmallScorePoseAlt",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = 1,
					PlayerAttributeSpeedModifier = 2,

					MatchSkills =
					{
						[2] = { "DoubleJump", "SprintSpeed" },
						[3] = { "InstantRespawn" },
						[4] = { "TripleJump" },
					},
					MatchItems =
					{
						[2] = "LosingScoreItemFate",
					},
				},
				-- Almer the Helpless / NomadAlt
				{
					Archetype = "PlayerMediumAlt",
					Tags = { "Story_FateSon" },
					Gender = "male",
					FirstName = "Rivals_FateSon_FirstName",
					TitlePostFix = "Nomad_Title_04",
					LastName = "Rivals_FateDad_LastName",
					LongName = "Rivals_FateSon_LongName",
					FamilyName = "Rivals_FateSon_LongName",
					TooltipIds = { FirstName = "Rivals_FateSon_LongName", ShortName = "Rivals_FateSon_LongName", FullName = "Rivals_FateSon_LongName", LongName = "Rivals_FateSon_LongName", LastName = "Rivals_FateSon_LongName", FamilyName = "Rivals_FateDad_LastName_Tooltip" },
					StartingTrait = "FateSon01",
					Backstory = "Rivals_FateSon_Backstory_Initial",
					RevealedBackstories = { "Rivals_FateSon_Backstory_Complete", },
					Past = "Rivals_FateSon_Past",
					Reason = "Rivals_FateSon_Reason",
					Reputation = "FateSon_Reputation_01",
					YearsExiled = 5,
					Birthday = { Month = "mJune", Date = 30 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop3",
					Portrait = "NomadAlmer01_Robed",
					RobedPortrait = "NomadAlmer01_Robed",
					SmallPortrait = "NomadAlmer01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Almer/",
					AscensionSendOffVO = "/VO/Justice_995",
					MusicTheme = "/Music/MatchMusic7_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,
					AscendedTooltip = "AscendedRival_FateSon",

					EpilogueRivalCharTag = "Story_Psycho",
					EpilogueAscendedEvent = "Epilogue_Fate_Ascended_01",
					EpilogueAscendedPlanAEvent = "Epilogue_Fate_AscendedPlanA_01",
					EpilogueAscendedPlanBEvent = "Epilogue_Fate_AscendedPlanB_01",
					EpilogueAscendedPlanCEvent = "Epilogue_Fate_AscendedPlanC_01",
					EpilogueAscendedPostPlanEvent = "Epilogue_Fate_AscendedPostPlan_01",
					EpilogueAscendedWithRivalEvent = "Epilogue_Fate_Ascended_WithRival_01",
					EpilogueRemainedEvent = "Epilogue_Fate_Remained_01",
					EpilogueRemainedWithRivalEvent = "Epilogue_Fate_Remained_WithRival_01",
					EpilogueConclusionEvent = "Epilogue_Fate_Conclusion_01",

					DraftedSpeech = "/VO/Match_103",
					VoiceUseTeamPostfix = false,
					UseVictoryVO = true,
					ScoringSpeechLines = { "/VO/Match_448", "/VO/Match_449", "/VO/Match_450", },
					ThrowScoringSpeechLines = { "/VO/Match_872", "/VO/Match_873", "/VO/Match_874" },
					BanishedSpeechLines = { "/VO/Match_451", "/VO/Match_452", "/VO/Match_453", "/VO/Match_454" },
					SpecialScorePose = "PlayerMediumAltScorePoseAlt",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -3,
					PlayerAttributeSpeedModifier = -3,

					MatchSkills =
					{
						[2] = { "MobilityChargeTime" },
						[3] = { "CastChargeTime", "TossSkillMediumAlt" },
						[4] = { "UnlimitedBallStamina" },
					},


					MatchItems =
					{
						[2] = "LosingScoreItemFate",
					},
				},
				-- Enia
				{ Archetype = "PlayerMedium", Gender = "female",
					FirstName = "Rivals_Fate_Extra_01",
					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -4,
					PlayerAttributeSpeedModifier = -2,
					SpecialScorePose = "PlayerMediumScorePoseAlt",
					SmallPortrait = "Nomad_Fate_Small",

					MatchSkills =
					{
						[2] = { "StaminaSkill" },
						[3] = { "JumpKillSkill" },
						[4] = { "TeamStaminaRechargeSkill" },
					},
					MatchItems =
					{
						[2] = "LosingScoreItemFate",
					},
				},
				-- Ra'ji
				{ Archetype = "PlayerImp", Gender = "male",
					FirstName = "Rivals_Fate_Extra_02",
					PlayerAttributeAuraModifier = 4,
					PlayerAttributeRespawnModifier = 4,
					PlayerAttributeSpeedModifier = 4,
					SpecialScorePose = "PlayerImpScorePoseAlt",
					SmallPortrait = "Imp_Fate_Small",

					MatchSkills =
					{
						[2] = { "MoveBetter" },
						[3] = { "ExplodeBigger", "CastFastRespawn" },
					},
					MatchItems =
					{
						[2] = "LosingScoreItemFate",
					},
				},
			}
		},
		[4] =
		{
			-- Dissidents Team
			Name = "TeamName04",
			GoalDecalSigil = "DissidentsGrill01",
			MeteorColorGrade = "Team04",
			MaskHue = 20, MaskSaturationAddition = -0, MaskValueAddition = -5,
			MaskHue2 = 50, MaskSaturationAddition2 = -80,  MaskValueAddition2 = -85,
			PostMatchSigil = "SigilDissidents",
			RosterScreenSigil = "GUI\\Sigils\\Dissidents_01_UI",
			LargeSigil = "Tilesets\\Arena\\Dissidents_01",
			PyreIcon = "GUI\\Icons\\Pyre\\PyreIcon_Dissidents",
			IntroVO = "/VO/Match_149", VictoryVO = "/VO/Match_150",
			AscensionVictoryVO = "/VO/Match_562",
			MusicTheme = "/Music/DissidentsTheme_MC",
			AscensionMusicTheme = "/Music/AscensionMatchMusicDissidents_MC",
			AscensionMatchStartEvents = { "Ascension_Beginning_Dissidents_01" },
			FlyingEvents = { "FlyingWagon_Dissidents_01", "FlyingWagon_Dissidents_02" },
			StarPickEvents = { "OpenStructure_Onward_StarPicked_Dissidents_01" },
			RivalryCharTag = "Story_Joker",
			RivalryPreMatchEvents = { "OpenStructure_ReachedGoal_Rivalry_Dissidents_01" },
			RivalryMatchStartEvents = { "OpenStructure_Match_Beginning_Rivalry_Dissidents_01" },
			RivalryMatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_Rivalry_Dissidents_01" },
			RivalryMatchVictoryEvents = { "OpenStructure_Match_TheyLost_Rivalry_Dissidents_01" },
			RivalryMatchDefeatEvents = { "OpenStructure_Match_TheyWon_Rivalry_Dissidents_01" },
			RivalryEndedMatchStartEvents = { "OpenStructure_Match_Beginning_RivalryEnded_Dissidents_01" },
			-- PreMatchEvents = { "OpenStructure_ReachedGoal_01" },
			-- MatchStartEvents = { "OpenStructure_Match_Beginning_02" },
			-- MatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_01" },
			LastMatchBigWinPhrases = { "TeamMemory_BigWin_Dissidents_01" },
			LastMatchCloseWinPhrases = { "TeamMemory_CloseWin_Dissidents_01" },
			LastMatchSolidWinPhrases = { "TeamMemory_SolidWin_Dissidents_01" },
			LastMatchBigLossPhrases = { "TeamMemory_BigLoss_Dissidents_01" },
			LastMatchCloseLossPhrases = { "TeamMemory_CloseLoss_Dissidents_01" },
			LastMatchSolidLossPhrases = { "TeamMemory_SolidLoss_Dissidents_01" },
			LastMatchNoMemoryPhrases = { "TeamMemory_NoMemory_Dissidents_01" },
			GenericReputation = "TeamName04_GenericRep_01",
			GuideBookChapter = 8,
			GuideBookEntry = 4,
			WinsSinceLastAscensionAttempt = 33,
			SimulatedMatchPower = 7,

			ForcedDraftPicks =
			{
				[1] = { 1, 2, 3 },
				[2] = { 1 },
				[3] = { 1 },
				[4] = { 1 },
				[5] = { 1 },
			},

			TeamAVersusLineNames = { "/VO/Match_1207" },
			TeamBVersusLineNames = { "/VO/Match_1208" },
			TeamScoresFirstSpeechLines =
			{
				-- The Dissidents are first to strike their adversary's flame!
				"/VO/Match_1020",
				-- Glory first to the Dissidents!
				"/VO/Match_1021",
				-- The Dissidents make their mark upon the flame!
				"/VO/Match_1022",
			},
			TeamScoredOnFirstSpeechLines =
			{
				-- The Dissidents' Pyre is the first to falter.
				"/VO/Match_1023",
				-- The Orb bathes first in the Dissidents' flame!
				"/VO/Match_1024",
			},
			TeamTakesLeadSpeechLines =
			{
				-- The Dissidents' Pyre now burns relatively brighter.
				"/VO/Match_1025",
				-- The Dissidents seem hungry to prevail.
				"/VO/Match_1026",
				-- The Dissidents are now favored to prevail.
				"/VO/Match_1027",
				-- Shall the Dissidents press their luck, perhaps?
				"/VO/Match_1028",
				-- The Dissidents best not grow overconfident just yet.
				"/VO/Match_1029",
				-- How very fortunate for the Dissidents.
				"/VO/Match_1030",
			},
			TeamLosesLeadSpeechLines =
			{
				-- The Dissidents seem to be falling behind.
				"/VO/Match_1031",
				-- The Dissidents' adversaries gained an edge.
				"/VO/Match_1032",
				-- A show of strength from the Dissidents' rivals.
				"/VO/Match_1033",
			},
			TeamFullWipeLines =
			{
				-- All of the Dissidents, gone.
				"/VO/Match_1034",
				-- The Dissidents are banished to the last.
				"/VO/Match_1035",
				-- Unfortunate for the Dissidents.
				"/VO/Match_1036",
				-- A rude predicament for the Dissidents.
				"/VO/Match_1037",
				-- How sad for the Dissidents.
				"/VO/Match_1038",
				-- No sign of the Dissidents for now!
				"/VO/Match_1039",
			},
			TeamPyreExtinguishedLines =
			{
				-- The Dissidents' flame is out!
				"/VO/Match_1040",
				-- The Dissidents' flames, extinguished!
				"/VO/Match_1041",
			},
			TeamReadyLines =
			{
				-- Dissidents, stand prepared.
				"/VO/Match_1042",
				-- Dissidents, stand ready.
				"/VO/Match_1043",
			},

			TeamBench =
			{
				-- Barker Ashpaws / Cur
				{
					Archetype = "PlayerSmall",
					Tags = { "Story_Dissident" },
					Gender = "male",
					FirstName = "Rivals_Captain14_FirstName",
					LastName = "Rivals_Captain14_LastName",
					LongName = "Rivals_Captain14_FullName",
					TooltipIds = { FirstName = "Rivals_Captain14_FullName", ShortName = "Rivals_Captain14_FullName", LastName = "Rivals_Captain14_FullName", LongName = "Rivals_Captain14_FullName", FullName = "Rivals_Captain14_FullName" },
					StartingTrait = "Dissident01",
					Backstory = "Rivals_Dissident_Backstory_Initial",
					RevealedBackstories = { "Rivals_Dissident_Backstory_Complete", },
					Past = "Rivals_Dissident_Past",
					Reason = "Rivals_Dissident_Reason",
					Reputation = "Dissident_Reputation_01",
					YearsExiled = 4,
					Birthday = { Month = "mDecember", Date = 12 },
					TextSpeedMultiplier = 0.9,
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop3",
					Portrait = "CurBarker01_Robed",
					RobedPortrait = "CurBarker01_Robed",
					SmallPortrait = "CurBarker01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Barker/",
					AscensionSendOffVO = "/VO/Justice_997",
					MusicTheme = "/Music/DissidentsTheme_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,
					AscensionSuccessEvent = "AscensionSuccess_Dissident",
					AscensionFailureEvent = "AscensionFailure_Dissident",
					PostAscensionNewJunctionEvents = { "OpenStructure_RivalAscended_Dissident_01" },
					AscendedTooltip = "AscendedRival_Dissident",

					EpilogueRemainedEvent = "Epilogue_Dissident_Remained_01",
					EpilogueAscendedEvent = "Epilogue_Dissident_Ascended_01",
					EpilogueRivalCharTag = "Story_Joker",
					EpilogueSpecialRivalEventNarrationReq = "OpenStructure_Match_TheyWon_Rivalry_Dissidents_01_Refuse",
					EpilogueSpecialRivalEvent = "Epilogue_Dissident_SpecialRival_01",
					EpilogueWithRivalEvent = "Epilogue_Dissident_WithRival_01",
					EpilogueWithoutRivalEvent = "Epilogue_Dissident_WithoutRival_01",
					EpilogueConclusionEvent = "Epilogue_Dissident_Conclusion_01",

					DraftedSpeech = "/VO/Match_104",
					TauntSoundLong = "/SFX/Player Sounds/Vocalizations/Barker/EmoteLongHowl",
					TauntSound = "/SFX/Player Sounds/Vocalizations/Barker/EmoteShortHowl",
					UseVictoryVO = true,
					ScoringSpeechLines = { "/VO/Match_455", "/VO/Match_456", "/VO/Match_457", },
					ThrowScoringSpeechLines = { "/VO/Match_875", "/VO/Match_876", "/VO/Match_877" },
					BanishedSpeechLines = { "/VO/Match_458", "/VO/Match_459", "/VO/Match_460", "/VO/Match_461", "/VO/Match_462" },
					SpecialScorePose = "PlayerSmallScorePoseAlt",

					PlayerAttributeAuraModifier = 3,
					PlayerAttributeRespawnModifier = 1,
					PlayerAttributeSpeedModifier = 3,

					MatchSkills =
					{
						[1] = { "DoubleJump" },
						[2] = { "UnlimitedRange" },
						[3] = { "SacrificeScoreSkill5", "AuraKillDetonate100" },
					},

					MatchItems =
					{
						[2] = "PlusAuraItemDissidents",
					},
				},
				-- Charson
				{
					Archetype = "PlayerSmall",
					FirstName = "Rivals_Dissidents_Extra_01",
					Gender = "male",
					Tags = { "Test_Small" },
					SpecialScorePose = "PlayerSmallScorePoseAlt",
					SmallPortrait = "Cur_Dissidents_Small",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -3,
					PlayerAttributeSpeedModifier = 2,

					MatchSkills =
					{
						[1] = { "DoubleJump" },
						[2] = { "UnlimitedRange" },
						[3] = { "SacrificeScoreSkill5", "AuraKillDetonate100" },
					},
					MatchItems =
					{
						[2] = "SacrificeScoreRespawnItemDissidents",
					},
				},
				-- Marla
				{
					Archetype = "PlayerSmall",
					FirstName = "Rivals_Dissidents_Extra_02",
					Gender = "female",
					SpecialScorePose = "PlayerSmallScorePoseAlt",
					SmallPortrait = "Cur_Dissidents_Small",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -4,
					PlayerAttributeSpeedModifier = 3,

					MatchSkills =
					{
						[1] = { "DoubleJump" },
						[2] = { "UnlimitedRange" },
						[3] = { "SacrificeScoreSkill5", "AuraKillDetonate100" },
					},
					MatchItems =
					{
						[2] = "SacrificeScoreRespawnItemDissidents",
					},
				},
				-- Snarlo
				{
					Archetype = "PlayerSmall",
					FirstName = "Rivals_Dissidents_Extra_03",
					Gender = "male",
					SpecialScorePose = "PlayerSmallScorePoseAlt",
					SmallPortrait = "Cur_Dissidents_Small",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -2,
					PlayerAttributeSpeedModifier = 1,

					MatchSkills =
					{
						[1] = { "DoubleJump" },
						[2] = { "UnlimitedRange" },
						[3] = { "SacrificeScoreSkill5", "AuraKillDetonate100" },
					},
					MatchItems =
					{
						[2] = "SacrificeScoreRespawnItemDissidents",
					},
				},
				-- Scarly
				{
					Archetype = "PlayerSmall",
					FirstName = "Rivals_Dissidents_Extra_04",
					Gender = "female",
					SpecialScorePose = "PlayerSmallScorePoseAlt",
					SmallPortrait = "Cur_Dissidents_Small",

					PlayerAttributeAuraModifier = 5,
					PlayerAttributeRespawnModifier = 0,
					PlayerAttributeSpeedModifier = -2,
					MatchScale=1.09,

					MatchSkills =
					{
						[1] = { "DoubleJump" },
						[2] = { "UnlimitedRange" },
						[3] = { "SacrificeScoreSkill5", "AuraKillDetonate100" },
					},
					MatchItems =
					{
						[2] = "SacrificeScoreRespawnItemDissidents",
					},
				},
				-- Walfie
				{
					Archetype = "PlayerSmall",
					FirstName = "Rivals_Dissidents_Extra_05",
					Gender = "male",
					SpecialScorePose = "PlayerSmallScorePoseAlt",
					SmallPortrait = "Cur_Dissidents_Small",

					PlayerAttributeAuraModifier = 9,
					PlayerAttributeRespawnModifier = 0,
					PlayerAttributeSpeedModifier = -1,
					MatchScale=1.07,

					MatchSkills =
					{
						[1] = { "DoubleJump" },
						[2] = { "UnlimitedRange" },
						[3] = { "SacrificeScoreSkill5", "AuraKillDetonate100" },
					},
					MatchItems =
					{
						[2] = "SacrificeScoreRespawnItemDissidents",
					},
				},
			}
		},
		[5] =
		{
			-- Withdrawn Team
			Name = "TeamName05",
			GoalDecalSigil = "WithdrawnGrill01",
			MeteorColorGrade = "Team05",
			MaskHue = 75, MaskSaturationAddition = -30, MaskValueAddition = -25,
			MaskHue2 = 128, MaskSaturationAddition2 = -40, MaskValueAddition2 = 60,
			PostMatchSigil = "SigilWithdrawn",
			RosterScreenSigil = "GUI\\Sigils\\Withdrawn_01_UI",
			LargeSigil = "Tilesets\\Arena\\Withdrawn_01",
			PyreIcon = "GUI\\Icons\\Pyre\\PyreIcon_Withdrawn",
			IntroVO = "/VO/Match_151", VictoryVO = "/VO/Match_152",
			AscensionVictoryVO = "/VO/Match_563",
			MusicTheme = "/Music/WithdrawnTheme_MC",
			AscensionMusicTheme = "/Music/AscensionMatchMusicWithdrawn_MC",
			AscensionMatchStartEvents = { "Ascension_Beginning_Withdrawn_01" },
			FlyingEvents = { "FlyingWagon_Withdrawn_01", "FlyingWagon_Withdrawn_02" },
			StarPickEvents = { "OpenStructure_Onward_StarPicked_Withdrawn_01" },
			RivalryCharTag = "Story_Diva",
			RivalryPreMatchEvents = { "OpenStructure_ReachedGoal_Rivalry_Withdrawn_01" },
			RivalryMatchConstellationEvents = { "OpenStructure_Constellation_Rivalry_Withdrawn_01" },
			RivalryMatchDraftStartEvents = { "OpenStructure_Match_DraftStart_Rivalry_Withdrawn_01" },
			RivalryMatchDraftStartAltEvents = { "OpenStructure_Match_DraftStart_Rivalry_Withdrawn_01_Alt" },
			RivalryMatchStartEvents = { "OpenStructure_Match_Beginning_Rivalry_Withdrawn_01" },
			RivalryMatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_Rivalry_Withdrawn_01" },
			RivalryMatchVictoryEvents = { "OpenStructure_Match_TheyLost_Rivalry_Withdrawn_01" },
			RivalryMatchVictoryAltEvents = { "OpenStructure_Match_TheyLost_Rivalry_Withdrawn_01_Alt" },
			RivalryMatchDefeatEvents = { "OpenStructure_Match_TheyWon_Rivalry_Withdrawn_01" },
			RivalryMatchDefeatAltEvents = { "OpenStructure_Match_TheyWon_Rivalry_Withdrawn_01_Alt" },
			-- PreMatchEvents = { "OpenStructure_ReachedGoal_01" },
			-- MatchStartEvents = { "OpenStructure_Match_Beginning_02" },
			-- MatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_01" },
			LastMatchBigWinPhrases = { "TeamMemory_BigWin_Withdrawn_01" },
			LastMatchCloseWinPhrases = { "TeamMemory_CloseWin_Withdrawn_01" },
			LastMatchSolidWinPhrases = { "TeamMemory_SolidWin_Withdrawn_01" },
			LastMatchBigLossPhrases = { "TeamMemory_BigLoss_Withdrawn_01" },
			LastMatchCloseLossPhrases = { "TeamMemory_CloseLoss_Withdrawn_01" },
			LastMatchSolidLossPhrases = { "TeamMemory_SolidLoss_Withdrawn_01" },
			LastMatchNoMemoryPhrases = { "TeamMemory_NoMemory_Withdrawn_01" },
			GenericReputation = "TeamName05_GenericRep_01",
			GuideBookChapter = 8,
			GuideBookEntry = 5,
			WinsSinceLastAscensionAttempt = 35,
			SimulatedMatchPower = 9,

			ForcedDraftPicks =
			{
				[1] = { 1, 2, 3 },
				[2] = { 1, 4, 5 },
				[3] = { 1, 6, 7 },
				[4] = { 1 },
				[5] = { 1 },
			},

			TeamAVersusLineNames = { "/VO/Match_1209" },
			TeamBVersusLineNames = { "/VO/Match_1210" },
			TeamScoresFirstSpeechLines =
			{
				-- The Withdrawn are first to strike their adversary's flame!
				"/VO/Match_1044",
				-- Glory first to the Withdrawn!
				"/VO/Match_1045",
				-- The Withdrawn thus make their mark upon the flame!
				"/VO/Match_1046",
			},
			TeamScoredOnFirstSpeechLines =
			{
				-- The Withdrawn's Pyre is the first to falter.
				"/VO/Match_1047",
				-- The Orb bathes first in the Withdrawn's flame!
				"/VO/Match_1048",
			},
			TeamTakesLeadSpeechLines =
			{
				-- The Withdrawn's Pyre now burns relatively brighter.
				"/VO/Match_1049",
				-- The Withdrawn hunger to prevail.
				"/VO/Match_1050",
				-- The Withdrawn are now favored to prevail.
				"/VO/Match_1051",
				-- Shall the Withdrawn further press their luck?
				"/VO/Match_1052",
				-- The Withdrawn gained the upper hand.
				"/VO/Match_1053",
				-- How very fortunate for the Withdrawn.
				"/VO/Match_1054",
			},
			TeamLosesLeadSpeechLines =
			{
				-- The Withdrawn seem to be falling behind.
				"/VO/Match_1055",
				-- The Withdrawn's adversaries gained an edge.
				"/VO/Match_1056",
				-- A show of strength from the Withdrawn's foes.
				"/VO/Match_1057",
			},
			TeamFullWipeLines =
			{
				-- All of the Withdrawn, gone.
				"/VO/Match_1058",
				-- The Withdrawn, banished to the last.
				"/VO/Match_1059",
				-- Unfortunate for the Withdrawn.
				"/VO/Match_1060",
				-- A rude predicament for the Withdrawn.
				"/VO/Match_1061",
				-- How sad for the Withdrawn.
				"/VO/Match_1062",
				-- No sign of the Withdrawn for now!
				"/VO/Match_1063",
			},
			TeamPyreExtinguishedLines =
			{
				-- The Withdrawn's flame is out!
				"/VO/Match_1064",
				-- The Withdrawn's flames, extinguished!
				"/VO/Match_1065",
			},
			TeamReadyLines =
			{
				-- The Withdrawn, stand prepared.
				"/VO/Match_1066",
				-- The Withdrawn, stand ready.
				"/VO/Match_1067",
			},

			TeamBench =
			{
				-- Witch Udmildhe / Monster
				{
					Archetype = "PlayerMonster",
					Tags = { "Story_Withdrawn" },
					Gender = "female",
					SurName = "Rivals_Captain13_Surname",
					FirstName = "Rivals_Captain13_FirstName",
					LastName = "Rivals_Captain13_FirstName",
					TooltipIds = { FirstName = "Rivals_Captain13_LongName", ShortName = "Rivals_Captain13_LongName", FullName = "Rivals_Captain13_LongName", LongName = "Rivals_Captain13_LongName" },
					StartingTrait = "Withdrawn01",
					Backstory = "Rivals_Withdrawn_Backstory_Initial",
					RevealedBackstories = { "Rivals_Withdrawn_Backstory_Complete", },
					Past = "Rivals_Withdrawn_Past",
					Reason = "Rivals_Withdrawn_Reason",
					Reputation = "Withdrawn_Reputation_01",
					YearsExiled = 52,
					Birthday = { Month = "mJanuary", Date = 16 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop5",
					TextSpeedMultiplier = 1.25,
					Portrait = "CroneUdmildhe01_Robed",
					RobedPortrait = "CroneUdmildhe01_Robed",
					SmallPortrait = "CroneUdmildhe01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Udmildhe/",
					AscensionSendOffVO = "/VO/Justice_998",
					MusicTheme = "/Music/WithdrawnTheme_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,
					Traits = { },
					AscensionSuccessEvent = "AscensionSuccess_Withdrawn",
					AscensionFailureEvent = "AscensionFailure_Withdrawn",
					PostAscensionNewJunctionEvents = { "OpenStructure_RivalAscended_Withdrawn_01" },
					AscendedTooltip = "AscendedRival_Withdrawn",

					EpilogueAscendedEvent = "Epilogue_Withdrawn_Ascended_01",
					EpilogueRemainedEvent = "Epilogue_Withdrawn_Remained_01",

					DraftedSpeech = "/VO/Match_105",
					EventEnterSound = "/SFX/World Sounds/CroneEnter",
					EventExitSound = "/SFX/World Sounds/CroneEnter",
					UseVictoryVO = true,
					ScoringSpeechLines = { "/VO/Match_463", "/VO/Match_464", "/VO/Match_465", },
					ThrowScoringSpeechLines = { "/VO/Match_878", "/VO/Match_879", "/VO/Match_880" },
					BanishedSpeechLines = { "/VO/Match_466", "/VO/Match_467", "/VO/Match_468", "/VO/Match_469" },
					SpecialScorePose = "PlayerMonsterScorePoseAlt",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = 6,
					PlayerAttributeSpeedModifier = 0,

					MatchSkills =
					{
						[2] = { "LosingScoreSkill5", "CastMonsterSkill" },
						[3] = { "MonsterJumpSkill" },
						[4] = { "WinningScoreSkill5" },
					},
					MatchItems =
					{
						[2] = "PyrePreDamageItemWithdrawn",
					},
				},
				-- Oshra
				{ Archetype = "PlayerMediumAlt",
					FirstName = "Rivals_Withdrawn_Extra_01",
					Tags = { "Test_MediumAlt" },
					Traits = { },
					Gender = "female",
					SpecialScorePose = "PlayerMediumAltScorePoseAlt",
					SmallPortrait = "Nomad_Withdrawn_Small",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -4,
					PlayerAttributeSpeedModifier = 2,

					MatchSkills =
					{
						[1] = { "MobilityChargeTime" },
						[2] = { "CastChargeTime" },
						[3] = { "JumpDistance" },
					},
					MatchItems =
					{
						[2] = "AuraCastRangeItemWithdrawn",
					},
				},
				-- Ramet
				{ Archetype = "PlayerMediumAlt",
					FirstName = "Rivals_Withdrawn_Extra_02",
					Traits = { },
					Gender = "male",
					SpecialScorePose = "PlayerMediumAltScorePoseAlt",
					SmallPortrait = "Nomad_Withdrawn_Small",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -3,
					PlayerAttributeSpeedModifier = 3,

					MatchSkills =
					{
						[1] = { "MobilityChargeTime" },
						[2] = { "CastChargeTime" },
						[3] = { "JumpDistance" },
					},
					MatchItems =
					{
						[2] = "AuraCastRangeItemWithdrawn",
					},
				},
				-- Pi'ab
				{ Archetype = "PlayerImp",  Tags = { "Test_Imp" },
					FirstName = "Rivals_Withdrawn_Extra_03",
					Gender = "female",
					SpecialScorePose = "PlayerImpScorePoseAlt",
					SmallPortrait = "Imp_Withdrawn_Small",

					Traits = {  },
					PlayerAttributeAuraModifier = 3,
					PlayerAttributeRespawnModifier = 4,
					PlayerAttributeSpeedModifier = 3,
					MatchSkills =
					{
						[2] = { "MoveBetter", "CastFastRespawn", "ExplodeBigger" },
					},
					MatchItems =
					{
						[2] = "ThrowDamageItemWithdrawn",
					},
				},
				-- Ya'ul
				{ Archetype = "PlayerImp",
					FirstName = "Rivals_Withdrawn_Extra_04",
					Gender = "male",
					SpecialScorePose = "PlayerImpScorePoseAlt",
					SmallPortrait = "Imp_Withdrawn_Small",

					Traits = {  },
					PlayerAttributeAuraModifier = 3,
					PlayerAttributeRespawnModifier = -1,
					PlayerAttributeSpeedModifier = 4,
					MatchSkills =
					{
						[2] = { "MoveBetter", "CastFastRespawn", "ExplodeBigger" },
					},
					MatchItems =
					{
						[2] = "ThrowDamageItemWithdrawn",
					},
				},
				-- Grunfel
				{ Archetype = "PlayerMonster",
					FirstName = "Rivals_Withdrawn_Extra_05",
					Gender = "female",
					SpecialScorePose = "PlayerMonsterScorePoseAlt",
					SmallPortrait = "Crone_Withdrawn_Small",

					Traits = {  },
					PlayerAttributeAuraModifier = 1,
					PlayerAttributeRespawnModifier = 4,
					PlayerAttributeSpeedModifier = 6,
					MatchSkills =
					{
						[3] = { "LosingScoreSkill5" },
						[4] = { "WinningScoreSkill5" },
					},
					MatchItems =
					{
						[2] = "ThrowDamageItemWithdrawn",
					},
				},
				-- Hrantha
				{ Archetype = "PlayerMonster",
					FirstName = "Rivals_Withdrawn_Extra_06",
					Gender = "female",
					SpecialScorePose = "PlayerMonsterScorePoseAlt",
					SmallPortrait = "Crone_Withdrawn_Small",

					Traits = {  },
					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = 5,
					PlayerAttributeSpeedModifier = 2,
					MatchSkills =
					{
						[3] = { "LosingScoreSkill5" },
						[4] = { "WinningScoreSkill5" },
					},
					MatchItems =
					{
						[2] = "ThrowDamageItemWithdrawn",
					},
				},
			}
		},
		[6] =
		{
			-- Pyrehearts Team
			Name = "TeamName06",
			GoalDecalSigil = "PyreheartsGrill01",
			MeteorColorGrade = "Team06",
			MaskHue = 170, MaskSaturationAddition = 0, MaskValueAddition = -20,
			MaskHue2 = 0, MaskSaturationAddition2 = 10, MaskValueAddition2 = 30,
			PostMatchSigil = "SigilPyrehearts",
			RosterScreenSigil = "GUI\\Sigils\\Pyrehearts_01_UI",
			LargeSigil = "Tilesets\\Arena\\Pyrehearts_01",
			PyreIcon = "GUI\\Icons\\Pyre\\PyreIcon_Pyrehearts",
			IntroVO = "/VO/Match_153", VictoryVO = "/VO/Match_154",
			AscensionVictoryVO = "/VO/Match_564",
			MusicTheme = "/Music/MatchMusic8_MC",
			AscensionMusicTheme = "/Music/AscensionMatchMusicPyrehearts_MC",
			AscensionMatchStartEvents = { "Ascension_Beginning_Pyrehearts_01" },
			FlyingEvents = { "FlyingWagon_Pyrehearts_01", "FlyingWagon_Pyrehearts_02" },
			StarPickEvents = { "OpenStructure_Onward_StarPicked_Pyrehearts_01" },
			RivalryCharTag = "Story_Knight",
			RivalryPreMatchEvents = { "OpenStructure_ReachedGoal_Rivalry_Pyrehearts_01" },
			RivalryMatchStartEvents = { "OpenStructure_Match_Beginning_Rivalry_Pyrehearts_01" },
			RivalryMatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_Rivalry_Pyrehearts_01" },
			RivalryMatchVictoryEvents = { "OpenStructure_Match_TheyLost_Rivalry_Pyrehearts_01" },
			RivalryMatchDefeatEvents = { "OpenStructure_Match_TheyWon_Rivalry_Pyrehearts_01" },
			RivalryEndedMatchStartEvents = { "OpenStructure_Match_Beginning_RivalryEnded_Pyrehearts_01" },
			-- PreMatchEvents = { "OpenStructure_ReachedGoal_01" },
			-- MatchStartEvents = { "OpenStructure_Match_Beginning_02" },
			-- MatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_01" },
			LastMatchBigWinPhrases = { "TeamMemory_BigWin_Pyrehearts_01" },
			LastMatchCloseWinPhrases = { "TeamMemory_CloseWin_Pyrehearts_01" },
			LastMatchSolidWinPhrases = { "TeamMemory_SolidWin_Pyrehearts_01" },
			LastMatchBigLossPhrases = { "TeamMemory_BigLoss_Pyrehearts_01" },
			LastMatchCloseLossPhrases = { "TeamMemory_CloseLoss_Pyrehearts_01" },
			LastMatchSolidLossPhrases = { "TeamMemory_SolidLoss_Pyrehearts_01" },
			LastMatchNoMemoryPhrases = { "TeamMemory_NoMemory_Pyrehearts_01" },
			GenericReputation = "TeamName06_GenericRep_01",
			GuideBookChapter = 8,
			GuideBookEntry = 6,
			WinsSinceLastAscensionAttempt = 32,
			SimulatedMatchPower = 3,

			ForcedDraftPicks =
			{
				[1] = { 1, 3, 6 },
				[2] = { 1, 2, 4 },
				[3] = { 1, 4, 5 },
				[4] = { 1, 5, 4 },
				[5] = { 1, 2, 4},
			},

			TeamAVersusLineNames = { "/VO/Match_1211" },
			TeamBVersusLineNames = { "/VO/Match_1212" },
			TeamScoresFirstSpeechLines =
			{
				-- The Pyrehearts are first to strike their adversary's flame!
				"/VO/Match_1068",
				-- Glory first to the Pyrehearts!
				"/VO/Match_1069",
				-- The Pyrehearts make their mark upon the flame!
				"/VO/Match_1070",
			},
			TeamScoredOnFirstSpeechLines =
			{
				-- The Pyrehearts' Pyre is the first to falter.
				"/VO/Match_1071",
				-- The Orb bathes first in the Pyrehearts' flame!
				"/VO/Match_1072",
			},
			TeamTakesLeadSpeechLines =
			{
				-- The Pyrehearts' Pyre now burns relatively brighter.
				"/VO/Match_1073",
				-- The Pyrehearts seem hungry for their glory.
				"/VO/Match_1074",
				-- The Pyrehearts are now favored to prevail.
				"/VO/Match_1075",
				-- Shall the Pyrehearts now further their advantage?
				"/VO/Match_1076",
				-- Best not let this go to your heads, Pyrehearts.
				"/VO/Match_1077",
				-- How very fortunate for the Pyrehearts.
				"/VO/Match_1078",
			},
			TeamLosesLeadSpeechLines =
			{
				-- The Pyrehearts seem to be falling behind.
				"/VO/Match_1079",
				-- The Pyrehearts' adversaries gained an edge.
				"/VO/Match_1080",
				-- A show of strength from the Pyrehearts' foe.
				"/VO/Match_1081",
			},
			TeamFullWipeLines =
			{
				-- All of the Pyrehearts, gone.
				"/VO/Match_1082",
				-- Pyrehearts, banished to the last.
				"/VO/Match_1083",
				-- Unfortunate for the Pyrehearts.
				"/VO/Match_1084",
				-- A rude predicament for the Pyrehearts.
				"/VO/Match_1085",
				-- How very sad for the Pyrehearts.
				"/VO/Match_1086",
				-- No sign of the Pyrehearts for now!
				"/VO/Match_1087",
			},
			TeamPyreExtinguishedLines =
			{
				-- The Pyrehearts' flame is out!
				"/VO/Match_1088",
				-- The Pyrehearts' flames, extinguished!
				"/VO/Match_1089",
			},
			TeamReadyLines =
			{
				-- Pyrehearts, stand prepared.
				"/VO/Match_1090",
				-- Pyrehearts, stand ready.
				"/VO/Match_1091",
			},

			TeamBench =
			{

				-- Sir Gilman - Enemy Version
				{
					Archetype = "PlayerTrail",
					Gender = "male",
					SurName = "Worm_Honorific_Male",
					FirstName = "Chars_Knight_FirstName",
					LastName = "Chars_Knight_FirstName",
					TooltipIds = { FirstName = "Chars_Knight_LongName", ShortName = "Chars_Knight_LongName", FullName = "Chars_Knight_LongName", LastName = "Chars_Knight_LongName" },
					Past = "Past_Knight01",
					Reason = "Reason_Knight01",
					Backstory = "Backstory_Knight01",
					Goal = "Goal_Knight01",
					Fear = "Fear_Knight01",
					Reputation = "Knight_Reputation_01",
					StartingTrait = "Knight01",
					UseVictoryVO = true,
					YearsExiled = 3,

					Birthday = { Month = "mNovember", Date = 3 },
					Portrait = "WyrmGilman01_Robed",
					RobedPortrait = "WyrmGilman01_Robed",
					SmallPortrait = "WyrmGilman02_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Gilman/",
					AscensionSendOffVO = "/VO/Justice_990",
					EventEnterSound = "/SFX/World Sounds/WyrmEnter",
					EventExitSound = "/SFX/World Sounds/WyrmEnter",
					MusicTheme = "/Music/GilmanTheme_MC",
					MusicStemName = "Drums",
					MusicStemValue = 2,
					DraftedSpeech = "/VO/Match_97",
					Height = 2,
					ScoringSpeechLines = { "/VO/Match_272", "/VO/Match_273", "/VO/Match_274", },
					ThrowScoringSpeechLines = { "/VO/Match_854", "/VO/Match_855", "/VO/Match_856" },
					BanishedSpeechLines = { "/VO/Match_275", "/VO/Match_276", "/VO/Match_277", "/VO/Match_278" },
					EventPositionOffset = -50,
					EventPositionOffsetRobed = -50,
					EventPositionOffsetMasked = -50,
				},
				-- Lady Seagrass
				{
					Archetype = "PlayerTrail",
					Gender = "female",
					SurName = "Worm_Honorific_Female",
					FirstName = "Rivals_Pyrehearts_Extra_01",
					LastName = "Rivals_Pyrehearts_Extra_01",
					TooltipIds = { FullName = "Rivals_Pyrehearts_Extra_01_Tooltip", ShortName = "Rivals_Pyrehearts_Extra_01_Tooltip" },
					Traits = { },
					Tags = { "Test_Trail" },
					SmallPortrait = "Wyrm_Pyrehearts_Small",
					SpecialScorePose = "PlayerTrailScorePoseAlt",

					PlayerAttributeAuraModifier = 2,
					PlayerAttributeRespawnModifier = 11,
					PlayerAttributeSpeedModifier = 7,
					Height = 0.6,

					MatchSkills =
					{
						[1] = { "KillsRespawnFriends100" },
						[2] = { "TrailExplosion" },
						[3] = { "WeaponRechargeStamina" },
					},

					MatchItems =
					{
						[2] = "SpeedItemPyrehearts",
					},
				},
				-- Sir Marsh
				{
					Archetype = "PlayerTrail",
					Gender = "male",
					SurName = "Worm_Honorific_Male",
					FirstName = "Rivals_Pyrehearts_Extra_02",
					LastName = "Rivals_Pyrehearts_Extra_02",
					TooltipIds = { FullName = "Rivals_Pyrehearts_Extra_02_Tooltip", ShortName = "Rivals_Pyrehearts_Extra_02_Tooltip" },
					Traits = { },
					SmallPortrait = "Wyrm_Pyrehearts_Small",
					SpecialScorePose = "PlayerTrailScorePoseAlt",

					PlayerAttributeAuraModifier = 7,
					PlayerAttributeRespawnModifier = 9,
					PlayerAttributeSpeedModifier = 6,
					Height = 0.7,

					MatchSkills =
					{
						[1] = { "KillsRespawnFriends100" },
						[2] = { "TrailExplosion" },
						[3] = { "WeaponRechargeStamina" },
					},

					MatchItems =
					{
						[2] = "SpeedItemPyrehearts",
					},
				},
				-- Lady Shelley
				{
					Archetype = "PlayerTrail",
					Gender = "female",
					Traits = { },
					Tags = { "Test_Trail" },
					SurName = "Worm_Honorific_Female",
					FirstName = "Rivals_Pyrehearts_Extra_03",
					LastName = "Rivals_Pyrehearts_Extra_03",
					TooltipIds = { FullName = "Rivals_Pyrehearts_Extra_03_Tooltip", ShortName = "Rivals_Pyrehearts_Extra_03_Tooltip" },
					SmallPortrait = "Wyrm_Pyrehearts_Small",
					SpecialScorePose = "PlayerTrailScorePoseAlt",


					PlayerAttributeAuraModifier = 6,
					PlayerAttributeRespawnModifier = 9,
					PlayerAttributeSpeedModifier = 4,
					MatchScale = 0.85,
					Height = 0.8,

					MatchSkills =
					{
						[1] = { "KillsRespawnFriends100" },
						[2] = { "TrailExplosion" },
						[3] = { "WeaponRechargeStamina" },
					},

					MatchItems =
					{
						--[2] = "SpeedItemPyrehearts",
					},
				},
				-- Sir Frothmore
				{
					Archetype = "PlayerTrail",
					Gender = "male",
					Traits = { },
					Tags = { "Test_Trail" },
					SurName = "Worm_Honorific_Male",
					FirstName = "Rivals_Pyrehearts_Extra_04",
					LastName = "Rivals_Pyrehearts_Extra_04",
					TooltipIds = { FullName = "Rivals_Pyrehearts_Extra_04_Tooltip", ShortName = "Rivals_Pyrehearts_Extra_04_Tooltip" },
					SmallPortrait = "Wyrm_Pyrehearts_Small",
					SpecialScorePose = "PlayerTrailScorePoseAlt",


					PlayerAttributeAuraModifier = 8,
					PlayerAttributeRespawnModifier = 9,
					PlayerAttributeSpeedModifier = 4,
					MatchScale = 0.85,
					Height = 0.9,

					MatchSkills =
					{
						[1] = { "KillsRespawnFriends100" },
						[2] = { "TrailExplosion" },
						[3] = { "WeaponRechargeStamina" },
					},

					MatchItems =
					{
						--[2] = "SpeedItemPyrehearts",
					},
				},

				-- Sir Deluge (replaces Gilman)
				{
					Archetype = "PlayerTrail",
					Tags = { "Story_Pyreheart" },
					Gender = "male",
					SurName = "Worm_Honorific_Male",
					FirstName = "Rivals_Captain09_FirstName",
					LastName = "Rivals_Captain09_FirstName",
					TooltipIds = { FirstName = "Rivals_Captain09_LongName", ShortName = "Rivals_Captain09_LongName", FullName = "Rivals_Captain09_LongName" },
					Honorific = "Worm_Honorific_Superior",
					StartingTrait = "Pyreheart01",
					Backstory = "Rivals_Pyreheart_Backstory_Initial",
					RevealedBackstories = { "Rivals_Pyreheart_Backstory_Complete", },
					Past = "Rivals_Pyreheart_Past",
					Reason = "Rivals_Pyreheart_Reason",
					Reputation = "Pyreheart_Reputation_01",
					YearsExiled = 3,
					Birthday = { Month = "mJanuary", Date = 16 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop3",
					TextSpeedMultiplier = 0.9,
					Portrait = "WyrmDeluge01_Robed",
					RobedPortrait = "WyrmDeluge01_Robed",
					EventPositionOffsetRobed = -100,
					EventPositionOffsetMasked = -100,
					SmallPortrait = "WyrmDeluge01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Deluge/",
					AscensionSendOffVO = "/VO/Justice_999",
					MusicTheme = "/Music/MatchMusic8_MC",
					MusicStemName = "Drums",
					MusicStemValue = 1,
					AscensionSuccessEvent = "AscensionSuccess_Pyreheart",
					AscensionFailureEvent = "AscensionFailure_Pyreheart",
					PostAscensionNewJunctionEvents = { "OpenStructure_RivalAscended_Pyreheart_01" },
					AscendedTooltip = "AscendedRival_Pyreheart",

					EpilogueRemainedEvent = "Epilogue_Pyreheart_Remained_01",
					EpilogueAscendedEvent = "Epilogue_Pyreheart_Ascended_01",
					EpilogueAscendedPlanAEvent = "Epilogue_Pyreheart_AscendedPlanA_01",
					EpilogueAscendedPlanBEvent = "Epilogue_Pyreheart_AscendedPlanB_01",
					EpilogueAscendedPlanCEvent = "Epilogue_Pyreheart_AscendedPlanC_01",
					EpilogueAscendedConclusionEvent = "Epilogue_Pyreheart_AscendedConclusion_01",
					EpilogueRivalCharTag = "Story_Knight",
					EpilogueRemainedWithRivalEvent = "Epilogue_Pyreheart_Remained_WithRival_01",
					EpilogueRemainedConclusionEvent = "Epilogue_Pyreheart_RemainedConclusion_01",

					DraftedSpeech = "/VO/Match_106",
					EventEnterSound = "/SFX/World Sounds/WyrmEnter",
					EventExitSound = "/SFX/World Sounds/WyrmEnter",
					UseVictoryVO = true,
					ScoringSpeechLines = { "/VO/Match_470", "/VO/Match_471", "/VO/Match_472", },
					ThrowScoringSpeechLines = { "/VO/Match_881", "/VO/Match_882", "/VO/Match_883" },
					BanishedSpeechLines = { "/VO/Match_473", "/VO/Match_474", "/VO/Match_475", "/VO/Match_476" },
					SpecialScorePose = "PlayerTrailScorePoseAlt",

					PlayerAttributeAuraModifier = 10,
					PlayerAttributeRespawnModifier = 5,
					PlayerAttributeSpeedModifier = 3,

					MatchScale = 0.78,

					MatchSkills =
					{
						[1] = { "KillsRespawnFriends100" },
						[2] = { "TrailExplosion" },
						[3] = { "WeaponRechargeStamina" },
					},

					MatchItems =
					{
						[2] = "OnDeathExplosionItemPyrehearts",
					},

					Height = 1,
				},

			}
		},
		[7] =
		{
			-- Essence Team
			Name = "TeamName07",
			GoalDecalSigil = "EssenceGrill01",
			MeteorColorGrade = "Team07",
			MaskHue = 160, MaskSaturationAddition = -10, MaskValueAddition = -50,
			MaskHue2 = 270, MaskSaturationAddition2 = -20, MaskValueAddition2 = 20,
			PostMatchSigil = "SigilEssence",
			RosterScreenSigil = "GUI\\Sigils\\Essence_01_UI",
			LargeSigil = "Tilesets\\Arena\\Essence_01",
			PyreIcon = "GUI\\Icons\\Pyre\\PyreIcon_Essence",
			IntroVO = "/VO/Match_155", VictoryVO = "/VO/Match_156",
			AscensionVictoryVO = "/VO/Match_565",
			MusicTheme = "/Music/EssenceTheme_MC",
			AscensionMusicTheme = "/Music/AscensionMatchMusicEssence_MC",
			AscensionMatchStartEvents = { "Ascension_Beginning_Essence_01" },
			FlyingEvents = { "FlyingWagon_Essence_01", "FlyingWagon_Essence_02" },
			StarPickEvents = { "OpenStructure_Onward_StarPicked_Essence_01" },
			RivalryCharTag = "Story_Vamp",
			RivalryPreMatchEvents = { "OpenStructure_ReachedGoal_Rivalry_Essence_01", "OpenStructure_ReachedGoal_Rivalry_Essence_02" },
			RivalryMatchStartEvents = { "OpenStructure_Match_Beginning_Rivalry_Essence_01", "OpenStructure_Match_Beginning_Rivalry_Essence_02" },
			RivalryMatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_Rivalry_Essence_01" },
			RivalryMatchVictoryEvents = { "OpenStructure_Match_TheyLost_Rivalry_Essence_01" },
			RivalryMatchDefeatEvents = { "OpenStructure_Match_TheyWon_Rivalry_Essence_01" },
			RivalryAscensionConclusionEventsPlayerWon = { "Ascension_Conclusion_PlayerWon_Rivalry_Essence" },
			RivalryAscensionConclusionEventsPlayerLost = { "Ascension_Conclusion_PlayerLost_Rivalry_Essence" },
			RivalryEndedMatchStartEvents = { "OpenStructure_Match_Beginning_RivalryEnded_Essence_01" },
			-- PreMatchEvents = { "OpenStructure_ReachedGoal_01" },
			-- MatchStartEvents = { "OpenStructure_Match_Beginning_02" },
			-- MatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_01" },
			LastMatchBigWinPhrases = { "TeamMemory_BigWin_Essence_01" },
			LastMatchCloseWinPhrases = { "TeamMemory_CloseWin_Essence_01" },
			LastMatchSolidWinPhrases = { "TeamMemory_SolidWin_Essence_01" },
			LastMatchBigLossPhrases = { "TeamMemory_BigLoss_Essence_01" },
			LastMatchCloseLossPhrases = { "TeamMemory_CloseLoss_Essence_01" },
			LastMatchSolidLossPhrases = { "TeamMemory_SolidLoss_Essence_01" },
			LastMatchNoMemoryPhrases = { "TeamMemory_NoMemory_Essence_01" },
			GenericReputation = "TeamName07_GenericRep_01",
			GuideBookChapter = 8,
			GuideBookEntry = 7,
			WinsSinceLastAscensionAttempt = 36,
			SimulatedMatchPower = 8,

			ForcedDraftPicks =
			{
				[1] = { 1, 2, 3 },
				[2] = { 1, 2, 3 },
				[3] = { 1, 2, 3 },
				[4] = { 1, 4, 5 },
				[5] = { 1, 4, 5 },
			},

			TeamAVersusLineNames = { "/VO/Match_1213" },
			TeamBVersusLineNames = { "/VO/Match_1214" },
			TeamScoresFirstSpeechLines =
			{
				-- The Essence are the first to strike their adversary's flame!
				"/VO/Match_1092",
				-- Glory first to the Essence!
				"/VO/Match_1093",
				-- The Essence make their mark upon the flame!
				"/VO/Match_1094",
			},
			TeamScoredOnFirstSpeechLines =
			{
				-- The Essence Pyre is the first to falter.
				"/VO/Match_1095",
				-- The Orb bathes first in the Essence flame!
				"/VO/Match_1096",
			},
			TeamTakesLeadSpeechLines =
			{
				-- The Essence Pyre now burns relatively brighter.
				"/VO/Match_1097",
				-- The Essence seem to want their freedom more.
				"/VO/Match_1098",
				-- The Essence are now favored to prevail.
				"/VO/Match_1099",
				-- Shall the Essence press their luck, perhaps?
				"/VO/Match_1100",
				-- Best not give in to pride just yet, Essence.
				"/VO/Match_1101",
				-- How very fortunate for the Essence.
				"/VO/Match_1102",
			},
			TeamLosesLeadSpeechLines =
			{
				-- The Essence seem to be falling behind.
				"/VO/Match_1103",
				-- The Essence adversaries gained an edge.
				"/VO/Match_1104",
				-- A show of strength from the Essence rivals.
				"/VO/Match_1105",
			},
			TeamFullWipeLines =
			{
				-- All of the Essence, gone.
				"/VO/Match_1106",
				-- The Essence, banished to the last.
				"/VO/Match_1107",
				-- Unfortunate for the Essence.
				"/VO/Match_1108",
				-- Quite a sour turn for the Essence.
				"/VO/Match_1109",
				-- How very sad for the Essence.
				"/VO/Match_1110",
				-- No sign of the Essence for the time!
				"/VO/Match_1111",
			},
			TeamPyreExtinguishedLines =
			{
				-- The Essence flame is out!
				"/VO/Match_1112",
				-- The Essence flames, extinguished!
				"/VO/Match_1113",
			},
			TeamReadyLines =
			{
				-- The Essence, stand prepared.
				"/VO/Match_1114",
				-- The Essence, stand ready.
				"/VO/Match_1115",
			},

			TeamBench =
			{
				-- Tamitha Theyn / Harp
				{
					Archetype = "PlayerFlying",
					Tags = { "Story_Essence" },
					Gender = "female",
					FirstName = "Rivals_Captain07_FirstName",
					LastName = "Rivals_Captain07_LastName",
					LongName = "Rivals_Captain07_LongName",
					TooltipIds = { FirstName = "Rivals_Captain07_LongName", ShortName = "Rivals_Captain07_LongName", FullName = "Rivals_Captain07_LongName", LastName = "Chars_Vamp_LastName_Tooltip" },
					StartingTrait = "Essence01",
					Backstory = "Rivals_Essence_Backstory_Initial",
					RevealedBackstories = { "Rivals_Essence_Backstory_Complete", },
					Past = "Rivals_Captain07_Past",
					Reason = "Rivals_Captain07_Reason",
					Reputation = "Essence_Reputation_01",
					YearsExiled = 7,
					Birthday = { Month = "mFebruary", Date = 1 },
					Portrait = "HarpTamitha01_Robed",
					RobedPortrait = "HarpTamitha01_Robed",
					SmallPortrait = "HarpTamitha01_Small",
					EventPositionOffset = -50,
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Tamitha/",
					AscensionSendOffVO = "/VO/Justice_1000",
					MusicTheme = "/Music/PamithaTheme_MC",
					MusicStemName = "Drums",
					MusicStemValue = 2,
					EpilogueMusicTheme = "/Music/EssenceTheme_MC",
					EpilogueMusicStemName = "Guitars",
					EpilogueMusicStemValue = 1,
					EventEnterSound = "/SFX/World Sounds/PickUpFlyAwayLEFT",
					EventExitSound = "/SFX/World Sounds/PickUpFlyAwayRIGHT",
					AscensionSuccessEvent = "AscensionSuccess_Essence",
					AscensionFailureEvent = "AscensionFailure_Essence",
					PostAscensionNewJunctionEvents = { "OpenStructure_RivalAscended_Essence_01" },
					AscendedTooltip = "AscendedRival_Essence",

					EpilogueRivalCharTag = "Story_Vamp",
					EpilogueAscendedEvent = "Epilogue_Essence_Ascended_01",
					EpilogueAscendedPlanAEvent = "Epilogue_Essence_AscendedPlanA_01",
					EpilogueAscendedPlanBEvent = "Epilogue_Essence_AscendedPlanB_01",
					EpilogueAscendedPlanCEvent = "Epilogue_Essence_AscendedPlanC_01",
					EpilogueAscendedWithRivalEvent = "Epilogue_Essence_Ascended_WithRival_01",
					EpilogueAscendedWithoutRivalEvent = "Epilogue_Essence_Ascended_WithoutRival_01",
					EpilogueAscendedConclusionEvent = "Epilogue_Essence_AscendedConclusion_01",
					EpilogueRemainedEvent = "Epilogue_Essence_Remained_01",
					EpilogueRemainedPlanAEvent = "Epilogue_Essence_RemainedPlanA_01",
					EpilogueRemainedPlanBEvent = "Epilogue_Essence_RemainedPlanB_01",
					EpilogueRemainedPlanCEvent = "Epilogue_Essence_RemainedPlanC_01",
					EpilogueRemainedWithRivalEvent = "Epilogue_Essence_Remained_WithRival_01",
					EpilogueRemainedWithoutRivalEvent = "Epilogue_Essence_Remained_WithoutRival_01",
					EpilogueRemainedConclusionEvent = "Epilogue_Essence_RemainedConclusion_01",

					DraftedSpeech = "/VO/Match_107",
					UseVictoryVO = true,
					ScoringSpeechLines = { "/VO/Match_477", "/VO/Match_478", "/VO/Match_479", },
					ThrowScoringSpeechLines = { "/VO/Match_884", "/VO/Match_885", "/VO/Match_886" },
					BanishedSpeechLines = { "/VO/Match_480", "/VO/Match_481", "/VO/Match_482", "/VO/Match_483" },
					SpecialScorePose = "PlayerFlyingScorePoseAlt",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = 7,
					PlayerAttributeSpeedModifier = -2,

					MatchSkills =
					{
						[2] = { "AirSpeed", },
						[3] = { "OnKillBuffSpeed", "RespawnBuff" },
						[4] = { "PlusStatsSkill" },
					},
					MatchItems =
					{
						[2] = "PyreHealthItemTamitha",
					},
				},
				-- Shikara
				{
					Archetype = "PlayerFlying",
					FirstName = "Rivals_Essence_Extra_01",
					Gender = "female",
					Traits = { },
					Tags = { "Test_Flying" },
					SmallPortrait = "Harp_Essence_Small",
					SpecialScorePose = "PlayerFlyingScorePoseAlt",
					Height = 6.49,
					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -2,
					PlayerAttributeSpeedModifier = -1,

					MatchSkills =
					{
						[2] = { "AirSpeed", },
						[3] = { "OnKillBuffSpeed", "RespawnBuff" },
						[4] = { "PlusStatsSkill" },
					},
					MatchItems =
					{
						[2] = "CarrySpeedItemEssence",
					},
				},
				-- Umani
				{
					Archetype = "PlayerFlying",
					FirstName = "Rivals_Essence_Extra_02",
					Gender = "female",
					Traits = { },
					SmallPortrait = "Harp_Essence_Small",
					SpecialScorePose = "PlayerFlyingScorePoseAlt",
					Height = 6.48,
					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -2,
					PlayerAttributeSpeedModifier = 0,

					MatchSkills =
					{
						[2] = { "AirSpeed", },
						[3] = { "OnKillBuffSpeed", "RespawnBuff" },
						[4] = { "PlusStatsSkill" },
					},
					MatchItems =
					{
						[2] = "CarrySpeedItemEssence",
					},
				},
				-- Shikara (more powerful)
				{
					Archetype = "PlayerFlying",
					FirstName = "Rivals_Essence_Extra_03",
					Gender = "female",
					Traits = { },
					SmallPortrait = "Harp_Essence_Small",
					SpecialScorePose = "PlayerFlyingScorePoseAlt",
					Height = 6.47,
					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = 3,
					PlayerAttributeSpeedModifier = 3,

					MatchSkills =
					{
						[2] = { "AirSpeed", },
						[3] = { "OnKillBuffSpeed", "RespawnBuff" },
						[4] = { "PlusStatsSkill" },
					},
					MatchItems =
					{
						[2] = "CarrySpeedItemEssence",
					},
				},
				-- Umani (more powerful)
				{
					Archetype = "PlayerFlying",
					FirstName = "Rivals_Essence_Extra_04",
					Gender = "female",
					Traits = { },
					SmallPortrait = "Harp_Essence_Small",
					SpecialScorePose = "PlayerFlyingScorePoseAlt",
					Height = 6.46,
					PlayerAttributeAuraModifier = 10,
					PlayerAttributeRespawnModifier = 1,
					PlayerAttributeSpeedModifier = 4,
					MatchScale = 1.1,

					MatchSkills =
					{
						[2] = { "AirSpeed", },
						[3] = { "OnKillBuffSpeed", "RespawnBuff" },
						[4] = { "PlusStatsSkill" },
					},
					MatchItems =
					{
						[2] = "CarrySpeedItemEssence",
					},
				},
				-- Filana
				{
					Archetype = "PlayerFlying",
					FirstName = "Rivals_Essence_Extra_05",
					Gender = "female",
					Traits = { },
					SmallPortrait = "Harp_Essence_Small",
					SpecialScorePose = "PlayerFlyingScorePoseAlt",
					Height = 6.45,
					PlayerAttributeAuraModifier = 10,
					PlayerAttributeRespawnModifier = -3,
					PlayerAttributeSpeedModifier = 4,
					MatchScale = 1.1,

					MatchSkills =
				{
						[2] = { "AirSpeed", },
						[3] = { "OnKillBuffSpeed", "RespawnBuff" },
						[4] = { "PlusStatsSkill" },
					},
					MatchItems =
					{
						[2] = "CarrySpeedItemEssence",
					},
				},
			}
		},
		[8] =
		{
			-- Chastity Team
			Name = "TeamName08",
			GoalDecalSigil = "ChastityGrill01",
			MeteorColorGrade = "Team08",
			MaskHue = 345, MaskSaturationAddition = -30, MaskValueAddition = 30,
			MaskHue2 = 40, MaskSaturationAddition2 = 20,  MaskValueAddition2 = 30,
			PostMatchSigil = "SigilChastity",
			RosterScreenSigil = "GUI\\Sigils\\Chastity_01_UI",
			LargeSigil = "Tilesets\\Arena\\Chastity_01",
			PyreIcon = "GUI\\Icons\\Pyre\\PyreIcon_Chastity",
			IntroVO = "/VO/Match_157", VictoryVO = "/VO/Match_158",
			AscensionVictoryVO = "/VO/Match_566",
			MusicTheme = "/Music/MatchMusic3_MC",
			AscensionMusicTheme = "/Music/AscensionMatchMusicChastity_MC",
			AscensionMatchStartEvents = { "Ascension_Beginning_Chastity_01" },
			FlyingEvents = { "FlyingWagon_Chastity_01", "FlyingWagon_Chastity_02" },
			StarPickEvents = { "OpenStructure_Onward_StarPicked_Chastity_01" },
			RivalryCharTag = "Story_Doc",
			RivalryPreMatchEvents = { "OpenStructure_ReachedGoal_Rivalry_Chastity_01" },
			RivalryMatchStartEvents = { "OpenStructure_Match_Beginning_Rivalry_Chastity_01" },
			RivalryMatchDraftScreenOpenEvents = { "OpenStructure_Match_DraftScreenOpen_Rivalry_Chastity_01" },
			RivalryMatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_Rivalry_Chastity_01" },
			RivalryMatchVictoryEvents = { "OpenStructure_Match_TheyLost_Rivalry_Chastity_01" },
			RivalryMatchDefeatEvents = { "OpenStructure_Match_TheyWon_Rivalry_Chastity_01" },
			-- PreMatchEvents = { "OpenStructure_ReachedGoal_01" },
			-- MatchStartEvents = { "OpenStructure_Match_Beginning_02" },
			-- MatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_01" },
			LastMatchBigWinPhrases = { "TeamMemory_BigWin_Chastity_01" },
			LastMatchCloseWinPhrases = { "TeamMemory_CloseWin_Chastity_01" },
			LastMatchSolidWinPhrases = { "TeamMemory_SolidWin_Chastity_01" },
			LastMatchBigLossPhrases = { "TeamMemory_BigLoss_Chastity_01" },
			LastMatchCloseLossPhrases = { "TeamMemory_CloseLoss_Chastity_01" },
			LastMatchSolidLossPhrases = { "TeamMemory_SolidLoss_Chastity_01" },
			LastMatchNoMemoryPhrases = { "TeamMemory_NoMemory_Chastity_01" },
			GenericReputation = "TeamName08_GenericRep_01",
			GuideBookChapter = 8,
			GuideBookEntry = 8,
			WinsSinceLastAscensionAttempt = 34,
			SimulatedMatchPower = 5,

			ForcedDraftPicks =
			{
				[1] = { 1, 2, 3 },
				[2] = { 1, 4, 5 },
				[3] = { 1 },
				[4] = { 1 },
				[5] = { 1 },
			},

			TeamAVersusLineNames = { "/VO/Match_1215" },
			TeamBVersusLineNames = { "/VO/Match_1216" },
			TeamScoresFirstSpeechLines =
			{
				-- The Chastity are first to strike their adversary's flame!
				"/VO/Match_1116",
				-- Glory first to the Chastity!
				"/VO/Match_1117",
				-- The Chastity have made their mark upon the flame!
				"/VO/Match_1118",
			},
			TeamScoredOnFirstSpeechLines =
			{
				-- The Chastity's Pyre is the first to falter.
				"/VO/Match_1119",
				-- The Orb bathes first in the Chastity's flame!
				"/VO/Match_1120",
			},
			TeamTakesLeadSpeechLines =
			{
				-- The Chastity's Pyre now burns relatively brighter.
				"/VO/Match_1121",
				-- The Chastity seem to want their freedom more.
				"/VO/Match_1122",
				-- The Chastity are now favored to prevail.
				"/VO/Match_1123",
				-- Shall the Chastity press their luck, perhaps?
				"/VO/Match_1124",
				-- Best not give in to pride just yet, Chastity.
				"/VO/Match_1125",
				-- How very fortunate for the Chastity.
				"/VO/Match_1126",
			},
			TeamLosesLeadSpeechLines =
			{
				-- The Chastity seem to be falling behind.
				"/VO/Match_1127",
				-- The Chastity's adversaries gained an edge.
				"/VO/Match_1128",
				-- A show of strength from the Chastity's rivals.
				"/VO/Match_1129",
			},
			TeamFullWipeLines =
			{
				-- All of the Chastity, gone.
				"/VO/Match_1130",
				-- The Chastity, banished to the last.
				"/VO/Match_1131",
				-- Unfortunate for the Chastity.
				"/VO/Match_1132",
				-- A rude predicament for the Chastity.
				"/VO/Match_1133",
				-- How very sad for the Chastity.
				"/VO/Match_1134",
				-- No sign of the Chastity for now!
				"/VO/Match_1135",
			},
			TeamPyreExtinguishedLines =
			{
				-- The Chastity's flame is out!
				"/VO/Match_1136",
				-- The Chastity's flames, extinguished!
				"/VO/Match_1137",
			},
			TeamReadyLines =
			{
				-- The Chastity, stand prepared.
				"/VO/Match_1138",
				-- The Chastity, stand ready.
				"/VO/Match_1139",
			},

			TeamBench =
			{
				-- Manley Tinderstauf / Sap
				{
					Archetype = "PlayerTree",
					Tags = { "Story_Chastity" },
					Gender = "male",
					FirstName = "Rivals_Captain05_FirstName",
					FirstInitial = "Rivals_Captain05_FirstInitial",
					MiddleName = "Rivals_Captain05_MiddleName",
					MiddleInitial = "Rivals_Captain05_MiddleInitial",
					LastName = "Rivals_Captain05_LastName",
					SaplingName = "RivalChastity_SaplingName",
					TooltipIds = { FirstName = "Rivals_Captain05_LongName", FullName = "Rivals_Captain05_LongName", ShortName = "Rivals_Captain05_LongName", LastName = "Rivals_Captain05_LongName", LongName = "Rivals_Captain05_LongName", SaplingName = "RivalChastity_SaplingName" },
					StartingTrait = "Chastity01",
					Backstory = "Rivals_Chastity_Backstory_Initial",
					RevealedBackstories = { "Rivals_Chastity_Backstory_Complete", },
					Past = "Rivals_Chastity_Past",
					Reason = "Rivals_Chastity_Reason",
					Reputation = "Chastity_Reputation_01",
					YearsExiled = 20,
					Birthday = { Month = "mJune", Date = 20 },
					Portrait = "SapManley01_Robed",
					RobedPortrait = "SapManley01_Robed",
					SmallPortrait = "SapManley01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Manley/",
					AscensionSendOffVO = "/VO/Justice_1001",
					MusicTheme = "/Music/MatchMusic3_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,
					AscensionSuccessEvent = "AscensionSuccess_Chastity",
					AscensionFailureEvent = "AscensionFailure_Chastity",
					PostAscensionNewJunctionEvents = { "OpenStructure_RivalAscended_Chastity_01" },
					AscendedTooltip = "AscendedRival_Chastity",

					EpilogueAscendedEvent = "Epilogue_Chastity_Ascended_01",
					EpilogueAscendedPlanAEvent = "Epilogue_Chastity_AscendedPlanA_01",
					EpilogueAscendedPlanBEvent = "Epilogue_Chastity_AscendedPlanB_01",
					EpilogueAscendedPlanCEvent = "Epilogue_Chastity_AscendedPlanC_01",
					EpilogueAscendedConclusionEvent = "Epilogue_Chastity_AscendedConclusion_01",
					EpilogueRemainedEvent = "Epilogue_Chastity_Remained_01",

					DraftedSpeech = "/VO/Match_108",
					EventEnterSound = "/SFX/World Sounds/SapEnter",
					EventExitSound = "/SFX/World Sounds/SapEnter",
					UseVictoryVO = true,
					ScoringSpeechLines = { "/VO/Match_484", "/VO/Match_485", "/VO/Match_486", },
					ThrowScoringSpeechLines = { "/VO/Match_887", "/VO/Match_888", "/VO/Match_889" },
					BanishedSpeechLines = { "/VO/Match_487", "/VO/Match_488", "/VO/Match_489", "/VO/Match_490" },
					--SpecialScorePose = "PlayerTreeScorePoseAlt",

					PlayerAttributeRespawn = 15,
					PlayerAttributeSpeedModifier = 2,
					MatchSkills =
					{
						[2] = { "SpawnDefenderUnit", "DefenderAura" },
						[3] = { "TauntSaplingExplode" },
					},
					MatchItems =
					{
						[2] = "TossChargeTimeItemChastity",
					},

				},
				-- Peyford
				{
					Archetype = "PlayerMedium",
					Gender = "male",
					FirstName = "Rivals_Chastity_Extra_01",
					Traits = { },
					SpecialScorePose = "PlayerMediumScorePoseAlt",
					SmallPortrait = "Nomad_Chastity_Small",

					PlayerAttributeRespawnModifier = -4,
					PlayerAttributeSpeedModifier = -2,

					MatchSkills =
					{
						[2] = { "StaminaSkill" },
						[3] = { "TeamStaminaRechargeSkill", "TeamBallSkill" },
					},

					MatchItems =
					{
						[2] = "GoalHealItemChastity",
					},
				},
				-- Xaxiana
				{
					Archetype = "PlayerFlying",
					Gender = "female",
					FirstName = "Rivals_Chastity_Extra_02",
					Traits = { },
					SpecialScorePose = "PlayerFlyingScorePoseAlt",
					SmallPortrait = "Harp_Chastity_Small",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -5,
					PlayerAttributeSpeedModifier = -3,

					MatchSkills =
					{
						[2] = { "AirSpeed" },
						[3] = { "DashCooldown" },
					},
					MatchItems =
					{
						[2] = "GoalHealItemChastity",
					},
				},
				-- Avrec
				{
					Archetype = "PlayerMediumAlt",
					Gender = "male",
					FirstName = "Rivals_Chastity_Extra_03",
					Traits = { },
					SpecialScorePose = "PlayerMediumAltScorePoseAlt",
					SmallPortrait = "Nomad_Chastity_Small",

					PlayerAttributeAuraModifier = 3,
					PlayerAttributeRespawnModifier = 3,
					PlayerAttributeSpeedModifier = 3,

					MatchSkills =
					{
						[2] = { "MobilityChargeTime" },
						[3] = { "JumpDistance" },
					},

					MatchItems =
					{
						[2] = "GoalHealItemChastity",
					},
				},
				-- Sir Tidemont
				{
					Archetype = "PlayerTrail",
					Gender = "male",
					SurName = "Worm_Honorific_Male",
					FirstName = "Rivals_Chastity_Extra_04",
					LastName = "Rivals_Chastity_Extra_04",
					TooltipIds = { FullName = "Rivals_Chastity_Extra_04_Tooltip", ShortName = "Rivals_Chastity_Extra_04_Tooltip" },
					Traits = { },
					SpecialScorePose = "PlayerTrailScorePoseAlt",
					SmallPortrait = "Wyrm_Chastity_Small",

					PlayerAttributeAuraModifier = 2,
					PlayerAttributeRespawnModifier = 2,
					PlayerAttributeSpeedModifier = 2,

					MatchSkills =
					{
						[2] = { "KillsRespawnFriends100" },
						[3] = { "TrailExplosion" },
						[4] = { "WeaponRechargeStamina" },
					},

					MatchItems =
					{
						[2] = "GoalHealItemChastity",
					},
				},
			}
		},
		[9] =
		{
			-- Tempers Team
			Name = "TeamName09",
			GoalDecalSigil = "TempersGrill01",
			MeteorColorGrade = "Team09",
			MaskHue = 80, MaskSaturationAddition = 0, MaskValueAddition = -60,
			MaskHue2 = 190, MaskSaturationAddition2 = 10, MaskValueAddition2 = -50,
			PostMatchSigil = "SigilTempers",
			RosterScreenSigil = "GUI\\Sigils\\Tempers_01_UI",
			LargeSigil = "Tilesets\\Arena\\Tempers_01",
			PyreIcon = "GUI\\Icons\\Pyre\\PyreIcon_Tempers",
			IntroVO = "/VO/Match_159", VictoryVO = "/VO/Match_160",
			AscensionVictoryVO = "/VO/Match_567",
			MusicTheme = "/Music/MatchMusic4_MC",
			AscensionMusicTheme = "/Music/AscensionMatchMusicTempers_MC",
			FlyingEvents = { "FlyingWagon_Tempers_01", "FlyingWagon_Tempers_02" },
			StarPickEvents = { "OpenStructure_Onward_StarPicked_Tempers_01" },
			RivalryCharTag = "Story_Badass",
			RivalryPreMatchEvents = { "OpenStructure_ReachedGoal_Rivalry_Tempers_01", "OpenStructure_ReachedGoal_Rivalry_Tempers_02" },
			RivalryMatchStartEvents = { "OpenStructure_Match_Beginning_Rivalry_Tempers_01", "OpenStructure_Match_Beginning_Rivalry_Tempers_02" },
			RivalryMatchDraftStartEvents = { "OpenStructure_Match_DraftStart_Rivalry_Tempers_01" },
			RivalryMatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_Rivalry_Tempers_01" },
			RivalryMatchVictoryEvents = { "OpenStructure_Match_TheyLost_Rivalry_Tempers_01" },
			RivalryMatchDefeatEvents = { "OpenStructure_Match_TheyWon_Rivalry_Tempers_01" },
			RivalryMatchConclusionEvents = { "OpenStructure_Match_Conclusion_Rivalry_Tempers_01" },
			RivalryEndedMatchStartEvents = { "OpenStructure_Match_Beginning_RivalryEnded_Tempers_01" },
			-- PreMatchEvents = { "OpenStructure_ReachedGoal_01" },
			-- MatchStartEvents = { "OpenStructure_Match_Beginning_02" },
			-- MatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_01" },
			LastMatchBigWinPhrases = { "TeamMemory_BigWin_Tempers_01" },
			LastMatchCloseWinPhrases = { "TeamMemory_CloseWin_Tempers_01" },
			LastMatchSolidWinPhrases = { "TeamMemory_SolidWin_Tempers_01" },
			LastMatchBigLossPhrases = { "TeamMemory_BigLoss_Tempers_01" },
			LastMatchCloseLossPhrases = { "TeamMemory_CloseLoss_Tempers_01" },
			LastMatchSolidLossPhrases = { "TeamMemory_SolidLoss_Tempers_01" },
			LastMatchNoMemoryPhrases = { "TeamMemory_NoMemory_Tempers_01" },
			GenericReputation = "TeamName09_GenericRep_01",
			GuideBookChapter = 8,
			GuideBookEntry = 9,
			WinsSinceLastAscensionAttempt = 99,
			SimulatedMatchPower = 10,

			ForcedDraftPicks =
			{
				[1] = { 1, 2, 3 },
				[2] = { 1 },
				[3] = { 1 },
				[4] = { 1 },
				[5] = { 1 },
			},

			TeamAVersusLineNames = { "/VO/Match_1217" },
			TeamBVersusLineNames = { "/VO/Match_1218" },
			TeamScoresFirstSpeechLines =
			{
				-- The Tempers are the first to strike their adversary's flame!
				"/VO/Match_1140",
				-- Glory first to the Tempers!
				"/VO/Match_1141",
				-- The Tempers make their mark upon the flame!
				"/VO/Match_1142",
			},
			TeamScoredOnFirstSpeechLines =
			{
				-- The Tempers' Pyre is the first to falter.
				"/VO/Match_1143",
				-- The Orb bathes first in the Tempers' flame!
				"/VO/Match_1144",
			},
			TeamTakesLeadSpeechLines =
			{
				-- The Tempers' Pyre now burns relatively brighter.
				"/VO/Match_1145",
				-- The Tempers seem to want their freedom more.
				"/VO/Match_1146",
				-- The Tempers are now favored to prevail.
				"/VO/Match_1147",
				-- Shall the Tempers press their luck, perhaps?
				"/VO/Match_1148",
				-- Best not give in to pride just yet, Tempers.
				"/VO/Match_1149",
				-- How very fortunate for the Tempers.
				"/VO/Match_1150",
			},
			TeamLosesLeadSpeechLines =
			{
				-- The Tempers seem to be falling behind.
				"/VO/Match_1151",
				-- The Tempers' adversaries gained an edge.
				"/VO/Match_1152",
				-- A show of strength from the Tempers' rivals.
				"/VO/Match_1153",
			},
			TeamFullWipeLines =
			{
				-- All of the Tempers, gone.
				"/VO/Match_1154",
				-- Tempers, banished to the last.
				"/VO/Match_1155",
				-- Unfortunate for the Tempers.
				"/VO/Match_1156",
				-- A rude predicament for the Tempers.
				"/VO/Match_1157",
				-- How very sad for the Tempers.
				"/VO/Match_1158",
				-- No sign of the Tempers for the time!
				"/VO/Match_1159",
			},
			TeamPyreExtinguishedLines =
			{
				-- The Tempers' flame is out!
				"/VO/Match_1160",
				-- The Tempers' flames, extinguished!
				"/VO/Match_1161",
			},
			TeamReadyLines =
			{
				-- Tempers, stand prepared.
				"/VO/Match_1162",
				-- Tempers, stand ready.
				"/VO/Match_1163",
			},

			TeamBench =
			{
				-- Ignarius / Demon
				{
					Archetype = "PlayerLarge",
					Tags = { "Story_Temper" },
					Gender = "male",
					FirstName = "Rivals_Captain04_FirstName",
					NickName = "Rivals_Captain04_NickName",
					StartingTrait = "Temper01",
					Backstory = "Rivals_Temper_Backstory_Initial",
					RevealedBackstories = { "Rivals_Temper_Backstory_Complete", },
					Past = "Rivals_Temper_Past",
					Reason = "Rivals_Temper_Reason",
					Reputation = "Temper_Reputation_01",
					YearsExiled = 14,
					Birthday = { Month = "mJune", Date = 2 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop4",
					PostAscensionNewJunctionEvents = { "OpenStructure_RivalAscended_Temper_01" },
					Traits = { },
					Portrait = "DemonIgnarius01_Robed",
					RobedPortrait = "DemonIgnarius01_Robed",
					SmallPortrait = "DemonIgnarius01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Ignarius/",
					AscensionSendOffVO = "/VO/Justice_1002",
					MusicTheme = "/Music/MatchMusic4_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,
					AscensionSuccessEvent = "AscensionSuccess_Temper",
					AscensionFailureEvent = "AscensionFailure_Temper",
					AscendedTooltip = "AscendedRival_Temper",

					EpilogueRemainedEvent = "Epilogue_Temper_Remained_01",
					EpilogueAscendedEvent = "Epilogue_Temper_Ascended_01",
					EpilogueRivalCharTag = "Story_Badass",
					EpilogueWithRivalEvent = "Epilogue_Temper_WithRival_01",
					EpilogueWithoutRivalEvent = "Epilogue_Temper_WithoutRival_01",
					EpilogueConclusionEvent = "Epilogue_Temper_Conclusion_01",

					DraftedSpeech = "/VO/Match_109",
					EventEnterSound = "/SFX/World Sounds/DemonEnter",
					EventExitSound = "/SFX/World Sounds/DemonEnter",
					UseVictoryVO = true,
					ScoringSpeechLines = { "/VO/Match_491", "/VO/Match_492", "/VO/Match_493", },
					ThrowScoringSpeechLines = { "/VO/Match_890", "/VO/Match_891", "/VO/Match_892" },
					BanishedSpeechLines = { "/VO/Match_494", "/VO/Match_495", "/VO/Match_496", "/VO/Match_497" },
					SpecialScorePose = "PlayerIgnariusScorePose",

					PlayerAttributeAuraModifier = 4,
					PlayerAttributeRespawnModifier = 7,
					PlayerAttributeSpeedModifier = 0,

					MatchSkills =
					{

						[1] = { "DoubleRush", "EvadeStun" },
						[2] = { "TauntScoreSkill10" },
					},
					MatchItems =
					{
						[1] = "PyreHealthItemIgnarius",
					},
				},
				-- Ulmar
				{
					Archetype = "PlayerMonster",
					Gender = "female",
					FirstName = "Rivals_Tempers_Extra_01",
					Traits = { },
					SpecialScorePose = "PlayerMonsterScorePoseAlt",
					SmallPortrait = "Crone_Tempers_Small",

					PlayerAttributeAuraModifier = 2,
					PlayerAttributeRespawnModifier = -1,
					PlayerAttributeSpeedModifier = 1,

					MatchSkills =
					{
						[2] = { "WinningScoreSkill5", "MonsterSprintSkill" },
						[3] = { "ChargeMonsterSkill" },
					},
					MatchItems =
					{
						[1] = "PlusAuraItemTempers",
					},

				},
				-- Lady River
				{
					Archetype = "PlayerTrail",
					Gender = "female",
					SurName = "Worm_Honorific_Female",
					FirstName = "Rivals_Tempers_Extra_02",
					LastName = "Rivals_Tempers_Extra_02",
					TooltipIds = { FullName = "Rivals_Tempers_Extra_02_Tooltip", ShortName = "Rivals_Tempers_Extra_02_Tooltip" },
					Traits = { },
					SpecialScorePose = "PlayerTrailScorePoseAlt",
					SmallPortrait = "Wyrm_Tempers_Small",

					PlayerAttributeAuraModifier = 1,
					PlayerAttributeRespawnModifier = 2,
					PlayerAttributeSpeedModifier = 1,

					MatchSkills =
					{
						[2] = { "KillsRespawnFriends100", "TrailExplosion" },
						[3] = { "WeaponRechargeStamina" },
					},

					MatchItems =
					{
						[1] = "PlusAuraItemTempers",
					},

				},
				-- Yowlson
				{
					Archetype = "PlayerSmall",
					Gender = "male",
					FirstName = "Rivals_Tempers_Extra_03",
					Traits = { },
					SpecialScorePose = "PlayerSmallScorePoseAlt",
					SmallPortrait = "Cur_Tempers_Small",

					PlayerAttributeAuraModifier = 3,
					PlayerAttributeRespawnModifier = 1,
					PlayerAttributeSpeedModifier = 1,

					MatchSkills =
					{
						[2] = { "DoubleJump", "SprintSpeed" },
						[3] = { "SacrificeScoreSkill5" },
					},

					MatchItems =
					{
						[1] = "PlusAuraItemTempers",
					},
				},
			}
		},
		[10] =
		{
			-- Beyonders Team
			Name = "TeamName10",
			MeteorColorGrade = "Team10",
			GoalDecalSigil = "BeyondersGrill01",
			MaskHue = 70, MaskSaturationAddition = -40, MaskValueAddition = 80,
			MaskHue2 = 100, MaskSaturationAddition2 = -60, MaskValueAddition2 = 70,
			--MaskHue = 20, MaskSaturationAddition = -40, MaskValueAddition = -90,
			--MaskHue2 = 150, MaskSaturationAddition2 = -20, MaskValueAddition2 = -30,
			IntroVO = "/VO/Match_15", VictoryVO = "/VO/Justice_484",
			AscensionVictoryVO = "/VO/Match_569",
			MusicTheme = "/Music/MatchMusic2_MC",
			AscensionMusicTheme = "/Music/AscensionMatchMusic1_MC",
			PyreIcon = "GUI\\Icons\\Pyre\\PyreIcon_Beyonders",
			PostMatchSigil = "SigilBeyonders",
			RosterScreenSigil = "GUI\\Sigils\\Beyonders_01_UI",
			LargeSigil = "Tilesets\\Arena\\Beyonders_01",
			-- MatchStartEvents = { "OpenStructure_Match_Beginning_01" },
			-- MatchDraftEndEvents = { "OpenStructure_Match_DraftEnd_01" },
			LastMatchBigWinPhrases = { "TeamMemory_BigWin_Beyonders_01" },
			LastMatchCloseWinPhrases = { "TeamMemory_CloseWin_Beyonders_01" },
			LastMatchSolidWinPhrases = { "TeamMemory_SolidWin_Beyonders_01" },
			LastMatchBigLossPhrases = { "TeamMemory_BigLoss_Beyonders_01" },
			LastMatchCloseLossPhrases = { "TeamMemory_CloseLoss_Beyonders_01" },
			LastMatchSolidLossPhrases = { "TeamMemory_SolidLoss_Beyonders_01" },
			LastMatchNoMemoryPhrases = { "TeamMemory_NoMemory_Beyonders_01" },
			GenericReputation = "TeamName10_GenericRep_01",
			DraftSeenArchetypesOnly = true,
			UsePhantomShader = true,
			ForcedDraftPicks =
			{
				[1] = { 1, 2, 3 },
			},

			TeamAVersusLineNames = { "/VO/Match_1219" },
			TeamBVersusLineNames = { "/VO/Match_1220" },
			TeamScoresFirstSpeechLines =
			{
				-- The Beyonders are first to strike the adversary's flame.
				"/VO/Justice_515",
				-- Glory first for the Beyonders!
				"/VO/Justice_517",
				-- The Beyonders make their mark upon the flame!
				"/VO/Justice_518",
			},
			TeamScoredOnFirstSpeechLines =
			{
				-- The Beyonders' Pyre is the first to falter!
				"/VO/Justice_509",
				-- The Orb bathes first in the Beyonders' flame!
				"/VO/Justice_511",
			},
			TeamTakesLeadSpeechLines =
			{
				-- The Beyonders' Pyre now burns relatively brighter.
				"/VO/Justice_559",
				-- The Beyonders are now favored to prevail.
				"/VO/Justice_560",
				-- The Beyonders seem to want their freedom more.
				"/VO/Justice_561",
				-- Shall the Beyonders press their luck, perhaps?
				"/VO/Justice_562",
				-- Best not give in to pride just yet, Beyonders.
				"/VO/Justice_563",
				-- How very fortunate for you Beyonders.
				"/VO/Justice_564",
			},
			TeamLosesLeadSpeechLines =
			{
			},
			TeamFullWipeLines =
			{
				-- All of the Beyonders, gone!
				"/VO/Justice_581",
				-- Beyonders, banished to the last.
				"/VO/Justice_582",
				-- Unfortunate for the Beyonders.
				"/VO/Justice_583",
				-- A rude predicament for the Beyonders.
				"/VO/Justice_584",
				-- How sad this is for the Beyonders.
				"/VO/Justice_585",
				-- Not sign of the Beyonders I'm afraid.
				"/VO/Justice_586",
			},
			TeamPyreExtinguishedLines =
			{
				-- The Beyonders' flame is out!
				"/VO/Justice_565",
				-- Beyonders flames extinguished!
				"/VO/Justice_566",
			},
			TeamReadyLines =
			{
				-- Beyonders, stand prepared.
				"/VO/Justice_479",
				-- Beyonders, stand ready.
				"/VO/Justice_480",
				-- Prepare yourselves, Beyonders.
				"/VO/Justice_481",
				-- Declare yourselves, Beyonders!
				-- "/VO/Justice_458",
				-- Is each of the Beyonders present?
				-- "/VO/Justice_459",
			},

			TeamBench =
			{
				-- Sandra the Unseeing / Nomad
				{
					Archetype = "PlayerMedium",
					Tags = { "Story_Beyonder" },
					Gender = "female",
					FirstName = "Rivals_Captain17_FirstName",
					TitlePostFix = "Nomad_Title_07",
					TooltipIds = { FirstName = "Rivals_Captain17_FullName", ShortName = "Rivals_Captain17_FullName", FullName = "Rivals_Captain17_FullName" },
					-- FullName = "Name_Phantom",
					StartingTrait = "Beyonder01",
					Backstory = "Rivals_Beyonder_Backstory_Initial",
					RevealedBackstories = { "Rivals_Beyonder_Backstory_Complete", },
					Past = "Rivals_Beyonder_Past",
					Reason = "Rivals_Beyonder_Reason",
					Reputation = "Beyonder_Reputation_01",
					YearsExiled = 837,
					Birthday = { Month = "mJuly", Date = 1 },
					Portrait = "NomadSandra01_Robed",
					RobedPortrait = "NomadSandra01_Robed",
					SmallPortrait = "PhantomNomadMasked01_Robed_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Sandra/",
					AscensionSendOffVO = "/VO/Justice_1004",
					RandomGreetingStrings = { "Story_Beyonder_Greeting_01", "Story_Beyonder_Greeting_02", "Story_Beyonder_Greeting_03", "Story_Beyonder_Greeting_04", "Story_Beyonder_Greeting_05", "Story_Beyonder_Greeting_06", "Story_Beyonder_Greeting_07", "Story_Beyonder_Greeting_08", "Story_Beyonder_Greeting_09", "Story_Beyonder_Greeting_10", "Story_Beyonder_Greeting_11", "Story_Beyonder_Greeting_12", "Story_Beyonder_Greeting_13", "Story_Beyonder_Greeting_14", "Story_Beyonder_Greeting_15" },
					RandomReturnGreetingStrings = { "Story_Beyonder_ReturnGreeting_01", "Story_Beyonder_ReturnGreeting_02", "Story_Beyonder_ReturnGreeting_03", "Story_Beyonder_ReturnGreeting_04", "Story_Beyonder_ReturnGreeting_05", "Story_Beyonder_ReturnGreeting_06", "Story_Beyonder_ReturnGreeting_07", "Story_Beyonder_ReturnGreeting_08", "Story_Beyonder_ReturnGreeting_09", "Story_Beyonder_ReturnGreeting_10" },
					RandomGreetingQuips = { "/VO/Phantom_Sandra_0104__5", "/VO/Phantom_Sandra_0016__4", "/VO/Phantom_Sandra_0005_", "/VO/Phantom_Sandra_0038__6", "/VO/Phantom_Sandra_0038__5", "/VO/Phantom_Sandra_0118__2", "/VO/Phantom_Sandra_0104__1", "/VO/Phantom_Sandra_0044__4", "/VO/Phantom_Sandra_0042__3", "/VO/Phantom_Sandra_0039__3", "/VO/Phantom_Sandra_0015__3", "/VO/Phantom_Sandra_0014__6", "/VO/Phantom_Sandra_0012__5" },
					CurrentStatusesA = { "Status_A_Beyonder_01", "Status_A_Beyonder_02", "Status_A_Beyonder_03", "Status_A_Beyonder_04", "Status_A_Beyonder_05", "Status_A_Beyonder_06", "Status_A_Beyonder_07", "Status_A_Beyonder_08", "Status_A_Beyonder_09", "Status_A_Beyonder_10", "Status_A_Beyonder_11", "Status_A_Beyonder_12", "Status_A_Beyonder_13", "Status_A_Beyonder_14", "Status_A_Beyonder_15", "Status_A_Beyonder_16" },
					CurrentStatusesW = { "Status_W_Beyonder_01", "Status_W_Beyonder_02", "Status_W_Beyonder_03", "Status_W_Beyonder_04", "Status_W_Beyonder_05", "Status_W_Beyonder_06", "Status_W_Beyonder_07", "Status_W_Beyonder_08", "Status_W_Beyonder_09", "Status_W_Beyonder_10", "Status_W_Beyonder_11", "Status_W_Beyonder_12", "Status_W_Beyonder_13", "Status_W_Beyonder_14", "Status_W_Beyonder_15", },
					CurrentStatusesR = { "Status_R_Beyonder_01", "Status_R_Beyonder_02", "Status_R_Beyonder_03", "Status_R_Beyonder_04", "Status_R_Beyonder_05", "Status_R_Beyonder_06", "Status_R_Beyonder_07", "Status_R_Beyonder_08", "Status_R_Beyonder_09", "Status_R_Beyonder_10" },
					CurrentStatusesI = { "Status_I_Beyonder_01", "Status_I_Beyonder_02", "Status_I_Beyonder_03", "Status_I_Beyonder_04", "Status_I_Beyonder_05", "Status_I_Beyonder_06", "Status_I_Beyonder_07" },
					CurrentStatusesN = { "Status_N_Beyonder_01", "Status_N_Beyonder_02", "Status_N_Beyonder_03", "Status_N_Beyonder_04", "Status_N_Beyonder_05", "Status_N_Beyonder_06", "Status_N_Beyonder_07", "Status_N_Beyonder_08", "Status_N_Beyonder_09", "Status_N_Beyonder_10", },

					Height = 5.0,
					MusicTheme = "/Music/MatchMusic2_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,
					AscendedTooltip = "AscendedRival_Beyonder",

					EpilogueSpecialRemainedEventNarrationReqs = { "PracticeStone_Intro_01" },
					EpilogueSpecialRemainedEvent = "Epilogue_Beyonder_Remained_01",
 					EpilogueRemainedEvent = "Epilogue_Beyonder_Remained_Alt_01",
					EpilogueSpecialConclusionEvent = "Epilogue_Beyonder_SpecialConclusion_01",

					DraftedSpeech = "/VO/Match_111",
					VoiceUseTeamPostfix = false,
					UseVictoryVO = true,
					EventEnterSound = "/SFX/Match SFX/PlayerRespawnNEW",
					EventExitSound = "/SFX/Match SFX/AuraOn",

					PlayerAttributeRespawnModifier = -5,
					MatchSkills =
					{
						[2] = { "StaminaSkill" },

					},
				},
				-- Feryn
				{
					Archetype = "PlayerSmall",
					Gender = "female",
					FirstName = "Rivals_Beyonders_Extra_01",
					-- FullName = "Name_Phantom",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Cur_Phantom/",
					SmallPortrait = "PhantomCurMasked01_Robed_Small",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -6,
					PlayerAttributeSpeedModifier = 0,

					MatchSkills =
					{

					},
				},
				-- Zaphestoph
				{
					Archetype = "PlayerLarge",
					Gender = "female",
					FirstName = "Rivals_Beyonders_Extra_02",
					-- FullName = "Name_Phantom",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Demon_Phantom/",
					SmallPortrait = "PhantomDemonMasked01_Robed_Small",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -5,
					PlayerAttributeSpeedModifier = 0,

					MatchSkills =
					{
					},
				},
				-- Lishan
				{
					Archetype = "PlayerMediumAlt",
					Gender = "female",
					FirstName = "Rivals_Beyonders_Extra_03",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Nomad_Phantom/",
					SmallPortrait = "PhantomNomadMasked01_Robed_Small",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -1,
					PlayerAttributeSpeedModifier = -1,

					MatchSkills =
					{
					},
				},
				-- To'mi
				{
					Archetype = "PlayerImp",
					Gender = "female",
					FirstName = "Rivals_Beyonders_Extra_04",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Imp_Phantom_01/",
					SmallPortrait = "Imp_Beyonders_Small",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -2,
					PlayerAttributeSpeedModifier = -2,

					MatchSkills =
					{
					},
				},
				-- Lady Luvian
				{
					Archetype = "PlayerTrail",
					Gender = "female",
					SurName = "Worm_Honorific_Female",
					FirstName = "Rivals_Beyonders_Extra_05",
					LastName = "Rivals_Beyonders_Extra_05",
					TooltipIds = { FullName = "Rivals_Beyonders_Extra_05_Tooltip", ShortName = "Rivals_Beyonders_Extra_05_Tooltip" },
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Wyrm_Phantom_01/",
					SmallPortrait = "Wyrm_Beyonders_Small",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -1,
					PlayerAttributeSpeedModifier = -2,

					MatchSkills =
					{
					},
				},
				-- Thiata
				{
					Archetype = "PlayerFlying",
					Gender = "female",
					FirstName = "Rivals_Beyonders_Extra_06",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Harp_Phantom_01/",
					SmallPortrait = "Harp_Beyonders_Small",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -2,
					PlayerAttributeSpeedModifier = -3,

					MatchSkills =
					{
					},
				},
				-- Palmis
				{
					Archetype = "PlayerTree",
					Gender = "male",
					FirstName = "Rivals_Beyonders_Extra_07",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Sap_Phantom_01/",
					SmallPortrait = "Sap_Beyonders_Small",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -3,
					PlayerAttributeSpeedModifier = 0,

					MatchSkills =
					{
					},
				},
				-- Vorfrit
				{
					Archetype = "PlayerMonster",
					Gender = "female",
					FirstName = "Rivals_Beyonders_Extra_08",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Crone_Phantom_01/",
					SmallPortrait = "Crone_Beyonders_Small",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -4,
					PlayerAttributeSpeedModifier = 0,

					MatchSkills =
					{
					},
				},

				-- challenge units
				-- index = 10
				{
					Archetype = "PlayerLarge",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Demon_Phantom/",
					SmallPortrait = "PhantomDemonMasked01_Robed_Small",
					Traits = { },
					PlayerAttributeRespawn = 20,
					MatchSkills = { },
				},
				{
					Archetype = "PlayerLarge",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Demon_Phantom/",
					SmallPortrait = "PhantomDemonMasked01_Robed_Small",
					Traits = { },
					PlayerAttributeRespawn = 20,
					MatchSkills = { },
				},
				{
					Archetype = "PlayerLarge",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Demon_Phantom/",
					SmallPortrait = "PhantomDemonMasked01_Robed_Small",
					Traits = { },
					PlayerAttributeRespawn = 20,
					MatchSkills = { },
				},

				-- index = 13
				{
					Archetype = "PlayerFlying",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Harp_Phantom_01/",
					SmallPortrait = "Harp_Beyonders_Small",
					Traits = { },
					PlayerAttributeRespawn = 19,
					--MatchSkills = { [1] = "AirSpeed" },
				},
				{
					Archetype = "PlayerFlying",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Harp_Phantom_01/",
					SmallPortrait = "Harp_Beyonders_Small",
					Traits = { },
					PlayerAttributeRespawn = 19,
					--MatchSkills = { [1] = "AirSpeed" },
				},
				{
					Archetype = "PlayerFlying",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Harp_Phantom_01/",
					SmallPortrait = "Harp_Beyonders_Small",
					Traits = { },
					PlayerAttributeRespawn = 19,
					--MatchSkills = { [1] = "AirSpeed" },
				},

				-- index = 16
				{
					Archetype = "PlayerImp",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Imp_Phantom_01/",
					SmallPortrait = "Imp_Beyonders_Small",
					Traits = { },
					PlayerAttributeRespawn = 15,
					PlayerAttributeSpeed = 16,
					MatchSkills = { [1] = { "MoveBetter" } },
				},
				{
					Archetype = "PlayerImp",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Imp_Phantom_01/",
					SmallPortrait = "Imp_Beyonders_Small",
					Traits = { },
					PlayerAttributeRespawn = 15,
					PlayerAttributeSpeed = 16,
					MatchSkills = { [1] = { "MoveBetter" } },
				},
				{
					Archetype = "PlayerImp",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Imp_Phantom_01/",
					SmallPortrait = "Imp_Beyonders_Small",
					Traits = { },
					PlayerAttributeRespawn = 15,
					PlayerAttributeSpeed = 16,
					MatchSkills = { [1] = { "MoveBetter" } },
				},

				-- index = 19
				{
					Archetype = "PlayerSmall",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Cur_Phantom/",
					SmallPortrait = "PhantomCurMasked01_Robed_Small",
					Traits = { },
					PlayerAttributeRespawn = 20,
					MatchSkills = { },
				},
				{
					Archetype = "PlayerMedium",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Nomad_Phantom/",
					SmallPortrait = "PhantomNomadMasked01_Robed_Small",
					Traits = { },
					PlayerAttributeRespawn = 20,
					MatchSkills = { },
				},
				{
					Archetype = "PlayerLarge",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Demon_Phantom/",
					SmallPortrait = "PhantomDemonMasked01_Robed_Small",
					Traits = { },
					PlayerAttributeRespawn = 20,
					MatchSkills = {  },
				},

				-- index = 22
				{
					Archetype = "PlayerLarge",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Demon_Phantom/",
					SmallPortrait = "PhantomDemonMasked01_Robed_Small",
					Traits = { },
					PlayerAttributeRespawn = 20,
					MatchSkills = { },
				},
				{
					Archetype = "PlayerMonster",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Crone_Phantom_01/",
					SmallPortrait = "Crone_Beyonders_Small",
					Traits = { },
					PlayerAttributeRespawn = 20,
					MatchSkills = { },
				},
				{
					Archetype = "PlayerTree",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Sap_Phantom_01/",
					SmallPortrait = "Sap_Beyonders_Small",
					Traits = { },
					PlayerAttributeRespawn = 20,
					MatchSkills = {  },
				},

				-- index = 25
				{
					Archetype = "PlayerMediumAlt",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Nomad_Phantom/",
					SmallPortrait = "PhantomNomadMasked01_Robed_Small",
					Traits = { },
					PlayerAttributeRespawn = 19,
					--MatchSkills = { "CastChargeTime" },
				},
				{
					Archetype = "PlayerMediumAlt",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Nomad_Phantom/",
					SmallPortrait = "PhantomNomadMasked01_Robed_Small",
					Traits = { },
					PlayerAttributeRespawn = 19,
					--MatchSkills = { "CastChargeTime" },
				},
				{
					Archetype = "PlayerMediumAlt",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Nomad_Phantom/",
					SmallPortrait = "PhantomNomadMasked01_Robed_Small",
					Traits = { },
					PlayerAttributeRespawn = 19,
					--MatchSkills = { "CastChargeTime" },
				},

				-- index = 28
				{
					Archetype = "PlayerTree",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Sap_Phantom_01/",
					SmallPortrait = "Sap_Beyonders_Small",
					Traits = { },
					PlayerAttributeRespawn = 5,
					MatchSkills = { },
				},
				{
					Archetype = "PlayerMedium",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Nomad_Phantom/",
					SmallPortrait = "PhantomNomadMasked01_Robed_Small",
					Traits = { },
					PlayerAttributeRespawn = 5,
					MatchSkills = { },
				},
				{
					Archetype = "PlayerLarge",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Demon_Phantom/",
					SmallPortrait = "PhantomDemonMasked01_Robed_Small",
					Traits = { },
					PlayerAttributeRespawn = 5,
					MatchSkills = { },
				},

				-- index = 31
				{
					Archetype = "PlayerMedium",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Nomad_Phantom/",
					SmallPortrait = "PhantomNomadMasked01_Robed_Small",
					Traits = { },
					PlayerAttributeRespawn = 20,
					--MatchSkills = { "StaminaSkill", "MassivePowerShot" },
				},
				{
					Archetype = "PlayerMediumAlt",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Nomad_Phantom/",
					SmallPortrait = "PhantomNomadMasked01_Robed_Small",
					Traits = { },
					PlayerAttributeRespawn = 20,
					--MatchSkills = { "MobilityChargeTime", "JumpDistance" },
				},
				{
					Archetype = "PlayerFlying",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Harp_Phantom_01/",
					SmallPortrait = "Harp_Beyonders_Small",
					Traits = { },
					PlayerAttributeRespawn = 20,
					--MatchSkills = { "AirSpeed" },
				},

				-- index = 34
				{
					Archetype = "PlayerSmall",
					VoicePrefix =  "/SFX/Player Sounds/Vocalizations/Cur_Phantom/",
					SmallPortrait = "PhantomCurMasked01_Robed_Small",
					Traits = { },
					PlayerAttributeAura = 30,
					PlayerAttributeRespawn = 21,
					--MatchSkills = { "DoubleJump", "SprintSpeed", "SacrificeScoreSkill5" },
				},
				{
					Archetype = "PlayerImp",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Imp_Phantom_01/",
					SmallPortrait = "Imp_Beyonders_Small",
					Traits = { },
					PlayerAttributeAura = 35,
					PlayerAttributeRespawn = 21,
					--MatchSkills = { "MoveBetter", "ExplodeBigger", "AnyScoreSkill" },
				},
				{
					Archetype = "PlayerTrail",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Wyrm_Phantom_01/",
					SmallPortrait = "Wyrm_Beyonders_Small",
					Traits = { },
					PlayerAttributeRespawn = 21,
					--MatchSkills = { "AllDeadRespawn", "SoleUnitPowerUp" },
				},
			}
		},
		[11] =
		{
			-- True Nightwings Team
			Name = "TeamName11",
			GoalDecalSigil = "TrueNightwingsGrill01",
			MeteorColorGrade = "Team11",
			MaskHue = 10, MaskSaturationAddition = 0,  MaskValueAddition = -20,
			MaskHue2 = 210, MaskSaturationAddition2 = -40, MaskValueAddition2 = -45,
			PostMatchSigil = "SigilTrueNightwings",
			RosterScreenSigil = "GUI\\Sigils\\TrueNightwings_01_UI",
			LargeSigil = "Tilesets\\Arena\\TrueNightwings_01",
			PyreIcon = "GUI\\Icons\\Pyre\\PyreIcon_TrueNightwings",
			IntroVO = "/VO/Match_113", VictoryVO = "/VO/Match_114",
			AscensionVictoryVO = "/VO/Match_568",
			MusicTheme = "/Music/MatchMusic5_MC",
			AscensionMusicTheme = "/Music/AscensionMatchMusicNightwings_MC",
			PreMatchEvents = { "OpenStructure_TrueNightwings_ReachedGoal_01" },
			MatchStartEvents = { "OpenStructure_Match_TrueNightwings_Beginning_01" },
			MatchDraftStartEvents = { "OpenStructure_Match_TrueNightwings_DraftStart_01" },
			MatchDraftEndEvents = { "OpenStructure_Match_TrueNightwings_DraftEnd_01" },
			MatchVictoryEvents = { "OpenStructure_Match_TrueNightwings_TheyWon_01" },
			MatchDefeatEvents = { "OpenStructure_Match_TrueNightwings_TheyLost_01" },
			LastMatchBigWinPhrases = { "TeamMemory_BigWin_TrueNightwings_01" },
			LastMatchCloseWinPhrases = { "TeamMemory_CloseWin_TrueNightwings_01" },
			LastMatchSolidWinPhrases = { "TeamMemory_SolidWin_TrueNightwings_01" },
			LastMatchBigLossPhrases = { "TeamMemory_BigLoss_TrueNightwings_01" },
			LastMatchCloseLossPhrases = { "TeamMemory_CloseLoss_TrueNightwings_01" },
			LastMatchSolidLossPhrases = { "TeamMemory_SolidLoss_TrueNightwings_01" },
			LastMatchNoMemoryPhrases = { "TeamMemory_NoMemory_TrueNightwings_01" },
			GenericReputation = "TeamName11_GenericRep_01",
			GuideBookChapter = 8,
			GuideBookEntry = 10,
			WinsSinceLastAscensionAttempt = 0,
			ForcedDraftPicks =
			{
				[1] = { 1, 2, 3 },
				[2] = { 1, 2, 3 },
				[3] = { 1, 2, 3 },
				[4] = { 1, 2, 3 },
				[5] = { 1, 2, 3 },
			},

			TeamAVersusLineNames = { "/VO/Match_1221" },
			TeamBVersusLineNames = { "/VO/Match_1222" },
			TeamScoresFirstSpeechLines =
			{
				-- The True Nightwings are first to strike their adversary's flame!
				"/VO/Match_1164",
				-- Glory first to the True Nightwings!
				"/VO/Match_1165",
				-- The True Nightwings make their mark upon the flame!
				"/VO/Match_1166",
			},
			TeamScoredOnFirstSpeechLines =
			{
				-- The True Nightwings' Pyre is the first to falter.
				"/VO/Match_1167",
				-- The Orb bathes first in the True Nightwings' flame!
				"/VO/Match_1168",
			},
			TeamTakesLeadSpeechLines =
			{
				-- The True Nightwings' Pyre now burns relatively brighter.
				"/VO/Match_1169",
				-- The True Nightwings seem to want their freedom more.
				"/VO/Match_1170",
				-- The True Nightwings are now favored to prevail.
				"/VO/Match_1171",
				-- Shall the True Nightwings press their luck, perhaps?
				"/VO/Match_1172",
				-- Best not give in to pride just yet, True Nightwings.
				"/VO/Match_1173",
				-- How very fortunate for the True Nightwings.
				"/VO/Match_1174",
			},
			TeamLosesLeadSpeechLines =
			{
				-- The True Nightwings seem to be falling behind.
				"/VO/Match_1175",
				-- The True Nightwings' adversaries gained an edge.
				"/VO/Match_1176",
				-- A show of strength from the True Nightwings' foe.
				"/VO/Match_1177",
			},
			TeamFullWipeLines =
			{
				-- All of the True Nightwings, gone.
				"/VO/Match_1178",
				-- True Nightwings, banished to the last.
				"/VO/Match_1179",
				-- Unfortunate for the True Nightwings.
				"/VO/Match_1180",
				-- A foul turn for the True Nightwings.
				"/VO/Match_1181",
				-- How very sad for the True Nightwings.
				"/VO/Match_1182",
				-- No sign of the True Nightwings at this time!
				"/VO/Match_1183",
			},
			TeamPyreExtinguishedLines =
			{
				-- The True Nightwings' flame is out!
				"/VO/Match_1184",
				-- The True Nightwings' flames, extinguished!
				"/VO/Match_1185",
			},
			TeamReadyLines =
			{
				-- True Nightwings, stand prepared.
				"/VO/Match_1186",
				-- True Nightwings, stand ready.
				"/VO/Match_1187",
			},

			TeamBench =
			{
				-- Oralech / Demon
				{
					Archetype = "PlayerLarge",
					Tags = { "Story_Nightwing" },
					Gender = "male",
					FirstName = "Rivals_Nightwing_FirstName",
					StartingTrait = "Nightwing01",
					Backstory = "Rivals_Nightwing_Backstory_Initial",
					RevealedBackstories = { "Rivals_Nightwing_Backstory_Complete", },
					Past = "Rivals_Nightwing_Past",
					Reason = "Rivals_Nightwing_Reason",
					Reputation = "Nightwing_Reputation_01",
					YearsExiled = 18,
					Birthday = { Month = "mAugust", Date = 10 },
					TextSpeedMultiplier = 1.1,
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop4",
					Portrait = "DemonOralech01_Robed",
					RobedPortrait = "DemonOralech01_Robed",
					SmallPortrait = "DemonOralech01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Oralech/",
					CaravanOffsetX = 0,
					CaravanOffsetY = 0,
					AscensionSendOffVO = "/VO/Justice_1003",
					MusicTheme = "/Music/MatchMusic5_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,
					--AscendedTooltip = "AscendedRival_Nightwing",

					EpilogueRivalCharTag = "Story_Doc",
					EpilogueRivalChar2Tag = "Story_Mascot",
					EpilogueAscendedEvent = "Epilogue_Nightwing_Ascended_01",
					EpilogueAscendedPlanAEvent = "Epilogue_Nightwing_AscendedPlanA_01",
					EpilogueAscendedPlanBEvent = "Epilogue_Nightwing_AscendedPlanB_01",
					EpilogueAscendedPlanCEvent = "Epilogue_Nightwing_AscendedPlanC_01",
					EpilogueAscendedPostPlanEvent = "Epilogue_Nightwing_AscendedPostPlan_01",
					EpilogueAscendedWithRivalEvent = "Epilogue_Nightwing_Ascended_WithRival_01",
					EpilogueAscendedWithRival2Event = "Epilogue_Nightwing_Ascended_WithRival2_01",
					EpilogueAscendedWithoutReaderEventNarrationReqs = { "Match_Ascension7_YouWon_ChooseAdversary", "Match_Ascension7_YouLost_ReachOut_Nightwing" },
					EpilogueAscendedWithoutReaderEvent = "Epilogue_Nightwing_Ascended_WithoutReader_01",
					EpilogueAscendedWithoutRivalEvent = "Epilogue_Nightwing_Ascended_WithoutRival_01",
					EpilogueAscendedConclusionEvent = "Epilogue_Nightwing_AscendedConclusion_01",
					EpilogueSpecialRemainedEventNarrationReqs = { "Match_Ascension7_YouLost_Manipulate_Escape", "Match_Ascension7_YouWon" },
					EpilogueSpecialRemainedEvent = "Epilogue_Nightwing_SpecialRemained_01",
					EpilogueRemainedEvent = "Epilogue_Nightwing_Remained_01",
					EpilogueRemainedWithRivalEvent = "Epilogue_Nightwing_Remained_WithRival_01",
					EpilogueRemainedWithoutRivalEvent = "Epilogue_Nightwing_Remained_WithoutRival_01",
					EpilogueRemainedWithoutReaderEvent = "Epilogue_Nightwing_Remained_WithoutReader_01",
					EpilogueRemainedWithRival2Event = "Epilogue_Nightwing_Remained_WithRival2_01",
					EpilogueRemainedConclusionEvent = "Epilogue_Nightwing_RemainedConclusion_01",

					AttractQuip = "/VO/Demon_Oralech_0079__1",
					DraftedSpeech = "/VO/Match_110",
					EventEnterSound = "/SFX/World Sounds/DemonEnter",
					EventExitSound = "/SFX/World Sounds/DemonEnter",
					UseVictoryVO = true,
					Height = 10,
					ScoringSpeechLines = { "/VO/Match_498", "/VO/Match_499", "/VO/Match_500", },
					ThrowScoringSpeechLines = { "/VO/Match_896", "/VO/Match_897", "/VO/Match_898" },
					BanishedSpeechLines = { "/VO/Match_501", "/VO/Match_502", "/VO/Match_503", "/VO/Match_504" },
					SpecialScorePose = "PlayerOralechScorePose",
					SpecialAuraTurnOn = "PlayerOralechAuraTurnOn",
					SpecialTauntAnimation = "PlayerOralechAuraTurnOn",
					MoveGraphic = "PlayerLargeRun",
					StartGraphic = "PlayerLargeStartSpecial",
					SprintFireGraphic = "PlayerLargeJumpSpecial",

					PlayerAttributeAura = 40,
					PlayerAttributeRespawn = 15,
					PlayerAttributeSpeed = 20,
					ScoreValue = 20,

					MatchSkills =
					{
						[1] = { "DoubleRush", "TauntScoreSkill10", "EvadeStun" },
						[2] = { "AuraSpikeKill" },
					},
					MatchItems =
					{
						[2] = "PyreHealthItemOralech",
					},
				},
				-- Gareph
				{ Archetype = "PlayerMediumAlt",
					Gender = "male",
					FirstName = "Rivals_TrueNightwings_Extra_01",
					PlayerAttributeAuraModifier = 2,
					PlayerAttributeRespawnModifier = 4,
					PlayerAttributeSpeedModifier = 6,
					SpecialScorePose = "PlayerMediumAltScorePoseAlt",
					SmallPortrait = "Nomad_TrueNightwings_Small",
					MatchSkills =
					{
						[1] = { "CastChargeTime", "TossSkillMediumAlt", "UnlimitedBallStamina" },
						[2] = { "MobilityChargeTime" },
					},
					MatchItems =
					{
						[2] = "QuickRespawnItemTrueNightwings",
					},
				},
				-- Iq'sa
				{ Archetype = "PlayerImp",
					Gender = "female",
					FirstName = "Rivals_TrueNightwings_Extra_02",
					PlayerAttributeAuraModifier = 2,
					PlayerAttributeRespawnModifier = 1,
					PlayerAttributeSpeedModifier = -2,
					SpecialScorePose="PlayerImpScorePoseAlt",
					SmallPortrait = "Imp_TrueNightwings_Small",
					MatchSkills =
					{
						[1] = { "MoveBetter", "CastFastRespawn" },
						[2] = { "ExplodeBigger" },
					},
					MatchItems =
					{
						[2] = "PlusSpeedItemTrueNightwings",
					},
				},
			}
		},
		[12] =
		{
		 	-- Conceit // MP TESTING TEAM
			Multiplayer = true,
			Name = "TeamNameMP01",
			FullName = "TeamName01_Full",
			GenericExileName = "TeamName01_GenericExile_01",
			GoalDecalSigil = "NightwingsGrill01",
			MeteorColorGrade = "Team01",
			PostMatchSigil = "SigilNightwings",
			RosterScreenSigil = "GUI\\Sigils\\Nightwings_01_UI",
			LargeSigil = "Tilesets\\Arena\\Nightwings_01",
			IntroVO = "/VO/Match_6", VictoryVO = "/VO/Justice_483",
			PyreIcon = "GUI\\Icons\\Pyre\\PyreIcon_Nightwings",
			LocalMPTeamAVictoryEvents = { "LocalMP_Victory_01", "LocalMP_Victory_02", "LocalMP_Victory_03" },
			LocalMPTeamBVictoryEvents = { "LocalMP_Victory_01_Alt", "LocalMP_Victory_02_Alt", "LocalMP_Victory_03_Alt" },

			--MaskHue = 28, MaskSaturationAddition = -20, MaskValueAddition = -15,
			--MaskHue2 = 191, MaskSaturationAddition2 = 0,  MaskValueAddition2 = 0,

			MaskHue = 210, MaskSaturationAddition = -20, MaskValueAddition = -15,
			MaskHue2 = 10, MaskSaturationAddition2 = 0,  MaskValueAddition2 = 0,

			TeamBench =
			{
				-- HedwynMP [1]
				{
					Archetype = "PlayerMedium",
					Tags = { "Story_FriendMP" },
					Gender = "male",
					FirstName = "Chars_Friend_FirstName_LocalMP",
					TitlePostFix = "Nomad_Title_01",
					Past = "Past_Friend01",
					Reason = "Reason_Friend01",
					Backstory = "Backstory_Friend01_Complete",
					Goal = "Goal_Friend01",
					Fear = "Fear_Friend01",
					Reputation = "Friend_Reputation_01",
					YearsExiled = 5,
					Birthday = { Month = "mJuly", Date = 29 },
					Portrait = "NomadHedwyn01",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Hedwyn/",
					StartingTrait = "Friend01",
					PlayerAttributeRespawn = 22,
					StartingSkills = { "StaminaSkill" },
					DraftedSpeech = "/VO/Match_93",
					VoiceUseTeamPostfix = false,
					-- DraftSelectVO = "/VO/Nomad_Hedwyn_10a",
					Height = 5,
					ScoringSpeechLines = { "/VO/Match_341", "/VO/Match_342" },
					BanishedSpeechLines = { "/VO/Match_349", "/VO/Match_350", "/VO/Match_351", "/VO/Match_352", "/VO/Match_353" },
					ThrowScoringSpeechLines = { "/VO/Match_839", "/VO/Match_840", "/VO/Match_841" },
					SkillTreeA = "PlayerMediumA",
					SkillTreeB = "PlayerMediumB",

					MaskHue = 210, MaskSaturationAddition = -20, MaskValueAddition = -15,
					MaskHue2 = 10, MaskSaturationAddition2 = 0,  MaskValueAddition2 = 0,

					MusicTheme = "/Music/ScavengersTheme_MC",
					MusicStemName = "Mandolins",
					MusicStemValue = 1,

					XP = 1180,
					TotalXP = 1180,
					Level = 2,
				},
				-- JodiMP [2]
				{
					Archetype = "PlayerLarge",
					Tags = { "Story_BadassMP" },
					Gender = "female",
					FirstName = "Chars_Badass_FirstName_LocalMP",
					Backstory = "Backstory_Badass01_Complete",
					Past = "Past_Badass01",
					Reason = "Reason_Badass01",
					Goal = "Goal_Badass01",
					Fear = "Fear_Badass01",
					Reputation = "Badass_Reputation_01",
					YearsExiled = 16,
					Portrait = "DemonJodi01",
					Birthday = { Month = "mDecember", Date = 23 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop2",
					TextSpeedMultiplier = 1.15,
					VictoryScreenPortrait = "DemonJodi01_Robed_Smirking",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Jodi/",
					StartingTrait = "Badass01",
					PlayerAttributeRespawn = 9,
					StartingSkills = { "KillsRegenerateStamina100" },
					DraftedSpeech = "/VO/Match_21",
					Height = 8,
					ScoringSpeechLines = { "/VO/Match_343", "/VO/Match_344" },
					ThrowScoringSpeechLines = { "/VO/Match_842", "/VO/Match_843", "/VO/Match_844" },
					BanishedSpeechLines = { "/VO/Match_354", "/VO/Match_355", "/VO/Match_356", "/VO/Match_357" },
					SkillTreeA = "PlayerLargeA",
					SkillTreeB = "PlayerLargeB",

					EventEnterSound = "/SFX/World Sounds/DemonEnter",
					EventExitSound = "/SFX/World Sounds/DemonEnter",
					MaskHue = 210, MaskSaturationAddition = -20, MaskValueAddition = -15,
					MaskHue2 = 10, MaskSaturationAddition2 = 0,  MaskValueAddition2 = 0,

					MusicTheme = "/Music/ScavengersTheme_MC",
					MusicStemName = "Toms",
					MusicStemValue = 1,

					XP = 1250,
					TotalXP = 1250,
					Level = 2,
				},
				-- RukeyMP [3]
				{
					Archetype = "PlayerSmall",
					Tags = { "Story_JokerMP" },
					Gender = "male",
					FirstName = "Chars_Joker_FirstName_LocalMP",
					LastName = "Chars_Joker_LastName",
					TooltipIds = { FirstName = "Chars_Joker_LongName", ShortName = "Chars_Joker_LongName", FullName = "Chars_Joker_LongNAme", LastName = "Chars_Joker_LastName_Tooltip" },
					Past = "Past_Joker01",
					Reason = "Reason_Joker01",
					Backstory = "Backstory_Joker01_Complete",
					Goal = "Goal_Joker01",
					Fear = "Fear_Joker01",
					Reputation = "Joker_Reputation_01",
					YearsExiled = 4,
					Birthday = { Month = "mApril", Date = 4 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop3",
					TextSpeedMultiplier = 0.8,
					Portrait = "CurRukey02",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Rukey/",
					StartingTrait = "Joker01",
					PlayerAttributeSpeed = 18,
					StartingSkills = { "DoubleJump" },
					DraftedSpeech = "/VO/Match_94",
					-- DraftSelectVO = "/VO/Cur_Rukey_30",
					Height = 3,
					ScoringSpeechLines = { "/VO/Match_345", "/VO/Match_346" },
					ThrowScoringSpeechLines = { "/VO/Match_845", "/VO/Match_846", "/VO/Match_847" },
					BanishedSpeechLines = { "/VO/Match_359", "/VO/Match_360", "/VO/Match_361", "/VO/Match_362" },
					TauntSoundLong = "/SFX/Player Sounds/Vocalizations/Rukey/EmoteLongHowl",
					TauntSound = "/SFX/Player Sounds/Vocalizations/Rukey/EmoteShortHowl",
					SkillTreeA = "PlayerSmallA",
					SkillTreeB = "PlayerSmallB",

					MaskHue = 210, MaskSaturationAddition = -20, MaskValueAddition = -15,
					MaskHue2 = 10, MaskSaturationAddition2 = 0,  MaskValueAddition2 = 0,

					MusicTheme = "/Music/ScavengersTheme_MC",
					MusicStemName = "Flutes",
					MusicStemValue = 1,

					XP = 1400,
					TotalXP = 1400,
					Level = 2,
				},
				-- MaeMP [4]
				{
					Archetype = "PlayerMediumAlt",
					Tags = { "Story_PsychoMP" },
					Gender = "female",
					FirstName = "Chars_Psycho_FirstName",
					TitlePostFix = "Nomad_Title_02",
					Past = "Past_Psycho01",
					Reason = "Reason_Psycho01",
					Backstory = "Backstory_Psycho01_Complete",
					Goal = "Goal_Psycho01",
					Fear = "Fear_Psycho01",
					Reputation = "Psycho_Reputation_01",
					YearsExiled = 2,
					Birthday = { Month = "mNovember", Date = 19 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop3",
					Portrait = "NomadMae01",
					VictoryScreenPortrait = "NomadMae01_Robed_Joy",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Mae/",
					StartingTrait = "Psycho01",
					StartingSkills = { "TauntBallTeleport" },
					DraftedSpeech = "/VO/Match_95",
					VoiceUseTeamPostfix = false,
					-- DraftSelectVO = "/VO/Mae_14_1",
					Height = 4,
					ScoringSpeechLines = { "/VO/Match_258", "/VO/Match_259", "/VO/Match_260", },
					ThrowScoringSpeechLines = { "/VO/Match_1244", "/VO/Match_1245", "/VO/Match_1246" },
					BanishedSpeechLines = { "/VO/Match_261", "/VO/Match_262", "/VO/Match_263", "/VO/Match_264" },
					SkillTreeA = "PlayerMediumAltA",
					SkillTreeB = "PlayerMediumAltB",

					MaskHue = 210, MaskSaturationAddition = -20, MaskValueAddition = -15,
					MaskHue2 = 10, MaskSaturationAddition2 = 0,  MaskValueAddition2 = 0,

					MusicTheme = "/Music/MaeTheme_MC",
					MusicStemName = "Flutes",
					MusicStemValue = 1,

					XP = 1075,
					TotalXP = 1075,
					Level = 2,
				},
				-- Ti'zoMP [5]
				{
					Archetype = "PlayerImp",
					Tags = { "Story_MascotMP" },
					Gender = "male",
					FirstName = "Chars_Mascot_FirstName",
					Backstory = "Backstory_Mascot01_Complete",
					Past = "Past_Mascot01",
					Reason = "Reason_Mascot01",
					Goal = "Goal_Mascot01",
					Fear = "Fear_Mascot01",
					Reputation = "Mascot_Reputation_01",
					TooltipIds = { YearsExiled = "YearsExiled_Alt_Tooltip" },
					Birthday = { Month = "mMay", Date = 13 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop3",
					TextSpeedMultiplier = 0.8,
					Portrait = "ImpTizo01",
					VictoryScreenPortrait = "ImpTizo01_Robed_Stoked",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Tizo/",
					StartingTrait = "Mascot01",
					StartingSkills = { "MoveBetter", "CastFastRespawn", "ExplodeBigger"},
					DraftedSpeech = "/VO/Match_96",
					Height = 1,
					ScoringSpeechLines = { "/VO/Match_265", "/VO/Match_266", "/VO/Match_267", },
					ThrowScoringSpeechLines = { "/VO/Match_851", "/VO/Match_852", "/VO/Match_853" },
					BanishedSpeechLines = { "/VO/Match_268", "/VO/Match_269", "/VO/Match_270", "/VO/Match_271" },
					SkillTreeA = "PlayerImpA",
					SkillTreeB = "PlayerImpB",

					MaskHue = 210, MaskSaturationAddition = -20, MaskValueAddition = -15,
					MaskHue2 = 10, MaskSaturationAddition2 = 0,  MaskValueAddition2 = 0,

					MusicTheme = "/Music/ImpTheme_MC",
					MusicStemName = "Misc",
					MusicStemValue = 1,

					XP = 6050,
					TotalXP = 6050,
					Level = 4,
				},
				-- GilmanMP [6]
				{
					Archetype = "PlayerTrail",
					Tags = { "Story_KnightMP" },
					Gender = "male",
					SurName = "Worm_Honorific_Male",
					FirstName = "Chars_Knight_FirstName",
					LastName = "Chars_Knight_FirstName",
					TooltipIds = { FirstName = "Chars_Knight_LongName", ShortName = "Chars_Knight_LongName", FullName = "Chars_Knight_LongName", LastName = "Chars_Knight_LongName" },
					Past = "Past_Knight01",
					Reason = "Reason_Knight01",
					Backstory = "Backstory_Knight01_Complete",
					Goal = "Goal_Knight01",
					Fear = "Fear_Knight01",
					Reputation = "Knight_Reputation_01",
					YearsExiled = 3,
					Birthday = { Month = "mNovember", Date = 3 },
					Portrait = "WyrmGilman01",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Gilman/",
					StartingTrait = "Knight01",
					StartingSkills = { "WeaponReTeleport", "WeaponRechargeStamina", "AllDeadRespawn" },
					DraftedSpeech = "/VO/Match_97",
					Height = 2,
					ScoringSpeechLines = { "/VO/Match_272", "/VO/Match_273", "/VO/Match_274", },
					ThrowScoringSpeechLines = { "/VO/Match_854", "/VO/Match_855", "/VO/Match_856" },
					BanishedSpeechLines = { "/VO/Match_275", "/VO/Match_276", "/VO/Match_277", "/VO/Match_278" },
					SkillTreeA = "PlayerTrailA",
					SkillTreeB = "PlayerTrailB",

					MaskHue = 210, MaskSaturationAddition = -20, MaskValueAddition = -15,
					MaskHue2 = 10, MaskSaturationAddition2 = 0,  MaskValueAddition2 = 0,

					EventEnterSound = "/SFX/World Sounds/WyrmEnter",
					EventExitSound = "/SFX/World Sounds/WyrmEnter",
					MusicTheme = "/Music/GilmanTheme_MC",
					MusicStemName = "Drums",
					MusicStemValue = 1,

					--PlayerAttributeSpeed = 40,

					XP = 5600,
					TotalXP = 5600,
					Level = 4,
				},
				-- PamithaMP [7]
				{
					Archetype = "PlayerFlying",
					Tags = { "Story_VampMP" },
					Gender = "female",
					FirstName = "Chars_Vamp_FirstName",
					LastName = "Chars_Vamp_LastName",
					LongName = "Chars_Vamp_LongName",
					TooltipIds = { FirstName = "Chars_Vamp_LongName", ShortName = "Chars_Vamp_LongName", FullName = "Chars_Vamp_LongName", LastName = "Chars_Vamp_LastName_Tooltip" },
					Past = "Past_Vamp01",
					Reason = "Reason_Vamp01",
					Backstory = "Backstory_Vamp01_Complete",
					Goal = "Goal_Vamp01",
					Fear = "Fear_Vamp01",
					Reputation = "Vamp_Reputation_01",
					YearsExiled = 4,
					Birthday = { Month = "mAugust", Date = 31 },
					Portrait = "HarpPamitha02",
					SmallPortrait = "HarpPamitha01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Pamitha/",
					StartingTrait = "Vamp01",
					StartingSkills = { "TauntSwap", "DashCooldown" },
					DraftedSpeech = "/VO/Match_98",
					Height = 6,
					ScoringSpeechLines = { "/VO/Match_279", "/VO/Match_280", "/VO/Match_281", },
					ThrowScoringSpeechLines = { "/VO/Match_857", "/VO/Match_858", "/VO/Match_859" },
					BanishedSpeechLines = { "/VO/Match_282", "/VO/Match_283", "/VO/Match_284", "/VO/Match_285" },
					SkillTreeA = "PlayerFlyingA",
					SkillTreeB = "PlayerFlyingB",

					MaskHue = 210, MaskSaturationAddition = -20, MaskValueAddition = -15,
					MaskHue2 = 10, MaskSaturationAddition2 = 0,  MaskValueAddition2 = 0,

					MusicTheme = "/Music/PamithaTheme_MC",
					MusicStemName = "Drums",
					MusicStemValue = 1,

					--PlayerAttributeSpeed = 40,

					XP = 3400,
					TotalXP = 3400,
					Level = 3,
				},
				-- VolfredMP [8]

				{
					Archetype = "PlayerTree",
					Tags = { "Story_DocMP" },
					Gender = "male",
					FirstName = "Chars_Doc_MiddleName",
					FirstInitial = "Chars_Doc_FirstInitial",
					MiddleName = "Chars_Doc_MiddleName",
					LastName = "Chars_Doc_LastName",
					TooltipIds = { FirstName = "Chars_Doc_LongName_Alt", ShortName = "Chars_Doc_LongName_Alt", FullName = "Chars_Doc_LongName_Alt", LongName = "Chars_Doc_LongName_Alt", LastName = "Chars_Doc_LongName_Alt" },
					Past = "Past_Doc01",
					Reason = "Reason_Doc01",
					Backstory = "Backstory_Doc01_Complete",
					Goal = "Goal_Doc01",
					Fear = "Fear_Doc01",
					Reputation = "Doc_Reputation_01",
					YearsExiled = 9,
					Birthday = { Month = "mJune", Date = 21 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop2",
					Portrait = "SapVolfred01",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Volfred/",
					StartingTrait = "Doc01",
					StartingSkills = { "PlusHopeSkill", "ShieldAllies" },
					DraftedSpeech = "/VO/Match_99",
					Height = 9,
					ScoringSpeechLines = { "/VO/Match_286", "/VO/Match_287", "/VO/Match_288", },
					ThrowScoringSpeechLines = { "/VO/Match_860", "/VO/Match_861", "/VO/Match_862" },
					BanishedSpeechLines = { "/VO/Match_289", "/VO/Match_290", "/VO/Match_291", "/VO/Match_433" },
					SkillTreeA = "PlayerTreeA",
					SkillTreeB = "PlayerTreeB",

					EventEnterSound = "/SFX/World Sounds/SapEnter",
					EventExitSound = "/SFX/World Sounds/SapEnter",
					MaskHue = 210, MaskSaturationAddition = -20, MaskValueAddition = -15,
					MaskHue2 = 10, MaskSaturationAddition2 = 0,  MaskValueAddition2 = 0,

					MusicTheme = "/Music/VolfredTheme_MC",
					MusicStemName = "Mandolins",
					MusicStemValue = 2,

					XP = 4275,
					TotalXP = 4275,
					Level = 3,
				},

				-- BertrudeMP [9]
				{
					Archetype = "PlayerMonster",
					Tags = { "Story_DivaMP" },
					Gender = "female",
					SurName = "Chars_Diva_SurName",
					FirstName = "Chars_Diva_FirstName",
					LastName = "Chars_Diva_FirstName",
					TooltipIds = { FirstName = "Chars_Diva_LongName", ShortName = "Chars_Diva_LongName", FullName = "Chars_Diva_LongName", LongName = "Chars_Diva_LongName" },
					Past = "Past_Diva01",
					Reason = "Reason_Diva01",
					Backstory = "Backstory_Diva01_Complete",
					Goal = "Goal_Diva01",
					Fear = "Fear_Diva01",
					Reputation = "Diva_Reputation_01",
					YearsExiled = 21,
					Birthday = { Month = "mFebruary", Date = 22 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop5",
					TextSpeedMultiplier = 1.25,
					Portrait = "CroneBertrude01",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Bertrude/",
					StartingTrait = "Diva01",
					StartingSkills = { "MonsterJumpSkill", "ChargeMonsterSkill" },
					DraftedSpeech = "/VO/Match_100",
					Height = 7,
					ScoringSpeechLines = { "/VO/Match_434", "/VO/Match_435", "/VO/Match_436", },
					ThrowScoringSpeechLines = { "/VO/Match_863", "/VO/Match_864", "/VO/Match_865" },
					BanishedSpeechLines = { "/VO/Match_437", "/VO/Match_438", "/VO/Match_439", "/VO/Match_440" },
					SkillTreeA = "PlayerMonsterA",
					SkillTreeB = "PlayerMonsterB",

					EventEnterSound = "/SFX/World Sounds/CroneEnter",
					EventExitSound = "/SFX/World Sounds/CroneEnter",
					MusicTheme = "/Music/BertrudeTheme_MC",
					MusicStemName = "Drums",
					MusicStemValue = 2,

					MaskHue = 210, MaskSaturationAddition = -20, MaskValueAddition = -15,
					MaskHue2 = 10, MaskSaturationAddition2 = 0,  MaskValueAddition2 = 0,

					XP = 3175,
					TotalXP = 3175,
					Level = 3,
				},

				-- LendelMP [10]
				{
					Archetype = "PlayerMedium",
					Tags = { "Story_AccuserMP" },
					Gender = "male",
					FirstName = "Rivals_Accuser_FirstName_LocalMP",
					TitlePostFix = "Nomad_Title_03",
					StartingTrait = "Accuser01",
					Backstory = "Rivals_Accuser_Backstory_Complete",
					Past = "Rivals_Captain02_Past",
					Reason = "Rivals_Accuser_Reason",
					Reputation = "Accuser_Reputation_01",
					YearsExiled = 6,
					Birthday = { Month = "mNovember", Date = 19 },
					Portrait = "NomadLendel01_Robed",
					RobedPortrait = "NomadLendel01_Robed",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Lendel/",
					MatchScale = 1.15,
					DraftedSpeech = "/VO/Match_101",
					ScoringSpeechLines = { "/VO/Match_347", "/VO/Match_348" },
					ThrowScoringSpeechLines = { "/VO/Match_866", "/VO/Match_867", "/VO/Match_868" },
					BanishedSpeechLines = { "/VO/Match_364", "/VO/Match_365", "/VO/Match_366", "/VO/Match_367", "/VO/Match_368" },
					PlayerAttributeRespawnModifier = -5,
					PlayerAttributeSpeedModifier = -1,
					StartingSkills = { "MassivePowerShot" },
					ScoreValue = 20,
					MaskHue = 30, MaskSaturationAddition = -30, MaskValueAddition = -30,
					MaskHue2 = 40, MaskSaturationAddition2 = 10, MaskValueAddition2 = 30,
					SpecialScorePose = "PlayerMediumScorePoseAlt",

					SkillTreeA = "PlayerMediumA",
					SkillTreeB = "PlayerMediumB",

					MusicTheme = "/Music/UrsaIdea8_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,

					XP = 1200,
					TotalXP = 1200,
					Level = 2,
				},

				-- IgnariusMP [11]
				{
					Archetype = "PlayerLarge",
					Tags = { "Story_TemperMP" },
					Gender = "male",
					FirstName = "Rivals_Captain04_FirstName",
					StartingTrait = "Temper01",
					Backstory = "Rivals_Temper_Backstory_Complete",
					Past = "Rivals_Temper_Past",
					Reason = "Rivals_Temper_Reason",
					Reputation = "Temper_Reputation_01",
					YearsExiled = 14,
					Birthday = { Month = "mJune", Date = 2 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop4",

					Portrait = "DemonIgnarius01_Robed",
					RobedPortrait = "DemonIgnarius01_Robed",
					SmallPortrait = "DemonIgnarius01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Ignarius/",

					DraftedSpeech = "/VO/Match_109",
					ScoringSpeechLines = { "/VO/Match_491", "/VO/Match_492", "/VO/Match_493", },
					ThrowScoringSpeechLines = { "/VO/Match_890", "/VO/Match_891", "/VO/Match_892" },
					BanishedSpeechLines = { "/VO/Match_494", "/VO/Match_495", "/VO/Match_496", "/VO/Match_497" },
					UseVictoryVO = true,
					SpecialScorePose = "PlayerIgnariusScorePose",

					MatchScale = 1.10,
					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -2,
					PlayerAttributeSpeedModifier = 0,
					StartingSkills = { "TauntScoreSkill10", "EvadeStun" },
					ScoreValue = 25,

					MaskHue = 80, MaskSaturationAddition = 0, MaskValueAddition = -60,
					MaskHue2 = 190, MaskSaturationAddition2 = 10, MaskValueAddition2 = -50,

					SkillTreeA = "PlayerLargeA",
					SkillTreeB = "PlayerLargeB",

					EventEnterSound = "/SFX/World Sounds/DemonEnter",
					EventExitSound = "/SFX/World Sounds/DemonEnter",
					MusicTheme = "/Music/MatchMusic4_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,

					XP = 3450,
					TotalXP = 3450,
					Level = 3,
				},

				-- BarkerMP [12]
				{
					Archetype = "PlayerSmall",
					Tags = { "Story_DissidentMP" },
					Gender = "male",
					FirstName = "Rivals_Captain14_FirstName",
					TooltipIds = { FirstName = "Rivals_Captain14_FullName", ShortName = "Rivals_Captain14_FullName", LastName = "Rivals_Captain14_FullName", LongName = "Rivals_Captain14_FullName", FullName = "Rivals_Captain14_FullName" },
					StartingTrait = "Dissident01",
					Past = "Rivals_Dissident_Past",
					Reason = "Rivals_Dissident_Reason",
					Backstory = "Rivals_Dissident_Backstory_Complete",
					Reputation = "Dissident_Reputation_01",
					YearsExiled = 4,
					Birthday = { Month = "mDecember", Date = 12 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop3",
					TextSpeedMultiplier = 0.8,
					Portrait = "CurBarker01_Robed",
					RobedPortrait = "CurBarker01_Robed",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Barker/",
					DraftedSpeech = "/VO/Match_104",
					ScoringSpeechLines = { "/VO/Match_455", "/VO/Match_456", "/VO/Match_457", },
					ThrowScoringSpeechLines = { "/VO/Match_875", "/VO/Match_876", "/VO/Match_877" },
					BanishedSpeechLines = { "/VO/Match_458", "/VO/Match_459", "/VO/Match_460", "/VO/Match_461", "/VO/Match_462" },
					TauntSoundLong = "/SFX/Player Sounds/Vocalizations/Barker/EmoteLongHowl",
					TauntSound = "/SFX/Player Sounds/Vocalizations/Barker/EmoteShortHowl",
					VictoryScreenPortrait = "CurBarker01_Robed",
					SmallPortrait = "CurBarker02_Small",
					SpecialScorePose="PlayerSmallScorePoseAlt",

					MatchScale = 1.15,
					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -1,
					PlayerAttributeSpeedModifier = 0,
					StartingSkills = { "SprintSpeed" },

					MaskHue = 20, MaskSaturationAddition = -0, MaskValueAddition = -5,
					MaskHue2 = 50, MaskSaturationAddition2 = -80,  MaskValueAddition2 = -85,

					SkillTreeA = "PlayerSmallA",
					SkillTreeB = "PlayerSmallB",

					MusicTheme = "/Music/DissidentsTheme_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,

					XP = 1150,
					TotalXP = 1150,
					Level = 2,
				},

				-- AlmerMP [13]
				{
					Archetype = "PlayerMediumAlt",
					Tags = { "Story_FateSonMP" },
					Gender = "male",
					FirstName = "Rivals_FateSon_FirstName_LocalMP",
					TooltipIds = { FirstName = "Rivals_FateSon_LongName", ShortName = "Rivals_FateSon_LongName", FullName = "Rivals_FateSon_LongName", LongName = "Rivals_FateSon_LongName", LastName = "Rivals_FateDad_LastName_Tooltip" },

					StartingTrait = "FateSon01",
					Backstory = "Rivals_FateSon_Backstory_Complete",
					Past = "Rivals_FateSon_Past",
					Reason = "Rivals_FateSon_Reason",
					Reputation = "FateSon_Reputation_01",
					YearsExiled = 5,
					Birthday = { Month = "mJune", Date = 30 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop3",

					Portrait = "NomadAlmer01_Robed",
					RobedPortrait = "NomadAlmer01_Robed",
					SmallPortrait = "NomadAlmer01_Small",
					DraftedSpeech = "/VO/Match_103",
					ScoringSpeechLines = { "/VO/Match_448", "/VO/Match_449", "/VO/Match_450", },
					ThrowScoringSpeechLines = { "/VO/Match_872", "/VO/Match_873", "/VO/Match_874" },
					BanishedSpeechLines = { "/VO/Match_451", "/VO/Match_452", "/VO/Match_453", "/VO/Match_454" },
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Almer/",
					VoiceUseTeamPostfix = false,
					UseVictoryVO = true,
					SpecialScorePose = "PlayerMediumAltScorePoseAlt",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = 0,
					PlayerAttributeSpeedModifier = -1,

					StartingSkills = { "TossSkillMediumAlt" },

					MaskHue = 290, MaskSaturationAddition = -30, MaskValueAddition = -25,
					MaskHue2 = 40, MaskSaturationAddition2 = -40, MaskValueAddition2 = 40,

					SkillTreeA = "PlayerMediumAltA",
					SkillTreeB = "PlayerMediumAltB",

					MusicTheme = "/Music/MatchMusic7_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,

					XP = 1200,
					TotalXP = 1200,
					Level = 2,
				},

				-- DalbertMP [14]
				{
					Archetype = "PlayerSmall",
					Tags = { "Story_FateDadMP" },
					FirstName = "Rivals_FateDad_FirstName",
					LastName = "Rivals_FateDad_LastName",
					LongName = "Rivals_FateDad_FullName",
					TooltipIds = { FirstName = "Rivals_FateDad_FullName", ShortName = "Rivals_FateDad_FullName", LongName = "Rivals_FateDad_FullName", FullName = "Rivals_FateDad_FullName", LastName = "Rivals_FateDad_LastName_Tooltip" },
					Gender = "male",

					StartingTrait = "FateDad01",
					Backstory = "Rivals_FateDad_Backstory_Complete",
					Past = "Rivals_FateDad_Past",
					Reason = "Rivals_FateDad_Reason",
					Reputation = "FateDad_Reputation_01",
					YearsExiled = 5,
					Birthday = { Month = "mOctober", Date = 1 },

					Portrait = "CurDalbert01_Robed",
					RobedPortrait = "CurDalbert01_Robed",
					SmallPortrait = "CurDalbert01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Dalbert/",
					MusicTheme = "/Music/MatchMusic7_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,

					DraftedSpeech = "/VO/Match_102",
					ScoringSpeechLines = { "/VO/Match_441", "/VO/Match_442", "/VO/Match_443", },
					ThrowScoringSpeechLines = { "/VO/Match_869", "/VO/Match_870", "/VO/Match_871" },
					BanishedSpeechLines = { "/VO/Match_444", "/VO/Match_445", "/VO/Match_446", "/VO/Match_447" },
					TauntSoundLong = "/SFX/Player Sounds/Vocalizations/Dalbert/EmoteLongHowl",
					TauntSound = "/SFX/Player Sounds/Vocalizations/Dalbert/EmoteShortHowl",
					UseVictoryVO = true,
					SpecialScorePose = "PlayerSmallScorePoseAlt",

					SkillTreeA = "PlayerSmallA",
					SkillTreeB = "PlayerSmallB",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = 2,
					PlayerAttributeSpeedModifier = 5,
					--ScoreValue = 15,

					MaskHue = 290, MaskSaturationAddition = -30, MaskValueAddition = -25,
					MaskHue2 = 40, MaskSaturationAddition2 = -40, MaskValueAddition2 = 40,

					StartingSkills = { "InstantRespawn", "SacrificeScoreRespawn100" },

					MusicTheme = "/Music/MatchMusic7_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,

					XP = 3800,
					TotalXP = 3800,
					Level = 3,

				},

				-- DelugeMP [15]
				{
					Archetype = "PlayerTrail",
					Tags = { "Story_PyreheartMP" },
					SurName = "Worm_Honorific_Male",
					FirstName = "Rivals_Captain09_FirstName",
					LastName = "Rivals_Captain09_FirstName",
					TooltipIds = { FirstName = "Rivals_Captain09_LongName", ShortName = "Rivals_Captain09_LongName", FullName = "Rivals_Captain09_LongName" },
					StartingTrait = "Pyreheart01",
					Backstory = "Rivals_Pyreheart_Backstory_Complete",
					Past = "Rivals_Pyreheart_Past",
					Reason = "Rivals_Pyreheart_Reason",
					Reputation = "Pyreheart_Reputation_01",
					YearsExiled = 3,
					Birthday = { Month = "mJanuary", Date = 16 },
					TextSpeedMultiplier = 0.9,
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop3",
					Portrait = "WyrmDeluge01_Robed",
					RobedPortrait = "WyrmDeluge01_Robed",
					SmallPortrait = "WyrmDeluge01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Deluge/",
					DraftedSpeech = "/VO/Match_106",
					ScoringSpeechLines = { "/VO/Match_470", "/VO/Match_471", "/VO/Match_472", },
					ThrowScoringSpeechLines = { "/VO/Match_881", "/VO/Match_882", "/VO/Match_883" },
					BanishedSpeechLines = { "/VO/Match_473", "/VO/Match_474", "/VO/Match_475", "/VO/Match_476" },
					UseVictoryVO = true,
					SpecialScorePose = "PlayerTrailScorePoseAlt",

					PlayerAttributeAuraModifier = 10,
					PlayerAttributeRespawnModifier = -2,
					PlayerAttributeSpeedModifier = -4,

					MatchScale = 0.78,
					ScoreValue = 15,
					StartingSkills = { "TauntTimeout", "TrailExplosion", "KillsRespawnFriends100" },

					Height = 2.5,

					MaskHue = 170, MaskSaturationAddition = 0, MaskValueAddition = -20,
					MaskHue2 = 0, MaskSaturationAddition2 = 10, MaskValueAddition2 = 30,

					SkillTreeA = "PlayerTrailA",
					SkillTreeB = "PlayerTrailB",

					EventEnterSound = "/SFX/World Sounds/WyrmEnter",
					EventExitSound = "/SFX/World Sounds/WyrmEnter",
					MusicTheme = "/Music/MatchMusic8_MC",
					MusicStemName = "Drums",
					MusicStemValue = 1,

					XP = 5200,
					TotalXP = 5200,
					Level = 4,
				},

				-- TamithaMP [16]
				{
					Archetype = "PlayerFlying",
					Tags = { "Story_EssenceMP" },
					Gender = "female",
					FirstName = "Rivals_Captain07_FirstName",
					LastName = "Rivals_Captain07_LastName",
					LongName = "Rivals_Captain07_LongName",
					TooltipIds = { FirstName = "Rivals_Captain07_LongName", ShortName = "Rivals_Captain07_LongName", FullName = "Rivals_Captain07_LongName", LastName = "Chars_Vamp_LastName_Tooltip" },
					Portrait = "HarpTamitha01_Robed",
					RobedPortrait = "HarpTamitha01_Robed",
					SmallPortrait = "HarpTamitha01_Small",
					StartingTrait = "Essence01",
					Backstory = "Rivals_Essence_Backstory_Complete",
					Past = "Rivals_Captain07_Past",
					Reason = "Rivals_Captain07_Reason",
					Reputation = "Essence_Reputation_01",
					YearsExiled = 7,
					Birthday = { Month = "mFebruary", Date = 1 },
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Tamitha/",
					DraftedSpeech = "/VO/Match_107",
					ScoringSpeechLines = { "/VO/Match_477", "/VO/Match_478", "/VO/Match_479", },
					ThrowScoringSpeechLines = { "/VO/Match_884", "/VO/Match_885", "/VO/Match_886" },
					BanishedSpeechLines = { "/VO/Match_480", "/VO/Match_481", "/VO/Match_482", "/VO/Match_483" },
					UseVictoryVO = true,
					SpecialScorePose = "PlayerFlyingScorePoseAlt",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -2,
					PlayerAttributeSpeedModifier = -1,

					StartingSkills = { "CastExplosion" },

					MaskHue = 160, MaskSaturationAddition = -10, MaskValueAddition = -50,
					MaskHue2 = 270, MaskSaturationAddition2 = -20, MaskValueAddition2 = 20,

					SkillTreeA = "PlayerFlyingA",
					SkillTreeB = "PlayerFlyingB",

					MusicTheme = "/Music/EssenceTheme_MC",
					MusicStemName = "Drums",
					MusicStemValue = 1,

					XP = 1300,
					TotalXP = 1300,
					Level = 2,
				},

				-- ManleyMP [17]
				{
					Archetype = "PlayerTree",
					Tags = { "Story_ChastityMP" },
					Gender = "male",
					FirstName = "Rivals_Captain05_FirstName",
					FirstInitial = "Rivals_Captain05_FirstInitial",
					MiddleName = "Rivals_Captain05_MiddleName",
					MiddleInitial = "Rivals_Captain05_MiddleInitial",
					LastName = "Rivals_Captain05_LastName",
					TooltipIds = { FirstName = "Rivals_Captain05_LongName", FullName = "Rivals_Captain05_LongName", ShortName = "Rivals_Captain05_LongName", LastName = "Rivals_Captain05_LongName", LongName = "Rivals_Captain05_LongName", SaplingName = "RivalChastity_SaplingName" },
					StartingTrait = "Chastity01",
					Backstory = "Rivals_Chastity_Backstory_Complete",
					Past = "Rivals_Chastity_Past",
					Reason = "Rivals_Chastity_Reason",
					Reputation = "Chastity_Reputation_01",
					YearsExiled = 20,
					Birthday = { Month = "mJune", Date = 20 },
					Portrait = "SapManley01_Robed",
					RobedPortrait = "SapManley01_Robed",
					SmallPortrait = "SapManley01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Manley/",
					DraftedSpeech = "/VO/Match_108",
					ScoringSpeechLines = { "/VO/Match_484", "/VO/Match_485", "/VO/Match_486", },
					ThrowScoringSpeechLines = { "/VO/Match_887", "/VO/Match_888", "/VO/Match_889" },
					BanishedSpeechLines = { "/VO/Match_487", "/VO/Match_488", "/VO/Match_489", "/VO/Match_490" },
					UseVictoryVO = true,

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = -2,
					PlayerAttributeSpeedModifier = -1,
					ScoreValue = 20,

					StartingSkills = { "TauntSaplingExplode", "TeamHeadWinds" },

					MaskHue = 345, MaskSaturationAddition = -30, MaskValueAddition = 30,
					MaskHue2 = 40, MaskSaturationAddition2 = 20,  MaskValueAddition2 = 30,

					SkillTreeA = "PlayerTreeA",
					SkillTreeB = "PlayerTreeB",

					EventEnterSound = "/SFX/World Sounds/SapEnter",
					EventExitSound = "/SFX/World Sounds/SapEnter",
					MusicTheme = "/Music/MatchMusic3_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,

					XP = 3875,
					TotalXP = 3875,
					Level = 3,

				},

				-- SandraMP [18]
				{
					Archetype = "PlayerMedium",
					Tags = { "Story_BeyonderMP" },
					Gender = "female",
					FirstName = "Rivals_Captain17_FirstName",
					TitlePostFix = "Nomad_Title_07",
					TooltipIds = { FirstName = "Rivals_Captain17_FullName", ShortName = "Rivals_Captain17_FullName", FullName = "Rivals_Captain17_FullName" },
					-- FullName = "Name_Phantom",
					StartingTrait = "Beyonder01",
					Backstory = "Rivals_Beyonder_Backstory_Complete",
					Past = "Rivals_Beyonder_Past",
					Reason = "Rivals_Beyonder_Reason",
					Reputation = "Beyonder_Reputation_01",
					YearsExiled = 837,
					Birthday = { Month = "mJuly", Date = 1 },
					Portrait = "NomadSandra01_Robed",
					RobedPortrait = "NomadSandra01_Robed",
					SmallPortrait = "NomadSandra01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Sandra/",

					MusicTheme = "/Music/MatchMusic2_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,

					DraftedSpeech = "/VO/Match_111",
					ScoringSpeechLines = { "/VO/Match_505", "/VO/Match_506", "/VO/Match_507", },
					ThrowScoringSpeechLines = { "/VO/Match_893", "/VO/Match_894", "/VO/Match_895" },
					BanishedSpeechLines = { "/VO/Match_508", "/VO/Match_509", "/VO/Match_510", "/VO/Match_511" },
					VoiceUseTeamPostfix = false,
					UseVictoryVO = true,
					SpecialScorePose = "PlayerMediumScorePoseAlt",

					SkillTreeA = "PlayerMediumA",
					SkillTreeB = "PlayerMediumB",

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = 2,
					PlayerAttributeSpeedModifier = 0,

					ScoreValue = 15,
					StartingSkills = { "TeamStaminaRechargeSkill", "TeamBallSkill", "TeamReviveSkill", "TeamEnemyBanishTime" },

					-- Campaign Beyonders Colors
					MaskHue = 70, MaskSaturationAddition = -40, MaskValueAddition = 80,
					MaskHue2 = 100, MaskSaturationAddition2 = -60, MaskValueAddition2 = 70,
					-- Alt Beyonders Colors
					-- MaskHue = 20, MaskSaturationAddition = -40, MaskValueAddition = -90,
					-- MaskHue2 = 150, MaskSaturationAddition2 = -20, MaskValueAddition2 = -30,

					MusicTheme = "/Music/MatchMusic2_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,

					XP = 10000,
					TotalXP = 10000,
					Level = 5,

				},

				-- OralechMP [19]
				{
					Archetype = "PlayerLarge",
					Tags = { "Story_NightwingMP" },
					Gender = "male",
					FirstName = "Rivals_Nightwing_FirstName",
					StartingTrait = "Nightwing01",
					Backstory = "Rivals_Nightwing_Backstory_Complete",
					Past = "Rivals_Nightwing_Past",
					Reason = "Rivals_Nightwing_Reason",
					Reputation = "Nightwing_Reputation_01",
					YearsExiled = 18,
					TextSpeedMultiplier = 1.1,
					Birthday = { Month = "mAugust", Date = 10 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop4",
					Portrait = "DemonOralech01_Robed",
					RobedPortrait = "DemonOralech01_Robed",
					SmallPortrait = "DemonOralech01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Oralech/",
					MusicTheme = "/Music/MatchMusic5_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,
					DraftedSpeech = "/VO/Match_110",
					ScoringSpeechLines = { "/VO/Match_498", "/VO/Match_499", "/VO/Match_500", },
					ThrowScoringSpeechLines = { "/VO/Match_896", "/VO/Match_897", "/VO/Match_898" },
					BanishedSpeechLines = { "/VO/Match_501", "/VO/Match_502", "/VO/Match_503", "/VO/Match_504" },
					UseVictoryVO = true,
					SpecialScorePose = "PlayerOralechScorePose",
					SpecialAuraTurnOn = "PlayerOralechAuraTurnOn",
					SpecialTauntAnimation = "PlayerOralechAuraTurnOn",
					MoveGraphic = "PlayerLargeRun",
					StartGraphic = "PlayerLargeStartSpecial",
					SprintFireGraphic = "PlayerLargeJumpSpecial",

					SkillTreeA = "PlayerLargeA",
					SkillTreeB = "PlayerLargeB",

					EventEnterSound = "/SFX/World Sounds/DemonEnter",
					EventExitSound = "/SFX/World Sounds/DemonEnter",
					ScoreValue = 25,

					MaskHue = 10, MaskSaturationAddition = 0,  MaskValueAddition = -20,
					MaskHue2 = 210, MaskSaturationAddition2 = -40, MaskValueAddition2 = -45,

					StartingSkills = { "PlusPresenceSkill", "AuraSpikeKill" },

					PlayerAttributeAura = 36,
					PlayerAttributeRespawn = 1,
					PlayerAttributeSpeed = 20,

					MusicTheme = "/Music/MatchMusic5_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,

					XP = 3700,
					TotalXP = 3700,
					Level = 3,
				},

				-- MessengerImpMP / HaubMP / Messenger Imp [20]
				{
					Archetype = "PlayerImp",
					Tags = { "Story_ImpMP" },
					Gender = "male",
					FirstName = "NPC_Imp",

					StartingTrait = "MessengerImp01",
					Backstory = "NPCs_MessengerImp_Backstory_Complete",
					Past = "NPCs_MessengerImp_Past",
					Reason = "NPCs_MessengerImp_Reason",
					Reputation = "Imp_Reputation_01",
					TooltipIds = { YearsExiled = "YearsExiled_Alt_Tooltip" },
					Birthday = { Month = "mApril", Date = 20 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop3",
					TextSpeedMultiplier = 0.8,

					Portrait = "ImpMessenger01_Robed",
					RobedPortrait = "ImpMessenger01_Robed",
					SmallPortrait = "NPC_Imp_01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Imp_01/",
					StartingTrait = "Mascot01",
					StartingSkills = { "Beacon", "TauntFeralImp", "OnDeathExplosion", "AnyScoreSkill" },
					DraftedSpeech = "/VO/Match_607",
					ScoringSpeechLines = { "/VO/Match_265", "/VO/Match_899", "/VO/Match_900", "/VO/Match_901" },
					ThrowScoringSpeechLines = { "/VO/Match_902", "/VO/Match_903", "/VO/Match_904" },
					BanishedSpeechLines = { "/VO/Match_270", "/VO/Match_905", "/VO/Match_906", "/VO/Match_907", "/VO/Match_908", },
					Height = 1,
					SpecialScorePose = "PlayerImpScorePoseAlt",

					MaskHue = 0, MaskSaturationAddition = 0, MaskValueAddition = -20,
					MaskHue2 = 40, MaskSaturationAddition2 = 0,  MaskValueAddition2 = -20,

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = 4,
					PlayerAttributeSpeedModifier = -2,

					SkillTreeA = "PlayerImpA",
					SkillTreeB = "PlayerImpB",

					MusicTheme = "/Music/ImpTheme_MC",
					MusicStemName = "Drums",
					MusicStemValue = 2,

					XP = 10000,
					TotalXP = 10000,
					Level = 5,
				},

				-- UdmildheMP [21]
				{
					Archetype = "PlayerMonster",
					Tags = { "Story_WithdrawnMP" },

					Gender = "female",
					SurName = "Rivals_Captain13_Surname",
					FirstName = "Rivals_Captain13_FirstName",
					LastName = "Rivals_Captain13_FirstName",
					TooltipIds = { FirstName = "Rivals_Captain13_LongName", ShortName = "Rivals_Captain13_LongName", FullName = "Rivals_Captain13_LongName", LongName = "Rivals_Captain13_LongName" },

					StartingTrait = "Withdrawn01",
					Backstory = "Rivals_Withdrawn_Backstory_Complete",
					Past = "Rivals_Withdrawn_Past",
					Reason = "Rivals_Withdrawn_Reason",
					Reputation = "Withdrawn_Reputation_01",
					YearsExiled = 52,
					Birthday = { Month = "mJanuary", Date = 16 },
					PrintingSound = "/SFX/Menu Sounds/DialogueLoop5",
					TextSpeedMultiplier = 1.25,

					Portrait = "CroneUdmildhe01_Robed",
					RobedPortrait = "CroneUdmildhe01_Robed",
					SmallPortrait = "CroneUdmildhe01_Small",
					VoicePrefix = "/SFX/Player Sounds/Vocalizations/Udmildhe/",
					SpecialScorePose = "PlayerMonsterScorePoseAlt",

					Traits = { },

					DraftedSpeech = "/VO/Match_105",
					ScoringSpeechLines = { "/VO/Match_463", "/VO/Match_464", "/VO/Match_465", },
					ThrowScoringSpeechLines = { "/VO/Match_878", "/VO/Match_879", "/VO/Match_880" },
					BanishedSpeechLines = { "/VO/Match_466", "/VO/Match_467", "/VO/Match_468", "/VO/Match_469" },
					UseVictoryVO = true,

					PlayerAttributeAuraModifier = 0,
					PlayerAttributeRespawnModifier = 1,
					PlayerAttributeSpeedModifier = -2,

					StartingSkills = { "CastMonsterSkill", "TauntPolymorphSide" },

					MaskHue = 75, MaskSaturationAddition = -30, MaskValueAddition = -25,
					MaskHue2 = 128, MaskSaturationAddition2 = -40, MaskValueAddition2 = 60,

					SkillTreeA = "PlayerMonsterA",
					SkillTreeB = "PlayerMonsterB",

					EventEnterSound = "/SFX/World Sounds/CroneEnter",
					EventExitSound = "/SFX/World Sounds/CroneEnter",
					MusicTheme = "/Music/WithdrawnTheme_MC",
					MusicStemName = "Guitars",
					MusicStemValue = 1,

					XP = 3550,
					TotalXP = 3550,
					Level = 3,
				},

			}
		},
	}

	PlayerData.Teams[13] = DeepCopyTable( PlayerData.Teams[12] )
	local mpOpponentTeam = PlayerData.Teams[13]

	for k, character in pairs( mpOpponentTeam.TeamBench ) do
		for j, tagName in pairs( character.Tags ) do
			character.Tags[j] = tagName.."_Alt"
		end
	end

	-- Patch any missing character data into a save game
	-- Assumes nothing is intentionally set to nil
	ReloadCharacterData( true )
	ReloadTeams( true )
	ReloadTeam( 12 )
	ReloadTeam( 13 )
	ReloadGuideBook( true )
	ReloadConstellationStars( true )
	ReloadLocalizationData()

	-- NPC Data
	PlayerData.NPCs =
	{
		-- Tariq, the Lone Minstrel
		CharBard =
		{
			Tags = { "Story_Bard" },
			Gender = "male",
			FirstName = "Chars_Bard_FirstName",
			Title = "Chars_Bard_Title",
			LongName = "Chars_Bard_LongName",
			FullName = "Chars_Bard_LongName",
			ShortName = "BardHiddenName",
			ShortNameNF = "BardHiddenName",
			TooltipIds = { FirstName = "Chars_Bard_LongName", FullName = "Chars_Bard_LongName", ShortName = "Chars_Bard_LongName" },
			Portrait = "Bard_M_01",
			RobedPortrait = "Bard_M_01",
			SmallPortrait = "Bard_M_01_Small",
			AttractQuip = "/VO/Bard_0163__11",
			MusicTheme = "/Music/BardTheme_MC",
			MusicStemName = "Drums",
			MusicStemValue = 1,
			CaravanOffsetX = 0,
			CaravanOffsetY = 0,
			EpilogueEvents = { "Epilogue_Bards_01" },
			CurrentStatusesA = { "Status_A_Bard_01", "Status_A_Bard_02", "Status_A_Bard_03", "Status_A_Bard_04", "Status_A_Bard_05", "Status_A_Bard_06", "Status_A_Bard_07", "Status_A_Bard_08", "Status_A_Bard_09", "Status_A_Bard_10", "Status_A_Bard_11", "Status_A_Bard_12", "Status_A_Bard_13", "Status_A_Bard_14", "Status_A_Bard_15", "Status_A_Bard_16" },
			CurrentStatusesW = { "Status_W_Bard_01", "Status_W_Bard_02", "Status_W_Bard_03", "Status_W_Bard_04", "Status_W_Bard_05", "Status_W_Bard_06", "Status_W_Bard_07", "Status_W_Bard_08", "Status_W_Bard_09", "Status_W_Bard_10", "Status_W_Bard_11", "Status_W_Bard_12", "Status_W_Bard_13", "Status_W_Bard_14", "Status_W_Bard_15", },
			CurrentStatusesR = { "Status_R_Bard_01", "Status_R_Bard_02", "Status_R_Bard_03", "Status_R_Bard_04", "Status_R_Bard_05", "Status_R_Bard_06", "Status_R_Bard_07", "Status_R_Bard_08", "Status_R_Bard_09", "Status_R_Bard_10" },
			CurrentStatusesI = { "Status_I_Bard_01", "Status_I_Bard_02", "Status_I_Bard_03", "Status_I_Bard_04", "Status_I_Bard_05", "Status_I_Bard_06", "Status_I_Bard_07" },
			CurrentStatusesN = { "Status_N_Bard_01", "Status_N_Bard_02", "Status_N_Bard_03", "Status_N_Bard_04", "Status_N_Bard_05", "Status_N_Bard_06", "Status_N_Bard_07", "Status_N_Bard_08", "Status_N_Bard_09", "Status_N_Bard_10", },
			Height = 7.5,
		},
		-- Scrivener Celeste
		CharRivalBard =
		{
			Tags = { "Story_RivalBard" },
			Gender = "female",
			FirstName = "Chars_RivalBard_FirstName",
			Title = "Chars_RivalBard_Title",
			FullName = "Chars_RivalBard_FullName",
			ShortName = "Chars_RivalBard_LongName",
			TooltipIds = { FirstName = "Chars_RivalBard_FullName", FullName = "Chars_RivalBard_FullName", ShortName = "Chars_RivalBard_FullName" },
			Portrait = "Bard_F_01",
			RobedPortrait = "Bard_F_01",
			SmallPortrait = "Bard_F_01_Small",
			MusicTheme = "/Music/BardTheme_MC",
			MusicStemName = "Drums",
			MusicStemValue = 2,
			EpilogueEvents = { "Epilogue_Bards_01" },
			Height = 7.4
		},
		-- Falcon Ron
		CharShopKeeper =
		{
			Tags = { "Story_ShopKeeper" },
			Gender = "male",
			FirstName = "Chars_ShopKeeper_FirstName",
			Title = "Chars_ShopKeeper_Title",
			FullName = "Chars_ShopKeeper_ShortName",
			ShortName = "Chars_ShopKeeper_ShortName",
			ShortNameNF = "Chars_ShopKeeper_ShortName",
			TooltipIds = { FirstName = "Chars_ShopKeeper_FirstName", FullName = "Chars_ShopKeeper_ShortName", ShortName = "Chars_ShopKeeper_ShortName" },
			Portrait = "ShopKeeper01",
			RobedPortrait = "ShopKeeper01",
			SmallPortrait = "ShopKeeper01_Small",
			EventEnterSound = "/SFX/World Sounds/RonEnter",
			EventExitSound = "/SFX/World Sounds/RonEnter",
			MusicTheme = "/Music/ShopkeeperTheme_MC",
			MusicStemName = "Misc",
			MusicStemValue = 1,

			ItemPickupLines = { },
			ItemSmallPurchaseLines = { },
			ItemMediumPurchaseLines = { },
			ItemBigPurchaseLines = { },
			ItemDroppedLines = { },
			ItemSmallBuybackLines = { },
			ItemMediumBuybackLines = { },
			ItemLargeBuybackLines = { },
			NoMoneyLines = { "/VO/ShopKeeper_168_", "/VO/ShopKeeper_168__1", "/VO/ShopKeeper_168__2", "/VO/ShopKeeper_168__3", "/VO/ShopKeeper_168__4", "/VO/ShopKeeper_168__5", "/VO/ShopKeeper_168__6", "/VO/ShopKeeper_168__7", "/VO/ShopKeeper_168__8", "/VO/ShopKeeper_168__9", "/VO/ShopKeeper_168__10", "/VO/ShopKeeper_168__11", "/VO/ShopKeeper_168__12", "/VO/ShopKeeper_168__13" },
			QuickExitLines = {},
			LowSpendExitLines = {},
			MedSpendExitLines = {},
			BigSpendExitLines = {},

			EpilogueRemainedEvent = "Epilogue_ShopKeeper_Remained_01",
			EpilogueRivalCharTag = "Story_Joker",
			EpilogueRemainedWithRivalEvent = "Epilogue_ShopKeeper_WithRival_Remained_01",
			EpilogueWithoutRivalEvent = "Epilogue_ShopKeeper_WithoutRival_Remained_01",

		},
		-- Bog Dweller
		CharBogDweller =
		{
			Tags = { "Story_BogDweller" },
			ShortName = "NPC_BogDweller",
			Portrait = "NPC_Bogdweller_01",
			RobedPortrait = "NPC_Bogdweller_01",
			EventEnterSound = "/SFX/World Sounds/CroneEnter",
			EventExitSound = "/SFX/World Sounds/CroneEnter",
		},
		-- Shade
		CharWraith =
		{
			Tags = { "Story_Wraith" },
			ShortName = "NPC_Wraith",
			Portrait = "NPC_Wraith_01",
			RobedPortrait = "NPC_Wraith_01",
			SmallPortrait = "NPC_Wraith_01_Small",
			EventEnterSound = "/SFX/Match SFX/PlayerRespawnNEW",
			EventExitSound = "/SFX/Match SFX/AuraOn",
		},
		-- Harp
		CharHarp =
		{
			Tags = { "Story_Harp" },
			Gender = "female",
			ShortName = "NPC_Harp",
			Portrait = "NPC_Harp_01",
			RobedPortrait = "NPC_Harp_01",
			EventEnterSound = "/SFX/World Sounds/PickUpFlyAwayLEFT",
			EventExitSound = "/SFX/World Sounds/PickUpFlyAwayRIGHT",
		},
		-- Messenger Imp
		CharMessenger =
		{
			Tags = { "Story_Messenger" },
			Gender = "male",
			ShortName = "NPC_Imp",
			Portrait = "NPC_Imp_01",
			SmallPortrait = "NPC_Imp_01_Small",
			RobedPortrait = "NPC_Imp_01",
			TooltipIds = { FirstName = "NPC_Imp", FullName = "NPC_Imp", ShortName = "NPC_Imp" },
		},
		-- Brighton
		CharAscended =
		{
			Tags = { "Story_NightwingAscended" },
			Gender = "male",
			ShortName = "NPC_NightwingAscended",
			Portrait = "Brighton01_Small_Backstory",
			SmallPortrait = "Brighton01_Small_Backstory",
			TooltipIds = { FirstName = "NPC_NightwingAscended", FullName = "NPC_NightwingAscended", ShortName = "NPC_NightwingAscended" },
		},
		-- Erisa
		CharBetrayer =
		{
			Tags = { "Story_NightwingTraitor" },
			Gender = "female",
			ShortName = "NPC_NightwingTraitor",
			Portrait = "Erisa01_Small_Backstory",
			SmallPortrait = "Erisa01_Small_Backstory",
			TooltipIds = { FirstName = "NPC_NightwingTraitor", FullName = "NPC_NightwingTraitor", ShortName = "NPC_NightwingTraitor" },
			},
		-- Eight Scribes
		-- Soliam Murr
		ScribeDemon =
		{
			Tags = { "Story_ScribeDemon" },
			Gender = "male",
			ShortName = "NPC_ScribeDemon",
			Portrait = "ScribeDemon01_Small",
			SmallPortrait = "ScribeDemon01_Small",
			TooltipIds = { FirstName = "NPC_ScribeDemon", FullName = "NPC_ScribeDemon", ShortName = "NPC_ScribeDemon" },
		},
		-- Ha'ub the Swallow
		ScribeImp =
		{
			Tags = { "Story_ScribeImp" },
			Gender = "male",
			ShortName = "NPC_ScribeImp",
			FirstName = "NPC_ScribeImpShort",
			Portrait = "ScribeImp01_Small",
			SmallPortrait = "ScribeImp01_Small",
			TooltipIds = { FirstName = "NPC_ScribeImpShort", FullName = "NPC_ScribeImp", ShortName = "NPC_ScribeImp" },
		},
		-- Gol Golathanian
		ScribeNomad =
		{
			Tags = { "Story_ScribeNomad" },
			Gender = "male",
			ShortName = "NPC_ScribeNomad",
			Portrait = "ScribeNomad01_Small",
			SmallPortrait = "ScribeNomad01_Small",
			TooltipIds = { FirstName = "NPC_ScribeNomad", FullName = "NPC_ScribeNomad", ShortName = "NPC_ScribeNomad" },
		},
		-- Lu Sclorian
		ScribeSap =
		{
			Tags = { "Story_ScribeSap" },
			Gender = "male",
			ShortName = "NPC_ScribeSapAlt",
			FirstName = "NPC_ScribeSapAlt",
			Title = "NPC_ScribeSapTitle",
			FullName = "NPC_ScribeSap",
			Portrait = "ScribeSap01_Small",
			SmallPortrait = "ScribeSap01_Small",
			TooltipIds = { FirstName = "NPC_ScribeSap", FullName = "NPC_ScribeSap", ShortName = "NPC_ScribeSap", Title = "NPC_ScribeSap" },
		},
		-- Molten Milithe
		ScribeCrone =
		{
			Tags = { "Story_ScribeCrone" },
			Gender = "female",
			ShortName = "NPC_ScribeCrone",
			FirstName = "NPC_ScribeCroneShort",
			Portrait = "ScribeCrone01_Small",
			SmallPortrait = "ScribeCrone01_Small",
			TooltipIds = { FirstName = "NPC_ScribeCrone", FullName = "NPC_ScribeCrone", ShortName = "NPC_ScribeCrone" },
		},
		-- Saint Triesta
		ScribeHarp =
		{
			Tags = { "Story_ScribeHarp" },
			Gender = "female",
			Title = "NPC_ScribeHarpTitle",
			ShortName = "NPC_ScribeHarpAlt",
			FirstName = "NPC_ScribeHarpShort",
			FullName = "NPC_ScribeHarp",
			Portrait = "ScribeHarp01_Small",
			SmallPortrait = "ScribeHarp01_Small",
			TooltipIds = { FirstName = "NPC_ScribeHarp", FullName = "NPC_ScribeHarp", ShortName = "NPC_ScribeHarp", Title = "NPC_ScribeHarp" },
		},
		-- Jomuer Many-Mane
		ScribeCur =
		{
			Tags = { "Story_ScribeCur" },
			Gender = "male",
			ShortName = "NPC_ScribeCur",
			FirstName = "NPC_ScribeCurShort",
			Portrait = "ScribeCur01_Small",
			SmallPortrait = "ScribeCur01_Small",
			TooltipIds = { FirstName = "NPC_ScribeCur", FullName = "NPC_ScribeCur", ShortName = "NPC_ScribeCur" },
		},
		-- Underking Ores
		ScribeWyrm =
		{
			Tags = { "Story_ScribeWyrm" },
			Gender = "male",
			Title = "NPC_ScribeWyrmTitle",
			ShortName = "NPC_ScribeWyrm",
			FullName = "NPC_ScribeWyrm",
			Portrait = "ScribeWyrm01_Small",
			SmallPortrait = "ScribeWyrm01_Small",
			TooltipIds = { FirstName = "NPC_ScribeWyrm", FullName = "NPC_ScribeWyrm", ShortName = "NPC_ScribeWyrm", Title = "NPC_ScribeWyrm" },
		},
		-- Khaylmer Rope-Caller
		ScribeTraitor =
		{
			Tags = { "Story_ScribeTraitor" },
			Gender = "male",
			Title = "NPC_ScribeTraitorTitle",
			ShortName = "NPC_ScribeTraitor",
			FirstName = "NPC_ScribeTraitorShort",
			Portrait = "ScribeTraitor01_Small",
			SmallPortrait = "ScribeTraitor01_Small",
			TooltipIds = { FirstName = "NPC_ScribeTraitorShort", FullName = "NPC_ScribeTraitor", ShortName = "NPC_ScribeTraitor", Title = "NPC_ScribeTraitorShort" },
		},
		-- Archjustice
		CharArchjustice =
		{
			Tags = { "Story_Archjustice" },
			Gender = "male",
			ShortName = "NPC_Archjustice",
			Portrait = "Archjustice01_Small",
			SmallPortrait = "Archjustice01_Small",
			TooltipIds = { FirstName = "NPC_Archjustice", FullName = "NPC_Archjustice", ShortName = "NPC_Archjustice" },
		},
		-- Fikani Shang
		CharHarpFlame =
		{
			Tags = { "Story_HarpFlame" },
			Gender = "female",
			FirstName = "NPC_HarpFlame_FirstName",
			ShortName = "NPC_HarpFlame_FirstName",
			FullName = "NPC_HarpFlame_FullName",
			Portrait = "Fikani01_Small_Backstory",
			SmallPortrait = "Fikani01_Small_Backstory",
			TooltipIds = { FirstName = "NPC_HarpFlame_FirstName", FullName = "NPC_HarpFlame_FullName", ShortName = "NPC_HarpFlame_FullName" },
		},

	}

	for k, npc in pairs( PlayerData.NPCs ) do
		SetupPronouns( npc )
		SetupPortraits( npc )
		SetupBirthday( npc )
	end

	if NPCs == nil then
		NPCs = {}
		PersistVariable({ Name = "NPCs" })
		for npcName, npcData in pairs( PlayerData.NPCs ) do
			local npc = DeepCopyTable( npcData )
			NPCs[npcName] = npc
			InitTags( npc )
		end
	end

	-- Auto-create shortcut references from name (and auto-SaveIgnore them)
	for npcName, npc in pairs( NPCs ) do
		_G[npcName] = npc
		SaveIgnores[npcName] = true
	end

end }

function InitTags( character )

	-- Convert existing tags by value to by key
	if character.Tags ~= nil then
		for k, startingTag in pairs( character.Tags ) do
			AddTag( character, startingTag )
		end
		for k, startingTag in ipairs( character.Tags ) do
			character.Tags[k] = nil
		end
	else
		character.Tags = {}
	end

end

function SetTeamMask( team, hue, saturationAdd, valueAdd, hue2, saturationAdd2, valueAdd2 )

	team.MaskHue = hue
	team.MaskSaturationAddition = saturationAdd
	team.MaskValueAddition = valueAdd
	team.MaskHue2 = hue2
	team.MaskSaturationAddition2 = saturationAdd2
	team.MaskValueAddition2 = valueAdd2

	team.MaskHueRGB = HSVtoRGB( hue, 1.0 + saturationAdd / 100, 0.76 + valueAdd / 100 )
	team.MaskHueRGB2 = HSVtoRGB( hue2, 1.0 + saturationAdd2 / 100, 0.76 + valueAdd2 / 100 )

end

function ReloadCharacterData( missingOnly )

	if League == nil then
		return
	end

	for teamIndex, team in ipairs( League ) do
		local teamData = PlayerData.Teams[teamIndex]
		for characterIndex, character in ipairs( team.TeamBench ) do
			-- Save Patches
			if character.Archetype == "PlayerRegenerating" then
				character.Archetype = "PlayerTree"
				DebugPrint({ Text = "Patching PlayerRegenerating Archetype" })
			elseif character.Archetype == "PlayerCone" then
				character.Archetype = "PlayerMonster"
				DebugPrint({ Text = "Patching PlayerCone Archetype" })
			end
			if character.TooltipPortrait == nil then
				character.TooltipPortrait = character.TooltipAnim
			end
			InitXP( character )
			--DebugPrint({ Text = "characterIndex = "..characterIndex, LogOnly = true })
			--DebugPrint({ Text = "teamIndex = "..teamIndex, LogOnly = true })
			local characterData = teamData.TeamBench[characterIndex]
			if characterData ~= nil then
				for attributeName, attributeValue in pairs( characterData ) do
					if not missingOnly or character[attributeName] == nil then
						if type(attributeValue) == "table" then
							character[attributeName] = ShallowCopyTable( attributeValue )
						else
							character[attributeName] = attributeValue
						end
						--local charPosition = teamIndex.."-"..characterIndex
						--DebugPrint({ Text = charPosition.." Restored: "..attributeName.." = "..tostring(attributeValue), LogOnly = true })
					end
				end
				if not missingOnly then
					InitTags( character )
					if character.UpgradeItemName ~= nil and character.UpgradeItem == nil then
						local createdItem = CreateItem( character.UpgradeItemName )
						EquipUpgradeItem( character, createdItem )
					end
				end
			end
		end
	end

end

function ReloadTeams( missingOnly )

	if League == nil then
		return
	end

	for teamIndex, savedTeam in ipairs( League ) do
		local teamData = PlayerData.Teams[teamIndex]
		for attributeName, attributeValue in pairs( teamData ) do
			if attributeName ~= "TeamBench" then -- Characters handled seperately by ReloadCharacterData()
				if not missingOnly or savedTeam[attributeName] == nil then
					if type(attributeValue) == "table" then
						savedTeam[attributeName] = ShallowCopyTable( attributeValue )
					else
						savedTeam[attributeName] = attributeValue
					end
					--local charPosition = teamIndex.."-"..characterIndex
					--DebugPrint({ Text = charPosition.." Restored: "..attributeName.." = "..tostring(attributeValue), LogOnly = true })
				end
			end
		end
	end

end

function ReloadTeam( teamIndex )

	if League == nil then
		return
	end

	local savedTeam = League[teamIndex]
	local teamData = PlayerData.Teams[teamIndex]

	for attributeName, attributeValue in pairs( teamData ) do
		if attributeName == "TeamBench" then
			for characterIndex, character in ipairs( savedTeam.TeamBench ) do
				local characterData = teamData.TeamBench[characterIndex]
				if characterData ~= nil then
					for attributeName, attributeValue in pairs( characterData ) do
						if type(attributeValue) == "table" then
							character[attributeName] = ShallowCopyTable( attributeValue )
						else
							character[attributeName] = attributeValue
						end
					end
					SetupBirthday( character )
				end
			end
		else
			if type(attributeValue) == "table" then
				savedTeam[attributeName] = ShallowCopyTable( attributeValue )
			else
				savedTeam[attributeName] = attributeValue
			end
		end
	end

end

function AssignCharacterToString()

	if League == nil then
		return
	end

	for teamIndex, team in ipairs( League ) do
		for characterIndex, character in ipairs( team.TeamBench ) do
			character.ToString = CharacterToString
		end
	end

end

function CharacterToString( character )
	return character.FirstName
end

function SetupPronouns( character )

	if character.Gender == "male" or character.Gender == "Char_Gender_Male" then
		character.Gender = "Char_Gender_Male"
		SetMalePronouns( character )
	elseif character.Gender == "female" or character.Gender == "Char_Gender_Female" then
		character.Gender = "Char_Gender_Female"
		SetFemalePronouns( character )
	elseif character.Gender == "X" or character.Gender == "Char_Gender_X" then
		character.Gender = "Char_Gender_X"
		SeNeutralPronouns( character )
	else
		SetFemalePronouns( character )
	end

end

function SetupNames( character )

	-- Generic Names for Masked Adversaries
	if character.FirstName == nil then
		-- Naming rules for generic characters
		local charIndex = character["TeamIndex"]
		local genericName = League[charIndex].GenericExileName
		character.FirstName = genericName
		character.TooltipIds.FirstName = character.FirstName
		character.FullName = genericName
		character.TooltipIds.FullName = character.FullName
		character.ShortName = genericName
		character.TooltipIds.ShortName = character.ShortName
	else
		-- Naming Rules for manually named characers

		-- Nomads / PlayerMedium / PlayerMediumAlt
		if character.TitlePostFix ~= nil then
			local title = GetDisplayName({ Text = "Nomad_LinkWord" }).." "..GetDisplayName({ Text = character.TitlePostFix })
			character.Title = title
			character.FullName = GetDisplayName({ Text = character.FirstName }).." "..title
			character.ShortName = character.FirstName
		elseif character.LastName ~= nil then
			-- Demons / PlayerLarge and Imps / PlayerImp
			if character.Archetype == "PlayerLarge" or character.Archetype == "PlayerImp" then
				character.FullName = character.FirstName
				character.ShortName = character.FirstName
			-- Curs / PlayerSmall
			elseif character.Archetype == "PlayerSmall" then
				character.FullName = GetDisplayName({ Text = character.FirstName }).." "..GetDisplayName({ Text = character.LastName })
				character.ShortName = character.FirstName
			-- Saps / PlayerTree
			elseif character.Archetype == "PlayerTree" then
				character.FullName = GetDisplayName({ Text = character.FirstInitial }).." "..GetDisplayName({ Text = character.MiddleName }).." "..GetDisplayName({ Text = character.LastName })
				character.LongName = GetDisplayName({ Text = character.MiddleName }).." "..GetDisplayName({ Text = character.LastName })
				character.ShortName = character.MiddleName
				character.HiddenFirstName = character.FirstName
				character.FirstName = character.ShortName
			-- Wyrms / PlayerTrail
			elseif character.Archetype == "PlayerTrail" then
				local surname = GetDisplayName({ Text = character.SurName })
				if surname ~= nil then
					character.FullName = surname.." "..GetDisplayName({ Text = character.FirstName })
					character.ShortName = character.FullName
				end
			-- Crones / PlayerMonster
			elseif character.Archetype == "PlayerMonster" then
				local surname = GetDisplayName({ Text = character.SurName })
				if surname ~= nil then
					character.FullName = surname.." "..GetDisplayName({ Text = character.FirstName })
					character.ShortName = character.FirstName
				end
			else
				if character.FirstName ~= nil and character.LastName ~= nil then
					character.FullName = GetDisplayName({ Text = character.FirstName }).." "..GetDisplayName({ Text = character.LastName })
				elseif character.FirstName ~= nil and character.LastName == nil then
					character.FullName = character.FirstName
				end
				character.ShortName = character.FirstName
			end
		elseif character.FirstName ~= nil then
			character.FullName = character.FirstName
		end
	end

	if character.ShortName == nil then
		character.ShortName = character.FullName
		character.TooltipIds.ShortName = character.ShortName
	end

	if character.NickName == nil then
		character.NickName = character.ShortName
		character.TooltipIds.NickName = character.NickName
	end

	-- 'NeverFormat' version of names
	character.ShortNameNF = character.ShortName

end

function SetupPortraits( character )
	if character.Portrait ~= nil then
		-- nil check so this can be overridden in data
		if character.RobedPortrait == nil then
			if string.find( character.Portrait, "Robed" ) == nil then
				character.RobedPortrait = character.Portrait.."_Robed"
			else
				character.RobedPortrait = character.Portrait
			end
		end
		if character.SmallPortrait == nil then
			character.SmallPortrait = character.Portrait.."_Small"
		end
		character.TooltipPortraitScale = 0.8
		if character.VictoryScreenPortrait == nil then
			character.VictoryScreenPortrait = character.RobedPortrait
		end
		if character.ForfeitVictoryScreenPortrait == nil then
			character.ForfeitVictoryScreenPortrait = character.RobedPortrait
		end
		character.TooltipPortrait = character.SmallPortrait
	end
end

function SetupBio( character )
	if character == nil then
		return
	end

	character.Birthday.RevealedBirthSign = character.Birthday.BirthSign
	character.RevealedPast = character.Past
	character.RevealedReason = character.Reason
	character.RevealedYearsExiled = character.YearsExiled

	if character.Reputation == nil then
		character.Reputation = "Bio_DescriptionHeader_01"
		if character.TeamIndex ~= 1 then
			character.Reputation = League[character.TeamIndex].GenericReputation
		end
	end

	if character.BackstoryHeader == nil then
		character.BackstoryHeader = "Bio_ObservationsHeader_01"
		if character.TeamIndex == 12 or character.TeamIndex == 13 then
			character.BackstoryHeader = "Bio_ObservationsHeader_02"
		end
	end

	-- don't hide roster data for LocalMP teams
	if character.TeamIndex ~= 12 and character.TeamIndex ~= 13 then
		character.Birthday.BirthSign = "HiddenBirthSign"
		if character.Birthday.TooltipIds == nil then
			character.Birthday.TooltipIds = {}
		end
		character.Birthday.TooltipPortrait = character.TooltipPortrait
		character.Birthday.TooltipIds.BirthSign = character.Birthday.BirthSign.."_Tooltip"

		if character.Archetype == "PlayerImp" then
			character.Past = "HiddenPast_Alt"
			character.TooltipIds.Past = character.Past.."_Tooltip"
		else
			character.Past = "HiddenPast"
			character.TooltipIds.Past = character.Past.."_Tooltip"
		end

		if character.Archetype == "PlayerImp" then
			character.Reason = "HiddenReason_Alt"
			character.TooltipIds.Reason = character.Reason.."_Tooltip"
		else
			character.Reason = "HiddenReason"
			character.TooltipIds.Reason = character.Reason.."_Tooltip"
		end

		if character.Archetype == "PlayerImp" then
			character.YearsExiled = "YearsExiled_Alt"
			character.TooltipIds.YearsExiled = character.YearsExiled.."_Tooltip"
		else
			character.YearsExiled = "HiddenYearsExiled"
			character.TooltipIds.YearsExiled = character.HiddenYearsExiled.."_Tooltip"
		end
	end
end

function IsDateContainedInSign( date, zodiacData )

	if date.Month ~= zodiacData["StartMonthName"] and date.Month ~= zodiacData["EndMonthName"] then
		return false
	elseif date.Month == zodiacData["StartMonthName"] then
		if date.Date >= zodiacData["StartMonthDate"] then
			return true
		end
	elseif date.Month == zodiacData["EndMonthName"] then
		if date.Date <= zodiacData["EndMonthDate"] then
			return true
		end
	else
		return false
	end

end

function SetupBirthday( character )

	if character.Birthday == nil then
		return
	end

	character.Birthday.CharRef = CreateCharRef( character )
	character.Birthday.TooltipPortraitScale = 0.8

	if character.Birthday.Date == 1 or character.Birthday.Date == 21 or character.Birthday.Date == 31 then
		character.Birthday.Suffix = GetDisplayName({ Text = "sufSt" })
	elseif character.Birthday.Date == 2 or character.Birthday.Date == 22 then
		character.Birthday.Suffix = GetDisplayName({ Text = "sufNd" })
	elseif character.Birthday.Date == 3 or character.Birthday.Date == 23 then
		character.Birthday.Suffix = GetDisplayName({ Text = "sufRd" })
	else
		character.Birthday.Suffix = GetDisplayName({ Text = "sufTh" })
	end

	local birthMonthMsg = GetDisplayName({ Text = character.Birthday.Month })
	-- note: this will likely need to vary by language
	character.Birthday.BirthdayString = GetDisplayName({ Text = "BirthdayString_Prefix" }).." "..character.Birthday.Date..character.Birthday.Suffix.." "..GetDisplayName({ Text = "BirthdayString_Article" }).." "..birthMonthMsg
	character.Birthday.HiddenBirthday = "HiddenBirthday"

	-- zodiac content
	for k, zodiacData in pairs( WorldData.ZodiacSigns ) do
		if IsDateContainedInSign( character.Birthday, zodiacData ) then
			local birthSign = zodiacData["SignName"]
			character.Birthday.BirthSign = birthSign
			character.Birthday.HiddenBirthSign = "HiddenBirthSign"
		end
	end

end

if XPTable == nil then
	if TitanMode then
		XPTable =
		{
			[1] = 1200,
			[2] = 2400,
			[3] = 3600,
			[4] = 4200,
			[5] = 20000,
			-- total: 10800
		}
	else
		XPTable =
		{
			[1] = 1000,
			[2] = 1500,
			[3] = 2500,
			[4] = 3300,
			[5] = 10000,
			-- total: 8300
		}
	end
	PersistVariable({ Name = "XPTable" })
end

LevelCap = 5
PostMatchLossXP = 350
PostMatchWinXP = 500
PostMatchWinBonus = PostMatchWinXP - PostMatchLossXP

function InitXP( character )

	if character.XP == nil then
		character.XP = 0
	end
	if character.TotalXP == nil then
		character.TotalXP = character.XP
	end
	if character.RestXp == nil then
		character.RestXp = 0
	end
	if character.Level == nil then
		character.Level = 1
		character.RankName = "CharacterRank1"
	end
	if character.NextLevelXP == nil then
		if character.Level < 5 then
			character.NextLevelXP = XPTable[character.Level]
		else
			character.NextLevelXP = "Skills_AtMaxLevel"
		end
	end

end

function GiveXP( character, amount )

	if amount == nil or amount == 0 then
		return
	end

	InitXP( character )

	character.GainedXP = amount
	character.XP = character.XP + character.GainedXP

	local xpPerLevel = XPTable[character.Level]

	if character.XP >= xpPerLevel then
		character.Level = character.Level + 1
		character.RankName = "CharacterRank"..character.Level
		character.XP = character.XP - xpPerLevel
		character.GainedLevel = true
	else
		character.GainedLevel = false
	end

	local newXpPerLevel = XPTable[character.Level]
	if newXpPerLevel ~= nil then
		character.NextLevelXP = newXpPerLevel - character.XP
	end
	character.TotalXP = GetTotalXp( character )

	CheckXPQuest()
	CheckXPAchievement()

	if PlayerTeam ~= nil and IsWholeTeamMaxLevel( PlayerTeam ) then
		RemoveEvent( TravelEvents, "OpenStructure_Enlighten_01" )
	end

end

function CheckXPAchievement()

	if PlayerTeam == nil then
		return
	end
	local totalActiveXPLevel5 = 0
	for k, char in pairs( PlayerTeam.TeamBench ) do
		if char.Level >= 5 then
			totalActiveXPLevel5 = totalActiveXPLevel5 + 1
		end
	end

	if totalActiveXPLevel5 >= 1 then
		UnlockAchievementOnce( "AchRank5" )
	end
end

function CheckXPQuest()

	if PlayerTeam == nil then
		return
	end

	local totalActiveXPCharacters = 0
	local totalActiveXPLevel2 = 0
	local totalActiveXPLevel5 = 0
	for k, char in pairs( PlayerTeam.TeamBench ) do
		if CharacterXPEligible( char ) then
			totalActiveXPCharacters = totalActiveXPCharacters + 1
			if char.Level >= 2 then
				totalActiveXPLevel2 = totalActiveXPLevel2 + 1
			end
			if char.Level >= 5 then
				totalActiveXPLevel5 = totalActiveXPLevel5 + 1
			end
		end
	end

	UpdateObjectiveProgress( "QuestExilesLevel2", nil, totalActiveXPLevel2, totalActiveXPCharacters )
	UpdateObjectiveProgress( "QuestExilesLevel5", nil, totalActiveXPLevel5, totalActiveXPCharacters )
end

function CharacterXPEligible( char )
	if char.RosterStatus ~= "Active" then
		return false
	end

	if char.Undraftable == "Roster_DraftIneligible_AscensionIneligible_DocReason" or char.Undraftable == "Roster_DraftIneligible_DocReason" then
		-- Exception for Volfred who is added to the team but won't play
		return false
	end

	return true
end

function GiveXPWithPresentation( character, grantedXP )

	SelectedCharacter = character
	BaseXP = grantedXP

	if character.Level >= LevelCap then
		DisplayInfoPanelText({ Name = "Skills_AlreadyMaxLevel", Duration = 2.0 })
		return
	end

	-- XP Bonuses

	local xpMultiplier = 0
	if inMatch and League[character.TeamIndex].TeamLastMatchResult == "Win" then
		for k, modifierData in pairs( ConstellationStars ) do
			if modifierData.Status == "On" then
				xpMultiplier = xpMultiplier + modifierData.XPBonus
			end
		end
		ConstellationXp = math.floor( grantedXP * xpMultiplier )
		grantedXP = grantedXP + ConstellationXp
	else
		ConstellationXp = 0
	end

	local rested = false
	local bonus = false
	if character.RestXp > 0 and inMatch then
		RestXpUsed = grantedXP
		if RestXpUsed > character.RestXp then
			RestXpUsed = character.RestXp
		end
		grantedXP = grantedXP + RestXpUsed
		character.RestXp = character.RestXp - RestXpUsed
		rested = true
	else
		RestXpUsed = 0
	end

	if grantFirstTimeLossBonus then
		grantedXP = grantedXP + 300
	end

	GrantedXP = grantedXP

	wait(0.1)

	-- Update XP
	PlaySound({ Name = "/SFX/Match SFX/AnnouncementPing2" })
	InitXP( character )
	local prevLevel = character.Level
	local maxXP = 8300
	local xpChangeFraction = grantedXP / maxXP
	local xpPresentationWait = xpChangeFraction * 12.5
	GiveXP( character, grantedXP )
	SetMenuOptions({ Name = "RosterScreen", Item = "XpBarRest", Properties = { WidthChangeSpeed = 0.08 } })
	SetMenuOptions({ Name = "RosterScreen", Properties = { Run = "StartForceXP" } })

	Rumble({ RightFraction = 0.2, Duration = xpPresentationWait })

	wait(0.1)

	SetMenuOptions({ Name = "RosterScreen", Properties = { Run = "PresentUpdatedXp" } })

	-- XP Bar Sound
	PlaySound({ Name = "/SFX/Menu Sounds/ChoirLoop" })

	thread( ShowXpTallyBox )

	wait( xpPresentationWait )

	StopSound({ Name = "/SFX/Menu Sounds/ChoirLoop", Duration = 0.5 })
	wait(0.6)

	-- Check Level Up
	if character.Level > prevLevel then

		if not ascensionMatch then
			PlaySound({ Name = "/Music/Stingers/PositiveStinger1" })
		else
			PlaySound({ Name = "/Music/Stingers/EnemyScore" })
		end
		Rumble({ RightFraction = 0.3, Duration = 0.3 })
		if not IsEmpty( character["LevelUpSpeechLines"] ) then
			local speech = RemoveFirstIndexValue( character["LevelUpSpeechLines"] )
			if GetMapName({ }) ~= "Campaign" then
				if not ascensionMatch and not blockMatchVO then
					PlaySpeech({ Name = speech })
				end
			end
		end

		SetMenuOptions({ Name = "RosterScreen", Properties = { Run = "StartForceXP" } })

		wait(1.0)

		local levelUpDialogue = RemoveFirstIndexValue( character.LevelUpDialogue )
		AddDialogueByName( levelUpDialogue )
		DialogueProcSequence()

		wait(0.5)
		character.SkillPoints = character.SkillPoints + 1
		PlaySound({ Name = "/SFX/Menu Sounds/ChoirStamp" })
		SetMenuOptions({ Name = "RosterScreen", Properties = { Run = "StartForceXP" } })
		SetMenuOptions({ Name = "CharacterSkillsScreen", Properties = { Run = "PresentUpdatedSkillPoints" } })

		wait(0.5)

		DisplayTutorialBox({ HelpTextId = "Skills_CharacterChooseASkill", X = 1391, Y = 170, Arrow = "Down" })
		waitUntil( "skillsPicked" )
		_events["skillsPicked"] = nil
		HideTutorialBox()
		wait(0.35)
	end

	wait(0.5)
	HideXpTallyBox()

end

function ShowXpTallyBox()

	SetMenuOptions({ Name = "RosterScreen", Item = "UpgradeIconBack", Properties = { BlockTooltip = true } })
	SetMenuOptions({ Name = "RosterScreen", Item = "UpgradeIcon", Properties = { BlockTooltip = true } })
	SetMenuOptions({ Name = "RosterScreen", Item = "BioTab", Properties = { BlockTooltip = true } })
	SetMenuOptions({ Name = "RosterScreen", Item = "SkillsTab", Properties = { BlockTooltip = true } })
	SetMenuOptions({ Name = "RosterScreen", Item = "InventoryTab", Properties = { BlockTooltip = true } })
	SetMenuOptions({ Name = "RosterScreen", Item = "Skill1", Properties = { BlockTooltip = true } })
	SetMenuOptions({ Name = "RosterScreen", Item = "Skill2", Properties = { BlockTooltip = true } })
	SetMenuOptions({ Name = "RosterScreen", Item = "Skill3", Properties = { BlockTooltip = true } })
	SetMenuOptions({ Name = "RosterScreen", Item = "Skill4", Properties = { BlockTooltip = true } })

	SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyBackground", Properties = { FadeTarget = 1.0 } })
	SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyTitle", Properties = { FadeTarget = 1.0 } })
	wait(0.2)

	local lineIndex = 1
	if inMatch then
		SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyLine"..lineIndex, Properties = { DisplayNameId = "Roster_XpTallyMatch", FadeTarget = 1.0, ReReadText = true } })
		lineIndex = lineIndex + 1
		wait(0.2)

		if PlayerTeam.TeamLastMatchResult == "Win" then
			SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyLine"..lineIndex, Properties = { DisplayNameId = "Roster_XpTallyWin", FadeTarget = 1.0, ReReadText = true } })
		else
			if grantFirstTimeLossBonus then
				SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyLine"..lineIndex, Properties = { DisplayNameId = "Roster_XpTallySpecialLoss", FadeTarget = 1.0, ReReadText = true } })
			else
				SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyLine"..lineIndex, Properties = { DisplayNameId = "Roster_XpTallyWin_Fail", FadeTarget = 1.0, ReReadText = true, TextRed = 0.5, TextGreen = 0.5, TextBlue = 0.5 } })
			end
		end
		lineIndex = lineIndex + 1
		wait(0.2)

		if TotalEnlightenmentBonus ~= nil then
			if PlayerTeam.TeamLastMatchResult == "Win" then
				SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyLine"..lineIndex, Properties = { DisplayNameId = "Roster_XpTallyConstellations", FadeTarget = 1.0, ReReadText = true } })
			else
				SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyLine"..lineIndex, Properties = { DisplayNameId = "Roster_XpTallyConstellations_Fail", FadeTarget = 1.0, ReReadText = true, TextRed = 0.5, TextGreen = 0.5, TextBlue = 0.5 } })
			end
			lineIndex = lineIndex + 1
			wait(0.2)
		end
	elseif chooseGrantXP then
		-- Mentoring
		SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyLine"..lineIndex, Properties = { DisplayNameId = "Roster_XpTallyMentor", FadeTarget = 1.0, ReReadText = true } })
		lineIndex = lineIndex + 1
	elseif XpItem ~= nil then
		-- From an item
		SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyLine"..lineIndex, Properties = { DisplayNameId = "Roster_XpTallyItem", FadeTarget = 1.0, ReReadText = true } })
		lineIndex = lineIndex + 1
	end

	if RestXpUsed ~= nil and RestXpUsed > 0 then
		SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyLine"..lineIndex, Properties = { DisplayNameId = "Roster_XpTallyRest", FadeTarget = 1.0, ReReadText = true } })
		lineIndex = lineIndex + 1
		wait(0.2)
	end

	SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyTotal", Properties = { DisplayNameId = "Roster_XpTallyTotal", FadeTarget = 1.0, ReReadText = true } })

end

function HideXpTallyBox()

	SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyBackground", Properties = { FadeTarget = 0.0 } })
	SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyTitle", Properties = { FadeTarget = 0.0 } })
	SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyLine1", Properties = { FadeTarget = 0.0 } })
	SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyLine2", Properties = { FadeTarget = 0.0 } })
	SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyLine3", Properties = { FadeTarget = 0.0 } })
	SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyLine4", Properties = { FadeTarget = 0.0 } })
	SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyTotal", Properties = { FadeTarget = 0.0 } })
	SetMenuOptions({ Name = "RosterScreen", Item = "XpTallyLineTotal", Properties = { FadeTarget = 0.0 } })

	SetMenuOptions({ Name = "RosterScreen", Item = "UpgradeIconBack", Properties = { BlockTooltip = false } })
	SetMenuOptions({ Name = "RosterScreen", Item = "UpgradeIcon", Properties = { BlockTooltip = false } })
	SetMenuOptions({ Name = "RosterScreen", Item = "BioTab", Properties = { BlockTooltip = false } })
	SetMenuOptions({ Name = "RosterScreen", Item = "SkillsTab", Properties = { BlockTooltip = false } })
	SetMenuOptions({ Name = "RosterScreen", Item = "InventoryTab", Properties = { BlockTooltip = false } })
	SetMenuOptions({ Name = "RosterScreen", Item = "Skill1", Properties = { BlockTooltip = false } })
	SetMenuOptions({ Name = "RosterScreen", Item = "Skill2", Properties = { BlockTooltip = false } })
	SetMenuOptions({ Name = "RosterScreen", Item = "Skill3", Properties = { BlockTooltip = false } })
	SetMenuOptions({ Name = "RosterScreen", Item = "Skill4", Properties = { BlockTooltip = false } })

end

minCharacterTraits = 2
maxCharacterTraits = 7
minStartingTraits = 0
maxStartingTraits = 2

startingScoreModifier = 0
startingMatchLootModifier = 1

OnAnyLoad
{
	function( triggerArgs )
		if MatchLootModifierUnits == nil then
			MatchLootModifierUnits = {}
			PersistVariable({ Name = "MatchLootModifierUnits" })
		end
	end
}

function CreateTeamCharacters( team )

	for index, character in pairs( team.TeamBench ) do

		-- Initialize the character with their default data
		character.CharacterIndex = index

		character.Id = NextCharacterId
		NextCharacterId = NextCharacterId + 1

		-- Hand over desired team fields
		character.TeamIndex = team.LeagueIndex
		character.TeamName = team.TeamName
		character.TooltipIds = character.TooltipIds or {}
		character.TooltipIds.TeamName = team.TooltipIds.TeamName

		InitTags( character )

		CreateCharacter( team, character )

		-- Archetype Defaults
		for key, value in pairs( ArchetypeData[character.Archetype] ) do
			if character[key] == nil then
				character[key] = value
			end
		end

		if team.LeagueIndex == 1 then
			character.RosterStatus = "Inactive"
		else
			character.RosterStatus = "Active"
			-- Non team 1 characters are always robed
			if character.RobedPortrait == nil then
				character.RobedPortrait = character.Portrait
			end
		end

		-- points and stats
		character.PointsLastMatch = 0
		character.PointsAllTime = 0
		character.MatchesPlayed = 0

		InitXP( character )
		GiveXP( character, character.StartingXP )
		character.Rank = 1

		-- Assign default attribute values
		for attributeName, attributeValue in pairs( PlayerDefaultAttributes[character.Archetype] ) do
			if character[attributeName] == nil then
				character[attributeName] = attributeValue
			end
		end
		for attributeName, attributeValue in pairs( PlayerDefaultAttributes[character.Archetype] ) do
			if character[attributeName.."Modifier"] ~= nil then
				character[attributeName] = character[attributeName] + character[attributeName.."Modifier"]
			end
		end
		UpdateDerivedAttributes( character )

		-- Record starting values
		for attributeName, attributeValue in pairs( PlayerDefaultAttributes[character.Archetype] ) do
			character["Starting"..attributeName] = character[attributeName]
		end

		-- Traits
		if character.Traits == nil then
			character.Traits = { }
		end
		for k, traitName in pairs( character.Traits ) do
			ProcessTrait( character, traitName )
		end
		AddCharacterTrait( character, character.StartingTrait )

		-- Character Skills
		if character.SkillPoints == nil then
			character.SkillPoints = 0
		end
		character.Skills = { }
		if character.StartingSkills ~= nil then
			for k, skillName in pairs( character.StartingSkills ) do
				AddSkill( character, skillName )
			end
		end

		-- Starting Upgrade Item
		if character.UpgradeItemName ~= nil then
			local createdItem = CreateItem( character.UpgradeItemName )
			EquipUpgradeItem( character, createdItem )
		end

		-- character misc data
		character.ActiveStatus = "None"
		character.MatchStatus = "None"
		character.RespawnTimer = -1
		character.StatusEffect = "None"
		character.StatusEffectTrait = "None"
		character.PreviousKilled = 0
		character.PreviousKiller = 0

		-- run this anytime a stat changes
		UpdateTooltips( character )

	end

end

function ResetDefaultAttributes( character, characterData )

	-- Archeypte default
	for attributeName, attributeValue in pairs( PlayerDefaultAttributes[character.Archetype] ) do
		character[attributeName] = attributeValue
	end
	character.ScoreValue = ArchetypeData[character.Archetype].ScoreValue

	local attributes = { "PlayerAttributeRespawn", "PlayerAttributeAura", "PlayerAttributeSpeed", "ScoreValue"  }
	for k, attributeName in pairs( attributes ) do
		-- Character override
		if characterData[attributeName] ~= nil then
			character[attributeName] = characterData[attributeName]
		end
		-- Character modifier
		if characterData[attributeName.."Modifier"] ~= nil then
			character[attributeName] = character[attributeName] + characterData[attributeName.."Modifier"]
		end
		character["Starting"..attributeName] = character[attributeName]
	end

	UpdateDerivedAttributes( character )

end

function ResetArchetypeDefaultAttributes( character )

	-- Archeypte default
	for attributeName, attributeValue in pairs( PlayerDefaultAttributes[character.Archetype] ) do
		character[attributeName] = attributeValue
		character["Starting"..attributeName] = character[attributeName]
	end
	character.ScoreValue = ArchetypeData[character.Archetype].ScoreValue

	UpdateDerivedAttributes( character )

end

function UpdateTooltips( character )
	-- attribute tooltips
	if character.ScoreValue <= 10 then
		character.TooltipIds.ScoreValue = "PlayerAttributeDamage_10"
	elseif character.ScoreValue > 10 and character.ScoreValue <= 15 then
		character.TooltipIds.ScoreValue = "PlayerAttributeDamage_15"
	elseif character.ScoreValue > 15 and character.ScoreValue <= 20 then
		character.TooltipIds.ScoreValue = "PlayerAttributeDamage_20"
	elseif character.ScoreValue > 20 and character.ScoreValue <= 25 then
		character.TooltipIds.ScoreValue = "PlayerAttributeDamage_25"
	elseif character.ScoreValue > 25 and character.ScoreValue <= 35 then
		character.TooltipIds.ScoreValue = "PlayerAttributeDamage_30"
	elseif character.ScoreValue > 35 then
		character.TooltipIds.ScoreValue = "PlayerAttributeDamage_35"
	end

	if character.PlayerAttributeAura < 1 then
		character.TooltipIds.PlayerAttributeAura = "PlayerAttributeAura_1"
	elseif character.PlayerAttributeAura >= 1 and character.PlayerAttributeAura < 5 then
		character.TooltipIds.PlayerAttributeAura = "PlayerAttributeAura_1"
	elseif character.PlayerAttributeAura >= 5 and character.PlayerAttributeAura < 10 then
		character.TooltipIds.PlayerAttributeAura = "PlayerAttributeAura_5"
	elseif character.PlayerAttributeAura >= 10 and character.PlayerAttributeAura < 15 then
		character.TooltipIds.PlayerAttributeAura = "PlayerAttributeAura_10"
	elseif character.PlayerAttributeAura >= 15 and character.PlayerAttributeAura < 20 then
		character.TooltipIds.PlayerAttributeAura = "PlayerAttributeAura_15"
	elseif character.PlayerAttributeAura >= 20 and character.PlayerAttributeAura < 25 then
		character.TooltipIds.PlayerAttributeAura = "PlayerAttributeAura_20"
	elseif character.PlayerAttributeAura >= 25 and character.PlayerAttributeAura < 40 then
		character.TooltipIds.PlayerAttributeAura = "PlayerAttributeAura_25"
	elseif character.PlayerAttributeAura == 40 then
		character.TooltipIds.PlayerAttributeAura = "PlayerAttributeAura_40"
	end

	if character.PlayerAttributeSpeed < 1 then
		character.TooltipIds.PlayerAttributeSpeed = "PlayerAttributeSpeed_1"
	elseif character.PlayerAttributeSpeed >= 1 and character.PlayerAttributeSpeed < 5 then
		character.TooltipIds.PlayerAttributeSpeed = "PlayerAttributeSpeed_1"
	elseif character.PlayerAttributeSpeed >= 5 and character.PlayerAttributeSpeed < 10 then
		character.TooltipIds.PlayerAttributeSpeed = "PlayerAttributeSpeed_5"
	elseif character.PlayerAttributeSpeed >= 10 and character.PlayerAttributeSpeed < 15 then
		character.TooltipIds.PlayerAttributeSpeed = "PlayerAttributeSpeed_10"
	elseif character.PlayerAttributeSpeed >= 15 and character.PlayerAttributeSpeed < 20 then
		character.TooltipIds.PlayerAttributeSpeed = "PlayerAttributeSpeed_15"
	elseif character.PlayerAttributeSpeed >= 20 and character.PlayerAttributeSpeed < 25 then
		character.TooltipIds.PlayerAttributeSpeed = "PlayerAttributeSpeed_20"
	elseif character.PlayerAttributeSpeed >= 25 and character.PlayerAttributeSpeed < 40 then
		character.TooltipIds.PlayerAttributeSpeed = "PlayerAttributeSpeed_25"
	elseif character.PlayerAttributeSpeed == 40 then
		character.TooltipIds.PlayerAttributeSpeed = "PlayerAttributeSpeed_40"
	end

	if character.PlayerAttributeRespawn < 1 then
		character.TooltipIds.PlayerAttributeRespawn = "PlayerAttributeRespawn_1"
	elseif character.PlayerAttributeRespawn >= 1 and character.PlayerAttributeRespawn < 5 then
		character.TooltipIds.PlayerAttributeRespawn = "PlayerAttributeRespawn_1"
	elseif character.PlayerAttributeRespawn >= 5 and character.PlayerAttributeRespawn < 10 then
		character.TooltipIds.PlayerAttributeRespawn = "PlayerAttributeRespawn_5"
	elseif character.PlayerAttributeRespawn >= 10 and character.PlayerAttributeRespawn < 15 then
		character.TooltipIds.PlayerAttributeRespawn = "PlayerAttributeRespawn_10"
	elseif character.PlayerAttributeRespawn >= 15 and character.PlayerAttributeRespawn < 20 then
		character.TooltipIds.PlayerAttributeRespawn = "PlayerAttributeRespawn_15"
	elseif character.PlayerAttributeRespawn >= 20 and character.PlayerAttributeRespawn < 25 then
		character.TooltipIds.PlayerAttributeRespawn = "PlayerAttributeRespawn_20"
	elseif character.PlayerAttributeRespawn >= 25 and character.PlayerAttributeRespawn < 40 then
		character.TooltipIds.PlayerAttributeRespawn = "PlayerAttributeRespawn_25"
	elseif character.PlayerAttributeRespawn == 40 then
		character.TooltipIds.PlayerAttributeRespawn = "PlayerAttributeRespawn_40"
	end
end

OnAnyLoad{ function( triggerArgs )

	-- end match gold attribute math
	if matchLoot == nil then
		matchLoot = 0
		PersistVariable({ Name = "matchLoot" })

		matchBounty = 0
		PersistVariable({ Name = "matchBounty" })
	end

end }

-- PlayerAttributeAura / Presence / Aura Radius
AuraStatTable =
{
	[1] = 25,
	[2] = 50,
	[3] = 75,
	[4] = 100,
	[5] = 125,
	[6] = 150,
	[7] = 175,
	[8] = 200,
	[9] = 225,
	[10] = 250,
	[11] = 275,
	[12] = 300,
	[13] = 325,
	[14] = 350,
	[15] = 375,
	[16] = 400,
	[17] = 425,
	[18] = 450,
	[19] = 475,
	[20] = 500,
	[21] = 525,
	[22] = 550,
	[23] = 575,
	[24] = 600,
	[25] = 625,
	[26] = 650,
	[27] = 675,
	[28] = 700,
	[29] = 725,
	[30] = 750,
	[31] = 775,
	[32] = 800,
}

-- PlayerAttributeSpeed / Quickness / Movement Speed
SpeedStatTable =
{
	[1] = 115,
	[2] = 185,
	[3] = 200,
	[4] = 215,
	[5] = 225,
	[6] = 250,
	[7] = 275,
	[8] = 300,
	[9] = 325,
	[10] = 350,
	[11] = 375,
	[12] = 400,
	[13] = 425,
	[14] = 450,
	[15] = 475,
	[16] = 500,
	[17] = 515,
	[18] = 530,
	[19] = 545,
	[20] = 560,
	[21] = 575,
	[22] = 590,
	[23] = 605,
	[24] = 620,
	[25] = 635,
	[26] = 640,
	[27] = 645,
	[28] = 650,
	[29] = 655,
	[30] = 660,
	[31] = 665,
	[32] = 670,
	[33] = 675,
	[34] = 680,
	[35] = 685,
	[36] = 690,
	[37] = 695,
	[38] = 700,
	[39] = 705,
	[40] = 710,
	--[[
	[26] = 645,
	[27] = 660,
	[28] = 675,
	[29] = 690,
	[30] = 700,
	[31] = 705,
	[32] = 710,
	[33] = 715,
	[34] = 720,
	[35] = 725,
	[36] = 730,
	[37] = 735,
	[38] = 740,
	[39] = 745,
	[40] = 750,
	]]
}

-- PlayerAttributeRespawn / Hope / RespawnTime
RespawnStatTable =
{
	[1] = 30.00,
	[2] = 20.00,
	[3] = 18.00,
	[4] = 16.00,
	[5] = 14.00,
	[6] = 12.00,
	[7] = 11.66,
	[8] = 11.33,
	[9] = 11.00,
	[10] = 10.66,
	[11] = 10.33,
	[12] = 10.00,
	[13] = 9.66,
	[14] = 9.33,
	[15] = 9.00,
	[16] = 8.66,
	[17] = 8.33,
	[18] = 8.00,
	[19] = 7.66,
	[20] = 7.33,
	[21] = 7.00,
	[22] = 6.66,
	[23] = 6.33,
	[24] = 6.00,
	[25] = 5.66,
	[26] = 5.33,
	[27] = 5.00,
	[28] = 4.80,
	[29] = 4.60,
	[30] = 4.40,
	[31] = 4.20,
	[32] = 4.00,
	[33] = 3.80,
	[34] = 3.60,
	[35] = 3.40,
	[36] = 3.20,
	[37] = 3.00,
	[38] = 2.80,
	[39] = 2.60,
	[40] = 2.40,
}

function UpdateDerivedAttributes( char )

	local playerAttitudeStat = char.PlayerAttributeRespawn
	if playerAttitudeStat < 1 then
		playerAttitudeStat = 1
	elseif playerAttitudeStat > #RespawnStatTable then
		playerAttitudeStat = #RespawnStatTable
	end

	char.BaseRespawnTimer = RespawnStatTable[playerAttitudeStat]

	local convertedRespawnStat = char.BaseRespawnTimer
	char.RoundedRespawnTime = ( round(convertedRespawnStat * 10 ) * 0.1 )

	local playerAuraStat = char.PlayerAttributeAura
	local convertedAuraStat = round(playerAuraStat/3.28, 1)
	char.AuraSize = convertedAuraStat

	local playerSpeedStat = char.PlayerAttributeSpeed
	local convertedSpeedStat = round(playerSpeedStat/3.28, 1)
	char.MovementSpeed = convertedSpeedStat

end

function AssignUnitAttributes( char, team )

	local charObjectId = char.ObjectId
	if charObjectId == nil or charObjectId <= 0 then
		return
	end

	-- Aura
	local auraValue = char.PlayerAttributeAura
	auraValue = Clamp( auraValue, 1, 40 )
	ApplyUpgrade({ Name = "Aura_"..auraValue, DestinationId = char.ObjectId })

	-- Speed
	-- v5: archetype adjusts move feel and stat determines speed
	local playerSpeedStat = char.PlayerAttributeSpeed
	playerSpeedStat = Clamp( playerSpeedStat, 1, 40)
	local characterSpeed = SpeedStatTable[playerSpeedStat]
	SetUnitProperty({ Name = "Speed", Value = characterSpeed, DestinationId = char.ObjectId })

	-- stamina
	local characterStamina = 0
	local characterStaminaBonus = 0
	if team == TeamB and ConstellationActive( "RivalTeamStamina" ) then
		characterStaminaBonus = 50
	end

	if char.PlayerAttributeStamina > 1 then
		characterStamina = 10 * char.PlayerAttributeStamina + characterStaminaBonus
		SetUnitProperty({ Name = "MaxStamina", Value = characterStamina, DestinationId = char.ObjectId })
	end

	if char.UpgradeItem ~= nil and char.UpgradeItem.UpgradeName == "NoMoveCurse" then
		SetUnitProperty({ Name = "MaxStamina", Value = 200, DestinationId = char.ObjectId })
	end

end

function AssignSkills( char )

	local charObjectId = char.ObjectId
	if charObjectId == nil or charObjectId <= 0 then
		return
	end

	for k, skillName in pairs( char.Skills ) do
		ApplyUpgrade({ Name = skillName, DestinationId = charObjectId })
	end

	-- last: assign match related traits
	for k, traitName in pairs( char.Traits ) do
		local traitData = PlayerTraitsTable[traitName]
		if traitData ~= nil and traitData.PlayerUnitUpgrade then
			ApplyUpgrade({ Name = traitName, DestinationId = charObjectId })
		end
	end

end

function CheckPyreMatchStartSkills()

	local prevTeamAHealth = TeamA.PyreHealth
	local prevTeamBHealth = TeamB.PyreHealth
	CheckTeamPyreMatchStartSkills( TeamA )
	CheckTeamPyreMatchStartSkills( TeamB )

	if TeamA.PyreHealth ~= prevTeamAHealth then
		thread( ShowGoalHealth, TeamA )
	end
	if TeamB.PyreHealth ~= prevTeamBHealth then
		thread( ShowGoalHealth, TeamB )
	end

end

function CheckTeamPyreMatchStartSkills( team )

	for k, char in pairs( team.TeamBench ) do
		if char.ActiveStatus == "Assigned" then

			-- pyre pre-damage skill
			local pyrePreDamageValue = GetUnitSkillValue( char, "PyrePreDamageSkill" )
			if pyrePreDamageValue > 0 then
				local opposingTeam = GetOpposingTeam( League[char.TeamIndex] )
				opposingTeam.PyreHealth = opposingTeam.PyreHealth - pyrePreDamageValue
				UpdatePyreScale( opposingTeam )
				thread( SkillProcFeedback, char.ObjectId, "PyrePreDamageSkill", nil, pyrePreDamageValue )
			end

			-- pyre health bonus skill
			local pyreHealthBonusValue = GetUnitSkillValue( char, "PyreHealthSkill" )
			if pyreHealthBonusValue > 0 then
				local team = League[char.TeamIndex]
				team.PyreMaxHealth = team.PyreMaxHealth + pyreHealthBonusValue
				team.PyreHealth = team.PyreHealth + pyreHealthBonusValue
				UpdatePyreScale( team )
				thread( SkillProcFeedback, char.ObjectId, "PyreHealthSkill", nil, pyreHealthBonusValue )
			end

		end
	end

end

-- recalculate stats
function ProcessTrait( characterData, traitName )

	local traitData = PlayerTraitsTable[traitName]

	if traitData == nil then
		return
	end

	if traitData.Trigger ~= "Passive" then
		return
	end

	if traitData.AttributeModifiers ~= nil then
		for attributeModifier, attributeModifierValue in pairs( traitData.AttributeModifiers ) do
			characterData[attributeModifier] = characterData[attributeModifier] + attributeModifierValue
		end
	end

end

function ProcessTraitRemoval( characterData, traitName )

	local traitData = PlayerTraitsTable[traitName]

	if traitData == nil then
		return
	end

	if traitData.Trigger ~= "Passive" then
		return
	end

	if traitData.AttributeModifiers ~= nil then
		for attributeModifier, attributeModifierValue in pairs( traitData.AttributeModifiers ) do
			characterData[attributeModifier] = characterData[attributeModifier] - attributeModifierValue
		end
	end

end

maxLeagueTeamSize = 10
PlayerTeamIndex = 1
PracticeTeamIndex = 10

OnAnyLoad{ function( triggerArgs )

	if League == nil then
		League = { }
		PersistVariable({ Name = "League" })
	end

end }

function CreateLeague()

	NextCharacterId = 1
	PersistVariable({ Name = "NextCharacterId" })

	for index, teamData in pairs( PlayerData.Teams ) do
		if not multiplayerOnly or teamData.Multiplayer then
			local team = CreateTeam( teamData )
			team.LeagueIndex = index
			League[index] = team

			SetupVoicePostfix( team )

			-- Tooltips
			team.TooltipIds = { }
			if index == 1 then
				team.TooltipIds.TeamName = "PlayerTeamName"
			elseif index == 2 then
				team.TooltipIds.TeamName = "AccusersTeamNamePrologue"
			else
				team.TooltipIds.TeamName = team.FullName
			end
			team.TooltipIds.FullTeamName = team.TooltipIds.TeamName
			team.TooltipPortraitIgnores = {}
			team.TooltipPortraitIgnores.TeamNextMatchVenue = true

			CreateTeamCharacters( team )

			if team.LeagueIndex >= 2 and team.LeagueIndex <= 11 then
				for charIndex, char in pairs( team.TeamBench ) do
					if charIndex ~= 1 then
						char.BlockTaunt = true
					end
				end
			end

		end
	end

	-- create 'coach' character
	Coach = {}
	PersistVariable({ Name = "Coach" })
	Coach.LocId = LocId_Story_Coach
	Coach.Bonus_Training = 1
	Coach.Bonus_Training_Rank = 1
	Coach.Bonus_Selling = 1
	Coach.Bonus_Selling_Rank = 1
	Coach.Bonus_Foraging_Rank = 1
	Coach.Bonus_Studying_Rank = 1
	Coach.Bonus_GlobalBuff_Respawn = 0
	Coach.Bonus_GlobalBuff_Speed = 0
	Coach.Bonus_GlobalBuff_Aura = 0
	Coach.Bonus_GlobalBuff_Damage = 0
	Coach.TooltipIds = { }
	Coach.TooltipIds.Patron = "CoachPatron"
	Coach.TooltipIds.FullName = "Coach_FullName_Tooltip"
	Coach.TooltipIds.ShortName = "Coach_FullName_Tooltip"
	Coach.FullName = "Coach_FullName"
	Coach.ShortName = "Coach_FullName"
	Coach.SmallPortrait = "NomadMasked01_Robed_Small"
	Coach.AscendedTooltip = "AscendedCoach_FullName"
	if CoinFlip() then
		SetCoachFemale()
	else
		SetCoachMale()
	end
	introRukeyComment = "JokerIntroComment01"

	-- create useful reference variables
	CreateLeagueReferences()

end

function CreateTeam( teamData )

	local team = ShallowCopyTable( teamData )

	-- Assign Team Names
	if team.Name ~= nil then
		team.TeamName = team.Name
		team.FullTeamName = "Full"..team.TeamName
		team.StandingsName = team.Name.."_Standings"

		if team.FullName == nil then
			team.FullName = team.Name.."_Full"
		end
		if team.GenericExileName == nil then
			team.GenericExileName = team.Name.."_GenericExile_01"
		end
	end

	-- Pick Random Reputation
	team.TeamRep = GetRandomRemainingData( WorldData.TeamReputations )

	-- team win & loss record
	team.Wins = 0
	team.Losses = 0
	team.WinsVsPlayer = 0
	team.LossesVsPlayer = 0
	team.TeamLastMatchResult = "None"
	team.CharactersAscended = 0
	team.AscensionMatchesPlayed = 0
	team.LastAscensionMatchSeasonNum = 0
	team.LiberationPlanProgress = 0
	team.MatchesPlayed = 0

	-- Team items and weapons
	team.TeamQuestStash = { }
	team.Money = 10
	team.MoneySpentLifeTime = 0
	team.MoneyEarnedLifeTime = 0
	team.Earnings = 0
	team.CaravanHealth = 100
	team.CaravanMaxHealth = 100
	team.CaravanSpeed = 200
	team.CaravanJumpMultiplier = 1
	team.StandingsScreenHeadIndex = 1

	-- Setup appropriate RGB color
	team.MaskHueRGB = HSVtoRGB( team.MaskHue, 1.0, 1.0 )
	team.MaskHueRGB2 = HSVtoRGB( team.MaskHue2, 1.0, 1.0 )

	-- Auto setup icons
	if team.Icon == nil then
		team.Icon = team.LargeSigil
		team.TooltipPortrait = team.RosterScreenSigil
		team.TooltipPortraitScale = 1.0
	end

	return team

end

function SetupVoicePostfix( team )

	if team.LeagueIndex <= 9 then
		team.VoicePostfix = "_0"..team.LeagueIndex
	elseif team.LeagueIndex == 10 then
		team.VoicePostfix = "_10"
	elseif team.LeagueIndex == 11 or team.LeagueIndex == 12 then
		team.VoicePostfix = "_01"
	end

end

function DefaultTeamTooltipPortraits()
	for k, team in pairs( League ) do
		team.TooltipPortrait = team.Icon
		team.TooltipPortraitScale = 0.1
		team.TooltipPortraitB = nil
	end
end

function StarPickTeamTooltipPortraits()
	for k, team in pairs( League ) do
		team.TooltipPortrait = team.TeamBench[1].TooltipPortrait
		team.TooltipPortraitScale = 0.8
		if PlayerTeam.AscensionMatchesPlayed == 2 and MatchesPlayedThisSeason == 1 then
			-- No preview for hidden match site
		elseif team.NextMatchSiteNode ~= nil then
			local matchSitePreview = "GUI\\Screens\\Versus\\LocalePreview_"..NodeData[team.NextMatchSiteNode].Map
			team.TooltipPortraitB = matchSitePreview
			team.TooltipPortraitBScale = 0.62
		end
	end
end

function CreateLeagueReferences()

	-- All of this stuff stomps RecordCharacter() things

	-- Pointers are disconnected on load and not reconnected with PersistVariable
	if League ~= nil then
		PlayerTeam = League[PlayerTeamIndex]
		NextTeam = League[NextTeamIndex]
		LastTeam = League[LastTeamIndex]

		PrevailedTeam = League[PrevailedTeamIndex]
		DefeatedTeam = League[DefeatedTeamIndex]
	end

	CacheCharacterTags()

	if PlayerTeam ~= nil then

		-- player team characters
		CharFriend = GetCharacterDataByStoryTag( "Story_Friend" )
		CharBadass = GetCharacterDataByStoryTag( "Story_Badass" )
		CharJoker = GetCharacterDataByStoryTag( "Story_Joker" )
		CharPsycho = GetCharacterDataByStoryTag( "Story_Psycho" )
		CharMascot = GetCharacterDataByStoryTag( "Story_Mascot" )
		CharKnight = GetCharacterDataByStoryTag( "Story_Knight" )
		CharVamp = GetCharacterDataByStoryTag( "Story_Vamp" )
		CharDoc = GetCharacterDataByStoryTag( "Story_Doc" )
		CharDiva = GetCharacterDataByStoryTag( "Story_Diva" )

		-- dynamic player character references
		CharExplorer = GetCharacterDataByStoryTag( "Story_Explorer" )
		CharForager = GetCharacterDataByStoryTag( "Story_Forager" )
		CharSeeker = GetCharacterDataByStoryTag( "Story_Seeker" )
		CharTraveler = GetCharacterDataByStoryTag( "Story_Traveler" )
		CharLucky = GetCharacterDataByStoryTag( "Story_Lucky" )
		CharDowner = GetCharacterDataByStoryTag( "Story_Downer" )
		CharProtag = GetCharacterDataByStoryTag( "Story_Protag" )
		CharLeader = GetCharacterDataByStoryTag( "Story_Leader" )

		-- all characters tagged separately for use in mutually exclusive ascension week events
		CharNum1 = GetCharacterDataByStoryTag( "Story_Num1" )
		CharNum2 = GetCharacterDataByStoryTag( "Story_Num2" )
		CharNum3 = GetCharacterDataByStoryTag( "Story_Num3" )
		CharNum4 = GetCharacterDataByStoryTag( "Story_Num4" )
		CharNum5 = GetCharacterDataByStoryTag( "Story_Num5" )
		CharNum6 = GetCharacterDataByStoryTag( "Story_Num6" )
		CharNum7 = GetCharacterDataByStoryTag( "Story_Num7" )
		CharNum8 = GetCharacterDataByStoryTag( "Story_Num8" )
		CharNum9 = GetCharacterDataByStoryTag( "Story_Num9" )

		-- drafted characters tagged
		CharPick1 = GetCharacterDataByStoryTag( "Story_Pick1" )
		CharPick2 = GetCharacterDataByStoryTag( "Story_Pick2" )
		CharPick3 = GetCharacterDataByStoryTag( "Story_Pick3" )

		-- most banished character in last match
		CharBanished = GetCharacterDataByStoryTag( "Story_Banished" )

		-- ascended buddy character
		CharBuddy = GetCharacterDataByStoryTag( "Story_Buddy" )

		-- NPCs
		CharBard = GetCharacterDataByStoryTag( "Story_Bard" )
		CharRivalBard = GetCharacterDataByStoryTag( "Story_RivalBard" )
		CharShopKeeper = GetCharacterDataByStoryTag( "Story_ShopKeeper" )

		-- rival captains
		RivalAccuser = GetCharacterDataByStoryTag( "Story_Accuser" )
		RivalFateDad = GetCharacterDataByStoryTag( "Story_FateDad" )
		RivalFateSon = GetCharacterDataByStoryTag( "Story_FateSon" )
		RivalDissident = GetCharacterDataByStoryTag( "Story_Dissident" )
		RivalWithdrawn = GetCharacterDataByStoryTag( "Story_Withdrawn" )
		RivalPyreheart = GetCharacterDataByStoryTag( "Story_Pyreheart" )
		RivalEssence = GetCharacterDataByStoryTag( "Story_Essence" )
		RivalChastity = GetCharacterDataByStoryTag( "Story_Chastity" )
		RivalTemper = GetCharacterDataByStoryTag( "Story_Temper" )
		RivalNightwing = GetCharacterDataByStoryTag( "Story_Nightwing" )
		RivalBeyonder = GetCharacterDataByStoryTag( "Story_Beyonder" )

		-- dynamic rival references
		RivalTarget = GetCharacterDataByStoryTag( "Story_Target" )
		RivalPrevailed = GetCharacterDataByStoryTag( "Story_Prevailed" )
		RivalDefeated = GetCharacterDataByStoryTag( "Story_Defeated" )
		RivalSeasonFoe = GetCharacterDataByStoryTag( "Story_SeasonFoe" )
		RivalFlying = GetCharacterDataByStoryTag( "Story_Flying" )

		-- previous & upcoming match information [all updated in RecordMatch]
		teamRecord = GetWinLossRecord()
		UpdateNextTeam()
		GetNumMatchesPlayed()

		PlayerTeam.AscensionMatchesPlayed = PlayerTeam.AscensionMatchesPlayed or 0

		-- Custom patches
		CharKnight.TooltipIds.NickName = CharKnight.TooltipIds.ShortName

	end

	if LastAscendedCharacterRef ~= nil then
		LastAscendedCharacter = GetCharByRef( LastAscendedCharacterRef )
	end

	if LastAscendedRivalRef ~= nil then
		LastAscendedRival = GetCharByRef( LastAscendedRivalRef )
	end

	CharBuddyPair1 = GetCharByRef( CharBuddyPair1Ref )
	CharBuddyPair2 = GetCharByRef( CharBuddyPair2Ref )

	PersistVariable({ Name = "teamRecord" })

	if lastMatchResult == nil then
		lastMatchResult = "None"
	end
	if lastMatchLocation == nil then
		lastMatchLocation = "None"
	end
	PersistVariable({ Name = "lastMatchResult" })
	PersistVariable({ Name = "lastMatchLocation" })

	if nextTeamRecord == nil then
		nextTeamRecord = "0 - 0"
		PersistVariable({ Name = "nextTeamRecord" })
	end

	--AssignCharacterToString()

end

function SetupRosterDisplay( teamIndex )

	if teamIndex == nil then
		teamIndex = 1
	end

	local teamRoster = League[teamIndex].TeamBench
	Chars = { }
	local charsFound = 0
	for k, character in ipairs( teamRoster ) do
		if character.RosterStatus ~= "Ascended" then
			charsFound = charsFound + 1
			Chars[charsFound] = teamRoster[k]
		end
	end
	Char = Chars[1]
end

function SetupEnemyRosterDisplay( teamIndex )

	local teamRoster = League[teamIndex].TeamBench
	Rivals = { }
	for k, v in ipairs(teamRoster) do
		Rivals[k] = teamRoster[k]
	end
	Rival = Rivals[1]

end

function StartCampaign()

	campaign = true
	PersistVariable({ Name = "campaign" })

	if GetConfigOptionValue({ Name = "RequestTitanMode" }) then
		TitanMode = true
		PersistVariable({ Name = "TitanMode" })
		SetConfigOption({ Name = "CampaignDifficulty", Value = "Campaign_Hard" })
	end

	SetConfigOption({ Name = "SelectedChapterIndex", Value = 0 })
	SetConfigOption({ Name = "SelectedEntryIndex", Value = 1 })

	CreateLeague()
	InitializeEventCarousels()
	StartNewSeason()

end

local FavorVsPlayerTeam = 4

function RecordWin( team, opponent )

	team.MatchesPlayed = team.MatchesPlayed + 1
	if team == PlayerTeam then
		MatchesPlayedThisSeason = MatchesPlayedThisSeason + 1
		MatchSiteVictories[CurrentMapName] = true
	end
	team.Wins = team.Wins + 1
	team.TeamLastMatchResult = "Win"

	if team.WinsSinceLastAscensionAttempt == nil then
		team.WinsSinceLastAscensionAttempt = 0
	end

	if opponent == PlayerTeam then
		team.WinsVsPlayer = team.WinsVsPlayer + 1
		team.LastWeekVsPlayer = PlayerTeam.MatchesPlayed

		if team.PyreHealth >= 70 then
			team.TeamLastMatchMemory = "BigWin"
		elseif team.PyreHealth >= 30 then
			team.TeamLastMatchMemory = "SolidWin"
		else
			team.TeamLastMatchMemory = "CloseWin"
		end

		team.WinsSinceLastAscensionAttempt = team.WinsSinceLastAscensionAttempt + FavorVsPlayerTeam
	else
		team.WinsSinceLastAscensionAttempt = team.WinsSinceLastAscensionAttempt + 1
	end


end

function RecordLoss( team, opponent )

	team.MatchesPlayed = team.MatchesPlayed + 1
	if team == PlayerTeam then
		MatchesPlayedThisSeason = MatchesPlayedThisSeason + 1
	end
	team.Losses = team.Losses + 1
	team.TeamLastMatchResult = "Loss"

	if team.WinsSinceLastAscensionAttempt == nil then
		team.WinsSinceLastAscensionAttempt = 0
	end

	if opponent == PlayerTeam then
		team.LossesVsPlayer = team.LossesVsPlayer + 1
		team.LastWeekVsPlayer = PlayerTeam.MatchesPlayed

		if opponent.PyreHealth >= 70 then
			team.TeamLastMatchMemory = "BigLoss"
		elseif opponent.PyreHealth >= 30 then
			team.TeamLastMatchMemory = "SolidLoss"
		else
			team.TeamLastMatchMemory = "CloseLoss"
		end

		team.WinsSinceLastAscensionAttempt = team.WinsSinceLastAscensionAttempt - FavorVsPlayerTeam
		if team.WinsSinceLastAscensionAttempt < 0 then
			team.WinsSinceLastAscensionAttempt = 0
		end
	end


end

function RecordMatch( teamAIndex, teamBIndex )

	local teamA = League[teamAIndex]
	local teamB = League[teamBIndex]

	-- Record wins and losses
	local winningTeam = nil
	local losingTeam = nil
	if teamA.PyreHealth > teamB.PyreHealth then
		winningTeam = teamA
		losingTeam = teamB
	else
		winningTeam = teamB
		losingTeam = teamA
	end

	RecordWin( winningTeam, losingTeam )
	RecordLoss( losingTeam, winningTeam )

	SetPostMatchActiveStatus( teamA, teamB )

	if IsMultiplayerMatch() then
		return
	end

	-- record everything for lockerroom scripts
	LastTeam = League[teamBIndex]
	LastTeamIndex = LastTeam.LeagueIndex
	PersistVariable({ Name = "LastTeamIndex" })

	lastMatchResult = League[teamAIndex].TeamLastMatchResult
	lastMatchLocation = League[teamAIndex].TeamNextMatchVenue
	PersistVariable({ Name = "lastMatchLocation" })

	-- add money
	matchLoot = 0
	DepositMoney( matchLoot )
	matchBounty = 0

	UpdateMatchesRemaining()

	-- increment Ascension Matches Played, if applicable
	if ascensionMatch then
		RecordAscensionMatch( teamA, teamB )
	end

	SimulateLeagueMatches( teamAIndex, teamBIndex )
	UpdateNextTeam()

	teamRecord = GetWinLossRecord()
	PersistVariable({ Name = "teamRecord" })

	GetNumMatchesPlayed()

	if LastWeekStandingsViewed >= PlayerTeam.MatchesPlayed - 1 then
		-- Lock in previous week rankings if the StandingsScreen was viewed
		UpdateViewedRank()
	end
	UpdateStandings()
end

function RecordAscensionMatch( teamA, teamB )

	if teamA.AscensionMatchesPlayed == nil then
		teamA.AscensionMatchesPlayed = 0
	end
	teamA.AscensionMatchesPlayed = teamA.AscensionMatchesPlayed + 1

	if teamB.AscensionMatchesPlayed == nil then
		teamB.AscensionMatchesPlayed = 0
	end
	teamB.AscensionMatchesPlayed = teamB.AscensionMatchesPlayed + 1

	teamA.WinsSinceLastAscensionAttempt = 0
	teamB.WinsSinceLastAscensionAttempt = 0

	teamA.LastAscensionMatchSeasonNum = PlayerTeam.AscensionMatchesPlayed
	teamB.LastAscensionMatchSeasonNum = PlayerTeam.AscensionMatchesPlayed

	goalNodeId = nil

end

function UpdateMatchesRemaining()
	if SeasonSchedule[PlayerTeam.AscensionMatchesPlayed + 1] == nil then
		MatchesRemainingTilAscensionMatch = 0
	else
		MatchesRemainingTilAscensionMatch = ( SeasonSchedule[PlayerTeam.AscensionMatchesPlayed + 1] - MatchesPlayedThisSeason ) - 1
	end
	PersistVariable({ Name = "MatchesRemainingTilAscensionMatch" })
end

function UpdateNextTeam()

	NextTeam = GetNextScheduledTeam()
	if NextTeam ~= nil then
		NextTeamIndex = NextTeam.LeagueIndex
		PersistVariable({ Name = "NextTeamIndex" })
		SetupNextTeamInfo()
		TagNextRival( "Story_Target" )
	end

end

function SwitchNextScheduledTeam( altTeamIndex )

	LastTeamIndex = NextTeamIndex
	LastTeam = League[LastTeamIndex]
	LastTeam.ForceNextOpponentOffer = true
	LastTeam.GotGanked = true
	LastTeam.AscensionMatchesPlayedWhenGanked = LastTeam.AscensionMatchesPlayed

	PlayerTeam.NextOpponentIndex = altTeamIndex
	UpdateNextTeam()

end

function SetupNextTeamInfo()

	PlayerTeam.NextOpponentIndex = NextTeamIndex
	-- NextTeam.TeamBench[1].TooltipIds.FullName = "NextTeamCaptain"
	-- NextTeam.TeamBench[1].TooltipIds.FirstName = "NextTeamCaptain"
	NextTeam.TeamBench[1].TooltipIds.Patron = "NextTeamCaptainPatron"
	nextTeamRecord = GetWinLossRecord( NextTeamIndex )
end

function GetNodeByLocationName( locationName )

	for nodeId, nodeData in pairs( NodeData ) do
		if nodeData.Location == locationName then
			return nodeData
		end
	end

	return nil

end

function GetAvailableVenues()

	if NodeData == nil then
		return
	end
	local availableVenues = {}

	-- Hard coded initial weeks
	if matchesPlayed == 0 then
		table.insert( availableVenues, GetNodeByLocationName( "Swath_01_Arena_01" ) )
	elseif matchesPlayed == 1 then
		table.insert( availableVenues, GetNodeByLocationName( "Swath_02_Arena_01" ) )
	elseif matchesPlayed == 2 then
		table.insert( availableVenues, GetNodeByLocationName( "Swath_02_Arena_02" ) )
	elseif matchesPlayed == 3 then
		table.insert( availableVenues, GetNodeByLocationName( "Swath_03_Arena_01" ) )
	elseif matchesPlayed == 4 then
		table.insert( availableVenues, GetNodeByLocationName( "Swath_05_Arena_01" ) )
	elseif matchesPlayed == 5 then
		table.insert( availableVenues, GetNodeByLocationName( "Swath_07_Arena_01" ) )
	elseif matchesPlayed == 6 then
		table.insert( availableVenues, GetNodeByLocationName( "Swath_07_Arena_02" ) )
	elseif matchesPlayed == 7 then
		table.insert( availableVenues, GetNodeByLocationName( "Swath_09_Arena_01" ) )
	-- MatchSiteJ / Isle of Khaylmer / HiddenArena reveal
	elseif PlayerTeam.AscensionMatchesPlayed == 2 and MatchesPlayedThisSeason == 1 then
		table.insert( availableVenues, GetNodeByLocationName( "Swath_06_Arena_01" ) )
	elseif PlayerTeam.AscensionMatchesPlayed == 6 and MatchesPlayedThisSeason == 0 then
		table.insert( availableVenues, GetNodeByLocationName( "Swath_01_Arena_01") )
		table.insert( availableVenues, GetNodeByLocationName( "Swath_02_Arena_01" ) )
		table.insert( availableVenues, GetNodeByLocationName( "Swath_02_Arena_02" ) )
	else
		-- Open game structure logic
		for k, locationData in pairs( NodeData ) do
			if IsMatchSiteAvailable( locationData, 3 ) then
				table.insert( availableVenues, locationData )
			end
		end
	end

	return availableVenues

end

function IsMatchSiteAvailable( locationData, minRepeatDuration )

	if locationData.Category ~= "Arena" then
		return false
	end

	if locationData.ObjectId == currentNodeId then
		return false
	end

	if locationData.Swath == currentlyOccupiedSwath then
		return false
	end

	-- HiddenArena / MatchSiteJ unavailable until a certain time
	if matchesPlayed < 13 and locationData.Swath == 6 then
		return false
	end

	if IsAscensionWeek() then
		-- Ascenion match
		if locationData.ObjectId ~= AscensionNodeId then
			return false
		end

		return true

	else
		-- Normal match
		if locationData.ObjectId == AscensionNodeId then
			return false
		end

		if LastWeekMatchSitePlayed[locationData.ObjectId] == nil then
			LastWeekMatchSitePlayed[locationData.ObjectId] = -999
		end
		if LastWeekMatchSitePlayed[locationData.ObjectId] + minRepeatDuration > PlayerTeam.MatchesPlayed then
			return false
		end

		return true

	end

end

function GetNumAscendedCharacters( team )

	local count = 0
	for k, character in pairs( team.TeamBench ) do
		if character.RosterStatus == "Ascended" then
			count = count + 1
		end
	end
	--[[ Reader doesn't count toward the Plan
	if team == PlayerTeam then
		if Coach.RosterStatus == "Ascended" then
			count = count + 1
		end
	end
	]]--

	return count

end

function GetVenueChoices()

	local numVenueChoices = 3
	if PlayerTeam.AscensionMatchesPlayed == 4 and MatchesPlayedThisSeason == 0 then
		numVenueChoices = 9
	end

	local remainingTeams = GetNumEligibleOpponents()
	if numVenueChoices > remainingTeams then
		numVenueChoices = remainingTeams
	end
	local availableVenues = GetAvailableVenues()

	if IsEmpty( availableVenues ) then
		return
	end

	local venueChoices = {}
	for i = 1, numVenueChoices, 1 do
		local venue = RemoveRandomValueIPairs( availableVenues )
		availableVenues = CollapseTable( availableVenues )
		table.insert( venueChoices, venue )
		if IsEmpty( availableVenues ) then
			break
		end
	end

	return venueChoices

end

function ScheduleOpponentsForVenues( venueNodes )

	local availableOpponents = GetAvailableOpponents()

	for k, nodeData in ipairs( venueNodes ) do
		local opponentIndex = nil
		if nodeData.ObjectId == AscensionNodeId then
			opponentIndex = RemoveTopStandingsRank( availableOpponents )
		else
			local forceOffer = GetForceOfferTeams( availableOpponents, nodeData.Map )
			if not IsEmpty( forceOffer ) then
				opponentIndex = RemoveRandomValueIPairs( forceOffer )
				RemoveValue( availableOpponents, opponentIndex )
			else
				local haveNotPlayedMap = GetTeamsWhichHaveNotPlayedMap( availableOpponents, nodeData.Map )
				if not IsEmpty( haveNotPlayedMap ) then
					opponentIndex = RemoveRandomValueIPairs( haveNotPlayedMap )
					RemoveValue( availableOpponents, opponentIndex )
				else
					opponentIndex = RemoveRandomValueIPairs( availableOpponents )
				end
			end
		end
		if opponentIndex ~= nil then
			nodeData.OpponentIndex = opponentIndex
			local team = League[opponentIndex]
			team.LastWeekOffered = PlayerTeam.MatchesPlayed
			team.ForceNextOpponentOffer = false
			team.NextMatchSiteNode = nodeData.ObjectId
		else
			venueNodes[k] = nil
		end
		availableOpponents = CollapseTable( availableOpponents )
	end

end

function GetForceOfferTeams( teamIndicies )

	local forceOfferTeams = {}
	for k, teamIndex in ipairs( teamIndicies ) do
		local team = League[teamIndex]
		if team.ForceNextOpponentOffer then
			table.insert( forceOfferTeams, teamIndex )
		end
	end
	return forceOfferTeams

end

function GetTeamsWhichHaveNotPlayedMap( teamIndicies, mapName )

	local haveNotPlayedMap = {}
	for k, teamIndex in ipairs( teamIndicies ) do
		local team = League[teamIndex]
		if not Contains( team.MapsPlayed, mapName ) then
			table.insert( haveNotPlayedMap, teamIndex )
		end
	end
	return haveNotPlayedMap
end

function GetAvailableOpponents()

	local availableOpponents = {}

	-- Hard coded initial weeks
	if PlayerTeam.MatchesPlayed == 0 then
		table.insert( availableOpponents, 2 )
	elseif PlayerTeam.MatchesPlayed == 1 then
		table.insert( availableOpponents, 3 )
	elseif PlayerTeam.MatchesPlayed == 2 then
		table.insert( availableOpponents, 4 )
	elseif PlayerTeam.MatchesPlayed == 3 then
		table.insert( availableOpponents, 5 )
	elseif PlayerTeam.MatchesPlayed == 4 then
		table.insert( availableOpponents, 6 )
	elseif PlayerTeam.MatchesPlayed == 5 then
		table.insert( availableOpponents, 7 )
	elseif PlayerTeam.MatchesPlayed == 6 then
		table.insert( availableOpponents, 8 )
	elseif PlayerTeam.MatchesPlayed == 7 then
		table.insert( availableOpponents, 9 )
	-- True Nightwings in final ascension match
	elseif PlayerTeam.AscensionMatchesPlayed == 6 and MatchesPlayedThisSeason == 1 then
		table.insert( availableOpponents, 11 )
	else
		-- Open structure
		-- First gather teams with repeat restrictions on
		local requestedTeams = 3
		if PlayerTeam.AscensionMatchesPlayed == 4 and MatchesPlayedThisSeason == 0 then
			requestedTeams = 9
		end

		for teamIndex, team in ipairs( League ) do
			if IsTeamEligibleOpponent( team, 3, false, true, true ) then
				table.insert( availableOpponents, teamIndex )
			end
			team.TooltipPortrait = team.TeamBench[1].SmallPortrait
		end
		if TableLength( availableOpponents ) < requestedTeams then
			-- If not enough teams were found, do a second pass ignoring some restrictions
			for teamIndex, team in ipairs( League ) do
				if not Contains( availableOpponents, teamIndex ) and IsTeamEligibleOpponent( team, 3, false, true, false ) then
					DebugPrint({ Text = "Second Pass Emergency Team: "..teamIndex })
					table.insert( availableOpponents, teamIndex )
				end
			end
		end
		if TableLength( availableOpponents ) < requestedTeams then
			-- If not enough teams were found, do a third pass ignoring more restrictions
			for teamIndex, team in ipairs( League ) do
				if not Contains( availableOpponents, teamIndex ) and IsTeamEligibleOpponent( team, 3, true, true, false ) then
					DebugPrint({ Text = "Third Pass Emergency Team: "..teamIndex })
					table.insert( availableOpponents, teamIndex )
				end
			end
		end
		if TableLength( availableOpponents ) < requestedTeams then
			-- If not enough teams were found, do a fourth pass ignoring more restrictions
			for teamIndex, team in ipairs( League ) do
				if not Contains( availableOpponents, teamIndex ) and IsTeamEligibleOpponent( team, 3, true, false, false ) then
					DebugPrint({ Text = "Fourth Pass Emergency Team: "..teamIndex })
					table.insert( availableOpponents, teamIndex )
				end
			end
		end
		if TableLength( availableOpponents ) < 2 then
			-- If not enough teams were found, do a fifth pass ignoring more restrictions
			for teamIndex, team in ipairs( League ) do
				if not Contains( availableOpponents, teamIndex ) and IsTeamEligibleOpponent( team, 4, true, false, false ) then
					DebugPrint({ Text = "Fifth Pass Emergency Team: "..teamIndex })
					table.insert( availableOpponents, teamIndex )
				end
			end
		end
		if TableLength( availableOpponents ) < 2 then
			-- If not enough teams were found, do a final pass ignoring all restrictions
			for teamIndex, team in ipairs( League ) do
				if not Contains( availableOpponents, teamIndex ) and IsTeamEligibleOpponent( team, nil, true, false, false ) then
					DebugPrint({ Text = "Sixth Pass Emergency Team: "..teamIndex })
					table.insert( availableOpponents, teamIndex )
				end
			end
		end

	end

	return availableOpponents

end

function IsTeamEligibleOpponent( team, maxMatchesVsPlayer, addAscensionCount, lastPlayedRestriction, lastOfferedRestriction )

	if team.LeagueIndex < 2 or team.LeagueIndex > 9 then
		return false
	end

	if team.Ascended or team.Forfeited then
		return false
	end

	if IsAscensionWeek() then
		return true
	end

	-- Normal match
	if team.ForceNextOpponentOffer then
		return true
	end

	if maxMatchesVsPlayer ~= nil then
		if addAscensionCount and team.AscensionMatchesPlayed >= 1 then
			maxMatchesVsPlayer = maxMatchesVsPlayer + 1
		end
		if GetMatchesVsPlayer( team ) >= maxMatchesVsPlayer then
			return false
		end
	end

	if lastPlayedRestriction then
		local minPlayedRepeatDuration = 3
		if team.LastWeekVsPlayer == nil then
			team.LastWeekVsPlayer = -999
		end
		if team.LastWeekVsPlayer + minPlayedRepeatDuration > PlayerTeam.MatchesPlayed then
			return false
		end
	end

	if lastOfferedRestriction then
		local minOfferedRepeatDuration = 1
		if team.LastWeekOffered == nil then
			team.LastWeekOffered = -999
		end
		if team.LastWeekOffered + minOfferedRepeatDuration > PlayerTeam.MatchesPlayed then
			return false
		end
	end

	return true

end

function GetNumEligibleOpponents()
	local eligibleTeams = 0
	for teamIndex, team in pairs( League ) do
		if teamIndex >= 2 and teamIndex <= 9 and not team.Ascended and not team.Forfeited then
			eligibleTeams = eligibleTeams + 1
		end
	end
	return eligibleTeams
end

function SetPostMatchActiveStatus( teamA, teamB )

	-- set all players to be unassigned
	for playerKey, playerTable in pairs( teamA.TeamBench ) do
		if playerTable.ActiveStatus == "Assigned" then
			playerTable.ActiveStatus = "PlayedLastMatch"
		end
	end

	for playerKey, playerTable in pairs( teamB.TeamBench ) do
		if playerTable.ActiveStatus == "Assigned" then
			playerTable.ActiveStatus = "PlayedLastMatch"
		end
	end

	-- Clear these so they're not saved
	teamA.AssignedCharacters = {}
	teamB.AssignedCharacters = {}

end

LastWeekStandingsViewed = LastWeekStandingsViewed or 0

function UpdateStandings()

	Standings = {}

	for teamIndex, team in pairs(League) do
		-- exclude Beyonders and True Nightwings
		if teamIndex <= 9 then
			table.insert( Standings, team )
		end
	end
	table.sort( Standings, WinsSinceLastAscensionAttemptSort )

	for rank, team in ipairs( Standings ) do
		team.StandingsRank = rank
		if team.PrevViewedRank == nil then
			team.PrevViewedRank = team.StandingsRank
		end
	end

	PersistVariable({ Name = "LastWeekStandingsViewed" })

	local challengerTeam = Standings[2]
	TagSeasonFoe( challengerTeam )

end

function UpdateViewedRank()

	for k, team in pairs( League ) do
		team.PrevViewedRank = team.StandingsRank
	end
end

function WinPercentageSort( teamA, teamB )

	local winPercentageA = teamA.Wins / (teamA.Wins + teamA.Losses)
	local winPercentageB = teamB.Wins / (teamB.Wins + teamB.Losses)

	if winPercentageA == winPercentageB then
		return teamA.Wins > teamB.Wins
	end

	return winPercentageA > winPercentageB

end

function WinsSinceLastAscensionAttemptSort( teamA, teamB )

	if teamA == PlayerTeam then
		return true
	end
	if teamB == PlayerTeam then
		return false
	end

	-- Always sort ascended or forfeited teams under those that are still active
	if teamB.Ascended or teamB.Forfeited then
		 if not teamA.Ascended and not teamA.Forfeited then
			return true
		end
	end
	if teamA.Ascended or teamA.Forfeited then
		 if not teamB.Ascended and not teamB.Forfeited then
			return false
		end
	end

	if teamA.WinsSinceLastAscensionAttempt == teamB.WinsSinceLastAscensionAttempt then
		return teamA.Wins > teamB.Wins
	end

	return teamA.WinsSinceLastAscensionAttempt > teamB.WinsSinceLastAscensionAttempt

end

function GetStandingRank( teamName )

	for rank, team in ipairs( Standings ) do

		if team.TeamName == teamName then
			return rank
		end
	end

	return nil

end

function GetNextScheduledTeamIndex()
	return PlayerTeam.NextOpponentIndex
end

function GetNextScheduledTeam()
	return League[PlayerTeam.NextOpponentIndex]
end

function GetLowestScorerAllTime()

	local lowestScore = 9999999
	local lowestScorerTable = nil

	for k, characterTable in pairs( PlayerTeam.TeamBench ) do
		if characterTable.PointsAllTime ~= nil and characterTable.PointsAllTime < lowestScore then
			lowestScore = characterTable.PointsAllTime
			lowestScorerTable = characterTable
		end
	end

	return lowestScorerTable

end

function GetLowestScorerLastMatch()

	local lowestScore = 9999999
	local lowestScorerTable = nil

	for k, characterTable in pairs( PlayerTeam.TeamBench ) do
		if characterTable.PointsLastMatch ~= nil and characterTable.PointsLastMatch < lowestScore then
			lowestScore = characterTable.PointsLastMatch
			lowestScorerTable = characterTable
		end
	end

	return lowestScorerTable

end

function GetHighestScorerAllTime()

	local highestScore = 0
	local highestScorerTable = nil

	for k, characterTable in pairs( PlayerTeam.TeamBench ) do
		if characterTable.PointsAllTime ~= nil and characterTable.PointsAllTime > highestScore then
			highestScore = characterTable.PointsAllTime
			highestScorerTable = characterTable
		end
	end

	return highestScorerTable

end

function GetHighestScorerLastMatch()

	local highestScore = 0
	local highestScorerTable = nil

	for k, characterTable in pairs( PlayerTeam.TeamBench ) do
		if characterTable.PointsLastMatch ~= nil and characterTable.PointsLastMatch > highestScore then
			highestScore = characterTable.PointsLastMatch
			highestScorerTable = characterTable
		end
	end

	return highestScorerTable

end

function GetOverlookedCharacter()

	local highest = GetHighestScorerLastMatch()
	local lowest = GetLowestScorerLastMatch()

	for k, characterTable in pairs( PlayerTeam.TeamBench ) do
		if characterTable ~= highest and characterTable ~= lowest then
			return characterTable
		end
	end

end

function GetNumMatchesPlayed()
	matchesPlayed = PlayerTeam.MatchesPlayed
	PersistVariable({ Name = "matchesPlayed" })
	return matchesPlayed
end

function GetWinLossRecord( teamIndex )

	if teamIndex == nil then
		teamIndex = 1
	end

	if teamIndex > TableLength( League ) then
		return nil
	end

	local winLossString = League[teamIndex]["Wins"].." - "..League[teamIndex]["Losses"]
	return winLossString
end

function SimulateLeagueMatches( teamAIndex, teamBIndex )

	local teamsToSimulate = { }
	for index, team in pairs( League ) do
		if team.Ascended or team.Forfeited or index == teamAIndex or index == teamBIndex or index > maxLeagueTeamSize - 1 or team.SimulatedMatchPower == nil then
			-- do nothing
		else
			table.insert( teamsToSimulate, team )
		end
	end

	local winnerTag = "Story_Prevailed"
	local loserTag = "Story_Defeated"

	-- Remove existing tags
	RemoveTagAll( winnerTag )
	RemoveTagAll( loserTag )
	local tagsApplied = false

	while TableLength( teamsToSimulate ) >= 2 do

		local simulatedTeamA = RemoveRandomValue( teamsToSimulate )
		local simulatedTeamB = RemoveRandomValue( teamsToSimulate )

		local totalPower = simulatedTeamA.SimulatedMatchPower + simulatedTeamB.SimulatedMatchPower
		local outcome = math.random( 1, totalPower )

		local winningTeam = nil
		local losingTeam = nil

		if outcome <= simulatedTeamA.SimulatedMatchPower then
			winningTeam = simulatedTeamA
			losingTeam = simulatedTeamB
		else
			winningTeam = simulatedTeamB
			losingTeam = simulatedTeamA
		end

		winningTeam.PyreHealth = math.random( 1, DEFAULT_PYRE_HEALTH )
		losingTeam.PyreHealth = 0
		RecordWin( winningTeam, losingTeam )
		RecordLoss( losingTeam, winningTeam )

		if not tagsApplied then
			AddTag( winningTeam.TeamBench[1], winnerTag )
			AddTag( losingTeam.TeamBench[1], loserTag )

			PrevailedTeamIndex = winningTeam.LeagueIndex
			DefeatedTeamIndex = losingTeam.LeagueIndex

			PersistVariable({ Name = "PrevailedTeamIndex" })
			PersistVariable({ Name = "DefeatedTeamIndex" })

			-- Update references to new tag (and remove references to old tag)
			CreateLeagueReferences()

			tagsApplied = true
		end

	end

end

OnAnyLoad
{
	function( triggerArgs )
		-- Pointers are disconnected on load and not reconnected with PersistVariable
		CreateLeagueReferences()
	end
}

function AddCharacterTrait( character, newTraitName )

	if newTraitName == nil then
		return
	end

	if Contains( character.Traits, newTraitName ) then
		-- Already applied
		return
	end

	table.insert( character.Traits, newTraitName )
	ProcessTrait( character, newTraitName )

	latestTrait = newTraitName
	PersistVariable({ Name = "latestTrait" })

end

function SubtractCharacterTrait( character, newTraitName )

	if newTraitName == nil then
		return
	end

	if not Contains( character.Traits, newTraitName ) then
		-- Doesn't actually have it
		return
	end

	RemoveValue( character.Traits, newTraitName )
	character.Traits = CollapseTable( character.Traits )
	ProcessTraitRemoval( character, newTraitName )

end

function SetNarrationCharacters( characterLookUpInfo, resetChars )

	if resetChars == nil then
		resetChars = true
	end
	if resetChars then
		Chars = { }
	end

	for k, v in pairs( characterLookUpInfo ) do

		local teamSpecificIndex = v["teamIndex"]
		local characterSpecificIndex = v["charIndex"]

		local narrationChar = League[teamSpecificIndex]["TeamBench"][characterSpecificIndex]

		if not Contains( Chars, narrationChar ) then
			table.insert( Chars, narrationChar )
		end

	end

	Char = Chars[1]

end

function SetNarrationRivals( characterLookUpInfo )

	if IsEmpty( characterLookUpInfo ) then
		return
	end

	Rivals = { }
	RivalTeams = { }

	for k, v in pairs( characterLookUpInfo ) do

		local teamSpecificIndex = v["teamIndex"]
		local characterSpecificIndex = v["charIndex"]
		Rivals[k] = League[teamSpecificIndex]["TeamBench"][characterSpecificIndex]
		RivalTeams[k] = League[ Rivals[k].TeamIndex ]

	end

end

-- random characters
function GetRandomCharactersIndices( numRandoms, teamIndex )

	AssortedCharactersTable = { }

	if numRandoms == nil then
		numRandoms = 1
	end

	if teamIndex == nil then
		teamIndex = 1
	end

	local indices = { }
	for index = 1, TableLength( League[teamIndex].TeamBench ), 1 do
		local character = League[teamIndex].TeamBench[index]
		if character ~= nil and character.RosterStatus == "Active" and not IsCharacterInEvent( character ) then
			table.insert( indices, index )
		end
	end

	for index = 1, numRandoms, 1 do
		if IsEmpty( indices ) then
			break
		end
		local randomCharacterIndex = RemoveRandomValue( indices )
		AssortedCharactersTable[index] = { }
		AssortedCharactersTable[index]["teamIndex"] = teamIndex
		AssortedCharactersTable[index]["charIndex"] = randomCharacterIndex
	end

	return AssortedCharactersTable
end

function IsCharacterInEvent( character )

	if character.TeamIndex == 1 then
		if Contains( Chars, character ) then
			return true
		end
	else
		if Contains( Rivals, character ) then
			return true
		end
	end

	return false

end

-- whole team
function GetEntireTeam( teamIndex )

	if teamIndex == nil then
		teamIndex = 1
	end

	local assortedCharactersTable = { }

	for index = 1, TableLength( League[teamIndex].TeamBench ), 1 do
		if League[teamIndex]["TeamBench"][index]["RosterStatus"] == "Active" then
			assortedCharactersTable[index] = { }
			assortedCharactersTable[index]["teamIndex"] = teamIndex
			assortedCharactersTable[index]["charIndex"] = index
		end
	end

	if teamIndex == 1 then
		SetNarrationCharacters( assortedCharactersTable )
	else
		SetNarrationRivals( assortedCharactersTable )
	end

end

-- story tags
function SetStoryTag( storyTag )

	if Chars ~= nil then
		for key, charData in pairs( Chars ) do
			AddTag( charData, storyTag )
		end
	end

	if Rivals ~= nil then
		for key, rivalData in pairs( Rivals ) do
			AddTag( rivalData, storyTag )
		end
	end

end

function GetStoryTaggedCharacters( storyTags, resetChars )

	if resetChars == nil then
		resetChars = true
	end
	if resetChars then
		Chars = {}
	end

	local foundRival = false

	for k, storyTag in ipairs( storyTags ) do
		local character = CharacterTags[storyTag]
		if character.TeamIndex == nil or character.TeamIndex == 1 then
			table.insert( Chars, character )
		else
			if not foundRival then
				Rivals = { }
				foundRival = true
			end
			table.insert( Rivals, character )
		end
	end

	Char = Chars[1]

end

function IsOnArenaNode()
	local nodeData = NodeData[currentNodeId]
	if nodeData ~= nil and nodeData.Category == "Arena" then
		return true
	end
	return false
end

function GetNextMatchMap()

	local numMatches = GetNumMatchesPlayed()

	if numMatches < 1 then
		nextMatchMap = "MatchSiteB"
	elseif numMatches == 1 then
		nextMatchMap = "MatchSiteC"
	elseif numMatches == 2 then
		nextMatchMap = "MatchSiteD"
	elseif numMatches == 3 then
		nextMatchMap = "MatchSiteE"
	elseif numMatches == 4 then
		nextMatchMap = "MatchSiteF"
	elseif numMatches == 5 then
		nextMatchMap = "MatchSiteG"
	elseif numMatches == 6 then
		nextMatchMap = "MatchSiteH"
	elseif numMatches == 7 then
		nextMatchMap = "MatchSiteI"
	else
		UpdateCurrentNodeData()
		nextMatchMap = currentNodeData.Map
	end

	return nextMatchMap
end

function CameFromMatch()

	-- A normal Season match
	if cameFromSeasonMatch then
		return true
	else
		return false
	end

end

function JustCameFromMatch()

	-- A normal Season match
	if movedSinceLastMatch then
		return false
	end

	if cameFromSeasonMatch then
		return true
	else
		return false
	end

end

function CameFromAnyMatch()

	-- A normal Season match or practice match
	if CameFromMatch() then
		return true
	end

	if cameFromFreePlayMatch or cameFromChallengeMatch then
		return true
	end

	return false

end

function JustCameFromAnyMatch()

	-- A normal League match or practice match
	if JustCameFromMatch() then
		return true
	end

	if cameFromFreePlayMatch or cameFromChallengeMatch then
		return true
	end

	return false

end

function JustCameFromPracticeMatch()

	if cameFromFreePlayMatch or cameFromChallengeMatch then
		return true
	end

	return false

end

function JustCameFromRivalryMatch()

	-- a Season match that was a Rivalry match (specific character face-off)
	if JustCameFromMatch() and rivalryMatch then
		return true
	end

	return false

end

function CameFromAscensionMatch()

	if cameFromAscensionMatch then
		return true
	else
		return false
	end

end

function JustCameFromAscensionMatch()

	if movedSinceLastMatch then
		return false
	end

	if cameFromAscensionMatch then
		return true
	else
		return false
	end

end

function CameFromEncounter()

	if LegalEncounterMaps[pvPreviousMap] then
		return true
	else
		return false
	end

end

function JustCameFromEncounter()

	if movedSinceLastEncounter then
		return false
	end

	if LegalEncounterMaps[pvPreviousMap] then
		return true
	else
		return false
	end

end

LegalEncounterMaps = ToLookup({ "ScenarioDefense", "ScenarioBrawl", "ScenarioRetrieval" })
