-- Ursa Audio

-- **Misc SFX**
-- Masked Audio / Masked Effect
function ToggleVocalsState( args )
	if args == "match" then
		SetSoundCueValue({ Id = GetMixingId({}), Names = {"VocalsAltState"}, Value = 1.0 })
	else
		SetSoundCueValue({ Id = GetMixingId({}), Names = {"VocalsAltState"}, Value = 0.0 })
	end
end

function PlayedMiscSoundRecently()
	if playedMiscSoundRecently then
		return
	end

	if not playedMiscSoundRecently then
		playedMiscSoundRecently = true
		local soundDelay = math.random(1,1)
		wait( soundDelay )
		playedMiscSoundRecently = false
	end
end

-- **MUSIC PLAYBACK**
MatchTrackList = ToLookup({ "/Music/MatchMusic2_MC", "/Music/UrsaIdea8_MC", "/Music/MatchMusic7_MC", "/Music/DissidentsTheme_MC", "/Music/WithdrawnTheme_MC","/Music/MatchMusic8_MC", "/Music/EssenceTheme_MC", "/Music/MatchMusic3_MC", "/Music/MatchMusic4_MC", "/Music/MatchMusic5_MC", "/Music/MatchMusic6_MC", })
LocalMPMusicOptions = { "LocalMP_MusicRandom", "LocalMP_MusicTeam", "/Music/MatchMusic2_MC", "/Music/UrsaIdea8_MC", "/Music/MatchMusic7_MC", "/Music/DissidentsTheme_MC", "/Music/WithdrawnTheme_MC","/Music/MatchMusic8_MC", "/Music/EssenceTheme_MC", "/Music/MatchMusic3_MC", "/Music/MatchMusic4_MC", "/Music/MatchMusic5_MC", "/Music/MatchMusic6_MC" }

CharacterMusicTrackList = ToLookup({ "/Music/ScavengersTheme_MC", "/Music/MaeTheme_MC", "/Music/ImpTheme_MC", "/Music/GilmanTheme_MC", "/Music/PamithaTheme_MC", "/Music/VolfredTheme_MC", "/Music/BertrudeTheme_MC", "/Music/BardTheme_MC" })

SongTrackList = { "/Music/TrailerSong", "/Music/TrailerSong_ACOUSTIC", "/Music/VagrantSong", "/Music/VagrantSong_ACOUSTIC" }

AscensionMusicTrackList = { "/Music/AscensionMatchMusic1_MC", "/Music/AscensionMatchMusicAccusers_MC", "/Music/AscensionMatchMusicFate_MC", "/Music/AscensionMatchMusicDissidents_MC", "/Music/AscensionMatchMusicWithdrawn_MC", "/Music/AscensionMatchMusicPyrehearts_MC", "/Music/AscensionMatchMusicEssence_MC", "/Music/AscensionMatchMusicChastity_MC", "/Music/AscensionMatchMusicTempers_MC", "/Music/AscensionMatchMusicNightwings_MC" }

-- Music Player
-- Overmap Music by Swath
function SwathMusic( delay )
	if delay == nil then
		delay = 0
	end

	if demoPan then
		return
	end

	if IsSongMusic() then
		-- TrailerSong / Trailer Song -- dealing with looping version
		if PlayerTeam.AscensionMatchesPlayed ~= 6 then
			return
		end
	end

	if delay > 0 then
		wait( delay )
	end

	if caravanFlying then
		if not airshipThemePlaying then
			-- SetOvermapMusic( "end" )
			-- waitUntil( "MusicTrackEnded" )
			if GetMusicName({ }) ~= "/Music/VolfredTheme_MC" and not IsAscensionWeek() then
				FadeMusicOut({ Duration = 1.0 })
			end
			wait( delay )
			-- Airship Theme ascension Week exceptions
			if IsAscensionWeek() then
				-- Final Voyage music
				if PlayerTeam.AscensionMatchesPlayed == 6 then
					airshipThemePlaying = true
					finalVoyage = true
				else
					airshipThemePlaying = true
					-- MusicPlayer( "/Music/OvermapMusicINTRO" )
				end
			else
				airshipThemePlaying = true
				if MusicName ~= nil and MusicName == "/Music/VolfredTheme_MC" then
					local musicId = GetMusicId()
					SetDefaultMusicParams( MusicName, musicId )
				else
					MusicPlayer( "/Music/VolfredTheme_MC" )
				end
			end
		end
	else
		if IsMusicPlaying() then
			local track = GetMusicName({ })
			if not JustCameFromMatch() and ( ( track ~= "/Music/UrsaIdea7_MC" and CharacterMusicTrackList[track] == nil ) or airshipThemePlaying ) then
				SetOvermapMusic( "end" )
				FadeMusicOut({ Duration = 3.0 })
				-- waitUntil( "MusicTrackEnded" )
				waitScreenTime(5.0)
				-- waitScreenTime(12.0)
			else
				FadeMusicOut({ Duration = 3.0 })
				waitScreenTime(3.0)
			end
		end

		if IsScreenOpen({ Name = "ItemPurchaseScreen" }) then
			return
		end

		if caravanLandedRecently and airshipThemePlaying then
			airshipThemePlaying = false
		end

		-- return out if Character Music is playing already
		if IsMusicPlaying() and CharacterMusicTrackList[MusicName] then
			return
		end

		if currentNodeId == goalNodeId then
			if JustCameFromMatch() or JustCameFromAscensionMatch() then
				--
			else
				return
			end
		end

		if currentlyOccupiedSwath == 1 then
			MusicPlayer( "/Music/OvermapMusic1_MC" )
		elseif currentlyOccupiedSwath == 2 then
			-- return out after week 1 as an exception (Mae theme plays soon after)
			if matchesPlayed == 1 and previousNodeId == 10010 then
				return
			end
			MusicPlayer( "/Music/OvermapMusic2_MC" )
		elseif currentlyOccupiedSwath == 3 then
			MusicPlayer( "/Music/OvermapMusic5_MC" )
		elseif currentlyOccupiedSwath == 4 or currentlyOccupiedSwath == 5 then
			MusicPlayer( "/Music/OvermapMusic4_MC" )
		elseif currentlyOccupiedSwath == 6 then
			if MusicName == SeaShantyTrackName then
				FireTrigger({ Name = "PlaySeaShanty" })
			end
		elseif currentlyOccupiedSwath == 7 then
			if MusicName ~= SeaShantyTrackName then
				MusicPlayer( "/Music/OvermapMusic6_MC" )
			end
		elseif currentlyOccupiedSwath == 8 then
			--
		elseif currentlyOccupiedSwath == 9 and MatchesPlayedThisSeason ~= 0 then
			MusicPlayer( "/Music/OvermapMusicSwath9_MC" )
		end

	end

	if kumbaya then
		kumbaya = false
	end

end

function IsMusicPlaying()
	if MusicId ~= nil and MusicId > 0 then
		return true
	end
	return false
end

-- Travel Music: this runs when the wagon is moving on the Campaign map
function TravelMusic( args )
	-- start swath music when you move if music isn't playing
	if not IsMusicPlaying() then
		thread(SwathMusic, 0.5 )
		return
	end
	-- revert to swath music if character music is playing
	if IsMusicPlaying() then
		-- end character music when you move
		if IsCharacterMusic() then
			if matchesPlayed == 2 and not NarrationRecord["NightWatchA"] then
				-- keep playing bard music in week 3
			else
				thread( CharacterMusic, "end" )
				return
			end
		end
		-- end swath music on approach to match sites
		if selectedNodeId == goalNodeId then
			-- don't end music in week 1 at Ridge
			if matchesPlayed > 0 then
				SetOvermapMusic( "end" )
			end
		end
	end
end

-- Song Music: Ends after Packing Up (used in certain scenes)
function StopSongMusic()
	if not IsSongMusic() then
		return
	end
	FireTrigger({ Name = "EndCurrentMusic" })
end

-- Character Themes
function CharacterMusic( args, character )

	local musicId = GetMusicId({ })

	airshipThemePlaying = false

	CharacterMusicQueued = character

	if IsMusicPlaying() and not IsMultiplayerMatch() then
		if not JustCameFromMatch() then
			SetOvermapMusic( "end" )
			waitScreenTime(3.0)
			FadeMusicOut({ Duration = 2.0 })
			waitScreenTime(1.0)
		else
			FadeMusicOut({ Duration = 3.0 })
			waitScreenTime(4.0)
		end
	end

	if args ~= "end" then

		if CharacterMusicQueued == nil then
			-- The request to start this music has been canceled
			return
		end

		if args ~= "bardsong" then
			-- Hedwyn Theme, Jodi, and Rukey)
			if character == CharFriend then
				kumbaya = true
				MusicPlayer( "/Music/ScavengersTheme_MC" )
				musicId = MusicId
				SetSoundCueValue({ Names = { "Mandolins" }, Id = musicId, Value = 1, Duration = duration })
			elseif character == CharBadass then
				kumbaya = true
				MusicPlayer( "/Music/ScavengersTheme_MC" )
				musicId = MusicId
				SetSoundCueValue({ Names = { "Toms" }, Id = musicId, Value = 1, Duration = duration })
			elseif character == CharJoker then
				kumbaya = true
				MusicPlayer( "/Music/ScavengersTheme_MC" )
				musicId = MusicId
				SetSoundCueValue({ Names = { "Flutes" }, Id = musicId, Value = 1, Duration = duration })
			else
				if character ~= nil then
					MusicPlayer( character.MusicTheme )
					musicId = MusicId
				end
			end
		else
			-- Bard Songs
			-- Forbidden Knowledge
			if ActiveNarrationName == "BardSong_01" then
				MusicPlayer( "/Music/MatchMusic2_MC" )
			end
		end
	end

	if args == "end" then
		SetSoundCueValue({ Names = { "Guitars" }, Id = musicId, Value = 1, Duration = 0.5 })
		SetSoundCueValue({ Names = { "End" }, Id = musicId, Value = 1 })
		waitUntil( "MusicTrackEnded" )
		if currentNodeId ~= goalNodeId then
			thread(SwathMusic, 1.0)
		end
		kumbaya = false
	end

end

OnTriggerFired
{ "EndKumbaya",
	function(triggerArgs)
		kumbaya = false
	end
}

-- Music Marker logic
OnMusicMarker{ "MarkerEnd",
	function( triggerArgs )
		local markerName = triggerArgs.name
		if markerName == "Marker End" then
			notifyExistingWaiters( "MusicTrackEnded" )
		end
	end
}

-- Music: Character Themes
OnTriggerFired
{ "PlayScavengersTheme",
	function(triggerArgs)
		kumbaya = true
		MusicPlayer( "/Music/ScavengersTheme_MC" )
	end
}

OnTriggerFired
{ "PlayFriendTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, CharFriend )
	end
}

OnTriggerFired
{ "PlayJokerTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, CharJoker )
	end
}

OnTriggerFired
{ "PlayBadassTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, CharBadass )
	end
}

OnTriggerFired
{ "PlayPsychoTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, CharPsycho )
	end
}

OnTriggerFired
{ "PlayMascotTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, CharMascot )
	end
}

OnTriggerFired
{ "PlayKnightTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, CharKnight )
	end
}

OnTriggerFired
{ "PlayVampTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, CharVamp )
	end
}

OnTriggerFired
{ "PlayDocTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, CharDoc )
	end
}

OnTriggerFired
{ "PlayDivaTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, CharDiva )
	end
}

OnTriggerFired
{ "PlayBardTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, CharBard )
	end
}

OnTriggerFired
{ "PlayBardDuet",
	function(triggerArgs)
		PlaySound({ Name = "/Music/BardDuet_3d", Id = currentNodeId, Delay = 1.0 })
	end
}


OnTriggerFired
{ "StopBardDuet",
	function(triggerArgs)
		StopSound({ Name = "/Music/BardDuet_3d", Duration = 0.5 })
	end
}

SeaShantyTrackName = "/Music/VagrantSong"

OnTriggerFired
{ "PlaySeaShanty",
	function(triggerArgs)
		MusicPlayer( SeaShantyTrackName )
		SetSoundCueValue({ Name = "Vocals", Id = GetMusicId(), Value = 1.0 })
	end
}

OnTriggerFired
{ "PlayFinalVoyageSong",
	function(triggerArgs)
		MusicPlayer( "/Music/TrailerSong_ACOUSTIC" )
		SetSoundCueValue({ Name = "Vocals", Id = GetMusicId(), Value = 1.0 })
	end
}

OnTriggerFired
{ "PlayShopKeeperTheme",
	function(triggerArgs)
		-- thread( CharacterMusic, nil, CharShopKeeper )
		thread( CrossfadeNewMusicTrack, "/Music/ShopkeeperTheme_MC" )
	end
}

OnTriggerFired
{ "PlayAccuserTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, RivalAccuser )
	end
}

OnTriggerFired
{ "PlayFateTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, RivalFateDad )
	end
}

OnTriggerFired
{ "PlayDissidentTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, RivalDissident )
	end
}

OnTriggerFired
{ "PlayWithdrawnTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, RivalWithdrawn )
	end
}

OnTriggerFired
{ "PlayPyreheartTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, RivalPyreheart )
	end
}

OnTriggerFired
{ "PlayEssenceTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, RivalEssence )
	end
}

OnTriggerFired
{ "PlayChastityTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, RivalChastity )
	end
}

OnTriggerFired
{ "PlayTemperTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, RivalTemper )
	end
}

OnTriggerFired
{ "PlayBeyonderTheme",
	function(triggerArgs)
		PauseSound({ Id = OvermapMusicId, Duration = 0.5 })
		waitScreenTime( 0.3 )
		-- Play beyonder track
		local beyonderTrack = "/Music/MatchMusic2_MC"
		BeyonderMusicId = PlaySound({ Name = beyonderTrack, AddCallbacks = true })
		SetDefaultMusicParams( beyonderTrack, BeyonderMusicId )
	end
}

OnTriggerFired
{ "PlayNightwingTheme",
	function(triggerArgs)
		thread( CharacterMusic, nil, RivalNightwing )
	end
}

OnTriggerFired
{ "PlayTeamVictoryStinger",
	function(triggerArgs)
		local winner = GetCharacterDataByStoryTag( "Story_Winner" )
		thread( CharacterMusic, nil, winner )
		SetSoundCueValue({ Names = { "Guitars" }, Id = GetMusicId({ }), Value = 1, Duration = 0.5 })
		SetSoundCueValue({ Names = { "End" }, Id = GetMusicId({ }), Delay = 3, Value = 1 })
	end
}

OnTriggerFired
{ "PlayRivalTheme",
	function(triggerArgs)
		local rival = GetCharacterDataByStoryTag( "Story_Target" )
		thread( CharacterMusic, nil, rival )
	end
}

OnTriggerFired
{ "PlayBardMusic",
	function(triggerArgs)
		thread( CharacterMusic, "bardsong", CharBard )
	end
}

-- **Default Music and Audio State**
function SetCampaignMusicAndAmbience()

	if not introComplete then
		return
	end

	thread( SwathAmbience )
	thread( ToggleVocalsState )

	-- Start Playing Music On Load
	if CameFromEncounter() and matchesPlayed == 2 then
		-- Mascot music after ScenarioDefense
		wait(2.5)
		thread( CharacterMusic, nil, CharMascot )
	elseif matchesPlayed == 1 and currentlyOccupiedSwath == 1 then
		if goalNodeId == 210298 then
			wait(1.25)
			FireTrigger({ Name = "PlayScavengersTheme" })
		else
			-- no music after Accusers match (Scavengers Theme plays soon)
		end
	elseif matchesPlayed == 2 then
		-- Bard music after Fate match
		wait(1.5)
		if currentNodeId ~= 10004 then
			thread( CharacterMusic, nil, CharBard )
		end
	elseif currentlyOccupiedSwath == 5 and pvPreviousMap == "ScenarioRetrieval" then
		-- no music returning from Scenario Retrieval (Gilman Theme starts soon after)
	elseif currentlyOccupiedSwath == 6 and PlayerTeam.AscensionMatchesPlayed == 0 and currentNodeId == 40184 then
		-- loading into Deathless Tempest
		wait(1.5)
		FireTrigger({ Name = "PlaySeaShanty" })
	elseif currentlyOccupiedSwath == 9 and not IsAscensionWeek() then
		-- Post-Ascension Music
		wait(5.5)
		MusicPlayer( "/Music/UrsaIdea6_MC" )
	elseif JustCameFromMatch() and PlayerTeam.AscensionMatchesPlayed == 2 and MatchesPlayedThisSeason == 3 then
		-- no music after True Nightwings match
	elseif allowCaravanFly and IsAscensionWeek() and goalNodeId == 10049 then
		if PlayerTeam.AscensionMatchesPlayed < 6 then
			-- Bard Theme during ascension weeks in Open Structure
			wait(1.25)
			FireTrigger({ Name = "PlayBardTheme" })
		else
			-- no music here for final ascension season
		end
	else
		-- Swath Music for general cases
		wait( 1.0 )
		thread( SwathMusic )
	end

	if matchesPlayed == 2 and not NarrationRecord["NightWatchA"] then
		LocationSpecialAmbience( currentNodeId )
	end

	local loopFixData = LoopFixData[MusicName]
	if loopFixData ~= nil then
		SetVolume({ Id = MusicId, Value = 0.0 })
		SetSoundPosition({ Id = MusicId, Position = loopFixData.Position * 1000 })
		wait(loopFixData.FadeInDelay)
		SetVolume({ Id = MusicId, Value = 1.0, Duration = 0.5 })
		wait(0.02)
	end

end

LoopFixData =
{
	["/Music/ScavengersTheme_MC"] = { Position = 194, FadeInDelay = 2.0 },
	["/Music/BardTheme_MC"] = { Position = 65, FadeInDelay = 1.3 },
	["/Music/ImpTheme_MC"] = { Position = 69, FadeInDelay = 1.25 },
	["/Music/OvermapMusic2_MC"] = { Position = 204, FadeInDelay = 1.2 },
	["/Music/OvermapMusic5_MC"] = { Position = 197, FadeInDelay = 1 },
	["/Music/OvermapMusic4_MC"] = { Position = 273.5, FadeInDelay = 1.3 },
	["/Music/OvermapMusic6_MC"] = { Position = 214, FadeInDelay = 1.1 },
	["/Music/OvermapMusic1_MC"] = { Position = 273.5, FadeInDelay = 1.1 },
	["/Music/OvermapMusic3_MC"] = { Position = 226.5, FadeInDelay = 1 },
	["/Music/OvermapMusicSwath9_MC"] = { Position = 229, FadeInDelay = 1.1 },
	["/Music/VolfredTheme_MC"] = { Position = 84.4, FadeInDelay = 1 },
	["/Music/ShopkeeperTheme_MC"] = { Position = 181.5, FadeInDelay = 1.1 },
	["/Music/PamithaTheme_MC"] = { Position = 60, FadeInDelay = 1 },
	["/Music/MaeTheme_MC"]= { Position = 69.5, FadeInDelay = 1.2 },
	["/Music/GilmanTheme_MC"] = { Position = 74, FadeInDelay = 1.2 },
	["/Music/BertrudeTheme_MC"] = { Position = 92, FadeInDelay = 1.4 },
}

OnAnyLoad
{
	function( triggerArgs )

		PersistVariable({ Name = "MusicName" })
		PersistVariable({ Name = "MusicId" })
		PersistVariable({ Name = "PausedMusicName" })
		PersistVariable({ Name = "PausedMusicId" })
		PersistVariable({ Name = "EndingMusicId" })
		PersistVariable({ Name = "BeyonderMusicId" })

		PersistVariable({ Name = "AmbienceId" })
		PersistVariable({ Name = "AmbienceId2" })
		PersistVariable({ Name = "currentAmbience" })
		PersistVariable({ Name = "currentAmbience2" })

		SetSoundCueValue({ Id = GetMixingId({}), Names = { "LowPass" }, Value = 0.0 })
	end
}

function PlaySwath0TransitionMusic()
	thread( SwathAmbience )
	FadeOutAmbience( 10 )
	wait(5)
	MusicPlayer( "/Music/OvermapMusic1_MC" )
end

function MusicPlayerDelayedStart( trackName, delay )
	wait( delay )
	MusicPlayer( trackName )
end

-- for Bard Music Player
function BardMusicPlayer( trackName )
	if trackName == nil then
		return
	end
	if trackName == "end" then
		if BardMusicId ~= nil then
			-- if you choose the 'no thanks' option and music is playing
			StopSound({ Id = BardMusicId, Duration = 1.0 })
			BardMusicId = nil
			BardTrackName = nil
		end
		ResumeSound({ Id = OvermapMusicId, Duration = 2.0 })
		thread( WagonAmbienceOn )
		return
	else
		-- otherwise, play the selected track
		if trackName ~= "end" then
			FadeOutAllAmbience( 0.5 )
			thread( NewBardMusicPlayerTrack, trackName )
		end
	end
end

function NewBardMusicPlayerTrack( trackName )

	if trackName == MusicName then
		-- If the requested BardTrack is the same as the current overmap music
		BardTrackName = trackName
		SetSoundCueValue({ Names = { "Guitars", }, Id = MusicId, Value = 1 })
		SetSoundCueValue({ Names = { "Bass", "Drums", "Flutes", "Toms", "Mandolins" }, Id = MusicId, Value = 0 })
		ResumeSound({ Id = MusicId, Duration = 0.5 })
		StopSound({ Id = BardMusicId, Duration = 0.5 })
		BardMusicId = nil
		return
	end

	if BardMusicId == nil then
		-- Crossfade the first chosen track over the Overmap music
		-- Get rid of any old paused track
		ResumeSound({ Id = PausedMusicId })
		StopSound({ Id = PausedMusicId })
		-- Fade out current track
		PauseSound({ Id = OvermapMusicId, Duration = 0.5 })
		waitScreenTime(0.5)
		if openedCaravan and not caravanClosing and not IsScreenOpen({ Name = "DialogueScreen" }) then
			-- If caravan hasn't been closed by the time the track wants to start
			-- Play new bard track
			BardTrackName = trackName
			BardMusicId = PlaySound({ Name = trackName, AddCallbacks = true })
			SetDefaultMusicParams( trackName, BardMusicId )
		end
	else
		-- If another track is chosen, end the current one and play the new one normally
		StopSound({ Id = BardMusicId, Value = 0.0, Duration = 0.5 })
		waitScreenTime(0.5)
		if openedCaravan and not caravanClosing and not IsScreenOpen({ Name = "DialogueScreen" }) then
			-- If caravan hasn't been closed by the time the track wants to start
			-- Play new bard track
			BardTrackName = trackName
			BardMusicId = PlaySound({ Name = trackName, AddCallbacks = true })
			SetDefaultMusicParams( trackName, BardMusicId )
		end
	end
	UnlockAchievementOnce( "AchMusicPlayer" )
end

-- Epilogue Song / End Song
function PlayEndSong()
	endSongPlaying = true
	MusicPlayer( "/Music/EndSong_MC" )
	if Coach.Gender == "Char_Gender_Female" then
		SetSoundCueValue({ Names = { "Gender" }, Id = GetMusicId(), Value = 0 })
	elseif Coach.Gender == "Char_Gender_Male" then
		SetSoundCueValue({ Names = { "Gender" }, Id = GetMusicId(), Value = 1 })
	elseif Coach.Gender == "Char_Gender_X" then
		SetSoundCueValue({ Names = { "Gender" }, Id = GetMusicId(), Value = 2 })
	end

	PauseSound({ Id = EpilogueAmbienceId, Duration = 0.5 })
	EpilogueAmbienceId = nil

	endSongStartTime = _worldTime
	DebugPrint({ Text = "End Song is starting at "..tostring(endSongStartTime) })
end

-- Epilogue Song / End Song
OnMusicMarker{ "MarkerFriend MarkerBadass MarkerJoker MarkerPsycho MarkerMascot MarkerKnight MarkerVamp MarkerDoc MarkerDiva MarkerCoach MarkerEnd",
	function( triggerArgs )
		if endSongPlaying then
			local markerName = triggerArgs.name
			local outcomeValue = 1
			if markerName == "MarkerFriend" and CharFriend.RosterStatus == "Ascended" then
				outcomeValue = 0
			elseif markerName == "MarkerBadass" and CharBadass.RosterStatus == "Ascended" then
				outcomeValue = 0
			elseif markerName == "MarkerJoker" and CharJoker.RosterStatus == "Ascended" then
				outcomeValue = 0
			elseif markerName == "MarkerPsycho" and CharPsycho.RosterStatus == "Ascended" then
				outcomeValue = 0
			elseif markerName == "MarkerMascot" and CharMascot.RosterStatus == "Ascended" then
				outcomeValue = 0
			elseif markerName == "MarkerKnight" and CharKnight.RosterStatus == "Ascended" then
				outcomeValue = 0
			elseif markerName == "MarkerVamp" and CharVamp.RosterStatus == "Ascended" then
				outcomeValue = 0
			elseif markerName == "MarkerDoc" and CharDoc.RosterStatus == "Ascended" then
				outcomeValue = 0
			elseif markerName == "MarkerDiva" and CharDiva.RosterStatus == "Ascended" then
				outcomeValue = 0
			elseif markerName == "MarkerCoach" and Coach.RosterStatus == "Ascended" then
				outcomeValue = 0
			elseif markerName == "MarkerEnd" then
				endSongPlaying = false
			end
			SetSoundCueValue({ Names = { "Outcome" }, Id = GetMusicId(), Value = outcomeValue })

			local elapsedTime = _worldTime - endSongStartTime
			DebugPrint({ Text = markerName.." is starting at "..tostring(elapsedTime) })
		end
	end
}

function GetMusicId()
	return MusicId
end

function GetMusicName()
	return MusicName
end

function PauseMusic()
	PauseSound({ Id = MusicId })
end

function ResumeMusic()
	ResumeSound({ Id = MusicId })
end

function FadeMusicOut( params )
	if params.MusicId == nil then
		params.MusicId = MusicId
	end
	StopSound({ Id = params.MusicId, Value = 0.0, Duration = params.Duration })
	MusicName = nil
	MusicId = nil
end

function SoundFadeOutAndPause( params )
	if params.SoundId == nil then
		return
	end
	SetVolume({ Id = params.SoundId, Value = 0.0, Duration = params.Duration })
	thread( DelayedSoundPause, params )
end

function DelayedSoundPause( params )
	if params.Duration ~= nil and params.Duration > 0 then
		waitScreenTime( params.Duration )
	end
	PauseSound({ Id = params.SoundId })
end

function SoundFadeInAndResume( params )
	if params.SoundId == nil then
		return
	end
	SetVolume({ Id = params.SoundId, Value = 1.0, Duration = params.Duration })
	thread( DelayedSoundResume, params )
end

function DelayedSoundResume( params )
	if params.Duration ~= nil and params.Duration > 0 then
		waitScreenTime( params.Duration )
	end
	ResumeSound({ Id = params.SoundId })
end

function DelayedMusicPlay( params )
	if params.Duration ~= nil and params.Duration > 0 then
		wait( params.Duration )
	end
	MusicPlayer( params.TrackName, params.MusicInfo )
end

function FadeMusicIn( params )
	SetVolume({ Id = MusicId, Value = 0.0, Duration = params.Duration })
end

function CrossfadeNewMusicTrack( newTrackName, crossfadeTime, newTrackStartWait, musicInfo )

	if MusicName ~= nil and MusicName == newTrackName then
		-- Don't cross-fade in an identical track
		return
	end

	if crossfadeTime == nil then
		crossfadeTime = 1.0
	end
	if newTrackStartWait == nil then
		newTrackStartWait = crossfadeTime * 0.75
	end

	-- Get rid of any old paused track
	ResumeSound({ Id = PausedMusicId })
	StopSound({ Id = PausedMusicId })

	-- Fade out current track
	PausedMusicId = MusicId
	PausedMusicName = MusicName
	SetVolume({ Id = PausedMusicId, Value = 0.0, Duration = crossfadeTime })

	if newTrackStartWait > 0 then
		waitScreenTime( newTrackStartWait )
	end

	-- Play new track
	MusicName = newTrackName
	MusicId = PlaySound({ Name = MusicName })
	SetDefaultMusicParams( MusicName, MusicId )

	if musicInfo ~= nil then
		musicInfo.Name = MusicName
		musicInfo.Id = MusicId
	end

	-- Pause previous track once faded out
	local pauseWait = crossfadeTime - newTrackStartWait
	if pauseWait > 0 then
		waitScreenTime( pauseWait )
	end
	PauseSound({ Id = PausedMusicId })

end

function ResumePausedMusicTrack( crossfadeTime, delay )

	if delay ~= nil and delay > 0 then
		wait( delay )
	end

	-- Fade out current track
	SetVolume({ Id = MusicId, Value = 0.0, Duration = crossfadeTime })

	-- Resume and fade in paused track
	ResumeSound({ Id = PausedMusicId })
	SetVolume({ Id = PausedMusicId, Value = 1.0, Duration = crossfadeTime })

	-- Swap back to current track
	local currentMusicId = MusicId
	local currentMusicName = MusicName
	MusicId = PausedMusicId
	MusicName = PausedMusicName
	PausedMusicId = currentMusicId
	PausedMusicName = currentMusicName

	-- Pause previous track once faded out
	waitScreenTime( crossfadeTime )
	PauseSound({ Id = PausedMusicId })

end

function DelayedMusicResume( musicId, crossfadeTime, delay )

	if delay ~= nil and delay > 0 then
		wait( delay )
	end

	-- Resume and fade in paused track
	ResumeSound({ Id = musicId })
	SetVolume({ Id = musicId, Value = 1.0, Duration = crossfadeTime })

end

function ResetMusicState()
	MusicId = nil
	MusicName = nil
	PauseMusicId = nil
	PausedMusicName = nil
end

function StartupMusic( trackName )

	ResetMusicState()
	MusicPlayer( trackName )

end

function MusicPlayer( trackName, musicInfo )

	if trackName == nil then
		return
	end

	if MusicName ~= nil and MusicName == trackName then
		-- Don't play an identical track that's already playing
		return
	end

	if trading and trackName ~= "/Music/ShopkeeperTheme_MC" then
		-- Block other tracks while in the shop
		return
	end

	if EndingMusicId ~= nil then
		StopSound({ Id = EndingMusicId, Duration = 0.25 })
		EndingMusicId = nil
	end

	if MusicId ~= nil then
		StopSound({ Id = MusicId })
	end
	MusicName = trackName
	MusicId = PlaySound({ Name = MusicName, AddCallbacks = true })
	SetDefaultMusicParams( MusicName, MusicId )

	if musicInfo ~= nil then
		musicInfo.Id = MusicId
		musicInfo.Name = MusicName
	end

end

function SetDefaultMusicParams( trackName, musicId )

	local mixingId = GetMixingId({ })
	local currentMap = CurrentMapName

	if trackName == "/Music/OvermapMusic3_MC" and ( IsScreenOpen({ Name = "LocalMPScreen" }) or IsMultiplayerMatch() ) then
		SetSoundCueValue({ Names = { "Bass", "Drums", "Guitars" }, Id = musicId, Value = 1, Duration = 0.15 })
		SetSoundCueValue({ Names = { "Misc", "Flutes", "Mandolins" }, Id = musicId, Value = 0 })
		return
	end

	if musicId == BardMusicId then
		SetSoundCueValue({ Names = { "Guitars", }, Id = musicId, Value = 1 })
		SetSoundCueValue({ Names = { "Bass", "Drums", "Flutes", "Toms", "Mandolins" }, Id = musicId, Value = 0 })
		return
	end

	if ( currentMap == "Campaign" and introComplete ) or CharacterMusicTrackList[trackName] then
		if not IsMatchMusic() or CharacterMusicTrackList[trackName] then
			if trackName == "/Music/ShopkeeperTheme_MC" then
				if IsScreenOpen({ Name = "DialogueScreen" }) then
					SetSoundCueValue({ Names = { "Guitars", "Keys", "Misc", "Bass", }, Id = musicId, Value = 1 })
					SetSoundCueValue({ Names = { "Mandolins", "Flutes", "End", "Drums" }, Id = musicId, Value = 0 })
				else
					SetSoundCueValue({ Names = { "Guitars", "Keys", "Bass", "Drums" }, Id = musicId, Value = 1 })
					SetSoundCueValue({ Names = { "Mandolins", "Flutes", "Misc", "End" }, Id = musicId, Value = 0 })
				end
			elseif trackName == "/Music/UrsaIdea6_MC" then
				if PlayerTeam.TeamLastMatchResult == "Win" then
					SetSoundCueValue({ Names = { "Guitars", "Flutes", "Drums", "Bass" }, Id = musicId, Value = 1 })
					SetSoundCueValue({ Names = { "Misc", "End" }, Id = musicId, Value = 0 })
				else
					SetSoundCueValue({ Names = { "Guitars", "Misc", "Drums", "Bass" }, Id = musicId, Value = 1 })
					SetSoundCueValue({ Names = { "Flutes", "End" }, Id = musicId, Value = 0 })
				end
				return
			else
				-- exception for Scavengers theme in game intro
				if trackName == "/Music/ScavengersTheme_MC" then
					if not introComplete and CurrentMapName ~= "Epilogue" then
						if cameFromIntroMatch then
							SetSoundCueValue({ Names = { "Bass", "Misc" }, Id = musicId, Value = 1 })
							SetSoundCueValue({ Names = { "Drums", "Guitars", "Mandolins", "Flutes", "End" }, Id = musicId, Value = 0 })
						else
							SetSoundCueValue({ Names = { "Bass" }, Id = musicId, Value = 1 })
							SetSoundCueValue({ Names = { "Drums" }, Id = musicId, Value = 1 })
							SetSoundCueValue({ Names = { "Guitars", "Mandolins", "Flutes", "Misc", "End" }, Id = musicId, Value = 0 })
						end
						return
					else
						SetSoundCueValue({ Names = { "Bass", "Misc" }, Id = musicId, Value = 1, Duration = duration })
						SetSoundCueValue({ Names = { "Guitars", "Mandolins", "Flutes" }, Id = musicId, Value = 0, Duration = longDuration })
						SetSoundCueValue({ Names = { "Drums" }, Id = musicId, Value = 2, Duration = duration })
					end
				elseif showStarMap then
					SetSoundCueValue({ Names = { "Bass", "Drums" }, Id = musicId, Value = 0 })
				else
					if airshipThemePlaying then
						SetSoundCueValue({ Names = { "Airship", "Guitars", "Bass" }, Id = musicId, Value = 1 })
						SetSoundCueValue({ Names = { "Drums", "Flutes", "Mandolins" }, Id = musicId, Value = 0 })
					else
						SetSoundCueValue({ Names = { "Guitars", "Bass" }, Id = musicId, Value = 1 })
						SetSoundCueValue({ Names = { "Drums" }, Id = musicId, Value = 1 })
						SetSoundCueValue({ Names = { "Mandolins", "Flutes", "Misc", "End" }, Id = musicId, Value = 0 })
						-- epilogue: stems for character-dialogue during character-specific themes
						if EpilogueChar ~= nil and CurrentMapName == "Epilogue" then
							if GetMusicName({ }) == EpilogueChar.MusicTheme and EpilogueChar.MusicStemName ~= nil then
								SetSoundCueValue({ Names = { EpilogueChar.MusicStemName }, Id = musicId, Value = EpilogueChar.MusicStemValue, Duration = duration })
							end
						end
					end
				end
			end
		else
			-- main layer
			SetSoundCueValue({ Id = mixingId, Names = {"Keys"}, Value = 1.0, Duration = 0.0 })

			-- extra percussion layer / player possession
			SetSoundCueValue({ Id = mixingId, Names = {"Drums"}, Value = 0.0, Duration = 0.0 })

			-- intense layer / enemy possession
			SetSoundCueValue({ Id = mixingId, Names = {"Guitars"}, Value = 0.0, Duration = 0.0 })

			-- tension layer / neargoal
			SetSoundCueValue({ Id = mixingId, Names = {"Vocals"}, Value = 0.0, Duration = 0.0 })

			-- lategame layer
			SetSoundCueValue({ Id = mixingId, Names = {"Keys2"}, Value = 0.0, Duration = 0.0 })
		end
	elseif trackName == "/Music/ScavengersTheme_MC" then
		if pvPreviousMap == "MatchSiteB" then
			SetSoundCueValue({ Names = { "Guitars", "Bass", "Drums" }, Id = musicId, Value = 1 })
			SetSoundCueValue({ Names = { "Flutes", "Toms", "Mandolins" }, Id = musicId, Value = 0 })
		else
			SetSoundCueValue({ Names = { "Bass", "Drums" }, Id = musicId, Value = 1 })
			SetSoundCueValue({ Names = { "Guitars", "Flutes", "Toms", "Mandolins" }, Id = musicId, Value = 0 })
		end
	elseif forfeitMatch and trackName == "/Music/UrsaIdea6_MC" then
		SetSoundCueValue({ Names = { "Guitars", "Flutes", "Bass" }, Id = musicId, Value = 1 })
		SetSoundCueValue({ Names = { "Misc", "Flutes", "End", "Drums", }, Id = musicId, Value = 0 })
	else
		-- main layer
		SetSoundCueValue({ Id = mixingId, Names = {"Keys"}, Value = 1.0, Duration = 0.0 })

		-- extra percussion layer / player possession
		SetSoundCueValue({ Id = mixingId, Names = {"Drums"}, Value = 0.0, Duration = 0.0 })

		-- intense layer / enemy possession
		SetSoundCueValue({ Id = mixingId, Names = {"Guitars"}, Value = 0.0, Duration = 0.0 })

		-- tension layer / neargoal
		SetSoundCueValue({ Id = mixingId, Names = {"Vocals"}, Value = 0.0, Duration = 0.0 })

		-- lategame layer
		SetSoundCueValue({ Id = mixingId, Names = {"Keys2"}, Value = 0.0, Duration = 0.0 })

		-- epilogue exceptions
		if CurrentMapName == "Epilogue" then
			if trackName == "/Music/ShopkeeperTheme_MC" then
				SetSoundCueValue({ Names = { "Guitars", "Keys", "Bass", "Drums" }, Id = musicId, Value = 1, Duration = 0.3, Delay = 0.1 })
				SetSoundCueValue({ Names = { "Mandolins", "Flutes", "Misc", "End" }, Id = musicId, Value = 0 })
			elseif trackName == "/Music/MatchMusic5_MC" then
				SetSoundCueValue({ Names = {"Keys", "Guitars"}, Id = mixingId, Value = 1.0, Duration = 0.0 })
			end
		end
	end

	if currentOvermapMusicSetting ~= nil and not blockMusicChanges and not airshipThemePlaying and not matchMusic and trackName ~= "/Music/ShopkeeperTheme_MC" and currentOvermapMusicSetting ~= "end" then
		SetOvermapMusic( currentOvermapMusicSetting )
	end

end

-- Music Utility Scripts
function IsMatchMusic()
	if MatchTrackList[MusicName] or BeyonderMusicId ~= nil then
		return true
	else
		return false
	end
end

function IsCharacterMusic()
	if CharacterMusicTrackList[MusicName] then
		return true
	else
		return false
	end
end

function IsSongMusic( musicName )

	if musicName == nil then
		musicName = GetMusicName({ })
	end

	if Contains( SongTrackList, musicName ) then
		return true
	else
		return false
	end
end

function IsAscensionMusic()
	if Contains( AscensionMusicTrackList, GetMusicName({ }) ) then
		return true
	else
		return false
	end
end

-- Dynamic Match Music
function UpdateMatchMusic( args )

	latestArgs = args

	local mixingId = GetMixingId({ })
	local musicId = MusicId

	-- change music based on ball possession
	if args == "playerpossession" then
		allowTensionMusic = true
		SetSoundCueValue({ Id = mixingId, Names = {"Drums"}, Value = 1.0, Duration = 0.1 })
		SetSoundCueValue({ Id = mixingId, Names = {"Guitars"}, Value = 0.0, Duration = 0.25 })
	elseif args == "enemypossession" then
		allowTensionMusic = true
		SetSoundCueValue({ Id = mixingId, Names = {"Guitars"}, Value = 1.0, Duration = 0.1 })
		SetSoundCueValue({ Id = mixingId, Names = {"Drums"}, Value = 0.0, Duration = 0.25 })
	elseif args == "nopossession" or args == nil then
		allowTensionMusic = false
		SetSoundCueValue({ Id = mixingId, Names = { "Drums", "Guitars" }, Value = 0.0, Duration = 0.25 })
	elseif args == "lategame" then
		SetSoundCueValue({ Id = mixingId, Names = {"Keys2"}, Value = 1.0, Duration = 0.1 })
	elseif args == "end" then
		-- SetSoundCueValue({ Names = { "Guitars" }, Id = musicId, Value = 1, Duration = 0.5 })
		SetSoundCueValue({ Names = { "End" }, Id = musicId, Value = 1 })
		if ascensionMatch then
			if PlayerTeam.TeamLastMatchResult == "Win" then
				SetSoundCueValue({ Id = mixingId, Names = {"Drums"}, Value = 1.0, Duration = 0.1 })
				SetSoundCueValue({ Id = mixingId, Names = {"Guitars"}, Value = 0.0, Duration = 0.25 })
			else
				SetSoundCueValue({ Id = mixingId, Names = {"Guitars"}, Value = 1.0, Duration = 0.1 })
				SetSoundCueValue({ Id = mixingId, Names = {"Drums"}, Value = 0.0, Duration = 0.25 })
			end
			SetSoundCueValue({ Id = mixingId, Names = {"Keys2"}, Value = 0.0, Duration = 10.0 })
		end
	end

	nearGoal = false
	SetSoundCueValue({ Id = mixingId, Names = {"Vocals"}, Value = 0.0, Duration = 0.5 })
end

-- **Match Music**
function StartMatchMusic( crossfade )
	if matchMusic then
		return
	end

	if uncommonMatch then
		return
	end

	-- should play in introMatch and practiceMatch
	local musicTrack = "/Music/MatchMusic2_MC"

	-- multiplayer music
	if IsMultiplayerMatch() then
		wait(2.4)
	end

	if introMatch and not introComplete then
		wait(3.32)
	end

	lateGameMusic = false

	-- standard match music
	if introComplete and NextTeam.MusicTheme ~= nil and not IsForfeitMatch() and not IsMultiplayerMatch() and not practiceMatch and pvPreviousMap ~= nil and not IsAscensionWeek() then
		musicTrack = NextTeam.MusicTheme
	-- ascension match music / ascension music scripting
	elseif IsAscensionWeek() and not IsMultiplayerMatch() and not practiceMatch then
		if PlayerTeam.AscensionMatchesPlayed >= 0 then
			-- archjustice VO disabled at first in ascension matches
			blockMatchVO = true
			FireTrigger({ Name = "PlayAscensionMatchMusic" })
			matchMusic = true
			return
		end
	-- practice match music
	elseif practiceMatch then
		musicTrack = League[10].MusicTheme
	-- multiplayer match music
	elseif IsMultiplayerMatch() or pvPreviousMap == nil then
		musicTrack = GetConfigOptionValue({ Name = "LocalMPMusicTrack" })
		if musicTrack == "LocalMP_MusicRandom" or musicTrack == nil then
			musicTrack = GetRandomKey( MatchTrackList )
		elseif musicTrack == "LocalMP_MusicTeam" then
			if PrevTeamMusic == nil then
				if CoinFlip() then
					musicTrack = TeamA.MusicTheme
				else
					musicTrack = TeamB.MusicTheme
				end
			else
				if PrevTeamMusic == TeamA.MusicTheme then
					musicTrack = TeamB.MusicTheme
				else
					musicTrack = TeamA.MusicTheme
				end
			end
			PrevTeamMusic = musicTrack
			PersistVariable({ Name = "PrevTeamMusic" })
		end
	-- forfeit match music
	elseif IsForfeitMatch() then
		blockMusicChanges = true
		musicTrack = "/Music/UrsaIdea6_MC"
	end
	matchMusic = true

	if crossfade then
		if ascensionMatch then
			thread( CrossfadeNewMusicTrack, musicTrack, 1.0, 0.5 )
		else
			thread( CrossfadeNewMusicTrack, musicTrack, 1.0, 2.0 )
		end
	elseif introMatch then
		MusicPlayer( musicTrack )
	else
		MusicPlayerDelayedStart( musicTrack, 2.0 )
	end

	if IsMultiplayerMatch() then
		UpdateMatchMusic( "nopossession" )
	end
end

function DraftMusic( args, musicId )

	if practiceMatch then
		return
	end

	if musicId == nil then
		if IsMultiplayerMatch() then
			musicId = LocalMPMusicId
		else
			musicId = MusicId
		end
	end

	if args == "start" then
		if IsAscensionWeek() and not practiceMatch then
			if PlayerTeam.AscensionMatchesPlayed >= 0 then
				local musicTrack = NextTeam.AscensionMusicTheme
				MusicPlayer( musicTrack )
				musicId = MusicId
			end
		elseif not IsMultiplayerMatch() then
			MusicPlayer( "/Music/OvermapMusic3_MC" )
			musicId = MusicId
		end
		SetSoundCueValue({ Names = { "Bass", "Drums" }, Id = musicId, Value = 1, Duration = 0.15 })
		SetSoundCueValue({ Names = { "Misc", "Guitars", "Flutes", "Mandolins" }, Id = musicId, Value = 0 })
	elseif args == "teamb" then
		SetSoundCueValue({ Names = { "Mandolins" }, Id = musicId, Value = 0.85, Duration = 1.0 })
		SetSoundCueValue({ Names = { "Drums" }, Id = musicId, Value = 2.0, Duration = 0.25 })
	elseif args == "firstpick" then
		SetSoundCueValue({ Names = { "Misc" }, Id = musicId, Value = 1, Duration = 0.35 })
	elseif args == "secondpick" then
		SetSoundCueValue({ Names = { "Guitars" }, Id = musicId, Value = 1, Duration = 0.35 })
	elseif args == "thirdpick" then
		if not IsAscensionWeek() then
			SetSoundCueValue({ Names = { "End" }, Id = musicId, Value = 1 })
		end
	elseif args == "teama" then
		SetSoundCueValue({ Names = { "Mandolins" }, Id = musicId, Value = 0, Duration = 3.0 })
		SetSoundCueValue({ Names = { "Drums" }, Id = musicId, Value = 1.0, Duration = 0.25 })
	-- specific to localmp showcase
	elseif args == "localmpshowcasestart" then
		MusicPlayerDelayedStart( "/Music/OvermapMusic3_MC", 1.2 )
		SetSoundCueValue({ Names = { "Bass", "Drums" }, Id = musicId, Value = 1, Duration = 0.15 })
		SetSoundCueValue({ Names = { "Misc", "Guitars", "Flutes", "Mandolins" }, Id = musicId, Value = 0 })
	elseif args == "localmprematch" then
		MusicPlayer( "/Music/OvermapMusic3_MC" )
		SetSoundCueValue({ Names = { "Bass", "Drums" }, Id = musicId, Value = 1, Duration = 0.15 })
		SetSoundCueValue({ Names = { "Misc", "Guitars", "Flutes", "Mandolins" }, Id = musicId, Value = 0 })
		SetSoundCueValue({ Names = { "End" }, Id = musicId, Value = 1 })
	elseif args == "p1ready" then
		SetSoundCueValue({ Names = { "Guitars" }, Id = musicId, Value = 0.85, Duration = 1.0 })
	elseif args == "p2ready" then
		SetSoundCueValue({ Names = { "Mandolins" }, Id = musicId, Value = 0.85, Duration = 1.0 })
	elseif args == "localmpshowcasereadyup" then
		SetSoundCueValue({ Names = { "Misc" }, Id = musicId, Value = 0.7, Duration = 2.0 })
		SetSoundCueValue({ Names = { "Drums" }, Id = musicId, Value = 2.0, Duration = 0.25 })
	end
end

function SetOvermapMusicInsideWagon()

	if blockMusicChanges then
		return
	end

	if BardMusicId ~= nil then
		return
	end

	if MusicName == BardTrackName then
		return
	end

	if kumbaya then
		return
	end

	if cameFromIntroMatch then
		return
	end

	if MusicName == "/Music/UrsaIdea6_MC" then
		return
	end

	local duration = 0.15
	local medDuration = 1.00
	local longDuration = 5.00

	SetSoundCueValue({ Names = { "Bass", }, Id = MusicId, Value = 1, Duration = duration })
	SetSoundCueValue({ Names = { "Guitars", "Mandolins", "Flutes", "Misc" }, Id = MusicId, Value = 0, Duration = longDuration })
	SetSoundCueValue({ Names = { "Drums" }, Id = MusicId, Value = 2, Duration = duration })

	if showStarMap then
		SetSoundCueValue({ Names = { "Bass", }, Id = MusicId, Value = 1, Duration = duration })
	end

end

-- **Overmap Music**
function SetOvermapMusic( args, characterData )
	if args == nil then
		return
	end

	if blockMusicChanges then
		return
	end

	if MusicName == "/Music/UrsaIdea6_MC" then
		return
	end

	if BardMusicId ~= nil then
		return
	end

	local duration = 0.15
	local medDuration = 1.00
	local longDuration = 5.00

	if currentOvermapMusicSetting ~= nil then
		previousOvermapMusicSetting = currentOvermapMusicSetting
	end

	currentOvermapMusicSetting = args

	local musicId = MusicId
	local mixingId = GetMixingId({ })

	if MusicName == "/Music/ShopkeeperTheme_MC" then
		if args == "dialogue" then
			SetSoundCueValue({ Names = { "Guitars", "Keys", "Misc", "Bass", }, Id = musicId, Value = 1, Duration = medDuration })
			SetSoundCueValue({ Names = { "Mandolins", "Flutes", "End", "Drums" }, Id = musicId, Value = 0, Duration = medDuration })
			return
		else
			SetSoundCueValue({ Names = { "Guitars", "Keys", "Bass", "Drums" }, Id = musicId, Value = 1, Duration = medDuration })
			SetSoundCueValue({ Names = { "Mandolins", "Flutes", "Misc", "End" }, Id = musicId, Value = 0, Duration = medDuration })
			return
		end
	end

	-- special Overmap Music Scripting for use with rival themes
	if IsMatchMusic() then
		-- main layer
		-- SetSoundCueValue({ Id = mixingId, Names = {"Keys"}, Value = 1.0, Duration = 0.0 })

		-- extra percussion layer / player possession
		-- SetSoundCueValue({ Id = mixingId, Names = {"Drums"}, Value = 0.0, Duration = 0.0 })

		-- intense layer / enemy possession
		-- SetSoundCueValue({ Id = mixingId, Names = {"Guitars"}, Value = 0.0, Duration = 0.0 })

		-- tension layer / neargoal
		-- SetSoundCueValue({ Id = mixingId, Names = {"Vocals"}, Value = 0.0, Duration = 0.0 })

		-- lategame layer
		-- SetSoundCueValue({ Id = mixingId, Names = {"Keys2"}, Value = 0.0, Duration = 0.0 })
		if args == "choice" then
			if BeyonderMusicId ~= nil then
				SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys", "Keys2", }, Value = 0.85, Duration = duration })
			else
				SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys", "Keys2"}, Value = 1.0, Duration = duration })
			end
			SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Drums", "Guitars", "Vocals"}, Value = 0.0, Duration = duration })
		elseif args == "confirm" then
			SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys", "Vocals"}, Value = 1.0, Duration = duration })
			SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys2", "Drums", "Guitars"}, Value = 0.0, Duration = duration })
		elseif args == "narration" then
			if previousOvermapMusicSetting == "choice" or previousOvermapMusicSetting == "confirm" then
				if BeyonderMusicId ~= nil then
					SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys", "Keys2", }, Value = 0.85, Duration = duration })
				else
					SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys", "Keys2", }, Value = 1.0, Duration = duration })
				end
				SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Drums", "Guitars", "Vocals"}, Value = 0.0, Duration = longDuration })
			elseif previousOvermapMusicSetting == "dialogue" then
				if BeyonderMusicId ~= nil then
					SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys", "Keys2", }, Value = 0.85, Duration = medDuration })
				else
					SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys", "Keys2", }, Value = 1.0, Duration = medDuration })
				end
				SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Drums", "Guitars", "Vocals"}, Value = 0.0, Duration = longDuration })
			else
				if BeyonderMusicId ~= nil then
					SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys", "Keys2", }, Value = 0.85, Duration = longDuration })
				else
					SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys", "Keys2", }, Value = 1.0, Duration = longDuration })
				end
				SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Drums", "Guitars", "Vocals"}, Value = 0.0, Duration = longDuration })
			end
		elseif args == "dialogue" then
			if BeyonderMusicId ~= nil then
				SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys"}, Value = 0.85, Duration = duration })
			else
				SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys"}, Value = 1.0, Duration = duration })
			end
			SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys2", "Drums", "Guitars", "Vocals"}, Value = 0.0, Duration = medDuration })
			-- stems for character-dialogue during character-specific themes
			if characterData ~= nil then
				if GetMusicName({ }) == characterData.MusicTheme and characterData.MusicStemName ~= nil then
					SetSoundCueValue({ Id = GetMixingId({ }), Names = { characterData.MusicStemName }, Value = characterData.MusicStemValue, Duration = medDuration })
				end
			end
		elseif args == "mapidle" or args == "mapzoomed" then
			SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys", "Vocals", "Guitars"}, Value = 1.0, Duration = longDuration })
			SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys2", "Drums"}, Value = 0.0, Duration = duration })
		elseif args == "matchstarting" then
			SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys"}, Value = 1.0, Duration = duration })
			SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys2", "Drums", "Vocals", "Guitars"}, Value = 0.0, Duration = longDuration })
		elseif args == "end" then
			if BeyonderMusicId ~= nil then
				SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys", "End", }, Value = 0.85 })
			else
				SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys", "End"}, Value = 1 })
			end
			SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Keys2", "Drums", "Guitars", "Vocals"}, Value = 0.0, Duration = duration })
		end
	-- **STANDARD OVERMAP MUSIC:** standard / older music scripting
	elseif airshipThemePlaying then
		--
	else
		if args == "choice" then
			if introComplete and MusicName ~= "/Music/ScavengersTheme_MC" then
				SetSoundCueValue({ Names = { "Mandolins", "Flutes" }, Id = musicId, Value = 1, Duration = duration })
				SetSoundCueValue({ Names = { "Guitars", "Bass", "Misc" }, Id = musicId, Value = 0, Duration = longDuration })
				SetSoundCueValue({ Names = { "Drums" }, Id = musicId, Value = 0, Duration = longDuration })
			else
				SetSoundCueValue({ Names = { "Bass", "Misc" }, Id = musicId, Value = 1, Duration = duration })
				SetSoundCueValue({ Names = { "Guitars", "Drums", "Flutes", "Toms", "Mandolins" }, Id = musicId, Value = 0, Duration = longDuration })
			end
		elseif args == "confirm" then
			if introComplete and MusicName ~= "/Music/ScavengersTheme_MC" then
				SetSoundCueValue({ Names = { "Mandolins", "Flutes" }, Id = musicId, Value = 1, Duration = duration })
				SetSoundCueValue({ Names = { "Drums" }, Id = musicId, Value = 2, Duration = duration })
				SetSoundCueValue({ Names = { "Guitars", "Bass", "Misc" }, Id = musicId, Value = 0, Duration = longDuration })
			else
				SetSoundCueValue({ Names = { "Drums", "Bass", "Misc" }, Id = musicId, Value = 1, Duration = duration })
				if not kumbaya then
					SetSoundCueValue({ Names = { "Guitars", "Flutes", "Toms", "Mandolins" }, Id = musicId, Value = 0, Duration = longDuration })
				end
			end
		elseif args == "narration" then
			if previousOvermapMusicSetting == "choice" or previousOvermapMusicSetting == "confirm" then
				SetSoundCueValue({ Names = { "Guitars", "Bass", "Misc", "Mandolins" }, Id = musicId, Value = 1, Duration = duration })
				SetSoundCueValue({ Names = { "Flutes", "Drums" }, Id = musicId, Value = 0, Duration = longDuration })
			elseif previousOvermapMusicSetting == "dialogue" then
				SetSoundCueValue({ Names = { "Guitars", "Bass", "Misc", "Mandolins" }, Id = musicId, Value = 1, Duration = medDuration })
				SetSoundCueValue({ Names = { "Flutes", "Drums" }, Id = musicId, Value = 0, Duration = longDuration })
			elseif numBigSpeechLines ~= nil then
				SetSoundCueValue({ Names = { "Guitars", "Bass", "Mandolins" }, Id = musicId, Value = 1, Duration = longDuration })
				SetSoundCueValue({ Names = { "Drums" }, Id = musicId, Value = 2, Duration = duration })
				SetSoundCueValue({ Names = { "Flutes", "Misc" }, Id = musicId, Value = 0, Duration = duration })
			else
				SetSoundCueValue({ Names = { "Guitars", "Bass", "Misc", "Mandolins" }, Id = musicId, Value = 1, Duration = longDuration })
				SetSoundCueValue({ Names = { "Flutes", "Drums" }, Id = musicId, Value = 0, Duration = longDuration })
			end
			CheckCharacterStems( musicId, characterData, medDuration )
			CheckCharacterStems( musicId, CharacterMusicQueued, medDuration )
		elseif args == "dialogue" then
			if previousOvermapMusicSetting == "choice" or previousOvermapMusicSetting == "confirm" then
				SetSoundCueValue({ Names = { "Guitars", "Bass", }, Id = musicId, Value = 1, Duration = duration })
				SetSoundCueValue({ Names = { "Flutes", "Mandolins", "Misc", "Drums" }, Id = musicId, Value = 0, Duration = longDuration })
			elseif previousOvermapMusicSetting == "narration" then
				SetSoundCueValue({ Names = { "Guitars", "Bass" }, Id = musicId, Value = 1, Duration = medDuration })
				SetSoundCueValue({ Names = { "Mandolins", "Misc" }, Id = musicId, Value = 0, Duration = medDuration })
				SetSoundCueValue({ Names = { "Flutes", "Drums" }, Id = musicId, Value = 0, Duration = longDuration })
			else
				SetSoundCueValue({ Names = { "Guitars", "Bass" }, Id = musicId, Value = 1, Duration = duration })
				SetSoundCueValue({ Names = { "Flutes", "Mandolins", "Misc", "Drums" }, Id = musicId, Value = 0, Duration = longDuration })
			end
			CheckCharacterStems( musicId, characterData, medDuration )
			CheckCharacterStems( musicId, CharacterMusicQueued, medDuration )
		elseif args == "mapidle" then
			if not kumbaya then
				SetSoundCueValue({ Names = { "Guitars", "Bass", "Drums" }, Id = musicId, Value = 1, Duration = duration })
				SetSoundCueValue({ Names = { "Mandolins", "Flutes", "Misc" }, Id = musicId, Value = 0, Duration = longDuration })
			else
				SetSoundCueValue({ Names = { "Misc" }, Id = musicId, Value = 1, Duration = longDuration })
			end
		elseif args == "mapmoving" then
			SetSoundCueValue({ Names = { "Guitars", "Bass", "Misc" }, Id = musicId, Value = 1, Duration = duration })
			SetSoundCueValue({ Names = { "Mandolins", "Flutes" }, Id = musicId, Value = 1, Duration = duration })
			SetSoundCueValue({ Names = { "Drums" }, Id = musicId, Value = 1, Duration = duration })
		elseif args == "mapzoomed" and not kumbaya then
			SetSoundCueValue({ Names = { "Bass", "Misc" }, Id = musicId, Value = 1, Duration = duration })
			SetSoundCueValue({ Names = { "Guitars", "Mandolins", "Flutes" }, Id = musicId, Value = 0, Duration = longDuration })
			SetSoundCueValue({ Names = { "Drums" }, Id = musicId, Value = 2, Duration = duration })
		elseif ( args == "starmap" or showStarMap ) and not IsAscensionWeek() then
			SetSoundCueValue({ Names = { "Misc", }, Id = musicId, Value = 1, Duration = duration })
			SetSoundCueValue({ Names = { "Drums", "Guitars", "Bass", "Flutes", "Toms", "Mandolins" }, Id = musicId, Value = 0, Duration = longDuration })
		elseif args == "ascensionstarmap" then
			SetSoundCueValue({ Names = { "Guitars", }, Id = musicId, Value = 1, Duration = duration })
			SetSoundCueValue({ Names = { "Drums", "Misc", "Bass", "Flutes", "Toms", "Mandolins" }, Id = musicId, Value = 0, Duration = longDuration })
		elseif args == "end" then
			SetSoundCueValue({ Names = { "Guitars" }, Id = musicId, Value = 1, Duration = duration })
			SetSoundCueValue({ Names = { "End" }, Id = musicId, Value = 1 })
		elseif args == "prologue" then
			if characterData ~= nil then
				if characterData == CharFriend then
					if not openedCaravan then
						SetSoundCueValue({ Names = { "Mandolins" }, Id = musicId, Value = 1, Duration = duration })
						SetSoundCueValue({ Names = { "Guitars", "Bass", "Drums" }, Id = musicId, Value = 1.0, Duration = duration })
						if not kumbaya then
							SetSoundCueValue({ Names = { "Toms", "Flutes" }, Id = musicId, Value = 0, Duration = longDuration })
						end
					else
						SetSoundCueValue({ Names = { "Mandolins", "Bass" }, Id = musicId, Value = 1, Duration = duration })
						SetSoundCueValue({ Names = { "Drums" }, Id = musicId, Value = 2, Duration = duration })
						if not kumbaya then
							SetSoundCueValue({ Names = { "Guitars", "Toms", "Flutes" }, Id = musicId, Value = 0, Duration = longDuration })
						end
					end
				elseif characterData == CharBadass then
					if not openedCaravan then
						SetSoundCueValue({ Names = { "Toms" }, Id = musicId, Value = 1, Duration = duration })
						SetSoundCueValue({ Names = { "Guitars", "Bass", "Drums" }, Id = musicId, Value = 1.0, Duration = duration })
						if not kumbaya then
							SetSoundCueValue({ Names = { "Mandolins", "Flutes" }, Id = musicId, Value = 0, Duration = longDuration })
						end
					else
						SetSoundCueValue({ Names = { "Toms", "Bass" }, Id = musicId, Value = 1, Duration = duration })
						SetSoundCueValue({ Names = { "Drums" }, Id = musicId, Value = 2, Duration = duration })
						if not kumbaya then
							SetSoundCueValue({ Names = { "Guitars", "Mandolins", "Flutes" }, Id = musicId, Value = 0, Duration = longDuration })
						end
					end
				elseif characterData == CharJoker then
					if not openedCaravan then
						SetSoundCueValue({ Names = { "Flutes" }, Id = musicId, Value = 0.8, Duration = duration })
						SetSoundCueValue({ Names = { "Guitars", "Bass" }, Id = musicId, Value = 1.0, Duration = duration })
						SetSoundCueValue({ Names = { "Drums" }, Id = musicId, Value = 2, Duration = duration })
						if not kumbaya then
							SetSoundCueValue({ Names = { "Mandolins", "Toms" }, Id = musicId, Value = 0, Duration = longDuration })
						end
					else
						SetSoundCueValue({ Names = { "Flutes", "Bass", "Drums" }, Id = musicId, Value = 1.0, Duration = duration })
						if not kumbaya then
							SetSoundCueValue({ Names = { "Guitars", "Mandolins", "Toms" }, Id = musicId, Value = 0, Duration = longDuration })
						else
							SetSoundCueValue({ Names = { "Flutes" }, Id = musicId, Value = 0.83, Duration = duration })
						end
					end
				end
			else
				if not postIntroMatch and not kumbaya then
					if not openedCaravan then
						-- epilogue hack for hedwyn, jodi, rukey
						if GetMapName({ }) == "Epilogue" and ( EpilogueChar == CharFriend or EpilogueChar == CharBadass or EpilogueChar == CharJoker ) then
							if EpilogueChar == CharFriend then
								SetSoundCueValue({ Names = { "Mandolins" }, Id = musicId, Value = 1, Duration = duration })
								SetSoundCueValue({ Names = { "Guitars", "Bass", "Drums" }, Id = musicId, Value = 1.0, Duration = duration })
							elseif EpilogueChar == CharBadass then
								SetSoundCueValue({ Names = { "Toms" }, Id = musicId, Value = 1, Duration = duration })
								SetSoundCueValue({ Names = { "Guitars", "Bass", "Drums" }, Id = musicId, Value = 1.0, Duration = duration })
							elseif EpilogueChar == CharJoker then
								SetSoundCueValue({ Names = { "Flutes" }, Id = musicId, Value = 0.8, Duration = duration })
								SetSoundCueValue({ Names = { "Guitars", "Bass" }, Id = musicId, Value = 1.0, Duration = duration })
								SetSoundCueValue({ Names = { "Drums" }, Id = musicId, Value = 2, Duration = duration })
							end
						else
							if not showStarMap then
								SetSoundCueValue({ Names = { "Guitars", "Bass", "Drums" }, Id = musicId, Value = 1, Duration = duration })
								SetSoundCueValue({ Names = { "Flutes", "Toms", "Mandolins", "Misc" }, Id = musicId, Value = 0, Duration = longDuration })
							else
								if not IsAscensionWeek() then
									SetSoundCueValue({ Names = { "Misc", }, Id = musicId, Value = 1, Duration = duration })
									SetSoundCueValue({ Names = { "Drums", "Guitars", "Bass", "Flutes", "Toms", "Mandolins" }, Id = musicId, Value = 0, Duration = longDuration })
								else
									SetSoundCueValue({ Names = { "Guitars", }, Id = musicId, Value = 1, Duration = duration })
									SetSoundCueValue({ Names = { "Drums", "Misc", "Bass", "Flutes", "Toms", "Mandolins" }, Id = musicId, Value = 0, Duration = longDuration })
								end
							end
						end
					else
						if not prologueShowingBook then
							SetSoundCueValue({ Names = { "Bass", "Drums" }, Id = musicId, Value = 1, Duration = duration })
							SetSoundCueValue({ Names = { "Guitars", "Flutes", "Toms", "Mandolins", "Misc" }, Id = musicId, Value = 0, Duration = longDuration })
						elseif prologueShowingBook then
							SetSoundCueValue({ Names = { "Misc" }, Id = musicId, Value = 1, Duration = longDuration })
							SetSoundCueValue({ Names = { "Bass", "Drums", "Guitars", "Flutes", "Toms", "Mandolins" }, Id = musicId, Value = 0, Duration = longDuration })
						end
					end
				else
					-- for star picker moment
					if showStarMap then
						SetSoundCueValue({ Names = { "Misc", }, Id = musicId, Value = 1, Duration = duration })
						SetSoundCueValue({ Names = { "Drums", "Guitars", "Bass", "Flutes", "Toms", "Mandolins" }, Id = musicId, Value = 0, Duration = longDuration })
					else
						SetSoundCueValue({ Names = { "Guitars", "Bass", }, Id = musicId, Value = 1, Duration = duration })
						SetSoundCueValue({ Names = { "Drums", "Flutes", "Toms", "Mandolins", "Misc" }, Id = musicId, Value = 0, Duration = duration })
					end
				end
			end
			-- airship music exception: kill the drums
			if airshipThemePlaying then
				SetSoundCueValue({ Names = { "Drums" }, Id = musicId, Value = 0, Duration = 0 })
			end
		end
	end
end

function CheckCharacterStems( musicId, characterData, duration )

	-- stems for character-dialogue during character-specific themes
	if characterData ~= nil then
		if MusicName == characterData.MusicTheme and characterData.MusicStemName ~= nil then
			SetSoundCueValue({ Names = { characterData.MusicStemName }, Id = musicId, Value = characterData.MusicStemValue, Duration = duration })
		end
	end

end

function OvermapMusicEndCheck()
	wait(0.1)
	-- end the current overmap music before swath transition
	-- going into swath 7
	if currentNodeId == 40184
	-- going into swath 9
	or currentNodeId == 10046
	then
		SetOvermapMusic( "end" )
	end
end

OnMenuOpened{ "RosterScreen InventoryScreen ItemPurchaseScreen GuideBookScreen StandingsScreen",
	function( triggerArgs )
		if introComplete and CurrentMapName == "Campaign" then
			SetOvermapMusicInsideWagon()
		end
	end
}

OnMenuClosed{ "RosterScreen InventoryScreen ItemPurchaseScreen GuideBookScreen StandingsScreen",
	function( triggerArgs )
		if introComplete then
			if openedCaravan then
				SetOvermapMusicInsideWagon()
			elseif not openedCaravan and IsScreenOpen({ Name = "LocationMenuScreen" }) and not IsScreenOpen({ Name = "DialogueScreen" }) then
				SetOvermapMusic( "mapzoomed" )
			elseif showStarMap then
				SetOvermapMusic( "prologue" )
			else
				SetOvermapMusic( "mapidle" )
			end
		end
	end
}

function DefenseMusic( args )

	local musicId = GetMusicId({ })

	if args == "prematch" or args == nil then
		MusicPlayer( "/Music/TestDefenseMusic1_MC" )
	elseif args == "start" then
		SetSoundCueValue({ Names = { "Snare" }, Id = musicId, Duration = 0.25, Value = 1 })
	elseif args == "madness" then
		SetSoundCueValue({ Names = { "ExtraDrums" }, Id = musicId, Duration = 0.25, Value = 1 })
	elseif args == "reset" then
		SetSoundCueValue({ Names = { "Snare", "ExtraDrums" }, Id = musicId, Duration = 1.0, Value = 0 })
	elseif args == "end" then
		SetSoundCueValue({ Names = { "Snare", "ExtraDrums" }, Id = musicId, Duration = 1.0, Value = 0 })
		SetSoundCueValue({ Names = { "End" }, Id = musicId, Value = 1 })
	end
end

OnTriggerFired
{ "StartDefenseMusic",
	function(triggerArgs)
		DefenseMusic( "prematch" )
		SetSoundCueValue({ Names = { "Music" }, Id = GetMusicId({ }), Value = 1 })
		SetSoundCueValue({ Names = { "Snare", "ExtraDrums", "End" }, Id = GetMusicId({ }), Value = 0 })
		blockMusicChanges = true
	end
}

OnTriggerFired
{ "BlockMusicChanges",
	function(triggerArgs)
		-- purposely not persisted
		blockMusicChanges = true
	end
}

OnTriggerFired
{ "PrologueMusic",
	function(triggerArgs)
		if ActiveNarrationName == "Prologue_WagonExterior" or ActiveNarrationName == "Prologue_QuestBegins" then
			-- music ending
			-- FadeMusicOut({ Duration = 3.0 })
		elseif ActiveNarrationName == "Prologue_WagonInterior_Books" or ActiveNarrationName == "Intro_WagonInterior_Books" then
			prologueShowingBook = true
			StopSound({ Name = "/SFX/World Sounds/CaravanInteriorLoop1", Duration = 5.0 })
		elseif ActiveNarrationName == "Prologue_WagonInterior_SetupIntroMatch" or ActiveNarrationName == "Intro_WagonInterior_SetupIntroMatch" then
			PlaySound({ Name = "/Ambience/MatchSiteAAmbience", Delay = 0 })
		elseif ActiveNarrationName == "Week1_ArrivedAtMatchSite" or ActiveNarrationName == "Intro_Week1_ArrivedAtMatchSite" then
			-- SetOvermapMusic( "end" )
		elseif ActiveNarrationName == "Week1_ReachedGoal" or ActiveNarrationName == "Intro_Week1_ReachedGoal" or ActiveNarrationName == "Week2_ReachedGoal" then
			blockMusicChanges = true
			StopSound({ Name = "/SFX/Object Ambiences/MatchSiteAmbience", Duration = 10 })
			MusicPlayer( "/Music/OvermapMusic3_MC" )
		elseif ActiveNarrationName == "Week2_Start" or ActiveNarrationName == "Intro_Week2_Onward" or ActiveNarrationName == "Intro_Week2_Onward_Kiosk" then
			kumbaya = true
			MusicPlayer( "/Music/ScavengersTheme_MC" )
		elseif ActiveNarrationName == "Intro_Week1_Match_Beginning" then
			if numTimesTriggeredInPrematch == nil then
				numTimesTriggeredInPrematch = 0
				SetSoundCueValue({ Names = { "Bass", "Drums", "Mandolins" }, Id = GetMusicId({ }), Value = 1, Duration = 0.15 })
				SetSoundCueValue({ Names = { "Misc", "Guitars", "Flutes" }, Id = GetMusicId({ }), Value = 0, Duration = 5.00 })
			elseif numTimesTriggeredInPrematch == 0 then
				numTimesTriggeredInPrematch = 1
				SetSoundCueValue({ Names = { "End" }, Id = GetMusicId({ }), Value = 1 })
			end
		elseif ActiveNarrationName == "Week2_Match_Beginning" then
			SetSoundCueValue({ Names = { "End" }, Id = GetMusicId({ }), Value = 1 })
		elseif ActiveNarrationName == "Intro_Week2_Onward_Conclusion" or ActiveNarrationName == "Intro_Week2_Onward_Kiosk_Conclusion" then
			SetOvermapMusic( "end" )
		else
			if not NarrationRecord["Prologue"] or not NarrationRecord["Intro"] then
				thread( MusicPlayerDelayedStart, "/Music/ScavengersTheme_MC", 3.75 )
			end
		end
	end
}

OnTriggerFired
{ "EndCurrentMusic",
	function(triggerArgs)
		EndMusic( MusicId, MusicName )
	end
}

function EndMusic( musicId, musicName )

	if musicId == nil then
		musicId = MusicId
	end
	if musicName == nil then
		musicName = MusicName
	end

	if musicId == nil then
		return
	end

	CharacterMusicQueued = nil

	local delay = 0
	if IsScreenOpen({ Name = "DialogueScreen" }) then
		delay = 0.35
	end
	if ascensionMatch then
		if IsAscensionMusic() and not IsMultiplayerMatch() then
			SetSoundCueValue({ Names = { "Guitars", "OutroEnd" }, Id = musicId, Value = 1, Delay = delay })
		else
			SetSoundCueValue({ Names = { "Guitars", "End" }, Id = musicId, Value = 1, Delay = delay })
		end
	else
		SetSoundCueValue({ Names = { "Guitars", "End" }, Id = musicId, Value = 1, Delay = delay })
	end

	if IsSongMusic( musicName ) then
		StopSound({ Id = musicId, Value = 0.0, Duration = 3.0 })
	else
		EndingMusicId = musicId
	end

	if musicId == MusicId then
		MusicId = nil
		MusicName = nil
	end

end

OnTriggerFired
{ "EndCurrentMusic_LocalMP",
	function(triggerArgs)
		local delay = 0
		if IsScreenOpen({ Name = "DialogueScreen" }) then
			delay = 0.35
		end
		SetSoundCueValue({ Names = { "End" }, Id = GetMusicId({ }), Value = 1, Delay = delay })
	end
}

OnTriggerFired
{ "UpdateEpilogueMusic",
	function(triggerArgs)
		if GetMusicName({ }) == "/Music/MatchMusic5_MC" then
			SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Guitars"}, Value = 0.0, Duration = 25.0 })
		end
	end
}

OnTriggerFired
{ "PlaySwathMusic",
	function(triggerArgs)
		thread(SwathMusic, 0.25)
	end
}

OnTriggerFired
{ "PlayPreMatchMusic",
	function(triggerArgs)
		blockMusicChanges = true
		StopSound({ Name = "/SFX/Object Ambiences/MatchSiteAmbience", Duration = 10 })
		if IsAscensionWeek() then
			if PlayerTeam.AscensionMatchesPlayed == 6 then
				MusicPlayer( "/Music/MatchMusic5_MC" )
			elseif PlayerTeam.AscensionMatchesPlayed == 2 then
				MusicPlayer( "/Music/OvermapMusic3_MC" )
			else
				MusicPlayer( "/Music/UrsaIdea4_MC" )
			end
		else
			MusicPlayer( "/Music/OvermapMusic3_MC" )
		end
	end
}

OnTriggerFired
{ "StartConstellationMusic",
	function(triggerArgs)
		if IsMatchMusic() then
			SetSoundCueValue({ Names = { "Keys2", }, Id = GetMixingId({ }), Value = 1, Duration = 0.5 })
			SetSoundCueValue({ Names = { "Guitars", "Drums" }, Id = GetMixingId({ }), Value = 0, Duration = 0.5 })
		else
			SetSoundCueValue({ Names = { "Misc", }, Id = GetMusicId({ }), Value = 1, Duration = 0.5 })
			SetSoundCueValue({ Names = { "Drums", }, Id = GetMusicId({ }), Value = 0, Duration = 0.3 })
		end
	end
}

OnTriggerFired
{ "EndConstellationMusic",
	function(triggerArgs)
		if IsMatchMusic() then
			SetSoundCueValue({ Names = { "Keys2", }, Id = GetMixingId({ }), Value = 0, Duration = 1.0 })
		else
			SetSoundCueValue({ Names = { "Misc", }, Id = GetMusicId({ }), Value = 0, Duration = 1.0 })
			SetSoundCueValue({ Names = { "Drums", }, Id = GetMusicId({ }), Value = 1, Duration = 0.3 })
		end
	end
}

-- ascension match music scripting
OnTriggerFired
{ "PlayAscensionMatchMusic",
	function(triggerArgs)
		leftBardId = 10000
		rightBardId = 10002

		SetSoundCueValue({ Id = GetMusicId({ }), Names = { "IntroEnd" }, Value = 1.0 })

		SetThingProperty({ DestinationId = leftBardId, Name = "LerpCueParamDistance", Value = 6000 })
		SetThingProperty({ DestinationId = leftBardId, Name = "LerpCueParamName", Value = "BardVocals" })
		SetThingProperty({ DestinationId = leftBardId, Name = "LerpCueParamId", Value = GetMixingId({ }) })

		SetThingProperty({ DestinationId = rightBardId, Name = "LerpCueParamDistance", Value = 6000 })
		SetThingProperty({ DestinationId = rightBardId, Name = "LerpCueParamName", Value = "RivalBardVocals" })
		SetThingProperty({ DestinationId = rightBardId, Name = "LerpCueParamId", Value = GetMixingId({ }) })

	end
}

-- ascension match music scripting
OnMusicMarker{ "VoxW",
	function( triggerArgs )
		if not IsAscensionWeek() then
			return
		end
		leftBardId = 10000
		rightBardId = 10002
		local markerName = triggerArgs.name
		if markerName == "VoxW" then
			-- toggle vocals and Archjustice VO when song loops
			if not altAscensionMusic then
				altAscensionMusic = true
				blockMatchVO = false
				SetThingProperty({ DestinationId = leftBardId, Name = "LerpCueParamDistance", Value = 0 })
				SetThingProperty({ DestinationId = leftBardId, Name = "LerpCueParamId", Value = 0 })
				SetThingProperty({ DestinationId = rightBardId, Name = "LerpCueParamDistance", Value = 0 })
				SetThingProperty({ DestinationId = rightBardId, Name = "LerpCueParamId", Value = 0 })
				SetSoundCueValue({ Names = { "BardVocals", "RivalBardVocals" }, Id = GetMixingId({ }), Value = 0, Delay = 0.1 })
			else
				altAscensionMusic = false
				blockMatchVO = true
				SetThingProperty({ DestinationId = leftBardId, Name = "LerpCueParamDistance", Value = 6000 })
				SetThingProperty({ DestinationId = leftBardId, Name = "LerpCueParamId", Value = GetMixingId({ }) })
				SetThingProperty({ DestinationId = rightBardId, Name = "LerpCueParamDistance", Value = 6000 })
				SetThingProperty({ DestinationId = rightBardId, Name = "LerpCueParamId", Value = GetMixingId({ }) })
				SetSoundCueValue({ Names = { "BardVocals", "RivalBardVocals" }, Id = GetMixingId({ }), Value = 1, Delay = 0.1 })
			end
		end
	end
}

-- ascension match music scripting
function StopAscensionMatchMusicVocals()
	leftBardId = 10000
	rightBardId = 10002
	SetThingProperty({ DestinationId = leftBardId, Name = "LerpCueParamDistance", Value = 0 })
	SetThingProperty({ DestinationId = leftBardId, Name = "LerpCueParamId", Value = 0 })
	SetThingProperty({ DestinationId = rightBardId, Name = "LerpCueParamDistance", Value = 0 })
	SetThingProperty({ DestinationId = rightBardId, Name = "LerpCueParamId", Value = 0 })
	SetSoundCueValue({ Names = { "BardVocals", "RivalBardVocals" }, Id = GetMixingId({ }), Value = 0, Delay = 0.1 })
end

OnTriggerFired
{ "StopPreMatchMusic",
	function(triggerArgs)
		if numTimesTriggeredInPrematch == nil then
			numTimesTriggeredInPrematch = 0
			SetSoundCueValue({ Names = { "Bass", "Drums", "Mandolins" }, Id = GetMusicId({ }), Value = 1, Duration = 0.15 })
			SetSoundCueValue({ Names = { "Misc", "Guitars", "Flutes" }, Id = GetMusicId({ }), Value = 0, Duration = 5.00 })
		elseif numTimesTriggeredInPrematch == 0 then
			numTimesTriggeredInPrematch = 1
			SetSoundCueValue({ Names = { "End" }, Id = GetMusicId({ }), Value = 1 })
		end
	end
}

OnTriggerFired
{ "PlayIntermissionMusic",
	function(triggerArgs)
		MusicPlayer( "/Music/UrsaIdea6_MC" )
	end
}

--[[ **AMBIENCE** ]]

function PlayMatchAmbience()

	SetAudioEffectState({ Name = "Reverb", Value = 1.0 })

	if introMatch then
		-- Special cased elsewhere
		return
	end

	local ambience = nil
	local persistentAmbience = nil
	local introAmbience1 = nil
	local introAmbience2 = nil
	local matchStartFadeInAmbience = nil

	if GetMapName({ }) == "MatchSiteA" then
		ambience = "/Ambience/MatchSiteAAmbience"
	elseif GetMapName({ }) == "MatchSiteB" then
		ambience = "/Ambience/WastelandAmbienceQuieter"
	elseif GetMapName({ }) == "MatchSiteC" then
		introAmbience1 = "/Ambience/ValleyAmbience"
		persistentAmbience = "/Ambience/StillWaterAmbience"
	elseif GetMapName({ }) == "MatchSiteD" then
		ambience = "/Ambience/WastelandAmbienceQuieter"
	elseif GetMapName({ }) == "MatchSiteE" then
		ambience = "/SFX/Object Ambiences/EvilLairAmbienceMatchSiteE"
	elseif GetMapName({ }) == "MatchSiteF" then
		introAmbience1 = "/Ambience/OceanWavesWaterAmbience"
		persistentAmbience = "/Ambience/GentleWavesBeachAmbience2D"
	elseif GetMapName({ }) == "MatchSiteG" then
		introAmbience1 = "/Ambience/WhippingWindLoop"
		introAmbience2 = "/Ambience/LavaEruptRumbleLoop_2D"
	elseif GetMapName({ }) == "MatchSiteH" then
		ambience = "/SFX/Object Ambiences/EnchantedGladeAmbienceMatchSiteH"
	elseif GetMapName({ }) == "MatchSiteI" then
		ambience = "/Ambience/WindyRooftopAmbience"
	elseif GetMapName({ }) == "MatchSiteJ" then
		introAmbience1 = "/Ambience/MatchSiteJWindyPandownAmbience"
		persistentAmbience = "/SFX/Match SFX/ImpCrowdLoop"
	end

	if ambience ~= nil then
		SwitchAmbience( ambience )
	end
	if introAmbience1 ~= nil then
		SwitchIntroAmbience1( introAmbience1 )
	end
	if introAmbience2 ~= nil then
		SwitchIntroAmbience2( introAmbience2 )
	end
	if persistentAmbience ~= nil then
		SwitchSecondaryAmbience( persistentAmbience )
	end

end

function SwitchAmbience( soundName )
	if AmbienceId ~= nil then
		StopSound({ Id = AmbienceId, Duration = 0.5 })
	end
	AmbienceId = PlaySound({ Name = soundName })
end

function SwitchSecondaryAmbience( soundName )
	if soundName ~= nil then
		if AmbienceId2 ~= nil then
			StopSound({ Id = AmbienceId2, Duration = 0.5 })
		end
		AmbienceId2 = PlaySound({ Name = soundName })
		SetVolume({ Id = AmbienceId2, Value = 0.0 })
		if GetConfigOptionValue({ Name = "LocalMPIntroPresentation" }) ~= "LocalMP_Intro_Long" or ForceShortIntro then
			SetVolume({ Id = AmbienceId2, Value = 1.0, Duration = 0.3 })
		else
			SetVolume({ Id = AmbienceId2, Value = 1.0, Duration = 20 })
		end
	end
end

function SwitchIntroAmbience1( soundName )
	-- skip all this for short intro
	if GetConfigOptionValue({ Name = "LocalMPIntroPresentation" }) ~= "LocalMP_Intro_Long" or ForceShortIntro then
		return
	end
	if AmbienceId3 ~= nil then
		StopSound({ Id = AmbienceId3, Duration = 0.5 })
	end
	AmbienceId3 = PlaySound({ Name = soundName })
	SetVolume({ Id = AmbienceId3, Value = 0.0, Duration = 20 })
end

function SwitchIntroAmbience2( soundName )
	if AmbienceId4 ~= nil then
		StopSound({ Id = AmbienceId4, Duration = 0.5 })
	end
	AmbienceId4 = PlaySound({ Name = soundName })
	SetVolume({ Id = AmbienceId4, Value = 0.0 })
	SetVolume({ Id = AmbienceId4, Value = 1.0, Duration = 18 })
end

function FadeOutAmbience( duration )
	StopSound({ Id = AmbienceId, Duration = duration })
	AmbienceId = nil
	StopSound({ Id = AmbienceId3, Duration = 3 })
	AmbienceId3 = nil
	StopSound({ Id = AmbienceId4, Duration = 10 })
	AmbienceId4 = nil
end

function FadeOutAllAmbience( duration )
	local ambienceIds = CollapseTable({ AmbienceId, AmbienceId2, AmbienceId3, AmbienceId4, DefenseAmbienceId, RetrievalAmbienceId, FlyingAmbienceId })
	StopSound({ Ids = ambienceIds, Duration = duration })
	AmbienceId = nil
	AmbienceId2 = nil
	AmbienceId3 = nil
	AmbienceId4 = nil
	DefenseAmbienceId = nil
	RetrievalAmbienceId = nil
	FlyingAmbienceId = nil
end

function WagonAmbienceOff()
	SetSoundCueValue({ Id = GetMixingId({}), Names = { "Wagon" }, Value = 0.0, Duration = 0.0 })
	FadeOutAllAmbience( 0.5 )
	SwathAmbience()
end

function WagonAmbienceOn()
	SetSoundCueValue({ Id = GetMixingId({}), Names = { "Wagon" }, Value = 1.0, Duration = 1.0 })
	FadeOutAllAmbience( 0.5 )
	if currentlyOccupiedSwath == 6 or overmapRain then
		AmbienceId = PlaySound({ Name = "/Ambience/WagonInteriorStormAmbience" })
	else
		AmbienceId = PlaySound({ Name = "/SFX/World Sounds/CaravanInteriorLoop1" })
	end
end

function SwathAmbience()

	if currentAmbience == nil then
		currentAmbience = "/Ambience/Swath1Ambience"
	end

	Delete({ Name = "AmbienceObjects" })

	SetAudioEffectState({ Name = "Reverb", Value = 0.0 })

	if currentAmbience ~= nil and not openedCaravan and not caravanClosing then
		StopSound({ Name = currentAmbience, Duration = 0.3 })
		wait(1.0)
	end

	-- Audio
	if NodeData ~= nil then

		-- Global Ambiences by Swath
		if currentlyOccupiedSwath ~= nil then
			if currentlyOccupiedSwath == 1 then
				currentAmbience = "/Ambience/MediumWindFieldLeavesAmbience"
			elseif currentlyOccupiedSwath == 2 then
				currentAmbience = "/Ambience/ValleyAmbience"
			elseif currentlyOccupiedSwath == 3 then
				currentAmbience = "/Ambience/BurningAmbience"
			elseif currentlyOccupiedSwath == 4 then
				currentAmbience = "/Ambience/StormyBoatWaterAmbience"
			elseif currentlyOccupiedSwath == 5 then
				currentAmbience = "/Ambience/CalmBoatWaterAmbience"
			elseif currentlyOccupiedSwath == 6 then
				currentAmbience = "/Ambience/StormSwathAmbience"
			elseif currentlyOccupiedSwath == 7 then
				currentAmbience = "/Ambience/CreepyForestAmbience"
			elseif currentlyOccupiedSwath == 8 then
				currentAmbience = "/Ambience/Swath1Ambience"
			elseif currentlyOccupiedSwath == 9 then
				currentAmbience = "/Ambience/MountainAmbience"
			else
				currentAmbience = nil
			end
			if currentAmbience ~= nil then
				SwitchAmbience( currentAmbience )
			end

			if overmapRain then
				currentAmbience2 = "/Ambience/RainAmbience"
			end
			if currentAmbience2 ~= nil then
				SwitchSecondaryAmbience( currentAmbience2 )
			end

		end
	end

end

function LocationAmbience( locationId )
	local nodeData = NodeData[locationId]
	if nodeData.Ambience ~= nil then
		local ambience = nodeData.Ambience
		PlaySound({ Name = ambience, Id = locationId })
		StopSound({ Name = ambience, Duration = 60 })
	end
end

function LocationSpecialAmbience( locationId )
	local nodeData = NodeData[locationId]
	if nodeData.SpecialAmbience ~= nil then
		local ambience = nodeData.SpecialAmbience
		NodeAmbienceId = PlaySound({ Name = ambience, Id = locationId })
		PersistVariable({ Name = "NodeAmbienceId" })
	end
end

OnTriggerFired
{ "EndCurrentAmbience",
	function(triggerArgs)
		FadeOutAllAmbience( 0.5 )
	end
}

OnTriggerFired
{ "ResumeCurrentAmbience",
	function(triggerArgs)
		thread( SwathAmbience )
	end
}

--[[ **INTRO VOICEOVER** ]]
function StartArchJusticeSpeech()
	SetAudioEffectState({ Name = "Reverb", Value = 1.0 })
	-- PlaySpeech({ Name = "/VO/Justice_Monologue", Id = archJustice  })

	-- Mercy is the beating heart of our glorious society.
	-- PlaySpeech({ Name = "/VO/Commonwealth_2", Id = archJustice  })

	wait(0.25)
	-- Mercy is the beating heart of our glorious Commonwealth.
	PlaySpeech({ Name = "/VO/Commonwealth_18", Id = archJustice  })
end

OnSoundComplete{ "/VO/Commonwealth_2 /VO/Commonwealth_18",
	function( triggerArgs )
		wait(1.0)
		-- Mercy, even for the foulest traitors.
		PlaySpeech({ Name = "/VO/Commonwealth_3", Id = archJustice  })
	end
}

OnSoundComplete{ "/VO/Commonwealth_3",
	function( triggerArgs )
		wait(1.25)
		-- As weeds take root in even the most splendid gardens, so too is no society immune to treachery…
		PlaySpeech({ Name = "/VO/Commonwealth_4", Id = archJustice  })
	end
}

OnSoundComplete{ "/VO/Commonwealth_4",
	function( triggerArgs )
		wait(0.9)
		-- Though treachery, like weeds, can be weeded out.
		PlaySpeech({ Name = "/VO/Commonwealth_5", Id = archJustice  })
	end
}

OnSoundComplete{ "/VO/Commonwealth_5",
	function( triggerArgs )
		wait(1.3)
		-- Expelled!
		PlaySpeech({ Name = "/VO/Commonwealth_6", Id = archJustice  })
	end
}

OnSoundComplete{ "/VO/Commonwealth_6",
	function( triggerArgs )
		wait(0.9)
		-- And so, to those who bear ill will, we swear this oath:
		PlaySpeech({ Name = "/VO/Commonwealth_7", Id = archJustice  })
	end
}

OnSoundComplete{ "/VO/Commonwealth_7",
	function( triggerArgs )
		wait(1.15)
		-- All are welcome here save demons such as you.
		PlaySpeech({ Name = "/VO/Commonwealth_8", Id = archJustice  })
	end
}

--[[
OnSoundComplete{ "/VO/Commonwealth_8",
	function( triggerArgs )
		wait(1.0)
		-- We shall not descend to your level.
		PlaySpeech({ Name = "/VO/Commonwealth_9", Id = archJustice  })
	end
}
]]--

OnSoundComplete{ "/VO/Commonwealth_8",
	function( triggerArgs )
		wait(1.25)
		-- That which poisoned your soul shall not take root in ours!
		PlaySpeech({ Name = "/VO/Commonwealth_10", Id = archJustice  })
	end
}

--[[
OnSoundComplete{ "/VO/Commonwealth_10",
	function( triggerArgs )
		wait(1.0)
		-- You are beneath contempt.
		PlaySpeech({ Name = "/VO/Commonwealth_11", Id = archJustice  })
	end
}
]]--

OnSoundComplete{ "/VO/Commonwealth_10 /VO/Commonwealth_11",
	function( triggerArgs )
		wait(1.85)
		-- As Mercy guides our hand, we spare your life... but rid ourselves of you.
		PlaySpeech({ Name = "/VO/Commonwealth_12", Id = archJustice  })
	end
}

OnSoundComplete{ "/VO/Commonwealth_12",
	RequiredFalseFlag = "EndArchJusticeSpeech",
	function( triggerArgs )
		wait(1.25)
		-- Begone!
		PlaySpeech({ Name = "/VO/Commonwealth_13", Id = archJustice  })
	end
}

OnSoundComplete{ "/VO/Commonwealth_13",
	RequiredFalseFlag = "EndArchJusticeSpeech",
	function( triggerArgs )
		wait(0.75)
		-- To distant lands, beneath our own, more suited to your kind.
		-- PlaySpeech({ Name = "/VO/Commonwealth_14", Id = archJustice  })

		-- Down the river, to lands more suited to your kind.
		PlaySpeech({ Name = "/VO/Commonwealth_19", Id = archJustice  })
	end
}

OnSoundComplete{ "/VO/Commonwealth_14 /VO/Commonwealth_19",
	RequiredFalseFlag = "EndArchJusticeSpeech",
	function( triggerArgs )
		wait(1.25)
		-- There, may you live out your days in penitence.
		-- PlaySpeech({ Name = "/VO/Commonwealth_15", Id = archJustice  })


		-- There, may you live out such days as to befit your wicked thoughts and deeds.
		PlaySpeech({ Name = "/VO/Commonwealth_20", Id = archJustice  })
	end
}

OnSoundComplete{ "/VO/Commonwealth_20",
	RequiredFalseFlag = "EndArchJusticeSpeech",
	function( triggerArgs )
		wait(1.25)
		-- And may you finally see yourself for what you are.
		PlaySpeech({ Name = "/VO/Commonwealth_21", Id = archJustice  })
	end
}

OnSoundComplete{ "/VO/Commonwealth_15",
	RequiredFalseFlag = "EndArchJusticeSpeech",
	function( triggerArgs )
		wait(1.0)
		-- May you assume the terrible, misshapen form befitting your thoughts and deeds.
		PlaySpeech({ Name = "/VO/Commonwealth_16", Id = archJustice  })
	end
}

OnSoundComplete{ "/VO/Commonwealth_16",
	RequiredFalseFlag = "EndArchJusticeSpeech",
	function( triggerArgs )
		wait(1.0)
		-- May you finally see yourself for what you are.
		PlaySpeech({ Name = "/VO/Commonwealth_17", Id = archJustice  })
	end
}

function EndArchJusticeSpeech()
	SetFlagTrue({ Name = "EndArchJusticeSpeech" })
	SetAudioEffectState({ Name = "Reverb", Value = 0.0 })
	-- StopSound({ Name = "/VO/Justice_Monologue", Id = archJustice, Duration = 0.2 })
end


-- IntroSpeech1
OnSoundComplete{ "/VO/Justice_169",
	function( triggerArgs )
		wait(0.7)
		if Coach.FriendMeeting == "IgnoredFriend" then
			if Char.Gender == "female" then
				-- One to whom you showed no gratitude after she saved your wretched life?
				PlaySpeech({ Name = "/VO/Justice_170" })
			else
				-- One to whom you showed no gratitude after he saved your wretched life?
				PlaySpeech({ Name = "/VO/Justice_171" })
			end
		else
			-- One to whom you gave your thanks, whilst to the Commonwealth you showed only contempt?
			PlaySpeech({ Name = "/VO/Justice_172" })
		end
	end
}

OnSoundComplete{ "/VO/Justice_170 /VO/Justice_171 /VO/Justice_172",
	function( triggerArgs )
		wait(1.2)
		if Char.Gender == "female" then
			-- You venture forth with her into the Otherworld.
			PlaySpeech({ Name = "/VO/Justice_174" })
		else
			-- You venture forth with him into the land of Downriver.
			PlaySpeech({ Name = "/VO/Justice_209" })
		end
	end
}

OnSoundComplete{ "/VO/Justice_173 /VO/Justice_209",
	function( triggerArgs )
		wait(1.2)
		-- And you shall wallow there, alone, in boundless shame.
		PlaySpeech({ Name = "/VO/Justice_175" })
	end
}

-- IntroSpeech2
OnSoundComplete{ "/VO/Justice_176",
	function( triggerArgs )
		wait(0.7)
		if Coach.Reason == "CoachChoice01" then
			if Coach.Action == "CoachAction01" then
				-- You confess to practice of the Old Ways.
				-- PlaySpeech({ Name = "/VO/Justice_177" })
				-- You admit you are a Reader in spite of Commonwealth decree.
				PlaySpeech({ Name = "/VO/Justice_210" })
			elseif Coach.Action == "CoachAction02" then
				-- You still deny your practice of the Old Ways.
				-- PlaySpeech({ Name = "/VO/Justice_178" })
				-- You deny being a Reader, and having violated Commonwealth decree.
				PlaySpeech({ Name = "/VO/Justice_211" })
			else
				-- You were sentenced for your practice of the Old Ways.
				-- PlaySpeech({ Name = "/VO/Justice_179" })
				-- You were sentenced for being a Reader, thus violating Commonwealth decree.
				PlaySpeech({ Name = "/VO/Justice_212" })
			end
		elseif Coach.Reason == "CoachChoice02" then
			if Coach.Action == "CoachAction01" then
				-- You confess to causing someone harm.
				PlaySpeech({ Name = "/VO/Justice_180" })
			elseif Coach.Action == "CoachAction02" then
				-- You still deny the harm you caused another.
				PlaySpeech({ Name = "/VO/Justice_181" })
			else
				-- You were sentenced for causing someone harm.
				PlaySpeech({ Name = "/VO/Justice_182" })
			end
		elseif Coach.Reason == "CoachChoice03" then
			if Coach.Action == "CoachAction01" then
				-- You confess to a leading a life of excess.
				PlaySpeech({ Name = "/VO/Justice_183" })
			elseif Coach.Action == "CoachAction02" then
				-- You still deny living in sinful excess.
				PlaySpeech({ Name = "/VO/Justice_184" })
			else
				-- You were sentenced for living in excess.
				PlaySpeech({ Name = "/VO/Justice_185" })
			end
		elseif Coach.Reason == "CoachChoice04" then
			if Coach.Action == "CoachAction01" then
				-- You did admit to certain crimes, yet you make light of them.
				PlaySpeech({ Name = "/VO/Justice_189" })
			elseif Coach.Action == "CoachAction02" then
				-- You still deny the crimes that earned your sentence here.
				PlaySpeech({ Name = "/VO/Justice_190" })
			else
				-- You disregard the reasons for your sentencing.
				PlaySpeech({ Name = "/VO/Justice_191" })
			end
		elseif Coach.Reason == "CoachChoice05" then
			if Coach.Action == "CoachAction01" then
				-- You admit you do not know why you are here.
				PlaySpeech({ Name = "/VO/Justice_186" })
			elseif Coach.Action == "CoachAction02" then
				-- You claim falsely not to know why you are here.
				PlaySpeech({ Name = "/VO/Justice_187" })
			else
				-- You were sentenced with good reason by the Commonwealth.
				PlaySpeech({ Name = "/VO/Justice_188" })
			end
		-- 'high treason'
		elseif Coach.Reason == "CoachChoice08" then
			if Coach.Action == "CoachAction01" then
				-- You confess to acts of treason 'gainst the Commonwealth.
				PlaySpeech({ Name = "/VO/Justice_213" })
			elseif Coach.Action == "CoachAction02" then
				-- You deny committing treason 'gainst the Commonwealth.
				PlaySpeech({ Name = "/VO/Justice_214" })
			else
				-- You were sentenced for high treason 'gainst the Commonwealth.
				PlaySpeech({ Name = "/VO/Justice_215" })
			end
		-- 'make something up'
		elseif Coach.Reason == "CoachChoice07" then
			if Coach.Action == "CoachAction01" then
				-- You confess to a tale most slanderous 'twixt you and my own Chosen!
				PlaySpeech({ Name = "/VO/Justice_216" })
			elseif Coach.Action == "CoachAction02" then
				-- You deny some of your slanderous tale 'twixt you and my own Chosen.
				PlaySpeech({ Name = "/VO/Justice_217" })
			else
				-- You spin quite the slanderous tale 'twixt you and my own Chosen!
				PlaySpeech({ Name = "/VO/Justice_218" })
			end
		else
			if Coach.Action == "CoachAction01" then
				-- You know what you have done to deserve this.
				PlaySpeech({ Name = "/VO/Justice_192" })
			elseif Coach.Action == "CoachAction02" then
				-- You still deny the accusations of the Commonwealth.
				PlaySpeech({ Name = "/VO/Justice_193" })
			else
				-- You remain silent on the circumstances of your sentencing.
				PlaySpeech({ Name = "/VO/Justice_194" })
			end
		end
	end
}

OnSoundComplete{ "/VO/Justice_177 /VO/Justice_180 /VO/Justice_183 /VO/Justice_186 /VO/Justice_189 /VO/Justice_192 /VO/Justice_210 /VO/Justice_213 /VO/Justice_216",
	function( triggerArgs )
		wait(0.85)
		-- Too little and too late.
		PlaySpeech({ Name = "/VO/Justice_195" })
	end
}

OnSoundComplete{ "/VO/Justice_178 /VO/Justice_181 /VO/Justice_184 /VO/Justice_187 /VO/Justice_190 /VO/Justice_193 /VO/Justice_211 /VO/Justice_214 /VO/Justice_217",
	function( triggerArgs )
		wait(0.85)
		-- Truth, however, cannot be denied.
		PlaySpeech({ Name = "/VO/Justice_196" })
	end
}

OnSoundComplete{ "/VO/Justice_179 /VO/Justice_182 /VO/Justice_185 /VO/Justice_188 /VO/Justice_191 /VO/Justice_194 /VO/Justice_212 /VO/Justice_215 /VO/Justice_218",
	function( triggerArgs )
		wait(0.85)
		-- Admit to it or not, the sentence stands.
		PlaySpeech({ Name = "/VO/Justice_197" })
	end
}

OnSoundComplete{ "/VO/Justice_195 /VO/Justice_196 /VO/Justice_197",
	function( triggerArgs )
		wait(0.9)
		-- All that you once held dear has now forsaken you. You seek salvation where none is to be found.
		PlaySpeech({ Name = "/VO/Justice_198" })
	end
}

-- **Match Speech**
function PlayMatchSpeech( args )

	if args == "matchstart" then
		if IsMultiplayerMatch() then
			thread( LocalMPMatchStartVO )
		end
	elseif args == "levelupjodariel" then
		-- The exile Jodariel has gained enlightenment!
		PlaySpeech({ Name = "/VO/Justice_287" })

	-- **week 2 match**
	elseif args == "vsaccusers_prepowerup" then
		wait(0.65)
		-- It seems that you have flustered the Accusers!
		PlaySpeechOnce({ Name = "/VO/Match_394" })
	elseif args == "vsaccusers_postpowerup" then
		wait(1.2)
		-- Have you any idea what that Lendel did to deserve his exile, hm?
		PlaySpeechOnce({ Name = "/VO/Match_395" })
		thread( ArchJusticeSpeaking )
	elseif args == "vsaccusers_youscoredfirst" then
		wait(1.25)
		-- It seems that you have flustered the Accusers!
		PlaySpeechOnce({ Name = "/VO/Match_394" })
	elseif args == "vsaccusers_theyscoredfirst" then
		wait(1.25)
		-- Lendel seeks to wash away the stain upon his honor. Would you deny him that?!
		PlaySpeechOnce({ Name = "/VO/Match_398" })
	elseif args == "lendelpoweredup_youscored" then
		wait(0.8)
		-- Hark, Reader! Your adversary Lendel draws upon the Auras of his cohorts!
		PlaySpeechOnce({ Name = "/VO/Match_401" })
	elseif args == "lendelpoweredup_theyscored" then
		wait(0.8)
		-- Hark, Reader! Your adversary Lendel aims to further his advantage!
		PlaySpeechOnce({ Name = "/VO/Match_402" })
	elseif args == "lendelpoweredup_continued" then
		wait(0.8)
		-- Lendel the Liar, he was branded, just before he was cast down for his crimes.
		-- PlaySpeech({ Name = "/VO/Match_396" })
		-- thread( ArchJusticeSpeaking )

	-- **week 2 match**
	elseif args == "week2_vsfate" then
		thread( ArchJusticeSpeaking )
		wait(1.25)
		-- A boon come from the stars themselves!
		PlaySpeechOnce({ Name = "/VO/Justice_732" })

	-- **week 3 ti'zo tutorial**
	elseif args == "week3_tizotutorial" then
		thread( ArchJusticeSpeaking )
		wait(1.25)
		-- Another joins your ranks?
		PlaySpeechOnce({ Name = "/VO/Justice_740" })

	-- **week 3 match**
	elseif args == "week3_vsdissidents" then
		thread( ArchJusticeSpeaking )
		wait(1.25)
		-- Careful, now! Your adversary Barker there seems rather fired up.
		PlaySpeechOnce({ Name = "/VO/Justice_744" })

	-- **week 4 match**
	elseif args == "week4_vswithdrawn" then
		thread( ArchJusticeSpeaking )
		wait(1.25)
		-- The witch invokes a profane name I shan't repeat.
		PlaySpeechOnce({ Name = "/VO/Justice_752" })

	-- **week 5 match**
	elseif args == "week5_vspyrehearts" then
		thread( ArchJusticeSpeaking )
		wait(1.25)
		-- Oh boo, a bit of foul weather, it would seem.
		PlaySpeechOnce({ Name = "/VO/Justice_760" })

	-- **week 5 match alt**
	elseif args == "week5_vspyrehearts_alt" then
		thread( ArchJusticeSpeaking )
		wait(1.25)
		-- There seems to be dissention in your adversary's ranks!
		PlaySpeechOnce({ Name = "/VO/Justice_762" })

	-- **week 6 pamitha tutorial**
	elseif args == "week6_pamithatutorial" then
		thread( ArchJusticeSpeaking )
		wait(1.25)
		-- Reader... you put yourself amidst a feud between two sisters?
		PlaySpeechOnce({ Name = "/VO/Justice_770" })

	-- **week 6 match**
	elseif args == "week6_vsessence" then
		showdownScoring = true
		thread( ArchJusticeSpeaking )
		wait(1.25)
		-- What is it those two think they're doing?!
		PlaySpeechOnce({ Name = "/VO/Justice_774" })

	-- **week 7 match**
	elseif args == "week7_saplingintro" then
		thread( ArchJusticeSpeaking )
		wait(1.25)
		-- Manley and his offspring hold no small degree of influence within the Commonwealth, Reader.
		PlaySpeechOnce({ Name = "/VO/Justice_1071" })

	elseif args == "week7_vschastity" then
		thread( ArchJusticeSpeaking )
		wait(1.25)
		-- Your adversary Manley is comfortable in this suffocating glade.
		PlaySpeechOnce({ Name = "/VO/Justice_784" })

	-- **week 8 match**
	elseif args == "week8_vstempers" and not blockMatchVO then
		thread( ArchJusticeSpeaking )
		wait(1.25)
		-- The demon whom you face was once a man!
		PlaySpeechOnce({ Name = "/VO/Justice_793" })

	elseif args == "theyscored_startedraining" then
		wait(1.25)
		-- Can you feel your defeat encroaching?
		PlaySpeechOnce({ Name = "/VO/Match_390" })
	elseif args == "youscored_startedraining" then
		wait(1.25)
		-- Such a bitter stroke of fate.
		-- PlaySpeechOnce({ Name = "/VO/Match_392" })
	elseif args == "leavingmatchsite" then
		-- 'Twas but the first stage of the Rites. Look to the stars for guidance, for I shall offer none.
		PlaySpeech({ Name = "/VO/Match_292" })

	-- **open structure: bertrude tutorial**
	elseif args == "bertrudetutorial" then
		thread( ArchJusticeSpeaking )
		wait(1.25)
		-- The bog-crone Bertrude shows herself in full.
		PlaySpeechOnce({ Name = "/VO/Justice_967" })

	-- **open structure: volfred tutorial**
	elseif args == "volfredtutorial" then
		thread( ArchJusticeSpeaking )
		wait(1.25)
		-- And there he is, at last, alive and well.
		PlaySpeechOnce({ Name = "/VO/Justice_971" })

	-- **open structure: MatchSiteJ imp mob**
	elseif args == "impmob" then
		thread( ArchJusticeSpeaking )
		wait(1.55)
		-- What are those blasted creatures doing?
		PlaySpeechOnce({ Name = "/VO/Justice_1029" })

	-- **open structure: misc midmatch events**
	elseif args == "misc_midmatchevent" then
		thread( ArchJusticeSpeaking )
		wait(1.2)
		if blockMatchVO then
			return
		end
		if NextTeam.LeagueIndex == 2 then
			if NextTeam.SpeechesPlayed == nil then
				-- That Lendel certainly enjoys a rousing speech, though talk means nothing in the Rites!
				PlaySpeechOnce({ Name = "/VO/Justice_1031", Queue = "Always" })
				NextTeam.SpeechesPlayed = 1
				return
			elseif NextTeam.SpeechesPlayed == 1 then
				-- That Lendel yearns to regain his status in the Commonwealth. Would you deny him that?
				PlaySpeechOnce({ Name = "/VO/Justice_1053", Queue = "Always" })
				NextTeam.SpeechesPlayed = 2
				return
			elseif NextTeam.SpeechesPlayed == 2 then
				-- If only Lendel's tendency to bluster caused him to prevail, why, then, he'd be free by now.
				PlaySpeechOnce({ Name = "/VO/Justice_1054", Queue = "Always" })
				NextTeam.SpeechesPlayed = 3
				return
			end
		elseif NextTeam.LeagueIndex == 3 then
			if NextTeam.SpeechesPlayed == nil then
				-- Such a struggle it must be for poor old Dalbert and his witless son.
				PlaySpeechOnce({ Name = "/VO/Justice_1032", Queue = "Always" })
				NextTeam.SpeechesPlayed = 1
				return
			elseif NextTeam.SpeechesPlayed == 1 then
				-- The Fate, they claim to honor this tradition, and yet their claims seldom ring true.
				PlaySpeechOnce({ Name = "/VO/Justice_1055", Queue = "Always" })
				NextTeam.SpeechesPlayed = 2
				return
			elseif NextTeam.SpeechesPlayed == 2 then
				-- Dalbert and Almer, each so gallant yet eternally naive. Like Father, like Son.
				PlaySpeechOnce({ Name = "/VO/Justice_1056", Queue = "Always" })
				NextTeam.SpeechesPlayed = 3
				return
			end
		elseif NextTeam.LeagueIndex == 4 then
			if NextTeam.SpeechesPlayed == nil then
				-- That foolish Barker was a menace to the Commonwealth, and is a blight upon the Rites!
				PlaySpeechOnce({ Name = "/VO/Justice_1033", Queue = "Always" })
				NextTeam.SpeechesPlayed = 1
				return
			elseif NextTeam.SpeechesPlayed == 1 then
				-- The disgraceful Barker Ashpaws is a constant blight upon the sanctity of these proceedings.
				PlaySpeechOnce({ Name = "/VO/Justice_1057", Queue = "Always" })
				NextTeam.SpeechesPlayed = 2
				return
			elseif NextTeam.SpeechesPlayed == 2 then
				-- That Barker is a menace lacking so much as a smidgen of respect for our most sacred tradition!
				PlaySpeechOnce({ Name = "/VO/Justice_1058", Queue = "Always" })
				NextTeam.SpeechesPlayed = 3
				return
			end
		elseif NextTeam.LeagueIndex == 5 then
			if NextTeam.SpeechesPlayed == nil then
				-- Ah the foul witch Udmildhe.
				PlaySpeechOnce({ Name = "/VO/Justice_1034", Queue = "Always" })
				return
			elseif NextTeam.SpeechesPlayed == 1 then
				-- The witch Udmildhe, she cares not for freedom! Her desires are... unconscionable.
				PlaySpeechOnce({ Name = "/VO/Justice_1059", Queue = "Always" })
				NextTeam.SpeechesPlayed = 2
				return
			elseif NextTeam.SpeechesPlayed == 2 then
				-- The Withdrawn were once deserving of respect! Now they evoke disgust, and nothing more.
				PlaySpeechOnce({ Name = "/VO/Justice_1060", Queue = "Always" })
				NextTeam.SpeechesPlayed = 3
				return
			end
		elseif NextTeam.LeagueIndex == 6 then
			if NextTeam.SpeechesPlayed == nil then
				-- That craven Sir Deluge, doubtless using exile as a means of shirking military service!
				PlaySpeechOnce({ Name = "/VO/Justice_1036", Queue = "Always" })
				NextTeam.SpeechesPlayed = 1
				return
			elseif NextTeam.SpeechesPlayed == 1 then
				-- The Pyrehearts seem to be having trouble living up to their name and olden reputation as of late.
				PlaySpeechOnce({ Name = "/VO/Justice_1061", Queue = "Always" })
				NextTeam.SpeechesPlayed = 2
				return
			elseif NextTeam.SpeechesPlayed == 2 then
				-- Would that every exile in the Downside was as dutiful as Sir Deluge's ever-loyal wyrm-knights.
				PlaySpeechOnce({ Name = "/VO/Justice_1062", Queue = "Always" })
				NextTeam.SpeechesPlayed = 3
				return
			end
		elseif NextTeam.LeagueIndex == 7 then
			if NextTeam.SpeechesPlayed == nil then
				-- Such hatred spewing constantly from Tamitha, yet here in exile, she is naught but talk.
				PlaySpeechOnce({ Name = "/VO/Justice_1037", Queue = "Always" })
				return
			elseif NextTeam.SpeechesPlayed == 1 then
				-- So utterly ungrateful is that Tamitha, of the great mercy shown her by the Commowealth.
				PlaySpeechOnce({ Name = "/VO/Justice_1063", Queue = "Always" })
				NextTeam.SpeechesPlayed = 2
				return
			elseif NextTeam.SpeechesPlayed == 2 then
				-- Surely the Scribes shall not allow one so hateful as that Tamitha to regain her freedom.
				PlaySpeechOnce({ Name = "/VO/Justice_1064", Queue = "Always" })
				NextTeam.SpeechesPlayed = 3
				return
			end
		elseif NextTeam.LeagueIndex == 8 then
			if NextTeam.SpeechesPlayed == nil then
				-- That Manley Tinderstauf has such a mind for politics... would that he focused on the Rites!
				PlaySpeechOnce({ Name = "/VO/Justice_1038", Queue = "Always" })
				return
			elseif NextTeam.SpeechesPlayed == 1 then
				-- That Manley acts as though he is already free! A bit presumptuous of him, I think.
				PlaySpeechOnce({ Name = "/VO/Justice_1065", Queue = "Always" })
				NextTeam.SpeechesPlayed = 2
				return
			elseif NextTeam.SpeechesPlayed == 2 then
				-- Would that every Sap I ever met were as agreeable as our friend Manley there.
				PlaySpeechOnce({ Name = "/VO/Justice_1066", Queue = "Always" })
				NextTeam.SpeechesPlayed = 3
				return
			end
		elseif NextTeam.LeagueIndex == 9 then
			if NextTeam.SpeechesPlayed == nil then
				-- Oh, the fading glory of the great Ignarius! These days he is nothing but an aging brute.
				PlaySpeechOnce({ Name = "/VO/Justice_1039", Queue = "Always" })
				return
			elseif NextTeam.SpeechesPlayed == 1 then
				-- That Ignarius is nothing but a common thug, arrived at a dead end upon his path to freedom.
				PlaySpeechOnce({ Name = "/VO/Justice_1067", Queue = "Always" })
				NextTeam.SpeechesPlayed = 2
				return
			elseif NextTeam.SpeechesPlayed == 2 then
				-- The once-mighty Tempers now seem to lack the will and fierceness for which they were known!
				PlaySpeechOnce({ Name = "/VO/Justice_1068", Queue = "Always" })
				NextTeam.SpeechesPlayed = 3
				return
			end
		elseif NextTeam.LeagueIndex == 11 then
			if NextTeam.SpeechesPlayed == nil then
				-- How he has changed, that Oralech... grown old and bitter lo these many years.
				PlaySpeechOnce({ Name = "/VO/Justice_1040", Queue = "Always" })
				return
			elseif NextTeam.SpeechesPlayed == 1 then
				-- Reader... you and that damned Oralech, and your friend, Volfred... you all deserve each other.
				PlaySpeechOnce({ Name = "/VO/Justice_1070", Queue = "Always" })
				NextTeam.SpeechesPlayed = 3
				return
			elseif NextTeam.SpeechesPlayed == 2 then
				-- Oralech! The Scribes themselves have turned their backs on you! Cease now your insolence!
				PlaySpeechOnce({ Name = "/VO/Justice_1069", Queue = "Always" })
				NextTeam.SpeechesPlayed = 2
				return
			end
		end
	elseif args == "localmpintro" then
		wait(0.35)
		PlaySound({ Name = "/SFX/Match SFX/AnnouncementThunder" })
		wait(0.45)
		if localMPintro1 then
			-- Hark, Exiles!
			PlaySpeech({ Name = "/VO/Justice_470", Queue = "Always" })
		elseif localMPintro2 then
			if CoinFlip() then
				-- Well if it isn't my two favorite triumvirates!
				PlaySpeech({ Name = "/VO/Justice_451", Queue = "Always" })
			else
				-- Ah my favorite exiles!
				PlaySpeech({ Name = "/VO/Justice_452", Queue = "Always" })
			end
		end
	-- LocalMP short intro / abridged intro
	elseif args == "localmprematch" then
		wait(2.0)
		PlaySound({ Name = "/SFX/Match SFX/AnnouncementThunder" })
		thread( LocalMPVersusIntroAudio )
		-- Welcome.
		-- PlaySpeech({ Name = "/VO/Justice_5", Queue = "Always", Delay = 0.45 })
	end
end

-- **week 2 event follow-up**
OnSoundComplete{ "/VO/Justice_732",
	function( triggerArgs )
		wait(0.8)
		-- But shall it be enough for Dalbert and his faithful son?
		PlaySpeechOnce({ Name = "/VO/Justice_733" })
	end
}

-- **week 3 ti'zo tutorial follow-up**
OnSoundComplete{ "/VO/Justice_740",
	function( triggerArgs )
		wait(0.8)
		-- And, a mere imp?
		PlaySpeechOnce({ Name = "/VO/Justice_741" })
	end
}

OnSoundComplete{ "/VO/Justice_741",
	function( triggerArgs )
		wait(0.8)
		-- Although... hrm, no, it cannot be.
		PlaySpeechOnce({ Name = "/VO/Justice_742" })
	end
}

OnSoundComplete{ "/VO/Justice_742",
	function( triggerArgs )
		wait(0.8)
		-- Then, we shall see what comes of this new partnership of yours.
		PlaySpeechOnce({ Name = "/VO/Justice_743" })
	end
}

-- **week 3 event follow-up**
OnSoundComplete{ "/VO/Justice_744",
	function( triggerArgs )
		wait(0.8)
		-- Whatever shall you do against so fierce a foe?
		PlaySpeechOnce({ Name = "/VO/Justice_745" })
	end
}

-- **week 4 event follow-up**
OnSoundComplete{ "/VO/Justice_752",
	function( triggerArgs )
		wait(0.8)
		-- Best beware her foul sorceries.
		PlaySpeechOnce({ Name = "/VO/Justice_753" })
	end
}

-- **week 5 event follow-up**
OnSoundComplete{ "/VO/Justice_760",
	function( triggerArgs )
		wait(0.8)
		-- Both your Pyres soon shall smolder at this rate!
		PlaySpeechOnce({ Name = "/VO/Justice_761" })
	end
}

-- **week 5 event alt follow-up**
OnSoundComplete{ "/VO/Justice_762",
	function( triggerArgs )
		wait(0.8)
		-- Tis little wonder these fool wyrm-knights...
		PlaySpeechOnce({ Name = "/VO/Justice_763" })
	end
}

-- **week 6 pamitha tutorial follow-up**
OnSoundComplete{ "/VO/Justice_770",
	function( triggerArgs )
		wait(0.8)
		-- That seems entirely unwise, even for you.
		PlaySpeechOnce({ Name = "/VO/Justice_771" })
	end
}

OnSoundComplete{ "/VO/Justice_771",
	function( triggerArgs )
		wait(0.8)
		-- Tread lightly 'round that exile Pamitha.
		PlaySpeechOnce({ Name = "/VO/Justice_772" })
	end
}

OnSoundComplete{ "/VO/Justice_772",
	function( triggerArgs )
		wait(0.8)
		-- Her kind's all but forgotten Saint Triesta's grace.
		PlaySpeechOnce({ Name = "/VO/Justice_773" })
	end
}

-- **week 6 event follow-up**
OnSoundComplete{ "/VO/Justice_774",
	function( triggerArgs )
		wait(0.8)
		-- The Rites are not the place to settle petty scores!
		PlaySpeechOnce({ Name = "/VO/Justice_775" })
	end
}

OnSoundComplete{ "/VO/Justice_775",
	function( triggerArgs )
		wait(0.8)
		-- Long since tainted by the Downside, or rather, by his crimes.
		PlaySpeechOnce({ Name = "/VO/Justice_775" })
	end
}

-- **week 7 event follow-up**
OnSoundComplete{ "/VO/Justice_1071",
	function( triggerArgs )
		wait(0.8)
		-- There are many who would welcome his return. Though, none so much as he himself.
		PlaySpeechOnce({ Name = "/VO/Justice_1072" })
	end
}

OnSoundComplete{ "/VO/Justice_784",
	function( triggerArgs )
		wait(0.8)
		-- Yet he longs now for the comfort of his Commonwealth estate!
		PlaySpeechOnce({ Name = "/VO/Justice_785" })
	end
}

OnSoundComplete{ "/VO/Justice_785",
	function( triggerArgs )
		wait(0.8)
		-- Perhaps such wealth ought be reserved instead for you?
		PlaySpeechOnce({ Name = "/VO/Justice_786" })
	end
}

-- **week 8 event follow-up**
OnSoundComplete{ "/VO/Justice_793",
	function( triggerArgs )
		wait(0.8)
		-- Long since tainted by the Downside, or rather, by his crimes.
		PlaySpeechOnce({ Name = "/VO/Justice_794" })
	end
}

OnSoundComplete{ "/VO/Justice_794",
	function( triggerArgs )
		wait(0.8)
		-- if you're winning
		if PlayerTeam.PyreHealth >= NextTeam.PyreHealth then
			-- I suspect his pennance is not yet complete.
			PlaySpeechOnce({ Name = "/VO/Justice_796" })
		-- if you're losing
		else
			-- Perhaps his absolution is at hand.
			PlaySpeechOnce({ Name = "/VO/Justice_795" })
		end
	end
}

-- **week 2: vs Accusers intro follow-up**
OnSoundComplete{ "/VO/Justice_5",
	function( triggerArgs )
		if IsMultiplayerMatch() then
			return
		end
		wait(0.9)
		-- Whosever Pyre yet burns once the other is extinguished shall step closer to freedom!
		PlaySpeech({ Name = "/VO/Justice_449" })
	end
}

-- **open structure: imp mob follow-up**
OnSoundComplete{ "/VO/Justice_1029",
	function( triggerArgs )
		wait(0.9)
		-- This is a sacred tradition, not some boorish spectacle!
		PlaySpeechOnce({ Name = "/VO/Justice_1030" })
	end
}

-- **open structure: vs Udmildhe follow-up**
OnSoundComplete{ "/VO/Justice_1034",
	function( triggerArgs )
		wait(0.8)
		-- Would that she served the Scribes as faithfully as the monstrosity which she adores!
		PlaySpeechOnce({ Name = "/VO/Justice_1035" })
	end
}

-- **LocalMP Showcase Intro**
OnSoundComplete{ "/VO/Justice_470",
	function( triggerArgs )
		if not head2head then
			return
		end
		wait(0.65)
		if longerMPintro then
			-- Each of you seeks to be free from this forsaken land.
			PlaySpeech({ Name = "/VO/Justice_471", Queue = "Always" })
		else
			-- Let us see which one of you shall be the first to extinguish your adversary's Pyre.
			PlaySpeech({ Name = "/VO/Justice_467", Queue = "Always" })
		end
	end
}

OnSoundComplete{ "/VO/Justice_471",
	function( triggerArgs )
		wait(0.9)
		-- Let us see which one of you deserves it more.
		-- PlaySpeech({ Name = "/VO/Justice_472" })
	end
}

OnSoundComplete{ "/VO/Justice_472",
	function( triggerArgs )
		wait(0.9)
		-- Be the first to quench your adversary's Pyre, and thereby show your worth.
		PlaySpeech({ Name = "/VO/Justice_473" })
	end
}

-- LocalMP Alt Intro
OnSoundComplete{ "/VO/Justice_451 /VO/Justice_452",
	function( triggerArgs )
		if not head2head then
			return
		end
		wait(0.6)
		if longerMPintro then
			-- Locked in an eternal struggle for salvation.
			PlaySpeech({ Name = "/VO/Justice_453", Queue = "Always" })
		end
	end
}

OnSoundComplete{ "/VO/Justice_453",
	function( triggerArgs )
		wait(0.65)
		-- Let us see which one of you shall be the first to extinguish your adversary's Pyre.
		PlaySpeech({ Name = "/VO/Justice_467", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_467",
	function( triggerArgs )
		wait(0.65)
		-- Prevail, and step closer to freedom.
		PlaySpeech({ Name = "/VO/Justice_468", Queue = "Always" })
	end
}

-- "lendelpoweredup_youscored" / "lendelpoweredup_theyscored" followup
OnSoundComplete{ "/VO/Match_401 /VO/Match_402",
	function( triggerArgs )
		wait(1.0)

	end
}

-- "levelupjodariel" followup
OnSoundComplete{ "/VO/Justice_287",
	function( triggerArgs )
		waitScreenTime(1.0)
		-- Only the enlightened can regain their freedom.
		PlaySpeech({ Name = "/VO/Justice_289" })
	end
}

-- **IntroMatch Speech**
function PlayIntroMatchSpeech( args )

	if args == nil then
		return
	end

	-- return out if in Trailer Mode (normally this option is true)
	if not GetConfigOptionValue({ Name = "ShowUIAnimations" }) then
		return
	end

	if args == "intro" then
		-- Reader!
		PlaySpeech({ Name = "/VO/Justice_219" })
		wait(0.1)
		CreateMeteringEntry({ Name = "ArchJustice", DSP = "/Silent/VisualVOcontrol", FalloffTime = 1.0, PropagationTime = -1.0, MaxDistance = 999999 })
	elseif args == "theball" then
		-- A Celestial Orb falls from the heavens when the time is nigh.
		PlaySpeech({ Name = "/VO/Justice_238", Queue = "Always" })
	elseif args == "gottheball" then
		-- Two Pyres shall ignite, afield of one another.
		-- PlaySpeech({ Name = "/VO/Justice_240" })
		-- The Orb is used to quench the burning Pyre.
		-- PlaySpeech({ Name = "/VO/Justice_239" })
	elseif args == "passedtheball" then
		if canPlayTriumvirate then
			-- Exiles conduct the Rites as a triumvirate, for they must prove their trust in one another, not just in themselves.
			PlaySpeech({ Name = "/VO/Justice_241", Queue = "Always" })
		else
			waitUntil( "canPlayTriumvirate" )
			-- Exiles conduct the Rites as a triumvirate, for they must prove their trust in one another, not just in themselves.
			PlaySpeech({ Name = "/VO/Justice_241", Queue = "Always" })
		end
	elseif args == "oneatatime" then
		if canPlayThreeMustActAsOne then
			wait(0.35)
			-- The three must act as one!
			PlaySpeech({ Name = "/VO/Justice_242", Queue = "Always" })
		else
			waitUntil( "canPlayThreeMustActAsOne" )
			-- The three must act as one!
			PlaySpeech({ Name = "/VO/Justice_242", Queue = "Always" })
		end
	elseif args == "learn2sprint" then
		-- We all must make our path.
		-- PlaySpeech({ Name = "/VO/Justice_126" })
	elseif args == "thepyre" then
		wait(0.25)
		-- Now plunge into the Pyre with Orb, and be purified!
		PlaySpeech({ Name = "/VO/Justice_433", Queue = "Always" })
	elseif args == "firstscorehedwyn" then
		wait(0.25)
		-- Yes! The exile Hedwyn has the way of it.
		PlaySpeech({ Name = "/VO/Justice_245", Queue = "Always" })
	elseif args == "firstscorejodariel" then
		wait(0.25)
		-- Yes! The exile Jodariel has the way of it.
		PlaySpeech({ Name = "/VO/Justice_246", Queue = "Always" })
	elseif args == "firstscorerukey" then
		wait(0.25)
		-- Yes! The exile Rukey has the way of it.
		PlaySpeech({ Name = "/VO/Justice_247", Queue = "Always" })
	elseif args == "rivaltagged" then
		wait(0.25)
		-- The Aura is your wrongdoing; accept it as a part of you!
		PlaySpeechOnce({ Name = "/VO/Justice_251" })
	elseif args == "rivalshot" then
		-- Correctly done.
		PlaySpeech({ Name = "/VO/Justice_274a", Queue = "Interrupt" })
	elseif args == "banishremainingrival" then
		wait(1.95)
		-- Again.
		PlaySpeech({ Name = "/VO/Justice_439", Queue = "Always"  })
	elseif args == "banishremainingrivalcomplete" then
		wait(0.65)
		-- Just so.
		PlaySpeech({ Name = "/VO/Justice_271a", Queue = "Always" })
	elseif args == "reclaimorb" then
		wait(0.25)
		-- Grasp the Orb once more.
		PlaySpeechOnce({ Name = "/VO/Justice_434", Queue = "Always" })
	elseif args == "aurathrow" then
		wait(0.45)
		-- Cast your Aura like a stone!
		PlaySpeech({ Name = "/VO/Justice_270c", Queue = "Always" })
	elseif args == "firewhenready" then
		wait(0.25)
		-- Go on.
		PlaySpeechOnce({ Name = "/VO/Justice_264c" })
	elseif args == "recoveredtheball" then
		wait(0.45)
		-- The Orb absorbs the Aura, then the Orb quenches the flame.
		PlaySpeechOnce({ Name = "/VO/Justice_252", Queue = "Always" })
	elseif args == "jumpintopyre" then
		wait(0.25)
		-- Now, I say jump.
		PlaySpeech({ Name = "/VO/Justice_436b", Queue = "Always" })
	elseif args == "jumpfail" then
		if timesJumpFailed == nil then
			timesJumpFailed = 1
		end
		wait(0.45)
		if timesJumpFailed == 1 then
			-- Not quite.
			PlaySpeech({ Name = "/VO/Justice_28a" })
		elseif timesJumpFailed == 2 then
			-- Into the flames.
			PlaySpeech({ Name = "/VO/Justice_437" })
		elseif timesJumpFailed == 3 then
			-- Do it.
			PlaySpeech({ Name = "/VO/Justice_438" })
		elseif timesJumpFailed == 4 then
			-- I can wait.
			PlaySpeech({ Name = "/VO/Justice_441b" })
		end
		timesJumpFailed = timesJumpFailed + 1
	elseif args == "secondscore" then
		wait(0.35)
		-- Thus sails the Orb into the waiting flame!
		PlaySpeech({ Name = "/VO/Match_315a" })
		-- A true-aimed thrust into the fire!
		-- PlaySpeech({ Name = "/VO/Match_314" })
		-- Again the Orb quenches the fires of your adversaries!
		-- PlaySpeech({ Name = "/VO/Justice_442" })
	elseif args == "winthematch" then
		wait(0.25)
		-- Now snuff out the adversary's Pyre whilst yours yet burns!
		PlaySpeech({ Name = "/VO/Justice_256", Queue = "Always" })
		thread( ArchJusticeSpeaking )
	elseif args == "lastscore" then
		wait(0.25)
		-- There, dear Reader, now you understand.
		PlaySpeech({ Name = "/VO/Justice_257", Queue = "Always" })
	else
	end

end

-- "intro" followup
OnSoundComplete{ "/VO/Justice_219",
	function( triggerArgs )
		wait(0.9)
		-- Dare you tamper with forbidden knowledge?
		PlaySpeech({ Name = "/VO/Justice_220" })
	end
}

OnSoundComplete{ "/VO/Justice_220",
	function( triggerArgs )
		wait(0.8)
		if Coach.Reason == "CoachChoice01" then
			-- So soon after your punishment for practicing the Old Ways.
			PlaySpeech({ Name = "/VO/Justice_221" })
		elseif Coach.Reason == "CoachChoice02" then
			-- So soon after your punishment for causing someone harm.
			PlaySpeech({ Name = "/VO/Justice_222" })
		elseif Coach.Reason == "CoachChoice03" then
			-- So soon after your punishment for living in excess.
			PlaySpeech({ Name = "/VO/Justice_223" })
		elseif Coach.Reason == "CoachChoice04" then
			-- So soon after your punishment for treason.
			PlaySpeech({ Name = "/VO/Justice_224" })
		elseif Coach.Reason == "CoachChoice05" then
			-- So soon after you punishment for brazen falsehood.
			PlaySpeech({ Name = "/VO/Justice_225" })
		elseif Coach.Reason == "CoachChoice06" then
			-- So soon after your punishment for such a faulty memory.
			PlaySpeech({ Name = "/VO/Justice_226" })
		elseif Coach.Reason == "CoachChoice07" then
			-- So soon after your punishment for flagrant apathy.
			PlaySpeech({ Name = "/VO/Justice_227" })
		elseif Coach.Reason == "CoachChoice08" then
			-- So soon after your punishment for holding your tongue.
			PlaySpeech({ Name = "/VO/Justice_228" })
		else
			-- So soon after your sentence into exile.
			PlaySpeech({ Name = "/VO/Justice_229" })
		end
	end
}

OnSoundComplete{ "/VO/Justice_221 /VO/Justice_222 /VO/Justice_223 /VO/Justice_224 /VO/Justice_225 /VO/Justice_226 /VO/Justice_227 /VO/Justice_228 /VO/Justice_229",
	function( triggerArgs )
		wait(0.8)
		thread( StartMatchMusic )
		-- Tis true what the Book says! You can be free again.
		PlaySpeech({ Name = "/VO/Justice_230" })
	end
}

OnSoundComplete{ "/VO/Justice_230",
	function( triggerArgs )
		wait(0.8)
		-- Perhaps not you yourself, but someone worthy of the privilege.
		PlaySpeech({ Name = "/VO/Justice_231" })
	end
}

OnSoundComplete{ "/VO/Justice_231",
	function( triggerArgs )
		wait(0.8)
		-- You witness now the path toward salvation.
		PlaySpeech({ Name = "/VO/Justice_232" })
	end
}

OnSoundComplete{ "/VO/Justice_232",
	function( triggerArgs )
		wait(0.8)
		-- You witness... the Rites!
		PlaySpeech({ Name = "/VO/Justice_233" })
	end
}

OnSoundComplete{ "/VO/Justice_233",
	function( triggerArgs )
		wait(0.8)
		-- The one way to return to glory!
		PlaySpeech({ Name = "/VO/Justice_234" })
	end
}

OnSoundComplete{ "/VO/Justice_234",
	function( triggerArgs )
		wait(0.8)
		-- Though in your case I hardly think it possible.
		PlaySpeech({ Name = "/VO/Justice_235" })
	end
}

OnSoundComplete{ "/VO/Justice_235",
	function( triggerArgs )
		wait(0.8)
		-- Yet by the grace of the Scribes it is my duty to inform you anyhow.
		PlaySpeech({ Name = "/VO/Justice_236" })
	end
}

-- "theball" followup
OnSoundComplete{ "/VO/Justice_238",
	function( triggerArgs )
		wait(0.5)
		canPlayTriumvirate = true
		notifyExistingWaiters( "canPlayTriumvirate" )
	end
}

-- "passedtheball" followup
OnSoundComplete{ "/VO/Justice_241",
	function( triggerArgs )
		wait(0.5)
		canPlayThreeMustActAsOne = true
		notifyExistingWaiters( "canPlayThreeMustActAsOne" )
	end
}

-- sprinting tutorial
OnSoundComplete{ "/VO/Justice_242",
	function( triggerArgs )
		if not introMatch then
			return
		end
		wait(1.65)
		-- We all are family in the Commonwealth! And families have rules.
		-- PlaySpeech({ Name = "/VO/Justice_47", Queue = "Always" })
	end
}

-- "firstscore" followup
OnSoundComplete{ "/VO/Justice_245 /VO/Justice_246 /VO/Justice_247",
	function( triggerArgs )
		wait(1.0)
		-- Whoever steps into the flame is banished!
		PlaySpeech({ Name = "/VO/Justice_253", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_253",
	function( triggerArgs )
		wait(0.45)
		-- For a time.
		PlaySpeech({ Name = "/VO/Justice_254" })
	end
}

OnSoundComplete{ "/VO/Justice_254",
	function( triggerArgs )
		wait(0.65)
		-- His or her cohorts must make do on their own.
		PlaySpeech({ Name = "/VO/Justice_255" })
	end
}

OnSoundComplete{ "/VO/Justice_255",
	function( triggerArgs )
		wait(1.2)
		-- O but it is not so simple.
		PlaySpeech({ Name = "/VO/Justice_248", Queue = "Always" })
	end
}

-- "postscore" followup
OnSoundComplete{ "/VO/Justice_248",
	function( triggerArgs )
		wait(1.2)
		-- In the Rites you shall face adversaries whose own freedom is at stake.
		PlaySpeech({ Name = "/VO/Justice_249" })
	end
}

OnSoundComplete{ "/VO/Justice_249",
	function( triggerArgs )
		wait(1.2)
		-- Beware the Aura that surrounds them, as they shall beware yours.
		PlaySpeech({ Name = "/VO/Justice_250" })
	end
}

OnSoundComplete{ "/VO/Justice_250",
	RequiredFlag = "CatchEnemyInAuraTutorial",
	function( triggerArgs )
		wait(1.4)
		-- Tread lightly.
		-- PlaySpeech({ Name = "/VO/Justice_661f" })
	end
}

-- "jumpintopyre" followup
OnSoundComplete{ "/VO/Justice_436b",
	function( triggerArgs )
		wait(0.8)
		-- Leap, with all your strength.
		PlaySpeech({ Name = "/VO/Justice_440" })
	end
}

-- "banishremainingrivalcomplete" followup
OnSoundComplete{ "/VO/Justice_271a",
	function( triggerArgs )
		wait(1.2)
		-- A glorious performance I admit.
		PlaySpeech({ Name = "/VO/Match_383a", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Match_383a",
	function( triggerArgs )
		wait(0.95)
		-- More than I expected from the likes of you.
		PlaySpeech({ Name = "/VO/Match_384a" })
	end
}

-- "lastscore" followup
OnSoundComplete{ "/VO/Justice_257",
	function( triggerArgs )
		wait(1.1)
		-- Or do you?
		PlaySpeech({ Name = "/VO/Justice_258" })
	end
}

OnSoundComplete{ "/VO/Justice_258",
	function( triggerArgs )
		wait(1.0)
		-- This was but a glimpse of that which lies ahead.
		PlaySpeech({ Name = "/VO/Justice_259" })
	end
}

OnSoundComplete{ "/VO/Justice_259",
	function( triggerArgs )
		wait(0.9)
		-- I would tell you to turn back.
		PlaySpeech({ Name = "/VO/Justice_260" })
	end
}

OnSoundComplete{ "/VO/Justice_260",
	function( triggerArgs )
		wait(0.9)
		-- Cast down your hope.
		PlaySpeech({ Name = "/VO/Justice_261" })
	end
}

OnSoundComplete{ "/VO/Justice_261",
	function( triggerArgs )
		wait(0.9)
		-- But all those such as you?
		PlaySpeech({ Name = "/VO/Justice_262" })
	end
}

OnSoundComplete{ "/VO/Justice_262",
	function( triggerArgs )
		wait(1.2)
		-- You never listen.
		PlaySpeech({ Name = "/VO/Justice_263" })
	end
}


--[[ **VOICEOVER** ]]

-- Speech delay: Change the wait() to affect rate of most dynamic speech playback
function ArchJusticeSpeaking()
	if archJusticeSpokeRecently then
		return
	end

	if not archJusticeSpokeRecently then
		archJusticeSpokeRecently = true
		local speechDelay = math.random(12,15)
		if netMPMatch then
			speechDelay = math.random(11,14)
		elseif head2head then
			speechDelay = math.random(10,13)
		end
		wait( speechDelay )
		archJusticeSpokeRecently = false
	end
end

-- Speech delay alternate for shorter lines
function ArchJusticeHooting()
	if archJusticeHootedRecently then
		return
	end

	if not archJusticeHootedRecently then
		archJusticeHootedRecently = true
		local speechDelay = math.random(3,5)
		wait( speechDelay )
		archJusticeHootedRecently = false
	end
end

-- captures slow-mo moment speech
function DramaticMomentPlaying()
	if dramaticMomentPlaying then
		return
	end

	if not dramaticMomentPlaying then
		dramaticMomentPlaying = true
		local speechDelay = math.random(3,3)
		wait( speechDelay )
		dramaticMomentPlaying = false
	end
end

function DramaticMomentFollowUpPlaying()
	if dramaticMomentFollowUpPlaying then
		return
	end

	if not dramaticMomentFollowUpPlaying then
		dramaticMomentFollowUpPlaying = true
		local speechDelay = math.random(3,3)
		wait( speechDelay )
		dramaticMomentFollowUpPlaying = false
	end
end

SpeechSet = SpeechSet or {}

-- Campaign Start VO
OnAnyLoad{ function( triggerArgs )

	  -- Campaign VO [OLD]
      SpeechSet.StartCampaign =
      {
	      "/VO/Justice_2",
	      "/VO/Justice_3",
	      "/VO/Justice_4",
	      "/VO/Justice_5",
      }
      function StartCampaignAudio()
	      wait(0.25)
	      PlaySound({ Name = "/SFX/Match SFX/AnnouncementThunder" })
	      wait(0.75)
	      PlayRemainingSpeech( SpeechSet.StartCampaign )
      end

      SpeechSet.StartOvermap =
      {
	      "/VO/Justice_65",
	      "/VO/Justice_66",
      }
      function StartOvermapAudio()
	      wait(0.3)
	      PlayRemainingSpeech( SpeechSet.StartOvermap )
      end

      -- Overmap Goal VO
      SpeechSet.OvermapGoal =
      {
	      "/VO/Justice_70",
      }
      function OvermapGoalAudio()
	      wait(0.25)
	      PlayRemainingSpeech( SpeechSet.OvermapGoal )
      end

	-- Caravan Moving VO
	SpeechSet.CaravanMoving =
	{
	  "/VO/Justice_67",
	  "/VO/Justice_68",
	}
	function CaravanMovingAudio()
		wait(0.15)
		if archJusticeSpokeRecently then
			return
		end
		local randomChance = math.random(1,3)
		if randomChance == 1 then
		  PlayRemainingSpeech( SpeechSet.CaravanMoving )
		end
		thread( ArchJusticeSpeaking )
	end

      -- Overmap New Season VO
      SpeechSet.NewSeason =
      {
	      "/VO/Justice_69",
      }

      function NewSeasonAudio()
	      wait(0.25)
	      PlayRemainingSpeech( SpeechSet.NewSeason )
      end

      -- Overmap Forfeit VO
      SpeechSet.OvermapForfeit =
      {
	      "/VO/Justice_71",
      }
      function OvermapForfeitAudio()
	      wait(0.25)
	      PlayRemainingSpeech( SpeechSet.OvermapForfeit )
      end

	-- Overmap Greeting VO
	SpeechSet.MorningGreeting =
	{
	      "/VO/Overmap_2",
	      "/VO/Overmap_3",
	      "/VO/Overmap_4",
	}
	SpeechSet.AfternoonGreeting =
	{
	      "/VO/Overmap_5",
	      "/VO/Overmap_6",
	      "/VO/Overmap_7",
	}
	SpeechSet.EveningGreeting =
	{
	      "/VO/Overmap_8",
	      "/VO/Overmap_9",
	      "/VO/Overmap_10",
	}
	function OvermapGreetingAudio()
		wait(0.25)
		if archJusticeSpokeRecently then
			return
		end
		thread( ArchJusticeSpeaking )

		if allowAfternoonVO then
			PlayRemainingSpeech( SpeechSet.AfternoonGreeting )
		elseif timeofday == "night" then
			PlayRemainingSpeech( SpeechSet.EveningGreeting )
		else
			PlayRemainingSpeech( SpeechSet.MorningGreeting )
		end
	end

-- Overmap Calendar VO
SpeechSet.TodaysDate =
{
	  "/VO/Overmap_11",
	  "/VO/Overmap_12",
	  "/VO/Overmap_13",
}

	-- Overmap Weather VO
	SpeechSet.WeatherForecasts =
	{
		"/VO/Overmap_65",
		"/VO/Overmap_66",
		"/VO/Overmap_67",
		"/VO/Overmap_68",
		"/VO/Overmap_69",
		"/VO/Overmap_70",
		"/VO/Overmap_71",
		"/VO/Overmap_72",
		"/VO/Overmap_73",
		"/VO/Overmap_74",
		"/VO/Overmap_75",
	}
	function OvermapWeatherForecastAudio()
		wait(0.25)
		PlayRemainingSpeech( SpeechSet.WeatherForecasts )
	end

OnSoundComplete{ "/VO/Overmap_65 /VO/Overmap_66 /VO/Overmap_67 /VO/Overmap_68 /VO/Overmap_69 /VO/Overmap_70 /VO/Overmap_71 /VO/Overmap_72 /VO/Overmap_73 /VO/Overmap_74 /VO/Overmap_75",
	function( triggerArgs )
		notifyExistingWaiters( "ArchJusticeAudioComplete" )
	end
}

	-- Overmap Contextual VO
	SpeechSet.OvermapContext =
	{
		"/VO/Justice_91"
	}

	-- LockerRoom VO
    SpeechSet.NewEvent =
    {
	    "/VO/Justice_72",
	    "/VO/Justice_73",
    }
    function NewEventAudio()
	    wait(1.0)
	    local randomChance = math.random(1,4)
	    if randomChance == 1 then
		    PlayRemainingSpeech( SpeechSet.NewEvent )
	    end
    end

	-- Caravan Screen / Roster Screen VO
    SpeechSet.CaravanScreen =
    {
	    "/VO/Justice_77",
	    "/VO/Justice_78",
    }
    function CaravanScreenAudio()
	    wait(1.0)
	    PlayRemainingSpeech( SpeechSet.CaravanScreen, "noreload" )
    end

    SpeechSet.RosterPlayerSmall =
    {
	    "/VO/Justice_79",
    }
    function RosterPlayerSmallAudio()
	    wait(1.0)
	    PlayRemainingSpeech( SpeechSet.RosterPlayerSmall )
    end

    SpeechSet.RosterPlayerMedium =
    {
	    "/VO/Justice_81",
    }
    function RosterPlayerMediumAudio()
	    wait(1.0)
	    PlayRemainingSpeech( SpeechSet.RosterPlayerMedium )
    end

    SpeechSet.RosterPlayerLarge =
    {
	    "/VO/Justice_80",
    }
    function RosterPlayerLargeAudio()
	    wait(1.0)
	    PlayRemainingSpeech( SpeechSet.RosterPlayerLarge )
    end

    SpeechSet.RosterPlayerTree =
    {
	    "/VO/Justice_82",
    }
    function RosterPlayerTreeAudio()
	    wait(1.0)
	    PlayRemainingSpeech( SpeechSet.RosterPlayerTree )
    end

    SpeechSet.RosterPlayerMisc =
    {
	    "/VO/Justice_83",
    }
    function RosterPlayerMiscAudio()
	    wait(1.0)
	    PlayRemainingSpeech( SpeechSet.RosterPlayerMisc )
    end

    SpeechSet.ScheduleScreen =
    {
	    "/VO/Justice_84",
    }
    function ScheduleScreenAudio()
	    wait(1.0)
	    PlayRemainingSpeech( SpeechSet.ScheduleScreen, "noreload" )
    end

    SpeechSet.StashScreen =
    {
	    "/VO/Justice_85",
    }
    function StashScreenAudio()
	    wait(1.0)
	    PlayRemainingSpeech( SpeechSet.StashScreen, "noreload" )
    end

	-- Guidebook VO
    SpeechSet.GuideBookOpened =
    {
	    "/VO/Justice_74",
	    "/VO/Justice_75",
    }
    function GuideBookOpenedAudio()
	    waitScreenTime(0.65)
	    PlayRemainingSpeech( SpeechSet.GuideBookOpened, "noreload" )
    end

    SpeechSet.GuideBookUpdated =
    {
	    "/VO/Justice_76",
    }
    function GuideBookUpdatedAudio()
	    waitScreenTime(0.45)
	    PlayRemainingSpeech( SpeechSet.GuideBookUpdated )
    end

	-- **Campaign Map VO**
	-- Titan Stars / Difficulty Modifiers VO
	function DifficultyModifiersIntroAudio()
		if not SpeechRecord["/VO/Match_608"] then
			wait(0.65)
			-- Behold, the Titan Stars.
			PlaySpeech({ Name = "/VO/Match_608" })
		else
			wait(0.65)
			-- The Titan Stars.
			PlaySpeech({ Name = "/VO/Match_609" })
		end
	end

	SpeechSet.DifficultyModifiersSomeChosen =
	{
			-- You looked upon the Titan Stars.
			"/VO/Match_622",
			-- You beseech the Titan Stars.
			"/VO/Match_623",
			-- You would look upon the Titan Stars?
			"/VO/Match_624",
	}
	function DifficultyModifiersSomeChosenAudio()
		wait(0.85)
		PlayRemainingSpeech( SpeechSet.DifficultyModifiersSomeChosen )
	end

	SpeechSet.DifficultyModifiersAllChosen =
	{
			-- All of the Titan Stars... sheer madness.
			"/VO/Match_625",
			-- Wha, all of the Titan Stars?
			"/VO/Match_626",
	}
	function DifficultyModifiersAllChosenAudio()
		wait(0.85)
		PlayRemainingSpeech( SpeechSet.DifficultyModifiersAllChosen )
	end

    -- **Match VO**
    -- VO for Draft Begins
    SpeechSet.DraftBegins =
    {
		-- Who shall conduct the Rites?
	    "/VO/Justice_10",
		-- The Rite shall begin forthwith.
	    "/VO/Justice_7",
		-- Who shall conduct this Rite?
	    "/VO/Match_700",
		-- Who shall conduct the Rite?
	    "/VO/Match_701",
		-- Who shall strive for freedom?
	    "/VO/Match_702",
		-- Who shall stand together here this night?
	    "/VO/Match_703",
		-- Now prepare yourselves.
		-- "/VO/Match_696",
		-- Now let us begin.
		"/VO/Match_697",
		-- Now we shall get started.
		"/VO/Match_698",
		-- Now let us get started.
		"/VO/Match_699",
	    -- "/VO/Justice_6",
	    -- "/VO/Justice_8",
    }
    SpeechSet.DraftBeginsLateGame =
    {
		-- Who shall it be this time?
	    "/VO/Match_185",
		-- Choose now your band of traitors.
	    "/VO/Match_186",
		-- Who shall besmirch the Nightwings name?
	    "/VO/Match_187",
		-- Choose quickly your triumvirate.
	    "/VO/Match_188",
		-- Go on, then!
	    "/VO/Match_189",
    }
    SpeechSet.AscensionDraftBegins =
    {
		-- Who most deserves their freedom?
	    "/VO/Match_161",
		-- Who would you set free?
	    "/VO/Match_162",
		-- Who shall return to glory?
	    "/VO/Match_163",
		-- Whom do you intend to liberate?
	    "/VO/Match_164",
		-- Whom do you endeavor to return?
	    "/VO/Match_195",
		-- Whom shall you attempt to send home this time?
	    "/VO/Match_196",
		-- One final opportunity for salvation. Too bad for the rest of you.
	    "/VO/Match_197",
    }
    function DraftBeginsAudio()

		-- skipped in first match since there's no draft
		if not IsMultiplayerMatch() then
			if matchesPlayed == 0 and campaign then
				return
			-- skipped in practice match in week 2
			elseif matchesPlayed == 1 and practiceMatch then
				return
			elseif ChallengeData ~= nil then
				return
			end
		end

		-- draft music
		DraftMusic( "start" )

		PlaySound({ Name = "/Music/Stingers/LockerRoomStinger" })
	    wait(0.25)

		if blockMatchVO then
			return
		end

		-- standard week audio
		if not IsMultiplayerMatch() then
			-- early game draft VO
			if PlayerTeam.AscensionMatchesPlayed < 3 then
				if not IsAscensionWeek() then
					-- standard match draft start
					PlayRemainingSpeech( SpeechSet.DraftBegins )
				elseif ascensionMatch then
					-- ascension match draft start
					PlayNextRemainingSpeech( SpeechSet.AscensionDraftBegins )
				end
			-- late game draft VO
			else
				if not IsAscensionWeek() then
					-- standard match draft start
					PlayRemainingSpeech( SpeechSet.DraftBeginsLateGame )
				elseif ascensionMatch then
					-- ascension match draft start
					PlayNextRemainingSpeech( SpeechSet.AscensionDraftBegins )
				end
			end
		-- multiplayer audio
		else
			if GetConfigOptionValue({ Name = "LocalMPIntroPresentation" }) ~= "LocalMP_Intro_Short" then
				-- standard match draft start
				waitScreenTime(0.25)
				PlayRemainingSpeech( SpeechSet.DraftBegins, nil, "Always"  )
			else
				-- Welcome.
				PlaySpeech({ Name = "/VO/Justice_5" })

				waitScreenTime(3)

				-- Who shall conduct the Rites?
				PlaySpeech({ Name = "/VO/Justice_10" })
			end
		end
    end

end }

OnSoundComplete{ "/VO/Justice_8",
	function( triggerArgs )
		wait(1.5)
		PlaySpeech({ Name = "/VO/Justice_9" })
	end
}

-- VO for Draft Picks
OnAnyLoad{ function( triggerArgs )

    SpeechSet.DraftPlayerSmall =
    {
	    "/VO/Justice_114",
    }
    function DraftPlayerSmallAudio()
	    wait(0.25)
	    PlayRemainingSpeech( SpeechSet.DraftPlayerSmall )
    end

    SpeechSet.DraftPlayerMedium =
    {
	    "/VO/Justice_116",
    }
    function DraftPlayerMediumAudio()
	    wait(0.25)
	    PlayRemainingSpeech( SpeechSet.DraftPlayerMedium )
    end

    SpeechSet.DraftPlayerLarge =
    {
	    "/VO/Justice_115",
    }
    function DraftPlayerLargeAudio()
	    wait(0.25)
	    PlayRemainingSpeech( SpeechSet.DraftPlayerLarge )
    end

    SpeechSet.DraftPlayerTree =
    {
	    "/VO/Justice_117",
    }
    function DraftPlayerTreeAudio()
	    wait(0.25)
	    PlayRemainingSpeech( SpeechSet.DraftPlayerTree )
    end

    SpeechSet.DraftPlayerMisc =
    {
	    "/VO/Justice_118",
    }
    function DraftPlayerMiscAudio()
	    wait(0.25)
	    PlayRemainingSpeech( SpeechSet.DraftPlayerMisc )
    end

    SpeechSet.AscensionDraftSupportingPlayerMale =
    {
		-- Who shall stand with him?
		"/VO/Match_165",
		-- Who shall be at his side?
		"/VO/Match_166",
		-- Who shall lend him support?
		"/VO/Match_167",
		-- Who shall strive for him?
		"/VO/Match_168",
    }
    SpeechSet.AscensionDraftSupportingPlayerFemale =
    {
		-- Who shall stand with her?
		"/VO/Match_169",
		-- Who shall be at her side?
		"/VO/Match_170",
		-- Who shall lend her support?
		"/VO/Match_171",
		-- Who shall strive for her?
		"/VO/Match_172",
    }
    function AscensionDraftSupportingPlayerAudio()
		if practiceMatch then
			return
		end
	    wait(0.4)
		if LastAscendedCharacter.Gender == "Char_Gender_Male" or LastAscendedCharacter.Gender == "male" then
			PlayRemainingSpeech( SpeechSet.AscensionDraftSupportingPlayerMale )
		else
			PlayRemainingSpeech( SpeechSet.AscensionDraftSupportingPlayerFemale )
		end
    end

	-- VO for Draft Waiting

    SpeechSet.DraftWaiting =
    {
		-- Choose.
	    "/VO/Justice_119",
		-- Go.
	    "/VO/Justice_120",
		-- Anytime.
	    "/VO/Match_935",
		-- We're waiting.
	    "/VO/Match_936",
		-- Choose someone.
	    "/VO/Match_937",
		-- Your choice?
	    "/VO/Match_938",
		-- Decided yet?
	    "/VO/Match_939",
		-- Your decision?
	    "/VO/Match_940",
		-- Just choose.
	    "/VO/Match_941",
		-- Decide.
	    "/VO/Match_942",
		-- Go on.
	    "/VO/Match_943",
		-- Well?
	    "/VO/Match_944",
    }
    function DraftWaitingAudio()

		-- skipped in first match since there's no draft
		if matchesPlayed == 0 and campaign then
			return
		end
		if ascensionMatch then
			return
		end
		if blockMatchVO then
			return
		end
		if IsScreenOpen({ Name = "DialogueScreen" }) then
			return
		end
		if IsScreenOpen({ Name = "CharacterBioScreen" }) then
			return
		end
		if IsScreenOpen({ Name = "CharacterSkillsScreen" }) then
			return
		end
		if IsScreenOpen({ Name = "InventoryScreen" }) then
			return
		end
		if rosterViewOpponentOnly then
			return
		end

	    wait(0.15)
	    PlayRemainingSpeech( SpeechSet.DraftWaiting )
    end

    -- VO for Draft Complete
    SpeechSet.DraftComplete =
    {
		-- Very well.
	    "/VO/Justice_11",
		-- It is done.
	    "/VO/Justice_12",
		-- ...Now!
		"/VO/Match_704",
		-- It is done.
		"/VO/Match_139",
		-- ...The choice is cast!
		"/VO/Match_705",
		-- Whereupon six exiles gather on a sacred site,
	    -- "/VO/Justice_13",
    }
    SpeechSet.DraftCompleteLateGame =
    {
		-- Fine.
		"/VO/Match_190",
		-- If that is all, then...
		"/VO/Match_191",
		-- Predictably decided.
		"/VO/Match_192",
		-- Those three, then, hm?
		-- "/VO/Match_193",
		-- It is done.
		"/VO/Match_139",
		-- Very well.
	    "/VO/Justice_11",
		-- With that out of the way...
		"/VO/Match_194",
		-- It is done.
	    "/VO/Justice_12",
		-- ...Now!
		"/VO/Match_704",
		-- ...The choice is cast!
		"/VO/Match_705",
    }
    function DraftCompleteAudio()

	    wait(0.5)
	    StopSound({ Name = "/SFX/Menu Sounds/OrganChoirLoop1", Duration = 0.3 })
	    StopSound({ Name = "/SFX/Menu Sounds/OrganChoirLoop2", Duration = 0.3 })
	    StopSound({ Name = "/SFX/Menu Sounds/OrganChoirLoop3", Duration = 0.3 })

	    -- PlaySound({ Name = "/SFX/Menu Sounds/OrganChoirSting" })

		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			PlaySound({ Name = "/SFX/Match SFX/ImpCrowdImpressed" })
		end

	    wait(0.5)
		if not IsMultiplayerMatch() then
			if not blockMatchVO then
				if PlayerTeam.AscensionMatchesPlayed < 4 then
					PlayRemainingSpeech( SpeechSet.DraftComplete )
				else
					PlayRemainingSpeech( SpeechSet.DraftCompleteLateGame )
				end
			end
		end

	    wait(1.0)
	    PlaySound({ Name = "/SFX/World Sounds/ThunderHuge" })
    end

    -- **VO for NetMP Matches**
	SpeechSet.SearchingForMatch =
	{
		-- Very well.
	    "/VO/Justice_11",
		-- It is done.
	    "/VO/Justice_12",
		-- It is done.
		"/VO/Match_139"
	}
	function SearchingForMatchAudio()
		if blockMatchVO then
			return
		end
		wait(0.10)
		PlayRemainingSpeech( SpeechSet.SearchingForMatch )
		blockMatchVO = true
		wait(2.0)
		allowMatchFoundAudio = true
	end

	SpeechSet.MatchFound =
	{
		-- Your attention, please!
		"/VO/Justice_73",
		-- Hark!
		"/VO/Justice_110",
		-- The Rite shall begin forthwith.
		"/VO/Justice_7",
		-- Let us begin shall we?.
		"/VO/Justice_4",
		-- Stand forth!
		"/VO/Match_2",
		-- The time is nigh!
		"/VO/Match_4",
		-- The stars align!
		"/VO/Match_5",
	}
	function MatchFoundAudio()
		wait(0.10)
		-- this also plays when objective is complete
		-- PlaySound({ Name = "/SFX/Match SFX/AnnouncementThunder" })
		FadeMusicOut({ Duration = 3.0 })
		if not allowMatchFoundAudio then
			return
		end
		PlayRemainingSpeech( SpeechSet.MatchFound )
	end

	SpeechSet.PlayerDefeated =
	{
		-- Disappointed aren't we?
		"/VO/Match_388",
		-- Such a bitter stroke of fate.
		"/VO/Match_392",
		-- Gloom is the neighbor of the heart.
		"/VO/Justice_128",
		-- Look down, and plunge into a sea of misery!
		"/VO/Justice_130",
		-- Perhaps your fortune shall be better next time, hm?
		"/VO/Match_294",
		-- A shameful outcome.
		"/VO/Justice_41",

	}
	function PlayerDefeatedAudio()
		if blockMatchVO then
			return
		end
		wait(1.5)
		PlayRemainingSpeech( SpeechSet.PlayerDefeated )
	end

	SpeechSet.PlayerVictorious =
	{
		-- You have prevailed!
		"/VO/Justice_282",
		-- The Nightwings prevail!
		"/VO/Justice_483",
		-- The Eight Scribes show you favor.
		"/VO/Match_381",
		-- Let your spirit soar!
		"/VO/Justice_127",
		-- Sing for the righteous!
		"/VO/Justice_125",
		-- Perhaps you shan't be quite so fortunate next time.
		"/VO/Match_293",
		-- You have shown your worth.
		"/VO/Justice_37",
	}
	function PlayerVictoriousAudio()
		if blockMatchVO then
			return
		end
		wait(1.5)
		PlayRemainingSpeech( SpeechSet.PlayerVictorious )
	end

end }

function DraftSelectionAudio()
	if DraftedCharacter.DraftSelectVO ~= nil then
		local cue = DraftedCharacter.DraftSelectVO
		PlaySpeech({ Name = cue })
	end
end

-- VO for Match Intro
OnAnyLoad
{
	function( triggerArgs )
		SpeechSet.MatchIntro =
		{
			-- Stand forth!
			"/VO/Match_2",
			-- Listen well.
			"/VO/Match_3",
			-- The time is nigh!
			"/VO/Match_4",
			-- The stars align!
			"/VO/Match_5",
			-- Hear me,
			"/VO/Match_115",
			-- Tis time again,
			"/VO/Match_116",
			-- Look forth,
			"/VO/Match_117",
			-- Good evening there,
			"/VO/Match_118",
			-- Hark now,
			"/VO/Match_119",
		}
		SpeechSet.MatchOpponent =
		{
			-- Your adversaries in the coming Rite shall be:
			"/VO/Match_131",
			-- The adversaries you are to confront shall be:
			"/VO/Match_132",
			-- The triumvirate you stand against shall be:
			"/VO/Match_133",
			-- Your adversaries in the Rites this eve shall be:
			"/VO/Justice_277"
		}
		SpeechSet.MatchObjective =
		{
			-- "/VO/Match_16",
			-- "/VO/Match_17",
			-- "/VO/Match_69",
			-- "/VO/Match_70",
			-- "/VO/Match_71",
			-- Reduce their pyre to a smolder, and step closer to freedom!
			"/VO/Match_134",
			-- Snuff out their pyre's flame, and show your worth.
			"/VO/Match_135",
			-- Extinguish now their pyre, and glory shall be yours.
			"/VO/Match_136",
			-- Whosever Pyre yet burns once the other is extinguished shall step closer to freedom!
			-- "/VO/Justice_449",
			-- Whosever Pyre yet burns ere the break of dawn shall surge forward on the path to glory!
			"/VO/Justice_279",
		}
		function MatchIntroAudio()
			if practiceMatch or IsMultiplayerMatch() or PlayerTeam == nil then
				return
			end
			if GetConfigOptionValue({ Name = "UseCampaignShortMatchIntro" }) then
				return
			end
			wait(0.25)
			PlaySound({ Name = "/SFX/Match SFX/AnnouncementThunder" })
			wait(0.75)

			-- week 1 intro / Ridge match
			if matchesPlayed == 0 then
				-- Reader! The stars align at last!
				PlaySpeech({ Name = "/VO/Justice_275", Queue = "Always" })
			-- week 2 intro / Spring match
			elseif matchesPlayed == 1 then
				-- Reader! What brings you to the Spring of Jomuer Many-Mane?
				PlaySpeech({ Name = "/VO/Justice_725", Queue = "Always" })
			-- week 3 intro / Cairn match
			elseif matchesPlayed == 2 then
				-- Welcome, dear Reader, to the splendors of the accursed Cairn of Ha'ub.
				PlaySpeech({ Name = "/VO/Justice_734", Queue = "Always" })
			-- week 4 intro / Pit match
			elseif matchesPlayed == 3 then
				-- Why, you made it, Reader!
				PlaySpeech({ Name = "/VO/Justice_746", Queue = "Always" })
			-- week 5 intro / Hulk match
			elseif matchesPlayed == 4 then
				-- Relentless, aren't we, Reader?
				PlaySpeech({ Name = "/VO/Justice_754", Queue = "Always" })
			-- week 6 intro / Nest match
			elseif matchesPlayed == 5 then
				-- Reader. I thought for sure the stars would have eluded you by now.
				PlaySpeech({ Name = "/VO/Justice_764", Queue = "Always" })
			-- week 7 intro / Glade match
			elseif matchesPlayed == 6 then
				-- Once again the stars align themselves before you, Reader.
				PlaySpeech({ Name = "/VO/Justice_778", Queue = "Always" })
			-- week 8 intro / Fall match / first Ascension
			elseif matchesPlayed == 7 then
				-- Many years have passed...
				PlaySpeech({ Name = "/VO/Justice_1073", Queue = "Always" })
				-- Many, many moons have passed...
				-- PlaySpeech({ Name = "/VO/Justice_787", Queue = "Always" })
			-- season 2
			elseif PlayerTeam.AscensionMatchesPlayed == 1 then
				-- week 9 intro / first Open Structure (any location)
				if MatchesPlayedThisSeason == 0 then
					specialIntroVO = true
					-- Reader! Ever-persevering, aren't we.
					PlaySpeech({ Name = "/VO/Justice_807", Queue = "Always" })
				elseif MatchesPlayedThisSeason == 1 then
					PlayRemainingSpeech( SpeechSet.MatchIntro, nil, "Always" )
				-- week 10 intro / Difficulty Modifiers introduced
				elseif MatchesPlayedThisSeason == 2 then
					-- Lo, the Titan-Stars cut through the darkness once again. Tis a portentous sign.
					-- PlaySpeech({ Name = "/VO/Justice_815", Queue = "Always" })
					if TitanMode then
						PlayRemainingSpeech( SpeechSet.MatchIntro, nil, "Always" )
					else
						-- The Titan Stars...
						PlaySpeech({ Name = "/VO/Justice_1022", Queue = "Always" })
					end
				-- ascension 2 intro
				elseif IsAscensionWeek() then
					-- The Nightwings have returned unto the Fall of Soliam...
					PlaySpeech({ Name = "/VO/Justice_821", Queue = "Always" })
				end
			-- season 3
			elseif PlayerTeam.AscensionMatchesPlayed == 2 then
				-- Bertrude first match
				if MatchesPlayedThisSeason == 0 then
					specialIntroVO = true
					-- The much-vaunted Reader has returned!
					PlaySpeech({ Name = "/VO/Justice_834", Queue = "Always" })
				-- MatchSiteJ / Isle of Khaylmer intro
				elseif MatchesPlayedThisSeason == 1 then
					-- A glorious eve to you, as ever, O you exiles of the Nightwings.
					PlaySpeech({ Name = "/VO/Justice_906", Queue = "Always" })
				-- True Nightwings first appearance
				elseif MatchesPlayedThisSeason == 2 then
					-- Reader!! What lunacy is this?!
					PlaySpeech({ Name = "/VO/Justice_842", Queue = "Always" })
					blockMatchVO = true
				-- ascension 3 intro
				elseif IsAscensionWeek() then
					-- Congratulations, Reader.
					PlaySpeech({ Name = "/VO/Justice_850", Queue = "Always" })
				end
			-- season 4
			elseif PlayerTeam.AscensionMatchesPlayed == 3 then
				-- Volfred first match
				if MatchesPlayedThisSeason == 0 then
					-- Reader! Or should I say, Deceiver?!
					PlaySpeech({ Name = "/VO/Justice_864", Queue = "Always" })
				elseif MatchesPlayedThisSeason == 1 then
					PlayRemainingSpeech( SpeechSet.MatchIntro, nil, "Always" )
				-- ascension 4 intro
				elseif IsAscensionWeek() then
					-- Once more, the Nightwings gain the summit...
					PlaySpeech({ Name = "/VO/Justice_873", Queue = "Always" })
				end
			-- season 5
			elseif PlayerTeam.AscensionMatchesPlayed == 4 then
				if MatchesPlayedThisSeason == 0 then
					-- Ah, the infamous Reader returns.
					PlaySpeech({ Name = "/VO/Justice_886", Queue = "Always" })
				elseif MatchesPlayedThisSeason == 1 then
					-- Reader? I am still very cross with you, you know.
					PlaySpeech({ Name = "/VO/Justice_958", Queue = "Always", Delay = 0.3 })
				-- ascension 5 intro
				elseif IsAscensionWeek() then
					-- The stars that yet remain aflame align once more over the sacred Fall of Soliam.
					PlaySpeech({ Name = "/VO/Justice_909", Queue = "Always" })
				end
			-- season 6
			elseif PlayerTeam.AscensionMatchesPlayed == 5 then
				if MatchesPlayedThisSeason == 0 then
					-- Reader. It seems the stars once more have mustered wherewithal to usher in the Rites.
					PlaySpeech({ Name = "/VO/Justice_922", Queue = "Always" })
				-- ascension 6 intro
				elseif IsAscensionWeek() then
					-- Reader, I would ask that you think back for just a moment, if you please.
					PlaySpeech({ Name = "/VO/Justice_928", Queue = "Always" })
				end
			-- season 7
			elseif PlayerTeam.AscensionMatchesPlayed == 6 then
				if MatchesPlayedThisSeason == 0 then
					-- Reader. The Commonwealth... your home...
					PlaySpeech({ Name = "/VO/Justice_936", Queue = "Always" })
				-- ascension 7 intro
				elseif IsAscensionWeek() then
					-- Look, for one last time, upon the Fall of Soliam, dear Reader.
					PlaySpeech({ Name = "/VO/Justice_944", Queue = "Always" })
				end
			else
				PlayRemainingSpeech( SpeechSet.MatchIntro, nil, "Always" )
			end
		end
	end
}

-- **week 1 / ridge match intro followup**
OnSoundComplete{ "/VO/Justice_275",
	function( triggerArgs )
		wait(0.9)
		-- You reached the Ridge of Gol at the appointed time, and your triumvirate is ready.
		PlaySpeech({ Name = "/VO/Justice_276", Queue = "Always" })
	end
}

-- MatchSiteB Exception
OnSoundComplete{ "/VO/Justice_276",
	function( triggerArgs )
		wait(0.9)
		-- Your adversaries in the Rites this eve shall be:
		PlaySpeech({ Name = "/VO/Justice_277", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_277",
	function( triggerArgs )
		if not IsFirstAccusersMatch() then
			return
		end
		wait(0.25)
		-- the Accusers!
		PlaySpeech({ Name = "/VO/Justice_278", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_278",
	function( triggerArgs )
		if not IsFirstAccusersMatch() then
			return
		end
		wait(0.8)
		-- Whosever Pyre yet burns once the other is extinguished shall step closer to freedom!
		PlaySpeech({ Name = "/VO/Justice_449", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_449",
	function( triggerArgs )
		if not IsFirstAccusersMatch() then
			return
		end
		wait(0.8)
		-- Now let the Rites commence!
		PlaySpeech({ Name = "/VO/Match_18a", Queue = "Always" })
	end
}

-- **week 2 / spring match intro follow-up**
OnSoundComplete{ "/VO/Justice_725",
	function( triggerArgs )
		wait(0.8)
		-- Why, it must have been the stars!
		PlaySpeech({ Name = "/VO/Justice_726", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_726",
	function( triggerArgs )
		wait(0.8)
		-- Although, it seems that your triumvirate now numbers four exiles, not the expected three...!
		PlaySpeech({ Name = "/VO/Justice_727", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_727",
	function( triggerArgs )
		wait(0.95)
		-- The rules of the Rites were not created for you to besmirch!
		PlaySpeech({ Name = "/VO/Justice_728", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_728",
	function( triggerArgs )
		wait(0.9)
		-- Prepare now to confront the Fate!
		PlaySpeech({ Name = "/VO/Justice_729", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_729",
	function( triggerArgs )
		wait(0.8)
		-- They still honor the traditions of the Scribes, and surely have been longing for this chance.
		PlaySpeech({ Name = "/VO/Justice_730", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_730",
	function( triggerArgs )
		wait(0.9)
		-- But first, you have a choice to make.
		PlaySpeech({ Name = "/VO/Justice_731", Queue = "Always" })
	end
}

-- **week 3 / cairn match intro follow-up**
OnSoundComplete{ "/VO/Justice_734",
	function( triggerArgs )
		wait(0.8)
		-- You shall find the Downside grows less pleasant from this point, but first! There's a tradition to uphold.
		PlaySpeech({ Name = "/VO/Justice_735", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_735",
	function( triggerArgs )
		wait(0.8)
		-- This time you stand against the Dissidents! Even now they hunger to defeat you.
		PlaySpeech({ Name = "/VO/Justice_736", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_736",
	function( triggerArgs )
		wait(0.8)
		-- Perhaps not simply to regain their freedom, but to deny you yours.
		PlaySpeech({ Name = "/VO/Justice_737", Queue = "Always" })
	end
}

-- **week 4 / pit match intro follow-up**
OnSoundComplete{ "/VO/Justice_746",
	function( triggerArgs )
		wait(0.8)
		-- Made it all the way to the detestable Pit of Milithe!
		PlaySpeech({ Name = "/VO/Justice_747", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_747",
	function( triggerArgs )
		wait(0.8)
		-- In doing so, of course, you have disturbed your ancient adversaries: the Withdrawn.
		PlaySpeech({ Name = "/VO/Justice_748", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_748",
	function( triggerArgs )
		wait(0.8)
		-- The deranged witch who leads them has big plans in store, should she prevail in all this.
		PlaySpeech({ Name = "/VO/Justice_749", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_749",
	function( triggerArgs )
		wait(0.8)
		-- Now as you know I normally would wish you a shameful defeat.
		PlaySpeech({ Name = "/VO/Justice_750", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_750",
	function( triggerArgs )
		wait(0.8)
		-- But in this case... I wish you a little bit of luck.
		PlaySpeech({ Name = "/VO/Justice_751", Queue = "Always" })
	end
}

-- **week 5 / hulk match intro follow-up**
OnSoundComplete{ "/VO/Justice_754",
	function( triggerArgs )
		wait(0.8)
		-- Even the vastness of the sea was not enough to thwart your coming here, unto the Hulk of Ores.
		PlaySpeech({ Name = "/VO/Justice_755", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_755",
	function( triggerArgs )
		wait(0.8)
		-- You would be wise not to underestimate your adversaries here, despite their pitiable look.
		PlaySpeech({ Name = "/VO/Justice_756", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_756",
	function( triggerArgs )
		wait(0.8)
		-- I am, of course, referring to the Pyrehearts!
		PlaySpeech({ Name = "/VO/Justice_757", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_757",
	function( triggerArgs )
		wait(0.8)
		-- These Rites are but another war to them, and that makes you their mortal enemy.
		PlaySpeech({ Name = "/VO/Justice_758", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_758",
	function( triggerArgs )
		wait(0.8)
		-- I expect your battle to be glorious.
		PlaySpeech({ Name = "/VO/Justice_759", Queue = "Always" })
	end
}

-- **week 6 / nest match intro follow-up**
OnSoundComplete{ "/VO/Justice_764",
	function( triggerArgs )
		wait(0.8)
		-- Yet here you are, somehow, upon the Nest of Saint Triesta.
		PlaySpeech({ Name = "/VO/Justice_765", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_765",
	function( triggerArgs )
		wait(0.8)
		-- And you've swelled the ranks of your triumvirate not merely with another, but with two!
		PlaySpeech({ Name = "/VO/Justice_766", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_766",
	function( triggerArgs )
		wait(0.8)
		-- One from the Pyrehearts, no less; and one who seeks the favor of the adversaries whom you'll imminently face:
		PlaySpeech({ Name = "/VO/Justice_767", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_767",
	function( triggerArgs )
		wait(0.8)
		-- They are the Essence! Winged terrors, as you soon shall see.
		PlaySpeech({ Name = "/VO/Justice_768", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_768",
	function( triggerArgs )
		wait(0.8)
		-- Can your longing for freedom match their hatred for the vibrant country that was once your home?
		PlaySpeech({ Name = "/VO/Justice_769", Queue = "Always" })
	end
}

-- **week 7 / glade match intro follow-up**
OnSoundComplete{ "/VO/Justice_778",
	function( triggerArgs )
		wait(0.8)
		-- And here, now, at the Glade of Lu, I have to say, you've come so very far.
		PlaySpeech({ Name = "/VO/Justice_779", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_779",
	function( triggerArgs )
		wait(0.8)
		-- But there are those, such as your adversaries called the Chastity, who have toiled for this, too.
		PlaySpeech({ Name = "/VO/Justice_780", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_780",
	function( triggerArgs )
		wait(0.8)
		-- They know that with their freedom comes great opportunity.
		PlaySpeech({ Name = "/VO/Justice_781", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_781",
	function( triggerArgs )
		wait(0.8)
		-- It could be yours, instead.
		PlaySpeech({ Name = "/VO/Justice_782", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_782",
	function( triggerArgs )
		wait(0.8)
		-- Please show the Chastity that the Nightwings are superior.
		PlaySpeech({ Name = "/VO/Justice_783", Queue = "Always" })
	end
}

-- **week 8 / fall match / first Ascension intro follow-up**
OnSoundComplete{ "/VO/Justice_1073",
	function( triggerArgs )
		wait(0.9)
		-- You are to be commended for this, Reader.
		-- PlaySpeech({ Name = "/VO/Justice_788", Queue = "Always" })
		-- You are to be commended for your guidance, Reader.
		PlaySpeech({ Name = "/VO/Justice_1074", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_1074",
	function( triggerArgs )
		wait(0.9)
		-- But only if you can prevail in this Liberation Rite.
		PlaySpeech({ Name = "/VO/Justice_789", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_789",
	function( triggerArgs )
		wait(0.7)
		-- Here, you stand to gain much more than some enlightenment.
		PlaySpeech({ Name = "/VO/Justice_790", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_790",
	function( triggerArgs )
		wait(0.6)
		-- Your adversaries are none other than the Tempers. I trust they need no introduction.
		PlaySpeech({ Name = "/VO/Justice_791", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_791",
	function( triggerArgs )
		wait(0.6)
		-- Soon, one among you shall re-gain their freedom.
		PlaySpeech({ Name = "/VO/Justice_792", Queue = "Always" })
	end
}

-- **week 9 / first open structure match intro follow-up**
OnSoundComplete{ "/VO/Justice_807",
	function( triggerArgs )
		wait(0.8)
		-- Well, then, rejoice! Because the cycle of the Rites begins anew!
		PlaySpeech({ Name = "/VO/Justice_808", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_808",
	function( triggerArgs )
		wait(0.8)
		if LastAscendedCharacter.RosterStatus == "Ascended" then
			-- Perhaps you'll liberate another soon enough.
			PlaySpeech({ Name = "/VO/Justice_809", Queue = "Always" })
		else
			-- Perhaps you shall find more success this time.
			PlaySpeech({ Name = "/VO/Justice_810", Queue = "Always" })
		end
	end
}

OnSoundComplete{ "/VO/Justice_809 /VO/Justice_810",
	function( triggerArgs )
		wait(0.8)
		-- Your chosen adversaries here shall be:
		PlaySpeech({ Name = "/VO/Justice_811", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_811",
	function( triggerArgs )
		wait(0.8)
		if TeamB ~= nil and TeamB.IntroVO ~= nil then
			local cue = TeamB.IntroVO
			PlaySpeech({ Name = cue, Queue = "Always" })
			waitUntil( cue )
			PostMatchIntroVO()
		end
	end
}

function PostMatchIntroVO()
	if specialIntroVO then
		wait(0.8)
		if PlayerTeam.AscensionMatchesPlayed == 1 then
			-- this was using TeamLastMatchResult before but that's not necessarily vs. the player
			if NextTeam["TeamLastMatchMemory"] == "BigLoss" or NextTeam["TeamLastMatchMemory"] == "SolidLoss" or NextTeam["TeamLastMatchMemory"] == "CloseLoss" then
				-- Reduce their flame to ash, just as you did when last you met.
				PlaySpeech({ Name = "/VO/Justice_812", Queue = "Always" })
			else
				-- Reduce their flame to ash, this time, lest they shame you once again!
				PlaySpeech({ Name = "/VO/Justice_813", Queue = "Always" })
			end
		elseif PlayerTeam.AscensionMatchesPlayed == 2 then
			-- Put out their flame, and walk the path to Liberty!
			PlaySpeech({ Name = "/VO/Justice_841", Queue = "Always" })
		end
	else
		-- Match Intro: Objective
		wait(0.85)
		-- Standard Objective
		if not ascensionMatch then
			PlayRemainingSpeech( SpeechSet.MatchObjective )
		-- Ascension Match Objective
		else
			-- Prevail here tonight, and one amongst you shall be free again!
			PlaySpeech({ Name = "/VO/Match_137", Queue = "Always" })
			--[[
			local chosenCharacter = GetCharByRef( chosenCharacterRef )
			if chosenCharacter ~= nil then
				-- female ascension subject
				if chosenCharacter.Gender == "female" then
					PlaySpeech({ Name = "/VO/Match_72" })
				else
				-- male ascension subject
					PlaySpeech({ Name = "/VO/Match_73" })
				end
			end
			]]--
		end
	end
end

OnSoundComplete{ "/VO/Justice_812 /VO/Justice_813",
	function( triggerArgs )
		wait(0.8)
		-- Now, who exactly shall oppose them?
		PlaySpeech({ Name = "/VO/Justice_814", Queue = "Always" })
	end
}

-- **open structure: matchsitej / isle of khaylmer follow-up**
OnSoundComplete{ "/VO/Justice_906",
	function( triggerArgs )
		wait(0.8)
		-- The Eight Scribes dragged you all the way unto the blasphemous Isle of Khaylmer.
		PlaySpeech({ Name = "/VO/Justice_907", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_907",
	function( triggerArgs )
		wait(0.8)
		-- Here you are to be surrounded by even more gibbering nitwits than usual.
		PlaySpeech({ Name = "/VO/Justice_908", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_908",
	function( triggerArgs )
		wait(0.4)
		PreparingToIntroduceRivalVO()
	end
}

-- **open structure: difficulty modifiers match intro follow-up**
OnSoundComplete{ "/VO/Justice_815",
	function( triggerArgs )
		wait(0.8)
		-- The Scribes snuffed out those stars themselves!
		PlaySpeech({ Name = "/VO/Justice_816", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_816",
	function( triggerArgs )
		wait(0.8)
		-- Now the Titan-Stars return again to the night, and these proceedings.
		PlaySpeech({ Name = "/VO/Justice_817", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_817",
	function( triggerArgs )
		wait(0.8)
		-- But let us focus on your adversaries now.
		PlaySpeech({ Name = "/VO/Justice_818", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_818",
	function( triggerArgs )
		wait(0.8)
		-- Put out their Pyre, if your worth be true!
		PlaySpeech({ Name = "/VO/Justice_819", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_819",
	function( triggerArgs )
		wait(0.8)
		-- Prepare now for the glory of the Rites!
		PlaySpeech({ Name = "/VO/Justice_820", Queue = "Always" })
	end
}

-- **open structure: alternate difficulty modifiers match intro follow-up**
OnSoundComplete{ "/VO/Justice_1022",
	function( triggerArgs )
		wait(0.9)
		-- burning remnants of monstrosities felled by the Scribes themselves...
		PlaySpeech({ Name = "/VO/Justice_1023", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_1023",
	function( triggerArgs )
		wait(0.8)
		if IsAnyConstellationActive() then
			-- ...dare you to stand against them in their fury?
			PlaySpeech({ Name = "/VO/Justice_1024", Queue = "Always" })
		else
			-- ...who could stand against them in their fury?
			PlaySpeech({ Name = "/VO/Justice_1026", Queue = "Always" })
		end
	end
}

OnSoundComplete{ "/VO/Justice_1024",
	function( triggerArgs )
		wait(1.1)
		-- Dark is the knowledge that you seek, there, Reader.
		PlaySpeech({ Name = "/VO/Justice_1025", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_1026",
	function( triggerArgs )
		wait(1.1)
		-- You are wise to have resisted their seductions, Reader.
		PlaySpeech({ Name = "/VO/Justice_1027", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_1025 /VO/Justice_1027",
	function( triggerArgs )
		wait(1.25)
		-- Best focus on your adversaries, keen as they are to confront you once again.
		PlaySpeech({ Name = "/VO/Justice_1028", Queue = "Always" })
	end
}


OnSoundComplete{ "/VO/Justice_1028",
	function( triggerArgs )
		wait(0.8)
		-- Put out their Pyre first, and show to them the glory of the Nightwings!
		PlaySpeech({ Name = "/VO/Justice_738", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_738",
	function( triggerArgs )
		wait(0.8)
		-- Now then, make ready for the Rite.
		PlaySpeech({ Name = "/VO/Justice_739", Queue = "Always" })
	end
}

-- **open structure: second Ascension intro follow-up**
OnSoundComplete{ "/VO/Justice_821",
	function( triggerArgs )
		wait(0.8)
		-- At stake this night is freedom, and prosperity!
		PlaySpeech({ Name = "/VO/Justice_822", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_822",
	function( triggerArgs )
		wait(0.8)
		-- But only for one exile who prevails in this Liberation Rite.
		PlaySpeech({ Name = "/VO/Justice_823", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_823",
	function( triggerArgs )
		wait(0.8)
		-- Your many adversaries all did strive to earn this opportunity.
		PlaySpeech({ Name = "/VO/Justice_824", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_824",
	function( triggerArgs )
		wait(0.8)
		if NextTeam.LeagueIndex == 2 then
			-- Twas the Accusers which earned it.
			PlaySpeech({ Name = "/VO/Justice_825", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 3 then
			-- Twas the Fate which earned it.
			PlaySpeech({ Name = "/VO/Justice_826", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 4 then
			-- Twas the Dissidents which earned it.
			PlaySpeech({ Name = "/VO/Justice_827", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 5 then
			-- Twas the Withdrawn which earned it.
			PlaySpeech({ Name = "/VO/Justice_828", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 6 then
			-- Twas the Pyrehearts which earned it.
			PlaySpeech({ Name = "/VO/Justice_829", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 7 then
			-- Twas the Essence which earned it.
			PlaySpeech({ Name = "/VO/Justice_830", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 8 then
			-- Twas the Chastity which earned it.
			PlaySpeech({ Name = "/VO/Justice_831", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 9 then
			-- Twas the Tempers which earned it.
			PlaySpeech({ Name = "/VO/Justice_832", Queue = "Always" })
		end
	end
}

OnSoundComplete{ "/VO/Justice_825 /VO/Justice_826 /VO/Justice_827 /VO/Justice_828 /VO/Justice_829 /VO/Justice_830 /VO/Justice_831 /VO/Justice_832",
	function( triggerArgs )
		wait(0.8)
		-- Who shall be absolved is up to all of you.
		PlaySpeech({ Name = "/VO/Justice_833", Queue = "Always" })
	end
}

-- **open structure: bertrude takes the field intro follow-up**
OnSoundComplete{ "/VO/Justice_834",
	function( triggerArgs )
		wait(0.8)
		if Coach.Gender == "Char_Gender_Female" then
			-- And it would appear her ranks grow stronger.
			PlaySpeech({ Name = "/VO/Justice_835", Queue = "Always" })
		elseif Coach.Gender == "Char_Gender_Male" then
			-- And it would appear his ranks grow stronger.
			PlaySpeech({ Name = "/VO/Justice_836", Queue = "Always" })
		else
			-- And it would appear their ranks grow stronger.
			PlaySpeech({ Name = "/VO/Justice_837", Queue = "Always" })
		end
	end
}

OnSoundComplete{ "/VO/Justice_835 /VO/Justice_836 /VO/Justice_837",
	function( triggerArgs )
		wait(0.8)
		-- Consorting with the bog-crone Bertrude, are we?
		PlaySpeech({ Name = "/VO/Justice_838", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_838",
	function( triggerArgs )
		wait(0.8)
		-- How very strange that you befriended her.
		PlaySpeech({ Name = "/VO/Justice_839", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_839",
	function( triggerArgs )
		wait(0.8)
		-- At any rate, your adversaries in this Rite shall be:
		PlaySpeech({ Name = "/VO/Justice_840", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_840",
	function( triggerArgs )
		wait(0.8)
		if TeamB ~= nil and TeamB.IntroVO ~= nil then
			local cue = TeamB.IntroVO
			PlaySpeech({ Name = cue, Queue = "Always" })
			waitUntil( cue )
			PostMatchIntroVO()
		end
	end
}



-- **bertrude tutorial follow-up**
OnSoundComplete{ "/VO/Justice_967",
	function( triggerArgs )
		wait(0.9)
		-- Though, I have to wonder what became of her accomplices.
		PlaySpeechOnce({ Name = "/VO/Justice_968" })
	end
}

OnSoundComplete{ "/VO/Justice_968",
	function( triggerArgs )
		wait(0.9)
		-- Of one accomplice in particular...
		PlaySpeechOnce({ Name = "/VO/Justice_969" })
	end
}

OnSoundComplete{ "/VO/Justice_969",
	function( triggerArgs )
		wait(0.9)
		-- You watch yourself around her, Reader. None are sentenced into exile without sufficient cause!
		PlaySpeechOnce({ Name = "/VO/Justice_970" })
	end
}

-- **open structure: true nightwings first appearance intro follow-up**
OnSoundComplete{ "/VO/Justice_842",
	function( triggerArgs )
		wait(0.8)
		-- Twould appear the Nightwings are to stand against themselves this time around.
		PlaySpeech({ Name = "/VO/Justice_843", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_843",
	function( triggerArgs )
		wait(0.8)
		-- This is a mutiny! In violation of the sacred law!
		PlaySpeech({ Name = "/VO/Justice_844", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_844",
	function( triggerArgs )
		wait(0.8)
		-- The exile whom you face? Oralech! Long ago, he had his chance, and he relinquished it!
		PlaySpeech({ Name = "/VO/Justice_845", Queue = "Always" })
		-- The exile whom you face? Long ago, he had his chance, and he relinquished it!
		-- PlaySpeech({ Name = "/VO/Justice_846", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_845 /VO/Justice_846",
	function( triggerArgs )
		wait(0.8)
		-- He cannot simply claim it now!
		PlaySpeech({ Name = "/VO/Justice_847", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_847",
	function( triggerArgs )
		wait(0.8)
		-- And I cannot preside over this nonsense!
		PlaySpeech({ Name = "/VO/Justice_848", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_848",
	function( triggerArgs )
		wait(0.6)
		-- Good night!
		PlaySpeech({ Name = "/VO/Justice_849", Queue = "Always" })
	end
}

-- **open structure: third Ascension match intro follow-up**
OnSoundComplete{ "/VO/Justice_850",
	function( triggerArgs )
		wait(0.8)
		-- It would appear the Rites are drawing to a close!
		PlaySpeech({ Name = "/VO/Justice_851", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_851",
	function( triggerArgs )
		wait(0.8)
		-- Doubtless the doing of that Oralech, in all his bitter spite.
		PlaySpeech({ Name = "/VO/Justice_852", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_852",
	function( triggerArgs )
		wait(1.1)
		-- For now, your exiles have another chance at freedom, here, upon the Fall of Soliam.
		PlaySpeech({ Name = "/VO/Justice_853", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_853",
	function( triggerArgs )
		wait(0.8)
		if NextTeam.LeagueIndex == 2 then
			-- So, too, do your adversaries, the Accusers!
			PlaySpeech({ Name = "/VO/Justice_854", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 3 then
			-- So, too, do the Fate, your adversaries!
			PlaySpeech({ Name = "/VO/Justice_855", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 4 then
			-- So, too, do the Dissidents, your adversaries!
			PlaySpeech({ Name = "/VO/Justice_856", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 5 then
			-- So, too, do your adversaries, the Withdrawn!
			PlaySpeech({ Name = "/VO/Justice_857", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 6 then
			-- So, too, do the Pyrehearts, your adversaries!
			PlaySpeech({ Name = "/VO/Justice_858", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 7 then
			-- So, too, do your adversaries, the Essence!
			PlaySpeech({ Name = "/VO/Justice_859", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 8 then
			-- So, too, do the Chastity, your adversaries!
			PlaySpeech({ Name = "/VO/Justice_860", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 9 then
			-- So, too, do your adversaries, the Tempers!
			PlaySpeech({ Name = "/VO/Justice_861", Queue = "Always" })
		end
	end
}

OnSoundComplete{ "/VO/Justice_854 /VO/Justice_855 /VO/Justice_856 /VO/Justice_857 /VO/Justice_858 /VO/Justice_859 /VO/Justice_860 /VO/Justice_861",
	function( triggerArgs )
		wait(0.8)
		-- They fought so very bravely for this moment.
		PlaySpeech({ Name = "/VO/Justice_862", Queue = "Always" })
	end
}


OnSoundComplete{ "/VO/Justice_862",
	function( triggerArgs )
		wait(0.8)
		-- Whichever side prevails soon shall send one of its own into the warm embrace of civilization.
		PlaySpeech({ Name = "/VO/Justice_863", Queue = "Always" })
	end
}

-- **open structure: volfred takes the field intro follow-up**
OnSoundComplete{ "/VO/Justice_864",
	function( triggerArgs )
		wait(0.8)
		-- For, I detect another exile in your ranks!
		PlaySpeech({ Name = "/VO/Justice_865", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_865",
	function( triggerArgs )
		wait(0.8)
		-- The exile Volfred Sandlewood, himself! That cursed Sap!
		PlaySpeech({ Name = "/VO/Justice_866", Queue = "Always" })
		-- The exile Volfred Sandlewood, himself!
		-- PlaySpeech({ Name = "/VO/Justice_867", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_866 /VO/Justice_867",
	function( triggerArgs )
		wait(0.8)
		-- I ought have known he was behind all this.
		PlaySpeech({ Name = "/VO/Justice_868", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_868",
	function( triggerArgs )
		wait(0.8)
		-- He has no love for our sacred tradition.
		PlaySpeech({ Name = "/VO/Justice_869", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_869",
	function( triggerArgs )
		wait(0.8)
		-- Yet you would heed his poisoned words over mine own?!
		PlaySpeech({ Name = "/VO/Justice_870", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_870",
	function( triggerArgs )
		wait(1.15)
		-- I thought that we were friends.
		PlaySpeech({ Name = "/VO/Justice_871", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_871",
	function( triggerArgs )
		wait(0.8)
		-- Then, fine. Let us return to a more-formal distance.
		PlaySpeech({ Name = "/VO/Justice_872", Queue = "Always" })
	end
}

-- **volfred tutorial follow-up**
OnSoundComplete{ "/VO/Justice_971",
	function( triggerArgs )
		wait(0.9)
		-- I know that you can hear me, Sandlewood.
		PlaySpeechOnce({ Name = "/VO/Justice_972" })
	end
}

OnSoundComplete{ "/VO/Justice_972",
	function( triggerArgs )
		wait(0.8)
		-- You're causing quite a stir out in the Commonwealth.
		PlaySpeechOnce({ Name = "/VO/Justice_973" })
	end
}

OnSoundComplete{ "/VO/Justice_973",
	function( triggerArgs )
		wait(0.8)
		-- You plant your little seeds of discontent?
		PlaySpeechOnce({ Name = "/VO/Justice_974" })
	end
}

OnSoundComplete{ "/VO/Justice_974",
	function( triggerArgs )
		wait(0.8)
		-- Know that your designs at sowing chaos shall not be tolerated here.
		PlaySpeechOnce({ Name = "/VO/Justice_975" })
	end
}

OnSoundComplete{ "/VO/Justice_975",
	function( triggerArgs )
		wait(0.9)
		-- Now, good evening to you!
		PlaySpeechOnce({ Name = "/VO/Justice_976" })
	end
}

-- **open structure: fourth Ascension match intro follow-up**
OnSoundComplete{ "/VO/Justice_873",
	function( triggerArgs )
		wait(0.8)
		-- Even as the stars themselves abandon you.
		PlaySpeech({ Name = "/VO/Justice_874", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_874",
	function( triggerArgs )
		wait(0.8)
		-- Make good upon these final opportunities, Reader.
		PlaySpeech({ Name = "/VO/Justice_875", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_875",
	function( triggerArgs )
		wait(0.8)
		-- This glorious, age-old tradition, coming to an end upon your watch.
		PlaySpeech({ Name = "/VO/Justice_876", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_876",
	function( triggerArgs )
		wait(0.8)
		if NextTeam.LeagueIndex == 2 then
			-- I trust your adversaries, the Accusers, shall not throw away this chance.
			PlaySpeech({ Name = "/VO/Justice_877", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 3 then
			-- I trust the Fate, your adversaries, shall not throw away this chance.
			PlaySpeech({ Name = "/VO/Justice_878", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 4 then
			-- I trust the Dissidents, your adversaries, shall not throw away this chance.
			PlaySpeech({ Name = "/VO/Justice_879", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 5 then
			-- I trust your adversaries, the Withdrawn, shall not throw away this chance.
			PlaySpeech({ Name = "/VO/Justice_880", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 6 then
			-- I trust the Pyrehearts, your adversaries, shall not throw away this chance.
			PlaySpeech({ Name = "/VO/Justice_881", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 7 then
			-- I trust your adversaries, the Essence, shall not throw away this chance.
			PlaySpeech({ Name = "/VO/Justice_882", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 8 then
			-- I trust the Chastity, your adversaries, shall not throw away this chance.
			PlaySpeech({ Name = "/VO/Justice_883", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 9 then
			-- I trust your adversaries, the Tempers, shall not throw away this chance.
			PlaySpeech({ Name = "/VO/Justice_884", Queue = "Always" })
		end
	end
}

OnSoundComplete{ "/VO/Justice_877 /VO/Justice_878 /VO/Justice_879 /VO/Justice_880 /VO/Justice_881 /VO/Justice_882 /VO/Justice_883 /VO/Justice_884",
	function( triggerArgs )
		wait(0.8)
		-- Choose now who may go free, should they unfortunately fail.
		PlaySpeech({ Name = "/VO/Justice_885", Queue = "Always" })
	end
}

-- **season 5 first match follow-up**
OnSoundComplete{ "/VO/Justice_886",
	function( triggerArgs )
		wait(0.8)
		-- if you've managed to ascend someone
		if GetNumAscendedCharacters( PlayerTeam ) ~= 0 then
			if Coach.Gender == "Char_Gender_Female" then
				-- Along with her remaining retinue of miscreants.
				PlaySpeech({ Name = "/VO/Justice_888", Queue = "Always" })
			elseif Coach.Gender == "Char_Gender_Male" then
				-- Along with his remaining retinue of miscreants.
				PlaySpeech({ Name = "/VO/Justice_887", Queue = "Always" })
			else
				-- Along with their remaining retinue of miscreants.
				PlaySpeech({ Name = "/VO/Justice_889", Queue = "Always" })
			end
		else
			if Coach.Gender == "Char_Gender_Female" then
				-- Along with her entire retinue of miscreants.
				PlaySpeech({ Name = "/VO/Justice_891", Queue = "Always" })
			elseif Coach.Gender == "Char_Gender_Male" then
				-- Along with his entire retinue of miscreants.
				PlaySpeech({ Name = "/VO/Justice_890", Queue = "Always" })
			else
				-- Along with their entire retinue of miscreants.
				PlaySpeech({ Name = "/VO/Justice_892", Queue = "Always" })
			end
		end
	end
}

OnSoundComplete{ "/VO/Justice_888 /VO/Justice_887 /VO/Justice_889 /VO/Justice_890 /VO/Justice_891 /VO/Justice_892",
	function( triggerArgs )
		wait(0.8)
		if LastAscendedCharacter.RosterStatus == "Ascended" then
			-- You managed recently to rid yourself of yet another one.
			PlaySpeech({ Name = "/VO/Justice_893", Queue = "Always" })
		else
			if GetNumAscendedCharacters( PlayerTeam ) == 0 then
				-- How unfortunate that each of your attempts to liberate them failed.
				PlaySpeech({ Name = "/VO/Justice_894", Queue = "Always" })
			else
				-- Too bad you failed to rid yourself of yet another one last time.
				PlaySpeech({ Name = "/VO/Justice_895", Queue = "Always" })
			end
		end
	end
}

OnSoundComplete{ "/VO/Justice_893 /VO/Justice_894 /VO/Justice_895",
	function( triggerArgs )
		wait(0.8)
		if NextTeam.LeagueIndex == 2 then
			-- Your adversaries, the Accusers...
			PlaySpeech({ Name = "/VO/Justice_896", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 3 then
			-- Your adversaries, the Fate...
			PlaySpeech({ Name = "/VO/Justice_897", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 4 then
			-- Your adversaries, the Dissidents...
			PlaySpeech({ Name = "/VO/Justice_898", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 5 then
			-- Your adversaries, the Withdrawn...
			PlaySpeech({ Name = "/VO/Justice_899", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 6 then
			-- Your adversaries, the Pyrehearts...
			PlaySpeech({ Name = "/VO/Justice_900", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 7 then
			-- Your adversaries, the Essence...
			PlaySpeech({ Name = "/VO/Justice_901", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 8 then
			-- Your adversaries, the Chastity...
			PlaySpeech({ Name = "/VO/Justice_902", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 9 then
			-- Your adversaries, the Tempers...
			PlaySpeech({ Name = "/VO/Justice_903", Queue = "Always" })
		end
	end
}

OnSoundComplete{ "/VO/Justice_896 /VO/Justice_897 /VO/Justice_898 /VO/Justice_899 /VO/Justice_900 /VO/Justice_901 /VO/Justice_902 /VO/Justice_903",
	function( triggerArgs )
		wait(0.8)
		-- ...as with you, they must be very desperate for their freedom.
		PlaySpeech({ Name = "/VO/Justice_904", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_904",
	function( triggerArgs )
		wait(0.9)
		-- They shall not make it any easier from here.
		PlaySpeech({ Name = "/VO/Justice_905", Queue = "Always" })
	end
}

-- **late-game match follow-up**
-- Reader? I am still very cross with you, you know.
OnSoundComplete{ "/VO/Justice_958",
	function( triggerArgs )
		wait(1.1)
		-- To think I saw in you a worthy heir.
		PlaySpeech({ Name = "/VO/Justice_959", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_959",
	function( triggerArgs )
		wait(0.8)
		-- Not just to the legacy of the Nightwings...
		PlaySpeech({ Name = "/VO/Justice_960", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_960",
	function( triggerArgs )
		wait(0.8)
		-- But to the future of the Commonwealth!
		PlaySpeech({ Name = "/VO/Justice_961", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_961",
	function( triggerArgs )
		wait(0.9)
		-- That traitor Volfred... only a fool would be seduced by his audacious promises.
		PlaySpeech({ Name = "/VO/Justice_962", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_962",
	function( triggerArgs )
		wait(0.5)
		-- And his dangerous ideas.
		PlaySpeech({ Name = "/VO/Justice_963", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_963",
	function( triggerArgs )
		wait(0.9)
		-- That, dear Reader, would make you a fool.
		PlaySpeech({ Name = "/VO/Justice_964", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_964",
	function( triggerArgs )
		wait(0.8)
		-- I have no choice but to explain it thus, so even you could understand.
		PlaySpeech({ Name = "/VO/Justice_965", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_965",
	function( triggerArgs )
		wait(0.8)
		-- Now for this blasted Rite. Some of us still have our duties to uphold.
		PlaySpeech({ Name = "/VO/Justice_966", Queue = "Always" })
	end
}

-- **open structure: fifth Ascension match intro follow-up**
OnSoundComplete{ "/VO/Justice_909",
	function( triggerArgs )
		wait(0.8)
		-- Twas here that the Eight Scribes ordained the glorious tradition in which you now participate.
		PlaySpeech({ Name = "/VO/Justice_910", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_910",
	function( triggerArgs )
		wait(0.8)
		-- The glorious tradition which you, and that instigator, Volfred, seek to undermine.
		PlaySpeech({ Name = "/VO/Justice_911", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_911",
	function( triggerArgs )
		wait(0.8)
		-- Tis my sincerest hope your adversaries in this Liberation Rite achieve instead what they desire.
		PlaySpeech({ Name = "/VO/Justice_912", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_912",
	function( triggerArgs )
		wait(0.8)
		if NextTeam.LeagueIndex == 2 then
			-- May the Accusers quickly quench those flames of yours.
			PlaySpeech({ Name = "/VO/Justice_913", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 3 then
			-- May the Fate soon quench those flames of yours.
			PlaySpeech({ Name = "/VO/Justice_914", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 4 then
			-- May the Dissidents soon douse those flames of yours.
			PlaySpeech({ Name = "/VO/Justice_915", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 5 then
			-- May the Withdrawn quickly put out your Pyre.
			PlaySpeech({ Name = "/VO/Justice_916", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 6 then
			-- May the Pyrehearts soon douse those flames of yours.
			PlaySpeech({ Name = "/VO/Justice_917", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 7 then
			-- May the Essence quickly quench those flames of yours.
			PlaySpeech({ Name = "/VO/Justice_918", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 8 then
			-- May the Chastity soon douse those flames of yours.
			PlaySpeech({ Name = "/VO/Justice_919", Queue = "Always" })
		elseif NextTeam.LeagueIndex == 9 then
			-- May the Tempers soon put out those flames of yours.
			PlaySpeech({ Name = "/VO/Justice_920", Queue = "Always" })
		end
	end
}

OnSoundComplete{ "/VO/Justice_913 /VO/Justice_914 /VO/Justice_915 /VO/Justice_916 /VO/Justice_917 /VO/Justice_918 /VO/Justice_919 /VO/Justice_920",
	function( triggerArgs )
		wait(0.9)
		-- Let us get on with the proceedings, then.
		PlaySpeech({ Name = "/VO/Justice_921", Queue = "Always" })
	end
}

-- **season 6 first match follow-up**
-- Reader. It seems the stars once more have mustered wherewithal to usher in the Rites.
OnSoundComplete{ "/VO/Justice_922",
	function( triggerArgs )
		wait(0.9)
		-- The sky grows dimmer by the day. An age is ending.
		PlaySpeech({ Name = "/VO/Justice_923", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_923",
	function( triggerArgs )
		wait(0.8)
		-- Surely you must know by now that you shall never all be free?
		PlaySpeech({ Name = "/VO/Justice_924", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_924",
	function( triggerArgs )
		wait(0.8)
		-- Yet still you struggle to fulfill some senseless Plan?
		PlaySpeech({ Name = "/VO/Justice_925", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_925",
	function( triggerArgs )
		wait(0.8)
		-- But I digress, of course. Some of us still honor the tradition.
		PlaySpeech({ Name = "/VO/Justice_926", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_926",
	function( triggerArgs )
		wait(0.8)
		-- Some of us hold dear the teachings of the Scribes.
		PlaySpeech({ Name = "/VO/Justice_927", Queue = "Always" })
	end
}

-- **open structure: sixth Ascension match intro follow-up**
-- Reader, I would ask that you think back for just a moment, if you please.
OnSoundComplete{ "/VO/Justice_928",
	function( triggerArgs )
		wait(0.8)
		-- When you first looked upon the Book of Rites. Think back upon the words that it revealed.
		PlaySpeech({ Name = "/VO/Justice_929", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_929",
	function( triggerArgs )
		wait(0.8)
		-- Oblige the voice that tells you more.
		PlaySpeech({ Name = "/VO/Justice_930", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_930",
	function( triggerArgs )
		wait(0.8)
		-- Oblige the voice that tells you more!
		PlaySpeech({ Name = "/VO/Justice_931", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_931",
	function( triggerArgs )
		wait(0.8)
		-- Would that the Scribes were here among us still.
		PlaySpeech({ Name = "/VO/Justice_932", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_932",
	function( triggerArgs )
		wait(0.8)
		-- I would not sing your praises to them, rest assured.
		PlaySpeech({ Name = "/VO/Justice_933", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_933",
	function( triggerArgs )
		wait(1.0)
		-- I trust that you shall savor this occasion.
		PlaySpeech({ Name = "/VO/Justice_934", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_934",
	function( triggerArgs )
		wait(1.0)
		-- I trust that you shall savor this occasion.
		PlaySpeech({ Name = "/VO/Justice_935", Queue = "Always" })
	end
}

-- **season 7 first match follow-up**
-- Reader. The Commonwealth... your home...
OnSoundComplete{ "/VO/Justice_936",
	function( triggerArgs )
		wait(0.9)
		-- Today it is aflame. Much like a stack of books.
		PlaySpeech({ Name = "/VO/Justice_937", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_937",
	function( triggerArgs )
		wait(0.9)
		-- Aflame, because of you.
		PlaySpeech({ Name = "/VO/Justice_938", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_938",
	function( triggerArgs )
		wait(0.9)
		-- Because of your outlandish Plan.
		PlaySpeech({ Name = "/VO/Justice_939", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_939",
	function( triggerArgs )
		wait(0.9)
		-- Not that you care. Not that you shall live to see this place again.
		PlaySpeech({ Name = "/VO/Justice_940", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_940",
	function( triggerArgs )
		wait(1.0)
		-- Your attempts at revolution shan't succeed.
		PlaySpeech({ Name = "/VO/Justice_941", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_941",
	function( triggerArgs )
		wait(0.8)
		-- Though, by all means, keep trying.
		PlaySpeech({ Name = "/VO/Justice_942", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_942",
	function( triggerArgs )
		wait(0.9)
		-- As for myself, I shall enjoy presiding over these remaining Rites.
		PlaySpeech({ Name = "/VO/Justice_943", Queue = "Always" })
	end
}

-- **open structure: seventh Ascension match / Final Liberation intro follow-up**
-- Look, for one last time, upon the Fall of Soliam, dear Reader.
OnSoundComplete{ "/VO/Justice_944",
	function( triggerArgs )
		wait(0.9)
		-- Hear me for one last time.
		PlaySpeech({ Name = "/VO/Justice_945", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_945",
	function( triggerArgs )
		wait(0.9)
		-- For, soon, the few remaining stars shall fade away.
		PlaySpeech({ Name = "/VO/Justice_946", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_946",
	function( triggerArgs )
		wait(0.9)
		-- Leaving you stranded there, for your remaining days.
		PlaySpeech({ Name = "/VO/Justice_947", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_947",
	function( triggerArgs )
		wait(0.9)
		-- In that forsaken land. Where you deserve to be.
		PlaySpeech({ Name = "/VO/Justice_948", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_948",
	function( triggerArgs )
		wait(1.15)
		-- The rabble that you roused here in the Commonwealth shall be put down.
		PlaySpeech({ Name = "/VO/Justice_949", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_949",
	function( triggerArgs )
		wait(0.95)
		if GetNumAscendedCharacters( PlayerTeam ) > 2 then
			-- The exiles whom you liberated all shall fall in line.
			PlaySpeech({ Name = "/VO/Justice_950", Queue = "Always" })
		else
			-- Your adversaries who regained their freedom thanks to you shall help us see to it.
			PlaySpeech({ Name = "/VO/Justice_951", Queue = "Always" })
		end
	end
}

OnSoundComplete{ "/VO/Justice_950 /VO/Justice_951",
	function( triggerArgs )
		wait(1.0)
		-- But first, let us get on with this last Liberation Rite.
		PlaySpeech({ Name = "/VO/Justice_952", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_952",
	function( triggerArgs )
		wait(0.8)
		-- You face none other than yourselves.
		PlaySpeech({ Name = "/VO/Justice_953", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_953",
	function( triggerArgs )
		wait(0.8)
		-- Each so unlike the glorious Nightwings of yore.
		PlaySpeech({ Name = "/VO/Justice_954", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_954",
	function( triggerArgs )
		wait(0.9)
		-- Tis a shame that one of you shall soon be free...
		PlaySpeech({ Name = "/VO/Justice_955", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_955",
	function( triggerArgs )
		wait(0.95)
		-- ...for, you deserve each other.
		PlaySpeech({ Name = "/VO/Justice_956", Queue = "Always" })
	end
}


-- **Campaign jump-scare / Archjustice Appearance follow-up**

-- Foolish Reader.
OnSoundComplete{ "/VO/Justice_981",
	function( triggerArgs )
		wait(0.95)
		-- Your so-called friends... you are accomplice to their hateful plot.
		PlaySpeech({ Name = "/VO/Justice_982", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_982",
	function( triggerArgs )
		wait(1.1)
		-- They are exploiting you.
		PlaySpeech({ Name = "/VO/Justice_983", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_983",
	function( triggerArgs )
		wait(1.2)
		-- You shall never have your freedom.
		PlaySpeech({ Name = "/VO/Justice_984", Queue = "Always" })
	end
}


-- Are you out there, O Reader?
OnSoundComplete{ "/VO/Justice_1041",
	function( triggerArgs )
		wait(1.1)
		-- I have made attempts at reaching out to you.
		PlaySpeech({ Name = "/VO/Justice_1042", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_1042",
	function( triggerArgs )
		wait(0.9)
		-- Yet always you rebuke me.
		PlaySpeech({ Name = "/VO/Justice_1043", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_1043",
	function( triggerArgs )
		wait(1.05)
		-- Despite the guidance I have given you.
		PlaySpeech({ Name = "/VO/Justice_1044", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_1044",
	function( triggerArgs )
		wait(1.05)
		-- Despite the kindness I have shown to you.
		PlaySpeech({ Name = "/VO/Justice_1045", Queue = "Always" })
	end
}


-- I do so hate to thusly contact you, O Reader.
OnSoundComplete{ "/VO/Justice_1075",
	function( triggerArgs )
		wait(1.1)
		-- Yet, an awful rumor reached me recently:
		PlaySpeech({ Name = "/VO/Justice_1076", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_1076",
	function( triggerArgs )
		wait(0.9)
		-- That you have within your retinue a traitor.
		PlaySpeech({ Name = "/VO/Justice_1077", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_1077",
	function( triggerArgs )
		wait(1.05)
		-- To the Nightwings, and the Commonwealth alike!
		PlaySpeech({ Name = "/VO/Justice_1078", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_1078",
	function( triggerArgs )
		wait(1.05)
		-- But you would never harbor such a traitor, now, would you?
		PlaySpeech({ Name = "/VO/Justice_1079", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_1079",
	function( triggerArgs )
		wait(1.25)
		-- I trust your time within the Downside would have taught you that.
		PlaySpeech({ Name = "/VO/Justice_1080", Queue = "Always" })
	end
}


-- You are nothing, Reader.
OnSoundComplete{ "/VO/Justice_1046",
	function( triggerArgs )
		wait(1.0)
		if Coach.CoachPast == "Past_Scholar" then
			-- Nothing but a mindless cripple.
			PlaySpeech({ Name = "/VO/Justice_1047", Queue = "Always" })
		elseif Coach.CoachPast == "Past_Farmer" then
			-- Nothing but a mindless farmhand.
			PlaySpeech({ Name = "/VO/Justice_1048", Queue = "Always" })
		elseif Coach.CoachPast == "Past_Orphan" then
			-- Nothing but a mindless child.
			PlaySpeech({ Name = "/VO/Justice_1049", Queue = "Always" })
		else
			-- Nothing but a mindless simpleton.
			PlaySpeech({ Name = "/VO/Justice_1050", Queue = "Always" })
		end
	end
}

OnSoundComplete{ "/VO/Justice_1047 /VO/Justice_1048 /VO/Justice_1049 /VO/Justice_1050",
	function( triggerArgs )
		wait(1.35)
		-- Your every action is a stain upon the legacy of the Eight Scribes.
		PlaySpeech({ Name = "/VO/Justice_1051", Queue = "Always" })
	end
}

OnSoundComplete{ "/VO/Justice_1051",
	function( triggerArgs )
		wait(1.15)
		-- The Rites have been a long-held secret to keep out those such as you.
		PlaySpeech({ Name = "/VO/Justice_1052", Queue = "Always" })
	end
}


-- **STANDARD MATCH INTRO**
-- Match Intro: Player Team Name
OnSoundComplete{ "/VO/Match_2 /VO/Match_3 /VO/Match_4 /VO/Match_5 /VO/Match_115 /VO/Match_116 /VO/Match_117 /VO/Match_118 /VO/Match_119",
	function( triggerArgs )
		if IsMultiplayerMatch() then
			return
		end
		wait(0.25)
		if TeamA ~= nil and TeamA.IntroVO ~= nil then
			local cue = TeamA.IntroVO
			PlaySpeech({ Name = cue, Queue = "Always" })
			waitUntil( cue )
			PostMatchIntroVO()
		else
			-- PlaySpeech({ Name = "/VO/Match_6" })
		end
	end
}

-- Match Intro: Match Location
OnSoundComplete{ "/VO/Match_120",
	function( triggerArgs )
		if NodeData == nil then
			return
		end
		wait(0.65)
		UpdateCurrentNodeData()
		local matchCue = nil
		if currentNodeData ~= nil and currentNodeData.MatchVO ~= nil then
			matchCue = GetRandomRemainingData( currentNodeData.MatchVO )
		elseif GetMapName({ }) == "MatchSiteA" then
			-- The Eight Scribes summon you to the Book of Rites.
			matchCue = "/VO/Match_130"
		else
			-- matchCue = "/VO/Match_7"
		end
		PlaySpeech({ Name = matchCue })
		waitUntil( matchCue )
		PreparingToIntroduceRivalVO()
	end
}

-- Match Intro: Preparing to Introduce Adversary / Rival Team
function PreparingToIntroduceRivalVO()
	wait(0.8)
	PlayRemainingSpeech( SpeechSet.MatchOpponent, nil, "Always" )
end


-- Match Intro: Declaring Adversary
OnSoundComplete{ "/VO/Match_131 /VO/Match_132 /VO/Match_133 /VO/Justice_277",
	function( triggerArgs )
		if IsFirstAccusersMatch() then
			return
		end
		wait(0.35)
		if TeamB ~= nil and TeamB.IntroVO ~= nil then
			local cue = TeamB.IntroVO
			PlaySpeech({ Name = cue, Queue = "Always" })
			waitUntil( cue )
			PostMatchIntroVO()
		else
			PlaySpeech({ Name = "/VO/Match_15", Queue = "Always" })
		end
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			if CoinFlip() then
				PlaySound({ Name = "/SFX/Match SFX/ImpCrowdCheer", Delay = 0.55 })
			else
				PlaySound({ Name = "/SFX/Match SFX/ImpCrowdJeer", Delay = 0.55 })
			end
		end
	end
}

-- Match Intro: Conclusion
OnSoundComplete{ "/VO/Match_134 /VO/Match_135 /VO/Match_136 /VO/Justice_449 /VO/Justice_279 /VO/Match_137",
	function( triggerArgs )
		wait(1.0)
		if matchesPlayed == 0 then
			-- Now let the Rites commence!
			PlaySpeech({ Name = "/VO/Match_18" })
		else
			-- Now, prepare yourselves.
			PlaySpeech({ Name = "/VO/Match_138" })
		end
	end
}

-- **VO for Match Outro**
OnAnyLoad
{
	function( triggerArgs )

		if SpeechSet.LateGameVictoryVO ~= nil then
			return
		end
		SpeechSet.LateGameVictoryVO =
		{
			-- The Nightwings prevail...
			"/VO/Match_198",
			-- The Nightwings... prevail.
			"/VO/Match_199",
			-- The Nightwings managed to prevail.
			"/VO/Match_200",
			-- The blasted Nightwings prevailed, somehow.
			"/VO/Match_201",
			-- Fine, yes, you prevailed, again.
			"/VO/Match_202",
			-- Again the Nightwings have prevailed.
			"/VO/Match_203",
		}
		function MatchOutroAudio( args )
			wait(0.35)
			-- imp crowd
			if GetMapName({ }) == "MatchSiteJ" then
				PlaySound({ Name = "/SFX/Match SFX/ImpCrowdCheer", Delay = 0.3 })
				StopSound({ Name = "/SFX/Match SFX/ImpCrowdChantLoop_1", Duration = 0.3 })
				StopSound({ Name = "/SFX/Match SFX/ImpCrowdChantLoop_2", Duration = 0.3 })
				StopSound({ Name = "/SFX/Match SFX/ImpCrowdChantLoop_3", Duration = 0.3 })
				StopSound({ Name = "/SFX/Match SFX/ImpCrowdChantLoop_4", Duration = 0.3 })
			end
			-- Standard Match Outro
			if not head2head then
				MiscPyreExtinguishedAudio()
			-- Local MP Match Outro
			else
				if CoinFlip() then
					if args == "win" then
						RedTeamPyreExtinguishedAudio()
					else
						BlueTeamPyreExtinguishedAudio()
					end
				else
					MiscPyreExtinguishedAudio()
				end
			end

			-- Campaign Week 1 Match End
			if matchesPlayed == 0 and not IsMultiplayerMatch() then
				wait(3.65)
				if args == "win" then
					-- You have prevailed!
					PlaySpeech({ Name = "/VO/Justice_282", Queue = "Always" })
				elseif args == "lose" then
					-- The Accusers prevail!
					PlaySpeech({ Name = "/VO/Justice_284", Queue = "Always"  })
				end
			else
				wait(3.65)
				if not blockMatchVO then
					local victorySpeechCue = nil
					local needsPlay = true
					if args == "win" then
						-- Ascension Victory VO
						if ascensionMatch then
							wait(0.65)
							if PlayerTeam.AscensionMatchesPlayed == 5 then
								-- The Nightwings... proved their worth.
								victorySpeechCue = "/VO/Match_557"
							elseif PlayerTeam.AscensionMatchesPlayed == 6 then
								-- The blasted Nightwings proved their worth.
								victorySpeechCue = "/VO/Match_558"
							elseif PlayerTeam.AscensionMatchesPlayed == 7 then
								-- The... rrnnggh, Nightwings proved their worth.
								victorySpeechCue = "/VO/Match_559"
							else
								-- The Nightwings proved their worth.
								if TeamA ~= nil and TeamA.AscensionVictoryVO ~= nil then
									victorySpeechCue = TeamA.AscensionVictoryVO
								end
							end
						-- Forfeit Victory VO
						elseif forfeitMatch then
							-- The Nightwings prevail... by default.
							victorySpeechCue = "/VO/Justice_979"
						-- Win Streak VO
						elseif TeamA ~= nil and TeamA.SuccessiveWins == 2 and not IsMultiplayerMatch() then
							-- The Nightwings prevail, again!
							victorySpeechCue = "/VO/Match_549"
						elseif TeamA ~= nil and TeamA.SuccessiveWins == 4 and not IsMultiplayerMatch() then
							-- The Nightwings prevail, yet again!
							victorySpeechCue = "/VO/Match_550"
						elseif TeamA ~= nil and TeamA.SuccessiveWins == 6 and not IsMultiplayerMatch() then
							-- The Nightwings once again prevail?!
							victorySpeechCue = "/VO/Match_551"
						elseif TeamA ~= nil and TeamA.SuccessiveWins == 8 and not IsMultiplayerMatch() then
							-- The you-know-who prevail.
							victorySpeechCue = "/VO/Match_552"
						elseif TeamA ~= nil and TeamA.SuccessiveWins == 10 and not IsMultiplayerMatch() then
							-- Fine, yes, the Nightwings did prevail.
							victorySpeechCue = "/VO/Match_553"
						-- late-game match victory
						elseif PlayerTeam.AscensionMatchesPlayed > 2 and not IsMultiplayerMatch() then
							victorySpeechCue = PlayNextRemainingSpeech( SpeechSet.LateGameVictoryVO )
							needsPlay = false
						-- standard match victory
						else
							-- The Nightwings prevail!
							if TeamA ~= nil and TeamA.VictoryVO ~= nil then
								victorySpeechCue = TeamA.VictoryVO
							end
						end
						if needsPlay then
							PlaySpeech({ Name = victorySpeechCue, Queue = "Always"  })
						end
						waitUntil( victorySpeechCue )
						PostVictoryVOQualityOfVictory()
					elseif args == "lose" then
						if ascensionMatch then
							wait(0.65)
							if TeamB ~= nil and TeamB.AscensionVictoryVO ~= nil then
								victorySpeechCue = TeamB.AscensionVictoryVO
							end
						else
							if TeamB ~= nil and TeamB.VictoryVO ~= nil then
								victorySpeechCue = TeamB.VictoryVO
							end
						end
						if needsPlay then
							PlaySpeech({ Name = victorySpeechCue, Queue = "Always"  })
						end
						waitUntil( victorySpeechCue )
						PostVictoryVOQualityOfVictory()
					else
						MatchEndAudio()
					end
				end
			end
		end

	end
}

-- post-victory VO: quality of victory
function PostVictoryVOQualityOfVictory()
	waitScreenTime(0.95)
	if forfeitMatch then
		return
	end
	-- standard set
	if ascensionMatch or RandomChance( 0.5 ) or PlayerTeam.AscensionMatchesPlayed <= 1 then
		local winningTeam = GetWinningTeam()
		if winningTeam.PyreHealth >= 70 then
			thread( MatchOutcomeBigWinAudio )
		elseif winningTeam.PyreHealth >= 30 then
			thread( MatchOutcomeSolidWinAudio )
		else
			thread( MatchOutcomeCloseWinAudio )
		end
		return
	end
	-- late-game season match set
	if PlayerTeam.PyreHealth > 0 then
		thread( MatchOutcomeLateGameWinAudio )
	else
		thread( MatchOutcomeLateGameLossAudio )
	end
end

-- post-victory VO: forfeit match
OnSoundComplete{ "/VO/Justice_979",
	function( triggerArgs )
		waitScreenTime(1.0)
		-- Not that their adversaries even care.
		PlaySpeech({ Name = "/VO/Justice_980", Queue = "Always" })
	end
}

-- post-post-victory VO: closing thoughts
function PostVictoryVOClosingThoughts()
	waitScreenTime(0.7)
	if IsMultiplayerMatch() then
		thread( MatchEndAudio )
	else
		-- standard matches
		if not ascensionMatch then
			wait(0.9)
			if lastMatchResult == "Win" and not SpeechRecord["/VO/Match_293"] then
				-- Perhaps you shan't be quite so fortunate next time.
				PlaySpeechOnce({ Name = "/VO/Match_293" })
			elseif lastMatchResult == "Loss" and not SpeechRecord["/VO/Match_294"] then
				-- Perhaps your fortune shall be better next time, hm?
				PlaySpeechOnce({ Name = "/VO/Match_294" })
			else
				thread( MatchEndAudio )
				-- The Rite is complete.
				-- PlaySpeech({ Name = "/VO/Justice_34", Queue = "Always" })
				-- I bid you all farewell for now.
				-- PlaySpeech({ Name = "/VO/Justice_496", Queue = "Always" })
			end
		-- ascension matches
		else
			-- handled in AscensionSuccessAudio() / AscensionFailureAudio()
		end
	end
end

-- **standard match conclusion follow-up**
OnSoundComplete{ "/VO/Justice_494 /VO/Justice_495",
	function( triggerArgs )
		if IsMultiplayerMatch() then
			wait(1.2)
			-- I bid you all farewell for now.
			PlaySpeech({ Name = "/VO/Justice_496", Queue = "Always" })
		end
	end
}

function LocalMPMatchSendOffAudio()
	if IsMultiplayerMatch() then
		thread( MatchSendOffAudio, 1 )
		StopSound({ Name = "/Ambience/StarPickerAmbienceLoop", Duration = 3.0 })
		-- PlaySound({ Name = "/Music/Stingers/MatchOver1" })
	end
end

OnSoundComplete{ "/VO/Justice_496",
	function( triggerArgs )
		LocalMPMatchSendOffAudio()
	end
}

-- **week 1 match outro followup**
OnSoundComplete{ "/VO/Justice_282",
	function( triggerArgs )
		waitScreenTime(0.7)
		if matchesPlayed <= 1 and GetMapName({ }) == "MatchSiteB" and not IsMultiplayerMatch() then
			-- Rejoice then in your single fleeting victory.
			PlaySpeech({ Name = "/VO/Justice_450" })
		end
	end
}

OnSoundComplete{ "/VO/Justice_284",
	function( triggerArgs )
		waitScreenTime(0.65)
		-- And as for you, you've the remainder of your lives to gain more competence.
		PlaySpeech({ Name = "/VO/Justice_285" })
	end
}

function AscensionEndedAudio()
	if PlayerTeam.AscensionMatchesPlayed < 7 then
		-- Thus ends the Liberation Rite.
		-- PlaySpeech({ Name = "/VO/Justice_797", Queue = "Always" })
		-- Thus ends the Liberation Rite.
		PlaySpeech({ Name = "/VO/Match_582", Queue = "Always" })
	else
		-- Final Liberation / Ascension 7 content goes here
		-- Thus ends the Liberation Rite.
		PlaySpeech({ Name = "/VO/Justice_1006", Queue = "Always" })
	end
end

-- **ascension match outro follow-up**
OnSoundComplete{ "/VO/Match_582",
	function( triggerArgs )
		waitScreenTime(0.9)
		-- And thus, the Scribes have chosen:
		PlaySpeech({ Name = "/VO/Match_583" })
	end
}

OnSoundComplete{ "/VO/Match_583",
	function( triggerArgs )
		waitScreenTime(0.9)
		-- if you won
		local speechCue = nil
		if PlayerTeam.PyreHealth > 0 then
			if PlayerTeam.AscensionMatchesPlayed == 6 then
				-- The exile appointed by the Nightwings shall be free.
				speechCue = "/VO/Match_587"
			elseif PlayerTeam.AscensionMatchesPlayed == 5 then
				-- The exile appointed by the Nightwings shall be free.
				speechCue = "/VO/Match_586"
			elseif PlayerTeam.AscensionMatchesPlayed == 4 then
				-- The exile appointed by the Nightwings shall be free.
				speechCue = "/VO/Match_585"
			else
				-- The exile appointed by the Nightwings shall be free.
				speechCue = "/VO/Match_584"
			end
		-- if you lost
		else
			if LastTeam.LeagueIndex == 2 then
				-- The exile appointed by the Accusers shall be free.
				speechCue = "/VO/Match_588"
			elseif LastTeam.LeagueIndex == 3 then
				-- The exile appointed by the Fate shall be free.
				speechCue = "/VO/Match_589"
			elseif LastTeam.LeagueIndex == 4 then
				-- The exile appointed by the Dissidents shall be free.
				speechCue = "/VO/Match_590"
			elseif LastTeam.LeagueIndex == 5 then
				-- The exile appointed by the Withdrawn shall be free.
				speechCue = "/VO/Match_591"
			elseif LastTeam.LeagueIndex == 6 then
				-- The exile appointed by the Pyrehearts shall be free.
				speechCue = "/VO/Match_592"
			elseif LastTeam.LeagueIndex == 7 then
				-- The exile appointed by the Essence shall be free.
				speechCue = "/VO/Match_593"
			elseif LastTeam.LeagueIndex == 8 then
				-- The exile appointed by the Chastity shall be free.
				speechCue = "/VO/Match_594"
			elseif LastTeam.LeagueIndex == 9 then
				-- The exile appointed by the Tempers shall be free.
				speechCue = "/VO/Match_595"
			elseif LastTeam.LeagueIndex == 10 then
				-- The exile appointed by the Beyonders shall be free.
				speechCue = "/VO/Match_597"
			elseif LastTeam.LeagueIndex == 11 then
				-- The exile appointed by the True Nightwings shall be free.
				speechCue = "/VO/Match_596"
			end
		end
		PlaySpeech({ Name = speechCue })
		waitUntil( speechCue )
		waitScreenTime(0.8)
		-- Absolved of all misdeeds.
		-- PlaySpeech({ Name = "/VO/Justice_801" })
		-- Absolved of all misdeeds.
		PlaySpeech({ Name = "/VO/Match_598" })
	end
}

OnSoundComplete{ "/VO/Justice_801 /VO/Match_598",
	function( triggerArgs )
		waitScreenTime(0.8)
		-- Returned to glory in the Commonwealth.
		-- PlaySpeech({ Name = "/VO/Justice_802" })
		-- Returned to glory in the Commonwealth.
		PlaySpeech({ Name = "/VO/Match_599" })
	end
}

OnSoundComplete{ "/VO/Justice_802 /VO/Match_599",
	function( triggerArgs )
		waitScreenTime(0.8)
		-- if you won
		if PlayerTeam.PyreHealth > 0 then
			if LastAscendedCharacter.Gender == "Char_Gender_Male" then
				-- All others and his adversary shall remain.
				-- PlaySpeech({ Name = "/VO/Justice_803" })
				-- His adversary and all others shall remain...
				PlaySpeech({ Name = "/VO/Match_600" })
			elseif LastAscendedCharacter.Gender == "Char_Gender_Female" then
				-- All others and her adversary shall remain.
				-- PlaySpeech({ Name = "/VO/Justice_804" })
				-- Her adversary and all others shall remain...
				PlaySpeech({ Name = "/VO/Match_601" })
			else
				-- Their adversary and all others shall remain...
				PlaySpeech({ Name = "/VO/Match_602" })
			end
		else
			if LastAscendedRival.Gender == "Char_Gender_Male" then
				-- All others and his adversary shall remain.
				-- PlaySpeech({ Name = "/VO/Justice_803" })
				-- His adversary and all others shall remain...
				PlaySpeech({ Name = "/VO/Match_600" })
			elseif LastAscendedRival.Gender == "Char_Gender_Female" then
				-- All others and her adversary shall remain.
				-- PlaySpeech({ Name = "/VO/Justice_804" })
				-- Her adversary and all others shall remain...
				PlaySpeech({ Name = "/VO/Match_601" })
			else
				-- Their adversary and all others shall remain...
				PlaySpeech({ Name = "/VO/Match_602" })
			end
		end
	end
}

OnSoundComplete{ "/VO/Match_600 /VO/Match_601 /VO/Match_602",
	function( triggerArgs )
		waitScreenTime(0.7)
		-- ...to carry out their rightful sentences.
		PlaySpeech({ Name = "/VO/Match_603" })
	end
}

-- **final liberation post-match follow-up**
OnSoundComplete{ "/VO/Justice_1006",
	function( triggerArgs )
		waitScreenTime(0.7)
		-- And thus, the Scribes have chosen:
		PlaySpeech({ Name = "/VO/Justice_1007" })
	end
}


function AscensionFinalLiberationOutcomeAudio()
	if PlayerTeam.AscensionMatchesPlayed ~= 7 then
		return
	end
	-- Ahem. And thus, the Scribes have chosen.
	PlaySpeech({ Name = "/VO/Justice_1008" })
end

OnSoundComplete{ "/VO/Justice_1008",
	function( triggerArgs )
		waitScreenTime(1.8)
		-- And thus, the Scribes have chosen...?!
		PlaySpeech({ Name = "/VO/Justice_1009" })
	end
}

OnSoundComplete{ "/VO/Justice_1009",
	function( triggerArgs )
		waitScreenTime(2.1)
		-- And thus, the SCRIBES HAVE CHOSEN?!
		PlaySpeech({ Name = "/VO/Justice_1010" })
	end
}

OnSoundComplete{ "/VO/Justice_1010",
	function( triggerArgs )
		waitScreenTime(2.3)
		-- No....
		PlaySpeech({ Name = "/VO/Justice_1011" })
	end
}

OnSoundComplete{ "/VO/Justice_1011",
	function( triggerArgs )
		waitScreenTime(1.2)
		-- Nightwings!! Reader! What have you done...?!
		PlaySpeech({ Name = "/VO/Justice_1012" })
	end
}

function AscensionPostOutcomeAudio()
	-- character-specific send-offs
	local sendOffSpeech = "/VO/Justice_68"
	-- if you win
	if PlayerTeam.PyreHealth > 0 then
		if LastAscendedCharacter["AscensionSendOffVO"] ~= nil then
			sendOffSpeech = LastAscendedCharacter["AscensionSendOffVO"]
		end
	-- if you lose
	else
		if LastAscendedRival["AscensionSendOffVO"] ~= nil then
			sendOffSpeech = LastAscendedRival["AscensionSendOffVO"]
		end
		-- Fate exception
		if LastTeam.LeagueIndex == 3 then
			sendOffSpeech = RivalFateSon["AscensionSendOffVO"]
		end
	end
	-- Final Liberation exception
	if PlayerTeam.AscensionMatchesPlayed == 7 then
		if NarrationRecord["Match_Ascension7_YouLost_Manipulate_Relent"] or NarrationRecord["Match_Ascension7_YouLost_Ignore"] or NarrationRecord["Match_Ascension7_YouLost_ReachOut_Nightwing"] or NarrationRecord["Match_Ascension7_YouLost_Manipulate_Relent"] or NarrationRecord["Match_Ascension7_YouWon_ChooseAdversary"] then
			sendOffSpeech = RivalNightwing["AscensionSendOffVO"]
		elseif NarrationRecord["Match_Ascension7_YouWon_ChooseFriend"] then
			sendOffSpeech = LastAscendedCharacter["AscensionSendOffVO"]
		else
			sendOffSpeech = "/VO/Justice_1005"
		end
	end
	PlaySpeech({ Name = sendOffSpeech, Queue = "Always" })
	waitUntil( sendOffSpeech )
	-- The Eight Scribes are ever merciful.
	-- PlaySpeech({ Name = "/VO/Match_604" })
	-- As for the rest of ye, know that the Scribes art ever-merciful.
	-- PlaySpeech({ Name = "/VO/Match_76" })
	-- Know, however, that the Scribes are ever merciful.
	-- PlaySpeech({ Name = "/VO/Justice_805" })

	waitScreenTime(2.0)
	-- Post-Ascension Sendoff
	if PlayerTeam.AscensionMatchesPlayed <= 3 then
		-- The Eight Scribes are ever merciful.
		PlaySpeech({ Name = "/VO/Match_604" })
	elseif PlayerTeam.AscensionMatchesPlayed == 4 then
		-- The Eight Scribes are watching from afar.
		PlaySpeech({ Name = "/VO/Match_830" })
	elseif PlayerTeam.AscensionMatchesPlayed == 5 then
		-- Perhaps the Scribes are watching, even now.
		PlaySpeech({ Name = "/VO/Match_832" })
	elseif PlayerTeam.AscensionMatchesPlayed == 6 then
		-- The cycle of the Rites is nearly at an end.
		PlaySpeech({ Name = "/VO/Match_828" })
	elseif PlayerTeam.AscensionMatchesPlayed == 7 then
		-- By the Scribes....
		PlaySpeech({ Name = "/VO/Justice_1013", Queue = "Always" })
	end
end

-- Post-Ascension Sendoff follow-up
OnSoundComplete{ "/VO/Match_604",
	function( triggerArgs )
		waitScreenTime(0.9)
		if PlayerTeam.AscensionMatchesPlayed == 1 then
			-- By their grace, the cycle of the Rites may soon commence again.
			PlaySpeech({ Name = "/VO/Justice_806" })
		elseif PlayerTeam.AscensionMatchesPlayed == 2 then
			-- By their grace, the cycle of the Rites may yet continue for a while...
			-- PlaySpeech({ Name = "/VO/Match_826" })
			-- By their grace, the cycle of the Rites may soon commence again.
			PlaySpeech({ Name = "/VO/Justice_806" })
		elseif PlayerTeam.AscensionMatchesPlayed == 3 then
			-- By their grace, may the cycle of the Rites keep turning for as long as possible...
			-- PlaySpeech({ Name = "/VO/Match_827" })
			-- By their grace, the cycle of the Rites may yet continue for a while...
			PlaySpeech({ Name = "/VO/Match_826" })
		end
	end
}

OnSoundComplete{ "/VO/Match_830",
	function( triggerArgs )
		waitScreenTime(0.9)
		-- But, soon, these Rites, their ancient trial, are to cease.
		-- PlaySpeech({ Name = "/VO/Match_829" })
		-- By their grace, may the cycle of the Rites keep turning for as long as possible...
		PlaySpeech({ Name = "/VO/Match_827" })
		end
}

OnSoundComplete{ "/VO/Match_832",
	function( triggerArgs )
		waitScreenTime(0.9)
		-- Watching as their glorious tradition draws to a close.
		PlaySpeech({ Name = "/VO/Match_833" })
	end
}

OnSoundComplete{ "/VO/Match_828",
	function( triggerArgs )
		waitScreenTime(0.9)
		-- Let us make good our last remaining opportunities.
		-- PlaySpeech({ Name = "/VO/Match_831" })
	end
}

-- **final liberation post-match follow-up**
OnSoundComplete{ "/VO/Justice_1013",
	function( triggerArgs )
		wait(1.35)
		-- No stars remain aloft.
		PlaySpeech({ Name = "/VO/Justice_1014" })
	end
}

OnSoundComplete{ "/VO/Justice_1014",
	function( triggerArgs )
		wait(1.35)
		-- The cycle of the Rites... it is finished.
		PlaySpeech({ Name = "/VO/Justice_1015" })
	end
}

OnSoundComplete{ "/VO/Justice_1015",
	function( triggerArgs )
		wait(1.35)
		-- The Commonwealth... what shall become of it....
		PlaySpeech({ Name = "/VO/Justice_1016" })
	end
}

OnSoundComplete{ "/VO/Justice_1016",
	function( triggerArgs )
		wait(1.35)
		-- What shall become of us?
		PlaySpeech({ Name = "/VO/Justice_1017" })
	end
}

OnSoundComplete{ "/VO/Justice_1017",
	function( triggerArgs )
		wait(1.35)
		-- Nightwings... the opportunity to gain your freedom from the Downside...
		PlaySpeech({ Name = "/VO/Justice_1018" })
	end
}

OnSoundComplete{ "/VO/Justice_1018",
	function( triggerArgs )
		wait(1.95)
		-- ...was it not enough?
		PlaySpeech({ Name = "/VO/Justice_1019" })
	end
}

-- disabled on purpose [GK 3/1/16]
OnSoundComplete{ "/VO/Match_292XXXXX",
	function( triggerArgs )
		waitScreenTime(0.9)
		if lastMatchResult == "Win" then
			-- Perhaps you shan't be quite so fortunate next time.
			PlaySpeech({ Name = "/VO/Match_293" })
		elseif lastMatchResult == "Loss" then
			-- Perhaps your fortune shall be better next time, hm?
			PlaySpeech({ Name = "/VO/Match_294" })
		end
	end
}

OnSoundComplete{ "/VO/Match_293 /VO/Match_294",
	function( triggerArgs )
		waitScreenTime(0.55)
		-- If you can find your way at all.
		-- PlaySpeech({ Name = "/VO/Match_295" })
	end
}

OnSoundComplete{ "/VO/Match_295",
	function( triggerArgs )
		waitScreenTime(0.9)
		-- Until then, begone now from my sight.
		PlaySpeech({ Name = "/VO/Match_296" })
	end
}

-- Remaining Matches: [ NOT IN USE 10/31/16 ]
function RemainingMatchesAudio()
	if TeamA == nil then
		return
	end

	if introMatch or practiceMatch then
		return
	end

	waitScreenTime(3.5)

	if PlayerTeam.MatchesPlayed ~= nil then
		if PlayerTeam.MatchesPlayed == 1 then
			-- Twas but the first stage of the Rites, and there art seven stages hence.
			PlaySpeech({ Name = "/VO/Match_81" })
		elseif PlayerTeam.MatchesPlayed == 2 then
			-- Twas the second of eight stages of the Rites, thus do six stages yet remain.
			PlaySpeech({ Name = "/VO/Match_82" })
		elseif PlayerTeam.MatchesPlayed == 3 then
			-- Twas the third of the eight stages of the Rites, and five such stages yet remain.
			PlaySpeech({ Name = "/VO/Match_83" })
		elseif PlayerTeam.MatchesPlayed == 4 then
			-- Twas the fourth stage of the Rites, merely halfway to thy goal.
			PlaySpeech({ Name = "/VO/Match_84" })
		elseif PlayerTeam.MatchesPlayed == 5 then
			-- Twas the fifth stage of the Rites, and only three remain.
			PlaySpeech({ Name = "/VO/Match_85" })
		elseif PlayerTeam.MatchesPlayed == 6 then
			-- Twas the sixth stage of the Rites; but two remain as yet.
			PlaySpeech({ Name = "/VO/Match_86" })
		elseif PlayerTeam.MatchesPlayed == 7 then
			-- Twas the seventh stage of the Rites, so all which yet remains is the very last.
			PlaySpeech({ Name = "/VO/Match_87" })
		elseif ascensionMatch then
			if TeamA.PyreHealth > TeamB.PyreHealth then
				AscensionSuccessAudio()
			else
				AscensionFailureAudio()
			end
		else
		end
	end

end

-- Match Conclusion: [ NOT IN USE 10/31/16 ]
SpeechSet.MatchConclusion =
{
	-- Look thee to the stars to guide ye on.
	"/VO/Match_88",
	-- The stars themselves shall be thy guide.
	"/VO/Match_89",
	-- Until the stars align.
	"/VO/Justice_92",
	-- Until the next Rite.
	"/VO/Justice_93",
	-- You may take your leave.
	"/VO/Justice_94",
}
function MatchConclusionAudio()
	wait(1.25)
	PlayRemainingSpeech( SpeechSet.MatchConclusion )
end

-- Match Outro: Closing Thought
OnSoundComplete{ "/VO/Match_81 /VO/Match_82 /VO/Match_83 /VO/Match_84 /VO/Match_85 /VO/Match_86 /VO/Match_87",
	function( triggerArgs )
		MatchConclusionAudio()
	end
}

-- Match Outro: Player Team Loses
OnSoundComplete{ "/VO/Match30 /VO/Match31 /VO/Match32 /VO/Match33",
	function( triggerArgs )
		wait(0.5)
		PlaySpeech({ Name = "/VO/Match_34" })
	end
}

-- VO for Match Start
OnSoundComplete{ "/VO/Justice_13 /VO/Justice_13a",
	function( triggerArgs )
		PlaySound({ Name = "/Music/Stingers/MandolinStingerMisc2" })
		wait(0.7)
		PlaySpeech({ Name = "/VO/Justice_14" })
	end
}

OnAnyLoad{ function( triggerArgs )

	if SpeechSet.MatchStart ~= nil then
		return
	end

	SpeechSet.MatchStart =
	{
		-- The Rites commence!
		-- "/VO/Justice_14",
		-- Begin!
		-- "/VO/Justice_15",
		-- Now let the Rite commence!
		-- "/VO/Justice_469",
		-- And thus begins the Rite!
		-- "/VO/Justice_482",
		-- Let the Rites commence!
		-- "/VO/Justice_281",
		-- Begin!
		"/VO/Match_140",
		-- Now, begin!
		"/VO/Match_141",
		-- Commence!
		"/VO/Match_142",
	}
	function MatchStartAudio()
		if not introMatch and not IsMultiplayerMatch() and not practiceMatch then
			if IsScreenOpen({ Name = "DialogueScreen" }) then
				waitUntil( "terminalShutdownComplete" )
			end

			wait(0.35)
			PlaySound({ Name = "/SFX/Match SFX/MatchStart" })
			waitScreenTime(1.35)
			-- Forfeit Match exception
			if forfeitMatch then
				-- Lo, even your adversaries have abandoned you.
				PlaySpeech({ Name = "/VO/Justice_977", Queue = "Always", Delay = 0.4 })
			-- Final Liberation exception
			elseif ascensionMatch then
				if PlayerTeam.AscensionMatchesPlayed == 6 then
					thread( ArchJusticeSpeaking )
					-- Begin! The final chance at Liberation for the Age!
					PlaySpeech({ Name = "/VO/Justice_957", Queue = "Always" })
				else
					-- Commence!
					PlaySpeech({ Name = "/VO/Match_142", Queue = "Always" })
				end
			elseif not IsFirstAccusersMatch() then
				if not blockMatchVO and not IsScreenOpen({ Name = "DialogueScreen" }) and ActiveNarrationName ~= "Week7_Match_SaplingIntro" then
					PlayRemainingSpeech( SpeechSet.MatchStart, nil, "Always" )
				end
			else
				-- Begin!
				PlaySpeech({ Name = "/VO/Justice_15a", Queue = "Always" })
			end

		-- multiplayer audio
		elseif IsMultiplayerMatch() then

			wait(0.95)

			-- after drafting
			if GetMapName({ }) == "MatchSiteMP" then
				-- Waitingroom / Waiting Room: no archjustice VO while you wait, except for first line and match found line
				if not blockMatchVO then
					SearchingForMatchAudio()
				end
			else
				-- LocalMP
				if not blockMatchVO then
					PlayRemainingSpeech( SpeechSet.MatchStart, nil, "Always" )
				end
			end

		else

			wait(1.0)

			PlaySound({ Name = "/SFX/World Sounds/ThunderHuge" })

			wait(0.5)

			if not practiceMatch then
				thread( PlayIntroMatchSpeech, "intro" )
			end

		end
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			PlaySound({ Name = "/SFX/Match SFX/ImpCrowdCheer", Delay = 0.1 })
		end
	end

    SpeechSet.MatchStartLastOfSeason =
    {
	    "/VO/Justice_124",
    }

    function MatchStartLastOfSeasonAudio()
	    wait(1.75)
	    PlayRemainingSpeech( SpeechSet.MatchStartLastOfSeason )
    end

    SpeechSet.MatchStartLightning =
    {
	    "/VO/Justice_121",
    }

    function MatchStartLightningAudio()
	    wait(1.75)
	    PlayRemainingSpeech( SpeechSet.MatchStartLightning )
    end

    SpeechSet.MatchStartSnow =
    {
	    "/VO/Justice_122",
    }

    function MatchStartSnowAudio()
	    wait(1.75)
	    PlayRemainingSpeech( SpeechSet.MatchStartSnow )
    end

    SpeechSet.MatchStartWind =
    {
	    "/VO/Justice_123",
    }

    function MatchStartWindAudio()
	    wait(1.75)
	    PlayRemainingSpeech( SpeechSet.MatchStartWind )
    end

	-- VO for Players Killed with Ball
    SpeechSet.PlayerWithBallKilled =
    {
		-- The Orb has left your clutches.
		"/VO/Match_321",
		-- Oh you poor thing.
		"/VO/Match_322",
		-- Mm too bad.
		"/VO/Match_323",
		-- Caught out!
		"/VO/Match_324",
		-- Woe is you.
		"/VO/Match_325",
		-- Oh dear.
		"/VO/Match_326",
		-- Not quite.
	    -- "/VO/Justice_28",
		-- Red handed.
	    "/VO/Justice_29",
		-- Careless.
	    "/VO/Justice_30",
		-- The Orb slips from your clutches!
	    "/VO/Justice_644",
		-- Banished from this place.
		"/VO/Justice_637",
		-- Bye now!
		"/VO/Justice_639",
		-- How sad for that one there.
		"/VO/Justice_642",
		-- The Orb's unclaimed again!
		"/VO/Justice_643",
		-- The Orb slips from your clutches!
		"/VO/Justice_644",
		-- There goes the Orb!
		"/VO/Justice_647",
		-- Someone grasp the Orb!
		"/VO/Justice_667",
    }
    function PlayerWithBallKilledAudio()
	    SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Drums"}, Value = 0.0, Duration = 0.25 })
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			if CoinFlip() then
				PlaySound({ Name = "/SFX/Match SFX/ImpCrowdDisappointed", Delay = 0.1 })
			end
		end
	    wait(0.45)
		if blockMatchVO then
			return
		end
		if someoneScored then
			return
		end
		if archJusticeSpokeRecently then
			return
		end
	    PlayRemainingSpeech( SpeechSet.PlayerWithBallKilled )
		thread( ArchJusticeSpeaking )
    end

    SpeechSet.PlayerWithBallKilledNearGoal =
    {
		-- Oh, so close.
	    "/VO/Match_328",
		-- Almost!
	    "/VO/Match_329",
		-- Uh-uh!
	    "/VO/Match_330",
		-- You'll have to do better than that.
	    "/VO/Match_331",
		-- All for naught.
	    "/VO/Match_332",
		-- No you don't.
	    "/VO/Match_333",
		-- If I were that one I'd be rather angry.
		"/VO/Justice_652",
		-- A stifled effort.
		"/VO/Justice_653",
		-- Well now that was exciting.
		"/VO/Justice_654",
		-- A mere attempt.
		"/VO/Justice_656",
		-- I almost pity what transpired there.
		"/VO/Justice_657",
		-- An interesting exchange.
		-- "/VO/Justice_658",
    }
    function PlayerWithBallKilledNearGoalAudio()
	    SetSoundCueValue({ Id = GetMixingId({ }), Names = {"Drums"}, Value = 0.0, Duration = 0.25 })
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			PlaySound({ Name = "/SFX/Match SFX/ImpCrowdDisappointed", Delay = 0.1 })
		end
	    wait(0.45)
		if blockMatchVO then
			return
		end
		if someoneScored then
			return
		end
		if archJusticeSpokeRecently then
			return
		end
	    PlayRemainingSpeech( SpeechSet.PlayerWithBallKilledNearGoal )
		thread( ArchJusticeSpeaking )
    end

    SpeechSet.OpponentWithBallKilled =
    {
		-- The Orb is loose!
		"/VO/Match_376",
		-- The Orb, take it!
		"/VO/Match_377",
		-- Seize the Orb!
		"/VO/Match_378",
		-- An opportunity!
		"/VO/Match_379",
		-- Now take it!
	    "/VO/Justice_31",
		-- Stand not in glory's path.
	    "/VO/Justice_32",
		-- Begone!
	    "/VO/Justice_33",
		-- A banishment.
		"/VO/Justice_634",
		-- Another banishment.
		"/VO/Justice_635",
		-- Banished.
		"/VO/Justice_636",
		-- Banishment.
		"/VO/Justice_638",
		-- Engulfed within the Aura.
		"/VO/Justice_640",
		-- Too bad for that one.
		"/VO/Justice_641",
		-- Somebody get the Orb!
		"/VO/Justice_645",
		-- The Orb!
		"/VO/Justice_646",
    }

    function OpponentWithBallKilledAudio()
	    wait(0.45)
		if blockMatchVO then
			return
		end
		if someoneScored then
			return
		end
		if archJusticeSpokeRecently then
			return
		end
	    PlayRemainingSpeech( SpeechSet.OpponentWithBallKilled )
		thread( ArchJusticeSpeaking )
    end

    SpeechSet.OpponentWithBallKilledNearGoal =
    {
		-- I thought they had you there.
	    "/VO/Match_334",
		-- Quite the turn of events.
	    "/VO/Match_335",
		-- Oh boo.
	    "/VO/Match_336",
		-- A stroke of luck is all.
	    "/VO/Match_337",
		-- How very fortunate.
	    "/VO/Match_338",
		-- Oh!
	    "/VO/Match_339",
		-- Ugh...
	    "/VO/Match_340",
		-- Twas dangerously close.
		"/VO/Justice_648",
		-- That one almost got through.
		"/VO/Justice_649",
		-- Quite the close call there, no?
		"/VO/Justice_650",
		-- Someone there rose to the occasion.
		"/VO/Justice_651",
		-- A deftly-thwarted drive.
		"/VO/Justice_655",
    }

    function OpponentWithBallKilledNearGoalAudio()
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			PlaySound({ Name = "/SFX/Match SFX/ImpCrowdDisappointed", Delay = 0.1 })
		end
	    wait(0.45)
		if blockMatchVO then
			return
		end
		if someoneScored then
			return
		end
		if archJusticeSpokeRecently then
			return
		end
	    PlayRemainingSpeech( SpeechSet.OpponentWithBallKilledNearGoal )
		thread( ArchJusticeSpeaking )
    end

	function CharacterBanishedAudio( character )
		if character == nil then
			return
		end
		if introMatch and character.TeamIndex ~= 1 then
			return
		end
		if blockMatchVO then
			return
		end
		if DidSuicide({ Id = character.ObjectId }) then
			return
		end
	    wait(0.45)
		if archJusticeSpokeRecently then
			return
		end
		if someoneScored then
			return
		end
		local speech = GetRandomRemainingData( character.BanishedSpeechLines, "Banished"..character.Id )
		PlaySpeech({ Name = speech })
		thread( ArchJusticeSpeaking )
	end

	-- VO for First Blood
    SpeechSet.FirstBlood =
    {
		-- Hark!
	    -- "/VO/Justice_110",
		-- Mercy!
	    -- "/VO/Justice_111",
		-- Behold, the Rites!
		-- "/VO/Match_425",
		-- The first of many banishments.
		"/VO/Match_422",
		-- The power of the Aura!
		"/VO/Match_423",
		-- Praise be to the Scribes!
		"/VO/Match_424",
		-- First to be banished!
		"/VO/Justice_630",
		-- Beware the adversary's Aura!
		"/VO/Justice_631",
		-- Beware the adversary's Aura, or be banished!
		"/VO/Justice_632",
		-- Now it begins in earnest!
		"/VO/Justice_633",
		-- The night's First Banishment!
		"/VO/Match_533",
		-- Twas the First Banishment.
		"/VO/Match_534",
		-- Banished in an instant!
		"/VO/Match_535",
		-- My, my!
		"/VO/Match_536",
		-- Gracious!
		"/VO/Match_537",
		-- My goodness!
		"/VO/Match_538",
		-- Twas bound to happen.
		"/VO/Match_539",
    }
    function FirstBloodAudio()
	    wait(0.25)
		if introMatch then
			return
		end
		if blockMatchVO then
			return
		end
		if someoneScored then
			return
		end
		if ( TeamA ~= nil and TeamA.PyreHealth < 100 ) or ( TeamB ~= nil and TeamB.PyreHealth < 100 ) then
			return
		end
		-- imp crowd
		if CurrentMapName == "MatchSiteJ" then
			PlaySound({ Name = "/SFX/Match SFX/ImpCrowdCheer", Delay = 0.1 })
		end
		if archJusticeSpokeRecently then
			-- return
		end
		if RandomChance(0.33) then
			PlayRemainingSpeech( SpeechSet.FirstBlood )
			thread( ArchJusticeSpeaking )
		end
    end

	-- VO for Player Multi-Kill
    SpeechSet.PlayerMultiKill =
    {
		-- Oh-hoh!
		"/VO/Match_427",
		-- Sinners!
		"/VO/Match_428",
		-- Away with them.
		"/VO/Match_429",
		-- Begone, you lot.
		"/VO/Match_430",
		-- Out with you all!
		"/VO/Match_431",
		-- Spectacular!
	    "/VO/Justice_112",
		-- Splendid!
	    "/VO/Justice_88",
		-- Miraculous!
	    -- "/VO/Justice_113",
		-- Such fervor!
		"/VO/Justice_587",
		-- No mercy shown.
		"/VO/Justice_588",
		-- Mm indeed!
		"/VO/Justice_589",
		-- So fiercely fought!
		"/VO/Justice_590",
		-- Audacious, aren't we.
		"/VO/Justice_591",
		-- Twas almost cruel.
		"/VO/Justice_592",
		-- Oh-hohoho.
		"/VO/Justice_593",
		-- Ah-hahaha-hah.
		"/VO/Justice_594",
		-- Ferocity unbridled!
		"/VO/Justice_595",
		-- Simply monstrous.
		"/VO/Justice_596",
    }
    function PlayerMultiKillAudio()
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			PlaySound({ Name = "/SFX/Match SFX/ImpCrowdImpressed", Delay = 0.25 })
		end
	    wait(0.3)
		if blockMatchVO then
			return
		end
		if someoneScored then
			return
		end
		if archJusticeSpokeRecently then
			return
		end
	    PlayRemainingSpeech( SpeechSet.PlayerMultiKill )
		thread( ArchJusticeSpeaking )
    end

	-- VO for Double KO
    SpeechSet.DoubleKO =
    {
		-- What happened there?
		"/VO/Match_369",
		-- Uh-huhuhuhu.
		"/VO/Match_370",
		-- Such chaos.
		"/VO/Match_371",
		-- Both banished.
		"/VO/Match_372",
		-- Pff-hah!
		"/VO/Match_373",
		-- Positively brutish.
		"/VO/Match_374",
		-- A bit of a blunder.
		"/VO/Match_375",
		-- How comical.
		"/VO/Justice_597",
		-- My, my.
		"/VO/Justice_598",
		-- To each his own.
		"/VO/Justice_599",
		-- Banished each in turn.
		"/VO/Justice_600",
		-- None left unscathed.
		"/VO/Justice_601",
		-- Quite an exchange.
		"/VO/Justice_602",
    }
    function DoubleKOAudio()
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			if CoinFlip() then
				PlaySound({ Name = "/SFX/Match SFX/ImpCrowdJeer", Delay = 0.2 })
			else
				PlaySound({ Name = "/SFX/Match SFX/ImpCrowdDisappointed", Delay = 0.2 })
			end
		end
	    wait(0.3)
		if blockMatchVO then
			return
		end
		if someoneScored then
			return
		end
		if archJusticeSpokeRecently then
			return
		end
	    PlayRemainingSpeech( SpeechSet.DoubleKO )
		thread( ArchJusticeSpeaking )
    end

	-- VO for PowerShot Kills
    SpeechSet.PowerShotKill =
    {
		-- Whaa!
		"/VO/Justice_603",
		-- Poof!
		"/VO/Justice_604",
		-- Well cast.
		"/VO/Justice_605",
		-- Didn't see it coming.
		"/VO/Justice_606",
		-- Huh!
		"/VO/Justice_607",
		-- Glorious!
		"/VO/Justice_608",
		-- Oh-hoho.
		"/VO/Justice_609",
		-- How fine.
		"/VO/Justice_610",
		-- Zap.
		"/VO/Justice_611",
		-- <Laughter>
		"/VO/Match_232",
    }
    function PowerShotKillAudio()
	    wait(0.25)
		if blockMatchVO then
			return
		end
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			if CoinFlip() then
				PlaySound({ Name = "/SFX/Match SFX/ImpCrowdLaugh", Delay = 0.25 })
			end
		end
		if archJusticeSpokeRecently then
			return
		end
	    PlayRemainingSpeech( SpeechSet.PowerShotKill )
		thread( ArchJusticeSpeaking )
    end

	-- VO for Mid-Air Collisions / AerialCollision()
    SpeechSet.Collision =
    {
		-- Ouch!
		"/VO/Justice_624",
		-- Oof!
		"/VO/Justice_625",
		-- Oh!
		"/VO/Justice_626",
		-- Hoh.
		"/VO/Justice_627",
		-- Ah!
		"/VO/Justice_628",
		-- Hoo.
		"/VO/Justice_629",
	}
    function CollisionAudio()
	    wait(0.15)
		if blockMatchVO then
			return
		end
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			PlaySound({ Name = "/SFX/Match SFX/ImpCrowdImpressed", Delay = 0.1 })
		end
		if archJusticeHootedRecently then
			return
		end
	    PlayRemainingSpeech( SpeechSet.Collision, nil, "Interrupt" )
		thread( ArchJusticeHooting )
    end

	-- VO for Dramatic Moments / ThrowScore Attempts / Jump Attempts
    SpeechSet.DramaticMoment =
    {
		-- Whaaa---
		"/VO/Justice_612",
		-- Hooh--
		"/VO/Justice_613",
		-- Mmm--
		"/VO/Justice_614",
		-- Haah--
		"/VO/Justice_615",
		-- Come on--
		"/VO/Justice_616",
		-- Shall it be--
		"/VO/Justice_617",
		-- Nnnn--
		"/VO/Match_1223",
		-- Hrrrr--
		"/VO/Match_1226",
		-- Now--
		"/VO/Match_1229",
		-- Rnnghh--
		"/VO/Match_1232",
		-- Do it--
		"/VO/Match_1235",
		-- There--
		"/VO/Match_1238",
		-- Ohhh--
		"/VO/Match_1241",

	}
    function DramaticMomentAudio()
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			if CoinFlip() then
				PlaySound({ Name = "/SFX/Match SFX/ImpCrowdImpressed", Delay = 0.1 })
			end
		end
		local coinToss = math.random(1,3)
		if coinToss ~= 1 then
			return
		end
	    wait(0.1)
		if blockMatchVO then
			return
		end
		if archJusticeHootedRecently then
			return
		end
		if IsWholeTeamDeadOrRespawning( TeamA ) or IsWholeTeamDeadOrRespawning( TeamB ) then
			return
		end
	    PlayRemainingSpeech( SpeechSet.DramaticMoment )

		thread( DramaticMomentPlaying )
		thread( ArchJusticeHooting )
    end

	-- VO for Interceptions
    SpeechSet.Interception =
    {
		-- Foiled.
		"/VO/Justice_618",
		-- Pah.
		"/VO/Justice_619",
		-- Blast.
		"/VO/Justice_620",
		-- I say.
		"/VO/Justice_621",
		-- My!
		"/VO/Justice_622",
		-- Huh!
		"/VO/Justice_623",
	}
    function InterceptionAudio()
	    wait(0.13)
		if blockMatchVO then
			return
		end
		if someoneScored then
			return
		end
		if dramaticMomentFollowUpPlaying then
			return
		end
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			PlaySound({ Name = "/SFX/Match SFX/ImpCrowdDisappointed", Delay = 0.1 })
		end
		thread( DramaticMomentFollowUpPlaying )
		if lastCuePlayed ~= nil then
			-- Nnnn--
			if lastCuePlayed == "/VO/Match_1223" then
				--Not quite.
				PlaySpeech({ Name = "/VO/Match_1225", Queue = "Interrupt" })
				return
			-- Hrrrr--
			elseif lastCuePlayed == "/VO/Match_1226" then
				--Rnnn.
				PlaySpeech({ Name = "/VO/Match_1228", Queue = "Interrupt" })
				return
			-- Now--
			elseif lastCuePlayed == "/VO/Match_1229" then
				--No.
				PlaySpeech({ Name = "/VO/Match_1231", Queue = "Interrupt" })
				return
			-- Rnnghh--
			elseif lastCuePlayed == "/VO/Match_1232" then
				--Hrmm.
				PlaySpeech({ Name = "/VO/Match_1234", Queue = "Interrupt" })
				return
			-- Do it--
			elseif lastCuePlayed == "/VO/Match_1235" then
				--Damn.
				PlaySpeech({ Name = "/VO/Match_1237", Queue = "Interrupt" })
				return
			-- There--
			elseif lastCuePlayed == "/VO/Match_1238" then
				--Ruhh...
				PlaySpeech({ Name = "/VO/Match_1240", Queue = "Interrupt" })
				return
			-- Ohhh--
			elseif lastCuePlayed == "/VO/Match_1241" then
				--Wuhh...
				PlaySpeech({ Name = "/VO/Match_1243", Queue = "Interrupt" })
				return
			else
				PlayRemainingSpeech( SpeechSet.Interception, nil, "Interrupt" )
			end
		else
			PlayRemainingSpeech( SpeechSet.Interception, nil, "Interrupt" )
		end
		-- thread( ArchJusticeSpeaking )
    end

	-- VO for Misc Match Quips; Talisman Effects, etc.
    SpeechSet.MatchQuip =
    {
		-- How fortuitous!
		"/VO/Match_706",
		-- Seemingly unfair!
		"/VO/Match_710",
		-- Unexpected...!
		"/VO/Match_711",
		-- My word!
		"/VO/Match_712",
		-- Trickery!
		"/VO/Match_713",
		-- How brazen.
		"/VO/Match_714",
		-- But how?!
		"/VO/Match_715",
		-- I never!
		"/VO/Match_716",
	}
    function MatchQuipAudio()
		local coinToss = math.random(1,2)
		if coinToss ~= 1 then
			return
		end
	    wait(0.25)
		if blockMatchVO then
			return
		end
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			PlaySound({ Name = "/SFX/Match SFX/ImpCrowdDisappointed", Delay = 0.15 })
		end
		if archJusticeHootedRecently then
			return
		end
	    PlayRemainingSpeech( SpeechSet.MatchQuip )
		thread( ArchJusticeHooting )
    end

	-- VO for Misc Match Quips; Talisman Effects, etc.
    SpeechSet.SecondWind =
    {
		-- A second wind!
		"/VO/Match_707",
		-- A swift recovery!
		"/VO/Match_708",
		-- Such zeal!
		"/VO/Match_709",
	}
    function SecondWindAudio()
		local coinToss = math.random(1,35)
		if coinToss ~= 1 then
			return
		end
	    wait(0.1)
		if blockMatchVO then
			return
		end
		if archJusticeHootedRecently then
			return
		end
	    PlayRemainingSpeech( SpeechSet.SecondWind )
		thread( ArchJusticeHooting )
    end

	-- **Standard: Scoring VO**
    SpeechSet.PlayerScoresFirst =
    {
		-- Have the Accusers underestimated you?
	    -- "/VO/Match_299",
		-- All proceeds as planned.
	    -- "/VO/Justice_96",
		-- The path to glory laid bare.
	    "/VO/Justice_97",
		-- Already does your adversaries' flame begin to flicker!
	    "/VO/Match_297",
		-- Your adversaries' Pyre is the first to falter!
	    "/VO/Match_298",
		-- A favorable start.
	    "/VO/Justice_95",
		-- The Nightwings are first to strike the adversary's flame.
		"/VO/Justice_510",
		-- Glory to the Nightwings first of all!
		"/VO/Justice_512",
		-- The Nightwings make their mark upon the flame!
		"/VO/Justice_513",
		-- The Nightwings thus assert themselves.
	    "/VO/Match_512",
		-- The Nightwings assert themselves thusly.
	    "/VO/Match_554",
		-- In honor of the Scribes.
	    "/VO/Match_513",
		-- A flame is stricken!
	    "/VO/Match_514",
		-- The First Dousing!
	    "/VO/Match_515",
		-- The Nightwings are the first to strike!
	    "/VO/Match_516",
    }
    function PlayerScoresFirstAudio()
	    wait(0.65)
		if blockMatchVO then
			return
		end
	    SetFlagFalse({ Name = "CanInterject" })

		if IsFirstAccusersMatch() or ( NextTeam.LeagueIndex == 2 and not SpeechRecord["/VO/Match_299"] ) then
			-- Have the Accusers underestimated you?
			PlaySpeechOnce({ Name = "/VO/Match_299" })
		else
			PlayRemainingSpeech( SpeechSet.PlayerScoresFirst, nil, "Interrupt" )
		end

		local chanceToQuip = math.random(1,10)
		if chanceToQuip >= 6 then
			-- SetFlagTrue({ Name = "CanInterject" })
		end
    end

    SpeechSet.PlayerScores =
    {
		-- Their Pyre weakens.
	    "/VO/Match_303",
		-- Their flame has died a little.
	    "/VO/Match_304",
		-- Their Pyre sputters!
	    "/VO/Match_305",
		-- Verily.
	    "/VO/Justice_16",
		-- So it is.
	    "/VO/Justice_17",
		-- With grace.
	    "/VO/Justice_18",
		-- Ah, yes.
		"/VO/Justice_538",
		-- As per the sacred law.
		"/VO/Justice_545",
		-- The fire of resolve!
		"/VO/Justice_541",
		-- Bask in the purifying flame!
		"/VO/Justice_539",
		-- The flames of freedom!
		"/VO/Justice_540",
		-- A blow against the adversary's Pyre!
		"/VO/Justice_544",
		-- Onward thus to greater glory!
		"/VO/Justice_547",
		-- Glory to the Scribes!
		"/VO/Justice_528",
		-- Glory!!
	    "/VO/Justice_19",
		-- Yes!!
	    "/VO/Justice_20",
		-- Remember everything which you hold dear.
		"/VO/Justice_552",
		-- Exactly by the Book.
		"/VO/Justice_549",
		-- The Orb, engulfed in fire.
		"/VO/Justice_550",
		-- Fear not the purifying flame!
		"/VO/Justice_551",
		-- Righteous fire!
		"/VO/Match_233",
		-- Glorious!
		"/VO/Match_234",
		-- Absolution!
		"/VO/Match_235",
		-- Sublime.
		"/VO/Match_239",
		-- Deliverance!
		"/VO/Match_243",
		-- Resplendent.
		"/VO/Match_236",
		-- Magnificent.
		"/VO/Match_237",
		-- Beautious.
		"/VO/Match_238",
		-- Brilliantly done.
		"/VO/Match_240",
		-- Splendid.
		"/VO/Match_241",
    }
    function PlayerScoresAudio()
		if blockMatchVO then
			return
		end
	    wait(0.65)
		SetFlagFalse({ Name = "CanInterject" })

		PlayRemainingSpeech( SpeechSet.PlayerScores, nil, "Interrupt" )

		local chanceToQuip = math.random(1,10)
		if chanceToQuip >= 6 then
			-- SetFlagTrue({ Name = "CanInterject" })
		end
    end

    SpeechSet.PlayerScoresBig =
    {
		-- Their Pyre shan't survive much more of that.
	    "/VO/Match_306",
		-- Twas a crushing blow against their Pyre.
	    "/VO/Match_307",
		-- Blessed be!
	    "/VO/Justice_21",
		-- By the Scribes!
		"/VO/Justice_526",
		-- Oh my word!
		"/VO/Justice_527",
		-- That Pyre's flames grow weak.
		"/VO/Justice_529",
		-- Spectacularly done!
		"/VO/Justice_531",
		-- How utterly brazen!
		"/VO/Justice_533",
		-- Now that is how to snuff a flame!
		"/VO/Justice_534",
		-- In the name of Soliam Murr!
		"/VO/Justice_536",
		-- Such wherewithal!
		"/VO/Justice_537",
	}
    function PlayerScoresBigAudio()
		if blockMatchVO then
			return
		end
	    wait(0.65)
		PlayRemainingSpeech( SpeechSet.PlayerScoresBig, nil, "Interrupt" )
    end

    SpeechSet.PlayerThrowScores =
    {
		-- Thus sails the Orb into the waiting flame!
	    -- "/VO/Match_315",
		-- A true-aimed thrust into the fire!
		"/VO/Match_314",
		-- Flung with considerable precision.
	    "/VO/Match_316",
		-- The Orb flies true!
	    "/VO/Justice_519",
		-- A Pyre stricken from afar.
	    "/VO/Justice_523",
		-- Why that was rather bold.
	    "/VO/Justice_525",
		-- Cast from afar into the Pyre's flame!
	    "/VO/Match_313",
		-- A true-aimed thrust into the fire!
		"/VO/Match_314",
		-- Flung with considerable precision.
	    "/VO/Match_316",
		-- Flung with force of will!
	    "/VO/Match_950",
		-- It has gone in!
	    "/VO/Match_951",
		-- The Orb has hit the mark.
	    "/VO/Match_952",
		-- In goes the Orb!
	    "/VO/Match_953",
		-- Twas flung right in!
	    "/VO/Match_954",
	}
    function PlayerThrowScoresAudio()
		if blockMatchVO then
			return
		end
	    wait(0.55)
		SetFlagFalse({ Name = "CanInterject" })

		if not throwScoredOnce and not IsMultiplayerMatch() then
			-- A daring display.
			PlaySpeech({ Name = "/VO/Match_385", Queue = "Interrupt" })
			throwScoredOnce = true
			PersistVariable({ Name = "throwScoredOnce" })
		else
			PlayRemainingSpeech( SpeechSet.PlayerThrowScores, nil, "Interrupt" )
		end

		local chanceToQuip = math.random(1,10)
		if chanceToQuip >= 6 then
			-- SetFlagTrue({ Name = "CanInterject" })
		end
    end

    function PlayerScoresIntroAudio()
	    wait(0.75)
		-- Glory!!
		PlaySpeech({ Name = "/VO/Justice_19", Queue = "Interrupt" })
    end

	function CharacterScoresAudio( character )
		if character == nil then
			return
		end
		if blockMatchVO then
			return
		end
		wait(0.65)
		local speech = GetRandomRemainingData( character.ScoringSpeechLines )
		PlaySpeech({ Name = speech })
	end

	function CharacterThrowScoresAudio( character )
		if character == nil then
			return
		end
		if blockMatchVO then
			return
		end
		wait(0.65)
		local speech = GetRandomRemainingData( character.ThrowScoringSpeechLines )
		PlaySpeech({ Name = speech })
	end

    SpeechSet.TeamScoresFirst =
    {
		-- In honor of the Scribes.
	    "/VO/Match_513",
		-- A flame is stricken!
	    "/VO/Match_514",
		-- The First Dousing!
	    "/VO/Match_515",
		-- A Pyre has been scathed!
		"/VO/Match_519",
    }
    function TeamScoresFirstAudio( scoringTeam, scoredOnTeam )
	    wait(0.65)
		if blockMatchVO then
			return
		end

		local allLines = CombineAllValues({ scoringTeam.TeamScoresFirstSpeechLines, scoredOnTeam.TeamScoredOnFirstSpeechLines, SpeechSet.TeamScoresFirst })
		PlayRemainingSpeech( allLines, nil, "Interrupt" )
    end

	SpeechSet.TeamTakesLead =
    {
	}
    function TeamTakesLeadAudio( scoringTeam, scoredOnTeam )
		if blockMatchVO then
			return
		end
		if introMatch then
			return
		end
		if TeamA.NumScores + TeamB.NumScores <= 1 then
			return
		end
	    wait(5.85)
		if IsScreenOpen({ Name = "DialogueScreen" }) then
			return
		end
	    local allLines = CombineAllValues({ scoringTeam.TeamTakesLeadSpeechLines, scoredOnTeam.TeamLosesLeadSpeechLines, SpeechSet.TeamTakesLead })
		PlayRemainingSpeech( allLines )
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			local cheers = { "/SFX/Match SFX/ImpCrowdChantLoop_1", "/SFX/Match SFX/ImpCrowdChantLoop_2", "/SFX/Match SFX/ImpCrowdChantLoop_3", "/SFX/Match SFX/ImpCrowdChantLoop_4" }
			local cheerSound = GetRandomValue( cheers )
			if CoinFlip() then
				local delayTime = math.random(8,12)
				PlaySound({ Name = cheerSound, Delay = 1.0 })
				StopSound({ Name = cheerSound, Delay = delayTime, duration = 2 })
			end
		end
    end

	SpeechSet.ScoreTiedAudio =
    {
		-- The two flames now burn equally as bright!
		"/VO/Match_927",
		-- The two triumvirates are neck and neck!
		"/VO/Match_928",
		-- Neither triumvirate is closer than the other.
		"/VO/Match_929",
		-- Both Pyres now burn with the same strength!
		"/VO/Match_930",
		-- Tis too close to call who shall prevail as yet!
		"/VO/Match_931",
		-- Each Pyre now burns no more brightly than the other.
		"/VO/Match_932",
		-- The Pyre on each side burns just as true.
		"/VO/Match_933",
		-- Both triumvirates are equally as close.
		"/VO/Match_934",
	}
    function ScoreTiedAudio( scoringTeam, scoredOnTeam )
		if blockMatchVO then
			return
		end
		if introMatch then
			return
		end
		if TeamA.NumScores + TeamB.NumScores <= 1 then
			return
		end
		if TeamA.PyreHealth ~= TeamB.PyreHealth then
		end
	    wait(5.85)
		if IsScreenOpen({ Name = "DialogueScreen" }) then
			return
		end
		PlayRemainingSpeech( SpeechSet.ScoreTiedAudio )
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			local cheers = { "/SFX/Match SFX/ImpCrowdChantLoop_1", "/SFX/Match SFX/ImpCrowdChantLoop_2", "/SFX/Match SFX/ImpCrowdChantLoop_3", "/SFX/Match SFX/ImpCrowdChantLoop_4" }
			local cheerSound = GetRandomValue( cheers )
			if CoinFlip() then
				local delayTime = math.random(9,15)
				PlaySound({ Name = cheerSound, Delay = 1.0 })
				StopSound({ Name = cheerSound, Delay = delayTime, duration = 2 })
			end
		end
    end

    SpeechSet.SomeoneScores =
    {
		-- Ah, yes.
		"/VO/Justice_538",
		-- Bask in the purifying flame!
		"/VO/Justice_539",
		-- The flames of freedom!
		"/VO/Justice_540",
		-- The fire of resolve!
		"/VO/Justice_541",
		-- Glory to the Scribes!
		"/VO/Justice_542",
		-- The Orb quenches the flame!
		"/VO/Justice_543",
		-- A blow against the adversary's Pyre!
		"/VO/Justice_544",
		-- As per the sacred law.
		"/VO/Justice_545",
		-- Tis what the Scribes ordain.
		"/VO/Justice_546",
		-- Onward thus to greater glory!
		"/VO/Justice_547",
		-- From burning flame to ash.
		"/VO/Justice_548",
		-- Exactly by the Book.
		"/VO/Justice_549",
		-- The Orb, engulfed in fire.
		"/VO/Justice_550",
		-- Fear not the purifying flame!
		"/VO/Justice_551",
		-- Remember everything which you hold dear.
		"/VO/Justice_552",
		-- <Laughter>
		"/VO/Match_232",
		-- Righteous fire!
		"/VO/Match_233",
		-- Glorious!
		"/VO/Match_234",
		-- Absolution!
		"/VO/Match_235",
		-- Resplendent.
		"/VO/Match_236",
		-- Magnificent.
		"/VO/Match_237",
		-- Beautious.
		"/VO/Match_238",
		-- Sublime.
		"/VO/Match_239",
		-- Brilliantly done.
		"/VO/Match_240",
		-- Splendid.
		"/VO/Match_241",
		-- There it is!
		"/VO/Match_242",
		-- Deliverance!
		"/VO/Match_243",
    }
    function SomeoneScoresAudio()
		if blockMatchVO then
			return
		end
	    wait(0.65)
		SetFlagFalse({ Name = "CanInterject" })

		PlayRemainingSpeech( SpeechSet.SomeoneScores, nil, "Interrupt" )

		local chanceToQuip = math.random(1,10)
		if chanceToQuip >= 6 then
			-- SetFlagTrue({ Name = "CanInterject" })
		end
    end

    SpeechSet.SomeoneScoresBig =
    {
		-- By the Scribes!
		"/VO/Justice_526",
		-- Oh my word!
		"/VO/Justice_527",
		-- Glory to the Scribes!
		"/VO/Justice_528",
		-- That Pyre's flames grow weak.
		"/VO/Justice_529",
		-- Now there's a proper dousing.
		"/VO/Justice_530",
		-- Spectacularly done!
		"/VO/Justice_531",
		-- Such a display!
		"/VO/Justice_532",
		-- How utterly brazen!
		"/VO/Justice_533",
		-- Now that is how to snuff a flame!
		"/VO/Justice_534",
		-- Well I dare say!
		"/VO/Justice_535",
		-- In the name of Soliam Murr!
		"/VO/Justice_536",
		-- Such wherewithal!
		"/VO/Justice_537",
	}
    function SomeoneScoresBigAudio()
		if blockMatchVO then
			return
		end
	    wait(0.65)
		PlayRemainingSpeech( SpeechSet.SomeoneScoresBig, nil, "Interrupt" )
    end

    SpeechSet.SomeoneThrowScores =
    {
		-- The Orb flies true!
	    "/VO/Justice_519",
		-- A devious maneuver.
	    "/VO/Justice_520",
		-- A rather cunning trick.
	    "/VO/Justice_521",
		-- No law 'gainst throwing in the Orb.
	    "/VO/Justice_522",
		-- A Pyre stricken from afar.
	    "/VO/Justice_523",
		-- Did that one throw it in?
	    "/VO/Justice_524",
		-- Why that was rather bold.
	    "/VO/Justice_525",
		-- Cast from afar into the Pyre's flame!
	    "/VO/Match_313",
		-- A true-aimed thrust into the fire!
		"/VO/Match_314",
		-- Flung with considerable precision.
	    "/VO/Match_316",
		-- The Orb's engulfed!
	    "/VO/Match_945",
		-- The flame is stricken!
	    "/VO/Match_946",
		-- The fires wane!
	    "/VO/Match_947",
		-- The Orb sails forth into the flame!
	    "/VO/Match_948",
		-- The Orb flies true!
	    "/VO/Match_949",
		-- Flung with force of will!
	    "/VO/Match_950",
		-- It has gone in!
	    "/VO/Match_951",
		-- The Orb has hit the mark.
	    "/VO/Match_952",
		-- In goes the Orb!
	    "/VO/Match_953",
		-- Twas flung right in!
	    "/VO/Match_954",
	}
    function SomeoneThrowScoresAudio()
		if blockMatchVO then
			return
		end
	    wait(0.55)
		PlayRemainingSpeech( SpeechSet.SomeoneThrowScores, nil, "Interrupt" )
    end

    SpeechSet.SomeoneWeakThrowScores =
    {
		-- Merely a glancing blow.
		"/VO/Match_964",
		-- Not much force of will behind that thrust.
		"/VO/Match_965",
		-- Barely a mark against that flame.
		"/VO/Match_966",
		-- A nearly negligible effort.
		"/VO/Match_967",
		-- Twas but a little splash.
		"/VO/Match_968",
		-- An unimpressive thrust, but true.
		"/VO/Match_969",
		-- Not much of a splash that time.
		"/VO/Match_970",
		-- A weak attempt, and yet, it hit the mark.
		"/VO/Match_971",
	}
    function SomeoneWeakThrowScoresAudio()
		if blockMatchVO then
			return
		end
	    wait(0.55)
		PlayRemainingSpeech( SpeechSet.SomeoneWeakThrowScores, nil, "Interrupt" )
    end

    SpeechSet.SomeoneDramaticScores =
    {
		-- Yesss.
	    "/VO/Match_219",
		-- Hmmm.
	    "/VO/Match_220",
		-- There.
	    "/VO/Match_221",
		-- Haaah.
	    "/VO/Match_222",
		-- Fwoosh.
	    "/VO/Match_223",
		-- Fooom.
	    "/VO/Match_224",
		-- Fooosh.
	    "/VO/Match_224",
	}
    function SomeoneDramaticScoresAudio()
		if blockMatchVO then
			return
		end
	    wait(0.65)

		if lastCuePlayed ~= nil then
			-- Whaaa---
			if lastCuePlayed == "/VO/Justice_612" then
				--Hoh!!
				PlaySpeech({ Name = "/VO/Match_226", Queue = "Interrupt" })
			-- Hooh--
			elseif lastCuePlayed == "/VO/Justice_613" then
				--Hah!!
				PlaySpeech({ Name = "/VO/Match_227", Queue = "Interrupt" })
			-- Mmm--
			elseif lastCuePlayed == "/VO/Justice_614" then
				--Yess!
				PlaySpeech({ Name = "/VO/Match_228", Queue = "Interrupt" })
			-- Haah--
			elseif lastCuePlayed == "/VO/Justice_615" then
				--Hah, hah!
				PlaySpeech({ Name = "/VO/Match_229", Queue = "Interrupt" })
			-- Come on--
			elseif lastCuePlayed == "/VO/Justice_616" then
				--Hmm.
				PlaySpeech({ Name = "/VO/Match_230", Queue = "Interrupt" })
			-- Shall it be--
			elseif lastCuePlayed == "/VO/Justice_617" then
				--Indeed!
				PlaySpeech({ Name = "/VO/Match_231", Queue = "Interrupt" })
			-- Nnnn--
			elseif lastCuePlayed == "/VO/Match_1223" then
				--Naah!
				PlaySpeech({ Name = "/VO/Match_1224", Queue = "Interrupt" })
			-- Hrrrr--
			elseif lastCuePlayed == "/VO/Match_1226" then
				--Raah, hah!
				PlaySpeech({ Name = "/VO/Match_1227", Queue = "Interrupt" })
			-- Now--
			elseif lastCuePlayed == "/VO/Match_1229" then
				--Waah!
				PlaySpeech({ Name = "/VO/Match_1230", Queue = "Interrupt" })
			-- Rnnghh--
			elseif lastCuePlayed == "/VO/Match_1232" then
				--Ho, hoh!
				PlaySpeech({ Name = "/VO/Match_1233", Queue = "Interrupt" })
			-- Do it--
			elseif lastCuePlayed == "/VO/Match_1235" then
				--Done!
				PlaySpeech({ Name = "/VO/Match_1236", Queue = "Interrupt" })
			-- There--
			elseif lastCuePlayed == "/VO/Match_1238" then
				--Righteous!
				PlaySpeech({ Name = "/VO/Match_1239", Queue = "Interrupt" })
			-- Ohhh--
			elseif lastCuePlayed == "/VO/Match_1241" then
				--Wah!
				PlaySpeech({ Name = "/VO/Match_1242", Queue = "Interrupt" })
			end
		else
			PlayRemainingSpeech( SpeechSet.SomeoneDramaticScores )
		end
    end

    SpeechSet.SomeoneScoresLastHitShield =
    {
		-- The dying flames... survive!
	    "/VO/Match_252",
		-- Divine intervention!
	    "/VO/Match_253",
		-- Beyond all reason, the flames yet burn!
	    "/VO/Match_254",
		-- A sacred miracle has kept the flames alive!
	    "/VO/Match_255",
		-- The flames withstood what ought have put them out!
	    "/VO/Match_256",
		-- A blessing keeps the Pyre burning hot!
	    "/VO/Match_257",
	}
    function SomeoneScoresLastHitShieldAudio()
		if blockMatchVO then
			return
		end
		if pyreShieldAudioPlayedThisMatch then
			return
		end
		pyreShieldAudioPlayedThisMatch = true
	    wait(0.55)
		PlayRemainingSpeech( SpeechSet.SomeoneScoresLastHitShield, nil, "Interrupt" )
    end

	-- **Local MP / Head2Head: Killing / Banishmeent VO**
    SpeechSet.SomeoneWithBallBanished =
    {
		-- A banishment.
		"/VO/Justice_634",
		-- Another banishment.
		"/VO/Justice_635",
		-- Banished.
		"/VO/Justice_636",
		-- Banished from this place.
		"/VO/Justice_637",
		-- Banishment.
		"/VO/Justice_638",
		-- Bye now!
		"/VO/Justice_639",
		-- Engulfed within the Aura.
		"/VO/Justice_640",
		-- Too bad for that one.
		"/VO/Justice_641",
		-- How sad for that one there.
		"/VO/Justice_642",
		-- The Orb's unclaimed again!
		"/VO/Justice_643",
		-- The Orb slips from your clutches!
		"/VO/Justice_644",
		-- Somebody get the Orb!
		"/VO/Justice_645",
		-- The Orb!
		"/VO/Justice_646",
		-- There goes the Orb!
		"/VO/Justice_647",
		-- Someone grasp the Orb!
		"/VO/Justice_667",
    }
    function SomeoneWithBallBanishedAudio()
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			if CoinFlip() then
				PlaySound({ Name = "/SFX/Match SFX/ImpCrowdLaugh", Delay = 0.25 })
			end
		end
	    wait(0.45)
		if blockMatchVO then
			return
		end
		if someoneScored then
			return
		end
		if archJusticeSpokeRecently then
			return
		end
	    PlayRemainingSpeech( SpeechSet.SomeoneWithBallBanished )
		thread( ArchJusticeSpeaking )
    end

    SpeechSet.SomeoneWithBallBanishedNearGoal =
    {
		-- Twas dangerously close.
		"/VO/Justice_648",
		-- That one almost got through.
		"/VO/Justice_649",
		-- Quite the close call there, no?
		"/VO/Justice_650",
		-- Someone there rose to the occasion.
		"/VO/Justice_651",
		-- If I were that one I'd be rather angry.
		"/VO/Justice_652",
		-- A stifled effort.
		"/VO/Justice_653",
		-- Well now that was exciting.
		"/VO/Justice_654",
		-- A deftly-thwarted drive.
		"/VO/Justice_655",
		-- A mere attempt.
		"/VO/Justice_656",
		-- I almost pity what transpired there.
		"/VO/Justice_657",
		-- An interesting exchange.
		"/VO/Justice_658",
    }
    function SomeoneWithBallBanishedNearGoalAudio()
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			if CoinFlip() then
				PlaySound({ Name = "/SFX/Match SFX/ImpCrowdDisappointed", Delay = 0.25 })
			end
		end
	    wait(0.45)
		if blockMatchVO then
			return
		end
		if someoneScored then
			return
		end
		if archJusticeSpokeRecently then
			return
		end
	    PlayRemainingSpeech( SpeechSet.SomeoneWithBallBanishedNearGoal )
		thread( ArchJusticeSpeaking )
    end

    SpeechSet.SomeoneBanishedByEnvironment =
    {
		-- A banishment.
		"/VO/Justice_634",
		-- One careless step.
		"/VO/Justice_659",
		-- Down goes that one.
		"/VO/Justice_660",
		-- Tread lightly.
		"/VO/Justice_661",
		-- How careless.
		"/VO/Justice_662",
		-- Poor exile.
		"/VO/Justice_663",
		-- One false move.
		"/VO/Justice_664",
    }
    function SomeoneBanishedByEnvironmentAudio()
	    wait(0.45)
		if blockMatchVO then
			return
		end
		if someoneScored then
			return
		end
		if archJusticeSpokeRecently then
			return
		end
	    PlayRemainingSpeech( SpeechSet.SomeoneBanishedByEnvironment )
		thread( ArchJusticeSpeaking )
    end

	-- **LocalMP / Head2Head**
	-- LocalMP Start
	SpeechSet.VersusModeAttract =
	{
		-- Let us conduct the Rites.
		"/VO/Match_1188",
		-- The Rites shall soon commence.
		"/VO/Match_1189",
		-- Prepare now for the Rites.
		"/VO/Match_1190",
		-- Let us begin, shall we?
		"/VO/Match_1191",
		-- Salutations.
		"/VO/Match_1192",
		-- I bid you welcome.
		"/VO/Match_1193",
		-- Whose Pyre shall burn through the night?
		"/VO/Match_1194",
		-- Prepare the ceremony.
		"/VO/Match_1195",
		-- Pyre.
		-- "/VO/Match_1196",
	}
	function VersusModeAttractAudio()
		waitScreenTime(0.45)
		PlayRemainingSpeech( SpeechSet.VersusModeAttract )
	end

	-- LocalMP Team Versus Team
	SpeechSet.VersusStatements =
	{
		-- ...versus...
		"/VO/Match_1197",
		-- ...shall confront...
		"/VO/Match_1198",
		-- ...shall now face...
		"/VO/Match_1199",
		-- ...shall take on...
		"/VO/Match_1200",
	}
	function LocalMPVersusIntroAudio()
		wait(0.25)
		if TeamA ~= nil and TeamB ~= nil and TeamA.TeamAVersusLineNames ~= nil and TeamB.TeamBVersusLineNames ~= nil then
			local teamASpeechCue = GetRandomRemainingData( TeamA.TeamAVersusLineNames )
			local teamBSpeechCue = GetRandomRemainingData( TeamB.TeamBVersusLineNames )
			local versusStatement = GetRandomRemainingData( SpeechSet.VersusStatements )
			PlaySpeech({ Name = teamASpeechCue, Queue = "Always" })
			-- imp crowd
			if GetMapName({ }) == "MatchSiteJ" then
				if CoinFlip() then
					PlaySound({ Name = "/SFX/Match SFX/ImpCrowdCheer", Delay = 0.55 })
				else
					PlaySound({ Name = "/SFX/Match SFX/ImpCrowdJeer", Delay = 0.55 })
				end
			end
			waitUntil( teamASpeechCue )
			wait(0.35)
			PlaySpeech({ Name = versusStatement, Queue = "Always" })
			waitUntil( versusStatement )
			wait(0.35)
			PlaySpeech({ Name = teamBSpeechCue, Queue = "Always" })
			-- imp crowd
			if GetMapName({ }) == "MatchSiteJ" then
				if CoinFlip() then
					PlaySound({ Name = "/SFX/Match SFX/ImpCrowdCheer", Delay = 0.55 })
				else
					PlaySound({ Name = "/SFX/Match SFX/ImpCrowdJeer", Delay = 0.55 })
				end
			end
		end
	end

	-- **LocalMP Match Intros**
    SpeechSet.LocalMPIntroA =
	{
		-- I bid you welcome, Exiles!
		"/VO/Match_627",
		-- Welcome, Exiles!
		"/VO/Match_628",
		-- Stand forth, Exiles!
		"/VO/Match_629",
		-- Hear me, Exiles!
		"/VO/Match_630",
		-- Greetings, Exiles!
		"/VO/Match_631",
		-- Good evening, Exiles!
		"/VO/Match_632",
		-- The time is nigh, Exiles!
		"/VO/Match_633",
		-- Why, hello, Exiles!
		"/VO/Match_634",
		-- Hark, Exiles!
		"/VO/Match_635",
	}
    SpeechSet.LocalMPIntroB_MatchSiteA =
	{
		-- Welcome to the Book of Rites.
		"/VO/Match_636",
		-- You stand within the Book of Rites itself.
		"/VO/Match_637",
		-- You heed the summons to the Book of Rites.
		"/VO/Match_638",
		-- You are gathered here within the Book of Rites.
		"/VO/Match_639",
	}
    SpeechSet.LocalMPIntroB_MatchSiteB =
	{
		-- Welcome to the Ridge of Gol.
		"/VO/Match_640",
		-- You stand upon the Ridge of Gol.
		"/VO/Match_641",
		-- You heed the summons to the Ridge of Gol.
		"/VO/Match_642",
		-- You are gathered at the Ridge of Gol.
		"/VO/Match_643",
	}
    SpeechSet.LocalMPIntroB_MatchSiteC =
	{
		-- Welcome to the Spring of Jomuer.
		"/VO/Match_644",
		-- You stand upon the Spring of Jomuer.
		"/VO/Match_645",
		-- You heed the summons to the Spring of Jomuer.
		"/VO/Match_646",
		-- You are gathered at the Spring of Jomuer.
		"/VO/Match_647",
	}
    SpeechSet.LocalMPIntroB_MatchSiteD =
	{
		-- Welcome to the Cairn of Ha'ub.
		"/VO/Match_648",
		-- You stand upon the Cairn of Ha'ub.
		"/VO/Match_649",
		-- You heed the summons to the Cairn of Ha'ub.
		"/VO/Match_650",
		-- You are gathered at the Cairn of Ha'ub.
		"/VO/Match_651",
	}
    SpeechSet.LocalMPIntroB_MatchSiteE =
	{
		-- Welcome to the Pit of Milithe.
		"/VO/Match_652",
		-- You stand upon the Pit of Milithe.
		"/VO/Match_653",
		-- You heed the summons to the Pit of Milithe.
		"/VO/Match_654",
		-- You are gathered at the Pit of Milithe.
		"/VO/Match_655",
	}
    SpeechSet.LocalMPIntroB_MatchSiteF =
	{
		-- Welcome to the Hulk of Ores.
		"/VO/Match_656",
		-- You stand upon the Hulk of Ores.
		"/VO/Match_657",
		-- You heed the summons to the Hulk of Ores.
		"/VO/Match_658",
		-- You are gathered at the Hulk of Ores.
		"/VO/Match_659",
	}
    SpeechSet.LocalMPIntroB_MatchSiteG =
	{
		-- Welcome to the Nest of Triesta.
		"/VO/Match_660",
		-- You stand upon the Nest of Triesta.
		"/VO/Match_661",
		-- You heed the summons to the Nest of Triesta.
		"/VO/Match_662",
		-- You are gathered at the Nest of Triesta.
		"/VO/Match_663",
	}
    SpeechSet.LocalMPIntroB_MatchSiteH =
	{
		-- Welcome to the Glade of Lu.
		"/VO/Match_664",
		-- You stand upon the Glade of Lu.
		"/VO/Match_665",
		-- You heed the summons to the Glade of Lu.
		"/VO/Match_666",
		-- You are gathered at the Glade of Lu.
		"/VO/Match_667",
	}
    SpeechSet.LocalMPIntroB_MatchSiteI =
	{
		-- Welcome to the Fall of Soliam.
		"/VO/Match_668",
		-- You stand upon the Fall of Soliam.
		"/VO/Match_669",
		-- You heed the summons to the Fall of Soliam.
		"/VO/Match_670",
		-- You are gathered at the Fall of Soliam.
		"/VO/Match_671",
	}
    SpeechSet.LocalMPIntroB_MatchSiteJ =
	{
		-- Welcome to the Isle of Khaylmer.
		"/VO/Match_672",
		-- You stand upon the Isle of Khaylmer.
		"/VO/Match_673",
		-- You heed the summons to the Isle of Khaylmer.
		"/VO/Match_674",
		-- You are gathered at the Isle of Khaylmer.
		"/VO/Match_675",
	}
    SpeechSet.LocalMPIntroC =
	{
		-- Here, you may yet prove your worth.
		"/VO/Match_676",
		-- You shall take part here in a glorious tradition.
		"/VO/Match_677",
		-- You have this opportunity to prove your worth.
		"/VO/Match_678",
		-- At stake here in this Rite is your salvation.
		"/VO/Match_679",
		-- Here you may step closer to achieving freedom.
		"/VO/Match_680",
		-- Here you shall be tested by your adversary.
		"/VO/Match_681",
		-- You now have this chance to prove yourselves.
		"/VO/Match_1286",
		-- You are gathered... to conduct this Rite.
		"/VO/Match_683",
		-- Have you the fortitude required to prevail?
		"/VO/Match_684",
		-- Here one of you may walk the path to glory.
		"/VO/Match_685",
		-- Each of you seeks to be free from this forsaken land.
		"/VO/Justice_471",
	}
    SpeechSet.LocalMPIntroD =
	{
		-- Let us see which one of you is more deserving.
		"/VO/Match_686",
		-- We soon shall see who is the most deserving.
		"/VO/Match_687",
		-- Let us determine which of you is the superior.
		"/VO/Match_688",
		-- Try not to let the pressure get to you.
		"/VO/Match_689",
		-- May further shame befall whomever fails.
		"/VO/Match_690",
		-- Prevail, and earn the favor of the Scribes.
		"/VO/Match_691",
		-- Cling to whatever shred of hope you have.
		"/VO/Match_692",
		-- Only the righteous shall emerge victorious.
		"/VO/Match_693",
		-- Know that the Scribes themselves are watching.
		"/VO/Match_694",
		-- The stars themselves shall be your witnesses.
		"/VO/Match_695",
		-- Prevail, and step closer to freedom.
		"/VO/Justice_468",
	}
    SpeechSet.LocalMPIntroE =
	{
		-- Now prepare yourselves.
		"/VO/Match_696",
		-- Now let us begin.
		"/VO/Match_697",
		-- Now we shall get started.
		"/VO/Match_698",
		-- Now let us get started.
		"/VO/Match_699",
	}
    function LocalMPMatchStartVO()
		if blockMatchVO then
			return
		end
		-- skip all this for short intro
		if GetConfigOptionValue({ Name = "LocalMPIntroPresentation" }) ~= "LocalMP_Intro_Long" or ForceShortIntro then
			return
		end
		wait(1.25)
		PlaySound({ Name = "/SFX/Match SFX/AnnouncementThunder" })
		wait(0.75)
		PlayRemainingSpeech( SpeechSet.LocalMPIntroA, nil, "Always" )
    end
    function LocalMPIntroBAudio()
		if blockMatchVO then
			return
		end
		wait(0.95)
		local map = GetMapName({ })
		local speechCue = nil
		if map == "MatchSiteA" then
			speechCue = PlayRemainingSpeech( SpeechSet.LocalMPIntroB_MatchSiteA, nil, "Always" )
		elseif map == "MatchSiteB" then
			speechCue = PlayRemainingSpeech( SpeechSet.LocalMPIntroB_MatchSiteB, nil, "Always" )
		elseif map == "MatchSiteC" then
			speechCue = PlayRemainingSpeech( SpeechSet.LocalMPIntroB_MatchSiteC, nil, "Always" )
		elseif map == "MatchSiteD" then
			speechCue = PlayRemainingSpeech( SpeechSet.LocalMPIntroB_MatchSiteD, nil, "Always" )
		elseif map == "MatchSiteE" then
			speechCue = PlayRemainingSpeech( SpeechSet.LocalMPIntroB_MatchSiteE, nil, "Always" )
		elseif map == "MatchSiteF" then
			speechCue = PlayRemainingSpeech( SpeechSet.LocalMPIntroB_MatchSiteF, nil, "Always" )
		elseif map == "MatchSiteG" then
			speechCue = PlayRemainingSpeech( SpeechSet.LocalMPIntroB_MatchSiteG, nil, "Always" )
		elseif map == "MatchSiteH" then
			speechCue = PlayRemainingSpeech( SpeechSet.LocalMPIntroB_MatchSiteH, nil, "Always" )
		elseif map == "MatchSiteI" then
			speechCue = PlayRemainingSpeech( SpeechSet.LocalMPIntroB_MatchSiteI, nil, "Always" )
		elseif map == "MatchSiteJ" then
			speechCue = PlayRemainingSpeech( SpeechSet.LocalMPIntroB_MatchSiteJ, nil, "Always" )
		end
		waitUntil( speechCue )
		LocalMPIntroCAudio()
    end
    function LocalMPIntroCAudio()
		if blockMatchVO then
			return
		end
		wait(0.95)
		PlayRemainingSpeech( SpeechSet.LocalMPIntroC, nil, "Always" )
    end
    function LocalMPIntroDAudio()
		if blockMatchVO then
			return
		end
		wait(1.05)
		PlayRemainingSpeech( SpeechSet.LocalMPIntroD, nil, "Always" )
    end
    function LocalMPIntroEAudio()
		if blockMatchVO then
			return
		end
		wait(1.1)
		PlayRemainingSpeech( SpeechSet.LocalMPIntroE, nil, "Always" )
    end

	-- **LocalMP / Head2Head: Match Ends VO**
    SpeechSet.RedTeamPyreExtinguished =
    {
		-- And it is done!
		"/VO/Justice_571",
	}
    function RedTeamPyreExtinguishedAudio()
		if blockMatchVO then
			return
		end
		PlayRemainingSpeech( SpeechSet.RedTeamPyreExtinguished, nil, "Always" )
    end

    SpeechSet.BlueTeamPyreExtinguished =
    {
		-- And it is done!
		"/VO/Justice_571",
    }
    function BlueTeamPyreExtinguishedAudio()
		if blockMatchVO then
			return
		end
		PlayRemainingSpeech( SpeechSet.BlueTeamPyreExtinguished, nil, "Always" )
    end

    SpeechSet.MiscPyreExtinguished =
    {
		-- The final blow is struck!
		-- "/VO/Justice_569",
		-- A Pyre is put out!
		-- "/VO/Justice_570",
		-- And it is done!
		-- "/VO/Justice_571",
		-- Thus ends the ceremony!
		-- "/VO/Justice_572",
		-- The Rite is hereby ended!
		-- "/VO/Justice_573",
		-- The tradition is upheld!
		-- "/VO/Justice_574",
		-- And it is done.
		"/VO/Justice_36",
    }
    SpeechSet.AscensionPyreExtinguished =
    {
		-- And, there it is, at last.
	    "/VO/Match_555",
    }
    function MiscPyreExtinguishedAudio()
		if blockMatchVO then
			return
		end
		if ascensionMatch then
			-- Pyre Extinguished - Ascension Match
			PlayRemainingSpeech( SpeechSet.AscensionPyreExtinguished, nil, "Always" )
		elseif forfeitMatch then
			-- Pyre Extinguished - Forfeit Match
			-- And it is done...
			PlaySpeech({ Name = "/VO/Justice_978", Queue = "Always" })
		else
			-- Pyre Extinguished - Standard Match
			PlayRemainingSpeech( SpeechSet.MiscPyreExtinguished, nil, "Always" )
		end
    end

	-- **Local MP / Head2Head: Possession VO**
    SpeechSet.SomeonePossesses =
    {
		-- That's it!
		"/VO/Justice_498",
		-- Now...!
		"/VO/Justice_499",
		-- Good.
		"/VO/Justice_500",
		-- Hmm.
		"/VO/Justice_501",
		-- Yes!
		"/VO/Justice_502",
		-- Into the adversary's flame.
		"/VO/Justice_503",
		-- Ah-hah!
		"/VO/Justice_504",
		-- The Orb is taken!
		"/VO/Justice_505",
		-- Now then!
		"/VO/Justice_506",
		-- There!
		"/VO/Justice_507",
		-- The Orb!
		"/VO/Justice_508",
		-- There!
		"/VO/Match_416",
		-- Now go!
		"/VO/Match_528",
		-- Hohh.
		"/VO/Match_529",
		-- Tis taken!
		"/VO/Match_530",
		-- Now to the flame!
		"/VO/Match_531",
		-- The Orb is up!
		"/VO/Match_532",
    }
    function SomeonePossessesAudio()
	    wait(0.2)
		if blockMatchVO then
			return
		end
		if archJusticeSpokeRecently then
			return
		end
	    PlayRemainingSpeech( SpeechSet.SomeonePossesses )
		thread( ArchJusticeSpeaking )
    end

	-- **Local MP / Head2Head: Player Killing VO**
    SpeechSet.SomeoneMultiKill =
    {
		-- Such fervor!
		"/VO/Justice_587",
		-- No mercy shown.
		"/VO/Justice_588",
		-- Mm indeed!
		"/VO/Justice_589",
		-- So fiercely fought!
		"/VO/Justice_590",
		-- Audacious, aren't we.
		"/VO/Justice_591",
		-- Twas almost cruel.
		"/VO/Justice_592",
		-- Oh-hohoho.
		"/VO/Justice_593",
		-- Ah-hahaha-hah.
		"/VO/Justice_594",
		-- Ferocity unbridled!
		"/VO/Justice_595",
		-- Simply monstrous.
		"/VO/Justice_596",
    }
    function SomeoneMultiKillAudio()
	    wait(0.3)
		if blockMatchVO then
			return
		end
		if someoneScored then
			return
		end
		if archJusticeSpokeRecently then
			return
		end
	    PlayRemainingSpeech( SpeechSet.SomeoneMultiKill )
		thread( ArchJusticeSpeaking )
    end

    SpeechSet.TeamFullWipe =
    {
		-- That was the last of them!
		"/VO/Match_909",
		-- One triumvirate stands unopposed!
		"/VO/Match_910",
		-- All banished.
		"/VO/Match_911",
		-- Banished, all of them.
		"/VO/Match_912",
		-- Banished, one and all.
		"/VO/Match_913",
		-- Why that was all of them.
		"/VO/Match_914",
		-- Banishment for all!
		"/VO/Match_915",
		-- Thoroughly banished.
		"/VO/Match_916",
		-- United in banishment.
		"/VO/Match_917",
		-- more in team data
	}
    function TeamFullWipeAudio( wipedTeam )
		if wipedTeam == nil then
			return
		end
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			if CoinFlip() then
				PlaySound({ Name = "/SFX/Match SFX/ImpCrowdBigLaugh", Delay = 0.15 })
			else
				PlaySound({ Name = "/SFX/Match SFX/ImpCrowdCheer", Delay = 0.15 })
			end
		end
	    wait(0.35)
		if blockMatchVO then
			return
		end
		if archJusticeHootedRecently then
			return
		end
		if someoneScored then
			return
		end
		if not IsWholeTeamDead( wipedTeam ) then
			return
		end
		local allLines = CombineAllValues({ wipedTeam.TeamFullWipeLines, SpeechSet.TeamFullWipe })
	    PlayRemainingSpeech( allLines )
		thread( ArchJusticeHooting )
    end

    SpeechSet.MashWhileBanished =
    {
		-- Your fellow exiles remain banished.
		"/VO/Match_918",
		-- You are powerless for now.
		"/VO/Match_919",
		-- Flailing shan't do anything, Reader.
		"/VO/Match_920",
		-- Struggle all you like, Reader.
		"/VO/Match_921",
		-- Patience, Reader.
		"/VO/Match_922",
		-- So sorry for the wait, there, Reader.
		"/VO/Match_923",
		-- Your exiles all are banished, I'm afraid.
		"/VO/Match_924",
		-- Not much to be done whilst all are banished.
		"/VO/Match_925",
		-- Your exiles shall return erelong.
		"/VO/Match_926",
	}
    function MashWhileBanishedAudio()
	    wait(0.35)
		if blockMatchVO then
			return
		end
		if someoneScored then
			return
		end
		if GetMapName({ }) == "ScenarioRetrieval" or GetMapName({ }) == "ScenarioDefense" then
			return
		end
		if archJusticeHootedRecently then
			return
		end
	    PlayRemainingSpeech( SpeechSet.MashWhileBanished )
		thread( ArchJusticeHooting )
    end

    SpeechSet.RematchPrompt =
    {
		-- Wish you to have another chance?
		"/VO/Match_959",
		-- Do you wish to strive again?
		"/VO/Match_960",
		-- Would you face your adversary once again?
		"/VO/Match_961",
		-- Dare you to confront your foe once more?
		"/VO/Match_962",
		-- Care to have another shot?
		"/VO/Match_963",
	}
    function RematchPromptAudio()
	    wait(0.35)
		if blockMatchVO then
			return
		end
	    PlayRemainingSpeech( SpeechSet.RematchPrompt )
		thread( ArchJusticeHooting )
    end

	-- **Standard: Match Ends VO**
    SpeechSet.OpposingPyreExtinguished =
    {
		-- The stars themselves alight in splendor!
		-- "/VO/Match_382",
		-- A glorious performance I admit.
		-- "/VO/Match_383",
		-- The adversaries' Pyre is extinguished.
		"/VO/Justice_447",
		-- The adversaries' Pyre is put out.
		"/VO/Justice_448",
	}
    function OpposingPyreExtinguishedAudio()
		if blockMatchVO then
			return
		end
	    wait(0.75)
		PlayRemainingSpeech( SpeechSet.OpposingPyreExtinguished )
    end

    SpeechSet.PlayerPyreExtinguished =
    {
		-- Your Pyre has been extinguished.
		"/VO/Justice_445",
		-- Your Pyre is put out.
		"/VO/Justice_446",

    }
    function PlayerPyreExtinguishedAudio()
		if blockMatchVO then
			return
		end
	    wait(0.75)
		PlayRemainingSpeech( SpeechSet.PlayerPyreExtinguished )
    end

	-- VO for Taking the Lead / Losing the Lead
    SpeechSet.PlayerTakesLead =
    {
		-- Your Pyre burns brighter, for the while.
	    "/VO/Match_405",
		-- Your adversariers' Pyre now falls short of yours.
	    "/VO/Match_406",
		-- Do you believe you can prevail in this?
	    "/VO/Match_407",
		-- The Accusers' Pyre grows weaker.
	    -- "/VO/Match_408",
		-- Perhaps you are worthy.
	    "/VO/Justice_101",
		-- This is the path to glory!
	    "/VO/Justice_102",
		-- The Nightwings shall prevail at this rate.
		"/VO/Justice_554",
		-- The Nightwings now are closer to achieving victory.
		"/VO/Justice_555",
		-- I wonder shall the Nightwings press their luck?
		"/VO/Justice_556",
		-- Best not get overconfident, Nightwings.
		"/VO/Justice_557",
		-- Let's see you Nightwings keep this up.
		"/VO/Justice_558",
		-- The Nightwings' Pyre burns brighter for now.
		"/VO/Match_522",
		-- The Nightwings edge closer to victory.
		"/VO/Match_523",
		-- It seems the Nightwings are a bit ahead.
		"/VO/Match_524",
    }
	if NextTeam ~= nil then
		if NextTeam.LeagueIndex == 2 then
		-- The Accusers' Pyre grows weaker.
		table.insert(SpeechSet.PlayerTakesLead, "/VO/Match_408")
		else
			-- The Accusers' Pyre grows weaker.
			RemoveValue(SpeechSet.PlayerTakesLead, "/VO/Match_408")
		end
	end
    function PlayerTakesLeadAudio()
		if blockMatchVO then
			return
		end
		if TeamA.NumScores + TeamB.NumScores <= 1 then
			return
		end
	    wait(5.85)
		if IsScreenOpen({ Name = "DialogueScreen" }) then
			return
		end
	    PlayRemainingSpeech( SpeechSet.PlayerTakesLead )
    end

    SpeechSet.PlayerLosesLead =
    {
		-- You seem unable to stop these people.
	    "/VO/Match_411",
		-- Your adversaries' Pyre now burns brighter than your own.
	    "/VO/Match_412",
		-- Perhaps you are unworthy.
	    "/VO/Justice_103",
		-- This is the road to ruin.
	    "/VO/Justice_104",
		-- Your Pyre shall soon be ashes on the ground.
	    "/VO/Match_409",
		-- The Nightwings seem to be falling behind.
		"/VO/Match_525",
		-- The Nightwings' adversaries gained an edge.
		"/VO/Match_526",
		-- A show of strength from the Nightwings' opponents.
		"/VO/Match_527",
		-- Your Pyre is beginning to look a bit thin.
	    -- "/VO/Match_410",
    }
    function PlayerLosesLeadAudio()
		if blockMatchVO then
			return
		end
		if TeamA.NumScores + TeamB.NumScores <= 1 then
			return
		end
	    wait(5.85)
		if IsScreenOpen({ Name = "DialogueScreen" }) then
			return
		end
	    PlayRemainingSpeech( SpeechSet.PlayerLosesLead )
    end

    SpeechSet.MatchPoint =
    {
		-- The Rite is nearly ended!
		"/VO/Match_244",
		-- Now, go on, just once more!
		"/VO/Match_245",
		-- Your victory's at hand!
		-- "/VO/Match_246",
		-- Once more, like that, and we are finished here!
		"/VO/Match_247",
		-- No more than a lick of flame remains!
		"/VO/Match_248",
		-- Now, end the ceremony!
		"/VO/Match_249",
    }
	if not IsMultiplayerMatch() then
		table.insert( SpeechSet.MatchPoint, "/VO/Match_246" )
	end
    SpeechSet.MatchPointCloseMatch =
    {
		-- Someone prevail, already!
		"/VO/Match_250",
		-- Come now, someone end this!
		"/VO/Match_251",
    }
    function MatchPointAudio()
		if blockMatchVO then
			return
		end
		if introMatch then
			return
		end
	    wait(5.75)
		if IsScreenOpen({ Name = "DialogueScreen" }) then
			return
		end
		if TeamA.PyreHealth <= 10 and TeamB.PyreHealth <= 10 and not closeMatchPointAudioPlayed then
			PlayRemainingSpeech( SpeechSet.MatchPointCloseMatch )
			closeMatchPointAudioPlayed = true
		else
			if not matchPointAudioPlayed then
				PlayRemainingSpeech( SpeechSet.MatchPoint )
				matchPointAudioPlayed = true
			end
		end
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			local cheers = { "/SFX/Match SFX/ImpCrowdChantLoop_1", "/SFX/Match SFX/ImpCrowdChantLoop_2", "/SFX/Match SFX/ImpCrowdChantLoop_3", "/SFX/Match SFX/ImpCrowdChantLoop_4", "/SFX/Match SFX/ImpCrowdChantSpeedUpCheer" }
			local cheerSound = GetRandomValue( cheers )
			PlaySound({ Name = cheerSound, Delay = 1.0 })
			if not intenseAmbience then
				SwitchSecondaryAmbience( "/SFX/Match SFX/ImpCrowdLoopIntense" )
				intenseAmbience = true
			end
		end
    end

	-- **Post-Match**
	-- PostMatch Screen Opens
    SpeechSet.PostMatchBegins =
    {
		-- Bask now in the wisdom of the Scribes.
	    "/VO/Justice_286",
		-- There is much to learn from this experience.
	    "/VO/Justice_681",
		-- The Rites do tend to teach something of trust.
	    "/VO/Justice_682",
		-- Boundless are the teachings of the Scribes.
	    "/VO/Justice_683",
		-- What stirs now in the hearts of all these exiles?
	    "/VO/Justice_684",
		-- The Eight Scribes bless us with their ways.
	    "/VO/Justice_685",
		-- Always is there greater knowledge to be gained.
	    "/VO/Justice_686",
	}
    function PostMatchBeginsAudio()
		wait(0.35)
		if blockMatchVO then
			return
		end
		PlayNextRemainingSpeech( SpeechSet.PostMatchBegins )
    end

    SpeechSet.SkillPickedPlayerMedium =
	{
		-- The Master-General reveals his strategem.
		"/VO/Match_717",
		-- Praise be to Gol Golathanian.
		"/VO/Match_718",
	}
    SpeechSet.SkillPickedPlayerLarge =
	{
		-- The Demon Scribe bestows his favor.
		"/VO/Match_719",
		-- Praise be to Soliam Murr.
		"/VO/Match_720",
	}
    SpeechSet.SkillPickedPlayerSmall =
	{
		-- A blessing from the Alpha-Chief himself!
		"/VO/Match_721",
		-- Praise be to Jomuer Many-Mane.
		"/VO/Match_722",
	}
    SpeechSet.SkillPickedPlayerMediumAlt =
	{
		-- A devious trick from the Rope-Caller.
		"/VO/Match_723",
		-- Forever cursed is Khaylmer Rope-Caller.
		"/VO/Match_724",
	}
    SpeechSet.SkillPickedPlayerImp =
	{
		-- Tis the influence of the Imp Scribe.
		"/VO/Match_725",
		-- Praise be to Ha'ub the Swallow.
		"/VO/Match_726",
	}
    SpeechSet.SkillPickedPlayerTrail =
	{
		-- The might of the Sea-Sojourner.
		"/VO/Match_727",
		-- Praise be to Underking Ores.
		"/VO/Match_728",
	}
    SpeechSet.SkillPickedPlayerFlying =
	{
		-- The holy power of the Eldest Matriarch.
		"/VO/Match_729",
		-- Praise be to Saint Triesta.
		"/VO/Match_730",
	}
    SpeechSet.SkillPickedPlayerTree =
	{
		-- Tis the wisdom of old Hundred-Minds.
		"/VO/Match_731",
		-- Praise be to Lu Sclorian.
		"/VO/Match_732",
	}
    SpeechSet.SkillPickedPlayerMonster =
	{
		-- The secrets of the Wild Witch, revealed.
		"/VO/Match_733",
		-- Praise be to Molten Milithe.
		"/VO/Match_734",
	}
	function SkillPickedAudio()
		if blockMatchVO then
			return
		end
		if IsMultiplayerMatch() then
			return
		end
		if GetMapName({ }) == "Campaign" then
			return
		end
		waitScreenTime(0.65)
		if NewSkillData == nil then
			return
		end
		-- Hedwyn skill choice
		if NewSkillData.Tree == "PlayerMediumA" or NewSkillData.Tree == "PlayerMediumB" then
			PlayNextRemainingSpeech( SpeechSet.SkillPickedPlayerMedium )
		-- Jodi skill choice
		elseif NewSkillData.Tree == "PlayerLargeA" or NewSkillData.Tree == "PlayerLargeB" then
			PlayNextRemainingSpeech( SpeechSet.SkillPickedPlayerLarge )
		-- Rukey skill choice
		elseif NewSkillData.Tree == "PlayerSmallA" or NewSkillData.Tree == "PlayerSmallB" then
			PlayNextRemainingSpeech( SpeechSet.SkillPickedPlayerSmall )
		-- Mae skill choice
		elseif NewSkillData.Tree == "PlayerMediumAltA" or NewSkillData.Tree == "PlayerMediumAltB" then
			PlayNextRemainingSpeech( SpeechSet.SkillPickedPlayerMediumAlt )
		-- Ti'zo skill choice
		elseif NewSkillData.Tree == "PlayerImpA" or NewSkillData.Tree == "PlayerImpB" then
			PlayNextRemainingSpeech( SpeechSet.SkillPickedPlayerImp )
		-- Sir Gilman skill choice
		elseif NewSkillData.Tree == "PlayerTrailA" or NewSkillData.Tree == "PlayerTrailB" then
			PlayNextRemainingSpeech( SpeechSet.SkillPickedPlayerTrail )
		-- Pamitha skill choice
		elseif NewSkillData.Tree == "PlayerFlyingA" or NewSkillData.Tree == "PlayerFlyingB" then
			PlayNextRemainingSpeech( SpeechSet.SkillPickedPlayerFlying )
		-- Volfred skill choice
		elseif NewSkillData.Tree == "PlayerTreeA" or NewSkillData.Tree == "PlayerTreeB" then
			PlayNextRemainingSpeech( SpeechSet.SkillPickedPlayerTree )
		-- Bertrude skill choice
		elseif NewSkillData.Tree == "PlayerMonsterA" or NewSkillData.Tree == "PlayerMonsterB" then
			PlayNextRemainingSpeech( SpeechSet.SkillPickedPlayerMonster )
		end
	end

	-- PostMatch: Player Rested / Rest XP
    SpeechSet.PlayerRested =
    {
		-- Respite clears the mind.
	    -- "/VO/Match_91",
		-- A flash of inspiration for next time.
	    "/VO/Justice_723",
		-- Witness the Rites firsthand, and be inspired.
	    "/VO/Justice_724",
    }
    function PlayerRestedAudio()
		wait(0.15)
		if GetMapName({ }) == "Campaign" then
			return
		end
		if blockMatchVO then
			return
		end
		if not playedRestedAudioThisMap then
			playedRestedAudioThisMap = true
			PlayRemainingSpeech( SpeechSet.PlayerRested, "noreload" )
		end
    end

	-- Player Well Rested: [ NOT IN USE 10/31/16 ]
    SpeechSet.PlayerWellRested =
    {
		-- Those who bide their time prevail.
	    "/VO/Match_92",
    }
    function PlayerWellRestedAudio()
		wait(0.15)
		if GetMapName({ }) == "Campaign" then
			return
		end
	    PlayRemainingSpeech( SpeechSet.PlayerWellRested )
    end

	-- Post-Match: Character hits level cap [ NOT IN USE 10/31/16 ]
    SpeechSet.LevelCapReached =
    {
		-- Enlightenment! A necessary step to freedom.
	    "/VO/Match_90",
    }
    function LevelCapReachedAudio()
		wait(0.15)
		if GetMapName({ }) == "Campaign" then
			return
		end
		if blockMatchVO then
			return
		end
	    PlayRemainingSpeech( SpeechSet.LevelCapReached )
    end
end }

-- LocalMP Match Intros
-- LocalMP Match Intro: Section B
OnSoundComplete{ "/VO/Match_627 /VO/Match_628 /VO/Match_629 /VO/Match_630 /VO/Match_631 /VO/Match_632 /VO/Match_633 /VO/Match_634 /VO/Match_635",
	function( triggerArgs )
		thread( LocalMPIntroBAudio )
	end
}

-- LocalMP Match Intro: Section D
OnSoundComplete{ "/VO/Match_676 /VO/Match_677 /VO/Match_678 /VO/Match_679 /VO/Match_680 /VO/Match_681 /VO/Match_682 /VO/Match_683 /VO/Match_684 /VO/Match_685 /VO/Match_1286 /VO/Justice_471",
	function( triggerArgs )
		thread( LocalMPIntroDAudio )
	end
}

-- LocalMP Match Intro: Section E
OnSoundComplete{ "/VO/Match_686 /VO/Match_687 /VO/Match_688 /VO/Match_689 /VO/Match_690 /VO/Match_691 /VO/Match_692 /VO/Match_693 /VO/Match_694 /VO/Match_695 /VO/Justice_468",
	function( triggerArgs )
		-- thread( LocalMPIntroEAudio )
		if TeamA ~= nil and TeamB ~= nil and TeamA.TeamReadyLines ~= nil and TeamB.TeamReadyLines ~= nil then
			local teamAReadyLine = GetRandomRemainingData( TeamA.TeamReadyLines )
			local teamBReadyLine = GetRandomRemainingData( TeamB.TeamReadyLines )
			PlaySpeech({ Name = teamAReadyLine, Delay = 1.2 })
			-- imp crowd
			if GetMapName({ }) == "MatchSiteJ" then
				if CoinFlip() then
					PlaySound({ Name = "/SFX/Match SFX/ImpCrowdCheer", Delay = 2.65 })
				else
					PlaySound({ Name = "/SFX/Match SFX/ImpCrowdJeer", Delay = 2.65 })
				end
			end
			waitUntil( teamAReadyLine )
			if not GetConfigOptionValue({ Name = "LocalMPTeamADraft" }) and not GetConfigOptionValue({ Name = "LocalMPTeamBDraft" }) then
				FireTrigger({ Name = "EndCurrentMusic_LocalMP" })
			end
			PlaySpeech({ Name = teamBReadyLine, Delay = 1.1 })
			-- imp crowd
			if GetMapName({ }) == "MatchSiteJ" then
				if CoinFlip() then
					PlaySound({ Name = "/SFX/Match SFX/ImpCrowdCheer", Delay = 2.65 })
				else
					PlaySound({ Name = "/SFX/Match SFX/ImpCrowdJeer", Delay = 2.65 })
				end
			end
		end
	end
}

-- "throwscore" followup
OnSoundComplete{ "/VO/Match_385",
	function( triggerArgs )
		wait(0.45)
		-- Flinging the Orb into the flames like that.
		PlaySpeech({ Name = "/VO/Justice_443" })
	end
}

OnSoundComplete{ "/VO/Justice_443",
	function( triggerArgs )
		wait(0.75)
		-- You elude banishment using such tricks.
		PlaySpeech({ Name = "/VO/Justice_444" })
	end
}

-- **IntroMatch VO**
OnSoundComplete{ "/VO/Justice_199",
	function( triggerArgs )
		wait(0.7)
		-- Tis true: You can be free again. Perhaps not you yourself but someone worthy of the privilege.
		PlaySpeech({ Name = "/VO/Justice_200" })
		wait(3.0)
		StartMatchMusic()
	end
}

--[[ Prologue: temp edit
OnSoundComplete{ "/VO/Justice_200",
	function( triggerArgs )
		wait(1.0)
		-- You witness now a vision of your predecessors, on the brink of earning back their freedom.
		PlaySpeech({ Name = "/VO/Justice_201" })
	end
}
]]--

OnSoundComplete{ "/VO/Justice_200",
	function( triggerArgs )
		wait(1.0)
		-- You witness the Rites!
		PlaySpeech({ Name = "/VO/Justice_202" })
	end
}

OnSoundComplete{ "/VO/Justice_202",
	function( triggerArgs )
		wait(1.0)
		-- An ancient competition where salvation is at stake.
		PlaySpeech({ Name = "/VO/Justice_203" })
	end
}

OnSoundComplete{ "/VO/Justice_203",
	function( triggerArgs )
		wait(1.0)
		-- But in your case? I hardly think it possible.
		PlaySpeech({ Name = "/VO/Justice_204" })
	end
}

-- Other
OnTriggerFired{ "PlayerKilledAudio",
	function( triggerArgs )
	end
}

OnTriggerFired{ "OpponentKilledAudio",
	function( triggerArgs )
	end
}

-- VO for Opponent Scoring
OnAnyLoad{ function( triggerArgs )

    SpeechSet.OpponentScoresFirst =
    {
		-- The Accusers shall prevail at this rate.
		-- "/VO/Match_302",
		-- Already does your Pyre's flame begin to flicker!
	    "/VO/Match_300",
		-- Your Pyre is the first to falter!
	    "/VO/Match_301",
		-- The Nightwings' Pyre is the first to falter!
		"/VO/Justice_514",
		-- The Orb bathes first within the Nightwings' flame!
		"/VO/Justice_516",
		-- An inauspicious start.
	    "/VO/Justice_98",
		-- Best-laid plans do oft go awry.
	    "/VO/Justice_99",
		-- The path to glory eludes us all at times.
	    "/VO/Justice_100",
		-- Your adversaries did not hesitate.
		"/VO/Match_517",
		-- Your adversaries are the first to strike!
		"/VO/Match_518",
		-- A Pyre has been scathed!
		"/VO/Match_519",
    }

	if matchesPlayed == 0 and not introMatch and not netMPMatch and not practiceMatch then
		table.insert( SpeechSet.OpponentScoresFirst, "/VO/Match_302" )
	elseif matchesPlayed == 1 then
		ResetRemainingSpeech( SpeechSet.OpponentScoresFirst )
	end

    function OpponentScoresFirstAudio()
		if blockMatchVO then
			return
		end
	    wait(0.85)
	    SetFlagFalse({ Name = "CanInterject" })

	    PlayRemainingSpeech( SpeechSet.OpponentScoresFirst, nil, "Interrupt" )
    end

    SpeechSet.OpponentScores =
    {
		-- Your Pyre weakens.
	    "/VO/Match_308",
		-- Your Pyre sputters.
	    "/VO/Match_309",
		-- Your flames grow weak.
	    "/VO/Match_310",
		-- Alas.
	    "/VO/Justice_22",
		-- Shame.
	    "/VO/Justice_23",
		-- Unfortunate.
	    "/VO/Justice_24",
		-- Tis what the Scribes ordain.
		"/VO/Justice_546",
		-- From burning flame to ash.
		"/VO/Justice_548",
		-- Glory to the Scribes!
		"/VO/Justice_542",
		-- <Laughter>
		"/VO/Match_232",
		-- There it is!
		"/VO/Match_242",
		-- The Orb quenches the flame!
		"/VO/Justice_543",
		-- That ought to wake you up.
		"/VO/Match_520",
		-- You left yourselves wide open.
		"/VO/Match_521",
    }
    function OpponentScoresAudio()
		if blockMatchVO then
			return
		end
	    wait(0.65)
	    PlayRemainingSpeech( SpeechSet.OpponentScores, nil, "Interrupt" )
	    SetFlagFalse({ Name = "CanInterject" })
    end

    local chanceToQuip = math.random(1,10)
    if chanceToQuip >= 7 then
	    -- SetFlagTrue({ Name = "CanInterject" })
    end

    SpeechSet.OpponentScoresBig =
    {
		-- A crushing blow against your Pyre.
	    "/VO/Match_311",
		-- Your Pyre cannot take much more of that.
	    "/VO/Match_312",
		-- Unacceptable.
	    "/VO/Justice_25",
		-- Disaster.
	    "/VO/Justice_26",
		-- Most foul.
	    "/VO/Justice_27",
		-- Such a display!
		"/VO/Justice_532",
		-- Well I dare say!
		"/VO/Justice_535",
		-- Now there's a proper dousing.
		"/VO/Justice_530",
		-- A decisive blow.
		"/VO/Match_426",
    }
    function OpponentScoresBigAudio()
		if blockMatchVO then
			return
		end
	    wait(0.65)
	    PlayRemainingSpeech( SpeechSet.OpponentScoresBig, nil, "Interrupt" )
    end

    SpeechSet.OpponentThrowScores =
    {
		-- Thrust straight into your flames.
	    "/VO/Match_317",
		-- The Orb was cast into your Pyre!
	    "/VO/Match_318",
		-- Their aim was true, and thus your Pyre wanes.
	    "/VO/Match_319",
		-- They simply threw it in!
	    "/VO/Match_320",
		-- A devious maneuver.
	    "/VO/Justice_520",
		-- A rather cunning trick.
	    "/VO/Justice_521",
		-- No law 'gainst throwing in the Orb.
	    "/VO/Justice_522",
		-- Did that one throw it in?
	    "/VO/Justice_524",
		-- The Orb's engulfed!
	    "/VO/Match_945",
		-- The flame is stricken!
	    "/VO/Match_946",
		-- The fires wane!
	    "/VO/Match_947",
		-- The Orb sails forth into the flame!
	    "/VO/Match_948",
		-- The Orb flies true!
	    "/VO/Match_949",
    }
    function OpponentThrowScoresAudio()
		if blockMatchVO then
			return
		end
	    wait(0.55)
		SetFlagFalse({ Name = "CanInterject" })

		PlayRemainingSpeech( SpeechSet.OpponentThrowScores, nil, "Interrupt" )

		local chanceToQuip = math.random(1,10)
		if chanceToQuip >= 6 then
			-- SetFlagTrue({ Name = "CanInterject" })
		end
    end

	-- VO for Player Getting Ball
    SpeechSet.Possession =
    {
		-- Now plunge into the flames!
	    -- "/VO/Match_413",
		-- Now for their Pyre!
	    -- "/VO/Match_414",
		-- Extinguish now their Pyre!
	    -- "/VO/Match_415",
		-- Now, toward their flames!
	    -- "/VO/Match_418",
		-- Quench now their Pyre!
	    -- "/VO/Match_419",
		-- Now then!
	    -- "/VO/Justice_107",
		-- There!
	    "/VO/Match_416",
		-- Yes!
	    "/VO/Match_417",
		-- The Orb!
	    "/VO/Match_420",
		-- Good.
	    "/VO/Justice_105",
		-- You have it!
	    "/VO/Justice_106",
		-- That's it!
		"/VO/Justice_498",
		-- Now...!
		"/VO/Justice_499",
		-- Good.
		"/VO/Justice_500",
		-- Hmm.
		"/VO/Justice_501",
		-- Yes!
		"/VO/Justice_502",
		-- Into the adversary's flame.
		-- "/VO/Justice_503",
		-- Ah-hah!
		"/VO/Justice_504",
		-- The Orb is taken!
		-- "/VO/Justice_505",
		-- Now then!
		"/VO/Justice_506",
		-- There!
		"/VO/Justice_507",
		-- The Orb!
		"/VO/Justice_508",
		-- There!
		"/VO/Match_416",
		-- Now go!
		"/VO/Match_528",
		-- Hohh.
		"/VO/Match_529",
		-- Tis taken!
		"/VO/Match_530",
		-- Now to the flame!
		"/VO/Match_531",
		-- The Orb is up!
		"/VO/Match_532",
    }
	if matchesPlayed == 0 and not introMatch and not IsMultiplayerMatch() then
		table.insert(SpeechSet.Possession, "/VO/Match_413")
		table.insert(SpeechSet.Possession, "/VO/Match_414")
		table.insert(SpeechSet.Possession, "/VO/Match_415")
		table.insert(SpeechSet.Possession, "/VO/Match_418")
		table.insert(SpeechSet.Possession, "/VO/Match_419")
		table.insert(SpeechSet.Possession, "/VO/Justice_107")
	end
    function PlayerPossessionAudio()
	    wait(0.3)
		if blockMatchVO then
			return
		end
		if archJusticeSpokeRecently then
			return
		end
		if CoinFlip() then
			return
		end
	    PlayRemainingSpeech( SpeechSet.Possession )
		thread( ArchJusticeSpeaking )
    end

	-- VO for All Players Banished
    SpeechSet.AllPlayerUnitsBanished =
    {
		-- A shameful outcome.
	    "/VO/Justice_41",
		-- Pathetic.
		"/VO/Justice_49",
		-- Beneath contempt.
		"/VO/Justice_50",
		-- Simply abhorrent.
		"/VO/Justice_51",
		-- Wherever did the Nightwings go?
		"/VO/Justice_575",
		-- Tough luck, Nightwings.
		"/VO/Justice_576",
		-- Oh you poor Nightwings.
		"/VO/Justice_577",
		-- All of the Nightwings, banished.
		"/VO/Justice_578",
		-- Quite foul for the Nightwings.
		"/VO/Justice_579",
		-- <Laughter>
		"/VO/Match_232",
		-- All three Nightwings, poof.
		"/VO/Justice_580",
	}
    function AllPlayerUnitsBanishedAudio()
	    wait(0.35)
		-- imp crowd
		if GetMapName({ }) == "MatchSiteJ" then
			if CoinFlip() then
			PlaySound({ Name = "/SFX/Match SFX/ImpCrowdDisappointed", Delay = 0.1 })
			else
			end
		end
		if blockMatchVO then
			return
		end
		if archJusticeHootedRecently then
			return
		end
		if someoneScored then
			return
		end
		if not IsWholeTeamDead( PlayerTeam ) then
			return
		end
	    PlayRemainingSpeech( SpeechSet.AllPlayerUnitsBanished )
		thread( ArchJusticeSpeaking )
    end

	-- VO for Positive Trait Proc / Buff
    SpeechSet.PlayerBuffed =
    {
		-- Sing for the righteous!
	    "/VO/Justice_125",
		-- Think on everything you hold dear!
	    "/VO/Justice_126",
		-- Let your spirit soar!
	    "/VO/Justice_127",
    }
    function PlayerBuffedAudio()
	    wait(0.05)
		if archJusticeSpokeRecently then
			return
		end
	    local randomChance = math.random(1,3)
	    if randomChance == 1 then
		    PlayRemainingSpeech( SpeechSet.PlayerBuffed )
	    end
		thread( ArchJusticeSpeaking )
    end

	-- VO for Negative Trait Proc / Debuff
    SpeechSet.PlayerDebuffed =
    {
		-- Gloom is the neighbor of the heart.
	    "/VO/Justice_128",
		-- Despondency is a most-vicious cycle.
	    "/VO/Justice_129",
		-- Look down and plunge into a sea of misery.
	    "/VO/Justice_130",
    }
    function PlayerDebuffedAudio()
	    wait(0.05)
		if archJusticeSpokeRecently then
			return
		end
	    local randomChance = math.random(1,3)
	    if randomChance == 1 then
		    PlayRemainingSpeech( SpeechSet.PlayerDebuffed )
	    end
		thread( ArchJusticeSpeaking )
    end

	-- VO for Match End
    SpeechSet.MatchEnd =
    {
		-- The Rite is complete.
	    "/VO/Justice_34",
		-- And thus the Rites conclude.
	    -- "/VO/Justice_35",
		-- And it is done.
	    -- "/VO/Justice_36",
		-- The Rite is ended.
	    "/VO/Match_955",
		-- The ceremony is complete.
	    "/VO/Match_956",
		-- Thus end this night's proceedings.
	    "/VO/Match_957",
		-- The Rite is done.
	    "/VO/Match_958",
    }
    function MatchEndAudio()
		if blockMatchVO then
			return
		end
	    wait(1.4)
		if introMatch then
			-- The Rite is complete.
			PlaySpeech({ Name = "/VO/Justice_34", Queue = "Interrupt" })
		else
			PlayRemainingSpeech( SpeechSet.MatchEnd, nil, "Interrupt" )
		end
    end

	SpeechSet.MatchOutcomeBigWin =
    {
		-- Twas a glorious performance I must say.
		"/VO/Justice_485",
		-- Accomplished effortlessly, I might add.
		"/VO/Justice_486",
		-- Their adversaries proved no match for them.
		"/VO/Justice_487",
		-- Their hapless adversaries stood no chance.
		"/VO/Justice_672",
		-- 'Twas as though the Scribes themselves stood by their side.
		"/VO/Justice_673",
		-- And what a crushing victory it was.
		"/VO/Justice_674",
		-- They overwhelmed their adversaries utterly.
		"/VO/Match_540",
		-- They vastly outperformed their adversaries.
		"/VO/Match_541",
		-- Their adversaries must be crying tears of shame.
		"/VO/Match_542",
		-- Most excellently done this time, I must admit.
		"/VO/Match_1287",
		-- Their Pyre yet burns with vigor and resolve.
		"/VO/Match_1288",
		-- Their adversaries did not even come close.
		"/VO/Match_1289",
    }
	SpeechSet.AscensionMatchOutcomeBigWin =
    {
		-- As for their adversaries, they did not.
		"/VO/Match_570",
		-- Their adversaries, they defeated utterly.
		"/VO/Match_571",
	}
	SpeechSet.AscensionMatchOutcomeBigLoss =
    {
		-- As for the Nightwings, they most certainly did not.
		"/VO/Match_576",
		-- The Nightwings proved their utter lack thereof.
		"/VO/Match_577",
	}
    function MatchOutcomeBigWinAudio()
	    wait(0.1)
		local speechCue = nil
		if not ascensionMatch then
			speechCue = PlayNextRemainingSpeech( SpeechSet.MatchOutcomeBigWin, nil, "Always" )
		else
			-- if you won the ascension match
			if PlayerTeam.PyreHealth > 0 then
				speechCue = PlayNextRemainingSpeech( SpeechSet.AscensionMatchOutcomeBigWin, nil, "Always" )
			-- if you lost the ascension match
			else
				speechCue = PlayNextRemainingSpeech( SpeechSet.AscensionMatchOutcomeBigLoss, nil, "Always" )
			end
		end
		waitUntil( speechCue )
		PostVictoryVOClosingThoughts()
    end

	SpeechSet.MatchOutcomeSolidWin =
    {
		-- Perhaps they do deserve their freedom after all.
		"/VO/Justice_491",
		-- And such a well-conducted victory it was.
		"/VO/Justice_492",
		-- A perfectly agreeable performance overall.
		"/VO/Justice_493",
		-- A Rite conducted with aplomb.
		"/VO/Justice_678",
		-- Their adversaries, confidently thwarted.
		"/VO/Justice_679",
		-- Meanwhile, their adversaries wallow in defeat.
		"/VO/Justice_680",
		-- The Scribes themselves surely have taken note.
		"/VO/Match_543",
		-- Their adversaries must be rather shaken after that.
		"/VO/Match_544",
		-- They brushed aside their adversaries without too much trouble.
		"/VO/Match_545",
		-- They proved superior to their adversaries.
		"/VO/Match_1293",
		-- Their Pyre burns, whilst that of their advesaries is but ash.
		"/VO/Match_1294",
		-- Twas the will of the Eight Scribes which kept their flame alive.
		"/VO/Match_1295",
    }
	SpeechSet.AscensionMatchOutcomeSolidWin =
    {
		-- An outcome which left little room for doubt.
		"/VO/Match_572",
		-- Rather convincingly, I must admit.
		"/VO/Match_573",
	}
	SpeechSet.AscensionMatchOutcomeSolidLoss =
    {
		-- The Nightwings, on the other hand, hm...
		"/VO/Match_578",
		-- The Nightwings made them work for it a bit.
		"/VO/Match_579",
	}
    function MatchOutcomeSolidWinAudio()
	    wait(0.1)
		local speechCue = nil
		if not ascensionMatch then
			speechCue = PlayRemainingSpeech( SpeechSet.MatchOutcomeSolidWin, nil, "Always" )
		else
			-- if you won the ascension match
			if PlayerTeam.PyreHealth > 0 then
				speechCue = PlayNextRemainingSpeech( SpeechSet.AscensionMatchOutcomeSolidWin, nil, "Always" )
			-- if you lost the ascension match
			else
				speechCue = PlayNextRemainingSpeech( SpeechSet.AscensionMatchOutcomeSolidLoss, nil, "Always" )
			end
		end
		waitUntil( speechCue )
		PostVictoryVOClosingThoughts()
    end

	SpeechSet.MatchOutcomeCloseWin =
    {
		-- A narrow victory, yet nonetheless commendable.
		"/VO/Justice_488",
		-- Their adversaries came ever so close.
		"/VO/Justice_489",
		-- I thought for certain they would not.
		"/VO/Justice_490",
		-- The flames of their resolve could not be doused.
		"/VO/Justice_675",
		-- The Scribes showed them a bit of favor, in the end.
		"/VO/Justice_676",
		-- Or you could say they managed to avoid defeat.
		"/VO/Justice_677",
		-- Perhaps a stroke of fortune ought be thanked?
		"/VO/Match_546",
		-- Although, their adversaries put up quite an effort.
		"/VO/Match_547",
		-- A victory so narrowly achieved, and thus, more glorious.
		"/VO/Match_548",
		-- They somehow managed to scrape by despite their adversaries' efforts.
		"/VO/Match_1290",
		-- They pulled together ere their Pyre sputtered out.
		"/VO/Match_1291",
		-- Their Pyre nearly was extinguished there, but no.
		"/VO/Match_1292",
    }
	SpeechSet.AscensionMatchOutcomeCloseWin =
    {
		-- Of their adversaries, the same cannot be said.
		"/VO/Match_574",
		-- They surpassed their adversaries, in the end.
		"/VO/Match_575",
	}
	SpeechSet.AscensionMatchOutcomeCloseLoss =
    {
		-- It could have been you, Nightwings, but, alas.
		"/VO/Match_580",
		-- The Nightwings fell just short of doing so.
		"/VO/Match_581",
	}
    function MatchOutcomeCloseWinAudio()
	    wait(0.1)
		local speechCue = nil
		if not ascensionMatch then
			speechCue = PlayRemainingSpeech( SpeechSet.MatchOutcomeCloseWin, nil, "Always" )
		else
			-- if you won the ascension match
			if PlayerTeam.PyreHealth > 0 then
				speechCue = PlayNextRemainingSpeech( SpeechSet.AscensionMatchOutcomeCloseWin, nil, "Always" )
			-- if you lost the ascension match
			else
				speechCue = PlayNextRemainingSpeech( SpeechSet.AscensionMatchOutcomeCloseLoss, nil, "Always" )
			end
		end
		waitUntil( speechCue )
		PostVictoryVOClosingThoughts()
    end

	SpeechSet.LateGameLoss =
    {
		-- A richly deserved victory, at that.
		"/VO/Match_208",
		-- Better them than traitors such as you.
		"/VO/Match_209",
		-- How very sad for you.
		"/VO/Match_210",
		-- The Scribes would not have had it otherwise.
		"/VO/Match_211",
    }
    function MatchOutcomeLateGameLossAudio()
	    wait(0.1)
		if not ascensionMatch then
			speechCue = PlayRemainingSpeech( SpeechSet.LateGameLoss, nil, "Always" )
			waitUntil( speechCue )
			PostVictoryVOClosingThoughts()
		end
    end

	SpeechSet.LateGameWin =
    {
		-- Mayhap the Scribes shall simply smite them down next time.
		"/VO/Match_204",
		-- They hardly deserved it, though, if you ask me.
		"/VO/Match_205",
		-- Alas that their adversaries failed to stop them.
		"/VO/Match_206",
		-- May their next adversaries fare a little better.
		"/VO/Match_207",
    }
    function MatchOutcomeLateGameWinAudio()
	    wait(0.1)
		if not ascensionMatch then
			speechCue = PlayRemainingSpeech( SpeechSet.LateGameWin, nil, "Always" )
			waitUntil( speechCue )
			PostVictoryVOClosingThoughts()
		end
    end

	SpeechSet.LocalMPMatchEnd =
    {
		-- Through more such deeds they may one day return in glory to their homes.
	    "/VO/Justice_494",
		-- Through more such deeds they may one day re-gain their freedom.
	    "/VO/Justice_495",
    }
    function LocalMPMatchEndAudio()
	    wait(0.5)
		PlayRemainingSpeech( SpeechSet.LocalMPMatchEnd )
    end

	SpeechSet.MatchSendOff =
    {
		-- I bid you all farewell for now.
	    -- "/VO/Justice_496",
		-- Until the stars align.
		-- "/VO/Justice_497",
		-- Until the stars align.
	    "/VO/Justice_92",
		-- Until the next Rite.
	    "/VO/Justice_93",
    }
	SpeechSet.LateGameMatchSendOff =
    {
		-- You may go now at your earliest convenience.
	    "/VO/Match_838",
		-- Begone now from my sight.
	    "/VO/Match_213",
		-- May misfortune find you ere the turning of the stars.
	    "/VO/Match_215",
		-- Now, go, and wallow in the Downside for a while.
	    "/VO/Match_835",
		-- I eagerly await our next such outing.
	    "/VO/Match_836",
		-- Until the next Rite. If there even is to be another one.
	    "/VO/Match_212",
		-- Now, take your sordid business someplace else.
	    "/VO/Match_837",
    }
	SpeechSet.AscensionMatchSendOff =
    {
		-- Until the the Rites begin anew.
	    "/VO/Match_173",
		-- Until the turning of the stars, farewell.
	    "/VO/Match_174",
		-- The Eight Scribes gave their freedom so that we may yet have ours.
	    "/VO/Match_606",
		-- May the Scribes have mercy on us all.
	    "/VO/Match_175",
	}
    function MatchSendOffAudio( delay )
		if blockMatchVO then
			return
		end
		local waitTime = 0.2
		if delay ~= nil then
			waitTime = delay
		end
		wait(waitTime)

		if RequestLocalMPRematch then
			return
		end

		if not ascensionMatch then
			if PlayerTeam.AscensionMatchesPlayed < 4 then
				PlayRemainingSpeech( SpeechSet.MatchSendOff, nil, "Always" )
			else
				PlayRemainingSpeech( SpeechSet.LateGameMatchSendOff, nil, "Always" )
			end
		else
			if PlayerTeam.AscensionMatchesPlayed == 5 then
				-- Merely two Liberation Rites remain...
				-- PlaySpeech({ Name = "/VO/Match_834", Queue = "Always" })
				-- Now, take your execrable companions someplace else.
				PlaySpeech({ Name = "/VO/Match_214", Queue = "Always" })
			elseif PlayerTeam.AscensionMatchesPlayed == 6 then
				-- One final Liberation Rite remains.
				-- PlaySpeech({ Name = "/VO/Match_218", Queue = "Always" })
			else
				PlayRemainingSpeech( SpeechSet.AscensionMatchSendOff, nil, "Always" )
			end
		end
    end

    SpeechSet.MatchEndLastOfSeason =
    {
	    "/VO/Justice_108",
	    "/VO/Justice_109",
    }
    function MatchEndLastOfSeasonAudio()
	    wait(0.35)
	    PlayRemainingSpeech( SpeechSet.MatchEndLastOfSeason )
    end

	-- VO for Post-Match (OLD)
    SpeechSet.PostMatch =
    {
		-- Until the stars align.
	    "/VO/Justice_92",
		-- Until the next Rite.
	    "/VO/Justice_93",
		-- You may take your leave.
	    "/VO/Justice_94",
    }
    function PostMatchAudio()
	    wait(1.0)
	    PlayRemainingSpeech( SpeechSet.PostMatch )
    end

	-- VO for Player Wins Match (OLD)
    SpeechSet.MatchWin =
    {
		-- You have shown your worth.
	    "/VO/Justice_37",
		-- Tis but a single battle in a long, long war.
	    "/VO/Justice_38",
		-- We give thanks.
	    "/VO/Justice_39",
    }
    function MatchWinAudio()
	    wait(0.45)
		PlaySound({ Name = "/Music/Stingers/MatchOver1" })
		if not introMatch then
			PlayRemainingSpeech( SpeechSet.MatchWin )

			SetFlagFalse({ Name = "CanPositiveQuip" })
			local chanceToQuip = math.random(1,10)
			if chanceToQuip >= 6 then
				SetFlagTrue({ Name = "CanPositiveQuip" })
			end
		end
    end

	-- VO for Player Loses Match (OLD)
    SpeechSet.MatchLoss =
    {
		-- Have you a taste for failure?
	    "/VO/Justice_40",
		-- A shameful outcome.
	    "/VO/Justice_41",
		-- Humiliating, was it not?
	    "/VO/Justice_42",
    }
    function MatchLossAudio()
		PlaySound({ Name = "/Music/Stingers/MatchLossStinger" })
	    wait(0.45)
	    SetFlagFalse({ Name = "CanNegativeQuip" })
	    PlayRemainingSpeech( SpeechSet.MatchLoss )

	    local chanceToQuip = math.random(1,10)
	    if chanceToQuip >= 6 then
		    SetFlagTrue({ Name = "CanNegativeQuip" })
	    end
    end

	-- VO for Celebration
    SpeechSet.SetupCelebration =
    {
		-- May shame befall our enemies!
	    "/VO/Justice_86",
		-- Do you not feel joy?
	    "/VO/Justice_87",
    }
    function SetupCelebrationAudio()
	    wait(0.25)
	    PlayRemainingSpeech( SpeechSet.SetupCelebration )
    end

    SpeechSet.CelebrationSuccess =
    {
		-- Splendid!
	    "/VO/Justice_88",
		-- Rejoice in their comeuppance!
	    "/VO/Justice_89",
    }
    function CelebrationSuccessAudio()
	    wait(0.25)
	    PlayRemainingSpeech( SpeechSet.CelebrationSuccess )
    end

    SpeechSet.CelebrationFail =
    {
		-- Boast not without due cause.
	    "/VO/Justice_90",
		-- Fie!
	    "/VO/Justice_91",
    }
    function CelebrationFailAudio()
	    wait(0.25)
	    PlayRemainingSpeech( SpeechSet.CelebrationFail )
    end

	-- VO for Positive Quips
    if SpeechSet.PositiveQuip == nil then
	    SpeechSet.PositiveQuip = {
			-- Most satisfactory.
		    "/VO/Justice_43",
			-- As it should be.
		    "/VO/Justice_44",
			-- Most agreeable.
		    "/VO/Justice_45",
			-- Not even the tempests of the Otherworld can shake our resolve!
		    "/VO/Justice_46",
			-- We all are family in the Commonwealth, and families have rules.
		    "/VO/Justice_47",
			-- If only Gol Golathanian showed such courage when the Ruined Legion crumbled all around him.
		    "/VO/Justice_48",
						    }
    end

end }

OnSoundComplete{ "/VO/Justice_206",
	function( triggerArgs )
		wait(1.35)
		-- But your fate is your own.
		PlaySpeech({ Name = "/VO/Justice_207" })
	end
}

OnSoundComplete{ "/VO/Justice_207",
	function( triggerArgs )
		wait(0.35)
		PlaySound({ Name = "/Music/Stingers/MandolinStingerMisc1" })
	end
}

OnSoundComplete{ "/VO/Justice_37 /VO/Justice_38 /VO/Justice_39",
	RequiredFlag = "CanPositiveQuip",
	function( triggerArgs )
		wait(0.75)
		PlayRemainingSpeech( SpeechSet.PositiveQuip )
	end
}


-- VO for Negative Quips
SpeechSet.NegativeQuip =
{
	-- Pathetic.
	"/VO/Justice_49",
	-- Beneath contempt.
	"/VO/Justice_50",
	-- Simply abhorrent.
	"/VO/Justice_51",
	-- Walk not the Rope-Caller's path.
	"/VO/Justice_52",
	-- Grovel not at the feet of false patrons, who would lead you only into treachery.
	"/VO/Justice_53",
	-- Evocative of the stories of the Six Scribes, would you not agree?
	-- "/VO/Justice_54",
}

OnSoundComplete{ "/VO/Justice_40 /VO/Justice_41 /VO/Justice_42",
	RequiredFlag = "CanNegativeQuip",
	function( triggerArgs )
		wait(0.75)
		PlayRemainingSpeech( SpeechSet.NegativeQuip )
	end
}

-- VO for Match Interludes / Interjections
SpeechSet.Interjection =
{
	-- May you ascend in glory if your worth be true! But only if.
	"/VO/Justice_55",
	"/VO/Justice_56",
	"/VO/Justice_57",
	"/VO/Justice_58",
	"/VO/Justice_59",
	"/VO/Justice_60",
	"/VO/Justice_61",
	"/VO/Justice_62",
	"/VO/Justice_63",
	"/VO/Justice_64",
}

OnSoundComplete{ "/VO/Justice_16 /VO/Justice_17 /VO/Justice_18 /VO/Justice_22 /VO/Justice_23 /VO/Justice_24",
	RequiredFlag = "CanInterject",
	function( triggerArgs )
		wait(1.25)
		PlayRemainingSpeech( SpeechSet.Interjection )
	end
}

function PlayQuip( quipType, characterData )

	if quipType == "Determined" then
		thread( QuipDeterminedAudio, characterData["VoicePrefix"] )
	elseif quipType == "FiredUp" then
		thread( QuipFiredUpAudio, characterData["VoicePrefix"] )
	elseif quipType == "Demoralized" then
		thread( QuipDemoralizedAudio, characterData["VoicePrefix"] )
	elseif quipType == "Taunt" then
		thread( QuipTauntAudio, characterData["VoicePrefix"] )
	elseif quipType == "Concede" then
		thread( QuipConcedeAudio, characterData["VoicePrefix"] )
	elseif quipType == "Excited" then
		thread( EmoteScoring, characterData["VoicePrefix"] )
	elseif quipType == "Bark" then
		thread( EmoteKilling, characterData["VoicePrefix"] )
	elseif quipType == "Surprised" then
		thread( EmoteSurprised, characterData["VoicePrefix"] )
	elseif quipType == "Sardonic" then
		thread( EmoteSardonic, characterData["VoicePrefix"] )
	elseif quipType == "Giddy" then
		thread( EmoteGiddy, characterData["VoicePrefix"] )
	elseif quipType == "Pleased" then
		thread( EmotePleased, characterData["VoicePrefix"] )
	elseif quipType == "Angry" then
		thread( EmoteAngry, characterData["VoicePrefix"] )
	elseif quipType == "Sad" then
		thread( EmoteSad, characterData["VoicePrefix"] )
	elseif quipType == "Skeptical" then
		thread( EmoteSkeptical, characterData["VoicePrefix"] )
	elseif quipType == "Curious" then
		thread( EmoteCurious, characterData["VoicePrefix"] )
	elseif quipType == "Grateful" then
		thread( EmoteGrateful, characterData["VoicePrefix"] )
	elseif quipType == "Sorry" then
		thread( EmoteSorry, characterData["VoicePrefix"] )
	elseif quipType == "Mocking" then
		thread( EmoteMocking, characterData["VoicePrefix"] )
	elseif quipType == "Naive" then
		thread( EmoteNaive, characterData["VoicePrefix"] )
	elseif quipType == "Tough" then
		thread( EmoteTough, characterData["VoicePrefix"] )
	else
		-- Didn't find a quip to play
		return false
	end

	-- Attmeped to play a quip
	return true

end

-- **Misc. Quips (Old)**
SpeechSet.QuipFiredUp =
{
	"Quip_2",
	"Quip_3",
	"Quip_4",
}
function QuipFiredUpAudio( prefix )
	wait(0.15)
	PlayRemainingSpeechWithPrefix( SpeechSet.QuipFiredUp, nil, prefix )
end

SpeechSet.QuipDemoralized =
{
	"Quip_5",
	"Quip_6",
	"Quip_7",
}
function QuipDemoralizedAudio( prefix )
	wait(0.15)
	PlayRemainingSpeechWithPrefix( SpeechSet.QuipDemoralized, nil, prefix )
end

SpeechSet.QuipDetermined =
{
	"Quip_8",
	"Quip_9",
	"Quip_10",
}
function QuipDeterminedAudio( prefix )
	wait(0.15)
	PlayRemainingSpeechWithPrefix( SpeechSet.QuipDetermined, nil, prefix )
end

SpeechSet.QuipTaunt =
{
	"Quip_11",
	"Quip_12",
	"Quip_13",
}
function QuipTauntAudio( prefix )
	wait(0.15)
	PlayRemainingSpeechWithPrefix( SpeechSet.QuipTaunt, nil, prefix )
end

SpeechSet.QuipConcede =
{
	"Quip_14",
	"Quip_15",
	"Quip_16",
}
function QuipConcedeAudio( prefix )
	wait(0.15)
	PlayRemainingSpeechWithPrefix( SpeechSet.QuipConcede, nil, prefix )
end

-- **Misc. Quips (Old)**

function EmoteSurprised( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "Emote_2"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteSardonic( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "Emote_3"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteGiddy( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "Emote_4"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmotePleased( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "Emote_5"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteAngry( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "Emote_6"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteSad( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "Emote_7"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteSkeptical( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "Emote_8"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteCurious( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "Emote_9"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteGrateful( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "Emote_10"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteSorry( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "Emote_11"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteMocking( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "Emote_12"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteNaive( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "Emote_13"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteTough( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "Emote_14"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteRelief( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "Emote_15"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end


-- **Match Emotes**
function EmoteChargeUp( prefix, id )

	if prefix == nil then
		return
	end

	local cueSuffix = "EmoteCharging"
	local cueName = prefix..cueSuffix
	if not CheckCooldown( cueName, 0.5 ) then
		return
	end
	PlaySound({ Name = cueName, Id = id })
end

function EmoteAttack( prefix, id )

	if prefix == nil then
		return
	end
	local chargingCueName = prefix.."EmoteCharging"
	if not CheckCooldown( chargingCueName, 0.3 ) then
		StopSound({ Name = chargingCueName, Duration = 0.1 })
	end

	local cueSuffix = "EmoteAttacking"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmotePowerAttack( prefix, id )

	if prefix == nil then
		return
	end
	local chargingCueName = prefix.."EmoteCharging"
	if not CheckCooldown( chargingCueName, 0.3 ) then
		StopSound({ Name = chargingCueName, Duration = 0.1 })
	end

	local cueSuffix = "EmotePowerAttacking"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteEvade( prefix, id )

	if prefix == nil then
		return
	end

	local sprintingCueName = prefix.."EmoteSprinting"
	if not CheckCooldown( sprintingCueName, 0.5 ) then
		return
	end
	local cueSuffix = "EmoteEvading"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteEvadeImp( prefix, id )

	if prefix == nil then
		return
	end

	local cueSuffix = "EmoteEvading"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteDoubleJump( prefix, id )

	if prefix == nil then
		return
	end

	local cueSuffix = "EmoteDoubleJumping"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteLanding( prefix, id )

	if prefix == nil then
		return
	end

	local cueSuffix = "EmoteLanding"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteSprinting( prefix, id )

	if prefix == nil then
		return
	end

	local cueSuffix = "EmoteSprinting"
	local cueName = prefix..cueSuffix
	if not CheckCooldown( cueName, 0.5 ) then
		return
	end
	PlaySound({ Name = cueName, Id = id })
end

function EmoteGetting( prefix, id )

	if prefix == nil then
		return
	end

	local cueSuffix = "EmoteGetting"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

-- this is EmoteGetting with a small delay
function EmoteReceiving( prefix, id )

	if prefix == nil then
		return
	end
	wait(0.1)
	if not IsAlive({ Id = id }) then
		return
	end
	local cueSuffix = "EmoteGetting"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

-- despite the name, this is used for getting the ball [GK 11/20/16]
function EmotePassing( prefix, id )

	if prefix == nil then
		return
	end

	local sprintingCueName = prefix.."EmoteSprinting"
	if not CheckCooldown( sprintingCueName, 0.5 ) then
		return
	end
	local cueSuffix = "EmotePassing"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteTossing( prefix, id )

	if prefix == nil then
		return
	end

	local chargingCueName = prefix.."EmoteCharging"
	if not CheckCooldown( chargingCueName, 0.3 ) then
		StopSound({ Name = chargingCueName, Duration = 0.1 })
	end

	local cueSuffix = "EmoteTossing"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteRespawning( prefix, id )

	if prefix == nil then
		return
	end
	wait(0.1)
	if someoneScored then
		return
	end
	if scorePresentation then
		return
	end
	if showBlackBars then
		return
	end
	local cueSuffix = "EmoteRespawning"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteScoring( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "EmoteScoring"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id, Delay = 0.65 })
end

function EmoteKilling( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.38)

	if someoneScored then
		return
	end
	if scorePresentation then
		return
	end

	local cueSuffix = "EmoteKilling"
	local cueName = prefix..cueSuffix
	if not CheckCooldown( cueName, 0.5 ) then
		return
	end
	PlaySound({ Name = cueName, Id = id })
end

function EmoteDying( prefix, id )

	if prefix == nil then
		return
	end

	if someoneScored then
		return
	end

	wait(0.1)
	local cueSuffix = "EmoteDying"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteShoving( prefix, id )

	if prefix == nil then
		return
	end

	if someoneScored then
		return
	end

	local cueSuffix = "EmotePassing"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteWinning( character, duration )

	if character == nil then
		return
	end
	if duration == nil then
		duration = 1.45
	end

	wait(duration)
	local cueName = character.VoicePrefix.."EmoteWinning"
	local team = League[character.TeamIndex]
	cueName = cueName..team.VoicePostfix
	if IsForfeitMatch() and character.ForfeitVictoryVO ~= nil then
		cueName = character.ForfeitVictoryVO
	end
	PlaySound({ Name = cueName })
end

function EmoteWinningAlt( character )

	if character == nil then
		return
	end

	wait(1.45)
	local cueName = character.VoicePrefix.."EmoteWinningAlt"
	PlaySound({ Name = cueName, Id = character.ObjectId })
end

function EmoteTaunting( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.25)
	local cueSuffix = "EmoteTaunting"
	local cueName = prefix..cueSuffix
	if not CheckCooldown( cueName, 1.5 ) then
		return
	end
	PlaySound({ Name = cueName, Id = id })
end

function EmoteTauntingMedium( prefix, character, team )

	if prefix == nil then
		return
	end

	wait(0.10)
	if not IsAlive({ Id = character.ObjectId }) then
		return
	end
	local cueSuffix = "EmoteCharging"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = character.ObjectId })
	wait(1.1)
	if not IsAlive({ Id = character.ObjectId }) then
		return
	end

	cueName = character.VoicePrefix.."EmoteWinning"
	cueName = cueName..team.VoicePostfix
	PlaySound({ Name = cueName, Id = character.ObjectId })
end

function EmoteTauntingLarge( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.10)
	if not IsAlive({ Id = id }) then
		return
	end
	local cueSuffix = "EmoteCharging"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
	if not IsAlive({ Id = id }) then
		return
	end
	wait(0.45)
	cueSuffix = "EmoteAttacking"
	cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
	wait(1.1)
	if not IsAlive({ Id = id }) then
		return
	end
	cueSuffix = "EmotePowerAttacking"
	cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end


function EmoteTauntingLargeOralech( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.345)
	local cueSuffix = "EmoteAttacking"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
	wait(0.45)
	if not IsAlive({ Id = id }) then
		return
	end
	if not IsAlive({ Id = id }) then
		return
	end
	cueSuffix = "EmoteAttacking"
	cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })

	wait(0.690)
	if not IsAlive({ Id = id }) then
		return
	end
	cueSuffix = "EmotePowerAttacking"
	cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })

	wait(0.62)
	if not IsAlive({ Id = id }) then
		return
	end
	cueSuffix = "EmoteCharging"
	cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })

end

function EmoteLosing( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "EmoteLosing"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteVictory( character )

	if character == nil then
		return
	end

	wait(1.45)
	local cueName = character.VoicePrefix.."EmoteVictory"
	PlaySound({ Name = cueName, Id = character.ObjectId })
end

function EmoteDefeat( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)
	local cueSuffix = "EmoteDefeat"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

function EmoteDrafted( prefix, id )

	if prefix == nil then
		return
	end

	wait(0.1)

	-- to avoid VO stomps with dialogue
	if IsScreenOpen({ Name = "DialogueScreen" }) then
		return
	end

	local cueSuffix = "EmoteDrafted"
	local cueName = prefix..cueSuffix
	PlaySound({ Name = cueName, Id = id })
end

-- **Misc SFX and Audio Triggers**

OnTriggerFired
{ "GuideBookBonusSFX",
	function(triggerArgs)
		PlaySound({ Name = "/Music/Stingers/MandolinStingerMisc2" })
	end
}

OnTriggerFired
{ "MaskUnlatchSFX",
	function(triggerArgs)
		local characterPositionId = nil
		if ActiveNarrationName == "Intro" then
			characterPositionId = CurrentScenePositionTrackers["LeftCharacter"]
		elseif ActiveNarrationName == "Intro_WagonInterior" then
			if timesMaskUnlatchTriggered == nil then
				characterPositionId = CurrentScenePositionTrackers["RightCharacter"]
				timesMaskUnlatchTriggered = 1
			else
				characterPositionId = CurrentScenePositionTrackers["LeftMidCharacter"]
				timesMaskUnlatchTriggered = timesMaskUnlatchTriggered + 1
			end
		elseif ActiveNarrationName == "Intro_Week1_Match_Beginning" then
			characterPositionId = CurrentScenePositionTrackers["RightCharacter"]
		elseif ActiveNarrationName == "Week7_ReachedGoal" then
			characterPositionId = CurrentScenePositionTrackers["RightCharacter"]
		end
		waitScreenTime(0.9)
		PlaySound({ Name = "/SFX/World Sounds/MaskUnlatch1", Id = characterPositionId })
		waitScreenTime(0.2)
		PlaySound({ Name = "/SFX/World Sounds/MaskUnlatch1", Id = characterPositionId })
		waitScreenTime(0.2)
		PlaySound({ Name = "/SFX/World Sounds/MaskUnlatch1", Id = characterPositionId })
		waitScreenTime(0.2)
		PlaySound({ Name = "/SFX/World Sounds/MaskUnlatch2", Id = characterPositionId })
		waitScreenTime(0.2)
		PlaySound({ Name = "/SFX/World Sounds/MaskUnlatch2", Id = characterPositionId })
		waitScreenTime(0.2)
		PlaySound({ Name = "/SFX/World Sounds/MaskUnlatch2", Id = characterPositionId })
	end
}

OnTriggerFired
{ "MaskRemoveSFX",
	function(triggerArgs)
		local characterPositionId = nil
		if ActiveNarrationName == "Intro" then
			characterPositionId = CurrentScenePositionTrackers["LeftCharacter"]
		elseif ActiveNarrationName == "Intro_WagonInterior" then
			if timesMaskRemoveTriggered == nil then
				characterPositionId = CurrentScenePositionTrackers["RightCharacter"]
				timesMaskRemoveTriggered = 1
			else
				characterPositionId = CurrentScenePositionTrackers["LeftMidCharacter"]
				timesMaskRemoveTriggered = timesMaskRemoveTriggered + 1
			end
		elseif ActiveNarrationName == "Intro_Week1_Match_Beginning" then
			characterPositionId = CurrentScenePositionTrackers["RightCharacter"]
		end
		PlaySound({ Name = "/SFX/World Sounds/Unmask", Id = characterPositionId })
	end
}

OnTriggerFired
{ "MaskStruggleSFX",
	function(triggerArgs)
		local characterPositionId = CurrentScenePositionTrackers["LeftMidCharacter"]
		if ActiveNarrationName == "Week7_ReachedGoal" then
			characterPositionId = CurrentScenePositionTrackers["RightCharacter"]
		end
		waitScreenTime(0.45)
		PlaySound({ Name = "/SFX/World Sounds/MaskUnlatch1", Id = characterPositionId })
		PlaySound({ Name = "/SFX/Match SFX/RobeFlutter", Id = characterPositionId })
		waitScreenTime(0.3)
		PlaySound({ Name = "/SFX/World Sounds/MaskUnlatch1", Id = characterPositionId })
		waitScreenTime(0.1)
		PlaySound({ Name = "/SFX/World Sounds/MaskUnlatch1", Id = characterPositionId })
		PlaySound({ Name = "/SFX/Match SFX/RobeFlutter", Id = characterPositionId })
		if ActiveNarrationName == "Week7_ReachedGoal" then
			PlaySound({ Name = "/VO/Sap_Manley_0068_", Id = characterPositionId })
		elseif ActiveNarrationName == "OpenStructure_Match_Beginning_RivalryEnded_Pyrehearts_01" or ActiveNarrationName == "OpenStructure_Match_Beginning_Rivalry_Pyrehearts_01" then
			PlaySound({ Name = "/VO/Wyrm_Deluge_0088__3", Id = characterPositionId })
		else
			PlaySound({ Name = "/VO/Cur_Rukey_55", Id = characterPositionId })
		end
		SetSoundCueValue({ Id = GetMixingId({}), Names = {"VocalsAltState"}, Value = 1.0 })
		waitScreenTime(0.1)
		PlaySound({ Name = "/SFX/World Sounds/MaskUnlatch1", Id = characterPositionId })
		PlaySound({ Name = "/SFX/Match SFX/RobeFlutter", Id = characterPositionId })
		waitScreenTime(0.3)
		PlaySound({ Name = "/SFX/World Sounds/MaskUnlatch1", Id = characterPositionId })
		PlaySound({ Name = "/SFX/Match SFX/RobeFlutter", Id = characterPositionId })
		waitScreenTime(0.1)
		PlaySound({ Name = "/SFX/World Sounds/MaskUnlatch2", Id = characterPositionId })
	end
}

OnTriggerFired
{ "MassHowlingSFX",
	function(triggerArgs)
		waitScreenTime(0.3)
		PlaySound({ Name = "/SFX/Match SFX/HowlerImpHowl_1" })
		waitScreenTime(0.7)
		PlaySound({ Name = "/SFX/Match SFX/HowlerImpHowl_2" })
		waitScreenTime(0.8)
		PlaySound({ Name = "/SFX/Match SFX/HowlerImpHowl_1" })
	end
}

OnTriggerFired
{ "MassHowlingSFX2",
	function(triggerArgs)
		waitScreenTime(0.3)
		PlaySound({ Name = "/SFX/Match SFX/HowlerImpHowl_2" })
		waitScreenTime(0.6)
		PlaySound({ Name = "/SFX/Match SFX/HowlerImpHowl_1" })
		waitScreenTime(1)
		PlaySound({ Name = "/SFX/Match SFX/HowlerImpHowl_2" })
		waitScreenTime(0.6)
		PlaySound({ Name = "/SFX/Match SFX/HowlerImpHowl_1" })
	end
}

OnTriggerFired
{ "ImpCheeringSFX",
	function(triggerArgs)
		waitScreenTime(0.3)
		PlaySound({ Name = "/SFX/Match SFX/ImpCrowdCheer" })
		waitScreenTime(0.2)
		PlaySound({ Name = "/SFX/Match SFX/ImpCrowdBigLaugh", Delay = 0.15 })
	end
}

OnTriggerFired
{ "BigSplashSFX",
	function(triggerArgs)
		PlaySound({ Name = "/SFX/World Sounds/BigSplash" })
	end
}


OnTriggerFired
{ "JokerStammerSFX",
	function(triggerArgs)
		PlaySound({ Name = "/VO/Cur_Rukey_0283__2", Id = CurrentScenePositionTrackers["LeftMidCharacter"] })
		PlaySound({ Name = "/SFX/Player Sounds/PlayerSkid", Id = CurrentScenePositionTrackers["LeftMidCharacter"] })
	end
}

OnTriggerFired
{ "WyrmStruggleSFX",
	function(triggerArgs)
		FireTrigger({ Name = "EventFlashSmall" })
		PlaySound({ Name = "/VO/Wyrm_Gilman_173__8", Id = CurrentScenePositionTrackers["RightCharacter"], Delay = 0.1 })
		PlaySound({ Name = "/VO/Wyrm_Deluge_0076_", Id = CurrentScenePositionTrackers["RightMidCharacter"], Delay = 0.3 })
		waitScreenTime(0.45)
		PlaySound({ Name = "/SFX/World Sounds/MaskUnlatch1", Id = CurrentScenePositionTrackers["RightMidCharacter"] })
		PlaySound({ Name = "/SFX/Match SFX/RobeFlutter", Id = CurrentScenePositionTrackers["RightMidCharacter"] })
		waitScreenTime(0.3)
		PlaySound({ Name = "/SFX/World Sounds/MaskUnlatch1", Id = CurrentScenePositionTrackers["RightMidCharacter"] })
		waitScreenTime(0.1)
		PlaySound({ Name = "/SFX/World Sounds/MaskUnlatch1", Id = CurrentScenePositionTrackers["RightMidCharacter"] })
		PlaySound({ Name = "/SFX/Match SFX/RobeFlutter", Id = CurrentScenePositionTrackers["RightMidCharacter"] })
	end
}

OnTriggerFired
{ "MessengerImpSFX",
	function(triggerArgs)
		PlaySound({ Name = "/SFX/Leftovers/FootstepsSand" })
		wait(0.2)
		PlaySound({ Name = "/SFX/Leftovers/FootstepsSand" })
		wait(0.2)
		PlaySound({ Name = "/SFX/Leftovers/FootstepsSand" })
		wait(0.2)
		PlaySound({ Name = "/SFX/Leftovers/FootstepsSand" })
		wait(0.2)
		PlaySound({ Name = "/SFX/Player Sounds/PlayerSkid" })
	end
}

OnTriggerFired
{ "MaeScreamSFX",
	function(triggerArgs)
		PlaySound({ Name = "/VO/Mae_212", Delay = 0.6 })
		PlaySound({ Name = "/VO/Mae_214", Delay = 0.9 })
	end
}


OnTriggerFired
{ "DissidentSFX",
	function(triggerArgs)
		if CurrentMapName == "Campaign" then
			PlaySound({ Name = "/VO/Cur_Barker_0073_", Delay = 0.3 })
			PlaySound({ Name = "/VO/Cur_Barker_0079__4", Delay = 0.6 })
		else
			PlaySound({ Name = "/VO/Cur_Barker_0073__2", Delay = 0.4 })
			PlaySound({ Name = "/VO/Cur_Barker_0079__5", Delay = 0.7 })
		end
	end
}

OnTriggerFired
{ "BigSwooshSFX",
	function(triggerArgs)
		PlaySound({ Name = "/SFX/World Sounds/SwoopingLargeFlaps" })
		PlaySound({ Name = "/SFX/World Sounds/SwoopingLargeFlaps", Delay = 0.4 })
		PlaySound({ Name = "/SFX/World Sounds/SwoopingLargeFlaps", Delay = 0.8 })
	end
}

OnTriggerFired
{ "NegativeSurpriseSFX",
	function(triggerArgs)
		PlaySound({ Name = "/SFX/Menu Sounds/TextReveal3" })
	end
}

OnTriggerFired
{ "AscensionPortalSFX",
	function(triggerArgs)
		PlaySound({ Name = "/SFX/Menu Sounds/ChoirShort" })
		PlaySound({ Name = "/SFX/Menu Sounds/EmoteAffection" })
	end
}

OnTriggerFired
{ "FlyingHighSFX",
	function(triggerArgs)
		PlaySound({ Name = "/SFX/Leftovers/WindBlowing" })
		waitUntil( "terminalShutdownComplete" )
		StopSound({ Name = "/SFX/Leftovers/WindBlowing", Duration = 4.0 })
	end
}

OnTriggerFired
{ "DownerMomentSFX",
	function(triggerArgs)
		PlaySound({ Name = "/SFX/Leftovers/TextReveal" })
	end
}

OnTriggerFired
{ "HeavyMomentSFX",
	function(triggerArgs)
		PlaySound({ Name = "/SFX/World Sounds/MapZoomSlow" })
	end
}

OnTriggerFired
{ "DoorCloseSFX",
	function(triggerArgs)
		PlaySound({ Name = "/SFX/Leftovers/DoorClose" })
	end
}


OnTriggerFired
{ "DishClinkSFX",
	function(triggerArgs)
		PlaySound({ Name = "/SFX/World Sounds/Caravan Interior/DishesInteract", Delay = 0.4 })
		PlaySound({ Name = "/SFX/World Sounds/Caravan Interior/DishesInteract", Delay = 0.8 })
		PlaySound({ Name = "/SFX/World Sounds/Caravan Interior/DishesInteract", Delay = 1.0 })
		PlaySound({ Name = "/SFX/World Sounds/Caravan Interior/DishesInteract", Delay = 1.3 })
		PlaySound({ Name = "/SFX/World Sounds/Caravan Interior/DishesInteract", Delay = 1.5 })
	end
}

OnTriggerFired
{ "FriendLaughSFX",
	function(triggerArgs)
		FireTrigger({ Name = "EventFlashSmall" })
		PlaySound({ Name = "/VO/Nomad_Hedwyn_0306__3", Id = CurrentScenePositionTrackers["LeftCharacter"], Delay = 0.3 })
	end
}

OnTriggerFired
{ "DivaLaughSFX",
	function(triggerArgs)
		FireTrigger({ Name = "EventFlashSmall" })
		PlaySound({ Name = "/VO/Bertrude_0177__8", Id = CurrentScenePositionTrackers["LeftCharacter"], Delay = 0.3 })
	end
}

OnTriggerFired
{ "DocDivaLaughSFX",
	function(triggerArgs)
		FireTrigger({ Name = "EventFlashSmall" })
		PlaySound({ Name = "/VO/Sap_Volfred_0269__2", Id = CurrentScenePositionTrackers["LeftCharacter"], Delay = 0.3 })
		PlaySound({ Name = "/VO/Bertrude_0149__2", Id = CurrentScenePositionTrackers["RightCharacter"], Delay = 0.3 })
	end
}

OnTriggerFired
{ "DocMascotHugSFX",
	function(triggerArgs)
		FireTrigger({ Name = "EventFlashSmall" })
		PlaySound({ Name = "/SFX/Match SFX/HarpDash", Id = CurrentScenePositionTrackers["RightCharacter"], Delay = 0.1 })
		PlaySound({ Name = "/VO/Imp_Tizo_0167__3", Id = CurrentScenePositionTrackers["RightCharacter"], Delay = 0.4 })
		PlaySound({ Name = "/VO/Sap_Volfred_0280__4", Id = CurrentScenePositionTrackers["RightCharacter"], Delay = 0.65 })
	end
}

OnTriggerFired
{ "PamithaMoonshineSFX",
	function(triggerArgs)
		wait(0.4)
		PlaySound({ Name = "/VO/Harp_Pamitha_0176__10" })
		PlaySound({ Name = "/SFX/World Sounds/Caravan Interior/SwallowDrink", Delay = 0.6 })
		PlaySound({ Name = "/VO/Harp_Pamitha_0201__5", Delay = 1.2 })
	end
}

OnTriggerFired
{ "FateHugSFX",
	function(triggerArgs)
		FireTrigger({ Name = "EventFlashSmall" })
		PlaySound({ Name = "/SFX/Match SFX/RobeFlutter", Id = CurrentScenePositionTrackers["RightMidCharacter"], Delay = 0.3 })
		PlaySound({ Name = "/VO/Cur_Dalbert_0090__6", Id = CurrentScenePositionTrackers["RightMidCharacter"], Delay = 0.4 })
		PlaySound({ Name = "/VO/Nomad_Almer_0038__6", Id = CurrentScenePositionTrackers["RightCharacter"], Delay = 0.4 })
	end
}

OnTriggerFired
{ "ReaderThroatClearSFX",
	function(triggerArgs)
		if Coach.Gender == "Char_Gender_Male" then
			PlaySound({ Name = "/SFX/Menu Sounds/BardThroatClear" })
		elseif Coach.Gender == "Char_Gender_Female" then
			PlaySound({ Name = "/SFX/Menu Sounds/FemaleThroatClear" })
		else
			-- PlaySound({ Name = "/SFX/Menu Sounds/BardThroatClear" })
		end
	end
}

OnTriggerFired
{ "NightwingsCheerSFX",
	function(triggerArgs)
		FireTrigger({ Name = "EventFlashSmall" })
		for k, characterData in pairs( PlayerTeam.TeamBench ) do
			if characterData.RosterStatus ~= "Ascended" then
				thread( EmoteWinning, characterData, 0.1 )
			end
		end
	end
}

OnTriggerFired
{
	"BardEpilogueSFX",
	function(triggerArgs)
		-- PlaySound({ Name = "/VO/Bard_0157__4", Id = CurrentScenePositionTrackers["LeftCharacter"], Delay = 0.4 })
		-- PlaySound({ Name = "/VO/RivalBard_0007__7", Id = CurrentScenePositionTrackers["RightCharacter"], Delay = 0.4 })
		PlaySound({ Name = "/VO/Bard_0052__4", Id = CurrentScenePositionTrackers["LeftCharacter"], Delay = 0.4 })
		PlaySound({ Name = "/VO/RivalBard_0016__7", Id = CurrentScenePositionTrackers["RightCharacter"], Delay = 0.4 })
	end
}

OnTriggerFired
{
	"FateEpilogueSFX",
	function(triggerArgs)
		PlaySound({ Name = "/VO/Cur_Dalbert_0016__5", Id = CurrentScenePositionTrackers["RightMidCharacter"] })
		PlaySound({ Name = "/VO/Nomad_Almer_0032__5", Id = CurrentScenePositionTrackers["RightCharacter"], Delay = 1.3 })
	end
}

function PlayRonSFX()
	PlaySound({ Name = "/VO/ShopKeeper_172", Id = realOvermapUnit })
end

OnTriggerFired{ "StopRonSFX",
	function( triggerArgs )
		StopSound({ Name = "/VO/ShopKeeper_172", Duration = 3 })
	end
}

OnTriggerFired{ "UseSpecialEventSound",
	function( triggerArgs )
		EventChoiceSfx = "/Music/Stingers/MandolinStingerMisc1"
	end
}

OnTriggerFired{ "UseCheesyEventSound",
	function( triggerArgs )
		EventChoiceSfx = "/Music/Stingers/PositiveStinger1"
	end
}

OnTriggerFired{ "UsePositiveEventSound",
	function( triggerArgs )
		EventChoiceSfx = "/Music/Stingers/PlayerScore"
	end
}

OnTriggerFired{ "UseAscensionSuccessSound",
	function( triggerArgs )
		EventChoiceSfx = "/SFX/Menu Sounds/AscensionConfirm"
	end
}

function SandFootsteps()
	PlaySound({ Name = "/SFX/Leftovers/FootstepsSand" })
	waitScreenTime(1.2)
	PlaySound({ Name = "/SFX/Leftovers/FootstepsSand" })
	waitScreenTime(1.2)
	PlaySound({ Name = "/SFX/Leftovers/FootstepsSand" })
	waitScreenTime(1.2)
	PlaySound({ Name = "/SFX/Leftovers/FootstepsSand" })
	waitScreenTime(1.2)
	PlaySound({ Name = "/SFX/Leftovers/FootstepsSand" })
	waitScreenTime(1.2)
	PlaySound({ Name = "/SFX/Leftovers/FootstepsSand" })
	waitScreenTime(0.35)
	PlaySound({ Name = "/SFX/Leftovers/FootstepsSand" })
	waitScreenTime(0.35)
	PlaySound({ Name = "/SFX/Leftovers/FootstepsSand" })
	waitScreenTime(0.35)
	PlaySound({ Name = "/SFX/Leftovers/FootstepsSand" })
	waitScreenTime(0.2)
	PlaySound({ Name = "/SFX/Leftovers/FootstepsSand" })
	waitScreenTime(0.2)
end

function ClickablesSoundPlaying()
	if clickablesSoundPlayedRecently then
		return
	end

	if not clickablesSoundPlayedRecently then
		clickablesSoundPlayedRecently = true
		local coolDown = 0.35
		wait( coolDown )
		clickablesSoundPlayedRecently = false
	end
end


--[[ * FOOTSTEPS * ]]

SwapSound({ Name = "/SFX/Player Sounds/FootstepsWheat2", DestinationName = "/SFX/Player Sounds/FootstepsConcrete" })

function MatchDeathAudio( deadCharacter )

	local team = League[deadCharacter.TeamIndex]
	-- for local MP
	if IsMultiplayerMatch() then
		if nearGoal then
			thread( SomeoneWithBallBanishedNearGoalAudio )
		else
			local coinToss = math.random(1,4)
			if coinToss == 4 and not IsEmpty( deadCharacter.BanishedSpeechLines ) then
				thread( CharacterBanishedAudio, deadCharacter )
			else
				thread( SomeoneWithBallBanishedAudio )
			end
		end
	-- for campaign
	else
		if team == LocalTeam then
			if nearGoal then
				thread( PlayerWithBallKilledNearGoalAudio )
			else
				local coinToss = math.random(1,4)
				if coinToss == 4 and not IsEmpty( deadCharacter.BanishedSpeechLines ) then
					thread( CharacterBanishedAudio, deadCharacter )
				else
					thread( PlayerWithBallKilledAudio )
				end
			end
		else
			if nearGoal then
				thread( OpponentWithBallKilledNearGoalAudio )
			else
				local coinToss = math.random(1,4)
				if coinToss == 4 and not IsEmpty( deadCharacter.BanishedSpeechLines ) then
					thread( CharacterBanishedAudio, deadCharacter )
				else
					thread( OpponentWithBallKilledAudio )
				end
			end
		end
	end
end

function MatchScoreAudio( scoringCharacter, roundScore )

	-- emote VO
	if thrownScore then
		-- thread( EmoteScoring, scoringCharacter.VoicePrefix, scoringCharacter.ObjectId )
	else
		thread( EmotePowerAttack, scoringCharacter.VoicePrefix, scoringCharacter.ObjectId )
	end

	local scoringTeam = League[scoringCharacter.TeamIndex]
	local scoredOnTeam = GetOpposingTeam( scoringTeam )

	-- if it's the winning point
	if scoredOnTeam.PyreHealth <= 0 then
		if not introMatch then
			-- thread( OpposingPyreExtinguishedAudio )
		else
			thread( MatchEndAudio )
		end

		return
	end

	if IsMultiplayerMatch() then
		HeadToHeadScoreAudio( scoringCharacter, roundScore )
	else
		if scoringTeam == LocalTeam then
			if showdownScoring then
				if matchesPlayed == 5 then
					showdownScoring = false
					-- So Pamitha's the better sister, then. Let us continue in the customary way.
					PlaySpeechOnce({ Name = "/VO/Justice_776", Delay = 0.65 })
				end
			else
				LocalPlayerScoreAudio( scoringCharacter, roundScore )
			end
		else
			if showdownScoring then
				if matchesPlayed == 5 then
					showdownScoring = false
					-- So Tamitha's the better sister, then. Let us continue in the customary way.
					PlaySpeechOnce({ Name = "/VO/Justice_777", Delay = 0.65 })
				end
			else
				RemotePlayerScoreAudio( scoringCharacter, roundScore )
			end
		end
	end

end

function LocalPlayerScoreAudio( scoringCharacter, roundScore )

	local scoringTeam = League[scoringCharacter.TeamIndex]
	local scoredOnTeam = GetOpposingTeam( scoringTeam )

	-- if it's match point
	if scoredOnTeam.PyreHealth <= 20 then
		thread( MatchPointAudio )
	end

	-- if the score is tied
	if scoringTeam.PyreHealth == scoredOnTeam.PyreHealth then
		thread( ScoreTiedAudio )
	end

	-- if you take the lead
	if scoringTeam.PyreHealth > scoredOnTeam.PyreHealth and scoredOnTeam.PrevPyreHealth >= scoringTeam.PyreHealth then
		thread( PlayerTakesLeadAudio )
	end

	-- if you score against the last-hit shield
	if scoredOnTeam.PyreShieldProcced and scoredOnTeam.PyreHealth > 0 then
		thread( SomeoneScoresLastHitShieldAudio )
		return
	end

	-- throwscore exception
	if IsFirstAccusersMatch() and thrownScore and not throwScoredOnce then
		thread( PlayerThrowScoresAudio )
		return
	end

	-- if you score during a dramatic moment
	if dramaticMomentPlaying then
		thread( SomeoneDramaticScoresAudio )
		return
	end

	-- if it's not the winning point
	-- if you score big
	if roundScore >= 25 then
		-- if it's the first point
		if firstScoreAudioCanPlay then
			-- if you throw-score
			if thrownScore then
				if roundScore <= ( scoringCharacter.ScoreValue * 0.6 ) then
					thread( SomeoneWeakThrowScoresAudio )
					return
				else
					local coinToss = math.random(1,3)
					if coinToss == 1 and not IsEmpty( scoringCharacter.ThrowScoringSpeechLines ) then
						thread( CharacterThrowScoresAudio, scoringCharacter )
						return
					end
				end
			else
				thread( PlayerScoresFirstAudio )
				return
			end
		-- if you score as bigger characters
		else
			-- if you throw-score
			if thrownScore then
				if roundScore <= ( scoringCharacter.ScoreValue * 0.6 ) then
					thread( SomeoneWeakThrowScoresAudio )
					return
				else
					local coinToss = math.random(1,3)
					if coinToss == 1 and not IsEmpty( scoringCharacter.ThrowScoringSpeechLines ) then
						thread( CharacterThrowScoresAudio, scoringCharacter )
						return
					else
						thread( PlayerScoresBigAudio )
						return
					end
				end
			else
				local coinToss = math.random(1,3)
				if coinToss == 3 and not IsEmpty( scoringCharacter.ScoringSpeechLines ) then
					thread( CharacterScoresAudio, scoringCharacter )
					return
				else
					thread( PlayerScoresBigAudio )
					return
				end
			end
		end

		return
	end

	-- if you score regular
	-- if you score first
	if firstScoreAudioCanPlay and not thrownScore then
		thread( PlayerScoresFirstAudio )
	else
		-- if you throw-score
		if thrownScore then
			if roundScore <= ( scoringCharacter.ScoreValue * 0.6 ) then
				thread( SomeoneWeakThrowScoresAudio )
				return
			else
				local coinToss = math.random(1,3)
				if coinToss == 1 and not IsEmpty( scoringCharacter.ThrowScoringSpeechLines ) then
					thread( CharacterThrowScoresAudio, scoringCharacter )
				else
					thread( PlayerThrowScoresAudio )
				end
			end
		-- otherwise
		else
			-- character-specific exceptions
			local coinToss = math.random(1,4)
			if coinToss == 4 and not IsEmpty( scoringCharacter.ScoringSpeechLines ) then
				thread( CharacterScoresAudio, scoringCharacter )
			else
				-- all other cases
				thread( PlayerScoresAudio )
			end
		end
	end

end

function RemotePlayerScoreAudio( scoringCharacter, roundScore )

	local scoringTeam = League[scoringCharacter.TeamIndex]
	local scoredOnTeam = GetOpposingTeam( scoringTeam )

	-- if it's match point
	-- if scoredOnTeam.PyreHealth <= 20 and scoring then
	--	thread( MatchPointAudio )
	--  return
	-- end

	-- if the score is tied
	if scoringTeam.PyreHealth == scoredOnTeam.PyreHealth then
		thread( ScoreTiedAudio )
	end

	-- if they take the lead
	if scoringTeam.PyreHealth > scoredOnTeam.PyreHealth and scoredOnTeam.PrevPyreHealth >= scoringTeam.PyreHealth then
		thread( PlayerLosesLeadAudio )
	end

	-- if they scores against the last-hit shield
	if scoredOnTeam.PyreShieldProcced and scoredOnTeam.PyreHealth > 0 then
		thread( SomeoneScoresLastHitShieldAudio )
		return
	end

	-- if they score during a dramatic moment
	if dramaticMomentPlaying then
		thread( SomeoneDramaticScoresAudio )
		return
	end

	-- if it's not the winning point
	if firstScoreAudioCanPlay then
		thread( OpponentScoresFirstAudio )
		return
	end

	-- specific for named characters and not throw-scoring
	if SacrificeScorer ~= nil and not thrownScore then
		if not IsEmpty( scoringCharacter.ScoringSpeechLines ) and RandomChance( 0.33 ) then
			thread( CharacterScoresAudio, scoringCharacter )
			return
		end
	end

	-- if it's a high-value score
	if roundScore >= 25 then
		thread( OpponentScoresBigAudio )
		return
	end

	if thrownScore then

		if roundScore <= ( scoringCharacter.ScoreValue * 0.6 ) then
			thread( SomeoneWeakThrowScoresAudio )
			return
		end

		if not IsEmpty( scoringCharacter.ThrowScoringSpeechLines ) and RandomChance( 0.33 ) then
			thread( CharacterThrowScoresAudio, scoringCharacter )
			return
		end

		thread( OpponentThrowScoresAudio )
		return

	end

	-- character-specific exceptions
	if not IsEmpty( scoringCharacter.ScoringSpeechLines ) and RandomChance( 0.25 ) then
		thread( CharacterScoresAudio, scoringCharacter )
		return
	end

	-- all other cases
	thread( OpponentScoresAudio )

end

function HeadToHeadScoreAudio( scoringCharacter, roundScore )

	local scoringTeam = League[scoringCharacter.TeamIndex]
	local scoredOnTeam = GetOpposingTeam( scoringTeam )

	-- if it's match point
	if scoredOnTeam.PyreHealth <= 20 then
		thread( MatchPointAudio )
	end

	-- if the score is tied
	if scoringTeam.PyreHealth == scoredOnTeam.PyreHealth then
		thread( ScoreTiedAudio )
	end

	-- if one team or the other takes the lead
	if scoringTeam.PyreHealth > scoredOnTeam.PyreHealth and scoredOnTeam.PrevPyreHealth >= scoringTeam.PyreHealth then
		thread( TeamTakesLeadAudio, scoringTeam, scoredOnTeam )
	end

	-- if someone scores against the last-hit shield
	if scoredOnTeam.PyreShieldProcced and scoredOnTeam.PyreHealth > 0 then
		thread( SomeoneScoresLastHitShieldAudio )
		return
	end

	-- if it's a dramatic moment and not the winning point
	if dramaticMomentPlaying and scoredOnTeam.PyreHealth > 0 then
		thread( SomeoneDramaticScoresAudio )
		return
	end

	-- if it's the first point
	if firstScoreAudioCanPlay and scoredOnTeam.PyreHealth > 0 then
		thread( TeamScoresFirstAudio, scoringTeam, scoredOnTeam )
		return
	end

	-- if someone throw-scores and it's not the first point or winning point
	if thrownScore and scoredOnTeam.PyreHealth > 0 then
		if roundScore <= ( scoringCharacter.ScoreValue * 0.6 ) then
			thread( SomeoneWeakThrowScoresAudio )
			return
		else
			-- character-specific exceptions
			local coinToss = math.random(1,3)
			if coinToss == 3 and not IsEmpty( scoringCharacter.ThrowScoringSpeechLines ) then
				thread( CharacterThrowScoresAudio, scoringCharacter )
				return
			else
				-- all other cases
				thread( SomeoneThrowScoresAudio )
				return
			end
		end
	end

	-- scoring for named characters
	local coinToss = math.random(1,4)
	if coinToss == 4 and not IsEmpty( scoringCharacter.ScoringSpeechLines ) then
		thread( CharacterScoresAudio, scoringCharacter )
		return
	-- if someone scores big and it's not the winning point
	elseif roundScore >= 25 then
		thread( SomeoneScoresBigAudio )
		return
	-- if someone scores normally
	else
		thread( SomeoneScoresAudio )
		return
	end

end

function CampaignMatchStartVO()
	wait(0.1)
	if introMatch then
		-- intro match audio
		thread( MatchStartAudio )
	elseif uncommonMatch or IsMultiplayerMatch() then
		-- Do nothing
	else
		-- dynamic match start audio
		thread( MatchIntroAudio )
	end
end