/*
 * Decompiled with CFR 0.152.
 */
package lee.study.down.util;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lee.study.down.jna.WinInet;
import lee.study.down.jna.WinInetImpl;

public class OsUtil {
    private static final String OS;
    private static final String ARCH;
    private static boolean isAdmin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFreePort(int defaultPort) throws Exception {
        int port;
        try (ServerSocket serverSocket1 = null;){
            serverSocket1 = new ServerSocket(defaultPort);
            port = serverSocket1.getLocalPort();
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBusyPort(int port) {
        boolean ret = true;
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port);
            ret = false;
        }
        catch (Exception e) {
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public static void openBrowse(String url) throws Exception {
        boolean flag;
        Desktop desktop = Desktop.getDesktop();
        boolean bl = flag = Desktop.isDesktopSupported() && desktop.isSupported(Desktop.Action.BROWSE);
        if (flag) {
            try {
                URI uri = new URI(url);
                desktop.browse(uri);
            }
            catch (Exception e) {
                throw new Exception("can't open browse", e);
            }
        } else {
            throw new Exception("don't support browse");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execFile(InputStream inputStream, String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            try (FileOutputStream fos = new FileOutputStream(file);){
                int len;
                byte[] bts = new byte[8192];
                while ((len = inputStream.read(bts)) != -1) {
                    fos.write(bts, 0, len);
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        Desktop.getDesktop().open(file);
    }

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return OS.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") >= 0;
    }

    public static boolean isSolaris() {
        return OS.indexOf("sunos") >= 0;
    }

    public static boolean is64() {
        return "64".equals(ARCH);
    }

    public static boolean is32() {
        return "32".equals(ARCH);
    }

    public static boolean isAdmin() {
        return isAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProcessPrint(String shell) throws IOException {
        Process process = Runtime.getRuntime().exec(shell);
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line + System.lineSeparator());
            }
        }
        finally {
            process.destroy();
        }
        return sb.toString();
    }

    public static Map<String, List<String>> getInterfacesInfo() throws SocketException {
        HashMap<String, List<String>> interfacesInfo = new HashMap<String, List<String>>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress nextElement = addresses.nextElement();
                String name = networkInterface.getDisplayName();
                ArrayList<String> ipList = (ArrayList<String>)interfacesInfo.get(name);
                if (ipList == null) {
                    ipList = new ArrayList<String>();
                    interfacesInfo.put(name, ipList);
                }
                ipList.add(nextElement.getHostAddress());
            }
        }
        return interfacesInfo;
    }

    public static String getRemoteInterface() throws IOException {
        Map<String, List<String>> interfacesInfo = OsUtil.getInterfacesInfo();
        Socket socket = new Socket("www.baidu.com", 80);
        for (Map.Entry<String, List<String>> entry : interfacesInfo.entrySet()) {
            if (!entry.getValue().contains(socket.getLocalAddress().getHostAddress())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String getRemoteInterfaceName() throws IOException {
        String remoteInterface = OsUtil.getRemoteInterface();
        String result = OsUtil.getProcessPrint("networksetup -listnetworkserviceorder");
        Pattern pattern = Pattern.compile("\\(Hardware\\sPort:\\s(.*),\\sDevice:\\s(.*)\\)");
        Matcher matcher = pattern.matcher(result);
        while (matcher.find()) {
            if (!matcher.group(2).equalsIgnoreCase(remoteInterface)) continue;
            return matcher.group(1);
        }
        return null;
    }

    public static boolean existsCert(String name, String sha1) throws IOException {
        if (OsUtil.isWindows()) {
            if (OsUtil.findCertList(name, true).toUpperCase().replaceAll("\\s", "").indexOf(":" + sha1.toUpperCase()) != -1) {
                return true;
            }
            return OsUtil.findCertList(name, false).toUpperCase().replaceAll("\\s", "").indexOf(":" + sha1.toUpperCase()) != -1;
        }
        if (OsUtil.isMac()) {
            return OsUtil.findCertList(name).toUpperCase().replaceAll("\\s", "").indexOf(":" + sha1.toUpperCase()) != -1;
        }
        return false;
    }

    public static boolean existsCert(String name) throws IOException {
        if (OsUtil.isWindows()) {
            if (OsUtil.isAdmin() && OsUtil.existsWindowsCert(name, true)) {
                return true;
            }
            return OsUtil.existsWindowsCert(name, false);
        }
        if (OsUtil.isMac()) {
            return OsUtil.findCertList(name).toUpperCase().indexOf("BEGIN CERTIFICATE") != -1;
        }
        return false;
    }

    public static boolean existsWindowsCert(String name, boolean isAdmin) throws IOException {
        return OsUtil.findCertList(name, isAdmin).indexOf("=====") != -1;
    }

    public static void installCert(String path) throws IOException {
        if (OsUtil.isWindows()) {
            Runtime.getRuntime().exec("certutil -addstore " + (OsUtil.isAdmin() ? "" : "-user ") + "root \"" + path + "\"");
        } else if (OsUtil.isMac()) {
            Runtime.getRuntime().exec("security add-trusted-cert -d -r trustRoot -k /Library/Keychains/System.keychain " + path);
        }
    }

    public static void uninstallCert(String name) throws IOException {
        block5: {
            block4: {
                String hash;
                if (!OsUtil.isWindows()) break block4;
                Pattern pattern = Pattern.compile("(?i)\\(sha1\\):\\s(.*)\r?\n");
                String certList = OsUtil.findCertList(name, false);
                Matcher matcher = pattern.matcher(certList);
                while (matcher.find()) {
                    hash = matcher.group(1).replaceAll("\\s", "");
                    Runtime.getRuntime().exec("certutil -delstore -user root " + hash);
                }
                if (!OsUtil.isAdmin()) break block5;
                certList = OsUtil.findCertList(name, true);
                matcher = pattern.matcher(certList);
                while (matcher.find()) {
                    hash = matcher.group(1);
                    Runtime.getRuntime().exec("certutil -delstore root " + hash);
                }
                break block5;
            }
            if (OsUtil.isMac()) {
                String certList = OsUtil.findCertList(name);
                Pattern pattern = Pattern.compile("(?i)SHA-1 hash:\\s(.*)\r?\n");
                Matcher matcher = pattern.matcher(certList);
                while (matcher.find()) {
                    String hash = matcher.group(1);
                    Runtime.getRuntime().exec("security delete-certificate -Z " + hash + " /Library/Keychains/System.keychain");
                }
            }
        }
    }

    private static String findCertList(String name, boolean isAdmin) throws IOException {
        if (OsUtil.isWindows()) {
            return OsUtil.getProcessPrint("certutil -store " + (isAdmin ? "" : "-user ") + "root " + name);
        }
        if (OsUtil.isMac()) {
            return OsUtil.getProcessPrint("security find-certificate -a -c " + name + " -p -Z /Library/Keychains/System.keychain");
        }
        return null;
    }

    private static String findCertList(String name) throws IOException {
        return OsUtil.findCertList(name, true);
    }

    public static void enabledPACProxy(String pac) throws IOException {
        if (OsUtil.isWindows()) {
            WinInet.INTERNET_PER_CONN_OPTION_LIST list = WinInetImpl.buildOptionList(2);
            WinInet.INTERNET_PER_CONN_OPTION[] pOptions = (WinInet.INTERNET_PER_CONN_OPTION[])list.pOptions.toArray(list.dwOptionCount);
            pOptions[0].dwOption = 1;
            pOptions[0].Value.dwValue = 4;
            pOptions[0].Value.setType(Integer.TYPE);
            pOptions[1].dwOption = 4;
            pOptions[1].Value.pszValue = pac;
            pOptions[1].Value.setType(String.class);
            WinInetImpl.refreshOptions(list);
        } else if (OsUtil.isMac()) {
            OsUtil.disabledProxy();
            String interName = OsUtil.getRemoteInterfaceName();
            Runtime.getRuntime().exec("networksetup -setautoproxyurl " + interName + " " + pac);
        }
    }

    public static void enabledHTTPProxy(String host, int port) throws IOException {
        if (OsUtil.isWindows()) {
            WinInet.INTERNET_PER_CONN_OPTION_LIST list = WinInetImpl.buildOptionList(2);
            WinInet.INTERNET_PER_CONN_OPTION[] pOptions = (WinInet.INTERNET_PER_CONN_OPTION[])list.pOptions.toArray(list.dwOptionCount);
            pOptions[0].dwOption = 1;
            pOptions[0].Value.dwValue = 2;
            pOptions[0].Value.setType(Integer.TYPE);
            pOptions[1].dwOption = 2;
            pOptions[1].Value.pszValue = host + ":" + port;
            pOptions[1].Value.setType(String.class);
            WinInetImpl.refreshOptions(list);
        } else if (OsUtil.isMac()) {
            OsUtil.disabledProxy();
            String interName = OsUtil.getRemoteInterfaceName();
            Runtime.getRuntime().exec("networksetup -setwebproxy " + interName + " " + host + " " + port);
            Runtime.getRuntime().exec("networksetup -setsecurewebproxy " + interName + " " + host + " " + port);
        }
    }

    public static void disabledProxy() throws IOException {
        if (OsUtil.isWindows()) {
            WinInet.INTERNET_PER_CONN_OPTION_LIST list = WinInetImpl.buildOptionList(1);
            WinInet.INTERNET_PER_CONN_OPTION[] pOptions = (WinInet.INTERNET_PER_CONN_OPTION[])list.pOptions.toArray(list.dwOptionCount);
            pOptions[0].dwOption = 1;
            pOptions[0].Value.dwValue = 1;
            pOptions[0].Value.setType(Integer.TYPE);
            WinInetImpl.refreshOptions(list);
        } else if (OsUtil.isMac()) {
            String interName = OsUtil.getRemoteInterfaceName();
            Runtime.getRuntime().exec("networksetup -setautoproxystate " + interName + " off");
            Runtime.getRuntime().exec("networksetup -setwebproxystate " + interName + " off");
            Runtime.getRuntime().exec("networksetup -setsecurewebproxystate " + interName + " off");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        PrintStream systemErr;
        OS = System.getProperty("os.name").toLowerCase();
        ARCH = System.getProperty("sun.arch.data.model");
        Preferences prefs = Preferences.systemRoot();
        PrintStream printStream = systemErr = System.err;
        synchronized (printStream) {
            System.setErr(null);
            try {
                prefs.put("pd_test", "1");
                prefs.remove("pd_test");
                prefs.flush();
                isAdmin = true;
            }
            catch (Exception e) {
                isAdmin = false;
            }
            finally {
                System.setErr(systemErr);
            }
        }
    }
}

