/*
 * Decompiled with CFR 0.152.
 */
package lee.study.down.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.Stack;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lee.study.down.util.OsUtil;

public class FileUtil {
    public static boolean exists(String path) {
        return new File(path).exists();
    }

    public static boolean existsAny(String ... paths) {
        return Arrays.stream(paths).anyMatch(path -> new File((String)path).exists());
    }

    public static void deleteIfExists(File file) throws IOException {
        if (file.exists()) {
            if (file.isFile()) {
                if (!file.delete()) {
                    throw new IOException("Delete file failure,path:" + file.getAbsolutePath());
                }
            } else {
                File[] files = file.listFiles();
                if (files != null && files.length > 0) {
                    for (File temp : files) {
                        FileUtil.deleteIfExists(temp);
                    }
                }
                if (!file.delete()) {
                    throw new IOException("Delete file failure,path:" + file.getAbsolutePath());
                }
            }
        }
    }

    public static void deleteIfExists(String path) throws IOException {
        FileUtil.deleteIfExists(new File(path));
    }

    public static File createFile(String path) throws IOException {
        return FileUtil.createFile(path, false);
    }

    public static File createDir(String path) throws IOException {
        return FileUtil.createDir(path, false);
    }

    public static File createFile(String path, boolean isHidden) throws IOException {
        File file = FileUtil.createFileSmart(path);
        if (OsUtil.isWindows()) {
            Files.setAttribute(file.toPath(), "dos:hidden", isHidden, new LinkOption[0]);
        }
        return file;
    }

    public static File createDir(String path, boolean isHidden) throws IOException {
        File file = new File(path);
        FileUtil.deleteIfExists(file);
        File newFile = new File(path);
        newFile.mkdir();
        if (OsUtil.isWindows()) {
            Files.setAttribute(newFile.toPath(), "dos:hidden", isHidden, new LinkOption[0]);
        }
        return file;
    }

    public static long getFileSize(String path) {
        File file = new File(path);
        if (file.exists()) {
            if (file.isFile()) {
                return file.length();
            }
            long size = 0L;
            File[] files = file.listFiles();
            if (files != null && files.length > 0) {
                for (File temp : files) {
                    if (!temp.isFile()) continue;
                    size += temp.length();
                }
            }
            return size;
        }
        return 0L;
    }

    public static File createFileSmart(String path) throws IOException {
        try {
            File file = new File(path);
            if (file.exists()) {
                file.delete();
                file.createNewFile();
            } else {
                FileUtil.createDirSmart(file.getParent());
                file.createNewFile();
            }
            return file;
        }
        catch (IOException e) {
            throw new IOException("createFileSmart=" + path, e);
        }
    }

    public static File createDirSmart(String path) throws IOException {
        try {
            File file = new File(path);
            if (file.exists()) {
                file.delete();
                file.mkdir();
            } else {
                Stack<File> stack = new Stack<File>();
                for (File temp = new File(path); temp != null; temp = temp.getParentFile()) {
                    stack.push(temp);
                }
                while (stack.size() > 0) {
                    File dir = (File)stack.pop();
                    if (dir.exists()) continue;
                    dir.mkdir();
                }
            }
            return file;
        }
        catch (Exception e) {
            throw new IOException("createDirSmart=" + path, e);
        }
    }

    public static long getDiskFreeSize(String path) {
        File file = new File(path);
        return file.getFreeSpace();
    }

    public static void unmap(MappedByteBuffer mappedBuffer) throws IOException {
        try {
            Class<?> clazz = Class.forName("sun.nio.ch.FileChannelImpl");
            Method m = clazz.getDeclaredMethod("unmap", MappedByteBuffer.class);
            m.setAccessible(true);
            m.invoke(clazz, mappedBuffer);
        }
        catch (Exception e) {
            throw new IOException("LargeMappedByteBuffer close", e);
        }
    }

    public static String getFileNameNoSuffix(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            return fileName.substring(0, index);
        }
        return fileName;
    }

    public static void initFile(String path, boolean isHidden) throws IOException {
        FileUtil.initFile(path, null, isHidden);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initFile(String path, InputStream input, boolean isHidden) throws IOException {
        Throwable throwable;
        RandomAccessFile raf;
        if (FileUtil.exists(path)) {
            raf = new RandomAccessFile(path, "rw");
            throwable = null;
            try {
                raf.setLength(0L);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (raf != null) {
                    if (throwable != null) {
                        try {
                            raf.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        raf.close();
                    }
                }
            }
        } else {
            FileUtil.createFile(path, isHidden);
        }
        if (input != null) {
            try {
                raf = new RandomAccessFile(path, "rw");
                throwable = null;
                try {
                    int len;
                    byte[] bts = new byte[8192];
                    while ((len = input.read(bts)) != -1) {
                        raf.write(bts, 0, len);
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (raf != null) {
                        if (throwable != null) {
                            try {
                                raf.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            raf.close();
                        }
                    }
                }
            }
            finally {
                input.close();
            }
        }
    }

    public static boolean canWrite(String path) {
        File file = new File(path);
        File test = file.isFile() ? new File(file.getParent() + File.separator + UUID.randomUUID().toString() + ".test") : new File(file.getPath() + File.separator + UUID.randomUUID().toString() + ".test");
        try {
            test.createNewFile();
            test.delete();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static void unzip(String zipPath, String toPath, String ... unzipFile) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipPath));){
            ZipEntry entry;
            String string = toPath = toPath == null ? new File(zipPath).getParent() : toPath;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (entry.isDirectory() || unzipFile != null && unzipFile.length > 0 && Arrays.stream(unzipFile).noneMatch(file -> entryName.equalsIgnoreCase((String)file))) {
                    zipInputStream.closeEntry();
                    continue;
                }
                File file2 = FileUtil.createFileSmart(toPath + File.separator + entryName);
                FileOutputStream outputStream = new FileOutputStream(file2);
                Throwable throwable = null;
                try {
                    int len;
                    byte[] bts = new byte[8192];
                    while ((len = zipInputStream.read(bts)) != -1) {
                        outputStream.write(bts, 0, len);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputStream == null) continue;
                    if (throwable != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    outputStream.close();
                }
            }
        }
    }
}

