/*
 * Decompiled with CFR 0.152.
 */
package lee.study.down.util;

import io.netty.buffer.ByteBuf;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import lee.study.down.util.FileUtil;

public class ByteUtil {
    public static byte[] numToBtsForBig(long num, int len) {
        byte[] bts = new byte[len];
        for (int i = 0; i < bts.length; ++i) {
            bts[bts.length - i - 1] = (byte)(num >> 8 * i & 0xFFL);
        }
        return bts;
    }

    public static byte[] numToBtsForBig(long num) {
        return ByteUtil.numToBtsForBig(num, 8);
    }

    public static long btsToNumForBig(byte[] bts) {
        long num = 0L;
        for (int i = 0; i < bts.length; ++i) {
            num += (long)(bts[i] & 0xFF) << 8 * (bts.length - i - 1);
        }
        return num;
    }

    public static byte[] numToBtsForSmall(long num, int len) {
        byte[] bts = new byte[len];
        for (int i = 0; i < bts.length; ++i) {
            bts[i] = (byte)(num >> 8 * i & 0xFFL);
        }
        return bts;
    }

    public static byte[] numToBtsForSmall(long num) {
        return ByteUtil.numToBtsForSmall(num, 8);
    }

    public static long btsToNumForSmall(byte[] bts) {
        long num = 0L;
        for (int i = 0; i < bts.length; ++i) {
            num += (long)(bts[i] & 0xFF) << 8 * i;
        }
        return num;
    }

    public static byte[] objToBts(Serializable object) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ObjectOutputStream outputStream = new ObjectOutputStream(baos);
            outputStream.writeObject(object);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static void serialize(Serializable object, String path, boolean isHidden) throws IOException {
        ByteUtil.serialize(object, path, null, isHidden);
    }

    public static void serialize(Serializable object, String path, String bakPath, boolean isHidden) throws IOException {
        FileUtil.initFile(path, isHidden);
        try (RandomAccessFile raf = new RandomAccessFile(path, "rw");){
            raf.write(ByteUtil.objToBts(object));
        }
        if (bakPath != null) {
            FileUtil.initFile(bakPath, isHidden);
            var5_5 = null;
            try (RandomAccessFile raf2 = new RandomAccessFile(bakPath, "rw");){
                raf2.write(ByteUtil.objToBts(object));
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
        }
    }

    public static void serialize(Serializable object, String path, String bakPath) throws IOException {
        ByteUtil.serialize(object, path, bakPath, true);
    }

    public static void serialize(Serializable object, String path) throws IOException {
        ByteUtil.serialize(object, path, true);
    }

    public static Object deserialize(String path) throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(path));){
            Object object = ois.readObject();
            return object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(String path, String bakPath) throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(path));){
            Object throwable3 = ois.readObject();
            return throwable3;
        }
        catch (Exception e) {
            try (ObjectInputStream ois2 = new ObjectInputStream(new FileInputStream(bakPath));){
                Object object = ois2.readObject();
                return object;
            }
        }
    }

    public static int findText(ByteBuf byteBuf, String str) {
        byte[] text = str.getBytes();
        int matchIndex = 0;
        for (int i = byteBuf.readerIndex(); i < byteBuf.readableBytes(); ++i) {
            int j = matchIndex;
            if (j >= text.length) continue;
            if (byteBuf.getByte(i) == text[j]) {
                matchIndex = j + 1;
                if (matchIndex != text.length) continue;
                return i;
            }
            matchIndex = 0;
        }
        return -1;
    }

    public static ByteBuf insertText(ByteBuf byteBuf, int index, String str) {
        return ByteUtil.insertText(byteBuf, index, str, Charset.defaultCharset());
    }

    public static ByteBuf insertText(ByteBuf byteBuf, int index, String str, Charset charset) {
        byte[] begin = new byte[index + 1];
        byte[] end = new byte[byteBuf.readableBytes() - begin.length];
        byteBuf.readBytes(begin);
        byteBuf.readBytes(end);
        byteBuf.writeBytes(begin);
        byteBuf.writeBytes(str.getBytes(charset));
        byteBuf.writeBytes(end);
        return byteBuf;
    }

    public static byte[] hexToBts(String hex) {
        byte[] bts = new byte[hex.length() / 2];
        for (int i = 0; i < bts.length; ++i) {
            bts[i] = (byte)Integer.parseInt(hex.substring(i * 2, i * 2 + 2), 16);
        }
        return bts;
    }

    public static String btsToHex(byte[] bts) {
        StringBuilder str = new StringBuilder();
        for (byte b : bts) {
            str.append(String.format("%2s", Integer.toHexString(b & 0xFF)).replace(" ", "0"));
        }
        return str.toString();
    }

    public static String readContent(InputStream inputStream, Charset charset) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, charset));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line + System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String readContent(InputStream inputStream) {
        return ByteUtil.readContent(inputStream, Charset.forName("UTF-8"));
    }

    public static String readJsContent(InputStream inputStream) {
        return ByteUtil.readJsContent(inputStream, Charset.defaultCharset());
    }

    public static String readJsContent(InputStream inputStream, Charset charset) {
        StringBuilder sb = new StringBuilder(ByteUtil.readContent(inputStream, charset));
        sb.insert(0, "<script type=\"text/javascript\">");
        sb.append("</script>");
        return sb.toString();
    }

    public static int findBytes(ByteBuffer buffer, byte[] ... btsArr) {
        int[] indexArray = new int[btsArr.length];
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            for (int i = 0; i < btsArr.length; ++i) {
                byte[] bts;
                if (indexArray[i] == -1) {
                    indexArray[i] = 0;
                }
                if (b == (bts = btsArr[i])[indexArray[i]]) {
                    int n = i;
                    indexArray[n] = indexArray[n] + 1;
                    if (indexArray[i] != bts.length) continue;
                    return buffer.position() - bts.length;
                }
                indexArray[i] = 0;
            }
        }
        return -1;
    }

    public static long getNextTokenSize(FileChannel fileChannel, long position, byte[] ... btsArr) throws IOException {
        return ByteUtil.getNextTokenSize(fileChannel, -1L, position, btsArr);
    }

    public static long getNextTokenSize(FileChannel fileChannel, long start, long position, byte[] ... btsArr) throws IOException {
        long ret = -1L;
        ByteBuffer buffer = ByteBuffer.allocateDirect(8192);
        long startPosition = start >= 0L ? start : fileChannel.position();
        if (position >= 0L) {
            fileChannel.position(position);
        }
        while (fileChannel.read(buffer) != -1) {
            buffer.flip();
            int index = ByteUtil.findBytes(buffer, btsArr);
            if (index != -1) {
                ret = fileChannel.position() - startPosition - (long)buffer.limit() + (long)index;
                break;
            }
            buffer.clear();
        }
        fileChannel.position(startPosition);
        return ret;
    }

    public static boolean matchToken(FileChannel fileChannel, long position, byte[] bts) throws IOException {
        return ByteUtil.matchToken(fileChannel, -1L, position, new byte[][]{bts});
    }

    public static boolean matchToken(FileChannel fileChannel, long start, long position, byte[] ... btsArr) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(btsArr[0].length);
        long rawPosition = start >= 0L ? start : fileChannel.position();
        if (position >= 0L) {
            fileChannel.position(position);
        }
        fileChannel.read(buffer);
        buffer.flip();
        boolean ret = ByteUtil.findBytes(buffer, btsArr) == 0;
        fileChannel.position(rawPosition);
        return ret;
    }

    public static String getCertHash(X509Certificate certificate) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = certificate.getEncoded();
        md.update(der);
        return ByteUtil.btsToHex(md.digest());
    }
}

