/*
 * Decompiled with CFR 0.152.
 */
package lee.study.down.model;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lee.study.down.model.ChunkInfo;

public class TaskInfo
implements Serializable {
    private static final long serialVersionUID = 4813413517396555930L;
    private String id;
    private String filePath;
    private String fileName;
    private int connections;
    private long totalSize;
    private boolean supportRange;
    private long downSize;
    private long startTime = 0L;
    private long lastTime = 0L;
    private long pauseTime = 0L;
    private int status;
    private List<ChunkInfo> chunkInfoList;

    public String buildTaskFilePath() {
        return this.getFilePath() + File.separator + this.getFileName();
    }

    public String buildChunksPath() {
        return this.getFilePath() + File.separator + "." + this.getFileName() + "_cks";
    }

    public String buildChunkFilePath(int index) {
        int size = this.chunkInfoList == null ? 0 : (this.chunkInfoList.size() + "").length();
        return this.buildChunksPath() + File.separator + "ck_" + String.format("%0" + size + "d", index) + ".tmp";
    }

    public String buildTaskRecordFilePath() {
        return this.getFilePath() + File.separator + "." + this.getFileName() + ".inf";
    }

    public String buildTaskRecordBakFilePath() {
        return this.getFilePath() + File.separator + "." + this.getFileName() + ".inf.bak";
    }

    public TaskInfo buildChunkInfoList() {
        ArrayList<ChunkInfo> chunkInfoList = new ArrayList<ChunkInfo>();
        if (this.getTotalSize() > 0L) {
            for (int i = 0; i < this.getConnections(); ++i) {
                ChunkInfo chunkInfo = new ChunkInfo();
                chunkInfo.setIndex(i);
                long chunkSize = this.getTotalSize() / (long)this.getConnections();
                chunkInfo.setOriStartPosition((long)i * chunkSize);
                chunkInfo.setNowStartPosition(chunkInfo.getOriStartPosition());
                if (i == this.getConnections() - 1) {
                    chunkSize += this.getTotalSize() % (long)this.getConnections();
                }
                chunkInfo.setEndPosition(chunkInfo.getOriStartPosition() + chunkSize - 1L);
                chunkInfo.setTotalSize(chunkSize);
                chunkInfoList.add(chunkInfo);
            }
        } else {
            ChunkInfo chunkInfo = new ChunkInfo();
            chunkInfo.setIndex(0);
            chunkInfo.setNowStartPosition(0L);
            chunkInfo.setOriStartPosition(0L);
            chunkInfoList.add(chunkInfo);
        }
        this.setChunkInfoList(chunkInfoList);
        return this;
    }

    public void reset() {
        this.pauseTime = 0L;
        this.lastTime = 0L;
        this.startTime = 0L;
        this.chunkInfoList.forEach(chunkInfo -> {
            chunkInfo.setStartTime(0L);
            chunkInfo.setLastTime(0L);
            chunkInfo.setPauseTime(0L);
            chunkInfo.setErrorCount(0);
        });
    }

    public void refresh(ChunkInfo chunkInfo) {
        this.lastTime = System.currentTimeMillis();
        chunkInfo.setLastTime(this.lastTime);
    }

    public String getId() {
        return this.id;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getConnections() {
        return this.connections;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public boolean isSupportRange() {
        return this.supportRange;
    }

    public long getDownSize() {
        return this.downSize;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public long getPauseTime() {
        return this.pauseTime;
    }

    public int getStatus() {
        return this.status;
    }

    public List<ChunkInfo> getChunkInfoList() {
        return this.chunkInfoList;
    }

    public TaskInfo setId(String id) {
        this.id = id;
        return this;
    }

    public TaskInfo setFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public TaskInfo setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public TaskInfo setConnections(int connections) {
        this.connections = connections;
        return this;
    }

    public TaskInfo setTotalSize(long totalSize) {
        this.totalSize = totalSize;
        return this;
    }

    public TaskInfo setSupportRange(boolean supportRange) {
        this.supportRange = supportRange;
        return this;
    }

    public TaskInfo setDownSize(long downSize) {
        this.downSize = downSize;
        return this;
    }

    public TaskInfo setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public TaskInfo setLastTime(long lastTime) {
        this.lastTime = lastTime;
        return this;
    }

    public TaskInfo setPauseTime(long pauseTime) {
        this.pauseTime = pauseTime;
        return this;
    }

    public TaskInfo setStatus(int status) {
        this.status = status;
        return this;
    }

    public TaskInfo setChunkInfoList(List<ChunkInfo> chunkInfoList) {
        this.chunkInfoList = chunkInfoList;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskInfo)) {
            return false;
        }
        TaskInfo other = (TaskInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        if (this.getConnections() != other.getConnections()) {
            return false;
        }
        if (this.getTotalSize() != other.getTotalSize()) {
            return false;
        }
        if (this.isSupportRange() != other.isSupportRange()) {
            return false;
        }
        if (this.getDownSize() != other.getDownSize()) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getLastTime() != other.getLastTime()) {
            return false;
        }
        if (this.getPauseTime() != other.getPauseTime()) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        List<ChunkInfo> this$chunkInfoList = this.getChunkInfoList();
        List<ChunkInfo> other$chunkInfoList = other.getChunkInfoList();
        return !(this$chunkInfoList == null ? other$chunkInfoList != null : !((Object)this$chunkInfoList).equals(other$chunkInfoList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        result = result * 59 + this.getConnections();
        long $totalSize = this.getTotalSize();
        result = result * 59 + (int)($totalSize >>> 32 ^ $totalSize);
        result = result * 59 + (this.isSupportRange() ? 79 : 97);
        long $downSize = this.getDownSize();
        result = result * 59 + (int)($downSize >>> 32 ^ $downSize);
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $lastTime = this.getLastTime();
        result = result * 59 + (int)($lastTime >>> 32 ^ $lastTime);
        long $pauseTime = this.getPauseTime();
        result = result * 59 + (int)($pauseTime >>> 32 ^ $pauseTime);
        result = result * 59 + this.getStatus();
        List<ChunkInfo> $chunkInfoList = this.getChunkInfoList();
        result = result * 59 + ($chunkInfoList == null ? 43 : ((Object)$chunkInfoList).hashCode());
        return result;
    }

    public String toString() {
        return "TaskInfo(id=" + this.getId() + ", filePath=" + this.getFilePath() + ", fileName=" + this.getFileName() + ", connections=" + this.getConnections() + ", totalSize=" + this.getTotalSize() + ", supportRange=" + this.isSupportRange() + ", downSize=" + this.getDownSize() + ", startTime=" + this.getStartTime() + ", lastTime=" + this.getLastTime() + ", pauseTime=" + this.getPauseTime() + ", status=" + this.getStatus() + ", chunkInfoList=" + this.getChunkInfoList() + ")";
    }

    @ConstructorProperties(value={"id", "filePath", "fileName", "connections", "totalSize", "supportRange", "downSize", "startTime", "lastTime", "pauseTime", "status", "chunkInfoList"})
    public TaskInfo(String id, String filePath, String fileName, int connections, long totalSize, boolean supportRange, long downSize, long startTime, long lastTime, long pauseTime, int status, List<ChunkInfo> chunkInfoList) {
        this.id = id;
        this.filePath = filePath;
        this.fileName = fileName;
        this.connections = connections;
        this.totalSize = totalSize;
        this.supportRange = supportRange;
        this.downSize = downSize;
        this.startTime = startTime;
        this.lastTime = lastTime;
        this.pauseTime = pauseTime;
        this.status = status;
        this.chunkInfoList = chunkInfoList;
    }

    public TaskInfo() {
    }
}

