/*
 * Decompiled with CFR 0.152.
 */
package lee.study.down.model;

import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import java.io.Serializable;
import java.util.Map;
import lee.study.down.model.HttpHeadsInfo;
import lee.study.proxyee.util.ProtoUtil;

public class HttpRequestInfo
implements HttpRequest,
Serializable {
    private static final long serialVersionUID = -4521453515739581677L;
    private ProtoUtil.RequestProto requestProto;
    private HttpVer version;
    private String method;
    private String uri;
    private HttpHeaders headers;
    private byte[] content;

    public HttpRequestInfo(HttpVer version, String method, String uri, HttpHeaders headers, byte[] content) {
        this.version = version;
        this.method = method;
        this.uri = uri;
        this.headers = headers;
        this.content = content;
    }

    public HttpRequest setContent(byte[] content) {
        this.content = content;
        return this;
    }

    public byte[] content() {
        return this.content;
    }

    public ProtoUtil.RequestProto requestProto() {
        return this.requestProto;
    }

    public HttpRequest setRequestProto(ProtoUtil.RequestProto requestProto) {
        this.requestProto = requestProto;
        return this;
    }

    public HttpMethod method() {
        return new HttpMethod(this.method);
    }

    @Deprecated
    public HttpMethod getMethod() {
        return this.method();
    }

    public HttpRequest setMethod(HttpMethod method) {
        this.method = method.toString();
        return this;
    }

    public String uri() {
        return this.uri;
    }

    @Deprecated
    public String getUri() {
        return this.uri();
    }

    public HttpRequest setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public HttpVersion protocolVersion() {
        if (this.version == HttpVer.HTTP_1_0) {
            return HttpVersion.HTTP_1_0;
        }
        return HttpVersion.HTTP_1_1;
    }

    @Deprecated
    public HttpVersion getProtocolVersion() {
        return this.protocolVersion();
    }

    public HttpRequest setProtocolVersion(HttpVersion version) {
        this.version = version.minorVersion() == 0 ? HttpVer.HTTP_1_0 : HttpVer.HTTP_1_1;
        return this;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    @Deprecated
    public DecoderResult getDecoderResult() {
        return null;
    }

    public DecoderResult decoderResult() {
        return null;
    }

    public void setDecoderResult(DecoderResult result) {
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(decodeResult: ");
        buf.append(this.decoderResult());
        buf.append(", version: ");
        buf.append(this.protocolVersion());
        buf.append(')');
        buf.append('\n');
        buf.append(this.method());
        buf.append(' ');
        buf.append(this.uri());
        buf.append(' ');
        buf.append(this.protocolVersion());
        buf.append('\n');
        if (this.headers != null) {
            for (Map.Entry e : this.headers) {
                buf.append((String)e.getKey());
                buf.append(": ");
                buf.append((String)e.getValue());
                buf.append('\n');
            }
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public static HttpRequest adapter(HttpRequest httpRequest) {
        if (httpRequest instanceof DefaultHttpRequest) {
            HttpVer version = httpRequest.protocolVersion().minorVersion() == 0 ? HttpVer.HTTP_1_0 : HttpVer.HTTP_1_1;
            HttpHeadsInfo httpHeadsInfo = new HttpHeadsInfo();
            for (Map.Entry entry : httpRequest.headers()) {
                httpHeadsInfo.set((String)entry.getKey(), entry.getValue());
            }
            return new HttpRequestInfo(version, httpRequest.method().toString(), httpRequest.uri(), httpHeadsInfo, null);
        }
        return httpRequest;
    }

    public static enum HttpVer {
        HTTP_1_0,
        HTTP_1_1;

    }
}

