/*
 * Decompiled with CFR 0.152.
 */
package lee.study.down.io;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;

public class LargeMappedByteBuffer
implements Closeable {
    private List<MappedByteBuffer> bufferList;
    private long rawPosition;
    private long position;
    private long size;

    public LargeMappedByteBuffer(FileChannel fileChannel, FileChannel.MapMode mapMode, long position, long size) throws IOException {
        this.rawPosition = position;
        this.position = position;
        this.size = size;
        int count = (int)Math.ceil((double)size / 2.147483647E9);
        this.bufferList = new LinkedList<MappedByteBuffer>();
        long calcPos = position;
        for (int i = 0; i < count; ++i) {
            long calcSize = i + 1 == count ? size % Integer.MAX_VALUE : Integer.MAX_VALUE;
            this.bufferList.add(fileChannel.map(mapMode, calcPos, calcSize));
            calcPos += calcSize;
        }
    }

    public final void put(ByteBuffer byteBuffer) throws IOException {
        try {
            int index = this.getIndex();
            long length = byteBuffer.limit() - byteBuffer.position();
            this.position += length;
            MappedByteBuffer mappedBuffer = this.bufferList.get(index);
            if ((long)mappedBuffer.remaining() < length) {
                byte[] temp = new byte[mappedBuffer.remaining()];
                byteBuffer.get(temp);
                this.bufferList.get(index).put(temp);
                this.bufferList.get(index + 1).put(byteBuffer);
            } else {
                this.bufferList.get(index).put(byteBuffer);
            }
        }
        catch (Exception e) {
            throw new IOException("LargeMappedByteBuffer put rawPosition-" + this.rawPosition + "\tposition-" + this.position + "\tsize-" + this.size, e);
        }
    }

    private int getIndex() {
        return (int)((this.position - this.rawPosition) / Integer.MAX_VALUE);
    }

    @Override
    public void close() throws IOException {
        try {
            Class<?> clazz = Class.forName("sun.nio.ch.FileChannelImpl");
            Method m = clazz.getDeclaredMethod("unmap", MappedByteBuffer.class);
            m.setAccessible(true);
            for (MappedByteBuffer mappedBuffer : this.bufferList) {
                m.invoke(clazz, mappedBuffer);
            }
        }
        catch (Exception e) {
            throw new IOException("LargeMappedByteBuffer close", e);
        }
    }
}

