/*
 * Decompiled with CFR 0.152.
 */
package lee.study.down.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lee.study.down.util.ByteUtil;
import lee.study.down.util.FileUtil;

public class BdyZip {
    private static final byte[] ZIP_ENTRY_FILE_HEARD = new byte[]{80, 75, 3, 4, 10, 0, 0, 0, 0, 0};
    private static final byte[] ZIP_ENTRY_CENTRAL_HEARD = new byte[]{80, 75, 1, 2, 0, 0, 10, 0, 0, 0};
    private static final long _4G = 0x100000000L;
    private static final long _512M = 0x20900000L;
    private static final int EOCD_SIZE = 22;
    private static final int CENTRAL_COUNT_OFFSET = 10;
    private static final int CENTRAL_SIZE = 46;
    private static final int CENTRAL_NAME_OFFSET = 28;
    public static final String ON_START = "onStart";
    public static final String ON_FIX = "onFix";
    public static final String ON_FIX_DONE = "onFixDone";
    public static final String ON_ENTRY_START = "onEntryStart";
    public static final String ON_ENTRY_WRITE = "onEntryWrite";
    public static final String ON_DONE = "onDone";
    public static final String ON_ERROR = "onError";

    public static BdyZipEntry getNextBdyZipEntry(FileChannel fileChannel, long position) throws IOException {
        if (position > 0L) {
            fileChannel.position(position);
        }
        BdyZipEntry zipEntry = new BdyZipEntry();
        ByteBuffer buffer = ByteBuffer.allocate(30);
        fileChannel.read(buffer);
        buffer.flip();
        buffer.get(zipEntry.getHeader());
        buffer.get(zipEntry.getVersion());
        buffer.get(zipEntry.getGeneral());
        buffer.get(zipEntry.getMethod());
        buffer.get(zipEntry.getTime());
        buffer.get(zipEntry.getDate());
        buffer.get(zipEntry.getCrc32());
        byte[] bts4 = new byte[4];
        buffer.get(bts4);
        zipEntry.setCompressedSize(ByteUtil.btsToNumForSmall(bts4));
        buffer.get(bts4);
        zipEntry.setUnCompressedSize(ByteUtil.btsToNumForSmall(bts4));
        byte[] bts2 = new byte[2];
        buffer.get(bts2);
        zipEntry.setFileNameLength(ByteUtil.btsToNumForSmall(bts2));
        buffer.get(bts2);
        zipEntry.setExtraFieldLength(ByteUtil.btsToNumForSmall(bts2));
        ByteBuffer fileNameBuffer = ByteBuffer.allocate((int)zipEntry.getFileNameLength());
        fileChannel.read(fileNameBuffer);
        fileNameBuffer.flip();
        zipEntry.setFileName(Charset.forName("GB18030").decode(fileNameBuffer).toString());
        if (zipEntry.getExtraFieldLength() > 0L) {
            fileChannel.position(fileChannel.position() + zipEntry.getExtraFieldLength());
        }
        if (zipEntry.getCompressedSize() == 0L && (zipEntry.getFileName().length() == 0 || "/".equals(zipEntry.getFileName().substring(zipEntry.getFileName().length() - 1)))) {
            zipEntry.setDir(true);
        }
        zipEntry.setFileStartPosition(fileChannel.position());
        return zipEntry;
    }

    public static BdyZipEntry getNextBdyZipEntry(FileChannel fileChannel) throws IOException {
        return BdyZip.getNextBdyZipEntry(fileChannel, -1L);
    }

    public static BdyZipEntry getNextFixedBdyZipEntry(FileChannel fileChannel, List<String> centralList, BdyUnzipCallback callback) throws IOException {
        BdyZipEntry zipEntry = BdyZip.getNextBdyZipEntry(fileChannel);
        boolean fixFlag = false;
        if (ByteUtil.matchToken(fileChannel, zipEntry.getFileStartPosition(), zipEntry.getFileStartPosition() + zipEntry.getCompressedSize(), new byte[][]{ZIP_ENTRY_CENTRAL_HEARD})) {
            zipEntry.setEnd(true);
        } else if (!ByteUtil.matchToken(fileChannel, zipEntry.getFileStartPosition(), zipEntry.getFileStartPosition() + zipEntry.getCompressedSize(), new byte[][]{ZIP_ENTRY_FILE_HEARD})) {
            long fixedSize = BdyZip.fixedEntrySize(fileChannel, zipEntry, centralList, callback);
            if (fixedSize == -1L) {
                throw new RuntimeException("\u4fee\u590d\u5931\u8d25,\u6587\u4ef6\u635f\u574f\u8bf7\u91cd\u65b0\u4e0b\u8f7d");
            }
            zipEntry.setUnCompressedSize(fixedSize);
            zipEntry.setCompressedSize(fixedSize);
            if (ByteUtil.matchToken(fileChannel, zipEntry.getFileStartPosition() + zipEntry.getCompressedSize(), ZIP_ENTRY_CENTRAL_HEARD)) {
                zipEntry.setEnd(true);
                fixFlag = true;
            }
        }
        if (!zipEntry.isEnd()) {
            fileChannel.position(zipEntry.getFileStartPosition() + zipEntry.getCompressedSize());
        }
        if (callback != null && !fixFlag) {
            callback.onFix(fileChannel.size(), zipEntry.getFileStartPosition() + zipEntry.getCompressedSize());
        }
        return zipEntry;
    }

    private static long fixedEntrySize(FileChannel fileChannel, BdyZipEntry fixEntry, List<String> centralList, BdyUnzipCallback callback) throws IOException {
        long fixedSize = fixEntry.getCompressedSize();
        while (fixEntry.getFileStartPosition() + fixedSize <= fileChannel.size()) {
            BdyZipEntry nextEntry;
            fixedSize += 0x100000000L;
            if (callback != null) {
                callback.onFix(fileChannel.size(), fixEntry.getFileStartPosition() + fixedSize);
            }
            if (!ByteUtil.matchToken(fileChannel, fixEntry.getFileStartPosition(), fixEntry.getFileStartPosition() + fixedSize, ZIP_ENTRY_FILE_HEARD, ZIP_ENTRY_CENTRAL_HEARD) || !BdyZip.isRight(centralList, fixEntry, nextEntry = BdyZip.getNextBdyZipEntry(fileChannel, fixEntry.getFileStartPosition() + fixedSize))) continue;
            return fixedSize;
        }
        return -1L;
    }

    private static boolean isRight(List<String> centralList, BdyZipEntry fixEntry, BdyZipEntry nextEntry) {
        if (Arrays.equals(nextEntry.getHeader(), Arrays.copyOfRange(ZIP_ENTRY_CENTRAL_HEARD, 0, 4))) {
            return true;
        }
        if (centralList == null) {
            return true;
        }
        for (int i = 0; i < centralList.size(); ++i) {
            if (i + 1 >= centralList.size() || !centralList.get(i).equals(fixEntry.getFileName()) || !centralList.get(i + 1).equals(nextEntry.getFileName())) continue;
            return true;
        }
        return false;
    }

    public static List<BdyZipEntry> getFixedEntryList(FileChannel fileChannel, BdyUnzipCallback callback) throws IOException {
        BdyZipEntry entry;
        ArrayList<BdyZipEntry> list = new ArrayList<BdyZipEntry>();
        List<String> centralList = null;
        try {
            centralList = BdyZip.getCentralList(fileChannel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        fileChannel.position(0L);
        do {
            entry = BdyZip.getNextFixedBdyZipEntry(fileChannel, centralList, callback);
            list.add(entry);
        } while (!entry.isEnd());
        if (callback != null) {
            callback.onFixDone(list);
        }
        return list;
    }

    private static List<String> getCentralList(FileChannel fileChannel) throws IOException, IllegalArgumentException {
        ArrayList<String> centralList = new ArrayList<String>();
        ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        fileChannel.position(fileChannel.size() - 22L + 10L);
        fileChannel.read(byteBuffer);
        byteBuffer.flip();
        byte[] bts2 = new byte[2];
        byteBuffer.get(bts2);
        int centralCount = (int)ByteUtil.btsToNumForSmall(bts2);
        byte[] bts4 = new byte[4];
        byteBuffer.get(bts4);
        long centralSize = ByteUtil.btsToNumForSmall(bts4);
        fileChannel.position(fileChannel.size() - centralSize - 22L);
        ByteBuffer centralBuffer = ByteBuffer.allocate(46);
        for (int i = 0; i < centralCount; ++i) {
            centralBuffer.clear();
            fileChannel.read(centralBuffer);
            centralBuffer.flip();
            centralBuffer.position(28);
            centralBuffer.get(bts2);
            int nameSize = (int)ByteUtil.btsToNumForSmall(bts2);
            ByteBuffer nameBuffer = ByteBuffer.allocate(nameSize);
            fileChannel.read(nameBuffer);
            centralList.add(new String(nameBuffer.array(), "GB18030"));
        }
        return centralList;
    }

    public static void unzip(String path, String toPath, BdyUnzipCallback callback) throws Exception {
        try {
            if (callback != null) {
                callback.onStart();
            }
            File zipFile = new File(path);
            if (!FileUtil.exists(toPath)) {
                FileUtil.createDirSmart(toPath);
            }
            File toDir = new File(toPath);
            try (FileChannel fileChannel = new RandomAccessFile(zipFile, "rw").getChannel();){
                List<BdyZipEntry> list = BdyZip.getFixedEntryList(fileChannel, callback);
                for (BdyZipEntry zipEntry : list) {
                    if (callback != null) {
                        callback.onEntryStart(zipEntry);
                    }
                    long fileSize = zipEntry.getCompressedSize();
                    if (zipEntry.isDir()) {
                        FileUtil.createDirSmart(toPath + File.separator + zipEntry.getFileName());
                        if (callback == null) continue;
                        callback.onEntryWrite(0L, 0L);
                        continue;
                    }
                    File unzipFile = FileUtil.createFileSmart(toDir.getPath() + File.separator + zipEntry.getFileName());
                    FileChannel unzipChannel = new RandomAccessFile(unzipFile, "rw").getChannel();
                    long position = zipEntry.getFileStartPosition();
                    long remaining = fileSize;
                    while (remaining > 0L) {
                        long size = remaining > 0x20900000L ? 0x20900000L : remaining;
                        long transferred = fileChannel.transferTo(position, size, unzipChannel);
                        remaining -= transferred;
                        position += transferred;
                        if (callback == null) continue;
                        callback.onEntryWrite(fileSize, transferred);
                    }
                    unzipChannel.close();
                }
                if (callback != null) {
                    callback.onDone();
                }
            }
        }
        catch (Exception e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
    }

    public static void unzip(String path, String toPath) throws Exception {
        BdyZip.unzip(path, toPath, null);
    }

    public static void main(String[] args) throws Exception {
        BdyZip.unzip(args[0], args[1], new TestUnzipCallback());
    }

    public static boolean isBdyZip(String filePath) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(filePath, "rw");){
            byte[] speHeard = new byte[10];
            raf.read(speHeard);
            if (Arrays.equals(speHeard, ZIP_ENTRY_FILE_HEARD) || Arrays.equals(speHeard, ZIP_ENTRY_CENTRAL_HEARD)) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    static class TestUnzipCallback
    implements BdyUnzipCallback {
        TestUnzipCallback() {
        }

        @Override
        public void onStart() {
            System.out.println(BdyZip.ON_START);
        }

        @Override
        public void onFix(long totalSize, long fixSize) {
            System.out.println("onFix:" + totalSize + " " + fixSize);
        }

        @Override
        public void onFixDone(List<BdyZipEntry> list) {
            System.out.println(BdyZip.ON_FIX_DONE);
        }

        @Override
        public void onEntryStart(BdyZipEntry entry) {
            System.out.println("onEntryStart:" + entry.getFileName());
        }

        @Override
        public void onEntryWrite(long totalSize, long writeSize) {
        }

        @Override
        public void onDone() {
            System.out.println(BdyZip.ON_DONE);
        }

        @Override
        public void onError(Exception e) {
        }
    }

    public static interface BdyUnzipCallback {
        public void onStart();

        public void onFix(long var1, long var3);

        public void onFixDone(List<BdyZipEntry> var1);

        public void onEntryStart(BdyZipEntry var1);

        public void onEntryWrite(long var1, long var3);

        public void onDone();

        public void onError(Exception var1);
    }

    public static class BdyZipEntry {
        private byte[] header = new byte[4];
        private byte[] version = new byte[2];
        private byte[] general = new byte[2];
        private byte[] method = new byte[2];
        private byte[] time = new byte[2];
        private byte[] date = new byte[2];
        private byte[] crc32 = new byte[4];
        private long compressedSize;
        private long unCompressedSize;
        private long fileNameLength;
        private long extraFieldLength;
        private String fileName;
        private boolean isDir;
        private long fileStartPosition;
        private boolean isEnd;

        public byte[] getHeader() {
            return this.header;
        }

        public byte[] getVersion() {
            return this.version;
        }

        public byte[] getGeneral() {
            return this.general;
        }

        public byte[] getMethod() {
            return this.method;
        }

        public byte[] getTime() {
            return this.time;
        }

        public byte[] getDate() {
            return this.date;
        }

        public byte[] getCrc32() {
            return this.crc32;
        }

        public long getCompressedSize() {
            return this.compressedSize;
        }

        public long getUnCompressedSize() {
            return this.unCompressedSize;
        }

        public long getFileNameLength() {
            return this.fileNameLength;
        }

        public long getExtraFieldLength() {
            return this.extraFieldLength;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean isDir() {
            return this.isDir;
        }

        public long getFileStartPosition() {
            return this.fileStartPosition;
        }

        public boolean isEnd() {
            return this.isEnd;
        }

        public void setHeader(byte[] header) {
            this.header = header;
        }

        public void setVersion(byte[] version) {
            this.version = version;
        }

        public void setGeneral(byte[] general) {
            this.general = general;
        }

        public void setMethod(byte[] method) {
            this.method = method;
        }

        public void setTime(byte[] time) {
            this.time = time;
        }

        public void setDate(byte[] date) {
            this.date = date;
        }

        public void setCrc32(byte[] crc32) {
            this.crc32 = crc32;
        }

        public void setCompressedSize(long compressedSize) {
            this.compressedSize = compressedSize;
        }

        public void setUnCompressedSize(long unCompressedSize) {
            this.unCompressedSize = unCompressedSize;
        }

        public void setFileNameLength(long fileNameLength) {
            this.fileNameLength = fileNameLength;
        }

        public void setExtraFieldLength(long extraFieldLength) {
            this.extraFieldLength = extraFieldLength;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setDir(boolean isDir) {
            this.isDir = isDir;
        }

        public void setFileStartPosition(long fileStartPosition) {
            this.fileStartPosition = fileStartPosition;
        }

        public void setEnd(boolean isEnd) {
            this.isEnd = isEnd;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BdyZipEntry)) {
                return false;
            }
            BdyZipEntry other = (BdyZipEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getHeader(), other.getHeader())) {
                return false;
            }
            if (!Arrays.equals(this.getVersion(), other.getVersion())) {
                return false;
            }
            if (!Arrays.equals(this.getGeneral(), other.getGeneral())) {
                return false;
            }
            if (!Arrays.equals(this.getMethod(), other.getMethod())) {
                return false;
            }
            if (!Arrays.equals(this.getTime(), other.getTime())) {
                return false;
            }
            if (!Arrays.equals(this.getDate(), other.getDate())) {
                return false;
            }
            if (!Arrays.equals(this.getCrc32(), other.getCrc32())) {
                return false;
            }
            if (this.getCompressedSize() != other.getCompressedSize()) {
                return false;
            }
            if (this.getUnCompressedSize() != other.getUnCompressedSize()) {
                return false;
            }
            if (this.getFileNameLength() != other.getFileNameLength()) {
                return false;
            }
            if (this.getExtraFieldLength() != other.getExtraFieldLength()) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            if (this.isDir() != other.isDir()) {
                return false;
            }
            if (this.getFileStartPosition() != other.getFileStartPosition()) {
                return false;
            }
            return this.isEnd() == other.isEnd();
        }

        protected boolean canEqual(Object other) {
            return other instanceof BdyZipEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getHeader());
            result = result * 59 + Arrays.hashCode(this.getVersion());
            result = result * 59 + Arrays.hashCode(this.getGeneral());
            result = result * 59 + Arrays.hashCode(this.getMethod());
            result = result * 59 + Arrays.hashCode(this.getTime());
            result = result * 59 + Arrays.hashCode(this.getDate());
            result = result * 59 + Arrays.hashCode(this.getCrc32());
            long $compressedSize = this.getCompressedSize();
            result = result * 59 + (int)($compressedSize >>> 32 ^ $compressedSize);
            long $unCompressedSize = this.getUnCompressedSize();
            result = result * 59 + (int)($unCompressedSize >>> 32 ^ $unCompressedSize);
            long $fileNameLength = this.getFileNameLength();
            result = result * 59 + (int)($fileNameLength >>> 32 ^ $fileNameLength);
            long $extraFieldLength = this.getExtraFieldLength();
            result = result * 59 + (int)($extraFieldLength >>> 32 ^ $extraFieldLength);
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            result = result * 59 + (this.isDir() ? 79 : 97);
            long $fileStartPosition = this.getFileStartPosition();
            result = result * 59 + (int)($fileStartPosition >>> 32 ^ $fileStartPosition);
            result = result * 59 + (this.isEnd() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "BdyZip.BdyZipEntry(header=" + Arrays.toString(this.getHeader()) + ", version=" + Arrays.toString(this.getVersion()) + ", general=" + Arrays.toString(this.getGeneral()) + ", method=" + Arrays.toString(this.getMethod()) + ", time=" + Arrays.toString(this.getTime()) + ", date=" + Arrays.toString(this.getDate()) + ", crc32=" + Arrays.toString(this.getCrc32()) + ", compressedSize=" + this.getCompressedSize() + ", unCompressedSize=" + this.getUnCompressedSize() + ", fileNameLength=" + this.getFileNameLength() + ", extraFieldLength=" + this.getExtraFieldLength() + ", fileName=" + this.getFileName() + ", isDir=" + this.isDir() + ", fileStartPosition=" + this.getFileStartPosition() + ", isEnd=" + this.isEnd() + ")";
        }
    }
}

