/*
 * Decompiled with CFR 0.152.
 */
package lee.study.down.content;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lee.study.down.boot.AbstractHttpDownBootstrap;
import lee.study.down.boot.HttpDownBootstrapFactory;
import lee.study.down.constant.HttpDownConstant;
import lee.study.down.content.ContentManager;
import lee.study.down.dispatch.HttpDownCallback;
import lee.study.down.model.HttpDownInfo;
import lee.study.down.model.HttpRequestInfo;
import lee.study.down.model.TaskInfo;
import lee.study.down.mvc.form.TaskInfoForm;
import lee.study.down.mvc.form.WsForm;
import lee.study.down.util.ByteUtil;
import lee.study.down.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DownContent {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownContent.class);
    private static Map<String, AbstractHttpDownBootstrap> downContent;

    public HttpDownInfo getDownInfo(String id) {
        if (downContent.containsKey(id)) {
            return ((AbstractHttpDownBootstrap)downContent.get(id)).getHttpDownInfo();
        }
        return null;
    }

    public List<HttpDownInfo> getDownInfos() {
        ArrayList<HttpDownInfo> httpDownInfoList = new ArrayList<HttpDownInfo>();
        for (String id : downContent.keySet()) {
            HttpDownInfo httpDownInfo = this.getDownInfo(id);
            httpDownInfoList.add(httpDownInfo);
        }
        return httpDownInfoList;
    }

    public TaskInfo getTaskInfo(String id) {
        HttpDownInfo httpDownInfo = this.getDownInfo(id);
        if (httpDownInfo != null) {
            return httpDownInfo.getTaskInfo();
        }
        return null;
    }

    public List<TaskInfo> getStartTasks() {
        ArrayList<TaskInfo> taskInfoList = new ArrayList<TaskInfo>();
        for (String id : downContent.keySet()) {
            TaskInfo taskInfo = this.getTaskInfo(id);
            if (taskInfo == null || taskInfo.getStatus() == 0) continue;
            taskInfoList.add(taskInfo);
        }
        return taskInfoList;
    }

    public List<TaskInfo> getDowningTasks() {
        ArrayList<TaskInfo> taskInfoList = new ArrayList<TaskInfo>();
        for (String id : downContent.keySet()) {
            TaskInfo taskInfo = this.getTaskInfo(id);
            if (taskInfo == null || taskInfo.getStatus() != 4) continue;
            taskInfoList.add(taskInfo);
        }
        return taskInfoList;
    }

    public TaskInfo getWaitTask() {
        for (String id : downContent.keySet()) {
            TaskInfo taskInfo = this.getTaskInfo(id);
            if (taskInfo == null || taskInfo.getStatus() != 0) continue;
            return taskInfo;
        }
        return null;
    }

    public WsForm buildWsForm(String taskId) {
        ArrayList<TaskInfo> list = new ArrayList<TaskInfo>();
        TaskInfo taskInfo = this.getTaskInfo(taskId);
        if (taskInfo == null) {
            return null;
        }
        list.add(taskInfo);
        return new WsForm(1, (Object)DownContent.setUrl(list));
    }

    public WsForm buildDowningWsForm() {
        List list = this.getDowningTasks();
        if (list == null || list.size() == 0) {
            return null;
        }
        return new WsForm(1, (Object)DownContent.setUrl((List)list));
    }

    public static List<TaskInfoForm> setUrl(List<TaskInfo> taskInfoList) {
        ArrayList<TaskInfoForm> ret = new ArrayList<TaskInfoForm>();
        for (TaskInfo taskInfo : taskInfoList) {
            TaskInfoForm taskInfoForm = new TaskInfoForm();
            BeanUtils.copyProperties((Object)taskInfo, (Object)taskInfoForm);
            HttpRequestInfo httpRequest = (HttpRequestInfo)ContentManager.DOWN.getDownInfo(taskInfo.getId()).getRequest();
            String uri = httpRequest.uri();
            String host = httpRequest.requestProto().getHost();
            String url = (uri.indexOf("/") == 0 ? host : "") + uri;
            if (url.indexOf("http://") != 0 && url.indexOf("https://") != 0) {
                url = (httpRequest.requestProto().getSsl() ? "https://" : "http://") + url;
            }
            taskInfoForm.setUrl(url);
            ret.add(taskInfoForm);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBoot(AbstractHttpDownBootstrap bootstrap) {
        Map map = downContent;
        synchronized (map) {
            TaskInfo taskInfo;
            if (bootstrap.getHttpDownInfo().getTaskInfo().getStatus() == 0 && (taskInfo = this.getWaitTask()) != null) {
                downContent.remove(taskInfo.getId());
            }
            downContent.put(bootstrap.getHttpDownInfo().getTaskInfo().getId(), bootstrap);
        }
    }

    public void putBoot(HttpDownInfo httpDownInfo) {
        AbstractHttpDownBootstrap bootstrap = HttpDownBootstrapFactory.create((HttpDownInfo)httpDownInfo, (int)ContentManager.CONFIG.get().getRetryCount(), (SslContext)HttpDownConstant.clientSslContext, (NioEventLoopGroup)HttpDownConstant.clientLoopGroup, (HttpDownCallback)HttpDownConstant.httpDownCallback);
        TaskInfo taskInfo = bootstrap.getHttpDownInfo().getTaskInfo();
        if (taskInfo.isSupportRange()) {
            taskInfo.setConnections(ContentManager.CONFIG.get().getConnections());
        }
        taskInfo.setFilePath(ContentManager.CONFIG.get().getLastPath());
        this.putBoot(bootstrap);
    }

    public void removeBoot(String id) {
        downContent.remove(id);
    }

    public static AbstractHttpDownBootstrap getBoot(String id) {
        return (AbstractHttpDownBootstrap)downContent.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            List httpDownInfo;
            List list = httpDownInfo = this.getDownInfos();
            synchronized (list) {
                ByteUtil.serialize((Serializable)((Serializable)((Object)httpDownInfo)), (String)HttpDownConstant.TASK_RECORD_PATH);
            }
        }
        catch (IOException e) {
            LOGGER.error("\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTask(String id) {
        block5: {
            try {
                TaskInfo taskInfo = this.getTaskInfo(id);
                if (taskInfo == null) break block5;
                TaskInfo taskInfo2 = taskInfo;
                synchronized (taskInfo2) {
                    ByteUtil.serialize((Serializable)taskInfo, (String)taskInfo.buildTaskRecordFilePath(), (String)taskInfo.buildTaskRecordBakFilePath());
                }
            }
            catch (IOException e) {
                LOGGER.warn("\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    public void init() {
        downContent = new ConcurrentHashMap();
        if (FileUtil.exists((String)HttpDownConstant.TASK_RECORD_PATH)) {
            try {
                List records = (List)ByteUtil.deserialize((String)HttpDownConstant.TASK_RECORD_PATH);
                for (HttpDownInfo httpDownInfo : records) {
                    AbstractHttpDownBootstrap bootstrap = HttpDownBootstrapFactory.create((HttpDownInfo)httpDownInfo, (int)ContentManager.CONFIG.get().getRetryCount(), (SslContext)HttpDownConstant.clientSslContext, (NioEventLoopGroup)HttpDownConstant.clientLoopGroup, (HttpDownCallback)HttpDownConstant.httpDownCallback);
                    TaskInfo taskInfo = httpDownInfo.getTaskInfo();
                    if (taskInfo.getStatus() == 0) continue;
                    if (taskInfo.getStatus() != 7) {
                        String taskDetailPath = taskInfo.buildTaskRecordFilePath();
                        String taskDetailBakPath = taskInfo.buildTaskRecordBakFilePath();
                        if (FileUtil.existsAny((String[])new String[]{taskDetailPath, taskDetailBakPath})) {
                            try {
                                taskInfo = (TaskInfo)ByteUtil.deserialize((String)taskDetailPath, (String)taskDetailBakPath);
                                httpDownInfo.setTaskInfo(taskInfo);
                            }
                            catch (IOException | ClassNotFoundException e) {
                                taskInfo.reset();
                            }
                        } else {
                            taskInfo.reset();
                        }
                        if (taskInfo.getStatus() == 8) {
                            taskInfo.setStatus(9);
                        } else if (taskInfo.getStatus() != 6) {
                            taskInfo.setStatus(5);
                            taskInfo.getChunkInfoList().forEach(chunk -> {
                                if (chunk.getStatus() != 7) {
                                    chunk.setStatus(5);
                                }
                            });
                        }
                    }
                    this.putBoot(bootstrap);
                }
            }
            catch (Exception e) {
                LOGGER.warn("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }
}

