// ShortcutIcon.cpp : implementation file
//

#include "stdafx.h"
#include "ShortcutIcon.h"
#include <shlobj.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

void CreateShortcut(const char* pszSrcFile, const char* pszTgtPath) 
{ 
	HRESULT hres; 

	IShellLink* psl = NULL; 
	hres = CoCreateInstance(CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER, IID_IShellLink, (LPVOID*) &psl); 
	if (psl) 
	{ 
		psl->SetPath(pszSrcFile); 
		//psl->SetArguments(Arguments);
		{
			char szNewPath[MAX_PATH];
			lstrcpy(szNewPath, pszSrcFile);
			char* p = strrchr(szNewPath, '\\');
			if (*(p-1) == ':') p++;
			*p = '\0';
			psl->SetWorkingDirectory(szNewPath); 
		}

		IPersistFile* ppf = NULL; 
		hres = psl->QueryInterface( IID_IPersistFile, (LPVOID *) &ppf); 
		if (ppf) 
		{
			// in fact, explorer will automatically eat ".lnk" when show short cut file name
			// so keep original extention name will cause a automatic icon
			WORD wsz[MAX_PATH]; 
			MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, pszTgtPath, -1, wsz,MAX_PATH); 

			hres = ppf->Save(wsz, TRUE); 

			ppf->Release(); 
		} 
		psl->Release(); 
	} 
}

void CreateShortcutName(const char* pszSrcFile, const char* pszTgtDir, char* pszTgtPath) 
{
	PathCombine(pszTgtPath, pszTgtDir, PathFindFileName(pszSrcFile));
	PathRenameExtension(pszTgtPath, ".lnk");
	/*
	lstrcpy(pszTgtPath, pszTgtDir);
	lstrcat(pszTgtPath, strrchr(pszSrcFile, '\\'));
	*(pszTgtPath + lstrlen(pszTgtPath) - 4) = 0;
	lstrcat(pszTgtPath, ".lnk");
	*/
}

void SureToDeleteFile(const char* pszPath, HWND hwnd)
{
	char szFileName[_MAX_PATH+1];
	ZeroMemory(szFileName, sizeof(szFileName));
	lstrcpy(szFileName, pszPath);

	SHFILEOPSTRUCT fop;
	ZeroMemory(&fop, sizeof(SHFILEOPSTRUCT));
	fop.hwnd = hwnd;
	fop.wFunc = FO_DELETE;
	fop.pFrom = szFileName;
	fop.fFlags = FOF_NOCONFIRMATION | FOF_NOERRORUI | FOF_SILENT;
	SHFileOperation(&fop);
}

BOOL IsShortcutCreated() 
{
	BOOL bRet = FALSE;

	char szPath[MAX_PATH];
	GetModuleFileName(NULL, szPath, sizeof(szPath));
	HWND hWnd = AfxGetApp()->m_pMainWnd->m_hWnd;

	char szTgtDir[MAX_PATH];
	char szTgtPath[MAX_PATH];
	CFileStatus rStatus;
	
	*szTgtDir = '\0';
	{
		LPITEMIDLIST	pidlShellItem = NULL;
		HRESULT hr = SHGetSpecialFolderLocation(hWnd, CSIDL_STARTUP, &pidlShellItem);
		if(!FAILED(hr)) 
		{ 
			// We did get an ID list, convert it to a long pathname 
			SHGetPathFromIDList(pidlShellItem, szTgtDir); 
			
			// Free the ID list allocated by ParseDisplayName 
			LPMALLOC pMalloc = NULL; 
			SHGetMalloc(&pMalloc); 
			pMalloc->Free(pidlShellItem); 
			pMalloc->Release(); 
		} 
	}
	if (*szTgtDir)
	{
		CreateShortcutName(szPath, szTgtDir, szTgtPath);
		bRet = CFile::GetStatus(szTgtPath, rStatus);
	}

	return bRet;
}

void ShortcutOpt(BOOL bCreateIt) 
{
	char szPath[MAX_PATH];
	GetModuleFileName(NULL, szPath, sizeof(szPath));
	HWND hWnd = AfxGetApp()->m_pMainWnd->m_hWnd;
	
	char szTgtDir[MAX_PATH];
	char szTgtPath[MAX_PATH];
	
	*szTgtDir = '\0';
	{
		LPITEMIDLIST	pidlShellItem = NULL;
		HRESULT hr = SHGetSpecialFolderLocation(hWnd, CSIDL_STARTUP, &pidlShellItem);
		if(!FAILED(hr)) 
		{ 
			// We did get an ID list, convert it to a long pathname 
			SHGetPathFromIDList(pidlShellItem, szTgtDir); 
			
			// Free the ID list allocated by ParseDisplayName 
			LPMALLOC pMalloc = NULL; 
			SHGetMalloc(&pMalloc); 
			pMalloc->Free(pidlShellItem); 
			pMalloc->Release(); 
		} 
	}
	if (*szTgtDir)
	{
		CreateShortcutName(szPath, szTgtDir, szTgtPath);
		if (bCreateIt)
			CreateShortcut(szPath, szTgtPath);
		else
			SureToDeleteFile(szTgtPath, hWnd);
	}
}
