// PopCDDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PopCD.h"
#include "PopCDDlg.h"
#include "Registry.h"
#include "DlgOption.h"
#include "Globle.h"
#include <dbt.h>
#include "aboutbox.h"
#include "ShortcutIcon.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define	WM_ICON_NOTIFY			WM_USER+10

const char c_strRegKey[] = "PopCD";
const UINT WM_TASKBARCREATED = 
     ::RegisterWindowMessage(_T("TaskbarCreated"));

/////////////////////////////////////////////////////////////////////////////
// CPopCDDlg dialog

CPopCDDlg::CPopCDDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPopCDDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPopCDDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
}

void CPopCDDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPopCDDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPopCDDlg, CDialog)
	//{{AFX_MSG_MAP(CPopCDDlg)
	ON_WM_DESTROY()
	ON_COMMAND(ID_POP_EXIT, OnPopExit)
	ON_COMMAND(ID_POP_OPTION, OnPopOption)
	ON_COMMAND(ID_POP_AUTO_START, OnPopAutoStart)
	ON_COMMAND(ID_POP_HELP, OnPopHelp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_WM_QUERYENDSESSION()
	ON_COMMAND(ID_OPEN_ALL, OnOpenAll)
	ON_COMMAND(ID_CLOSE_ALL, OnCloseAll)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_ICON_NOTIFY, OnTrayNotification)
	ON_REGISTERED_MESSAGE(WM_TASKBARCREATED, OnTaskBarCreated)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPopCDDlg message handlers

BOOL CPopCDDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here
	TaskBarAddIcon();
	ReadOption();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

LONG CPopCDDlg::OnTaskBarCreated(WPARAM wp, LPARAM lp)
{
	TaskBarAddIcon();
	return 0;
}

// If the function succeeds, the return value is nonzero.
BOOL CPopCDDlg::TaskBarAddIcon() 
{ 
	NOTIFYICONDATA tnid; 

	tnid.cbSize = sizeof(NOTIFYICONDATA); 
	tnid.hWnd = m_hWnd; 
	tnid.uID = IDR_POPUP; 
	tnid.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP; 
	tnid.uCallbackMessage = WM_ICON_NOTIFY; 
	tnid.hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME); 
	lstrcpy(tnid.szTip, "PopCD"); 

	return Shell_NotifyIcon(NIM_ADD, &tnid);
} 

BOOL CPopCDDlg::TaskBarDeleteIcon() 
{ 
	BOOL res; 
	NOTIFYICONDATA tnid; 

	tnid.cbSize = sizeof(NOTIFYICONDATA); 
	tnid.hWnd = m_hWnd; 
	tnid.uID = IDR_POPUP; 
     
	res = Shell_NotifyIcon(NIM_DELETE, &tnid); 
	return res;
} 
/*
BOOL CPopCDDlg::TaskBarModifyIcon(BOOL bIn) 
{ 
	BOOL res; 
	NOTIFYICONDATA tnid; 

	tnid.cbSize = sizeof(NOTIFYICONDATA); 
	tnid.hWnd = m_hWnd; 
	tnid.uID = IDR_POPUP; 
 	tnid.uFlags = NIF_ICON | NIF_TIP;
	if (bIn) {
		tnid.hIcon = AfxGetApp()->LoadIcon(IDI_ICON_IN); 
		lstrcpy(tnid.szTip, "Pop CD"); 
	}
	else {
		tnid.hIcon = AfxGetApp()->LoadIcon(IDI_ICON_OUT); 
		lstrcpy(tnid.szTip, "Push CD"); 
	}
    
	res = Shell_NotifyIcon(NIM_MODIFY, &tnid); 
	return res;
} 
*/
LRESULT CPopCDDlg::OnTrayNotification(WPARAM wParam, LPARAM lParam)
{
    //Return quickly if its not for this tray icon
    if (wParam != IDR_POPUP)
        return 0L;

    CMenu menu, *pSubMenu;

    // Clicking with right button brings up a context menu
    if (LOWORD(lParam) == WM_RBUTTONUP)
    {    
        if (!menu.LoadMenu(IDR_POPUP)) return 0;
        if (!(pSubMenu = menu.GetSubMenu(0))) return 0;

		if (CheckLink())
			pSubMenu->CheckMenuItem(ID_POP_AUTO_START, MF_BYCOMMAND|MF_CHECKED);
		else
			pSubMenu->CheckMenuItem(ID_POP_AUTO_START, MF_BYCOMMAND|MF_UNCHECKED);

		InsertCDMenu(menu);

        //Display and track the popup menu
        CPoint pos;
        GetCursorPos(&pos);

        ::SetForegroundWindow(m_hWnd);  
        int iRet = ::TrackPopupMenu(pSubMenu->m_hMenu, TPM_RETURNCMD, pos.x, pos.y, 0, m_hWnd, NULL);
		OnMenuMsg(menu, iRet);

        // BUGFIX: See "PRB: Menus for Notification Icons Don't Work Correctly"
        ::PostMessage(m_hWnd, WM_NULL, 0, 0);

        menu.DestroyMenu();
    } 
    else if (LOWORD(lParam) == WM_LBUTTONDOWN) 
    {
        // mouse click received, the default action is to isplay a window with additional information
		PopCD();
	}
    else if (LOWORD(lParam) == WM_LBUTTONDBLCLK) 
    {
        // double click received, the default action is to execute first menu item
		PushCD();
    }
    else if (LOWORD(lParam) ==  WM_MOUSEMOVE) 
    {
        // mouse move received, the default action is to show tool tip of the icon
    }

    return 1;
}

void CPopCDDlg::OnDestroy() 
{
	TaskBarDeleteIcon();

	CDialog::OnDestroy();
}

void CPopCDDlg::OnPopExit() 
{
	// TODO: Add your command handler code here
	DestroyWindow();
	//CDialog::OnOK();
}

void CPopCDDlg::OnCancel() 
{
}

void CPopCDDlg::OnOK() 
{
}

BOOL CPopCDDlg::Create() 
{
	return CDialog::Create(IDD);
}

void CPopCDDlg::OnPopOption() 
{
	// TODO: Add your command handler code here
	CDlgOption dlg;
	dlg.DoModal();
}

void CPopCDDlg::OnPopAutoStart() 
{
	// TODO: Add your command handler code here
	CRegistry regkey;
	regkey.Open(HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run");
	if (CheckLink())
	{
		regkey.DeleteValue(c_strRegKey);
		ShortcutOpt(FALSE);
	}
	else
	{
		char szModuleName[_MAX_PATH];
		::GetModuleFileName(NULL, szModuleName,
							sizeof(szModuleName));
		if (!regkey.Write(c_strRegKey, szModuleName))
			ShortcutOpt(TRUE);
	}
	regkey.Close();
}

BOOL CPopCDDlg::CheckLink()
{
	BOOL bRet = FALSE;
	{
		CRegistry regkey;
		CString strVal;
		regkey.Open(HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run");
		bRet = regkey.Read(c_strRegKey, strVal);
		regkey.Close();
	}
	if (!bRet)
		bRet = IsShortcutCreated();
	return bRet;
}

void CPopCDDlg::OnPopHelp() 
{
	// TODO: Add your command handler code here
	CString strMsg;
	strMsg = "To open your CD tray just click once on the icon right-below.";
	strMsg += "\nTo close it click twice on the icon.";

	strMsg += "\n\nIf you have more than one CD drive,\n";
	strMsg += "please set the default one by Option menu,\n";
	strMsg += "or click it's name in menu to open it.\n";
	strMsg += "If you click the drive name in menu while pressing Ctrl key,\n";
	strMsg += "It will close the CD tray.";

	MessageBox(strMsg, "Help for PopCD");
}

void CPopCDDlg::OnAppAbout() 
{
	// TODO: Add your command handler code here
    CAboutDlg aboutDlg;
    aboutDlg.DoModal();
}

BOOL CPopCDDlg::OnQueryEndSession() 
{
	if (!CDialog::OnQueryEndSession())
		return FALSE;
	
	// TODO: Add your specialized query end session code here
	if (g_bPopWhenExit) {
		int d;
		char szRootPathName[] = " :\\";
		char chDefaultDrive = g_chDefaultDrive;
		BOOL bPoped = FALSE;

		for (d = 1; d <= 26; d++) {
			*szRootPathName = d + 'A' - 1;
			if (GetDriveType(szRootPathName) == DRIVE_CDROM) {
				g_chDefaultDrive = *szRootPathName;
				if (CheckRM(g_chDefaultDrive)) {
					PopCD();
					bPoped = TRUE;
				}
			}
		}
		if (bPoped) {
			AfxMessageBox("Please take your CD, then click OK.");

			for (d = 1; d <= 26; d++) {
				*szRootPathName = d + 'A' - 1;
				if (GetDriveType(szRootPathName) == DRIVE_CDROM) {
					g_chDefaultDrive = *szRootPathName;
					PushCD();
				}
			}
		}

		g_chDefaultDrive = chDefaultDrive;
	}
	
	return TRUE;
}

void CPopCDDlg::OnOpenAll() 
{
	// TODO: Add your command handler code here
	CD_OpenCloseAllDrives(TRUE);
}

void CPopCDDlg::OnCloseAll() 
{
	// TODO: Add your command handler code here
	CD_OpenCloseAllDrives(FALSE);
}

void CPopCDDlg::OnMenuMsg(CMenu& menu, int nID) 
{
	if ((nID > ID_CLOSE_ALL) && (nID < ID_APP_ABOUT))
	{
		char szName[128];
		menu.GetMenuString(nID, szName, sizeof(szName), MF_BYCOMMAND);
		char* p = strchr(szName, ':');
		p--;
		if (GetKeyState(VK_CONTROL) & 0x8000)
			PushCD(*p);
		else
			PopCD(*p);
	}
	else
	{
        ::PostMessage(m_hWnd, WM_COMMAND, nID, BN_CLICKED);
	}
}

