#include "stdafx.h"
#include "PopCD.h"
#include "Globle.h"
#include "mmsystem.h"	// For mci functions

char		g_chDefaultDrive;
BOOL		g_bPopWhenExit;

static TCHAR BASED_CODE szSection[] = _T("Option");
static TCHAR BASED_CODE szDefaultDrive[] = _T("DefaultDrive");
static TCHAR BASED_CODE szPopWhenExit[] = _T("PopWhenExit");

void WriteOption()
{
	CWinApp* pApp = AfxGetApp();
	pApp->WriteProfileInt(szSection, szDefaultDrive, (int)g_chDefaultDrive);
	pApp->WriteProfileInt(szSection, szPopWhenExit, (int)g_bPopWhenExit);
}

void ReadOption()
{
	CWinApp* pApp = AfxGetApp();
	g_chDefaultDrive = (char)pApp->GetProfileInt(szSection, szDefaultDrive, 0);
	g_bPopWhenExit = (BOOL)pApp->GetProfileInt(szSection, szPopWhenExit, 0);

	char szRootPathName[] = " :\\";
	if (g_chDefaultDrive != 0) {
		*szRootPathName = g_chDefaultDrive;
		if (GetDriveType(szRootPathName) != DRIVE_CDROM) {
			g_chDefaultDrive = 0;
		}
	}

	if (g_chDefaultDrive == 0) {
		for (int d = 1; d <= 26; d++) {
			*szRootPathName = d + 'A' - 1;
			if (GetDriveType(szRootPathName) == DRIVE_CDROM) {
				g_chDefaultDrive = *szRootPathName;
				break;
			}
		}
	}
}

/********************************************************************************\ 
*    FUNCTION: CheckRM(LPTSTR) * 
*    PURPOSE: Verifies that a removeable media drive contains a disk * 
*    COMMENTS: * 
*        This function is called each time a drive type is determined to be 
*        removeable (DRIVE_REMOVEABLE).  An attempt is made to open a 
*        file in the root directory of the drive.  If the attempt succeeds, 
*        then media is present in the drive and subsequent calls to the 
*        drive can be safely made.  If the call fails, then there is no media 
*        present in the drive and no attempts should be made to access this 
*        drive.  The Error Mode is temporarily set to 1 to allow failures 
*        to immediately return to the calling program.  This eliminates 
*        unwanted dialog boxes that prompt for disks to be placed in the 
*        drive. * 
*    INPUT: szDriveName - removeable media drive name (ex - "a:") * 
*    OUTPUT: Returns TRUE if media present 
*                    FALSE if media is not present 
\*********************************************************************************/ 
BOOL CheckRM(char chDrive) 
{ 
	TCHAR    szFileName[] = "c:\\.";
	DWORD    dwHold;  

	SetErrorMode( SEM_FAILCRITICALERRORS ); 
	*szFileName = chDrive;
	dwHold = GetFileAttributes( szFileName );
	SetErrorMode( 0 );  
	//  If no error, media must be in drive.
	if( dwHold != 0xFFFFFFFF ) { 
		return(TRUE);
	}
	else {
		dwHold = GetLastError(); 
		if( dwHold != ERROR_NOT_READY ) 
			TRACE(TEXT("CheckRM: Get Removable Media Info Failure."));  

		return(FALSE);
	}
}

void PopCD()
{
	PopCD(g_chDefaultDrive);
}

void PopCD(char chDrive)
{
	chDrive &= 0xdf;
	CD_OpenCloseDrive(TRUE, chDrive);
}

void PushCD()
{
	PushCD(g_chDefaultDrive);
}

void PushCD(char chDrive)
{
	chDrive &= 0xdf;
	CD_OpenCloseDrive(FALSE, chDrive);
}

void InsertCDMenu(CMenu& menu)
{
	char szDrives[128];
	char szOpen[128];
	UINT dwID = ID_CLOSE_ALL + 1;
	UINT uiPos = ID_POP_OPTION;
	BOOL bInserted = FALSE;

	GetLogicalDriveStrings(sizeof(szDrives), szDrives);

	for (char* pszDrive = szDrives; *pszDrive != '\0'; pszDrive += lstrlen(pszDrive), pszDrive++)
	{
		(*pszDrive) = (*pszDrive) & 0xdf;
		if (GetDriveType(pszDrive) != DRIVE_CDROM)
			continue;
		if ((*pszDrive) == g_chDefaultDrive)
			continue;

		ZeroMemory(szOpen, sizeof(szOpen));
		*szOpen = (*pszDrive);
		lstrcat(szOpen, ":");
		GetVolumeName(pszDrive, (szOpen + lstrlen(szOpen)));
		menu.InsertMenu(uiPos, MF_STRING, dwID, szOpen);
		dwID++; //uiPos++;

		bInserted = TRUE;
	}

	if (bInserted)
		menu.InsertMenu(uiPos, MF_SEPARATOR);
}

void GetVolumeName(LPCTSTR pszRoot, char* pszName)
{
	GetVolumeInformation(pszRoot,
		  pszName,
		  128,
		  NULL,
		  NULL,
		  NULL,
		  NULL,
		  0
	);
}

// Open or Close CD Drive
// cDrive is Drive Letter to Open, or 0x01 for 'Default' drive
// Examples:
//    CD_OpenCloseDrive(TRUE, 'G');   // Open CD Door for Drive G: 
//    CD_OpenCloseDrive(FALSE, 'G');  // Close CD Door for Drive G:
//    CD_OpenCloseDrive(TRUE, 1);     // Open First Logical CD Drive Door
void CD_OpenCloseDrive(BOOL bOpenDrive, TCHAR cDrive)
{
	MCI_OPEN_PARMS op;
	MCI_STATUS_PARMS st;
	DWORD flags;
	
	TCHAR szDriveName[4];
	strcpy(szDriveName, "X:");
	
	::ZeroMemory(&op, sizeof(MCI_OPEN_PARMS));
	op.lpstrDeviceType = (LPCSTR) MCI_DEVTYPE_CD_AUDIO;
	
	if(cDrive > 1)
	{
		szDriveName[0] = cDrive;
		op.lpstrElementName = szDriveName;
		flags = MCI_OPEN_TYPE | MCI_OPEN_TYPE_ID | MCI_OPEN_ELEMENT | MCI_OPEN_SHAREABLE;
	}
	else flags = MCI_OPEN_TYPE | MCI_OPEN_TYPE_ID | MCI_OPEN_SHAREABLE;
	
	if (!mciSendCommand(0,MCI_OPEN,flags,(unsigned long)&op)) 
	{
		st.dwItem = MCI_STATUS_READY;
		
		if(bOpenDrive)
			mciSendCommand(op.wDeviceID,MCI_SET,MCI_SET_DOOR_OPEN,0);
		else
			mciSendCommand(op.wDeviceID,MCI_SET,MCI_SET_DOOR_CLOSED,0);
		
		mciSendCommand(op.wDeviceID,MCI_CLOSE,MCI_WAIT,0);
	}
}


void CD_OpenCloseAllDrives(BOOL bOpenDrives)
{
	// Determine All CD Drives and Open (or Close) each one
	int nPos = 0;
	UINT nCount = 0;
	TCHAR szDrive[4];
	strcpy(szDrive, "?:\\");
	
	DWORD dwDriveList = ::GetLogicalDrives ();
	
	while (dwDriveList) {
		if (dwDriveList & 1) 
		{
			szDrive[0] = 0x41 + nPos;
			if(::GetDriveType(szDrive) == DRIVE_CDROM)
				CD_OpenCloseDrive(bOpenDrives, szDrive[0]);
		}
		dwDriveList >>= 1;
		nPos++;
	}
}
