// DlgOption.cpp : implementation file
//

#include "stdafx.h"
#include "PopCD.h"
#include "DlgOption.h"
#include "Globle.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgOption dialog


CDlgOption::CDlgOption(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgOption::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgOption)
	m_bPopWhenExit = FALSE;
	//}}AFX_DATA_INIT
}


void CDlgOption::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgOption)
	DDX_Check(pDX, IDC_CHECK_POP_DISK, m_bPopWhenExit);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgOption, CDialog)
	//{{AFX_MSG_MAP(CDlgOption)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgOption message handlers

BOOL CDlgOption::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_AboutIcon.SubclassDlgItem (IDC_STATIC_ABOUT, this);

	CComboBox * pCB = (CComboBox *) GetDlgItem(IDC_COMBO_DEFAULT_DRIVE);
	char s[] = " :";
	char szRootPathName[] = " :\\";
	
	for (int d = 1; d <= 26; d++)
	{
		*szRootPathName = d + 'A' - 1;
		if (GetDriveType(szRootPathName) == DRIVE_CDROM)
		{
			*s = *szRootPathName;
			pCB->AddString(s);
		}
	}

	if (g_chDefaultDrive == 0)
	{
		if (pCB->GetCount() > 0)
			pCB->SetCurSel(0);
	}
	else
	{
		*s = g_chDefaultDrive;
		pCB->SelectString(-1, s);
	}
	
	UpdateData();
	m_bPopWhenExit = g_bPopWhenExit;
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgOption::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData();
	g_bPopWhenExit = m_bPopWhenExit;

	char szBuffer[10];
	CComboBox * pCB = (CComboBox *) GetDlgItem(IDC_COMBO_DEFAULT_DRIVE);
	int iSel = pCB->GetCurSel();
	if (iSel != CB_ERR)
	{
		pCB->GetLBText(iSel, szBuffer);
		g_chDefaultDrive = *szBuffer;
	}

	WriteOption();
	
	CDialog::OnOK();
}
