// HyperLink.cpp : implementation file
//
// HyperLink static control. Will open the default browser with the given URL
// when the user clicks on the link.
//
// Copyright (C) 1997, 1998 Chris Maunder (chrismaunder@codeguru.com)
// All rights reserved. May not be sold for profit.
//
// Thanks to Pl K. Tnder for auto-size and window caption changes.
//
// "GotoURL" function by Stuart Patterson
// As seen in the August, 1997 Windows Developer's Journal.
// Copyright 1997 by Miller Freeman, Inc. All rights reserved.
// Modified by Chris Maunder to use TCHARs instead of chars.
//
// "Default hand cursor" from Paul DiLascia's Jan 1998 MSJ article.
//

#include "stdafx.h"
#include "AboutIcon.h"
#include "resource.h"       // main symbols
#include "aboutbox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define TOOLTIP_ID 1

/////////////////////////////////////////////////////////////////////////////
// CAboutIcon

CAboutIcon::CAboutIcon()
{
    m_hLinkCursor       = NULL;                 // No cursor as yet
    m_bOverControl      = FALSE;                // Cursor not yet over control
}

CAboutIcon::~CAboutIcon()
{
}

BEGIN_MESSAGE_MAP(CAboutIcon, CStatic)
    //{{AFX_MSG_MAP(CAboutIcon)
    ON_CONTROL_REFLECT(STN_CLICKED, OnClicked)
    ON_WM_SETCURSOR()
    ON_WM_MOUSEMOVE()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAboutIcon message handlers

BOOL CAboutIcon::PreTranslateMessage(MSG* pMsg) 
{
    m_ToolTip.RelayEvent(pMsg);
    return CStatic::PreTranslateMessage(pMsg);
}

void CAboutIcon::OnClicked()
{
	m_bOverControl = FALSE;
	ReleaseCapture();
	RedrawWindow();

	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

void CAboutIcon::OnMouseMove(UINT nFlags, CPoint point) 
{
    CStatic::OnMouseMove(nFlags, point);

    if (m_bOverControl)        // Cursor is currently over control
    {
        CRect rect;
        GetClientRect(rect);

        if (!rect.PtInRect(point))
        {
            m_bOverControl = FALSE;
            ReleaseCapture();
            RedrawWindow();
            return;
        }
    }
    else                      // Cursor has just moved over control
    {
        m_bOverControl = TRUE;
        RedrawWindow();
        SetCapture();
    }
}

BOOL CAboutIcon::OnSetCursor(CWnd* /*pWnd*/, UINT /*nHitTest*/, UINT /*message*/) 
{
    if (m_hLinkCursor)
    {
        ::SetCursor(m_hLinkCursor);
        return TRUE;
    }
    return FALSE;
}

void CAboutIcon::PreSubclassWindow() 
{
    // We want to get mouse clicks via STN_CLICKED
    DWORD dwStyle = GetStyle();
    ::SetWindowLong(GetSafeHwnd(), GWL_STYLE, dwStyle | SS_NOTIFY);
    
    SetDefaultCursor();      // Try and load up a "hand" cursor

	char szTip[128];
	lstrcpy(szTip, "About ");
	AfxGetApp()->m_pMainWnd->GetWindowText(szTip+lstrlen(szTip), 80);

    // Create the tooltip
    CRect rect; 
    GetClientRect(rect);
    m_ToolTip.Create(this);
    m_ToolTip.AddTool(this, szTip, rect, TOOLTIP_ID);

    CStatic::PreSubclassWindow();
}

/////////////////////////////////////////////////////////////////////////////
// CAboutIcon implementation

void CAboutIcon::SetDefaultCursor()
{
    if (m_hLinkCursor == NULL)                // No cursor handle - load our own
		m_hLinkCursor = AfxGetApp()->LoadCursor(IDC_CURSOR_HAND);
}
