//  MPSuperPopoverControllerDefines.h
//
//
//  Created by Kirill Kovalenko on 11.05.16.
//  Copyright © 2016 Macphun. All rights reserved.
//


typedef NS_ENUM(NSUInteger, MPSuperPopoverArrowDirectionType) {
    MPSuperPopoverArrowDirectionTypeUndefined,
    MPSuperPopoverArrowDirectionTypeLeft,
    MPSuperPopoverArrowDirectionTypeRight,
    MPSuperPopoverArrowDirectionTypeUp,
    MPSuperPopoverArrowDirectionTypeDown,
    MPSuperPopoverArrowDirectionTypeCenter,
    MPSuperPopoverArrowDirectionTypeCenterSelected,
    MPSuperPopoverArrowDirectionTypeCount
};

typedef NS_ENUM(NSUInteger, MPSuperPopoverSenderPosition) {
    MPSuperPopoverSenderPositionBottomCenter,
    MPSuperPopoverSenderPositionBottomLeft,
    MPSuperPopoverSenderPositionBottomRight,
    MPSuperPopoverSenderPositionTopCenter,
    MPSuperPopoverSenderPositionTopLeft,
    MPSuperPopoverSenderPositionTopRight
};


typedef NS_OPTIONS(NSUInteger, MPSuperPopoverArrowDirection) {
    MPSuperPopoverArrowDirectionNone = 0,
    MPSuperPopoverArrowDirectionUndefined = (1UL << MPSuperPopoverArrowDirectionTypeUndefined),
    MPSuperPopoverArrowDirectionLeft = (1UL << MPSuperPopoverArrowDirectionTypeLeft),
    MPSuperPopoverArrowDirectionRight = (1UL << MPSuperPopoverArrowDirectionTypeRight),
    MPSuperPopoverArrowDirectionUp = (1UL << MPSuperPopoverArrowDirectionTypeUp),
    MPSuperPopoverArrowDirectionDown = (1UL << MPSuperPopoverArrowDirectionTypeDown),
    MPSuperPopoverArrowDirectionCenter = (1UL << MPSuperPopoverArrowDirectionTypeCenter),
    MPSuperPopoverArrowDirectionCenterSelected = (1UL << MPSuperPopoverArrowDirectionTypeCenterSelected),
};

typedef NS_ENUM(NSInteger, MPSuperPopoverAnimationType) {
	MPSuperPopoverAnimationTypePop = 0,	// Pop animation similar to NSPopover
	MPSuperPopoverAnimationTypeFadeIn,	// Fade in only, no fade out
	MPSuperPopoverAnimationTypeFadeOut,	// Fade out only, no fade in
	MPSuperPopoverAnimationTypeFadeInOut // Fade in and out
};

struct Padding {
    float left;
    float right;
};

typedef struct Padding Padding;

struct ShadowSettings {
    CGSize shadowOffset;
    CGFloat shadowRadius;
    
    CGFloat shadowAlpha;
};

typedef struct ShadowSettings ShadowSettings;
