//
//  MPSubscription.h
//  MPServices
//
//  Created by vladislav.senyukov on 5/4/17.
//  Copyright © 2017 MacPhun. All rights reserved.
//

#import "MPObject.h"
#import "MPSubscriptionPlan.h"
#import "MPSubscriptionConsts.h"

@interface MPSubscription : MPObject
// deserializable
@property (nonatomic, readonly) MPSubscriptionStatus status;
@property (nonatomic, readonly) NSUInteger daysLeft;
@property (nonatomic, assign) NSInteger photosLeft;
@property (nonatomic, readonly) BOOL activationAllowed;
@property (nonatomic, readonly) NSDate *lastEventDate;
@property (nonatomic, strong) NSDate *startPeriodDate;
@property (nonatomic, strong) NSDate *subscriptionBillDate;
@property (nonatomic, readonly) NSDate *offlineDate;
@property (nonatomic, readonly) MPSubscriptionPlan *plan;
// accessors
@property (nonatomic, readonly) BOOL isActive;
@property (nonatomic, readonly) BOOL isSubscriptionOver;
@property (nonatomic, readonly) NSUInteger trialDaysLeft;
@property (nonatomic, readonly) BOOL areTrialAndSubscriptionOver;
@end
