//
//  MPSession.h
//  MPServices
//
//  Created by vladislav.senyukov on 5/4/17.
//  Copyright © 2017 MacPhun. All rights reserved.
//

#import "MPObject.h"
#import "MPUser.h"
#import "MPSubscription.h"
#import "MPSubscriptionConsts.h"

@class MPSession;
@protocol MPSessionDelegate <NSObject>
@optional
- (void)sessionDidUpdate:(MPSession*)session;
- (BOOL)sessionShouldResetPhotosExportTimer:(MPSession*)session;
- (void)sessionDidResetPhotosExportTimer:(MPSession*)session;
@end

@interface MPSession : MPObject
- (instancetype)initWithJSONDic:(NSDictionary *)jsonDic delegate:(NSObject<MPSessionDelegate> *)delegate debugInfo:(NSDictionary*)debugInfo;
@property (nonatomic, weak) NSObject<MPSessionDelegate> *delegate;
@property (nonatomic, readonly) NSString *authToken;
@property (nonatomic, readonly) MPUser *user;
@property (nonatomic, readonly) MPSubscription *subscription;
@property (nonatomic, readonly) NSDate *date;

@property (nonatomic, readonly) BOOL useDatesAreValid;
@property (nonatomic, readonly) BOOL checkDatesAreValid;
@property (nonatomic, readonly) BOOL errorStatus;

- (NSDate*)nextPhotosCounterResetDateFromDate:(NSDate*)date;
- (void)reset;

@end
