//
//  MPCollectionView.h
//  Phoenix
//
//  Created by Oleksii Dykan on 5/22/15.
//  Copyright (c) 2015 MacPhun LLC. All rights reserved.
//

#import "MPSView.h"

@class MPSCollectionView, MPSCollectionViewCell;

typedef MPSCollectionViewCell *(^MPCellCreationBlock)(void);

@protocol MPSCollectionViewDataSource <NSObject>

- (NSInteger)numberOfCellsInCollectionView:(MPSCollectionView *)collectionView;
- (MPSCollectionViewCell *)collectionView:(MPSCollectionView *)collectionView cellForItemAtIndex:(NSInteger)cellIndex;
- (NSSize)sizeForCellInCollectionView:(MPSCollectionView *)collectionView;

@optional

/// Note!!!Horizontal insets are minimum insets. Actual horizontal insets will be calculated based on clip view width
- (NSEdgeInsets)insetsForCollectionView:(MPSCollectionView *)collectionView;
- (NSSize)spacingBetweenCells:(MPSCollectionView *)collectionView;

@end

@protocol MPSCollectionViewDelegate <NSObject>

@optional

- (BOOL)collectionView:(MPSCollectionView *)collectionView shouldSelectItemAtIndex:(NSInteger)itemIndex;
- (void)collectionView:(MPSCollectionView *)collectionView didSelectItemAtIndex:(NSInteger)itemIndex;
- (BOOL)collectionView:(MPSCollectionView *)collectionView shouldDeselectItemAtIndex:(NSInteger)itemIndex;
- (void)collectionView:(MPSCollectionView *)collectionView didDeselectItemAtIndex:(NSInteger)itemIndex;

- (void)collectionView:(MPSCollectionView *)collectionView willDisplayCell:(MPSCollectionViewCell *)cell forItemAtIndex:(NSInteger)cellIndex;
- (void)collectionView:(MPSCollectionView *)collectionView didEndDisplayCell:(MPSCollectionViewCell *)cell forItemAtIndex:(NSInteger)cellIndex;

@end

@interface MPSCollectionView : MPSView

@property (nonatomic, copy) MPCellCreationBlock cellCreationBlock;
@property (nonatomic, weak) IBOutlet id<MPSCollectionViewDataSource> dataSource;
@property (nonatomic, weak) IBOutlet id<MPSCollectionViewDelegate> delegate;
@property (nonatomic, assign) IBInspectable BOOL allowsSelection;
@property (nonatomic, assign) IBInspectable BOOL allowsMultipleSelection;
@property (nonatomic, assign) IBInspectable BOOL allowsMouseDragSelection;
@property (readonly, nonatomic, strong) NSIndexSet *indexesForVisibleCells;
@property (readonly, nonatomic, strong) NSIndexSet *indexesForSelectedCells;

- (void)reloadData;
- (void)reloadCellAtIndex:(NSInteger)cellIndex;
- (MPSCollectionViewCell *)dequeueReusableCellAtIndex:(NSInteger)cellIndex;

- (void)scrollToCellAtIndex:(NSInteger)cellIndex;
- (void)deselectCellAtIndex:(NSInteger)cellIndex;
- (void)selectCellAtIndex:(NSInteger)cellIndex;
- (void)selectAllCells;

@end
