//
//  MPProgressInfoIndicator.h
//  Aurora HDR
//
//  Created by Macphun on 8/22/16.
//  Copyright © 2016 MacPhun LLC. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSUInteger, MPProgressPosition) {
    kMPProgressPositionTopLeft,
    kMPProgressPositionTopCenter,
    kMPProgressPositionTopRight,
    kMPProgressPositionCenterLeft,
    kMPProgressPositionCenter,
    kMPProgressPositionCenterRight,
    kMPProgressPositionBottomLeft,
    kMPProgressPositionBottomCenter,
    kMPProgressPositionBottomRight,
};

@interface MPProgressInfoIndicator : NSObject

+ (void)registrerDefaultView:(NSView *)aView;
+ (void)unregisterDefaultView;
+ (NSView *)defaultView;

+ (void)showProgressForView:(NSView *)aView title:(NSString *)title;
+ (void)showProgressForView:(NSView *)aView position:(MPProgressPosition)position title:(NSString *)title;

+ (void)showProgressForView:(NSView *)aView title:(NSString *)title animated:(BOOL)animated;
+ (void)showProgressForView:(NSView *)aView position:(MPProgressPosition)position title:(NSString *)title animated:(BOOL)animated;

+ (void)showProgressForView:(NSView *)aView
                   position:(MPProgressPosition)position
                     offset:(NSPoint)offset
                      title:(NSString *)title;

+ (void)showProgressForView:(NSView *)aView
                   position:(MPProgressPosition)position
                     offset:(NSPoint)offset
                      title:(NSString *)title
                   animated:(BOOL)animated;

+ (void)setTitle:(NSString *)title forView:(NSView *)aView;

+ (void)hideProgress;
+ (void)hideProgressAnimated:(BOOL)animated;

+ (BOOL)isProgressShown;

@end
