//
//  MPPopoverViewController.h
//  MPServices
//
//  Created by Andrey Shekhovtsov on 12/01/2015.
//  Copyright (c) 2015 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef NS_ENUM(NSUInteger, MPPopoverViewPosition) {
    MPPopoverViewPositionLeft,
    MPPopoverViewPositionRight,
    MPPopoverViewPositionTop,
    MPPopoverViewPositionBottom,
    MPPopoverViewPositionCenter
};

FOUNDATION_EXPORT NSString *const MPPopoverViewDidShowNotification;
FOUNDATION_EXPORT NSString *const MPPopoverViewDidHideNotification;

typedef void(^MPPopoverViewCloseHandler) ();

@interface MPPopoverViewController :  NSViewController

@property (readonly, nonatomic, assign) BOOL popoverIsPresented;
@property (readonly, nonatomic, assign) NSPoint offsetFromView;

@property (nonatomic, assign) BOOL needsAnimations;
@property (nonatomic, assign) MPPopoverViewPosition popoverPosition;
@property (nonatomic, assign) NSEventMask eventsToSkip;

@property (nonatomic, assign) CGFloat offset;
@property (nonatomic, assign) CGFloat positionShiftX;

@property (nonatomic, assign) CGFloat positionShiftY;

/*!
 * @brief if YES resets positionShiftY to zero when window content view height is less than popover height
 */
@property (assign, nonatomic) BOOL resetShiftYOnCompression;

@property (nonatomic, assign) NSPoint shadowOffset;

@property (nonatomic, assign) BOOL ignoreWindowBounds;

@property (nonatomic, strong) NSArray *observedKeysForClosing;
@property (nonatomic, copy) MPPopoverViewCloseHandler closeHandler;

- (NSWindow *)window;

- (void)showFromRect:(NSRect)fromRect inWindow:(NSWindow *)window;
- (void)showFromView:(NSView *)view;
- (IBAction)dismiss:(id)sender;
- (void)dismissAnimated:(BOOL)animated;
- (void)didUpdateOffsetFromView;

- (void)mouseDidMove:(NSEvent *)event;

@end
